/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.MP3;
import jake2.qcommon.xcommand_t;
import jake2.util.Lib;
import java.io.File;

public final class CDAudio {
    public static boolean cdValid = false;
    public static boolean playing = false;
    public static boolean wasPlaying = false;
    public static boolean initialized = false;
    public static boolean enabled = true;
    public static boolean playLooping = false;
    public static float cdvolume = 0.0f;
    public static byte playTrack;
    public static byte maxTrack;
    static MP3 mp3;
    static int cdfile;
    static cvar_t cd_volume;
    static cvar_t cd_nocd;
    static cvar_t cddir;
    static xcommand_t CD_f;

    public static void Play(int track, boolean looping) {
        if (cdfile == -1 || !enabled) {
            return;
        }
        if (!cdValid) {
            CDAudio.GetAudioDiskInfo();
            if (!cdValid) {
                return;
            }
        }
        if (track < 1 || track > maxTrack) {
            Com.Printf("CD Audio (MP3s) Bad track number " + track + ".\n");
            return;
        }
        if (playing) {
            if (playTrack == track) {
                return;
            }
            CDAudio.Stop();
        }
        String mp3filename = CDAudio.cddir.string + "\\soundtrack\\" + track + ".mp3";
        mp3 = new MP3(mp3filename, looping);
        mp3.play();
        if (mp3.isError()) {
            return;
        }
        playLooping = looping;
        playTrack = (byte)track;
        playing = true;
        if (CDAudio.cd_volume.value == 0.0f) {
            CDAudio.Stop();
        }
        if (looping) {
            Com.DPrintf("CD Audio (MP3s) Looping track " + track + "\n");
        } else {
            Com.DPrintf("CD Audio (MP3s) Playing track " + track + "\n");
        }
    }

    public static void Stop() {
        if (cdfile == -1 || !enabled || !playing) {
            return;
        }
        mp3.stop();
        wasPlaying = false;
        playing = false;
        Com.DPrintf("CD Audio (MP3s) Stopping track\n");
    }

    public static void Eject() {
        if (cdfile == -1 || !enabled) {
            return;
        }
        Com.DPrintf("CD Audio (MP3s) Ejected\n");
    }

    public static void CloseDoor() {
        if (cdfile == -1 || !enabled) {
            return;
        }
        Com.DPrintf("CD Audio (MP3s) CloseDoor\n");
    }

    public static int GetAudioDiskInfo() {
        cdValid = false;
        maxTrack = 0;
        int numFiles = 0;
        String folder = CDAudio.cddir.string + "/soundtrack";
        File f = new File(folder);
        if (f.exists() && f.isDirectory()) {
            Com.DPrintf("CD Audio we found the sountrack folder\n");
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean isText = CDAudio.checkMP3(children[i]);
                if (!isText) continue;
                ++numFiles;
            }
            maxTrack = (byte)numFiles;
            Com.DPrintf("CD Audio we found " + maxTrack + " MP3s in the folder\n");
            if (maxTrack < 1) {
                return -1;
            }
            cdValid = true;
            return 0;
        }
        return -1;
    }

    static boolean checkMP3(File f) {
        String name = f.getName();
        return name.contains(".mp3");
    }

    public static void Pause() {
        if (cdfile == -1 || !enabled || !playing) {
            return;
        }
        mp3.pause();
        if (!mp3.isError()) {
            wasPlaying = playing;
            playing = false;
            Com.DPrintf("CD Audio (MP3s) Paused \n");
        }
    }

    public static void Resume() {
        if (!(cdfile != -1 && enabled && cdValid && wasPlaying)) {
            return;
        }
        mp3.resume();
        if (!mp3.isError()) {
            wasPlaying = playing;
            playing = true;
            Com.DPrintf("CD Audio (MP3s) Resumed\n");
        }
    }

    public static void Update() {
    }

    public static int Init() {
        cd_nocd = Cvar.Get("cd_nocd", "0", 1);
        if ((int)CDAudio.cd_nocd.value != 0) {
            return -1;
        }
        cddir = Cvar.Get("cddir", "C:\\Quake2\\baseq2", 1);
        cd_volume = Cvar.Get("cd_volume", "1", 1);
        cdvolume = CDAudio.cd_volume.value;
        if (CDAudio.GetAudioDiskInfo() == -1) {
            Com.Printf("CD Audio No CD (MP3s) in player\n");
            cdfile = -1;
            initialized = false;
            enabled = false;
            return -1;
        }
        Cmd.AddCommand("cd", CD_f);
        cdfile = 0;
        initialized = true;
        enabled = true;
        Com.Printf("CD Audio (MP3s) Initialized\n");
        return 0;
    }

    public static void Shutdown() {
        if (!initialized) {
            return;
        }
        CDAudio.Stop();
        cdfile = -1;
        Com.Printf("CD Audio (MP3s) Shutdown\n");
    }

    static {
        cdfile = -1;
        CD_f = new xcommand_t(){

            public void execute() {
                if (Cmd.Argc() < 2) {
                    return;
                }
                String command = Cmd.Argv(1);
                if (command.equalsIgnoreCase("on")) {
                    enabled = true;
                    return;
                }
                if (command.equalsIgnoreCase("off")) {
                    if (playing) {
                        CDAudio.Stop();
                    }
                    enabled = false;
                    return;
                }
                if (command.equalsIgnoreCase("reset")) {
                    enabled = true;
                    if (playing) {
                        CDAudio.Stop();
                    }
                    CDAudio.GetAudioDiskInfo();
                    return;
                }
                if (command.equalsIgnoreCase("remap")) {
                    return;
                }
                if (command.equalsIgnoreCase("close")) {
                    CDAudio.CloseDoor();
                    return;
                }
                if (!cdValid) {
                    CDAudio.GetAudioDiskInfo();
                    if (!cdValid) {
                        Com.Printf("Audio CD (MP3s) No CD in player.\n");
                        return;
                    }
                }
                if (command.equalsIgnoreCase("play")) {
                    CDAudio.Play(Lib.atoi(Cmd.Argv(2)), false);
                    return;
                }
                if (command.equalsIgnoreCase("loop")) {
                    CDAudio.Play(Lib.atoi(Cmd.Argv(2)), true);
                    return;
                }
                if (command.equalsIgnoreCase("stop")) {
                    CDAudio.Stop();
                    return;
                }
                if (command.equalsIgnoreCase("pause")) {
                    CDAudio.Pause();
                    return;
                }
                if (command.equalsIgnoreCase("resume")) {
                    CDAudio.Resume();
                    return;
                }
                if (command.equalsIgnoreCase("eject")) {
                    if (playing) {
                        CDAudio.Stop();
                    }
                    CDAudio.Eject();
                    cdValid = false;
                    return;
                }
                if (command.equalsIgnoreCase("info")) {
                    Com.Printf(maxTrack + " tracks (MP3s) on the cd\n");
                    if (playing) {
                        if (playLooping) {
                            Com.Printf("Currently looping track " + playTrack + "\n");
                        } else {
                            Com.Printf("Currently playing track " + playTrack + "\n");
                        }
                    } else if (wasPlaying) {
                        if (playLooping) {
                            Com.Printf("Paused looping track " + playTrack + "\n");
                        } else {
                            Com.Printf("Paused playing track " + playTrack + "\n");
                        }
                    }
                    Com.Printf("Volume is " + cdvolume + "\n");
                    return;
                }
            }
        };
    }
}

