/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.pmove_state_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.io.IOException;
import java.io.RandomAccessFile;

public class player_state_t {
    public pmove_state_t pmove = new pmove_state_t();
    public float[] viewangles = new float[]{0.0f, 0.0f, 0.0f};
    public float[] viewoffset = new float[]{0.0f, 0.0f, 0.0f};
    public float[] kick_angles = new float[]{0.0f, 0.0f, 0.0f};
    public float[] gunangles = new float[]{0.0f, 0.0f, 0.0f};
    public float[] gunoffset = new float[]{0.0f, 0.0f, 0.0f};
    public int gunindex;
    public int gunframe;
    public float[] blend = new float[4];
    public float fov;
    public int rdflags;
    public short[] stats = new short[32];
    private static player_state_t prototype = new player_state_t();

    public void clear() {
        this.set(prototype);
    }

    public player_state_t getClone() {
        return new player_state_t().set(this);
    }

    public player_state_t set(player_state_t from) {
        this.pmove.set(from.pmove);
        Math3D.VectorCopy(from.viewangles, this.viewangles);
        Math3D.VectorCopy(from.viewoffset, this.viewoffset);
        Math3D.VectorCopy(from.kick_angles, this.kick_angles);
        Math3D.VectorCopy(from.gunangles, this.gunangles);
        Math3D.VectorCopy(from.gunoffset, this.gunoffset);
        this.gunindex = from.gunindex;
        this.gunframe = from.gunframe;
        this.blend[0] = from.blend[0];
        this.blend[1] = from.blend[1];
        this.blend[2] = from.blend[2];
        this.blend[3] = from.blend[3];
        this.fov = from.fov;
        this.rdflags = from.rdflags;
        System.arraycopy(from.stats, 0, this.stats, 0, 32);
        return this;
    }

    public void load(RandomAccessFile f) throws IOException {
        this.pmove.load(f);
        this.viewangles[0] = f.readFloat();
        this.viewangles[1] = f.readFloat();
        this.viewangles[2] = f.readFloat();
        this.viewoffset[0] = f.readFloat();
        this.viewoffset[1] = f.readFloat();
        this.viewoffset[2] = f.readFloat();
        this.kick_angles[0] = f.readFloat();
        this.kick_angles[1] = f.readFloat();
        this.kick_angles[2] = f.readFloat();
        this.gunangles[0] = f.readFloat();
        this.gunangles[1] = f.readFloat();
        this.gunangles[2] = f.readFloat();
        this.gunoffset[0] = f.readFloat();
        this.gunoffset[1] = f.readFloat();
        this.gunoffset[2] = f.readFloat();
        this.gunindex = f.readInt();
        this.gunframe = f.readInt();
        this.blend[0] = f.readFloat();
        this.blend[1] = f.readFloat();
        this.blend[2] = f.readFloat();
        this.blend[3] = f.readFloat();
        this.fov = f.readFloat();
        this.rdflags = f.readInt();
        for (int n = 0; n < 32; ++n) {
            this.stats[n] = f.readShort();
        }
    }

    public void write(RandomAccessFile f) throws IOException {
        this.pmove.write(f);
        f.writeFloat(this.viewangles[0]);
        f.writeFloat(this.viewangles[1]);
        f.writeFloat(this.viewangles[2]);
        f.writeFloat(this.viewoffset[0]);
        f.writeFloat(this.viewoffset[1]);
        f.writeFloat(this.viewoffset[2]);
        f.writeFloat(this.kick_angles[0]);
        f.writeFloat(this.kick_angles[1]);
        f.writeFloat(this.kick_angles[2]);
        f.writeFloat(this.gunangles[0]);
        f.writeFloat(this.gunangles[1]);
        f.writeFloat(this.gunangles[2]);
        f.writeFloat(this.gunoffset[0]);
        f.writeFloat(this.gunoffset[1]);
        f.writeFloat(this.gunoffset[2]);
        f.writeInt(this.gunindex);
        f.writeInt(this.gunframe);
        f.writeFloat(this.blend[0]);
        f.writeFloat(this.blend[1]);
        f.writeFloat(this.blend[2]);
        f.writeFloat(this.blend[3]);
        f.writeFloat(this.fov);
        f.writeInt(this.rdflags);
        for (int n = 0; n < 32; ++n) {
            f.writeShort(this.stats[n]);
        }
    }

    public void dump() {
        this.pmove.dump();
        Lib.printv("viewangles", this.viewangles);
        Lib.printv("viewoffset", this.viewoffset);
        Lib.printv("kick_angles", this.kick_angles);
        Lib.printv("gunangles", this.gunangles);
        Lib.printv("gunoffset", this.gunoffset);
        Com.Println("gunindex: " + this.gunindex);
        Com.Println("gunframe: " + this.gunframe);
        Lib.printv("blend", this.blend);
        Com.Println("fov: " + this.fov);
        Com.Println("rdflags: " + this.rdflags);
        for (int n = 0; n < 32; ++n) {
            System.out.println("stats[" + n + "]: " + this.stats[n]);
        }
    }
}

