/*
 * Decompiled with CFR 0.152.
 */
package jake2.game.monsters;

import jake2.game.EntDieAdapter;
import jake2.game.EntInteractAdapter;
import jake2.game.EntPainAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.GameAI;
import jake2.game.GameBase;
import jake2.game.GameMisc;
import jake2.game.GameUtil;
import jake2.game.GameWeapon;
import jake2.game.Monster;
import jake2.game.edict_t;
import jake2.game.mframe_t;
import jake2.game.mmove_t;
import jake2.game.monsters.M_Flash;
import jake2.util.Lib;
import jake2.util.Math3D;

public class M_Gladiator {
    public static final int FRAME_stand1 = 0;
    public static final int FRAME_stand2 = 1;
    public static final int FRAME_stand3 = 2;
    public static final int FRAME_stand4 = 3;
    public static final int FRAME_stand5 = 4;
    public static final int FRAME_stand6 = 5;
    public static final int FRAME_stand7 = 6;
    public static final int FRAME_walk1 = 7;
    public static final int FRAME_walk2 = 8;
    public static final int FRAME_walk3 = 9;
    public static final int FRAME_walk4 = 10;
    public static final int FRAME_walk5 = 11;
    public static final int FRAME_walk6 = 12;
    public static final int FRAME_walk7 = 13;
    public static final int FRAME_walk8 = 14;
    public static final int FRAME_walk9 = 15;
    public static final int FRAME_walk10 = 16;
    public static final int FRAME_walk11 = 17;
    public static final int FRAME_walk12 = 18;
    public static final int FRAME_walk13 = 19;
    public static final int FRAME_walk14 = 20;
    public static final int FRAME_walk15 = 21;
    public static final int FRAME_walk16 = 22;
    public static final int FRAME_run1 = 23;
    public static final int FRAME_run2 = 24;
    public static final int FRAME_run3 = 25;
    public static final int FRAME_run4 = 26;
    public static final int FRAME_run5 = 27;
    public static final int FRAME_run6 = 28;
    public static final int FRAME_melee1 = 29;
    public static final int FRAME_melee2 = 30;
    public static final int FRAME_melee3 = 31;
    public static final int FRAME_melee4 = 32;
    public static final int FRAME_melee5 = 33;
    public static final int FRAME_melee6 = 34;
    public static final int FRAME_melee7 = 35;
    public static final int FRAME_melee8 = 36;
    public static final int FRAME_melee9 = 37;
    public static final int FRAME_melee10 = 38;
    public static final int FRAME_melee11 = 39;
    public static final int FRAME_melee12 = 40;
    public static final int FRAME_melee13 = 41;
    public static final int FRAME_melee14 = 42;
    public static final int FRAME_melee15 = 43;
    public static final int FRAME_melee16 = 44;
    public static final int FRAME_melee17 = 45;
    public static final int FRAME_attack1 = 46;
    public static final int FRAME_attack2 = 47;
    public static final int FRAME_attack3 = 48;
    public static final int FRAME_attack4 = 49;
    public static final int FRAME_attack5 = 50;
    public static final int FRAME_attack6 = 51;
    public static final int FRAME_attack7 = 52;
    public static final int FRAME_attack8 = 53;
    public static final int FRAME_attack9 = 54;
    public static final int FRAME_pain1 = 55;
    public static final int FRAME_pain2 = 56;
    public static final int FRAME_pain3 = 57;
    public static final int FRAME_pain4 = 58;
    public static final int FRAME_pain5 = 59;
    public static final int FRAME_pain6 = 60;
    public static final int FRAME_death1 = 61;
    public static final int FRAME_death2 = 62;
    public static final int FRAME_death3 = 63;
    public static final int FRAME_death4 = 64;
    public static final int FRAME_death5 = 65;
    public static final int FRAME_death6 = 66;
    public static final int FRAME_death7 = 67;
    public static final int FRAME_death8 = 68;
    public static final int FRAME_death9 = 69;
    public static final int FRAME_death10 = 70;
    public static final int FRAME_death11 = 71;
    public static final int FRAME_death12 = 72;
    public static final int FRAME_death13 = 73;
    public static final int FRAME_death14 = 74;
    public static final int FRAME_death15 = 75;
    public static final int FRAME_death16 = 76;
    public static final int FRAME_death17 = 77;
    public static final int FRAME_death18 = 78;
    public static final int FRAME_death19 = 79;
    public static final int FRAME_death20 = 80;
    public static final int FRAME_death21 = 81;
    public static final int FRAME_death22 = 82;
    public static final int FRAME_painup1 = 83;
    public static final int FRAME_painup2 = 84;
    public static final int FRAME_painup3 = 85;
    public static final int FRAME_painup4 = 86;
    public static final int FRAME_painup5 = 87;
    public static final int FRAME_painup6 = 88;
    public static final int FRAME_painup7 = 89;
    public static final float MODEL_SCALE = 1.0f;
    static int sound_pain1;
    static int sound_pain2;
    static int sound_die;
    static int sound_gun;
    static int sound_cleaver_swing;
    static int sound_cleaver_hit;
    static int sound_cleaver_miss;
    static int sound_idle;
    static int sound_search;
    static int sound_sight;
    static EntThinkAdapter gladiator_idle;
    static EntInteractAdapter gladiator_sight;
    static EntThinkAdapter gladiator_search;
    static EntThinkAdapter gladiator_cleaver_swing;
    static mframe_t[] gladiator_frames_stand;
    static mmove_t gladiator_move_stand;
    static EntThinkAdapter gladiator_stand;
    static mframe_t[] gladiator_frames_walk;
    static mmove_t gladiator_move_walk;
    static EntThinkAdapter gladiator_walk;
    static mframe_t[] gladiator_frames_run;
    static mmove_t gladiator_move_run;
    static EntThinkAdapter gladiator_run;
    static EntThinkAdapter GaldiatorMelee;
    static mframe_t[] gladiator_frames_attack_melee;
    static mmove_t gladiator_move_attack_melee;
    static EntThinkAdapter gladiator_melee;
    static EntThinkAdapter GladiatorGun;
    static mframe_t[] gladiator_frames_attack_gun;
    static mmove_t gladiator_move_attack_gun;
    static EntThinkAdapter gladiator_attack;
    static mframe_t[] gladiator_frames_pain;
    static mmove_t gladiator_move_pain;
    static mframe_t[] gladiator_frames_pain_air;
    static mmove_t gladiator_move_pain_air;
    static EntPainAdapter gladiator_pain;
    static EntThinkAdapter gladiator_dead;
    static mframe_t[] gladiator_frames_death;
    static mmove_t gladiator_move_death;
    static EntDieAdapter gladiator_die;

    public static void SP_monster_gladiator(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        sound_pain1 = GameBase.gi.soundindex("gladiator/pain.wav");
        sound_pain2 = GameBase.gi.soundindex("gladiator/gldpain2.wav");
        sound_die = GameBase.gi.soundindex("gladiator/glddeth2.wav");
        sound_gun = GameBase.gi.soundindex("gladiator/railgun.wav");
        sound_cleaver_swing = GameBase.gi.soundindex("gladiator/melee1.wav");
        sound_cleaver_hit = GameBase.gi.soundindex("gladiator/melee2.wav");
        sound_cleaver_miss = GameBase.gi.soundindex("gladiator/melee3.wav");
        sound_idle = GameBase.gi.soundindex("gladiator/gldidle1.wav");
        sound_search = GameBase.gi.soundindex("gladiator/gldsrch1.wav");
        sound_sight = GameBase.gi.soundindex("gladiator/sight.wav");
        self.movetype = 5;
        self.solid = 2;
        self.s.modelindex = GameBase.gi.modelindex("models/monsters/gladiatr/tris.md2");
        Math3D.VectorSet(self.mins, -32.0f, -32.0f, -24.0f);
        Math3D.VectorSet(self.maxs, 32.0f, 32.0f, 64.0f);
        self.health = 400;
        self.gib_health = -175;
        self.mass = 400;
        self.pain = gladiator_pain;
        self.die = gladiator_die;
        self.monsterinfo.stand = gladiator_stand;
        self.monsterinfo.walk = gladiator_walk;
        self.monsterinfo.run = gladiator_run;
        self.monsterinfo.dodge = null;
        self.monsterinfo.attack = gladiator_attack;
        self.monsterinfo.melee = gladiator_melee;
        self.monsterinfo.sight = gladiator_sight;
        self.monsterinfo.idle = gladiator_idle;
        self.monsterinfo.search = gladiator_search;
        GameBase.gi.linkentity(self);
        self.monsterinfo.currentmove = gladiator_move_stand;
        self.monsterinfo.scale = 1.0f;
        GameAI.walkmonster_start.think(self);
    }

    static {
        gladiator_idle = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_idle";
            }

            public boolean think(edict_t self) {
                GameBase.gi.sound(self, 2, sound_idle, 1.0f, 2.0f, 0.0f);
                return true;
            }
        };
        gladiator_sight = new EntInteractAdapter(){

            public String getID() {
                return "gladiator_sight";
            }

            public boolean interact(edict_t self, edict_t other) {
                GameBase.gi.sound(self, 2, sound_sight, 1.0f, 1.0f, 0.0f);
                return true;
            }
        };
        gladiator_search = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_search";
            }

            public boolean think(edict_t self) {
                GameBase.gi.sound(self, 2, sound_search, 1.0f, 1.0f, 0.0f);
                return true;
            }
        };
        gladiator_cleaver_swing = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_cleaver_swing";
            }

            public boolean think(edict_t self) {
                GameBase.gi.sound(self, 1, sound_cleaver_swing, 1.0f, 1.0f, 0.0f);
                return true;
            }
        };
        gladiator_frames_stand = new mframe_t[]{new mframe_t(GameAI.ai_stand, 0.0f, null), new mframe_t(GameAI.ai_stand, 0.0f, null), new mframe_t(GameAI.ai_stand, 0.0f, null), new mframe_t(GameAI.ai_stand, 0.0f, null), new mframe_t(GameAI.ai_stand, 0.0f, null), new mframe_t(GameAI.ai_stand, 0.0f, null), new mframe_t(GameAI.ai_stand, 0.0f, null)};
        gladiator_move_stand = new mmove_t(0, 6, gladiator_frames_stand, null);
        gladiator_stand = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_stand";
            }

            public boolean think(edict_t self) {
                self.monsterinfo.currentmove = gladiator_move_stand;
                return true;
            }
        };
        gladiator_frames_walk = new mframe_t[]{new mframe_t(GameAI.ai_walk, 15.0f, null), new mframe_t(GameAI.ai_walk, 7.0f, null), new mframe_t(GameAI.ai_walk, 6.0f, null), new mframe_t(GameAI.ai_walk, 5.0f, null), new mframe_t(GameAI.ai_walk, 2.0f, null), new mframe_t(GameAI.ai_walk, 0.0f, null), new mframe_t(GameAI.ai_walk, 2.0f, null), new mframe_t(GameAI.ai_walk, 8.0f, null), new mframe_t(GameAI.ai_walk, 12.0f, null), new mframe_t(GameAI.ai_walk, 8.0f, null), new mframe_t(GameAI.ai_walk, 5.0f, null), new mframe_t(GameAI.ai_walk, 5.0f, null), new mframe_t(GameAI.ai_walk, 2.0f, null), new mframe_t(GameAI.ai_walk, 2.0f, null), new mframe_t(GameAI.ai_walk, 1.0f, null), new mframe_t(GameAI.ai_walk, 8.0f, null)};
        gladiator_move_walk = new mmove_t(7, 22, gladiator_frames_walk, null);
        gladiator_walk = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_walk";
            }

            public boolean think(edict_t self) {
                self.monsterinfo.currentmove = gladiator_move_walk;
                return true;
            }
        };
        gladiator_frames_run = new mframe_t[]{new mframe_t(GameAI.ai_run, 23.0f, null), new mframe_t(GameAI.ai_run, 14.0f, null), new mframe_t(GameAI.ai_run, 14.0f, null), new mframe_t(GameAI.ai_run, 21.0f, null), new mframe_t(GameAI.ai_run, 12.0f, null), new mframe_t(GameAI.ai_run, 13.0f, null)};
        gladiator_move_run = new mmove_t(23, 28, gladiator_frames_run, null);
        gladiator_run = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_run";
            }

            public boolean think(edict_t self) {
                self.monsterinfo.currentmove = (self.monsterinfo.aiflags & 1) != 0 ? gladiator_move_stand : gladiator_move_run;
                return true;
            }
        };
        GaldiatorMelee = new EntThinkAdapter(){

            public String getID() {
                return "GaldiatorMelee";
            }

            public boolean think(edict_t self) {
                float[] aim = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.VectorSet(aim, 80.0f, self.mins[0], -4.0f);
                if (GameWeapon.fire_hit(self, aim, 20 + Lib.rand() % 5, 300)) {
                    GameBase.gi.sound(self, 0, sound_cleaver_hit, 1.0f, 1.0f, 0.0f);
                } else {
                    GameBase.gi.sound(self, 0, sound_cleaver_miss, 1.0f, 1.0f, 0.0f);
                }
                return true;
            }
        };
        gladiator_frames_attack_melee = new mframe_t[]{new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, gladiator_cleaver_swing), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, GaldiatorMelee), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, gladiator_cleaver_swing), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, GaldiatorMelee), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null)};
        gladiator_move_attack_melee = new mmove_t(29, 45, gladiator_frames_attack_melee, gladiator_run);
        gladiator_melee = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_melee";
            }

            public boolean think(edict_t self) {
                self.monsterinfo.currentmove = gladiator_move_attack_melee;
                return true;
            }
        };
        GladiatorGun = new EntThinkAdapter(){

            public String getID() {
                return "GladiatorGun";
            }

            public boolean think(edict_t self) {
                float[] start = new float[]{0.0f, 0.0f, 0.0f};
                float[] dir = new float[]{0.0f, 0.0f, 0.0f};
                float[] forward = new float[]{0.0f, 0.0f, 0.0f};
                float[] right = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.AngleVectors(self.s.angles, forward, right, null);
                Math3D.G_ProjectSource(self.s.origin, M_Flash.monster_flash_offset[61], forward, right, start);
                Math3D.VectorSubtract(self.pos1, start, dir);
                Math3D.VectorNormalize(dir);
                Monster.monster_fire_railgun(self, start, dir, 50, 100, 61);
                return true;
            }
        };
        gladiator_frames_attack_gun = new mframe_t[]{new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, GladiatorGun), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null), new mframe_t(GameAI.ai_charge, 0.0f, null)};
        gladiator_move_attack_gun = new mmove_t(46, 54, gladiator_frames_attack_gun, gladiator_run);
        gladiator_attack = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_attack";
            }

            public boolean think(edict_t self) {
                float[] v = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.VectorSubtract(self.s.origin, self.enemy.s.origin, v);
                float range = Math3D.VectorLength(v);
                if (range <= 112.0f) {
                    return true;
                }
                GameBase.gi.sound(self, 1, sound_gun, 1.0f, 1.0f, 0.0f);
                Math3D.VectorCopy(self.enemy.s.origin, self.pos1);
                self.pos1[2] = self.pos1[2] + (float)self.enemy.viewheight;
                self.monsterinfo.currentmove = gladiator_move_attack_gun;
                return true;
            }
        };
        gladiator_frames_pain = new mframe_t[]{new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null)};
        gladiator_move_pain = new mmove_t(55, 60, gladiator_frames_pain, gladiator_run);
        gladiator_frames_pain_air = new mframe_t[]{new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null)};
        gladiator_move_pain_air = new mmove_t(83, 89, gladiator_frames_pain_air, gladiator_run);
        gladiator_pain = new EntPainAdapter(){

            public String getID() {
                return "gladiator_pain";
            }

            public void pain(edict_t self, edict_t other, float kick, int damage) {
                if (self.health < self.max_health / 2) {
                    self.s.skinnum = 1;
                }
                if (GameBase.level.time < self.pain_debounce_time) {
                    if (self.velocity[2] > 100.0f && self.monsterinfo.currentmove == gladiator_move_pain) {
                        self.monsterinfo.currentmove = gladiator_move_pain_air;
                    }
                    return;
                }
                self.pain_debounce_time = GameBase.level.time + 3.0f;
                if ((double)Lib.random() < 0.5) {
                    GameBase.gi.sound(self, 2, sound_pain1, 1.0f, 1.0f, 0.0f);
                } else {
                    GameBase.gi.sound(self, 2, sound_pain2, 1.0f, 1.0f, 0.0f);
                }
                if (GameBase.skill.value == 3.0f) {
                    return;
                }
                self.monsterinfo.currentmove = self.velocity[2] > 100.0f ? gladiator_move_pain_air : gladiator_move_pain;
            }
        };
        gladiator_dead = new EntThinkAdapter(){

            public String getID() {
                return "gladiator_dead";
            }

            public boolean think(edict_t self) {
                Math3D.VectorSet(self.mins, -16.0f, -16.0f, -24.0f);
                Math3D.VectorSet(self.maxs, 16.0f, 16.0f, -8.0f);
                self.movetype = 7;
                self.svflags |= 2;
                self.nextthink = 0.0f;
                GameBase.gi.linkentity(self);
                return true;
            }
        };
        gladiator_frames_death = new mframe_t[]{new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null), new mframe_t(GameAI.ai_move, 0.0f, null)};
        gladiator_move_death = new mmove_t(61, 82, gladiator_frames_death, gladiator_dead);
        gladiator_die = new EntDieAdapter(){

            public String getID() {
                return "gladiator_die";
            }

            public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
                if (self.health <= self.gib_health) {
                    int n;
                    GameBase.gi.sound(self, 2, GameBase.gi.soundindex("misc/udeath.wav"), 1.0f, 1.0f, 0.0f);
                    for (n = 0; n < 2; ++n) {
                        GameMisc.ThrowGib(self, "models/objects/gibs/bone/tris.md2", damage, 0);
                    }
                    for (n = 0; n < 4; ++n) {
                        GameMisc.ThrowGib(self, "models/objects/gibs/sm_meat/tris.md2", damage, 0);
                    }
                    GameMisc.ThrowHead(self, "models/objects/gibs/head2/tris.md2", damage, 0);
                    self.deadflag = 2;
                    return;
                }
                if (self.deadflag == 2) {
                    return;
                }
                GameBase.gi.sound(self, 2, sound_die, 1.0f, 1.0f, 0.0f);
                self.deadflag = 2;
                self.takedamage = 1;
                self.monsterinfo.currentmove = gladiator_move_death;
            }
        };
    }
}

