/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.edict_t;
import jake2.util.Math3D;
import jake2.util.QuakeFile;
import java.io.IOException;

public class entity_state_t
implements Cloneable {
    public int number = 0;
    public edict_t surrounding_ent = null;
    public float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    public float[] angles = new float[]{0.0f, 0.0f, 0.0f};
    public float[] old_origin = new float[]{0.0f, 0.0f, 0.0f};
    public int modelindex;
    public int modelindex2;
    public int modelindex3;
    public int modelindex4;
    public int frame;
    public int skinnum;
    public int effects;
    public int renderfx;
    public int solid;
    public int sound;
    public int event;

    public entity_state_t(edict_t ent) {
        this.surrounding_ent = ent;
        if (ent != null) {
            this.number = ent.index;
        }
    }

    public void write(QuakeFile f) throws IOException {
        f.writeEdictRef(this.surrounding_ent);
        f.writeVector(this.origin);
        f.writeVector(this.angles);
        f.writeVector(this.old_origin);
        f.writeInt(this.modelindex);
        f.writeInt(this.modelindex2);
        f.writeInt(this.modelindex3);
        f.writeInt(this.modelindex4);
        f.writeInt(this.frame);
        f.writeInt(this.skinnum);
        f.writeInt(this.effects);
        f.writeInt(this.renderfx);
        f.writeInt(this.solid);
        f.writeInt(this.sound);
        f.writeInt(this.event);
    }

    public void read(QuakeFile f) throws IOException {
        this.surrounding_ent = f.readEdictRef();
        this.origin = f.readVector();
        this.angles = f.readVector();
        this.old_origin = f.readVector();
        this.modelindex = f.readInt();
        this.modelindex2 = f.readInt();
        this.modelindex3 = f.readInt();
        this.modelindex4 = f.readInt();
        this.frame = f.readInt();
        this.skinnum = f.readInt();
        this.effects = f.readInt();
        this.renderfx = f.readInt();
        this.solid = f.readInt();
        this.sound = f.readInt();
        this.event = f.readInt();
    }

    public entity_state_t getClone() {
        entity_state_t out = new entity_state_t(this.surrounding_ent);
        out.set(this);
        return out;
    }

    public void set(entity_state_t from) {
        this.number = from.number;
        Math3D.VectorCopy(from.origin, this.origin);
        Math3D.VectorCopy(from.angles, this.angles);
        Math3D.VectorCopy(from.old_origin, this.old_origin);
        this.modelindex = from.modelindex;
        this.modelindex2 = from.modelindex2;
        this.modelindex3 = from.modelindex3;
        this.modelindex4 = from.modelindex4;
        this.frame = from.frame;
        this.skinnum = from.skinnum;
        this.effects = from.effects;
        this.renderfx = from.renderfx;
        this.solid = from.solid;
        this.sound = from.sound;
        this.event = from.event;
    }

    public void clear() {
        this.number = 0;
        this.surrounding_ent = null;
        Math3D.VectorClear(this.origin);
        Math3D.VectorClear(this.angles);
        Math3D.VectorClear(this.old_origin);
        this.modelindex = 0;
        this.modelindex4 = 0;
        this.modelindex3 = 0;
        this.modelindex2 = 0;
        this.frame = 0;
        this.skinnum = 0;
        this.effects = 0;
        this.renderfx = 0;
        this.solid = 0;
        this.sound = 0;
        this.event = 0;
    }
}

