/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EntInteractAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.GameBase;
import jake2.game.GameItems;
import jake2.game.GameUtil;
import jake2.game.GameWeapon;
import jake2.game.ItemDropAdapter;
import jake2.game.ItemUseAdapter;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.game.gitem_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class PlayerWeapon {
    public static EntThinkAdapter Weapon_Grenade = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Grenade";
        }

        public boolean think(edict_t ent) {
            if (ent.client.newweapon != null && ent.client.weaponstate == 0) {
                PlayerWeapon.ChangeWeapon(ent);
                return true;
            }
            if (ent.client.weaponstate == 1) {
                ent.client.weaponstate = 0;
                ent.client.ps.gunframe = 16;
                return true;
            }
            if (ent.client.weaponstate == 0) {
                if (((ent.client.latched_buttons | ent.client.buttons) & 1) != 0) {
                    ent.client.latched_buttons &= 0xFFFFFFFE;
                    if (0 != ent.client.pers.inventory[ent.client.ammo_index]) {
                        ent.client.ps.gunframe = 1;
                        ent.client.weaponstate = 3;
                        ent.client.grenade_time = 0.0f;
                    } else {
                        if (GameBase.level.time >= ent.pain_debounce_time) {
                            GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/noammo.wav"), 1.0f, 1.0f, 0.0f);
                            ent.pain_debounce_time = GameBase.level.time + 1.0f;
                        }
                        PlayerWeapon.NoAmmoWeaponChange(ent);
                    }
                    return true;
                }
                if ((ent.client.ps.gunframe == 29 || ent.client.ps.gunframe == 34 || ent.client.ps.gunframe == 39 || ent.client.ps.gunframe == 48) && (Lib.rand() & 0xF) != 0) {
                    return true;
                }
                if (++ent.client.ps.gunframe > 48) {
                    ent.client.ps.gunframe = 16;
                }
                return true;
            }
            if (ent.client.weaponstate == 3) {
                if (ent.client.ps.gunframe == 5) {
                    GameBase.gi.sound(ent, 1, GameBase.gi.soundindex("weapons/hgrena1b.wav"), 1.0f, 1.0f, 0.0f);
                }
                if (ent.client.ps.gunframe == 11) {
                    if (0.0f == ent.client.grenade_time) {
                        ent.client.grenade_time = GameBase.level.time + 3.0f + 0.2f;
                        ent.client.weapon_sound = GameBase.gi.soundindex("weapons/hgrenc1b.wav");
                    }
                    if (!ent.client.grenade_blew_up && GameBase.level.time >= ent.client.grenade_time) {
                        ent.client.weapon_sound = 0;
                        PlayerWeapon.weapon_grenade_fire(ent, true);
                        ent.client.grenade_blew_up = true;
                    }
                    if ((ent.client.buttons & 1) != 0) {
                        return true;
                    }
                    if (ent.client.grenade_blew_up) {
                        if (GameBase.level.time >= ent.client.grenade_time) {
                            ent.client.ps.gunframe = 15;
                            ent.client.grenade_blew_up = false;
                        } else {
                            return true;
                        }
                    }
                }
                if (ent.client.ps.gunframe == 12) {
                    ent.client.weapon_sound = 0;
                    PlayerWeapon.weapon_grenade_fire(ent, false);
                }
                if (ent.client.ps.gunframe == 15 && GameBase.level.time < ent.client.grenade_time) {
                    return true;
                }
                ++ent.client.ps.gunframe;
                if (ent.client.ps.gunframe == 16) {
                    ent.client.grenade_time = 0.0f;
                    ent.client.weaponstate = 0;
                }
            }
            return true;
        }
    };
    public static EntThinkAdapter weapon_grenadelauncher_fire = new EntThinkAdapter(){

        public String getID() {
            return "weapon_grenadelauncher_fire";
        }

        public boolean think(edict_t ent) {
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            int damage = 120;
            float radius = damage + 40;
            if (is_quad) {
                damage *= 4;
            }
            Math3D.VectorSet(offset, 8.0f, 8.0f, ent.viewheight - 8);
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
            Math3D.VectorScale(forward, -2.0f, ent.client.kick_origin);
            ent.client.kick_angles[0] = -1.0f;
            GameWeapon.fire_grenade(ent, start, forward, damage, 600, 2.5f, radius);
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(8 | is_silenced);
            GameBase.gi.multicast(ent.s.origin, 2);
            ++ent.client.ps.gunframe;
            PlayerWeapon.PlayerNoise(ent, start, 1);
            if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                int n = ent.client.ammo_index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_GrenadeLauncher = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_GrenadeLauncher";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{34, 51, 59, 0};
            int[] fire_frames = new int[]{6, 0};
            PlayerWeapon.Weapon_Generic(ent, 5, 16, 59, 64, pause_frames, fire_frames, weapon_grenadelauncher_fire);
            return true;
        }
    };
    public static EntThinkAdapter Weapon_RocketLauncher_Fire = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_RocketLauncher_Fire";
        }

        public boolean think(edict_t ent) {
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            int damage = 100 + (int)((double)Lib.random() * 20.0);
            int radius_damage = 120;
            float damage_radius = 120.0f;
            if (is_quad) {
                damage *= 4;
                radius_damage *= 4;
            }
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            Math3D.VectorScale(forward, -2.0f, ent.client.kick_origin);
            ent.client.kick_angles[0] = -1.0f;
            Math3D.VectorSet(offset, 8.0f, 8.0f, ent.viewheight - 8);
            PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
            GameWeapon.fire_rocket(ent, start, forward, damage, 650, damage_radius, radius_damage);
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(7 | is_silenced);
            GameBase.gi.multicast(ent.s.origin, 2);
            ++ent.client.ps.gunframe;
            PlayerWeapon.PlayerNoise(ent, start, 1);
            if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                int n = ent.client.ammo_index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_RocketLauncher = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_RocketLauncher";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{25, 33, 42, 50, 0};
            int[] fire_frames = new int[]{5, 0};
            PlayerWeapon.Weapon_Generic(ent, 4, 12, 50, 54, pause_frames, fire_frames, Weapon_RocketLauncher_Fire);
            return true;
        }
    };
    public static EntThinkAdapter Weapon_Blaster_Fire = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Blaster_Fire";
        }

        public boolean think(edict_t ent) {
            int damage = GameBase.deathmatch.value != 0.0f ? 15 : 10;
            PlayerWeapon.Blaster_Fire(ent, Globals.vec3_origin, damage, false, 8);
            ++ent.client.ps.gunframe;
            return true;
        }
    };
    public static EntThinkAdapter Weapon_Blaster = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Blaster";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{19, 32, 0};
            int[] fire_frames = new int[]{5, 0};
            PlayerWeapon.Weapon_Generic(ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Blaster_Fire);
            return true;
        }
    };
    public static EntThinkAdapter Weapon_HyperBlaster_Fire = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_HyperBlaster_Fire";
        }

        public boolean think(edict_t ent) {
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            ent.client.weapon_sound = GameBase.gi.soundindex("weapons/hyprbl1a.wav");
            if (0 == (ent.client.buttons & 1)) {
                ++ent.client.ps.gunframe;
            } else {
                if (0 == ent.client.pers.inventory[ent.client.ammo_index]) {
                    if (GameBase.level.time >= ent.pain_debounce_time) {
                        GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/noammo.wav"), 1.0f, 1.0f, 0.0f);
                        ent.pain_debounce_time = GameBase.level.time + 1.0f;
                    }
                    PlayerWeapon.NoAmmoWeaponChange(ent);
                } else {
                    float rotation = (float)((double)((ent.client.ps.gunframe - 5) * 2) * Math.PI / 6.0);
                    offset[0] = (float)(-4.0 * Math.sin(rotation));
                    offset[1] = 0.0f;
                    offset[2] = (float)(4.0 * Math.cos(rotation));
                    int effect = ent.client.ps.gunframe == 6 || ent.client.ps.gunframe == 9 ? 64 : 0;
                    int damage = GameBase.deathmatch.value != 0.0f ? 15 : 20;
                    PlayerWeapon.Blaster_Fire(ent, offset, damage, true, effect);
                    if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                        int n = ent.client.ammo_index;
                        ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                    }
                    ent.client.anim_priority = 4;
                    if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                        ent.s.frame = 159;
                        ent.client.anim_end = 168;
                    } else {
                        ent.s.frame = 45;
                        ent.client.anim_end = 53;
                    }
                }
                ++ent.client.ps.gunframe;
                if (ent.client.ps.gunframe == 12 && 0 != ent.client.pers.inventory[ent.client.ammo_index]) {
                    ent.client.ps.gunframe = 6;
                }
            }
            if (ent.client.ps.gunframe == 12) {
                GameBase.gi.sound(ent, 0, GameBase.gi.soundindex("weapons/hyprbd1a.wav"), 1.0f, 1.0f, 0.0f);
                ent.client.weapon_sound = 0;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_HyperBlaster = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_HyperBlaster";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{0};
            int[] fire_frames = new int[]{6, 7, 8, 9, 10, 11, 0};
            PlayerWeapon.Weapon_Generic(ent, 5, 20, 49, 53, pause_frames, fire_frames, Weapon_HyperBlaster_Fire);
            return true;
        }
    };
    public static EntThinkAdapter Weapon_Machinegun = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Machinegun";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{23, 45, 0};
            int[] fire_frames = new int[]{4, 5, 0};
            PlayerWeapon.Weapon_Generic(ent, 3, 5, 45, 49, pause_frames, fire_frames, Machinegun_Fire);
            return true;
        }
    };
    public static EntThinkAdapter Weapon_Chaingun = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Chaingun";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{38, 43, 51, 61, 0};
            int[] fire_frames = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 0};
            PlayerWeapon.Weapon_Generic(ent, 4, 31, 61, 64, pause_frames, fire_frames, Chaingun_Fire);
            return true;
        }
    };
    public static EntThinkAdapter weapon_shotgun_fire = new EntThinkAdapter(){

        public String getID() {
            return "weapon_shotgun_fire";
        }

        public boolean think(edict_t ent) {
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            int damage = 4;
            int kick = 8;
            if (ent.client.ps.gunframe == 9) {
                ++ent.client.ps.gunframe;
                return true;
            }
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            Math3D.VectorScale(forward, -2.0f, ent.client.kick_origin);
            ent.client.kick_angles[0] = -2.0f;
            Math3D.VectorSet(offset, 0.0f, 8.0f, ent.viewheight - 8);
            PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
            if (is_quad) {
                damage *= 4;
                kick *= 4;
            }
            if (GameBase.deathmatch.value != 0.0f) {
                GameWeapon.fire_shotgun(ent, start, forward, damage, kick, 500, 500, 12, 2);
            } else {
                GameWeapon.fire_shotgun(ent, start, forward, damage, kick, 500, 500, 12, 2);
            }
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(2 | is_silenced);
            GameBase.gi.multicast(ent.s.origin, 2);
            ++ent.client.ps.gunframe;
            PlayerWeapon.PlayerNoise(ent, start, 1);
            if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                int n = ent.client.ammo_index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_Shotgun = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Shotgun";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{22, 28, 34, 0};
            int[] fire_frames = new int[]{8, 9, 0};
            PlayerWeapon.Weapon_Generic(ent, 7, 18, 36, 39, pause_frames, fire_frames, weapon_shotgun_fire);
            return true;
        }
    };
    public static EntThinkAdapter weapon_supershotgun_fire = new EntThinkAdapter(){

        public String getID() {
            return "weapon_supershotgun_fire";
        }

        public boolean think(edict_t ent) {
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            int damage = 6;
            int kick = 12;
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            Math3D.VectorScale(forward, -2.0f, ent.client.kick_origin);
            ent.client.kick_angles[0] = -2.0f;
            Math3D.VectorSet(offset, 0.0f, 8.0f, ent.viewheight - 8);
            PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
            if (is_quad) {
                damage *= 4;
                kick *= 4;
            }
            v[0] = ent.client.v_angle[0];
            v[1] = ent.client.v_angle[1] - 5.0f;
            v[2] = ent.client.v_angle[2];
            Math3D.AngleVectors(v, forward, null, null);
            GameWeapon.fire_shotgun(ent, start, forward, damage, kick, 1000, 500, 10, 3);
            v[1] = ent.client.v_angle[1] + 5.0f;
            Math3D.AngleVectors(v, forward, null, null);
            GameWeapon.fire_shotgun(ent, start, forward, damage, kick, 1000, 500, 10, 3);
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(0xD | is_silenced);
            GameBase.gi.multicast(ent.s.origin, 2);
            ++ent.client.ps.gunframe;
            PlayerWeapon.PlayerNoise(ent, start, 1);
            if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                int n = ent.client.ammo_index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 2;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_SuperShotgun = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_SuperShotgun";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{29, 42, 57, 0};
            int[] fire_frames = new int[]{7, 0};
            PlayerWeapon.Weapon_Generic(ent, 6, 17, 57, 61, pause_frames, fire_frames, weapon_supershotgun_fire);
            return true;
        }
    };
    public static EntThinkAdapter weapon_railgun_fire = new EntThinkAdapter(){

        public String getID() {
            return "weapon_railgun_fire";
        }

        public boolean think(edict_t ent) {
            int kick;
            int damage;
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            if (GameBase.deathmatch.value != 0.0f) {
                damage = 100;
                kick = 200;
            } else {
                damage = 150;
                kick = 250;
            }
            if (is_quad) {
                damage *= 4;
                kick *= 4;
            }
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            Math3D.VectorScale(forward, -3.0f, ent.client.kick_origin);
            ent.client.kick_angles[0] = -3.0f;
            Math3D.VectorSet(offset, 0.0f, 7.0f, ent.viewheight - 8);
            PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
            GameWeapon.fire_rail(ent, start, forward, damage, kick);
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(6 | is_silenced);
            GameBase.gi.multicast(ent.s.origin, 2);
            ++ent.client.ps.gunframe;
            PlayerWeapon.PlayerNoise(ent, start, 1);
            if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                int n = ent.client.ammo_index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_Railgun = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_Railgun";
        }

        public boolean think(edict_t ent) {
            int[] pause_frames = new int[]{56, 0};
            int[] fire_frames = new int[]{4, 0};
            PlayerWeapon.Weapon_Generic(ent, 3, 18, 56, 61, pause_frames, fire_frames, weapon_railgun_fire);
            return true;
        }
    };
    public static EntThinkAdapter weapon_bfg_fire = new EntThinkAdapter(){

        public String getID() {
            return "weapon_bfg_fire";
        }

        public boolean think(edict_t ent) {
            float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            float damage_radius = 1000.0f;
            int damage = GameBase.deathmatch.value != 0.0f ? 200 : 500;
            if (ent.client.ps.gunframe == 9) {
                GameBase.gi.WriteByte(1);
                GameBase.gi.WriteShort(ent.index);
                GameBase.gi.WriteByte(0xC | is_silenced);
                GameBase.gi.multicast(ent.s.origin, 2);
                ++ent.client.ps.gunframe;
                PlayerWeapon.PlayerNoise(ent, start, 1);
                return true;
            }
            if (ent.client.pers.inventory[ent.client.ammo_index] < 50) {
                ++ent.client.ps.gunframe;
                return true;
            }
            if (is_quad) {
                damage *= 4;
            }
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            Math3D.VectorScale(forward, -2.0f, ent.client.kick_origin);
            ent.client.v_dmg_pitch = -40.0f;
            ent.client.v_dmg_roll = Lib.crandom() * 8.0f;
            ent.client.v_dmg_time = GameBase.level.time + 0.5f;
            Math3D.VectorSet(offset, 8.0f, 8.0f, ent.viewheight - 8);
            PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
            GameWeapon.fire_bfg(ent, start, forward, damage, 400, damage_radius);
            ++ent.client.ps.gunframe;
            PlayerWeapon.PlayerNoise(ent, start, 1);
            if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                int n = ent.client.ammo_index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 50;
            }
            return true;
        }
    };
    public static EntThinkAdapter Weapon_BFG = new EntThinkAdapter(){

        public String getID() {
            return "Weapon_BFG";
        }

        public boolean think(edict_t ent) {
            PlayerWeapon.Weapon_Generic(ent, 8, 32, 55, 58, pause_frames, fire_frames, weapon_bfg_fire);
            return true;
        }
    };
    public static boolean is_quad;
    public static byte is_silenced;
    public static ItemUseAdapter Use_Weapon;
    public static ItemDropAdapter Drop_Weapon;
    public static EntThinkAdapter Machinegun_Fire;
    public static EntThinkAdapter Chaingun_Fire;
    public static int[] pause_frames;
    public static int[] fire_frames;
    public static EntInteractAdapter Pickup_Weapon;

    public static void P_ProjectSource(gclient_t client, float[] point, float[] distance, float[] forward, float[] right, float[] result) {
        float[] _distance = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorCopy(distance, _distance);
        if (client.pers.hand == 1) {
            _distance[1] = _distance[1] * -1.0f;
        } else if (client.pers.hand == 2) {
            _distance[1] = 0.0f;
        }
        Math3D.G_ProjectSource(point, _distance, forward, right, result);
    }

    public static void ChangeWeapon(edict_t ent) {
        if (ent.client.grenade_time != 0.0f) {
            ent.client.grenade_time = GameBase.level.time;
            ent.client.weapon_sound = 0;
            PlayerWeapon.weapon_grenade_fire(ent, false);
            ent.client.grenade_time = 0.0f;
        }
        ent.client.pers.lastweapon = ent.client.pers.weapon;
        ent.client.pers.weapon = ent.client.newweapon;
        ent.client.newweapon = null;
        ent.client.machinegun_shots = 0;
        if (ent.s.modelindex == 255) {
            int i = ent.client.pers.weapon != null ? (ent.client.pers.weapon.weapmodel & 0xFF) << 8 : 0;
            ent.s.skinnum = ent.index - 1 | i;
        }
        ent.client.ammo_index = ent.client.pers.weapon != null && ent.client.pers.weapon.ammo != null ? GameItems.ITEM_INDEX(GameItems.FindItem(ent.client.pers.weapon.ammo)) : 0;
        if (ent.client.pers.weapon == null) {
            ent.client.ps.gunindex = 0;
            return;
        }
        ent.client.weaponstate = 1;
        ent.client.ps.gunframe = 0;
        ent.client.ps.gunindex = GameBase.gi.modelindex(ent.client.pers.weapon.view_model);
        ent.client.anim_priority = 3;
        if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
            ent.s.frame = 169;
            ent.client.anim_end = 172;
        } else {
            ent.s.frame = 62;
            ent.client.anim_end = 65;
        }
    }

    public static void NoAmmoWeaponChange(edict_t ent) {
        if (0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("slugs"))] && 0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("railgun"))]) {
            ent.client.newweapon = GameItems.FindItem("railgun");
            return;
        }
        if (0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("cells"))] && 0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("hyperblaster"))]) {
            ent.client.newweapon = GameItems.FindItem("hyperblaster");
            return;
        }
        if (0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("bullets"))] && 0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("chaingun"))]) {
            ent.client.newweapon = GameItems.FindItem("chaingun");
            return;
        }
        if (0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("bullets"))] && 0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("machinegun"))]) {
            ent.client.newweapon = GameItems.FindItem("machinegun");
            return;
        }
        if (ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("shells"))] > 1 && 0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("super shotgun"))]) {
            ent.client.newweapon = GameItems.FindItem("super shotgun");
            return;
        }
        if (0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("shells"))] && 0 != ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("shotgun"))]) {
            ent.client.newweapon = GameItems.FindItem("shotgun");
            return;
        }
        ent.client.newweapon = GameItems.FindItem("blaster");
    }

    public static void Think_Weapon(edict_t ent) {
        if (ent.health < 1) {
            ent.client.newweapon = null;
            PlayerWeapon.ChangeWeapon(ent);
        }
        if (null != ent.client.pers.weapon && null != ent.client.pers.weapon.weaponthink) {
            is_quad = ent.client.quad_framenum > (float)GameBase.level.framenum;
            is_silenced = ent.client.silencer_shots != 0 ? (byte)-128 : (byte)0;
            ent.client.pers.weapon.weaponthink.think(ent);
        }
    }

    public static void Weapon_Generic(edict_t ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int[] pause_frames, int[] fire_frames, EntThinkAdapter fire) {
        int FRAME_FIRE_FIRST = FRAME_ACTIVATE_LAST + 1;
        int FRAME_IDLE_FIRST = FRAME_FIRE_LAST + 1;
        int FRAME_DEACTIVATE_FIRST = FRAME_IDLE_LAST + 1;
        if (ent.deadflag != 0 || ent.s.modelindex != 255) {
            return;
        }
        if (ent.client.weaponstate == 2) {
            if (ent.client.ps.gunframe == FRAME_DEACTIVATE_LAST) {
                PlayerWeapon.ChangeWeapon(ent);
                return;
            }
            if (FRAME_DEACTIVATE_LAST - ent.client.ps.gunframe == 4) {
                ent.client.anim_priority = 6;
                if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                    ent.s.frame = 173;
                    ent.client.anim_end = 169;
                } else {
                    ent.s.frame = 66;
                    ent.client.anim_end = 62;
                }
            }
            ++ent.client.ps.gunframe;
            return;
        }
        if (ent.client.weaponstate == 1) {
            if (ent.client.ps.gunframe == FRAME_ACTIVATE_LAST) {
                ent.client.weaponstate = 0;
                ent.client.ps.gunframe = FRAME_IDLE_FIRST;
                return;
            }
            ++ent.client.ps.gunframe;
            return;
        }
        if (ent.client.newweapon != null && ent.client.weaponstate != 3) {
            ent.client.weaponstate = 2;
            ent.client.ps.gunframe = FRAME_DEACTIVATE_FIRST;
            if (FRAME_DEACTIVATE_LAST - FRAME_DEACTIVATE_FIRST < 4) {
                ent.client.anim_priority = 6;
                if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                    ent.s.frame = 173;
                    ent.client.anim_end = 169;
                } else {
                    ent.s.frame = 66;
                    ent.client.anim_end = 62;
                }
            }
            return;
        }
        if (ent.client.weaponstate == 0) {
            if (((ent.client.latched_buttons | ent.client.buttons) & 1) != 0) {
                ent.client.latched_buttons &= 0xFFFFFFFE;
                if (0 == ent.client.ammo_index || ent.client.pers.inventory[ent.client.ammo_index] >= ent.client.pers.weapon.quantity) {
                    ent.client.ps.gunframe = FRAME_FIRE_FIRST;
                    ent.client.weaponstate = 3;
                    ent.client.anim_priority = 4;
                    if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                        ent.s.frame = 159;
                        ent.client.anim_end = 168;
                    } else {
                        ent.s.frame = 45;
                        ent.client.anim_end = 53;
                    }
                } else {
                    if (GameBase.level.time >= ent.pain_debounce_time) {
                        GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/noammo.wav"), 1.0f, 1.0f, 0.0f);
                        ent.pain_debounce_time = GameBase.level.time + 1.0f;
                    }
                    PlayerWeapon.NoAmmoWeaponChange(ent);
                }
            } else {
                if (ent.client.ps.gunframe == FRAME_IDLE_LAST) {
                    ent.client.ps.gunframe = FRAME_IDLE_FIRST;
                    return;
                }
                if (pause_frames != null) {
                    int n = 0;
                    while (pause_frames[n] != 0) {
                        if (ent.client.ps.gunframe == pause_frames[n] && (Lib.rand() & 0xF) != 0) {
                            return;
                        }
                        ++n;
                    }
                }
                ++ent.client.ps.gunframe;
                return;
            }
        }
        if (ent.client.weaponstate == 3) {
            int n = 0;
            while (fire_frames[n] != 0) {
                if (ent.client.ps.gunframe == fire_frames[n]) {
                    if (ent.client.quad_framenum > (float)GameBase.level.framenum) {
                        GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/damage3.wav"), 1.0f, 1.0f, 0.0f);
                    }
                    fire.think(ent);
                    break;
                }
                ++n;
            }
            if (0 == fire_frames[n]) {
                ++ent.client.ps.gunframe;
            }
            if (ent.client.ps.gunframe == FRAME_IDLE_FIRST + 1) {
                ent.client.weaponstate = 0;
            }
        }
    }

    public static void weapon_grenade_fire(edict_t ent, boolean held) {
        float[] offset = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] start = new float[]{0.0f, 0.0f, 0.0f};
        int damage = 125;
        float radius = damage + 40;
        if (is_quad) {
            damage *= 4;
        }
        Math3D.VectorSet(offset, 8.0f, 8.0f, ent.viewheight - 8);
        Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
        PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
        float timer = ent.client.grenade_time - GameBase.level.time;
        int speed = (int)(400.0f + (3.0f - timer) * 133.33333f);
        GameWeapon.fire_grenade2(ent, start, forward, damage, speed, timer, radius, held);
        if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
            int n = ent.client.ammo_index;
            ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
        }
        ent.client.grenade_time = GameBase.level.time + 1.0f;
        if (ent.deadflag != 0 || ent.s.modelindex != 255) {
            return;
        }
        if (ent.health <= 0) {
            return;
        }
        if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
            ent.client.anim_priority = 4;
            ent.s.frame = 159;
            ent.client.anim_end = 162;
        } else {
            ent.client.anim_priority = 6;
            ent.s.frame = 119;
            ent.client.anim_end = 112;
        }
    }

    public static void Blaster_Fire(edict_t ent, float[] g_offset, int damage, boolean hyper, int effect) {
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] start = new float[]{0.0f, 0.0f, 0.0f};
        float[] offset = new float[]{0.0f, 0.0f, 0.0f};
        if (is_quad) {
            damage *= 4;
        }
        Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
        Math3D.VectorSet(offset, 24.0f, 8.0f, ent.viewheight - 8);
        Math3D.VectorAdd(offset, g_offset, offset);
        PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
        Math3D.VectorScale(forward, -2.0f, ent.client.kick_origin);
        ent.client.kick_angles[0] = -1.0f;
        GameWeapon.fire_blaster(ent, start, forward, damage, 1000, effect, hyper);
        GameBase.gi.WriteByte(1);
        GameBase.gi.WriteShort(ent.index);
        if (hyper) {
            GameBase.gi.WriteByte(0xE | is_silenced);
        } else {
            GameBase.gi.WriteByte(0 | is_silenced);
        }
        GameBase.gi.multicast(ent.s.origin, 2);
        PlayerWeapon.PlayerNoise(ent, start, 1);
    }

    static void PlayerNoise(edict_t who, float[] where, int type) {
        edict_t noise;
        if (type == 1 && who.client.silencer_shots > 0) {
            --who.client.silencer_shots;
            return;
        }
        if (GameBase.deathmatch.value != 0.0f) {
            return;
        }
        if ((who.flags & 0x20) != 0) {
            return;
        }
        if (who.mynoise == null) {
            noise = GameUtil.G_Spawn();
            noise.classname = "player_noise";
            Math3D.VectorSet(noise.mins, -8.0f, -8.0f, -8.0f);
            Math3D.VectorSet(noise.maxs, 8.0f, 8.0f, 8.0f);
            noise.owner = who;
            noise.svflags = 1;
            who.mynoise = noise;
            noise = GameUtil.G_Spawn();
            noise.classname = "player_noise";
            Math3D.VectorSet(noise.mins, -8.0f, -8.0f, -8.0f);
            Math3D.VectorSet(noise.maxs, 8.0f, 8.0f, 8.0f);
            noise.owner = who;
            noise.svflags = 1;
            who.mynoise2 = noise;
        }
        if (type == 0 || type == 1) {
            GameBase.level.sound_entity = noise = who.mynoise;
            GameBase.level.sound_entity_framenum = GameBase.level.framenum;
        } else {
            GameBase.level.sound2_entity = noise = who.mynoise2;
            GameBase.level.sound2_entity_framenum = GameBase.level.framenum;
        }
        Math3D.VectorCopy(where, noise.s.origin);
        Math3D.VectorSubtract(where, noise.maxs, noise.absmin);
        Math3D.VectorAdd(where, noise.maxs, noise.absmax);
        noise.teleport_time = GameBase.level.time;
        GameBase.gi.linkentity(noise);
    }

    static {
        Use_Weapon = new ItemUseAdapter(){

            public String getID() {
                return "Use_Weapon";
            }

            public void use(edict_t ent, gitem_t item) {
                if (item == ent.client.pers.weapon) {
                    return;
                }
                if (item.ammo != null && 0.0f == GameBase.g_select_empty.value && 0 == (item.flags & 2)) {
                    gitem_t ammo_item = GameItems.FindItem(item.ammo);
                    int ammo_index = GameItems.ITEM_INDEX(ammo_item);
                    if (0 == ent.client.pers.inventory[ammo_index]) {
                        GameBase.gi.cprintf(ent, 2, "No " + ammo_item.pickup_name + " for " + item.pickup_name + ".\n");
                        return;
                    }
                    if (ent.client.pers.inventory[ammo_index] < item.quantity) {
                        GameBase.gi.cprintf(ent, 2, "Not enough " + ammo_item.pickup_name + " for " + item.pickup_name + ".\n");
                        return;
                    }
                }
                ent.client.newweapon = item;
            }
        };
        Drop_Weapon = new ItemDropAdapter(){

            public String getID() {
                return "Drop_Weapon";
            }

            public void drop(edict_t ent, gitem_t item) {
                if (0 != ((int)GameBase.dmflags.value & 4)) {
                    return;
                }
                int index = GameItems.ITEM_INDEX(item);
                if ((item == ent.client.pers.weapon || item == ent.client.newweapon) && ent.client.pers.inventory[index] == 1) {
                    GameBase.gi.cprintf(ent, 2, "Can't drop current weapon\n");
                    return;
                }
                GameItems.Drop_Item(ent, item);
                int n = index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
            }
        };
        Machinegun_Fire = new EntThinkAdapter(){

            public String getID() {
                return "Machinegun_Fire";
            }

            public boolean think(edict_t ent) {
                float[] start = new float[]{0.0f, 0.0f, 0.0f};
                float[] forward = new float[]{0.0f, 0.0f, 0.0f};
                float[] right = new float[]{0.0f, 0.0f, 0.0f};
                float[] angles = new float[]{0.0f, 0.0f, 0.0f};
                int damage = 8;
                int kick = 2;
                float[] offset = new float[]{0.0f, 0.0f, 0.0f};
                if (0 == (ent.client.buttons & 1)) {
                    ent.client.machinegun_shots = 0;
                    ++ent.client.ps.gunframe;
                    return true;
                }
                ent.client.ps.gunframe = ent.client.ps.gunframe == 5 ? 4 : 5;
                if (ent.client.pers.inventory[ent.client.ammo_index] < 1) {
                    ent.client.ps.gunframe = 6;
                    if (GameBase.level.time >= ent.pain_debounce_time) {
                        GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/noammo.wav"), 1.0f, 1.0f, 0.0f);
                        ent.pain_debounce_time = GameBase.level.time + 1.0f;
                    }
                    PlayerWeapon.NoAmmoWeaponChange(ent);
                    return true;
                }
                if (is_quad) {
                    damage *= 4;
                    kick *= 4;
                }
                for (int i = 1; i < 3; ++i) {
                    ent.client.kick_origin[i] = Lib.crandom() * 0.35f;
                    ent.client.kick_angles[i] = Lib.crandom() * 0.7f;
                }
                ent.client.kick_origin[0] = Lib.crandom() * 0.35f;
                ent.client.kick_angles[0] = (float)ent.client.machinegun_shots * -1.5f;
                if (0.0f == GameBase.deathmatch.value) {
                    ++ent.client.machinegun_shots;
                    if (ent.client.machinegun_shots > 9) {
                        ent.client.machinegun_shots = 9;
                    }
                }
                Math3D.VectorAdd(ent.client.v_angle, ent.client.kick_angles, angles);
                Math3D.AngleVectors(angles, forward, right, null);
                Math3D.VectorSet(offset, 0.0f, 8.0f, ent.viewheight - 8);
                PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
                GameWeapon.fire_bullet(ent, start, forward, damage, kick, 300, 500, 4);
                GameBase.gi.WriteByte(1);
                GameBase.gi.WriteShort(ent.index);
                GameBase.gi.WriteByte(1 | is_silenced);
                GameBase.gi.multicast(ent.s.origin, 2);
                PlayerWeapon.PlayerNoise(ent, start, 1);
                if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                    int n = ent.client.ammo_index;
                    ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                }
                ent.client.anim_priority = 4;
                if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                    ent.s.frame = 160 - (int)((double)Lib.random() + 0.25);
                    ent.client.anim_end = 168;
                } else {
                    ent.s.frame = 46 - (int)((double)Lib.random() + 0.25);
                    ent.client.anim_end = 53;
                }
                return true;
            }
        };
        Chaingun_Fire = new EntThinkAdapter(){

            public String getID() {
                return "Chaingun_Fire";
            }

            public boolean think(edict_t ent) {
                int i;
                float[] start = new float[]{0.0f, 0.0f, 0.0f};
                float[] forward = new float[]{0.0f, 0.0f, 0.0f};
                float[] right = new float[]{0.0f, 0.0f, 0.0f};
                float[] up = new float[]{0.0f, 0.0f, 0.0f};
                float[] offset = new float[]{0.0f, 0.0f, 0.0f};
                int kick = 2;
                int damage = GameBase.deathmatch.value != 0.0f ? 6 : 8;
                if (ent.client.ps.gunframe == 5) {
                    GameBase.gi.sound(ent, 0, GameBase.gi.soundindex("weapons/chngnu1a.wav"), 1.0f, 2.0f, 0.0f);
                }
                if (ent.client.ps.gunframe == 14 && 0 == (ent.client.buttons & 1)) {
                    ent.client.ps.gunframe = 32;
                    ent.client.weapon_sound = 0;
                    return true;
                }
                ent.client.ps.gunframe = ent.client.ps.gunframe == 21 && (ent.client.buttons & 1) != 0 && 0 != ent.client.pers.inventory[ent.client.ammo_index] ? 15 : ++ent.client.ps.gunframe;
                if (ent.client.ps.gunframe == 22) {
                    ent.client.weapon_sound = 0;
                    GameBase.gi.sound(ent, 0, GameBase.gi.soundindex("weapons/chngnd1a.wav"), 1.0f, 2.0f, 0.0f);
                } else {
                    ent.client.weapon_sound = GameBase.gi.soundindex("weapons/chngnl1a.wav");
                }
                ent.client.anim_priority = 4;
                if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                    ent.s.frame = 160 - (ent.client.ps.gunframe & 1);
                    ent.client.anim_end = 168;
                } else {
                    ent.s.frame = 46 - (ent.client.ps.gunframe & 1);
                    ent.client.anim_end = 53;
                }
                int shots = ent.client.ps.gunframe <= 9 ? 1 : (ent.client.ps.gunframe <= 14 ? ((ent.client.buttons & 1) != 0 ? 2 : 1) : 3);
                if (ent.client.pers.inventory[ent.client.ammo_index] < shots) {
                    shots = ent.client.pers.inventory[ent.client.ammo_index];
                }
                if (0 == shots) {
                    if (GameBase.level.time >= ent.pain_debounce_time) {
                        GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/noammo.wav"), 1.0f, 1.0f, 0.0f);
                        ent.pain_debounce_time = GameBase.level.time + 1.0f;
                    }
                    PlayerWeapon.NoAmmoWeaponChange(ent);
                    return true;
                }
                if (is_quad) {
                    damage *= 4;
                    kick *= 4;
                }
                for (i = 0; i < 3; ++i) {
                    ent.client.kick_origin[i] = Lib.crandom() * 0.35f;
                    ent.client.kick_angles[i] = Lib.crandom() * 0.7f;
                }
                for (i = 0; i < shots; ++i) {
                    Math3D.AngleVectors(ent.client.v_angle, forward, right, up);
                    float r = 7.0f + Lib.crandom() * 4.0f;
                    float u = Lib.crandom() * 4.0f;
                    Math3D.VectorSet(offset, 0.0f, r, u + (float)ent.viewheight - 8.0f);
                    PlayerWeapon.P_ProjectSource(ent.client, ent.s.origin, offset, forward, right, start);
                    GameWeapon.fire_bullet(ent, start, forward, damage, kick, 300, 500, 5);
                }
                GameBase.gi.WriteByte(1);
                GameBase.gi.WriteShort(ent.index);
                GameBase.gi.WriteByte(3 + shots - 1 | is_silenced);
                GameBase.gi.multicast(ent.s.origin, 2);
                PlayerWeapon.PlayerNoise(ent, start, 1);
                if (0 == ((int)GameBase.dmflags.value & 0x2000)) {
                    int n = ent.client.ammo_index;
                    ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - shots;
                }
                return true;
            }
        };
        pause_frames = new int[]{39, 45, 50, 55, 0};
        fire_frames = new int[]{9, 17, 0};
        Pickup_Weapon = new EntInteractAdapter(){

            public String getID() {
                return "Pickup_Weapon";
            }

            public boolean interact(edict_t ent, edict_t other) {
                int index = GameItems.ITEM_INDEX(ent.item);
                if ((((int)GameBase.dmflags.value & 4) != 0 || GameBase.coop.value != 0.0f) && 0 != other.client.pers.inventory[index] && 0 == (ent.spawnflags & 0x30000)) {
                    return false;
                }
                int n = index;
                other.client.pers.inventory[n] = other.client.pers.inventory[n] + 1;
                if (0 == (ent.spawnflags & 0x10000)) {
                    gitem_t ammo = GameItems.FindItem(ent.item.ammo);
                    if (((int)GameBase.dmflags.value & 0x2000) != 0) {
                        GameItems.Add_Ammo(other, ammo, 1000);
                    } else {
                        GameItems.Add_Ammo(other, ammo, ammo.quantity);
                    }
                    if (0 == (ent.spawnflags & 0x20000)) {
                        if (GameBase.deathmatch.value != 0.0f) {
                            if (((int)GameBase.dmflags.value & 4) != 0) {
                                ent.flags |= Integer.MIN_VALUE;
                            } else {
                                GameItems.SetRespawn(ent, 30.0f);
                            }
                        }
                        if (GameBase.coop.value != 0.0f) {
                            ent.flags |= Integer.MIN_VALUE;
                        }
                    }
                }
                if (other.client.pers.weapon != ent.item && other.client.pers.inventory[index] == 1 && (0.0f == GameBase.deathmatch.value || other.client.pers.weapon == GameItems.FindItem("blaster"))) {
                    other.client.newweapon = ent.item;
                }
                return true;
            }
        };
    }
}

