/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameItems;
import jake2.game.PlayerHud;
import jake2.game.PlayerWeapon;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class PlayerView {
    public static edict_t current_player;
    public static gclient_t current_client;
    public static float[] forward;
    public static float[] right;
    public static float[] up;
    public static float xyspeed;
    public static float bobmove;
    public static int bobcycle;
    public static float bobfracsin;
    private static int xxxi;

    public static float SV_CalcRoll(float[] angles, float[] velocity) {
        float side = Math3D.DotProduct(velocity, right);
        float sign = side < 0.0f ? -1.0f : 1.0f;
        side = Math.abs(side);
        float value = GameBase.sv_rollangle.value;
        side = side < GameBase.sv_rollspeed.value ? side * value / GameBase.sv_rollspeed.value : value;
        return side * sign;
    }

    public static void P_DamageFeedback(edict_t player) {
        float count;
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        float[] power_color = new float[]{0.0f, 1.0f, 0.0f};
        float[] acolor = new float[]{1.0f, 1.0f, 1.0f};
        float[] bcolor = new float[]{1.0f, 0.0f, 0.0f};
        gclient_t client = player.client;
        client.ps.stats[15] = 0;
        if (client.damage_blood != 0) {
            client.ps.stats[15] = (short)(client.ps.stats[15] | 1);
        }
        if (client.damage_armor != 0 && 0 == (player.flags & 0x10) && client.invincible_framenum <= (float)GameBase.level.framenum) {
            client.ps.stats[15] = (short)(client.ps.stats[15] | 2);
        }
        if ((count = (float)(client.damage_blood + client.damage_armor + client.damage_parmor)) == 0.0f) {
            return;
        }
        if (client.anim_priority < 3 & player.s.modelindex == 255) {
            client.anim_priority = 3;
            if ((client.ps.pmove.pm_flags & 1) != 0) {
                player.s.frame = 168;
                client.anim_end = 172;
            } else {
                xxxi = (xxxi + 1) % 3;
                switch (xxxi) {
                    case 0: {
                        player.s.frame = 53;
                        client.anim_end = 57;
                        break;
                    }
                    case 1: {
                        player.s.frame = 57;
                        client.anim_end = 61;
                        break;
                    }
                    case 2: {
                        player.s.frame = 61;
                        client.anim_end = 65;
                    }
                }
            }
        }
        float realcount = count;
        if (count < 10.0f) {
            count = 10.0f;
        }
        if (GameBase.level.time > player.pain_debounce_time && 0 == (player.flags & 0x10) && client.invincible_framenum <= (float)GameBase.level.framenum) {
            int r = 1 + (Lib.rand() & 1);
            player.pain_debounce_time = GameBase.level.time + 0.7f;
            int l = player.health < 25 ? 25 : (player.health < 50 ? 50 : (player.health < 75 ? 75 : 100));
            GameBase.gi.sound(player, 2, GameBase.gi.soundindex("*pain" + l + "_" + r + ".wav"), 1.0f, 1.0f, 0.0f);
        }
        if (client.damage_alpha < 0.0f) {
            client.damage_alpha = 0.0f;
        }
        client.damage_alpha += count * 0.01f;
        if (client.damage_alpha < 0.2f) {
            client.damage_alpha = 0.2f;
        }
        if (client.damage_alpha > 0.6f) {
            client.damage_alpha = 0.6f;
        }
        Math3D.VectorClear(v);
        if (client.damage_parmor != 0) {
            Math3D.VectorMA(v, (float)client.damage_parmor / realcount, power_color, v);
        }
        if (client.damage_armor != 0) {
            Math3D.VectorMA(v, (float)client.damage_armor / realcount, acolor, v);
        }
        if (client.damage_blood != 0) {
            Math3D.VectorMA(v, (float)client.damage_blood / realcount, bcolor, v);
        }
        Math3D.VectorCopy(v, client.damage_blend);
        float kick = Math.abs(client.damage_knockback);
        if (kick != 0.0f && player.health > 0) {
            if ((double)(kick = kick * 100.0f / (float)player.health) < (double)count * 0.5) {
                kick = count * 0.5f;
            }
            if (kick > 50.0f) {
                kick = 50.0f;
            }
            Math3D.VectorSubtract(client.damage_from, player.s.origin, v);
            Math3D.VectorNormalize(v);
            float side = Math3D.DotProduct(v, right);
            client.v_dmg_roll = kick * side * 0.3f;
            side = -Math3D.DotProduct(v, forward);
            client.v_dmg_pitch = kick * side * 0.3f;
            client.v_dmg_time = GameBase.level.time + 0.5f;
        }
        client.damage_blood = 0;
        client.damage_armor = 0;
        client.damage_parmor = 0;
        client.damage_knockback = 0;
    }

    public static void SV_CalcViewOffset(edict_t ent) {
        float ratio;
        float[] angles = new float[]{0.0f, 0.0f, 0.0f};
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        angles = ent.client.ps.kick_angles;
        if (ent.deadflag != 0) {
            Math3D.VectorClear(angles);
            ent.client.ps.viewangles[2] = 40.0f;
            ent.client.ps.viewangles[0] = -15.0f;
            ent.client.ps.viewangles[1] = ent.client.killer_yaw;
        } else {
            Math3D.VectorCopy(ent.client.kick_angles, angles);
            ratio = (ent.client.v_dmg_time - GameBase.level.time) / 0.5f;
            if (ratio < 0.0f) {
                ratio = 0.0f;
                ent.client.v_dmg_pitch = 0.0f;
                ent.client.v_dmg_roll = 0.0f;
            }
            angles[0] = angles[0] + ratio * ent.client.v_dmg_pitch;
            angles[2] = angles[2] + ratio * ent.client.v_dmg_roll;
            ratio = (ent.client.fall_time - GameBase.level.time) / 0.3f;
            if (ratio < 0.0f) {
                ratio = 0.0f;
            }
            angles[0] = angles[0] + ratio * ent.client.fall_value;
            float delta = Math3D.DotProduct(ent.velocity, forward);
            angles[0] = angles[0] + delta * GameBase.run_pitch.value;
            delta = Math3D.DotProduct(ent.velocity, right);
            angles[2] = angles[2] + delta * GameBase.run_roll.value;
            delta = bobfracsin * GameBase.bob_pitch.value * xyspeed;
            if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                delta *= 6.0f;
            }
            angles[0] = angles[0] + delta;
            delta = bobfracsin * GameBase.bob_roll.value * xyspeed;
            if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
                delta *= 6.0f;
            }
            if ((bobcycle & 1) != 0) {
                delta = -delta;
            }
            angles[2] = angles[2] + delta;
        }
        Math3D.VectorClear(v);
        v[2] = v[2] + (float)ent.viewheight;
        ratio = (ent.client.fall_time - GameBase.level.time) / 0.3f;
        if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        v[2] = (float)((double)v[2] - (double)(ratio * ent.client.fall_value) * 0.4);
        float bob = bobfracsin * xyspeed * GameBase.bob_up.value;
        if (bob > 6.0f) {
            bob = 6.0f;
        }
        v[2] = v[2] + bob;
        Math3D.VectorAdd(v, ent.client.kick_origin, v);
        if (v[0] < -14.0f) {
            v[0] = -14.0f;
        } else if (v[0] > 14.0f) {
            v[0] = 14.0f;
        }
        if (v[1] < -14.0f) {
            v[1] = -14.0f;
        } else if (v[1] > 14.0f) {
            v[1] = 14.0f;
        }
        if (v[2] < -22.0f) {
            v[2] = -22.0f;
        } else if (v[2] > 30.0f) {
            v[2] = 30.0f;
        }
        Math3D.VectorCopy(v, ent.client.ps.viewoffset);
    }

    public static void SV_CalcGunOffset(edict_t ent) {
        ent.client.ps.gunangles[2] = xyspeed * bobfracsin * 0.005f;
        ent.client.ps.gunangles[1] = xyspeed * bobfracsin * 0.01f;
        if ((bobcycle & 1) != 0) {
            ent.client.ps.gunangles[2] = -ent.client.ps.gunangles[2];
            ent.client.ps.gunangles[1] = -ent.client.ps.gunangles[1];
        }
        ent.client.ps.gunangles[0] = xyspeed * bobfracsin * 0.005f;
        int i = 0;
        while (i < 3) {
            float delta = ent.client.oldviewangles[i] - ent.client.ps.viewangles[i];
            if (delta > 180.0f) {
                delta -= 360.0f;
            }
            if (delta < -180.0f) {
                delta += 360.0f;
            }
            if (delta > 45.0f) {
                delta = 45.0f;
            }
            if (delta < -45.0f) {
                delta = -45.0f;
            }
            if (i == 1) {
                ent.client.ps.gunangles[2] = (float)((double)ent.client.ps.gunangles[2] + 0.1 * (double)delta);
            }
            int n = i++;
            ent.client.ps.gunangles[n] = (float)((double)ent.client.ps.gunangles[n] + 0.2 * (double)delta);
        }
        Math3D.VectorClear(ent.client.ps.gunoffset);
        for (i = 0; i < 3; ++i) {
            int n = i;
            ent.client.ps.gunoffset[n] = ent.client.ps.gunoffset[n] + forward[i] * GameBase.gun_y.value;
            int n2 = i;
            ent.client.ps.gunoffset[n2] = ent.client.ps.gunoffset[n2] + right[i] * GameBase.gun_x.value;
            int n3 = i;
            ent.client.ps.gunoffset[n3] = ent.client.ps.gunoffset[n3] + up[i] * -GameBase.gun_z.value;
        }
    }

    public static void SV_AddBlend(float r, float g, float b, float a, float[] v_blend) {
        if (a <= 0.0f) {
            return;
        }
        float a2 = v_blend[3] + (1.0f - v_blend[3]) * a;
        float a3 = v_blend[3] / a2;
        v_blend[0] = v_blend[0] * a3 + r * (1.0f - a3);
        v_blend[1] = v_blend[1] * a3 + g * (1.0f - a3);
        v_blend[2] = v_blend[2] * a3 + b * (1.0f - a3);
        v_blend[3] = a2;
    }

    public static void SV_CalcBlend(edict_t ent) {
        float[] vieworg = new float[]{0.0f, 0.0f, 0.0f};
        ent.client.ps.blend[3] = 0.0f;
        ent.client.ps.blend[2] = 0.0f;
        ent.client.ps.blend[1] = 0.0f;
        ent.client.ps.blend[0] = 0.0f;
        Math3D.VectorAdd(ent.s.origin, ent.client.ps.viewoffset, vieworg);
        int contents = GameBase.gi.pointcontents.pointcontents(vieworg);
        ent.client.ps.rdflags = (contents & 0x38) != 0 ? (ent.client.ps.rdflags |= 1) : (ent.client.ps.rdflags &= 0xFFFFFFFE);
        if ((contents & 9) != 0) {
            PlayerView.SV_AddBlend(1.0f, 0.3f, 0.0f, 0.6f, ent.client.ps.blend);
        } else if ((contents & 0x10) != 0) {
            PlayerView.SV_AddBlend(0.0f, 0.1f, 0.05f, 0.6f, ent.client.ps.blend);
        } else if ((contents & 0x20) != 0) {
            PlayerView.SV_AddBlend(0.5f, 0.3f, 0.2f, 0.4f, ent.client.ps.blend);
        }
        if (ent.client.quad_framenum > (float)GameBase.level.framenum) {
            int remaining = (int)(ent.client.quad_framenum - (float)GameBase.level.framenum);
            if (remaining == 30) {
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/damage2.wav"), 1.0f, 1.0f, 0.0f);
            }
            if (remaining > 30 || (remaining & 4) != 0) {
                PlayerView.SV_AddBlend(0.0f, 0.0f, 1.0f, 0.08f, ent.client.ps.blend);
            }
        } else if (ent.client.invincible_framenum > (float)GameBase.level.framenum) {
            int remaining = (int)ent.client.invincible_framenum - GameBase.level.framenum;
            if (remaining == 30) {
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/protect2.wav"), 1.0f, 1.0f, 0.0f);
            }
            if (remaining > 30 || (remaining & 4) != 0) {
                PlayerView.SV_AddBlend(1.0f, 1.0f, 0.0f, 0.08f, ent.client.ps.blend);
            }
        } else if (ent.client.enviro_framenum > (float)GameBase.level.framenum) {
            int remaining = (int)ent.client.enviro_framenum - GameBase.level.framenum;
            if (remaining == 30) {
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/airout.wav"), 1.0f, 1.0f, 0.0f);
            }
            if (remaining > 30 || (remaining & 4) != 0) {
                PlayerView.SV_AddBlend(0.0f, 1.0f, 0.0f, 0.08f, ent.client.ps.blend);
            }
        } else if (ent.client.breather_framenum > (float)GameBase.level.framenum) {
            int remaining = (int)ent.client.breather_framenum - GameBase.level.framenum;
            if (remaining == 30) {
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/airout.wav"), 1.0f, 1.0f, 0.0f);
            }
            if (remaining > 30 || (remaining & 4) != 0) {
                PlayerView.SV_AddBlend(0.4f, 1.0f, 0.4f, 0.04f, ent.client.ps.blend);
            }
        }
        if (ent.client.damage_alpha > 0.0f) {
            PlayerView.SV_AddBlend(ent.client.damage_blend[0], ent.client.damage_blend[1], ent.client.damage_blend[2], ent.client.damage_alpha, ent.client.ps.blend);
        }
        if (ent.client.bonus_alpha > 0.0f) {
            PlayerView.SV_AddBlend(0.85f, 0.7f, 0.3f, ent.client.bonus_alpha, ent.client.ps.blend);
        }
        ent.client.damage_alpha = (float)((double)ent.client.damage_alpha - 0.06);
        if (ent.client.damage_alpha < 0.0f) {
            ent.client.damage_alpha = 0.0f;
        }
        ent.client.bonus_alpha = (float)((double)ent.client.bonus_alpha - 0.1);
        if (ent.client.bonus_alpha < 0.0f) {
            ent.client.bonus_alpha = 0.0f;
        }
    }

    public static void P_FallingDamage(edict_t ent) {
        float delta;
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        if (ent.s.modelindex != 255) {
            return;
        }
        if (ent.movetype == 1) {
            return;
        }
        if (ent.client.oldvelocity[2] < 0.0f && ent.velocity[2] > ent.client.oldvelocity[2] && null == ent.groundentity) {
            delta = ent.client.oldvelocity[2];
        } else {
            if (ent.groundentity == null) {
                return;
            }
            delta = ent.velocity[2] - ent.client.oldvelocity[2];
        }
        delta = delta * delta * 1.0E-4f;
        if (ent.waterlevel == 3) {
            return;
        }
        if (ent.waterlevel == 2) {
            delta = (float)((double)delta * 0.25);
        }
        if (ent.waterlevel == 1) {
            delta = (float)((double)delta * 0.5);
        }
        if (delta < 1.0f) {
            return;
        }
        if (delta < 15.0f) {
            ent.s.event = 2;
            return;
        }
        ent.client.fall_value = delta * 0.5f;
        if (ent.client.fall_value > 40.0f) {
            ent.client.fall_value = 40.0f;
        }
        ent.client.fall_time = GameBase.level.time + 0.3f;
        if (delta > 30.0f) {
            if (ent.health > 0) {
                ent.s.event = delta >= 55.0f ? 5 : 4;
            }
            ent.pain_debounce_time = GameBase.level.time;
            int damage = (int)((delta - 30.0f) / 2.0f);
            if (damage < 1) {
                damage = 1;
            }
            Math3D.VectorSet(dir, 0.0f, 0.0f, 1.0f);
            if (GameBase.deathmatch.value == 0.0f || 0 == ((int)GameBase.dmflags.value & 8)) {
                GameCombat.T_Damage(ent, GameBase.g_edicts[0], GameBase.g_edicts[0], dir, ent.s.origin, Globals.vec3_origin, damage, 0, 0, 22);
            }
        } else {
            ent.s.event = 3;
            return;
        }
    }

    public static void P_WorldEffects() {
        boolean envirosuit;
        if (PlayerView.current_player.movetype == 1) {
            PlayerView.current_player.air_finished = GameBase.level.time + 12.0f;
            return;
        }
        int waterlevel = PlayerView.current_player.waterlevel;
        int old_waterlevel = PlayerView.current_client.old_waterlevel;
        PlayerView.current_client.old_waterlevel = waterlevel;
        boolean breather = PlayerView.current_client.breather_framenum > (float)GameBase.level.framenum;
        boolean bl = envirosuit = PlayerView.current_client.enviro_framenum > (float)GameBase.level.framenum;
        if (old_waterlevel == 0 && waterlevel != 0) {
            PlayerWeapon.PlayerNoise(current_player, PlayerView.current_player.s.origin, 0);
            if ((PlayerView.current_player.watertype & 8) != 0) {
                GameBase.gi.sound(current_player, 4, GameBase.gi.soundindex("player/lava_in.wav"), 1.0f, 1.0f, 0.0f);
            } else if ((PlayerView.current_player.watertype & 0x10) != 0) {
                GameBase.gi.sound(current_player, 4, GameBase.gi.soundindex("player/watr_in.wav"), 1.0f, 1.0f, 0.0f);
            } else if ((PlayerView.current_player.watertype & 0x20) != 0) {
                GameBase.gi.sound(current_player, 4, GameBase.gi.soundindex("player/watr_in.wav"), 1.0f, 1.0f, 0.0f);
            }
            PlayerView.current_player.flags |= 8;
            PlayerView.current_player.damage_debounce_time = GameBase.level.time - 1.0f;
        }
        if (old_waterlevel != 0 && waterlevel == 0) {
            PlayerWeapon.PlayerNoise(current_player, PlayerView.current_player.s.origin, 0);
            GameBase.gi.sound(current_player, 4, GameBase.gi.soundindex("player/watr_out.wav"), 1.0f, 1.0f, 0.0f);
            PlayerView.current_player.flags &= 0xFFFFFFF7;
        }
        if (old_waterlevel != 3 && waterlevel == 3) {
            GameBase.gi.sound(current_player, 4, GameBase.gi.soundindex("player/watr_un.wav"), 1.0f, 1.0f, 0.0f);
        }
        if (old_waterlevel == 3 && waterlevel != 3) {
            if (PlayerView.current_player.air_finished < GameBase.level.time) {
                GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("player/gasp1.wav"), 1.0f, 1.0f, 0.0f);
                PlayerWeapon.PlayerNoise(current_player, PlayerView.current_player.s.origin, 0);
            } else if (PlayerView.current_player.air_finished < GameBase.level.time + 11.0f) {
                GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("player/gasp2.wav"), 1.0f, 1.0f, 0.0f);
            }
        }
        if (waterlevel == 3) {
            if (breather || envirosuit) {
                PlayerView.current_player.air_finished = GameBase.level.time + 10.0f;
                if ((int)(PlayerView.current_client.breather_framenum - (float)GameBase.level.framenum) % 25 == 0) {
                    if (PlayerView.current_client.breather_sound == 0) {
                        GameBase.gi.sound(current_player, 0, GameBase.gi.soundindex("player/u_breath1.wav"), 1.0f, 1.0f, 0.0f);
                    } else {
                        GameBase.gi.sound(current_player, 0, GameBase.gi.soundindex("player/u_breath2.wav"), 1.0f, 1.0f, 0.0f);
                    }
                    PlayerView.current_client.breather_sound ^= 1;
                    PlayerWeapon.PlayerNoise(current_player, PlayerView.current_player.s.origin, 0);
                }
            }
            if (PlayerView.current_player.air_finished < GameBase.level.time && PlayerView.current_player.client.next_drown_time < GameBase.level.time && PlayerView.current_player.health > 0) {
                PlayerView.current_player.client.next_drown_time = GameBase.level.time + 1.0f;
                PlayerView.current_player.dmg += 2;
                if (PlayerView.current_player.dmg > 15) {
                    PlayerView.current_player.dmg = 15;
                }
                if (PlayerView.current_player.health <= PlayerView.current_player.dmg) {
                    GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("player/drown1.wav"), 1.0f, 1.0f, 0.0f);
                } else if ((Lib.rand() & 1) != 0) {
                    GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("*gurp1.wav"), 1.0f, 1.0f, 0.0f);
                } else {
                    GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("*gurp2.wav"), 1.0f, 1.0f, 0.0f);
                }
                PlayerView.current_player.pain_debounce_time = GameBase.level.time;
                GameCombat.T_Damage(current_player, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, PlayerView.current_player.s.origin, Globals.vec3_origin, PlayerView.current_player.dmg, 0, 2, 17);
            }
        } else {
            PlayerView.current_player.air_finished = GameBase.level.time + 12.0f;
            PlayerView.current_player.dmg = 2;
        }
        if (waterlevel != 0 && 0 != (PlayerView.current_player.watertype & 0x18)) {
            if ((PlayerView.current_player.watertype & 8) != 0) {
                if (PlayerView.current_player.health > 0 && PlayerView.current_player.pain_debounce_time <= GameBase.level.time && PlayerView.current_client.invincible_framenum < (float)GameBase.level.framenum) {
                    if ((Lib.rand() & 1) != 0) {
                        GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("player/burn1.wav"), 1.0f, 1.0f, 0.0f);
                    } else {
                        GameBase.gi.sound(current_player, 2, GameBase.gi.soundindex("player/burn2.wav"), 1.0f, 1.0f, 0.0f);
                    }
                    PlayerView.current_player.pain_debounce_time = GameBase.level.time + 1.0f;
                }
                if (envirosuit) {
                    GameCombat.T_Damage(current_player, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, PlayerView.current_player.s.origin, Globals.vec3_origin, 1 * waterlevel, 0, 0, 19);
                } else {
                    GameCombat.T_Damage(current_player, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, PlayerView.current_player.s.origin, Globals.vec3_origin, 3 * waterlevel, 0, 0, 19);
                }
            }
            if ((PlayerView.current_player.watertype & 0x10) != 0 && !envirosuit) {
                GameCombat.T_Damage(current_player, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, PlayerView.current_player.s.origin, Globals.vec3_origin, 1 * waterlevel, 0, 0, 18);
            }
        }
    }

    public static void G_SetClientEffects(edict_t ent) {
        int remaining;
        ent.s.effects = 0;
        ent.s.renderfx = 0;
        if (ent.health <= 0 || GameBase.level.intermissiontime != 0.0f) {
            return;
        }
        if (ent.powerarmor_time > GameBase.level.time) {
            int pa_type = GameItems.PowerArmorType(ent);
            if (pa_type == 1) {
                ent.s.effects |= 0x200;
            } else if (pa_type == 2) {
                ent.s.effects |= 0x100;
                ent.s.renderfx |= 0x800;
            }
        }
        if (ent.client.quad_framenum > (float)GameBase.level.framenum && ((remaining = (int)ent.client.quad_framenum - GameBase.level.framenum) > 30 || 0 != (remaining & 4))) {
            ent.s.effects |= 0x8000;
        }
        if (ent.client.invincible_framenum > (float)GameBase.level.framenum && ((remaining = (int)ent.client.invincible_framenum - GameBase.level.framenum) > 30 || 0 != (remaining & 4))) {
            ent.s.effects |= 0x10000;
        }
        if ((ent.flags & 0x10) != 0) {
            ent.s.effects |= 0x100;
            ent.s.renderfx |= 0x1C00;
        }
    }

    public static void G_SetClientEvent(edict_t ent) {
        if (ent.s.event != 0) {
            return;
        }
        if (ent.groundentity != null && xyspeed > 225.0f && (int)(PlayerView.current_client.bobtime + bobmove) != bobcycle) {
            ent.s.event = 2;
        }
    }

    public static void G_SetClientSound(edict_t ent) {
        if (ent.client.pers.game_helpchanged != GameBase.game.helpchanged) {
            ent.client.pers.game_helpchanged = GameBase.game.helpchanged;
            ent.client.pers.helpchanged = 1;
        }
        if (ent.client.pers.helpchanged != 0 && ent.client.pers.helpchanged <= 3 && 0 == (GameBase.level.framenum & 0x3F)) {
            ++ent.client.pers.helpchanged;
            GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("misc/pc_up.wav"), 1.0f, 3.0f, 0.0f);
        }
        String weap = ent.client.pers.weapon != null ? ent.client.pers.weapon.classname : "";
        ent.s.sound = ent.waterlevel != 0 && 0 != (ent.watertype & 0x18) ? GameBase.snd_fry : (Lib.strcmp(weap, "weapon_railgun") == 0 ? GameBase.gi.soundindex("weapons/rg_hum.wav") : (Lib.strcmp(weap, "weapon_bfg") == 0 ? GameBase.gi.soundindex("weapons/bfg_hum.wav") : (ent.client.weapon_sound != 0 ? ent.client.weapon_sound : 0)));
    }

    public static void G_SetClientFrame(edict_t ent) {
        if (ent.s.modelindex != 255) {
            return;
        }
        gclient_t client = ent.client;
        boolean duck = (client.ps.pmove.pm_flags & 1) != 0;
        boolean run = xyspeed != 0.0f;
        boolean skip = false;
        if (duck != client.anim_duck && client.anim_priority < 5) {
            skip = true;
        }
        if (run != client.anim_run && client.anim_priority == 0) {
            skip = true;
        }
        if (null == ent.groundentity && client.anim_priority <= 1) {
            skip = true;
        }
        if (!skip) {
            if (client.anim_priority == 6) {
                if (ent.s.frame > client.anim_end) {
                    --ent.s.frame;
                    return;
                }
            } else if (ent.s.frame < client.anim_end) {
                ++ent.s.frame;
                return;
            }
            if (client.anim_priority == 5) {
                return;
            }
            if (client.anim_priority == 2) {
                if (null == ent.groundentity) {
                    return;
                }
                ent.client.anim_priority = 1;
                ent.s.frame = 68;
                ent.client.anim_end = 71;
                return;
            }
        }
        client.anim_priority = 0;
        client.anim_duck = duck;
        client.anim_run = run;
        if (null == ent.groundentity) {
            client.anim_priority = 2;
            if (ent.s.frame != 67) {
                ent.s.frame = 66;
            }
            client.anim_end = 67;
        } else if (run) {
            if (duck) {
                ent.s.frame = 154;
                client.anim_end = 159;
            } else {
                ent.s.frame = 40;
                client.anim_end = 45;
            }
        } else if (duck) {
            ent.s.frame = 135;
            client.anim_end = 153;
        } else {
            ent.s.frame = 0;
            client.anim_end = 39;
        }
    }

    public static void ClientEndServerFrame(edict_t ent) {
        current_player = ent;
        current_client = ent.client;
        for (int i = 0; i < 3; ++i) {
            PlayerView.current_client.ps.pmove.origin[i] = (short)((double)ent.s.origin[i] * 8.0);
            PlayerView.current_client.ps.pmove.velocity[i] = (short)((double)ent.velocity[i] * 8.0);
        }
        if (GameBase.level.intermissiontime != 0.0f) {
            PlayerView.current_client.ps.blend[3] = 0.0f;
            PlayerView.current_client.ps.fov = 90.0f;
            PlayerHud.G_SetStats(ent);
            return;
        }
        Math3D.AngleVectors(ent.client.v_angle, forward, right, up);
        PlayerView.P_WorldEffects();
        ent.s.angles[0] = ent.client.v_angle[0] > 180.0f ? (-360.0f + ent.client.v_angle[0]) / 3.0f : ent.client.v_angle[0] / 3.0f;
        ent.s.angles[1] = ent.client.v_angle[1];
        ent.s.angles[2] = 0.0f;
        ent.s.angles[2] = PlayerView.SV_CalcRoll(ent.s.angles, ent.velocity) * 4.0f;
        xyspeed = (float)Math.sqrt(ent.velocity[0] * ent.velocity[0] + ent.velocity[1] * ent.velocity[1]);
        if (xyspeed < 5.0f) {
            bobmove = 0.0f;
            PlayerView.current_client.bobtime = 0.0f;
        } else if (ent.groundentity != null) {
            bobmove = xyspeed > 210.0f ? 0.25f : (xyspeed > 100.0f ? 0.125f : 0.0625f);
        }
        float bobtime = PlayerView.current_client.bobtime += bobmove;
        if ((PlayerView.current_client.ps.pmove.pm_flags & 1) != 0) {
            bobtime *= 4.0f;
        }
        bobcycle = (int)bobtime;
        bobfracsin = (float)Math.abs(Math.sin((double)bobtime * Math.PI));
        PlayerView.P_FallingDamage(ent);
        PlayerView.P_DamageFeedback(ent);
        PlayerView.SV_CalcViewOffset(ent);
        PlayerView.SV_CalcGunOffset(ent);
        PlayerView.SV_CalcBlend(ent);
        if (ent.client.resp.spectator) {
            PlayerHud.G_SetSpectatorStats(ent);
        } else {
            PlayerHud.G_SetStats(ent);
        }
        PlayerHud.G_CheckChaseStats(ent);
        PlayerView.G_SetClientEvent(ent);
        PlayerView.G_SetClientEffects(ent);
        PlayerView.G_SetClientSound(ent);
        PlayerView.G_SetClientFrame(ent);
        Math3D.VectorCopy(ent.velocity, ent.client.oldvelocity);
        Math3D.VectorCopy(ent.client.ps.viewangles, ent.client.oldviewangles);
        Math3D.VectorClear(ent.client.kick_origin);
        Math3D.VectorClear(ent.client.kick_angles);
        if (ent.client.showscores && 0 == (GameBase.level.framenum & 0x1F)) {
            PlayerHud.DeathmatchScoreboardMessage(ent, ent.enemy);
            GameBase.gi.unicast(ent, false);
        }
    }

    static {
        forward = new float[]{0.0f, 0.0f, 0.0f};
        right = new float[]{0.0f, 0.0f, 0.0f};
        up = new float[]{0.0f, 0.0f, 0.0f};
        xxxi = 0;
    }
}

