/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.GameBase;
import jake2.game.GameUtil;
import jake2.game.edict_t;
import jake2.util.Math3D;

public class PlayerTrail {
    static int TRAIL_LENGTH = 8;
    static edict_t[] trail = new edict_t[TRAIL_LENGTH];
    static int trail_head;
    static boolean trail_active;

    static int NEXT(int n) {
        return (n + 1) % TRAIL_LENGTH;
    }

    static int PREV(int n) {
        return (n + TRAIL_LENGTH - 1) % TRAIL_LENGTH;
    }

    static void Init() {
        if (GameBase.deathmatch.value != 0.0f) {
            return;
        }
        for (int n = 0; n < TRAIL_LENGTH; ++n) {
            PlayerTrail.trail[n] = GameUtil.G_Spawn();
            PlayerTrail.trail[n].classname = "player_trail";
        }
        trail_head = 0;
        trail_active = true;
    }

    static void Add(float[] spot) {
        float[] temp = new float[]{0.0f, 0.0f, 0.0f};
        if (!trail_active) {
            return;
        }
        Math3D.VectorCopy(spot, PlayerTrail.trail[PlayerTrail.trail_head].s.origin);
        PlayerTrail.trail[PlayerTrail.trail_head].timestamp = GameBase.level.time;
        Math3D.VectorSubtract(spot, PlayerTrail.trail[PlayerTrail.PREV((int)PlayerTrail.trail_head)].s.origin, temp);
        PlayerTrail.trail[PlayerTrail.trail_head].s.angles[1] = Math3D.vectoyaw(temp);
        trail_head = PlayerTrail.NEXT(trail_head);
    }

    static void New(float[] spot) {
        if (!trail_active) {
            return;
        }
        PlayerTrail.Init();
        PlayerTrail.Add(spot);
    }

    static edict_t PickFirst(edict_t self) {
        if (!trail_active) {
            return null;
        }
        int marker = trail_head;
        for (int n = TRAIL_LENGTH; n > 0 && PlayerTrail.trail[marker].timestamp <= self.monsterinfo.trail_time; --n) {
            marker = PlayerTrail.NEXT(marker);
        }
        if (GameUtil.visible(self, trail[marker])) {
            return trail[marker];
        }
        if (GameUtil.visible(self, trail[PlayerTrail.PREV(marker)])) {
            return trail[PlayerTrail.PREV(marker)];
        }
        return trail[marker];
    }

    static edict_t PickNext(edict_t self) {
        if (!trail_active) {
            return null;
        }
        int marker = trail_head;
        for (int n = TRAIL_LENGTH; n > 0 && PlayerTrail.trail[marker].timestamp <= self.monsterinfo.trail_time; --n) {
            marker = PlayerTrail.NEXT(marker);
        }
        return trail[marker];
    }

    static edict_t LastSpot() {
        return trail[PlayerTrail.PREV(trail_head)];
    }

    static {
        trail_active = false;
        for (int n = 0; n < TRAIL_LENGTH; ++n) {
            PlayerTrail.trail[n] = new edict_t(n);
        }
    }
}

