/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.EdictIterator;
import jake2.game.GameBase;
import jake2.game.GameItemList;
import jake2.game.GameItems;
import jake2.game.PlayerClient;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.game.gitem_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import jake2.util.Math3D;
import jake2.util.Vargs;

public class PlayerHud {
    public static void MoveClientToIntermission(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f || GameBase.coop.value != 0.0f) {
            ent.client.showscores = true;
        }
        Math3D.VectorCopy(GameBase.level.intermission_origin, ent.s.origin);
        ent.client.ps.pmove.origin[0] = (short)(GameBase.level.intermission_origin[0] * 8.0f);
        ent.client.ps.pmove.origin[1] = (short)(GameBase.level.intermission_origin[1] * 8.0f);
        ent.client.ps.pmove.origin[2] = (short)(GameBase.level.intermission_origin[2] * 8.0f);
        Math3D.VectorCopy(GameBase.level.intermission_angle, ent.client.ps.viewangles);
        ent.client.ps.pmove.pm_type = 4;
        ent.client.ps.gunindex = 0;
        ent.client.ps.blend[3] = 0.0f;
        ent.client.ps.rdflags &= 0xFFFFFFFE;
        ent.client.quad_framenum = 0.0f;
        ent.client.invincible_framenum = 0.0f;
        ent.client.breather_framenum = 0.0f;
        ent.client.enviro_framenum = 0.0f;
        ent.client.grenade_blew_up = false;
        ent.client.grenade_time = 0.0f;
        ent.viewheight = 0;
        ent.s.modelindex = 0;
        ent.s.modelindex2 = 0;
        ent.s.modelindex3 = 0;
        ent.s.modelindex = 0;
        ent.s.effects = 0;
        ent.s.sound = 0;
        ent.solid = 0;
        if (GameBase.deathmatch.value != 0.0f || GameBase.coop.value != 0.0f) {
            PlayerHud.DeathmatchScoreboardMessage(ent, null);
            GameBase.gi.unicast(ent, true);
        }
    }

    public static void BeginIntermission(edict_t targ) {
        edict_t client;
        if (GameBase.level.intermissiontime != 0.0f) {
            return;
        }
        GameBase.game.autosaved = false;
        int i = 0;
        while ((float)i < GameBase.maxclients.value) {
            client = GameBase.g_edicts[1 + i];
            if (client.inuse && client.health <= 0) {
                PlayerClient.respawn(client);
            }
            ++i;
        }
        GameBase.level.intermissiontime = GameBase.level.time;
        GameBase.level.changemap = targ.map;
        if (GameBase.level.changemap.indexOf(42) > -1) {
            if (GameBase.coop.value != 0.0f) {
                i = 0;
                while ((float)i < GameBase.maxclients.value) {
                    client = GameBase.g_edicts[1 + i];
                    if (client.inuse) {
                        for (int n = 1; n < GameItemList.itemlist.length; ++n) {
                            if (GameItemList.itemlist[n] == null || (GameItemList.itemlist[n].flags & 0x10) == 0) continue;
                            client.client.pers.inventory[n] = 0;
                        }
                    }
                    ++i;
                }
            }
        } else if (0.0f == GameBase.deathmatch.value) {
            GameBase.level.exitintermission = true;
            return;
        }
        GameBase.level.exitintermission = false;
        edict_t ent = GameBase.G_FindEdict(null, GameBase.findByClass, "info_player_intermission");
        if (ent == null) {
            ent = GameBase.G_FindEdict(null, GameBase.findByClass, "info_player_start");
            if (ent == null) {
                ent = GameBase.G_FindEdict(null, GameBase.findByClass, "info_player_deathmatch");
            }
        } else {
            i = Lib.rand() & 3;
            EdictIterator es = null;
            while (i-- > 0) {
                if ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_intermission")) == null) continue;
                ent = es.o;
            }
        }
        Math3D.VectorCopy(ent.s.origin, GameBase.level.intermission_origin);
        Math3D.VectorCopy(ent.s.angles, GameBase.level.intermission_angle);
        i = 0;
        while ((float)i < GameBase.maxclients.value) {
            client = GameBase.g_edicts[1 + i];
            if (client.inuse) {
                PlayerHud.MoveClientToIntermission(client);
            }
            ++i;
        }
    }

    public static void DeathmatchScoreboardMessage(edict_t ent, edict_t killer) {
        edict_t cl_ent;
        int i;
        StringBuffer string = new StringBuffer(1400);
        int[] sorted = new int[256];
        int[] sortedscores = new int[256];
        int total = 0;
        for (i = 0; i < GameBase.game.maxclients; ++i) {
            int j;
            cl_ent = GameBase.g_edicts[1 + i];
            if (!cl_ent.inuse || GameBase.game.clients[i].resp.spectator) continue;
            int score = GameBase.game.clients[i].resp.score;
            for (j = 0; j < total && score <= sortedscores[j]; ++j) {
            }
            for (int k = total; k > j; --k) {
                sorted[k] = sorted[k - 1];
                sortedscores[k] = sortedscores[k - 1];
            }
            sorted[j] = i;
            sortedscores[j] = score;
            ++total;
        }
        if (total > 12) {
            total = 12;
        }
        for (i = 0; i < total; ++i) {
            gclient_t cl = GameBase.game.clients[sorted[i]];
            cl_ent = GameBase.g_edicts[1 + sorted[i]];
            int picnum = GameBase.gi.imageindex("i_fixme");
            int x = i >= 6 ? 160 : 0;
            int y = 32 + 32 * (i % 6);
            String tag = cl_ent == ent ? "tag1" : (cl_ent == killer ? "tag2" : null);
            if (tag != null) {
                string.append("xv ").append(x + 32).append(" yv ").append(y).append(" picn ").append(tag);
            }
            string.append(" client ").append(x).append(" ").append(y).append(" ").append(sorted[i]).append(" ").append(cl.resp.score).append(" ").append(cl.ping).append(" ").append((GameBase.level.framenum - cl.resp.enterframe) / 600);
        }
        GameBase.gi.WriteByte(4);
        GameBase.gi.WriteString(string.toString());
    }

    public static void DeathmatchScoreboard(edict_t ent) {
        PlayerHud.DeathmatchScoreboardMessage(ent, ent.enemy);
        GameBase.gi.unicast(ent, true);
    }

    public static void Cmd_Score_f(edict_t ent) {
        ent.client.showinventory = false;
        ent.client.showhelp = false;
        if (0.0f == GameBase.deathmatch.value && 0.0f == GameBase.coop.value) {
            return;
        }
        if (ent.client.showscores) {
            ent.client.showscores = false;
            return;
        }
        ent.client.showscores = true;
        PlayerHud.DeathmatchScoreboard(ent);
    }

    public static void G_SetStats(edict_t ent) {
        gitem_t item;
        int cells = 0;
        ent.client.ps.stats[0] = (short)GameBase.level.pic_health;
        ent.client.ps.stats[1] = (short)ent.health;
        if (0 == ent.client.ammo_index) {
            ent.client.ps.stats[2] = 0;
            ent.client.ps.stats[3] = 0;
        } else {
            item = GameItemList.itemlist[ent.client.ammo_index];
            ent.client.ps.stats[2] = (short)GameBase.gi.imageindex(item.icon);
            ent.client.ps.stats[3] = (short)ent.client.pers.inventory[ent.client.ammo_index];
        }
        int power_armor_type = GameItems.PowerArmorType(ent);
        if (power_armor_type != 0 && (cells = ent.client.pers.inventory[GameItems.ITEM_INDEX(GameItems.FindItem("cells"))]) == 0) {
            ent.flags &= 0xFFFFEFFF;
            GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("misc/power2.wav"), 1.0f, 1.0f, 0.0f);
            power_armor_type = 0;
        }
        int index = GameItems.ArmorIndex(ent);
        if (power_armor_type != 0 && (0 == index || 0 != (GameBase.level.framenum & 8))) {
            ent.client.ps.stats[4] = (short)GameBase.gi.imageindex("i_powershield");
            ent.client.ps.stats[5] = (short)cells;
        } else if (index != 0) {
            item = GameItems.GetItemByIndex(index);
            ent.client.ps.stats[4] = (short)GameBase.gi.imageindex(item.icon);
            ent.client.ps.stats[5] = (short)ent.client.pers.inventory[index];
        } else {
            ent.client.ps.stats[4] = 0;
            ent.client.ps.stats[5] = 0;
        }
        if (GameBase.level.time > ent.client.pickup_msg_time) {
            ent.client.ps.stats[7] = 0;
            ent.client.ps.stats[8] = 0;
        }
        if (ent.client.quad_framenum > (float)GameBase.level.framenum) {
            ent.client.ps.stats[9] = (short)GameBase.gi.imageindex("p_quad");
            ent.client.ps.stats[10] = (short)((ent.client.quad_framenum - (float)GameBase.level.framenum) / 10.0f);
        } else if (ent.client.invincible_framenum > (float)GameBase.level.framenum) {
            ent.client.ps.stats[9] = (short)GameBase.gi.imageindex("p_invulnerability");
            ent.client.ps.stats[10] = (short)((ent.client.invincible_framenum - (float)GameBase.level.framenum) / 10.0f);
        } else if (ent.client.enviro_framenum > (float)GameBase.level.framenum) {
            ent.client.ps.stats[9] = (short)GameBase.gi.imageindex("p_envirosuit");
            ent.client.ps.stats[10] = (short)((ent.client.enviro_framenum - (float)GameBase.level.framenum) / 10.0f);
        } else if (ent.client.breather_framenum > (float)GameBase.level.framenum) {
            ent.client.ps.stats[9] = (short)GameBase.gi.imageindex("p_rebreather");
            ent.client.ps.stats[10] = (short)((ent.client.breather_framenum - (float)GameBase.level.framenum) / 10.0f);
        } else {
            ent.client.ps.stats[9] = 0;
            ent.client.ps.stats[10] = 0;
        }
        ent.client.ps.stats[6] = ent.client.pers.selected_item <= 0 ? (short)0 : (short)GameBase.gi.imageindex(GameItemList.itemlist[ent.client.pers.selected_item].icon);
        ent.client.ps.stats[12] = (short)ent.client.pers.selected_item;
        ent.client.ps.stats[13] = 0;
        if (GameBase.deathmatch.value != 0.0f) {
            if (ent.client.pers.health <= 0 || GameBase.level.intermissiontime != 0.0f || ent.client.showscores) {
                ent.client.ps.stats[13] = (short)(ent.client.ps.stats[13] | 1);
            }
            if (ent.client.showinventory && ent.client.pers.health > 0) {
                ent.client.ps.stats[13] = (short)(ent.client.ps.stats[13] | 2);
            }
        } else {
            if (ent.client.showscores || ent.client.showhelp) {
                ent.client.ps.stats[13] = (short)(ent.client.ps.stats[13] | 1);
            }
            if (ent.client.showinventory && ent.client.pers.health > 0) {
                ent.client.ps.stats[13] = (short)(ent.client.ps.stats[13] | 2);
            }
        }
        ent.client.ps.stats[14] = (short)ent.client.resp.score;
        ent.client.ps.stats[11] = ent.client.pers.helpchanged != 0 && (GameBase.level.framenum & 8) != 0 ? (short)GameBase.gi.imageindex("i_help") : ((ent.client.pers.hand == 2 || ent.client.ps.fov > 91.0f) && ent.client.pers.weapon != null ? (short)GameBase.gi.imageindex(ent.client.pers.weapon.icon) : (short)0);
        ent.client.ps.stats[17] = 0;
    }

    public static void G_CheckChaseStats(edict_t ent) {
        int i = 1;
        while ((float)i <= GameBase.maxclients.value) {
            gclient_t cl = GameBase.g_edicts[i].client;
            if (GameBase.g_edicts[i].inuse && cl.chase_target == ent) {
                System.arraycopy(ent.client.ps.stats, 0, cl.ps.stats, 0, 32);
                PlayerHud.G_SetSpectatorStats(GameBase.g_edicts[i]);
            }
            ++i;
        }
    }

    public static void G_SetSpectatorStats(edict_t ent) {
        gclient_t cl = ent.client;
        if (null == cl.chase_target) {
            PlayerHud.G_SetStats(ent);
        }
        cl.ps.stats[17] = 1;
        cl.ps.stats[13] = 0;
        if (cl.pers.health <= 0 || GameBase.level.intermissiontime != 0.0f || cl.showscores) {
            cl.ps.stats[13] = (short)(cl.ps.stats[13] | 1);
        }
        if (cl.showinventory && cl.pers.health > 0) {
            cl.ps.stats[13] = (short)(cl.ps.stats[13] | 2);
        }
        cl.ps.stats[16] = cl.chase_target != null && cl.chase_target.inuse ? (short)(1312 + cl.chase_target.index - 1) : (short)0;
    }

    public static void HelpComputer(edict_t ent) {
        StringBuffer sb = new StringBuffer(256);
        String sk = GameBase.skill.value == 0.0f ? "easy" : (GameBase.skill.value == 1.0f ? "medium" : (GameBase.skill.value == 2.0f ? "hard" : "hard+"));
        sb.append("xv 32 yv 8 picn help ");
        sb.append("xv 202 yv 12 string2 \"").append(sk).append("\" ");
        sb.append("xv 0 yv 24 cstring2 \"").append(GameBase.level.level_name).append("\" ");
        sb.append("xv 0 yv 54 cstring2 \"").append(GameBase.game.helpmessage1).append("\" ");
        sb.append("xv 0 yv 110 cstring2 \"").append(GameBase.game.helpmessage2).append("\" ");
        sb.append("xv 50 yv 164 string2 \" kills     goals    secrets\" ");
        sb.append("xv 50 yv 172 string2 \"");
        sb.append(Com.sprintf("%3i/%3i     %i/%i       %i/%i\" ", new Vargs(6).add(GameBase.level.killed_monsters).add(GameBase.level.total_monsters).add(GameBase.level.found_goals).add(GameBase.level.total_goals).add(GameBase.level.found_secrets).add(GameBase.level.total_secrets)));
        GameBase.gi.WriteByte(4);
        GameBase.gi.WriteString(sb.toString());
        GameBase.gi.unicast(ent, true);
    }
}

