/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.Cmd;
import jake2.game.EdictIterator;
import jake2.game.EntDieAdapter;
import jake2.game.EntPainAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.GameBase;
import jake2.game.GameChase;
import jake2.game.GameItemList;
import jake2.game.GameItems;
import jake2.game.GameMisc;
import jake2.game.GameSVCmds;
import jake2.game.GameUtil;
import jake2.game.Info;
import jake2.game.PlayerHud;
import jake2.game.PlayerTrail;
import jake2.game.PlayerView;
import jake2.game.PlayerWeapon;
import jake2.game.client_persistant_t;
import jake2.game.client_respawn_t;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.game.gitem_t;
import jake2.game.pmove_t;
import jake2.game.trace_t;
import jake2.game.usercmd_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class PlayerClient {
    public static int player_die_i = 0;
    static EntDieAdapter player_die = new EntDieAdapter(){

        public String getID() {
            return "player_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            int n;
            Math3D.VectorClear(self.avelocity);
            self.takedamage = 1;
            self.movetype = 7;
            self.s.modelindex2 = 0;
            self.s.angles[0] = 0.0f;
            self.s.angles[2] = 0.0f;
            self.s.sound = 0;
            self.client.weapon_sound = 0;
            self.maxs[2] = -8.0f;
            self.svflags |= 2;
            if (self.deadflag == 0) {
                self.client.respawn_time = GameBase.level.time + 1.0f;
                PlayerClient.LookAtKiller(self, inflictor, attacker);
                self.client.ps.pmove.pm_type = 2;
                PlayerClient.ClientObituary(self, inflictor, attacker);
                PlayerClient.TossClientWeapon(self);
                if (GameBase.deathmatch.value != 0.0f) {
                    Cmd.Help_f(self);
                }
                for (n = 0; n < GameBase.game.num_items; ++n) {
                    if (GameBase.coop.value != 0.0f && (GameItemList.itemlist[n].flags & 0x10) != 0) {
                        self.client.resp.coop_respawn.inventory[n] = self.client.pers.inventory[n];
                    }
                    self.client.pers.inventory[n] = 0;
                }
            }
            self.client.quad_framenum = 0.0f;
            self.client.invincible_framenum = 0.0f;
            self.client.breather_framenum = 0.0f;
            self.client.enviro_framenum = 0.0f;
            self.flags &= 0xFFFFEFFF;
            if (self.health < -40) {
                GameBase.gi.sound(self, 4, GameBase.gi.soundindex("misc/udeath.wav"), 1.0f, 1.0f, 0.0f);
                for (n = 0; n < 4; ++n) {
                    GameMisc.ThrowGib(self, "models/objects/gibs/sm_meat/tris.md2", damage, 0);
                }
                GameMisc.ThrowClientHead(self, damage);
                self.takedamage = 0;
            } else if (self.deadflag == 0) {
                player_die_i = (player_die_i + 1) % 3;
                self.client.anim_priority = 5;
                if ((self.client.ps.pmove.pm_flags & 1) != 0) {
                    self.s.frame = 172;
                    self.client.anim_end = 177;
                } else {
                    switch (player_die_i) {
                        case 0: {
                            self.s.frame = 177;
                            self.client.anim_end = 183;
                            break;
                        }
                        case 1: {
                            self.s.frame = 183;
                            self.client.anim_end = 189;
                            break;
                        }
                        case 2: {
                            self.s.frame = 189;
                            self.client.anim_end = 197;
                        }
                    }
                }
                GameBase.gi.sound(self, 2, GameBase.gi.soundindex("*death" + (Lib.rand() % 4 + 1) + ".wav"), 1.0f, 1.0f, 0.0f);
            }
            self.deadflag = 2;
            GameBase.gi.linkentity(self);
        }
    };
    static EntThinkAdapter SP_FixCoopSpots = new EntThinkAdapter(){

        public String getID() {
            return "SP_FixCoopSpots";
        }

        public boolean think(edict_t self) {
            float[] d = new float[]{0.0f, 0.0f, 0.0f};
            edict_t spot = null;
            EdictIterator es = null;
            while (true) {
                if ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_start")) == null) {
                    return true;
                }
                spot = es.o;
                if (spot.targetname == null) continue;
                Math3D.VectorSubtract(self.s.origin, spot.s.origin, d);
                if (Math3D.VectorLength(d) < 384.0f) break;
            }
            if (self.targetname == null || Lib.Q_stricmp(self.targetname, spot.targetname) != 0) {
                self.targetname = spot.targetname;
            }
            return true;
        }
    };
    static EntThinkAdapter SP_CreateCoopSpots = new EntThinkAdapter(){

        public String getID() {
            return "SP_CreateCoopSpots";
        }

        public boolean think(edict_t self) {
            if (Lib.Q_stricmp(GameBase.level.mapname, "security") == 0) {
                edict_t spot = GameUtil.G_Spawn();
                spot.classname = "info_player_coop";
                spot.s.origin[0] = 124.0f;
                spot.s.origin[1] = -164.0f;
                spot.s.origin[2] = 80.0f;
                spot.targetname = "jail3";
                spot.s.angles[1] = 90.0f;
                spot = GameUtil.G_Spawn();
                spot.classname = "info_player_coop";
                spot.s.origin[0] = 252.0f;
                spot.s.origin[1] = -164.0f;
                spot.s.origin[2] = 80.0f;
                spot.targetname = "jail3";
                spot.s.angles[1] = 90.0f;
                spot = GameUtil.G_Spawn();
                spot.classname = "info_player_coop";
                spot.s.origin[0] = 316.0f;
                spot.s.origin[1] = -164.0f;
                spot.s.origin[2] = 80.0f;
                spot.targetname = "jail3";
                spot.s.angles[1] = 90.0f;
            }
            return true;
        }
    };
    static EntPainAdapter player_pain = new EntPainAdapter(){

        public String getID() {
            return "player_pain";
        }

        public void pain(edict_t self, edict_t other, float kick, int damage) {
        }
    };
    static EntDieAdapter body_die = new EntDieAdapter(){

        public String getID() {
            return "body_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            if (self.health < -40) {
                GameBase.gi.sound(self, 4, GameBase.gi.soundindex("misc/udeath.wav"), 1.0f, 1.0f, 0.0f);
                for (int n = 0; n < 4; ++n) {
                    GameMisc.ThrowGib(self, "models/objects/gibs/sm_meat/tris.md2", damage, 0);
                }
                self.s.origin[2] = self.s.origin[2] - 48.0f;
                GameMisc.ThrowClientHead(self, damage);
                self.takedamage = 0;
            }
        }
    };
    static edict_t pm_passent;
    public static pmove_t.TraceAdapter PM_trace;

    public static void SP_info_player_start(edict_t self) {
        if (GameBase.coop.value == 0.0f) {
            return;
        }
        if (Lib.Q_stricmp(GameBase.level.mapname, "security") == 0) {
            self.think = SP_CreateCoopSpots;
            self.nextthink = GameBase.level.time + 0.1f;
        }
    }

    public static void SP_info_player_deathmatch(edict_t self) {
        if (0.0f == GameBase.deathmatch.value) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        GameMisc.SP_misc_teleporter_dest.think(self);
    }

    public static void SP_info_player_coop(edict_t self) {
        if (0.0f == GameBase.coop.value) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        if (Lib.Q_stricmp(GameBase.level.mapname, "jail2") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "jail4") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "mine1") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "mine2") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "mine3") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "mine4") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "lab") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "boss1") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "fact3") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "biggun") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "space") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "command") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "power2") == 0 || Lib.Q_stricmp(GameBase.level.mapname, "strike") == 0) {
            self.think = SP_FixCoopSpots;
            self.nextthink = GameBase.level.time + 0.1f;
        }
    }

    public static void SP_info_player_intermission() {
    }

    public static void ClientObituary(edict_t self, edict_t inflictor, edict_t attacker) {
        if (GameBase.coop.value != 0.0f && attacker.client != null) {
            GameBase.meansOfDeath |= 0x8000000;
        }
        if (GameBase.deathmatch.value != 0.0f || GameBase.coop.value != 0.0f) {
            boolean ff = (GameBase.meansOfDeath & 0x8000000) != 0;
            int mod = GameBase.meansOfDeath & 0xF7FFFFFF;
            String message = null;
            String message2 = "";
            switch (mod) {
                case 23: {
                    message = "suicides";
                    break;
                }
                case 22: {
                    message = "cratered";
                    break;
                }
                case 20: {
                    message = "was squished";
                    break;
                }
                case 17: {
                    message = "sank like a rock";
                    break;
                }
                case 18: {
                    message = "melted";
                    break;
                }
                case 19: {
                    message = "does a back flip into the lava";
                    break;
                }
                case 25: 
                case 26: {
                    message = "blew up";
                    break;
                }
                case 28: {
                    message = "found a way out";
                    break;
                }
                case 30: {
                    message = "saw the light";
                    break;
                }
                case 33: {
                    message = "got blasted";
                    break;
                }
                case 27: 
                case 29: 
                case 31: {
                    message = "was in the wrong place";
                }
            }
            if (attacker == self) {
                switch (mod) {
                    case 24: {
                        message = "tried to put the pin back in";
                        break;
                    }
                    case 7: 
                    case 16: {
                        if (PlayerClient.IsNeutral(self)) {
                            message = "tripped on its own grenade";
                            break;
                        }
                        if (PlayerClient.IsFemale(self)) {
                            message = "tripped on her own grenade";
                            break;
                        }
                        message = "tripped on his own grenade";
                        break;
                    }
                    case 9: {
                        if (PlayerClient.IsNeutral(self)) {
                            message = "blew itself up";
                            break;
                        }
                        if (PlayerClient.IsFemale(self)) {
                            message = "blew herself up";
                            break;
                        }
                        message = "blew himself up";
                        break;
                    }
                    case 13: {
                        message = "should have used a smaller gun";
                        break;
                    }
                    default: {
                        message = PlayerClient.IsNeutral(self) ? "killed itself" : (PlayerClient.IsFemale(self) ? "killed herself" : "killed himself");
                    }
                }
            }
            if (message != null) {
                GameBase.gi.bprintf(1, self.client.pers.netname + " " + message + ".\n");
                if (GameBase.deathmatch.value != 0.0f) {
                    --self.client.resp.score;
                }
                self.enemy = null;
                return;
            }
            self.enemy = attacker;
            if (attacker != null && attacker.client != null) {
                switch (mod) {
                    case 1: {
                        message = "was blasted by";
                        break;
                    }
                    case 2: {
                        message = "was gunned down by";
                        break;
                    }
                    case 3: {
                        message = "was blown away by";
                        message2 = "'s super shotgun";
                        break;
                    }
                    case 4: {
                        message = "was machinegunned by";
                        break;
                    }
                    case 5: {
                        message = "was cut in half by";
                        message2 = "'s chaingun";
                        break;
                    }
                    case 6: {
                        message = "was popped by";
                        message2 = "'s grenade";
                        break;
                    }
                    case 7: {
                        message = "was shredded by";
                        message2 = "'s shrapnel";
                        break;
                    }
                    case 8: {
                        message = "ate";
                        message2 = "'s rocket";
                        break;
                    }
                    case 9: {
                        message = "almost dodged";
                        message2 = "'s rocket";
                        break;
                    }
                    case 10: {
                        message = "was melted by";
                        message2 = "'s hyperblaster";
                        break;
                    }
                    case 11: {
                        message = "was railed by";
                        break;
                    }
                    case 12: {
                        message = "saw the pretty lights from";
                        message2 = "'s BFG";
                        break;
                    }
                    case 13: {
                        message = "was disintegrated by";
                        message2 = "'s BFG blast";
                        break;
                    }
                    case 14: {
                        message = "couldn't hide from";
                        message2 = "'s BFG";
                        break;
                    }
                    case 15: {
                        message = "caught";
                        message2 = "'s handgrenade";
                        break;
                    }
                    case 16: {
                        message = "didn't see";
                        message2 = "'s handgrenade";
                        break;
                    }
                    case 24: {
                        message = "feels";
                        message2 = "'s pain";
                        break;
                    }
                    case 21: {
                        message = "tried to invade";
                        message2 = "'s personal space";
                    }
                }
                if (message != null) {
                    GameBase.gi.bprintf(1, self.client.pers.netname + " " + message + " " + attacker.client.pers.netname + " " + message2 + "\n");
                    if (GameBase.deathmatch.value != 0.0f) {
                        attacker.client.resp.score = ff ? --attacker.client.resp.score : ++attacker.client.resp.score;
                    }
                    return;
                }
            }
        }
        GameBase.gi.bprintf(1, self.client.pers.netname + " died.\n");
        if (GameBase.deathmatch.value != 0.0f) {
            --self.client.resp.score;
        }
    }

    public static void InitClientPersistant(gclient_t client) {
        client.pers = new client_persistant_t();
        gitem_t item = GameItems.FindItem("Blaster");
        client.pers.selected_item = GameItems.ITEM_INDEX(item);
        client.pers.inventory[client.pers.selected_item] = 1;
        client.pers.weapon = item;
        client.pers.health = 100;
        client.pers.max_health = 100;
        client.pers.max_bullets = 200;
        client.pers.max_shells = 100;
        client.pers.max_rockets = 50;
        client.pers.max_grenades = 50;
        client.pers.max_cells = 200;
        client.pers.max_slugs = 50;
        client.pers.connected = true;
    }

    public static void InitClientResp(gclient_t client) {
        client.resp.clear();
        client.resp.enterframe = GameBase.level.framenum;
        client.resp.coop_respawn.set(client.pers);
    }

    public static void SaveClientData() {
        for (int i = 0; i < GameBase.game.maxclients; ++i) {
            edict_t ent = GameBase.g_edicts[1 + i];
            if (!ent.inuse) continue;
            GameBase.game.clients[i].pers.health = ent.health;
            GameBase.game.clients[i].pers.max_health = ent.max_health;
            GameBase.game.clients[i].pers.savedFlags = ent.flags & 0x1030;
            if (GameBase.coop.value == 0.0f) continue;
            GameBase.game.clients[i].pers.score = ent.client.resp.score;
        }
    }

    public static void FetchClientEntData(edict_t ent) {
        ent.health = ent.client.pers.health;
        ent.max_health = ent.client.pers.max_health;
        ent.flags |= ent.client.pers.savedFlags;
        if (GameBase.coop.value != 0.0f) {
            ent.client.resp.score = ent.client.pers.score;
        }
    }

    static float PlayersRangeFromSpot(edict_t spot) {
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        float bestplayerdistance = 9999999.0f;
        int n = 1;
        while ((float)n <= GameBase.maxclients.value) {
            edict_t player = GameBase.g_edicts[n];
            if (player.inuse && player.health > 0) {
                Math3D.VectorSubtract(spot.s.origin, player.s.origin, v);
                float playerdistance = Math3D.VectorLength(v);
                if (playerdistance < bestplayerdistance) {
                    bestplayerdistance = playerdistance;
                }
            }
            ++n;
        }
        return bestplayerdistance;
    }

    public static edict_t SelectRandomDeathmatchSpawnPoint() {
        int count = 0;
        edict_t spot = null;
        float range2 = 99999.0f;
        float range1 = 99999.0f;
        edict_t spot2 = null;
        edict_t spot1 = null;
        EdictIterator es = null;
        while ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_deathmatch")) != null) {
            spot = es.o;
            ++count;
            float range = PlayerClient.PlayersRangeFromSpot(spot);
            if (range < range1) {
                range1 = range;
                spot1 = spot;
                continue;
            }
            if (!(range < range2)) continue;
            range2 = range;
            spot2 = spot;
        }
        if (count == 0) {
            return null;
        }
        if (count <= 2) {
            spot2 = null;
            spot1 = null;
        } else {
            count -= 2;
        }
        int selection = Lib.rand() % count;
        spot = null;
        es = null;
        while ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_deathmatch")) != null) {
            spot = es.o;
            if (spot == spot1 || spot == spot2) {
                // empty if block
            }
            int n = ++selection;
            --selection;
            if (n > 0) continue;
        }
        return spot;
    }

    static edict_t SelectFarthestDeathmatchSpawnPoint() {
        edict_t spot = null;
        edict_t bestspot = null;
        float bestdistance = 0.0f;
        EdictIterator es = null;
        while ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_deathmatch")) != null) {
            spot = es.o;
            float bestplayerdistance = PlayerClient.PlayersRangeFromSpot(spot);
            if (!(bestplayerdistance > bestdistance)) continue;
            bestspot = spot;
            bestdistance = bestplayerdistance;
        }
        if (bestspot != null) {
            return bestspot;
        }
        EdictIterator edit = GameBase.G_Find(null, GameBase.findByClass, "info_player_deathmatch");
        if (edit == null) {
            return null;
        }
        return edit.o;
    }

    public static edict_t SelectDeathmatchSpawnPoint() {
        if (0 != ((int)GameBase.dmflags.value & 0x200)) {
            return PlayerClient.SelectFarthestDeathmatchSpawnPoint();
        }
        return PlayerClient.SelectRandomDeathmatchSpawnPoint();
    }

    public static edict_t SelectCoopSpawnPoint(edict_t ent) {
        String target;
        edict_t spot = null;
        int index = ent.client.index;
        if (index == 0) {
            return null;
        }
        spot = null;
        EdictIterator es = null;
        do {
            if ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_coop")) == null) {
                return null;
            }
            spot = es.o;
            if (spot == null) {
                return null;
            }
            target = spot.targetname;
            if (target != null) continue;
            target = "";
        } while (Lib.Q_stricmp(GameBase.game.spawnpoint, target) != 0 || 0 != --index);
        return spot;
    }

    public static void SelectSpawnPoint(edict_t ent, float[] origin, float[] angles) {
        edict_t spot = null;
        if (GameBase.deathmatch.value != 0.0f) {
            spot = PlayerClient.SelectDeathmatchSpawnPoint();
        } else if (GameBase.coop.value != 0.0f) {
            spot = PlayerClient.SelectCoopSpawnPoint(ent);
        }
        EdictIterator es = null;
        if (null == spot) {
            while ((es = GameBase.G_Find(es, GameBase.findByClass, "info_player_start")) != null) {
                spot = es.o;
                if ((GameBase.game.spawnpoint.length() != 0 || spot.targetname != null) && (GameBase.game.spawnpoint.length() == 0 || spot.targetname == null || Lib.Q_stricmp(GameBase.game.spawnpoint, spot.targetname) != 0)) continue;
            }
            if (null == spot) {
                if (GameBase.game.spawnpoint.length() == 0 && (es = GameBase.G_Find(es, GameBase.findByClass, "info_player_start")) != null) {
                    spot = es.o;
                }
                if (null == spot) {
                    GameBase.gi.error("Couldn't find spawn point " + GameBase.game.spawnpoint + "\n");
                    return;
                }
            }
        }
        Math3D.VectorCopy(spot.s.origin, origin);
        origin[2] = origin[2] + 9.0f;
        Math3D.VectorCopy(spot.s.angles, angles);
    }

    public static void InitBodyQue() {
        GameBase.level.body_que = 0;
        for (int i = 0; i < 8; ++i) {
            edict_t ent = GameUtil.G_Spawn();
            ent.classname = "bodyque";
        }
    }

    public static void CopyToBodyQue(edict_t ent) {
        int i = (int)GameBase.maxclients.value + GameBase.level.body_que + 1;
        edict_t body = GameBase.g_edicts[i];
        GameBase.level.body_que = (GameBase.level.body_que + 1) % 8;
        GameBase.gi.unlinkentity(ent);
        GameBase.gi.unlinkentity(body);
        body.s = ent.s.getClone();
        body.s.number = body.index;
        body.svflags = ent.svflags;
        Math3D.VectorCopy(ent.mins, body.mins);
        Math3D.VectorCopy(ent.maxs, body.maxs);
        Math3D.VectorCopy(ent.absmin, body.absmin);
        Math3D.VectorCopy(ent.absmax, body.absmax);
        Math3D.VectorCopy(ent.size, body.size);
        body.solid = ent.solid;
        body.clipmask = ent.clipmask;
        body.owner = ent.owner;
        body.movetype = ent.movetype;
        body.die = body_die;
        body.takedamage = 1;
        GameBase.gi.linkentity(body);
    }

    public static void respawn(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f || GameBase.coop.value != 0.0f) {
            if (self.movetype != 1) {
                PlayerClient.CopyToBodyQue(self);
            }
            self.svflags &= 0xFFFFFFFE;
            PlayerClient.PutClientInServer(self);
            self.s.event = 6;
            self.client.ps.pmove.pm_flags = (byte)32;
            self.client.ps.pmove.pm_time = (byte)14;
            self.client.respawn_time = GameBase.level.time;
            return;
        }
        GameBase.gi.AddCommandString("menu_loadgame\n");
    }

    private static boolean passwdOK(String i1, String i2) {
        return i1.length() == 0 || i1.equals("none") || i1.equals(i2);
    }

    public static void spectator_respawn(edict_t ent) {
        if (ent.client.pers.spectator) {
            String value = Info.Info_ValueForKey(ent.client.pers.userinfo, "spectator");
            if (!PlayerClient.passwdOK(GameBase.spectator_password.string, value)) {
                GameBase.gi.cprintf(ent, 2, "Spectator password incorrect.\n");
                ent.client.pers.spectator = false;
                GameBase.gi.WriteByte(11);
                GameBase.gi.WriteString("spectator 0\n");
                GameBase.gi.unicast(ent, true);
                return;
            }
            int i = 1;
            int numspec = 0;
            while ((float)i <= GameBase.maxclients.value) {
                if (GameBase.g_edicts[i].inuse && GameBase.g_edicts[i].client.pers.spectator) {
                    ++numspec;
                }
                ++i;
            }
            if ((float)numspec >= GameBase.maxspectators.value) {
                GameBase.gi.cprintf(ent, 2, "Server spectator limit is full.");
                ent.client.pers.spectator = false;
                GameBase.gi.WriteByte(11);
                GameBase.gi.WriteString("spectator 0\n");
                GameBase.gi.unicast(ent, true);
                return;
            }
        } else {
            String value = Info.Info_ValueForKey(ent.client.pers.userinfo, "password");
            if (!PlayerClient.passwdOK(GameBase.spectator_password.string, value)) {
                GameBase.gi.cprintf(ent, 2, "Password incorrect.\n");
                ent.client.pers.spectator = true;
                GameBase.gi.WriteByte(11);
                GameBase.gi.WriteString("spectator 1\n");
                GameBase.gi.unicast(ent, true);
                return;
            }
        }
        ent.client.pers.score = 0;
        ent.client.resp.score = 0;
        ent.svflags &= 0xFFFFFFFE;
        PlayerClient.PutClientInServer(ent);
        if (!ent.client.pers.spectator) {
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(9);
            GameBase.gi.multicast(ent.s.origin, 2);
            ent.client.ps.pmove.pm_flags = (byte)32;
            ent.client.ps.pmove.pm_time = (byte)14;
        }
        ent.client.respawn_time = GameBase.level.time;
        if (ent.client.pers.spectator) {
            GameBase.gi.bprintf(2, ent.client.pers.netname + " has moved to the sidelines\n");
        } else {
            GameBase.gi.bprintf(2, ent.client.pers.netname + " joined the game\n");
        }
    }

    public static void PutClientInServer(edict_t ent) {
        String userinfo;
        float[] mins = new float[]{-16.0f, -16.0f, -24.0f};
        float[] maxs = new float[]{16.0f, 16.0f, 32.0f};
        float[] spawn_origin = new float[]{0.0f, 0.0f, 0.0f};
        float[] spawn_angles = new float[]{0.0f, 0.0f, 0.0f};
        client_persistant_t saved = new client_persistant_t();
        client_respawn_t resp = new client_respawn_t();
        PlayerClient.SelectSpawnPoint(ent, spawn_origin, spawn_angles);
        int index = ent.index - 1;
        gclient_t client = ent.client;
        if (GameBase.deathmatch.value != 0.0f) {
            resp.set(client.resp);
            userinfo = client.pers.userinfo;
            PlayerClient.InitClientPersistant(client);
            userinfo = PlayerClient.ClientUserinfoChanged(ent, userinfo);
        } else if (GameBase.coop.value != 0.0f) {
            resp.set(client.resp);
            userinfo = client.pers.userinfo;
            resp.coop_respawn.game_helpchanged = client.pers.game_helpchanged;
            resp.coop_respawn.helpchanged = client.pers.helpchanged;
            client.pers.set(resp.coop_respawn);
            userinfo = PlayerClient.ClientUserinfoChanged(ent, userinfo);
            if (resp.score > client.pers.score) {
                client.pers.score = resp.score;
            }
        } else {
            resp.clear();
        }
        saved.set(client.pers);
        client.clear();
        client.pers.set(saved);
        if (client.pers.health <= 0) {
            PlayerClient.InitClientPersistant(client);
        }
        client.resp.set(resp);
        PlayerClient.FetchClientEntData(ent);
        ent.groundentity = null;
        ent.client = GameBase.game.clients[index];
        ent.takedamage = 2;
        ent.movetype = 4;
        ent.viewheight = 22;
        ent.inuse = true;
        ent.classname = "player";
        ent.mass = 200;
        ent.solid = 2;
        ent.deadflag = 0;
        ent.air_finished = GameBase.level.time + 12.0f;
        ent.clipmask = 33619971;
        ent.model = "players/male/tris.md2";
        ent.pain = player_pain;
        ent.die = player_die;
        ent.waterlevel = 0;
        ent.watertype = 0;
        ent.flags &= 0xFFFFF7FF;
        ent.svflags &= 0xFFFFFFFD;
        Math3D.VectorCopy(mins, ent.mins);
        Math3D.VectorCopy(maxs, ent.maxs);
        Math3D.VectorClear(ent.velocity);
        ent.client.ps.clear();
        client.ps.pmove.origin[0] = (short)(spawn_origin[0] * 8.0f);
        client.ps.pmove.origin[1] = (short)(spawn_origin[1] * 8.0f);
        client.ps.pmove.origin[2] = (short)(spawn_origin[2] * 8.0f);
        if (GameBase.deathmatch.value != 0.0f && 0 != ((int)GameBase.dmflags.value & 0x8000)) {
            client.ps.fov = 90.0f;
        } else {
            client.ps.fov = Lib.atoi(Info.Info_ValueForKey(client.pers.userinfo, "fov"));
            if (client.ps.fov < 1.0f) {
                client.ps.fov = 90.0f;
            } else if (client.ps.fov > 160.0f) {
                client.ps.fov = 160.0f;
            }
        }
        client.ps.gunindex = GameBase.gi.modelindex(client.pers.weapon.view_model);
        ent.s.effects = 0;
        ent.s.modelindex = 255;
        ent.s.modelindex2 = 255;
        ent.s.skinnum = ent.index - 1;
        ent.s.frame = 0;
        Math3D.VectorCopy(spawn_origin, ent.s.origin);
        ent.s.origin[2] = ent.s.origin[2] + 1.0f;
        Math3D.VectorCopy(ent.s.origin, ent.s.old_origin);
        for (int i = 0; i < 3; ++i) {
            client.ps.pmove.delta_angles[i] = (short)Math3D.ANGLE2SHORT(spawn_angles[i] - client.resp.cmd_angles[i]);
        }
        ent.s.angles[0] = 0.0f;
        ent.s.angles[1] = spawn_angles[1];
        ent.s.angles[2] = 0.0f;
        Math3D.VectorCopy(ent.s.angles, client.ps.viewangles);
        Math3D.VectorCopy(ent.s.angles, client.v_angle);
        if (client.pers.spectator) {
            client.chase_target = null;
            client.resp.spectator = true;
            ent.movetype = 1;
            ent.solid = 0;
            ent.svflags |= 1;
            ent.client.ps.gunindex = 0;
            GameBase.gi.linkentity(ent);
            return;
        }
        client.resp.spectator = false;
        if (!GameUtil.KillBox(ent)) {
            // empty if block
        }
        GameBase.gi.linkentity(ent);
        client.newweapon = client.pers.weapon;
        PlayerWeapon.ChangeWeapon(ent);
    }

    public static void ClientBeginDeathmatch(edict_t ent) {
        GameUtil.G_InitEdict(ent, ent.index);
        PlayerClient.InitClientResp(ent.client);
        PlayerClient.PutClientInServer(ent);
        if (GameBase.level.intermissiontime != 0.0f) {
            PlayerHud.MoveClientToIntermission(ent);
        } else {
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(9);
            GameBase.gi.multicast(ent.s.origin, 2);
        }
        GameBase.gi.bprintf(2, ent.client.pers.netname + " entered the game\n");
        PlayerView.ClientEndServerFrame(ent);
    }

    public static void ClientBegin(edict_t ent) {
        ent.client = GameBase.game.clients[ent.index - 1];
        if (GameBase.deathmatch.value != 0.0f) {
            PlayerClient.ClientBeginDeathmatch(ent);
            return;
        }
        if (ent.inuse) {
            for (int i = 0; i < 3; ++i) {
                ent.client.ps.pmove.delta_angles[i] = (short)Math3D.ANGLE2SHORT(ent.client.ps.viewangles[i]);
            }
        } else {
            GameUtil.G_InitEdict(ent, ent.index);
            ent.classname = "player";
            PlayerClient.InitClientResp(ent.client);
            PlayerClient.PutClientInServer(ent);
        }
        if (GameBase.level.intermissiontime != 0.0f) {
            PlayerHud.MoveClientToIntermission(ent);
        } else if (GameBase.game.maxclients > 1) {
            GameBase.gi.WriteByte(1);
            GameBase.gi.WriteShort(ent.index);
            GameBase.gi.WriteByte(9);
            GameBase.gi.multicast(ent.s.origin, 2);
            GameBase.gi.bprintf(2, ent.client.pers.netname + " entered the game\n");
        }
        PlayerView.ClientEndServerFrame(ent);
    }

    public static String ClientUserinfoChanged(edict_t ent, String userinfo) {
        String s;
        if (!Info.Info_Validate(userinfo)) {
            return "\\name\\badinfo\\skin\\male/grunt";
        }
        ent.client.pers.netname = s = Info.Info_ValueForKey(userinfo, "name");
        s = Info.Info_ValueForKey(userinfo, "spectator");
        ent.client.pers.spectator = GameBase.deathmatch.value != 0.0f && !s.equals("0");
        s = Info.Info_ValueForKey(userinfo, "skin");
        int playernum = ent.index - 1;
        GameBase.gi.configstring(1312 + playernum, ent.client.pers.netname + "\\" + s);
        if (GameBase.deathmatch.value != 0.0f && 0 != ((int)GameBase.dmflags.value & 0x8000)) {
            ent.client.ps.fov = 90.0f;
        } else {
            ent.client.ps.fov = Lib.atoi(Info.Info_ValueForKey(userinfo, "fov"));
            if (ent.client.ps.fov < 1.0f) {
                ent.client.ps.fov = 90.0f;
            } else if (ent.client.ps.fov > 160.0f) {
                ent.client.ps.fov = 160.0f;
            }
        }
        s = Info.Info_ValueForKey(userinfo, "hand");
        if (s.length() > 0) {
            ent.client.pers.hand = Lib.atoi(s);
        }
        ent.client.pers.userinfo = userinfo;
        return userinfo;
    }

    public static boolean ClientConnect(edict_t ent, String userinfo) {
        String value = Info.Info_ValueForKey(userinfo, "ip");
        if (GameSVCmds.SV_FilterPacket(value)) {
            userinfo = Info.Info_SetValueForKey(userinfo, "rejmsg", "Banned.");
            return false;
        }
        value = Info.Info_ValueForKey(userinfo, "spectator");
        if (GameBase.deathmatch.value != 0.0f && value.length() != 0 && 0 != Lib.strcmp(value, "0")) {
            if (!PlayerClient.passwdOK(GameBase.spectator_password.string, value)) {
                userinfo = Info.Info_SetValueForKey(userinfo, "rejmsg", "Spectator password required or incorrect.");
                return false;
            }
            int numspec = 0;
            int i = 0;
            while ((float)i < GameBase.maxclients.value) {
                if (GameBase.g_edicts[i + 1].inuse && GameBase.g_edicts[i + 1].client.pers.spectator) {
                    ++numspec;
                }
                ++i;
            }
            if ((float)numspec >= GameBase.maxspectators.value) {
                userinfo = Info.Info_SetValueForKey(userinfo, "rejmsg", "Server spectator limit is full.");
                return false;
            }
        } else {
            value = Info.Info_ValueForKey(userinfo, "password");
            if (!PlayerClient.passwdOK(GameBase.spectator_password.string, value)) {
                userinfo = Info.Info_SetValueForKey(userinfo, "rejmsg", "Password required or incorrect.");
                return false;
            }
        }
        ent.client = GameBase.game.clients[ent.index - 1];
        if (!ent.inuse) {
            PlayerClient.InitClientResp(ent.client);
            if (!GameBase.game.autosaved || null == ent.client.pers.weapon) {
                PlayerClient.InitClientPersistant(ent.client);
            }
        }
        userinfo = PlayerClient.ClientUserinfoChanged(ent, userinfo);
        if (GameBase.game.maxclients > 1) {
            GameBase.gi.dprintf(ent.client.pers.netname + " connected\n");
        }
        ent.svflags = 0;
        ent.client.pers.connected = true;
        return true;
    }

    public static void ClientDisconnect(edict_t ent) {
        if (ent.client == null) {
            return;
        }
        GameBase.gi.bprintf(2, ent.client.pers.netname + " disconnected\n");
        GameBase.gi.WriteByte(1);
        GameBase.gi.WriteShort(ent.index);
        GameBase.gi.WriteByte(10);
        GameBase.gi.multicast(ent.s.origin, 2);
        GameBase.gi.unlinkentity(ent);
        ent.s.modelindex = 0;
        ent.solid = 0;
        ent.inuse = false;
        ent.classname = "disconnected";
        ent.client.pers.connected = false;
        int playernum = ent.index - 1;
        GameBase.gi.configstring(1312 + playernum, "");
    }

    public static void ClientThink(edict_t ent, usercmd_t ucmd) {
        edict_t other;
        int i;
        pmove_t pm = null;
        GameBase.level.current_entity = ent;
        gclient_t client = ent.client;
        if (GameBase.level.intermissiontime != 0.0f) {
            client.ps.pmove.pm_type = 4;
            if (GameBase.level.time > GameBase.level.intermissiontime + 5.0f && 0 != (ucmd.buttons & 0x80)) {
                GameBase.level.exitintermission = true;
            }
            return;
        }
        pm_passent = ent;
        if (ent.client.chase_target != null) {
            client.resp.cmd_angles[0] = Math3D.SHORT2ANGLE(ucmd.angles[0]);
            client.resp.cmd_angles[1] = Math3D.SHORT2ANGLE(ucmd.angles[1]);
            client.resp.cmd_angles[2] = Math3D.SHORT2ANGLE(ucmd.angles[2]);
        } else {
            pm = new pmove_t();
            client.ps.pmove.pm_type = ent.movetype == 1 ? 1 : (ent.s.modelindex != 255 ? 3 : (ent.deadflag != 0 ? 2 : 0));
            client.ps.pmove.gravity = (short)GameBase.sv_gravity.value;
            pm.s.set(client.ps.pmove);
            for (i = 0; i < 3; ++i) {
                pm.s.origin[i] = (short)(ent.s.origin[i] * 8.0f);
                pm.s.velocity[i] = (short)(ent.velocity[i] * 8.0f);
            }
            if (client.old_pmove.equals(pm.s)) {
                pm.snapinitial = true;
            }
            pm.cmd.set(ucmd);
            pm.trace = PM_trace;
            pm.pointcontents = GameBase.gi.pointcontents;
            GameBase.gi.Pmove(pm);
            client.ps.pmove.set(pm.s);
            client.old_pmove.set(pm.s);
            for (i = 0; i < 3; ++i) {
                ent.s.origin[i] = (float)pm.s.origin[i] * 0.125f;
                ent.velocity[i] = (float)pm.s.velocity[i] * 0.125f;
            }
            Math3D.VectorCopy(pm.mins, ent.mins);
            Math3D.VectorCopy(pm.maxs, ent.maxs);
            client.resp.cmd_angles[0] = Math3D.SHORT2ANGLE(ucmd.angles[0]);
            client.resp.cmd_angles[1] = Math3D.SHORT2ANGLE(ucmd.angles[1]);
            client.resp.cmd_angles[2] = Math3D.SHORT2ANGLE(ucmd.angles[2]);
            if (ent.groundentity != null && null == pm.groundentity && pm.cmd.upmove >= 10 && pm.waterlevel == 0) {
                GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("*jump1.wav"), 1.0f, 1.0f, 0.0f);
                PlayerWeapon.PlayerNoise(ent, ent.s.origin, 0);
            }
            ent.viewheight = (int)pm.viewheight;
            ent.waterlevel = pm.waterlevel;
            ent.watertype = pm.watertype;
            ent.groundentity = pm.groundentity;
            if (pm.groundentity != null) {
                ent.groundentity_linkcount = pm.groundentity.linkcount;
            }
            if (ent.deadflag != 0) {
                client.ps.viewangles[2] = 40.0f;
                client.ps.viewangles[0] = -15.0f;
                client.ps.viewangles[1] = client.killer_yaw;
            } else {
                Math3D.VectorCopy(pm.viewangles, client.v_angle);
                Math3D.VectorCopy(pm.viewangles, client.ps.viewangles);
            }
            GameBase.gi.linkentity(ent);
            if (ent.movetype != 1) {
                GameBase.G_TouchTriggers(ent);
            }
            for (i = 0; i < pm.numtouch; ++i) {
                int j;
                other = pm.touchents[i];
                for (j = 0; j < i && pm.touchents[j] != other; ++j) {
                }
                if (j != i || other.touch == null) continue;
                other.touch.touch(other, ent, GameBase.dummyplane, null);
            }
        }
        client.oldbuttons = client.buttons;
        client.buttons = ucmd.buttons;
        client.latched_buttons |= client.buttons & ~client.oldbuttons;
        ent.light_level = ucmd.lightlevel;
        if ((client.latched_buttons & 1) != 0) {
            if (client.resp.spectator) {
                client.latched_buttons = 0;
                if (client.chase_target != null) {
                    client.chase_target = null;
                    client.ps.pmove.pm_flags = (byte)(client.ps.pmove.pm_flags & 0xFFFFFFBF);
                } else {
                    GameChase.GetChaseTarget(ent);
                }
            } else if (!client.weapon_thunk) {
                client.weapon_thunk = true;
                PlayerWeapon.Think_Weapon(ent);
            }
        }
        if (client.resp.spectator) {
            if (ucmd.upmove >= 10) {
                if (0 == (client.ps.pmove.pm_flags & 2)) {
                    client.ps.pmove.pm_flags = (byte)(client.ps.pmove.pm_flags | 2);
                    if (client.chase_target != null) {
                        GameChase.ChaseNext(ent);
                    } else {
                        GameChase.GetChaseTarget(ent);
                    }
                }
            } else {
                client.ps.pmove.pm_flags = (byte)(client.ps.pmove.pm_flags & 0xFFFFFFFD);
            }
        }
        i = 1;
        while ((float)i <= GameBase.maxclients.value) {
            other = GameBase.g_edicts[i];
            if (other.inuse && other.client.chase_target == ent) {
                GameChase.UpdateChaseCam(other);
            }
            ++i;
        }
    }

    public static void ClientBeginServerFrame(edict_t ent) {
        if (GameBase.level.intermissiontime != 0.0f) {
            return;
        }
        gclient_t client = ent.client;
        if (GameBase.deathmatch.value != 0.0f && client.pers.spectator != client.resp.spectator && GameBase.level.time - client.respawn_time >= 5.0f) {
            PlayerClient.spectator_respawn(ent);
            return;
        }
        if (!client.weapon_thunk && !client.resp.spectator) {
            PlayerWeapon.Think_Weapon(ent);
        } else {
            client.weapon_thunk = false;
        }
        if (ent.deadflag != 0) {
            int buttonMask;
            if (GameBase.level.time > client.respawn_time && ((client.latched_buttons & (buttonMask = GameBase.deathmatch.value != 0.0f ? 1 : -1)) != 0 || GameBase.deathmatch.value != 0.0f && 0 != ((int)GameBase.dmflags.value & 0x400))) {
                PlayerClient.respawn(ent);
                client.latched_buttons = 0;
            }
            return;
        }
        if (GameBase.deathmatch.value != 0.0f && !GameUtil.visible(ent, PlayerTrail.LastSpot())) {
            PlayerTrail.Add(ent.s.old_origin);
        }
        client.latched_buttons = 0;
    }

    public static boolean IsFemale(edict_t ent) {
        if (null == ent.client) {
            return false;
        }
        char info = Info.Info_ValueForKey(ent.client.pers.userinfo, "gender").charAt(0);
        return info == 'f' || info == 'F';
    }

    public static boolean IsNeutral(edict_t ent) {
        if (ent.client == null) {
            return false;
        }
        char info = Info.Info_ValueForKey(ent.client.pers.userinfo, "gender").charAt(0);
        return info != 'f' && info != 'F' && info != 'm' && info != 'M';
    }

    public static void LookAtKiller(edict_t self, edict_t inflictor, edict_t attacker) {
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        edict_t world = GameBase.g_edicts[0];
        if (attacker != null && attacker != world && attacker != self) {
            Math3D.VectorSubtract(attacker.s.origin, self.s.origin, dir);
        } else if (inflictor != null && inflictor != world && inflictor != self) {
            Math3D.VectorSubtract(inflictor.s.origin, self.s.origin, dir);
        } else {
            self.client.killer_yaw = self.s.angles[1];
            return;
        }
        if (dir[0] != 0.0f) {
            self.client.killer_yaw = (float)(57.29577951308232 * Math.atan2(dir[1], dir[0]));
        } else {
            self.client.killer_yaw = 0.0f;
            if (dir[1] > 0.0f) {
                self.client.killer_yaw = 90.0f;
            } else if (dir[1] < 0.0f) {
                self.client.killer_yaw = -90.0f;
            }
        }
        if (self.client.killer_yaw < 0.0f) {
            self.client.killer_yaw += 360.0f;
        }
    }

    public static void TossClientWeapon(edict_t self) {
        edict_t drop;
        if (GameBase.deathmatch.value == 0.0f) {
            return;
        }
        gitem_t item = self.client.pers.weapon;
        if (0 == self.client.pers.inventory[self.client.ammo_index]) {
            item = null;
        }
        if (item != null && Lib.strcmp(item.pickup_name, "Blaster") == 0) {
            item = null;
        }
        boolean quad = 0 == ((int)GameBase.dmflags.value & 0x4000) ? false : self.client.quad_framenum > (float)(GameBase.level.framenum + 10);
        float spread = item != null && quad ? 22.5f : 0.0f;
        if (item != null) {
            self.client.v_angle[1] = self.client.v_angle[1] - spread;
            drop = GameItems.Drop_Item(self, item);
            self.client.v_angle[1] = self.client.v_angle[1] + spread;
            drop.spawnflags = 131072;
        }
        if (quad) {
            self.client.v_angle[1] = self.client.v_angle[1] + spread;
            drop = GameItems.Drop_Item(self, GameItems.FindItemByClassname("item_quad"));
            self.client.v_angle[1] = self.client.v_angle[1] - spread;
            drop.spawnflags |= 0x20000;
            drop.touch = GameItems.Touch_Item;
            drop.nextthink = GameBase.level.time + (self.client.quad_framenum - (float)GameBase.level.framenum) * 0.1f;
            drop.think = GameUtil.G_FreeEdictA;
        }
    }

    static {
        PM_trace = new pmove_t.TraceAdapter(){

            public trace_t trace(float[] start, float[] mins, float[] maxs, float[] end) {
                if (PlayerClient.pm_passent.health > 0) {
                    return GameBase.gi.trace(start, mins, maxs, end, pm_passent, 33619971);
                }
                return GameBase.gi.trace(start, mins, maxs, end, pm_passent, 65539);
            }
        };
    }
}

