/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.client.M;
import jake2.game.EdictIterator;
import jake2.game.EntThinkAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameBase;
import jake2.game.GameItems;
import jake2.game.GameUtil;
import jake2.game.GameWeapon;
import jake2.game.edict_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import jake2.util.Math3D;

public class Monster {
    public static EntThinkAdapter monster_think = new EntThinkAdapter(){

        public String getID() {
            return "monster_think";
        }

        public boolean think(edict_t self) {
            M.M_MoveFrame(self);
            if (self.linkcount != self.monsterinfo.linkcount) {
                self.monsterinfo.linkcount = self.linkcount;
                M.M_CheckGround(self);
            }
            M.M_CatagorizePosition(self);
            M.M_WorldEffects(self);
            M.M_SetEffects(self);
            return true;
        }
    };
    public static EntThinkAdapter monster_triggered_spawn = new EntThinkAdapter(){

        public String getID() {
            return "monster_trigger_spawn";
        }

        public boolean think(edict_t self) {
            self.s.origin[2] = self.s.origin[2] + 1.0f;
            GameUtil.KillBox(self);
            self.solid = 2;
            self.movetype = 5;
            self.svflags &= 0xFFFFFFFE;
            self.air_finished = GameBase.level.time + 12.0f;
            GameBase.gi.linkentity(self);
            Monster.monster_start_go(self);
            if (self.enemy != null && 0 == (self.spawnflags & 1) && 0 == (self.enemy.flags & 0x20)) {
                GameUtil.FoundTarget(self);
            } else {
                self.enemy = null;
            }
            return true;
        }
    };
    public static EntUseAdapter monster_triggered_spawn_use = new EntUseAdapter(){

        public String getID() {
            return "monster_trigger_spawn_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.think = monster_triggered_spawn;
            self.nextthink = GameBase.level.time + 0.1f;
            if (activator.client != null) {
                self.enemy = activator;
            }
            self.use = GameUtil.monster_use;
        }
    };
    public static EntThinkAdapter monster_triggered_start = new EntThinkAdapter(){

        public String getID() {
            return "monster_triggered_start";
        }

        public boolean think(edict_t self) {
            if (self.index == 312) {
                Com.Printf("monster_triggered_start\n");
            }
            self.solid = 0;
            self.movetype = 0;
            self.svflags |= 1;
            self.nextthink = 0.0f;
            self.use = monster_triggered_spawn_use;
            return true;
        }
    };

    public static void monster_fire_bullet(edict_t self, float[] start, float[] dir, int damage, int kick, int hspread, int vspread, int flashtype) {
        GameWeapon.fire_bullet(self, start, dir, damage, kick, hspread, vspread, 0);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_fire_shotgun(edict_t self, float[] start, float[] aimdir, int damage, int kick, int hspread, int vspread, int count, int flashtype) {
        GameWeapon.fire_shotgun(self, start, aimdir, damage, kick, hspread, vspread, count, 0);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_fire_blaster(edict_t self, float[] start, float[] dir, int damage, int speed, int flashtype, int effect) {
        GameWeapon.fire_blaster(self, start, dir, damage, speed, effect, false);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_fire_grenade(edict_t self, float[] start, float[] aimdir, int damage, int speed, int flashtype) {
        GameWeapon.fire_grenade(self, start, aimdir, damage, speed, 2.5f, damage + 40);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_fire_rocket(edict_t self, float[] start, float[] dir, int damage, int speed, int flashtype) {
        GameWeapon.fire_rocket(self, start, dir, damage, speed, damage + 20, damage);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_fire_railgun(edict_t self, float[] start, float[] aimdir, int damage, int kick, int flashtype) {
        GameWeapon.fire_rail(self, start, aimdir, damage, kick);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_fire_bfg(edict_t self, float[] start, float[] aimdir, int damage, int speed, int kick, float damage_radius, int flashtype) {
        GameWeapon.fire_bfg(self, start, aimdir, damage, speed, damage_radius);
        GameBase.gi.WriteByte(2);
        GameBase.gi.WriteShort(self.index);
        GameBase.gi.WriteByte(flashtype);
        GameBase.gi.multicast(start, 2);
    }

    public static void monster_death_use(edict_t self) {
        self.flags &= 0xFFFFFFFC;
        self.monsterinfo.aiflags &= 0x100;
        if (self.item != null) {
            GameItems.Drop_Item(self, self.item);
            self.item = null;
        }
        if (self.deathtarget != null) {
            self.target = self.deathtarget;
        }
        if (self.target == null) {
            return;
        }
        GameUtil.G_UseTargets(self, self.enemy);
    }

    public static boolean monster_start(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return false;
        }
        if ((self.spawnflags & 4) != 0 && 0 == (self.monsterinfo.aiflags & 0x100)) {
            self.spawnflags &= 0xFFFFFFFB;
            self.spawnflags |= 1;
        }
        if (0 == (self.monsterinfo.aiflags & 0x100)) {
            ++GameBase.level.total_monsters;
        }
        self.nextthink = GameBase.level.time + 0.1f;
        self.svflags |= 4;
        self.s.renderfx |= 0x40;
        self.takedamage = 2;
        self.air_finished = GameBase.level.time + 12.0f;
        self.use = GameUtil.monster_use;
        self.max_health = self.health;
        self.clipmask = 0x2020003;
        self.s.skinnum = 0;
        self.deadflag = 0;
        self.svflags &= 0xFFFFFFFD;
        if (null == self.monsterinfo.checkattack) {
            self.monsterinfo.checkattack = GameUtil.M_CheckAttack;
        }
        Math3D.VectorCopy(self.s.origin, self.s.old_origin);
        if (GameBase.st.item != null && GameBase.st.item.length() > 0) {
            self.item = GameItems.FindItemByClassname(GameBase.st.item);
            if (self.item == null) {
                GameBase.gi.dprintf("monster_start:" + self.classname + " at " + Lib.vtos(self.s.origin) + " has bad item: " + GameBase.st.item + "\n");
            }
        }
        if (self.monsterinfo.currentmove != null) {
            self.s.frame = self.monsterinfo.currentmove.firstframe + Lib.rand() % (self.monsterinfo.currentmove.lastframe - self.monsterinfo.currentmove.firstframe + 1);
        }
        return true;
    }

    public static void monster_start_go(edict_t self) {
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        if (self.health <= 0) {
            return;
        }
        if (self.target != null) {
            edict_t target = null;
            boolean notcombat = false;
            boolean fixup = false;
            EdictIterator edit = null;
            while ((edit = GameBase.G_Find(edit, GameBase.findByTarget, self.target)) != null) {
                target = edit.o;
                if (Lib.strcmp(target.classname, "point_combat") == 0) {
                    self.combattarget = self.target;
                    fixup = true;
                    continue;
                }
                notcombat = true;
            }
            if (notcombat && self.combattarget != null) {
                GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + " has target with mixed types\n");
            }
            if (fixup) {
                self.target = null;
            }
        }
        if (self.combattarget != null) {
            edict_t target = null;
            EdictIterator edit = null;
            while ((edit = GameBase.G_Find(edit, GameBase.findByTarget, self.combattarget)) != null) {
                target = edit.o;
                if (Lib.strcmp(target.classname, "point_combat") == 0) continue;
                GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + " has bad combattarget " + self.combattarget + " : " + target.classname + " at " + Lib.vtos(target.s.origin));
            }
        }
        if (self.target != null) {
            self.goalentity = self.movetarget = GameBase.G_PickTarget(self.target);
            if (null == self.movetarget) {
                GameBase.gi.dprintf(self.classname + " can't find target " + self.target + " at " + Lib.vtos(self.s.origin) + "\n");
                self.target = null;
                self.monsterinfo.pausetime = 1.0E8f;
                self.monsterinfo.stand.think(self);
            } else if (Lib.strcmp(self.movetarget.classname, "path_corner") == 0) {
                Math3D.VectorSubtract(self.goalentity.s.origin, self.s.origin, v);
                self.ideal_yaw = self.s.angles[1] = Math3D.vectoyaw(v);
                self.monsterinfo.walk.think(self);
                self.target = null;
            } else {
                self.movetarget = null;
                self.goalentity = null;
                self.monsterinfo.pausetime = 1.0E8f;
                self.monsterinfo.stand.think(self);
            }
        } else {
            self.monsterinfo.pausetime = 1.0E8f;
            self.monsterinfo.stand.think(self);
        }
        self.think = monster_think;
        self.nextthink = GameBase.level.time + 0.1f;
    }
}

