/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EdictIterator;
import jake2.game.EntThinkAdapter;
import jake2.game.EntTouchAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameMisc;
import jake2.game.GameUtil;
import jake2.game.PlayerWeapon;
import jake2.game.cplane_t;
import jake2.game.csurface_t;
import jake2.game.edict_t;
import jake2.game.trace_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameWeapon {
    static EntTouchAdapter blaster_touch = new EntTouchAdapter(){

        public String getID() {
            return "blaster_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (other == self.owner) {
                return;
            }
            if (surf != null && (surf.flags & 4) != 0) {
                GameUtil.G_FreeEdict(self);
                return;
            }
            if (self.owner.client != null) {
                PlayerWeapon.PlayerNoise(self.owner, self.s.origin, 2);
            }
            if (other.takedamage != 0) {
                int mod = (self.spawnflags & 1) != 0 ? 10 : 1;
                float[] normal = plane == null ? new float[3] : plane.normal;
                GameCombat.T_Damage(other, self, self.owner, self.velocity, self.s.origin, normal, self.dmg, 1, 4, mod);
            } else {
                GameBase.gi.WriteByte(3);
                GameBase.gi.WriteByte(2);
                GameBase.gi.WritePosition(self.s.origin);
                if (plane == null) {
                    GameBase.gi.WriteDir(Globals.vec3_origin);
                } else {
                    GameBase.gi.WriteDir(plane.normal);
                }
                GameBase.gi.multicast(self.s.origin, 2);
            }
            GameUtil.G_FreeEdict(self);
        }
    };
    static EntThinkAdapter Grenade_Explode = new EntThinkAdapter(){

        public String getID() {
            return "Grenade_Explode";
        }

        public boolean think(edict_t ent) {
            int mod;
            float[] origin = new float[]{0.0f, 0.0f, 0.0f};
            if (ent.owner.client != null) {
                PlayerWeapon.PlayerNoise(ent.owner, ent.s.origin, 2);
            }
            if (ent.enemy != null) {
                float points = 0.0f;
                float[] v = new float[]{0.0f, 0.0f, 0.0f};
                float[] dir = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.VectorAdd(ent.enemy.mins, ent.enemy.maxs, v);
                Math3D.VectorMA(ent.enemy.s.origin, 0.5f, v, v);
                Math3D.VectorSubtract(ent.s.origin, v, v);
                points = (float)ent.dmg - 0.5f * Math3D.VectorLength(v);
                Math3D.VectorSubtract(ent.enemy.s.origin, ent.s.origin, dir);
                mod = (ent.spawnflags & 1) != 0 ? 15 : 6;
                GameCombat.T_Damage(ent.enemy, ent, ent.owner, dir, ent.s.origin, Globals.vec3_origin, (int)points, (int)points, 1, mod);
            }
            mod = (ent.spawnflags & 2) != 0 ? 24 : ((ent.spawnflags & 1) != 0 ? 16 : 7);
            GameCombat.T_RadiusDamage(ent, ent.owner, ent.dmg, ent.enemy, ent.dmg_radius, mod);
            Math3D.VectorMA(ent.s.origin, -0.02f, ent.velocity, origin);
            GameBase.gi.WriteByte(3);
            if (ent.waterlevel != 0) {
                if (ent.groundentity != null) {
                    GameBase.gi.WriteByte(18);
                } else {
                    GameBase.gi.WriteByte(17);
                }
            } else if (ent.groundentity != null) {
                GameBase.gi.WriteByte(8);
            } else {
                GameBase.gi.WriteByte(7);
            }
            GameBase.gi.WritePosition(origin);
            GameBase.gi.multicast(ent.s.origin, 1);
            GameUtil.G_FreeEdict(ent);
            return true;
        }
    };
    static EntTouchAdapter Grenade_Touch = new EntTouchAdapter(){

        public String getID() {
            return "Grenade_Touch";
        }

        public void touch(edict_t ent, edict_t other, cplane_t plane, csurface_t surf) {
            if (other == ent.owner) {
                return;
            }
            if (surf != null && 0 != (surf.flags & 4)) {
                GameUtil.G_FreeEdict(ent);
                return;
            }
            if (other.takedamage == 0) {
                if ((ent.spawnflags & 1) != 0) {
                    if (Lib.random() > 0.5f) {
                        GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/hgrenb1a.wav"), 1.0f, 1.0f, 0.0f);
                    } else {
                        GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/hgrenb2a.wav"), 1.0f, 1.0f, 0.0f);
                    }
                } else {
                    GameBase.gi.sound(ent, 2, GameBase.gi.soundindex("weapons/grenlb1b.wav"), 1.0f, 1.0f, 0.0f);
                }
                return;
            }
            ent.enemy = other;
            Grenade_Explode.think(ent);
        }
    };
    static EntTouchAdapter rocket_touch = new EntTouchAdapter(){

        public String getID() {
            return "rocket_touch";
        }

        public void touch(edict_t ent, edict_t other, cplane_t plane, csurface_t surf) {
            float[] origin = new float[]{0.0f, 0.0f, 0.0f};
            if (other == ent.owner) {
                return;
            }
            if (surf != null && (surf.flags & 4) != 0) {
                GameUtil.G_FreeEdict(ent);
                return;
            }
            if (ent.owner.client != null) {
                PlayerWeapon.PlayerNoise(ent.owner, ent.s.origin, 2);
            }
            Math3D.VectorMA(ent.s.origin, -0.02f, ent.velocity, origin);
            if (other.takedamage != 0) {
                GameCombat.T_Damage(other, ent, ent.owner, ent.velocity, ent.s.origin, plane.normal, ent.dmg, 0, 0, 8);
            } else if (GameBase.deathmatch.value == 0.0f && 0.0f == GameBase.coop.value && surf != null && 0 == (surf.flags & 0x78)) {
                int n = Lib.rand() % 5;
                while (n-- > 0) {
                    GameMisc.ThrowDebris(ent, "models/objects/debris2/tris.md2", 2.0f, ent.s.origin);
                }
            }
            GameCombat.T_RadiusDamage(ent, ent.owner, ent.radius_dmg, other, ent.dmg_radius, 9);
            GameBase.gi.WriteByte(3);
            if (ent.waterlevel != 0) {
                GameBase.gi.WriteByte(17);
            } else {
                GameBase.gi.WriteByte(7);
            }
            GameBase.gi.WritePosition(origin);
            GameBase.gi.multicast(ent.s.origin, 1);
            GameUtil.G_FreeEdict(ent);
        }
    };
    static EntThinkAdapter bfg_explode = new EntThinkAdapter(){

        public String getID() {
            return "bfg_explode";
        }

        public boolean think(edict_t self) {
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            EdictIterator edit = null;
            if (self.s.frame == 0) {
                edict_t ent = null;
                while ((edit = GameBase.findradius(edit, self.s.origin, self.dmg_radius)) != null) {
                    ent = edit.o;
                    if (ent.takedamage == 0 || ent == self.owner || !GameCombat.CanDamage(ent, self) || !GameCombat.CanDamage(ent, self.owner)) continue;
                    Math3D.VectorAdd(ent.mins, ent.maxs, v);
                    Math3D.VectorMA(ent.s.origin, 0.5f, v, v);
                    Math3D.VectorSubtract(self.s.origin, v, v);
                    float dist = Math3D.VectorLength(v);
                    float points = (float)((double)self.radius_dmg * (1.0 - Math.sqrt(dist / self.dmg_radius)));
                    if (ent == self.owner) {
                        points *= 0.5f;
                    }
                    GameBase.gi.WriteByte(3);
                    GameBase.gi.WriteByte(20);
                    GameBase.gi.WritePosition(ent.s.origin);
                    GameBase.gi.multicast(ent.s.origin, 1);
                    GameCombat.T_Damage(ent, self, self.owner, self.velocity, ent.s.origin, Globals.vec3_origin, (int)points, 0, 4, 14);
                }
            }
            self.nextthink = GameBase.level.time + 0.1f;
            ++self.s.frame;
            if (self.s.frame == 5) {
                self.think = GameUtil.G_FreeEdictA;
            }
            return true;
        }
    };
    static EntTouchAdapter bfg_touch = new EntTouchAdapter(){

        public String getID() {
            return "bfg_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (other == self.owner) {
                return;
            }
            if (surf != null && (surf.flags & 4) != 0) {
                GameUtil.G_FreeEdict(self);
                return;
            }
            if (self.owner.client != null) {
                PlayerWeapon.PlayerNoise(self.owner, self.s.origin, 2);
            }
            if (other.takedamage != 0) {
                GameCombat.T_Damage(other, self, self.owner, self.velocity, self.s.origin, plane.normal, 200, 0, 0, 13);
            }
            GameCombat.T_RadiusDamage(self, self.owner, 200.0f, other, 100.0f, 13);
            GameBase.gi.sound(self, 2, GameBase.gi.soundindex("weapons/bfg__x1b.wav"), 1.0f, 1.0f, 0.0f);
            self.solid = 0;
            self.touch = null;
            Math3D.VectorMA(self.s.origin, -0.1f, self.velocity, self.s.origin);
            Math3D.VectorClear(self.velocity);
            self.s.modelindex = GameBase.gi.modelindex("sprites/s_bfg3.sp2");
            self.s.frame = 0;
            self.s.sound = 0;
            self.s.effects &= 0xFFFFDFFF;
            self.think = bfg_explode;
            self.nextthink = GameBase.level.time + 0.1f;
            self.enemy = other;
            GameBase.gi.WriteByte(3);
            GameBase.gi.WriteByte(21);
            GameBase.gi.WritePosition(self.s.origin);
            GameBase.gi.multicast(self.s.origin, 2);
        }
    };
    static EntThinkAdapter bfg_think = new EntThinkAdapter(){

        public String getID() {
            return "bfg_think";
        }

        public boolean think(edict_t self) {
            float[] point = new float[]{0.0f, 0.0f, 0.0f};
            float[] dir = new float[]{0.0f, 0.0f, 0.0f};
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] end = new float[]{0.0f, 0.0f, 0.0f};
            int dmg = GameBase.deathmatch.value != 0.0f ? 5 : 10;
            EdictIterator edit = null;
            while ((edit = GameBase.findradius(edit, self.s.origin, 256.0f)) != null) {
                trace_t tr;
                edict_t ent = edit.o;
                if (ent == self || ent == self.owner || ent.takedamage == 0 || 0 == (ent.svflags & 4) && null == ent.client && Lib.strcmp(ent.classname, "misc_explobox") != 0) continue;
                Math3D.VectorMA(ent.absmin, 0.5f, ent.size, point);
                Math3D.VectorSubtract(point, self.s.origin, dir);
                Math3D.VectorNormalize(dir);
                edict_t ignore = self;
                Math3D.VectorCopy(self.s.origin, start);
                Math3D.VectorMA(start, 2048.0f, dir, end);
                while (true) {
                    tr = GameBase.gi.trace(start, null, null, end, ignore, 0x6000001);
                    if (null == tr.ent) break;
                    if (tr.ent.takedamage != 0 && 0 == (tr.ent.flags & 4) && tr.ent != self.owner) {
                        GameCombat.T_Damage(tr.ent, self, self.owner, dir, tr.endpos, Globals.vec3_origin, dmg, 1, 4, 12);
                    }
                    if (0 == (tr.ent.svflags & 4) && null == tr.ent.client) {
                        GameBase.gi.WriteByte(3);
                        GameBase.gi.WriteByte(15);
                        GameBase.gi.WriteByte(4);
                        GameBase.gi.WritePosition(tr.endpos);
                        GameBase.gi.WriteDir(tr.plane.normal);
                        GameBase.gi.WriteByte(self.s.skinnum);
                        GameBase.gi.multicast(tr.endpos, 2);
                        break;
                    }
                    ignore = tr.ent;
                    Math3D.VectorCopy(tr.endpos, start);
                }
                GameBase.gi.WriteByte(3);
                GameBase.gi.WriteByte(23);
                GameBase.gi.WritePosition(self.s.origin);
                GameBase.gi.WritePosition(tr.endpos);
                GameBase.gi.multicast(self.s.origin, 1);
            }
            self.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };

    static void check_dodge(edict_t self, float[] start, float[] dir, int speed) {
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        if (GameBase.skill.value == 0.0f && (double)Lib.random() > 0.25) {
            return;
        }
        Math3D.VectorMA(start, 8192.0f, dir, end);
        trace_t tr = GameBase.gi.trace(start, null, null, end, self, 0x6000003);
        if (tr.ent != null && (tr.ent.svflags & 4) != 0 && tr.ent.health > 0 && null != tr.ent.monsterinfo.dodge && GameUtil.infront(tr.ent, self)) {
            Math3D.VectorSubtract(tr.endpos, start, v);
            float eta = (Math3D.VectorLength(v) - tr.ent.maxs[0]) / (float)speed;
            tr.ent.monsterinfo.dodge.dodge(tr.ent, self, eta);
        }
    }

    public static boolean fire_hit(edict_t self, float[] aim, int damage, int kick) {
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        float[] point = new float[]{0.0f, 0.0f, 0.0f};
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorSubtract(self.enemy.s.origin, self.s.origin, dir);
        float range = Math3D.VectorLength(dir);
        if (range > aim[0]) {
            return false;
        }
        if (aim[1] > self.mins[0] && aim[1] < self.maxs[0]) {
            range -= self.enemy.maxs[0];
        } else {
            aim[1] = aim[1] < 0.0f ? self.enemy.mins[0] : self.enemy.maxs[0];
        }
        Math3D.VectorMA(self.s.origin, range, dir, point);
        trace_t tr = GameBase.gi.trace(self.s.origin, null, null, point, self, 0x6000003);
        if (tr.fraction < 1.0f) {
            if (0 == tr.ent.takedamage) {
                return false;
            }
            if ((tr.ent.svflags & 4) != 0 || tr.ent.client != null) {
                tr.ent = self.enemy;
            }
        }
        Math3D.AngleVectors(self.s.angles, forward, right, up);
        Math3D.VectorMA(self.s.origin, range, forward, point);
        Math3D.VectorMA(point, aim[1], right, point);
        Math3D.VectorMA(point, aim[2], up, point);
        Math3D.VectorSubtract(point, self.enemy.s.origin, dir);
        GameCombat.T_Damage(tr.ent, self, self, dir, point, Globals.vec3_origin, damage, kick / 2, 8, 32);
        if (0 == (tr.ent.svflags & 4) && null == tr.ent.client) {
            return false;
        }
        Math3D.VectorMA(self.enemy.absmin, 0.5f, self.enemy.size, v);
        Math3D.VectorSubtract(v, point, v);
        Math3D.VectorNormalize(v);
        Math3D.VectorMA(self.enemy.velocity, kick, v, self.enemy.velocity);
        if (self.enemy.velocity[2] > 0.0f) {
            self.enemy.groundentity = null;
        }
        return true;
    }

    public static void fire_lead(edict_t self, float[] start, float[] aimdir, int damage, int kick, int te_impact, int hspread, int vspread, int mod) {
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        float[] water_start = new float[]{0.0f, 0.0f, 0.0f};
        boolean water = false;
        int content_mask = 100663355;
        trace_t tr = GameBase.gi.trace(self.s.origin, null, null, start, self, 0x6000003);
        if (!((double)tr.fraction < 1.0)) {
            Math3D.vectoangles(aimdir, dir);
            Math3D.AngleVectors(dir, forward, right, up);
            float r = Lib.crandom() * (float)hspread;
            float u = Lib.crandom() * (float)vspread;
            Math3D.VectorMA(start, 8192.0f, forward, end);
            Math3D.VectorMA(end, r, right, end);
            Math3D.VectorMA(end, u, up, end);
            if ((GameBase.gi.pointcontents.pointcontents(start) & 0x38) != 0) {
                water = true;
                Math3D.VectorCopy(start, water_start);
                content_mask &= 0xFFFFFFC7;
            }
            tr = GameBase.gi.trace(start, null, null, end, self, content_mask);
            if ((tr.contents & 0x38) != 0) {
                water = true;
                Math3D.VectorCopy(tr.endpos, water_start);
                if (!Math3D.VectorEquals(start, tr.endpos)) {
                    int color = (tr.contents & 0x20) != 0 ? (Lib.strcmp(tr.surface.name, "*brwater") == 0 ? 3 : 2) : ((tr.contents & 0x10) != 0 ? 4 : ((tr.contents & 8) != 0 ? 5 : 0));
                    if (color != 0) {
                        GameBase.gi.WriteByte(3);
                        GameBase.gi.WriteByte(10);
                        GameBase.gi.WriteByte(8);
                        GameBase.gi.WritePosition(tr.endpos);
                        GameBase.gi.WriteDir(tr.plane.normal);
                        GameBase.gi.WriteByte(color);
                        GameBase.gi.multicast(tr.endpos, 2);
                    }
                    Math3D.VectorSubtract(end, start, dir);
                    Math3D.vectoangles(dir, dir);
                    Math3D.AngleVectors(dir, forward, right, up);
                    r = Lib.crandom() * (float)hspread * 2.0f;
                    u = Lib.crandom() * (float)vspread * 2.0f;
                    Math3D.VectorMA(water_start, 8192.0f, forward, end);
                    Math3D.VectorMA(end, r, right, end);
                    Math3D.VectorMA(end, u, up, end);
                }
                tr = GameBase.gi.trace(water_start, null, null, end, self, 0x6000003);
            }
        }
        if ((tr.surface == null || 0 == (tr.surface.flags & 4)) && (double)tr.fraction < 1.0) {
            if (tr.ent.takedamage != 0) {
                GameCombat.T_Damage(tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, 16, mod);
            } else if (!"sky".equals(tr.surface.name)) {
                GameBase.gi.WriteByte(3);
                GameBase.gi.WriteByte(te_impact);
                GameBase.gi.WritePosition(tr.endpos);
                GameBase.gi.WriteDir(tr.plane.normal);
                GameBase.gi.multicast(tr.endpos, 2);
                if (self.client != null) {
                    PlayerWeapon.PlayerNoise(self, tr.endpos, 2);
                }
            }
        }
        if (water) {
            float[] pos = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorSubtract(tr.endpos, water_start, dir);
            Math3D.VectorNormalize(dir);
            Math3D.VectorMA(tr.endpos, -2.0f, dir, pos);
            if ((GameBase.gi.pointcontents.pointcontents(pos) & 0x38) != 0) {
                Math3D.VectorCopy(pos, tr.endpos);
            } else {
                tr = GameBase.gi.trace(pos, null, null, water_start, tr.ent, 56);
            }
            Math3D.VectorAdd(water_start, tr.endpos, pos);
            Math3D.VectorScale(pos, 0.5f, pos);
            GameBase.gi.WriteByte(3);
            GameBase.gi.WriteByte(11);
            GameBase.gi.WritePosition(water_start);
            GameBase.gi.WritePosition(tr.endpos);
            GameBase.gi.multicast(pos, 2);
        }
    }

    public static void fire_bullet(edict_t self, float[] start, float[] aimdir, int damage, int kick, int hspread, int vspread, int mod) {
        GameWeapon.fire_lead(self, start, aimdir, damage, kick, 0, hspread, vspread, mod);
    }

    public static void fire_shotgun(edict_t self, float[] start, float[] aimdir, int damage, int kick, int hspread, int vspread, int count, int mod) {
        for (int i = 0; i < count; ++i) {
            GameWeapon.fire_lead(self, start, aimdir, damage, kick, 4, hspread, vspread, mod);
        }
    }

    public static void fire_blaster(edict_t self, float[] start, float[] dir, int damage, int speed, int effect, boolean hyper) {
        Math3D.VectorNormalize(dir);
        edict_t bolt = GameUtil.G_Spawn();
        bolt.svflags = 2;
        Math3D.VectorCopy(start, bolt.s.origin);
        Math3D.VectorCopy(start, bolt.s.old_origin);
        Math3D.vectoangles(dir, bolt.s.angles);
        Math3D.VectorScale(dir, speed, bolt.velocity);
        bolt.movetype = 8;
        bolt.clipmask = 0x6000003;
        bolt.solid = 2;
        bolt.s.effects |= effect;
        Math3D.VectorClear(bolt.mins);
        Math3D.VectorClear(bolt.maxs);
        bolt.s.modelindex = GameBase.gi.modelindex("models/objects/laser/tris.md2");
        bolt.s.sound = GameBase.gi.soundindex("misc/lasfly.wav");
        bolt.owner = self;
        bolt.touch = blaster_touch;
        bolt.nextthink = GameBase.level.time + 2.0f;
        bolt.think = GameUtil.G_FreeEdictA;
        bolt.dmg = damage;
        bolt.classname = "bolt";
        if (hyper) {
            bolt.spawnflags = 1;
        }
        GameBase.gi.linkentity(bolt);
        if (self.client != null) {
            GameWeapon.check_dodge(self, bolt.s.origin, dir, speed);
        }
        trace_t tr = GameBase.gi.trace(self.s.origin, null, null, bolt.s.origin, bolt, 0x6000003);
        if ((double)tr.fraction < 1.0) {
            Math3D.VectorMA(bolt.s.origin, -10.0f, dir, bolt.s.origin);
            bolt.touch.touch(bolt, tr.ent, GameBase.dummyplane, null);
        }
    }

    public static void fire_grenade(edict_t self, float[] start, float[] aimdir, int damage, int speed, float timer, float damage_radius) {
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.vectoangles(aimdir, dir);
        Math3D.AngleVectors(dir, forward, right, up);
        edict_t grenade = GameUtil.G_Spawn();
        Math3D.VectorCopy(start, grenade.s.origin);
        Math3D.VectorScale(aimdir, speed, grenade.velocity);
        Math3D.VectorMA(grenade.velocity, 200.0f + Lib.crandom() * 10.0f, up, grenade.velocity);
        Math3D.VectorMA(grenade.velocity, Lib.crandom() * 10.0f, right, grenade.velocity);
        Math3D.VectorSet(grenade.avelocity, 300.0f, 300.0f, 300.0f);
        grenade.movetype = 9;
        grenade.clipmask = 0x6000003;
        grenade.solid = 2;
        grenade.s.effects |= 0x20;
        Math3D.VectorClear(grenade.mins);
        Math3D.VectorClear(grenade.maxs);
        grenade.s.modelindex = GameBase.gi.modelindex("models/objects/grenade/tris.md2");
        grenade.owner = self;
        grenade.touch = Grenade_Touch;
        grenade.nextthink = GameBase.level.time + timer;
        grenade.think = Grenade_Explode;
        grenade.dmg = damage;
        grenade.dmg_radius = damage_radius;
        grenade.classname = "grenade";
        GameBase.gi.linkentity(grenade);
    }

    public static void fire_grenade2(edict_t self, float[] start, float[] aimdir, int damage, int speed, float timer, float damage_radius, boolean held) {
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.vectoangles(aimdir, dir);
        Math3D.AngleVectors(dir, forward, right, up);
        edict_t grenade = GameUtil.G_Spawn();
        Math3D.VectorCopy(start, grenade.s.origin);
        Math3D.VectorScale(aimdir, speed, grenade.velocity);
        Math3D.VectorMA(grenade.velocity, 200.0f + Lib.crandom() * 10.0f, up, grenade.velocity);
        Math3D.VectorMA(grenade.velocity, Lib.crandom() * 10.0f, right, grenade.velocity);
        Math3D.VectorSet(grenade.avelocity, 300.0f, 300.0f, 300.0f);
        grenade.movetype = 9;
        grenade.clipmask = 0x6000003;
        grenade.solid = 2;
        grenade.s.effects |= 0x20;
        Math3D.VectorClear(grenade.mins);
        Math3D.VectorClear(grenade.maxs);
        grenade.s.modelindex = GameBase.gi.modelindex("models/objects/grenade2/tris.md2");
        grenade.owner = self;
        grenade.touch = Grenade_Touch;
        grenade.nextthink = GameBase.level.time + timer;
        grenade.think = Grenade_Explode;
        grenade.dmg = damage;
        grenade.dmg_radius = damage_radius;
        grenade.classname = "hgrenade";
        grenade.spawnflags = held ? 3 : 1;
        grenade.s.sound = GameBase.gi.soundindex("weapons/hgrenc1b.wav");
        if ((double)timer <= 0.0) {
            Grenade_Explode.think(grenade);
        } else {
            GameBase.gi.sound(self, 1, GameBase.gi.soundindex("weapons/hgrent1a.wav"), 1.0f, 1.0f, 0.0f);
            GameBase.gi.linkentity(grenade);
        }
    }

    public static void fire_rocket(edict_t self, float[] start, float[] dir, int damage, int speed, float damage_radius, int radius_damage) {
        edict_t rocket = GameUtil.G_Spawn();
        Math3D.VectorCopy(start, rocket.s.origin);
        Math3D.VectorCopy(dir, rocket.movedir);
        Math3D.vectoangles(dir, rocket.s.angles);
        Math3D.VectorScale(dir, speed, rocket.velocity);
        rocket.movetype = 8;
        rocket.clipmask = 0x6000003;
        rocket.solid = 2;
        rocket.s.effects |= 0x10;
        Math3D.VectorClear(rocket.mins);
        Math3D.VectorClear(rocket.maxs);
        rocket.s.modelindex = GameBase.gi.modelindex("models/objects/rocket/tris.md2");
        rocket.owner = self;
        rocket.touch = rocket_touch;
        rocket.nextthink = GameBase.level.time + (float)(8000 / speed);
        rocket.think = GameUtil.G_FreeEdictA;
        rocket.dmg = damage;
        rocket.radius_dmg = radius_damage;
        rocket.dmg_radius = damage_radius;
        rocket.s.sound = GameBase.gi.soundindex("weapons/rockfly.wav");
        rocket.classname = "rocket";
        if (self.client != null) {
            GameWeapon.check_dodge(self, rocket.s.origin, dir, speed);
        }
        GameBase.gi.linkentity(rocket);
    }

    public static void fire_rail(edict_t self, float[] start, float[] aimdir, int damage, int kick) {
        float[] from = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        trace_t tr = null;
        Math3D.VectorMA(start, 8192.0f, aimdir, end);
        Math3D.VectorCopy(start, from);
        edict_t ignore = self;
        boolean water = false;
        int mask = 100663323;
        while (ignore != null) {
            tr = GameBase.gi.trace(from, null, null, end, ignore, mask);
            if ((tr.contents & 0x18) != 0) {
                mask &= 0xFFFFFFE7;
                water = true;
            } else {
                ignore = (tr.ent.svflags & 4) != 0 || tr.ent.client != null || tr.ent.solid == 2 ? tr.ent : null;
                if (tr.ent != self && tr.ent.takedamage != 0) {
                    GameCombat.T_Damage(tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, 0, 11);
                }
            }
            Math3D.VectorCopy(tr.endpos, from);
        }
        GameBase.gi.WriteByte(3);
        GameBase.gi.WriteByte(3);
        GameBase.gi.WritePosition(start);
        GameBase.gi.WritePosition(tr.endpos);
        GameBase.gi.multicast(self.s.origin, 1);
        if (water) {
            GameBase.gi.WriteByte(3);
            GameBase.gi.WriteByte(3);
            GameBase.gi.WritePosition(start);
            GameBase.gi.WritePosition(tr.endpos);
            GameBase.gi.multicast(tr.endpos, 1);
        }
        if (self.client != null) {
            PlayerWeapon.PlayerNoise(self, tr.endpos, 2);
        }
    }

    public static void fire_bfg(edict_t self, float[] start, float[] dir, int damage, int speed, float damage_radius) {
        edict_t bfg = GameUtil.G_Spawn();
        Math3D.VectorCopy(start, bfg.s.origin);
        Math3D.VectorCopy(dir, bfg.movedir);
        Math3D.vectoangles(dir, bfg.s.angles);
        Math3D.VectorScale(dir, speed, bfg.velocity);
        bfg.movetype = 8;
        bfg.clipmask = 0x6000003;
        bfg.solid = 2;
        bfg.s.effects |= 0x2080;
        Math3D.VectorClear(bfg.mins);
        Math3D.VectorClear(bfg.maxs);
        bfg.s.modelindex = GameBase.gi.modelindex("sprites/s_bfg1.sp2");
        bfg.owner = self;
        bfg.touch = bfg_touch;
        bfg.nextthink = GameBase.level.time + (float)(8000 / speed);
        bfg.think = GameUtil.G_FreeEdictA;
        bfg.radius_dmg = damage;
        bfg.dmg_radius = damage_radius;
        bfg.classname = "bfg blast";
        bfg.s.sound = GameBase.gi.soundindex("weapons/bfg__l1a.wav");
        bfg.think = bfg_think;
        bfg.nextthink = GameBase.level.time + 0.1f;
        bfg.teammaster = bfg;
        bfg.teamchain = null;
        if (self.client != null) {
            GameWeapon.check_dodge(self, bfg.s.origin, dir, speed);
        }
        GameBase.gi.linkentity(bfg);
    }
}

