/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.client.M;
import jake2.game.EdictIterator;
import jake2.game.EntThinkAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameAI;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameItems;
import jake2.game.Info;
import jake2.game.edict_t;
import jake2.game.entity_state_t;
import jake2.game.gclient_t;
import jake2.game.trace_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameUtil {
    public static EntThinkAdapter Think_Delay = new EntThinkAdapter(){

        public String getID() {
            return "Think_Delay";
        }

        public boolean think(edict_t ent) {
            GameUtil.G_UseTargets(ent, ent.activator);
            GameUtil.G_FreeEdict(ent);
            return true;
        }
    };
    public static EntThinkAdapter G_FreeEdictA = new EntThinkAdapter(){

        public String getID() {
            return "G_FreeEdictA";
        }

        public boolean think(edict_t ent) {
            GameUtil.G_FreeEdict(ent);
            return false;
        }
    };
    static EntThinkAdapter MegaHealth_think = new EntThinkAdapter(){

        public String getID() {
            return "MegaHealth_think";
        }

        public boolean think(edict_t self) {
            if (self.owner.health > self.owner.max_health) {
                self.nextthink = GameBase.level.time + 1.0f;
                --self.owner.health;
                return false;
            }
            if ((self.spawnflags & 0x10000) == 0 && GameBase.deathmatch.value != 0.0f) {
                GameItems.SetRespawn(self, 20.0f);
            } else {
                GameUtil.G_FreeEdict(self);
            }
            return false;
        }
    };
    public static EntThinkAdapter M_CheckAttack = new EntThinkAdapter(){

        public String getID() {
            return "M_CheckAttack";
        }

        public boolean think(edict_t self) {
            float chance;
            float[] spot1 = new float[]{0.0f, 0.0f, 0.0f};
            float[] spot2 = new float[]{0.0f, 0.0f, 0.0f};
            if (self.enemy.health > 0) {
                Math3D.VectorCopy(self.s.origin, spot1);
                spot1[2] = spot1[2] + (float)self.viewheight;
                Math3D.VectorCopy(self.enemy.s.origin, spot2);
                spot2[2] = spot2[2] + (float)self.enemy.viewheight;
                trace_t tr = GameBase.gi.trace(spot1, null, null, spot2, self, 33554459);
                if (tr.ent != self.enemy) {
                    return false;
                }
            }
            if (GameAI.enemy_range == 0) {
                if (GameBase.skill.value == 0.0f && (Lib.rand() & 3) != 0) {
                    return false;
                }
                self.monsterinfo.attack_state = self.monsterinfo.melee != null ? 3 : 4;
                return true;
            }
            if (self.monsterinfo.attack == null) {
                return false;
            }
            if (GameBase.level.time < self.monsterinfo.attack_finished) {
                return false;
            }
            if (GameAI.enemy_range == 3) {
                return false;
            }
            if ((self.monsterinfo.aiflags & 1) != 0) {
                chance = 0.4f;
            } else if (GameAI.enemy_range == 0) {
                chance = 0.2f;
            } else if (GameAI.enemy_range == 1) {
                chance = 0.1f;
            } else if (GameAI.enemy_range == 2) {
                chance = 0.02f;
            } else {
                return false;
            }
            if (GameBase.skill.value == 0.0f) {
                chance = (float)((double)chance * 0.5);
            } else if (GameBase.skill.value >= 2.0f) {
                chance *= 2.0f;
            }
            if (Lib.random() < chance) {
                self.monsterinfo.attack_state = 4;
                self.monsterinfo.attack_finished = GameBase.level.time + 2.0f * Lib.random();
                return true;
            }
            if ((self.flags & 1) != 0) {
                self.monsterinfo.attack_state = Lib.random() < 0.3f ? 2 : 1;
            }
            return false;
        }
    };
    static EntUseAdapter monster_use = new EntUseAdapter(){

        public String getID() {
            return "monster_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (self.enemy != null) {
                return;
            }
            if (self.health <= 0) {
                return;
            }
            if ((activator.flags & 0x20) != 0) {
                return;
            }
            if (null == activator.client && 0 == (activator.monsterinfo.aiflags & 0x100)) {
                return;
            }
            self.enemy = activator;
            GameUtil.FoundTarget(self);
        }
    };

    public static void checkClassname(edict_t ent) {
        if (ent.classname == null) {
            Com.Printf("edict with classname = null: " + ent.index);
        }
    }

    public static void G_UseTargets(edict_t ent, edict_t activator) {
        edict_t t;
        GameUtil.checkClassname(ent);
        if (ent.delay != 0.0f) {
            edict_t t2 = GameUtil.G_Spawn();
            t2.classname = "DelayedUse";
            t2.nextthink = GameBase.level.time + ent.delay;
            t2.think = Think_Delay;
            t2.activator = activator;
            if (activator == null) {
                GameBase.gi.dprintf("Think_Delay with no activator\n");
            }
            t2.message = ent.message;
            t2.target = ent.target;
            t2.killtarget = ent.killtarget;
            return;
        }
        if (ent.message != null && (activator.svflags & 4) == 0) {
            GameBase.gi.centerprintf(activator, "" + ent.message);
            if (ent.noise_index != 0) {
                GameBase.gi.sound(activator, 0, ent.noise_index, 1.0f, 1.0f, 0.0f);
            } else {
                GameBase.gi.sound(activator, 0, GameBase.gi.soundindex("misc/talk1.wav"), 1.0f, 1.0f, 0.0f);
            }
        }
        EdictIterator edit = null;
        if (ent.killtarget != null) {
            while ((edit = GameBase.G_Find(edit, GameBase.findByTarget, ent.killtarget)) != null) {
                t = edit.o;
                GameUtil.G_FreeEdict(t);
                if (ent.inuse) continue;
                GameBase.gi.dprintf("entity was removed while using killtargets\n");
                return;
            }
        }
        if (ent.target != null) {
            edit = null;
            while ((edit = GameBase.G_Find(edit, GameBase.findByTarget, ent.target)) != null) {
                t = edit.o;
                if (Lib.Q_stricmp("func_areaportal", t.classname) == 0 && (Lib.Q_stricmp("func_door", ent.classname) == 0 || Lib.Q_stricmp("func_door_rotating", ent.classname) == 0)) continue;
                if (t == ent) {
                    GameBase.gi.dprintf("WARNING: Entity used itself.\n");
                } else if (t.use != null) {
                    t.use.use(t, ent, activator);
                }
                if (ent.inuse) continue;
                GameBase.gi.dprintf("entity was removed while using targets\n");
                return;
            }
        }
    }

    public static void G_InitEdict(edict_t e, int i) {
        e.inuse = true;
        e.classname = "noclass";
        e.gravity = 1.0f;
        e.s = new entity_state_t(e);
        e.s.number = i;
        e.index = i;
    }

    public static edict_t G_Spawn() {
        int i;
        edict_t e = null;
        for (i = (int)GameBase.maxclients.value + 1; i < GameBase.num_edicts; ++i) {
            e = GameBase.g_edicts[i];
            if (e.inuse || !(e.freetime < 2.0f) && !((double)(GameBase.level.time - e.freetime) > 0.5)) continue;
            e = GameBase.g_edicts[i] = new edict_t(i);
            GameUtil.G_InitEdict(e, i);
            return e;
        }
        if (i == GameBase.game.maxentities) {
            GameBase.gi.error("ED_Alloc: no free edicts");
        }
        e = GameBase.g_edicts[i] = new edict_t(i);
        ++GameBase.num_edicts;
        GameUtil.G_InitEdict(e, i);
        return e;
    }

    public static void G_FreeEdict(edict_t ed) {
        GameBase.gi.unlinkentity(ed);
        if ((float)ed.index <= GameBase.maxclients.value + 8.0f) {
            return;
        }
        GameBase.g_edicts[ed.index] = new edict_t(ed.index);
        ed.classname = "freed";
        ed.freetime = GameBase.level.time;
        ed.inuse = false;
    }

    public static void G_ClearEdict(edict_t ent) {
        int i = ent.index;
        GameBase.g_edicts[i] = new edict_t(i);
    }

    public static boolean KillBox(edict_t ent) {
        block1: {
            trace_t tr;
            do {
                tr = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, ent.s.origin, null, 33619971);
                if (tr.ent == null || tr.ent == GameBase.g_edicts[0]) break block1;
                GameCombat.T_Damage(tr.ent, ent, ent, Globals.vec3_origin, ent.s.origin, Globals.vec3_origin, 100000, 0, 32, 21);
            } while (tr.ent.solid == 0);
            return false;
        }
        return true;
    }

    public static boolean OnSameTeam(edict_t ent1, edict_t ent2) {
        if (0 == ((int)GameBase.dmflags.value & 0xC0)) {
            return false;
        }
        return GameUtil.ClientTeam(ent1).equals(GameUtil.ClientTeam(ent2));
    }

    static String ClientTeam(edict_t ent) {
        if (ent.client == null) {
            return "";
        }
        String value = Info.Info_ValueForKey(ent.client.pers.userinfo, "skin");
        int p = value.indexOf("/");
        if (p == -1) {
            return value;
        }
        if (((int)GameBase.dmflags.value & 0x80) != 0) {
            return value.substring(0, p);
        }
        return value.substring(p + 1, value.length());
    }

    static void ValidateSelectedItem(edict_t ent) {
        gclient_t cl = ent.client;
        if (cl.pers.inventory[cl.pers.selected_item] != 0) {
            return;
        }
        GameItems.SelectNextItem(ent, -1);
    }

    public static int range(edict_t self, edict_t other) {
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorSubtract(self.s.origin, other.s.origin, v);
        float len = Math3D.VectorLength(v);
        if (len < 80.0f) {
            return 0;
        }
        if (len < 500.0f) {
            return 1;
        }
        if (len < 1000.0f) {
            return 2;
        }
        return 3;
    }

    static void AttackFinished(edict_t self, float time) {
        self.monsterinfo.attack_finished = GameBase.level.time + time;
    }

    public static boolean infront(edict_t self, edict_t other) {
        float[] vec = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.AngleVectors(self.s.angles, forward, null, null);
        Math3D.VectorSubtract(other.s.origin, self.s.origin, vec);
        Math3D.VectorNormalize(vec);
        float dot = Math3D.DotProduct(vec, forward);
        return (double)dot > 0.3;
    }

    public static boolean visible(edict_t self, edict_t other) {
        float[] spot1 = new float[]{0.0f, 0.0f, 0.0f};
        float[] spot2 = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorCopy(self.s.origin, spot1);
        spot1[2] = spot1[2] + (float)self.viewheight;
        Math3D.VectorCopy(other.s.origin, spot2);
        spot2[2] = spot2[2] + (float)other.viewheight;
        trace_t trace = GameBase.gi.trace(spot1, Globals.vec3_origin, Globals.vec3_origin, spot2, self, 25);
        return (double)trace.fraction == 1.0;
    }

    static boolean FindTarget(edict_t self) {
        edict_t client;
        if ((self.monsterinfo.aiflags & 0x100) != 0) {
            if (self.goalentity != null && self.goalentity.inuse && self.goalentity.classname != null && self.goalentity.classname.equals("target_actor")) {
                return false;
            }
            return false;
        }
        if ((self.monsterinfo.aiflags & 0x1000) != 0) {
            return false;
        }
        boolean heardit = false;
        if (GameBase.level.sight_entity_framenum >= GameBase.level.framenum - 1 && 0 == (self.spawnflags & 1)) {
            client = GameBase.level.sight_entity;
            if (client.enemy == self.enemy) {
                return false;
            }
        } else if (GameBase.level.sound_entity_framenum >= GameBase.level.framenum - 1) {
            client = GameBase.level.sound_entity;
            heardit = true;
        } else if (null != self.enemy && GameBase.level.sound2_entity_framenum >= GameBase.level.framenum - 1 && 0 != (self.spawnflags & 1)) {
            client = GameBase.level.sound2_entity;
            heardit = true;
        } else {
            client = GameBase.level.sight_client;
            if (client == null) {
                return false;
            }
        }
        if (!client.inuse) {
            return false;
        }
        if (client.client != null) {
            if ((client.flags & 0x20) != 0) {
                return false;
            }
        } else if ((client.svflags & 4) != 0) {
            if (client.enemy == null) {
                return false;
            }
            if ((client.enemy.flags & 0x20) != 0) {
                return false;
            }
        } else if (heardit) {
            if ((client.owner.flags & 0x20) != 0) {
                return false;
            }
        } else {
            return false;
        }
        if (!heardit) {
            int r = GameUtil.range(self, client);
            if (r == 3) {
                return false;
            }
            if (client.light_level <= 5) {
                return false;
            }
            if (!GameUtil.visible(self, client)) {
                return false;
            }
            if (r == 1 ? (float)client.show_hostile < GameBase.level.time && !GameUtil.infront(self, client) : r == 2 && !GameUtil.infront(self, client)) {
                return false;
            }
            if (client == self.enemy) {
                return true;
            }
            self.enemy = client;
            if (!self.enemy.classname.equals("player_noise")) {
                self.monsterinfo.aiflags &= 0xFFFFFFFB;
                if (self.enemy.client == null) {
                    self.enemy = self.enemy.enemy;
                    if (self.enemy.client == null) {
                        self.enemy = null;
                        return false;
                    }
                }
            }
        } else {
            float[] temp = new float[]{0.0f, 0.0f, 0.0f};
            if ((self.spawnflags & 1) != 0 ? !GameUtil.visible(self, client) : !GameBase.gi.inPHS(self.s.origin, client.s.origin)) {
                return false;
            }
            Math3D.VectorSubtract(client.s.origin, self.s.origin, temp);
            if (Math3D.VectorLength(temp) > 1000.0f) {
                return false;
            }
            if (client.areanum != self.areanum && !GameBase.gi.AreasConnected(self.areanum, client.areanum)) {
                return false;
            }
            self.ideal_yaw = Math3D.vectoyaw(temp);
            M.M_ChangeYaw(self);
            self.monsterinfo.aiflags |= 4;
            if (client == self.enemy) {
                return true;
            }
            self.enemy = client;
        }
        GameUtil.FoundTarget(self);
        if (0 == (self.monsterinfo.aiflags & 4) && self.monsterinfo.sight != null) {
            self.monsterinfo.sight.interact(self, self.enemy);
        }
        return true;
    }

    public static void FoundTarget(edict_t self) {
        if (self.enemy.client != null) {
            GameBase.level.sight_entity = self;
            GameBase.level.sight_entity_framenum = GameBase.level.framenum;
            GameBase.level.sight_entity.light_level = 128;
        }
        self.show_hostile = (int)GameBase.level.time + 1;
        Math3D.VectorCopy(self.enemy.s.origin, self.monsterinfo.last_sighting);
        self.monsterinfo.trail_time = GameBase.level.time;
        if (self.combattarget == null) {
            GameAI.HuntTarget(self);
            return;
        }
        self.goalentity = self.movetarget = GameBase.G_PickTarget(self.combattarget);
        if (self.movetarget == null) {
            self.goalentity = self.movetarget = self.enemy;
            GameAI.HuntTarget(self);
            GameBase.gi.dprintf("" + self.classname + "at " + Lib.vtos(self.s.origin) + ", combattarget " + self.combattarget + " not found\n");
            return;
        }
        self.combattarget = null;
        self.monsterinfo.aiflags |= 0x1000;
        self.movetarget.targetname = null;
        self.monsterinfo.pausetime = 0.0f;
        self.monsterinfo.run.think(self);
    }
}

