/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EntBlockedAdapter;
import jake2.game.EntDieAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameItems;
import jake2.game.GameUtil;
import jake2.game.GameWeapon;
import jake2.game.edict_t;
import jake2.game.monsters.M_Infantry;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameTurret {
    static EntBlockedAdapter turret_blocked = new EntBlockedAdapter(){

        public String getID() {
            return "turret_blocked";
        }

        public void blocked(edict_t self, edict_t other) {
            if (other.takedamage != 0) {
                edict_t attacker = self.teammaster.owner != null ? self.teammaster.owner : self.teammaster;
                GameCombat.T_Damage(other, self, attacker, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.teammaster.dmg, 10, 0, 20);
            }
        }
    };
    static EntThinkAdapter turret_breach_think = new EntThinkAdapter(){

        public String getID() {
            return "turret_breach_think";
        }

        public boolean think(edict_t self) {
            float[] current_angles = new float[]{0.0f, 0.0f, 0.0f};
            float[] delta = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorCopy(self.s.angles, current_angles);
            GameTurret.AnglesNormalize(current_angles);
            GameTurret.AnglesNormalize(self.move_angles);
            if (self.move_angles[0] > 180.0f) {
                self.move_angles[0] = self.move_angles[0] - 360.0f;
            }
            if (self.move_angles[0] > self.pos1[0]) {
                self.move_angles[0] = self.pos1[0];
            } else if (self.move_angles[0] < self.pos2[0]) {
                self.move_angles[0] = self.pos2[0];
            }
            if (self.move_angles[1] < self.pos1[1] || self.move_angles[1] > self.pos2[1]) {
                float dmin = Math.abs(self.pos1[1] - self.move_angles[1]);
                if (dmin < -180.0f) {
                    dmin += 360.0f;
                } else if (dmin > 180.0f) {
                    dmin -= 360.0f;
                }
                float dmax = Math.abs(self.pos2[1] - self.move_angles[1]);
                if (dmax < -180.0f) {
                    dmax += 360.0f;
                } else if (dmax > 180.0f) {
                    dmax -= 360.0f;
                }
                self.move_angles[1] = Math.abs(dmin) < Math.abs(dmax) ? self.pos1[1] : self.pos2[1];
            }
            Math3D.VectorSubtract(self.move_angles, current_angles, delta);
            if (delta[0] < -180.0f) {
                delta[0] = delta[0] + 360.0f;
            } else if (delta[0] > 180.0f) {
                delta[0] = delta[0] - 360.0f;
            }
            if (delta[1] < -180.0f) {
                delta[1] = delta[1] + 360.0f;
            } else if (delta[1] > 180.0f) {
                delta[1] = delta[1] - 360.0f;
            }
            delta[2] = 0.0f;
            if (delta[0] > self.speed * 0.1f) {
                delta[0] = self.speed * 0.1f;
            }
            if (delta[0] < -1.0f * self.speed * 0.1f) {
                delta[0] = -1.0f * self.speed * 0.1f;
            }
            if (delta[1] > self.speed * 0.1f) {
                delta[1] = self.speed * 0.1f;
            }
            if (delta[1] < -1.0f * self.speed * 0.1f) {
                delta[1] = -1.0f * self.speed * 0.1f;
            }
            Math3D.VectorScale(delta, 10.0f, self.avelocity);
            self.nextthink = GameBase.level.time + 0.1f;
            edict_t ent = self.teammaster;
            while (ent != null) {
                ent.avelocity[1] = self.avelocity[1];
                ent = ent.teamchain;
            }
            if (self.owner != null) {
                float[] target = new float[]{0.0f, 0.0f, 0.0f};
                float[] dir = new float[]{0.0f, 0.0f, 0.0f};
                self.owner.avelocity[0] = self.avelocity[0];
                self.owner.avelocity[1] = self.avelocity[1];
                float angle = self.s.angles[1] + self.owner.move_origin[1];
                angle = (float)((double)angle * (Math.PI / 180));
                target[0] = GameTurret.SnapToEights((float)((double)self.s.origin[0] + Math.cos(angle) * (double)self.owner.move_origin[0]));
                target[1] = GameTurret.SnapToEights((float)((double)self.s.origin[1] + Math.sin(angle) * (double)self.owner.move_origin[0]));
                target[2] = self.owner.s.origin[2];
                Math3D.VectorSubtract(target, self.owner.s.origin, dir);
                self.owner.velocity[0] = dir[0] * 1.0f / 0.1f;
                self.owner.velocity[1] = dir[1] * 1.0f / 0.1f;
                angle = self.s.angles[0] * ((float)Math.PI / 180);
                float target_z = GameTurret.SnapToEights((float)((double)self.s.origin[2] + (double)self.owner.move_origin[0] * Math.tan(angle) + (double)self.owner.move_origin[2]));
                float diff = target_z - self.owner.s.origin[2];
                self.owner.velocity[2] = diff * 1.0f / 0.1f;
                if ((self.spawnflags & 0x10000) != 0) {
                    GameTurret.turret_breach_fire(self);
                    self.spawnflags &= 0xFFFEFFFF;
                }
            }
            return true;
        }
    };
    static EntThinkAdapter turret_breach_finish_init = new EntThinkAdapter(){

        public String getID() {
            return "turret_breach_finish_init";
        }

        public boolean think(edict_t self) {
            if (self.target == null) {
                GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + " needs a target\n");
            } else {
                self.target_ent = GameBase.G_PickTarget(self.target);
                Math3D.VectorSubtract(self.target_ent.s.origin, self.s.origin, self.move_origin);
                GameUtil.G_FreeEdict(self.target_ent);
            }
            self.teammaster.dmg = self.dmg;
            self.think = turret_breach_think;
            self.think.think(self);
            return true;
        }
    };
    static EntDieAdapter turret_driver_die = new EntDieAdapter(){

        public String getID() {
            return "turret_driver_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            self.target_ent.move_angles[0] = 0.0f;
            edict_t ent = self.target_ent.teammaster;
            while (ent.teamchain != self) {
                ent = ent.teamchain;
            }
            ent.teamchain = null;
            self.teammaster = null;
            self.flags &= 0xFFFFFBFF;
            self.target_ent.owner = null;
            self.target_ent.teammaster.owner = null;
            M_Infantry.infantry_die.die(self, inflictor, attacker, damage, null);
        }
    };
    static EntThinkAdapter turret_driver_think = new EntThinkAdapter(){

        public String getID() {
            return "turret_driver_think";
        }

        public boolean think(edict_t self) {
            float[] target = new float[]{0.0f, 0.0f, 0.0f};
            float[] dir = new float[]{0.0f, 0.0f, 0.0f};
            self.nextthink = GameBase.level.time + 0.1f;
            if (!(self.enemy == null || self.enemy.inuse && self.enemy.health > 0)) {
                self.enemy = null;
            }
            if (null == self.enemy) {
                if (!GameUtil.FindTarget(self)) {
                    return true;
                }
                self.monsterinfo.trail_time = GameBase.level.time;
                self.monsterinfo.aiflags &= 0xFFFFFFF7;
            } else if (GameUtil.visible(self, self.enemy)) {
                if ((self.monsterinfo.aiflags & 8) != 0) {
                    self.monsterinfo.trail_time = GameBase.level.time;
                    self.monsterinfo.aiflags &= 0xFFFFFFF7;
                }
            } else {
                self.monsterinfo.aiflags |= 8;
                return true;
            }
            Math3D.VectorCopy(self.enemy.s.origin, target);
            target[2] = target[2] + (float)self.enemy.viewheight;
            Math3D.VectorSubtract(target, self.target_ent.s.origin, dir);
            Math3D.vectoangles(dir, self.target_ent.move_angles);
            if (GameBase.level.time < self.monsterinfo.attack_finished) {
                return true;
            }
            float reaction_time = (3.0f - GameBase.skill.value) * 1.0f;
            if (GameBase.level.time - self.monsterinfo.trail_time < reaction_time) {
                return true;
            }
            self.monsterinfo.attack_finished = GameBase.level.time + reaction_time + 1.0f;
            self.target_ent.spawnflags |= 0x10000;
            return true;
        }
    };
    public static EntThinkAdapter turret_driver_link = new EntThinkAdapter(){

        public String getID() {
            return "turret_driver_link";
        }

        public boolean think(edict_t self) {
            float[] vec = new float[]{0.0f, 0.0f, 0.0f};
            self.think = turret_driver_think;
            self.nextthink = GameBase.level.time + 0.1f;
            self.target_ent = GameBase.G_PickTarget(self.target);
            self.target_ent.owner = self;
            self.target_ent.teammaster.owner = self;
            Math3D.VectorCopy(self.target_ent.s.angles, self.s.angles);
            vec[0] = self.target_ent.s.origin[0] - self.s.origin[0];
            vec[1] = self.target_ent.s.origin[1] - self.s.origin[1];
            vec[2] = 0.0f;
            self.move_origin[0] = Math3D.VectorLength(vec);
            Math3D.VectorSubtract(self.s.origin, self.target_ent.s.origin, vec);
            Math3D.vectoangles(vec, vec);
            GameTurret.AnglesNormalize(vec);
            self.move_origin[1] = vec[1];
            self.move_origin[2] = self.s.origin[2] - self.target_ent.s.origin[2];
            edict_t ent = self.target_ent.teammaster;
            while (ent.teamchain != null) {
                ent = ent.teamchain;
            }
            ent.teamchain = self;
            self.teammaster = self.target_ent.teammaster;
            self.flags |= 0x400;
            return true;
        }
    };

    public static void AnglesNormalize(float[] vec) {
        while (vec[0] > 360.0f) {
            vec[0] = vec[0] - 360.0f;
        }
        while (vec[0] < 0.0f) {
            vec[0] = vec[0] + 360.0f;
        }
        while (vec[1] > 360.0f) {
            vec[1] = vec[1] - 360.0f;
        }
        while (vec[1] < 0.0f) {
            vec[1] = vec[1] + 360.0f;
        }
    }

    public static float SnapToEights(float x) {
        x = (double)(x = (float)((double)x * 8.0)) > 0.0 ? (float)((double)x + 0.5) : (float)((double)x - 0.5);
        return 0.125f * (float)((int)x);
    }

    public static void turret_breach_fire(edict_t self) {
        float[] f = new float[]{0.0f, 0.0f, 0.0f};
        float[] r = new float[]{0.0f, 0.0f, 0.0f};
        float[] u = new float[]{0.0f, 0.0f, 0.0f};
        float[] start = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.AngleVectors(self.s.angles, f, r, u);
        Math3D.VectorMA(self.s.origin, self.move_origin[0], f, start);
        Math3D.VectorMA(start, self.move_origin[1], r, start);
        Math3D.VectorMA(start, self.move_origin[2], u, start);
        int damage = (int)(100.0f + Lib.random() * 50.0f);
        int speed = (int)(550.0f + 50.0f * GameBase.skill.value);
        GameWeapon.fire_rocket(self.teammaster.owner, start, f, damage, speed, 150.0f, damage);
        GameBase.gi.positioned_sound(start, self, 1, GameBase.gi.soundindex("weapons/rocklf1a.wav"), 1.0f, 1.0f, 0.0f);
    }

    public static void SP_turret_breach(edict_t self) {
        self.solid = 3;
        self.movetype = 2;
        GameBase.gi.setmodel(self, self.model);
        if (self.speed == 0.0f) {
            self.speed = 50.0f;
        }
        if (self.dmg == 0) {
            self.dmg = 10;
        }
        if (GameBase.st.minpitch == 0.0f) {
            GameBase.st.minpitch = -30.0f;
        }
        if (GameBase.st.maxpitch == 0.0f) {
            GameBase.st.maxpitch = 30.0f;
        }
        if (GameBase.st.maxyaw == 0.0f) {
            GameBase.st.maxyaw = 360.0f;
        }
        self.pos1[0] = -1.0f * GameBase.st.minpitch;
        self.pos1[1] = GameBase.st.minyaw;
        self.pos2[0] = -1.0f * GameBase.st.maxpitch;
        self.pos2[1] = GameBase.st.maxyaw;
        self.move_angles[1] = self.ideal_yaw = self.s.angles[1];
        self.blocked = turret_blocked;
        self.think = turret_breach_finish_init;
        self.nextthink = GameBase.level.time + 0.1f;
        GameBase.gi.linkentity(self);
    }

    public static void SP_turret_base(edict_t self) {
        self.solid = 3;
        self.movetype = 2;
        GameBase.gi.setmodel(self, self.model);
        self.blocked = turret_blocked;
        GameBase.gi.linkentity(self);
    }

    public static void SP_turret_driver(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.movetype = 2;
        self.solid = 2;
        self.s.modelindex = GameBase.gi.modelindex("models/monsters/infantry/tris.md2");
        Math3D.VectorSet(self.mins, -16.0f, -16.0f, -24.0f);
        Math3D.VectorSet(self.maxs, 16.0f, 16.0f, 32.0f);
        self.health = 100;
        self.gib_health = 0;
        self.mass = 200;
        self.viewheight = 24;
        self.die = turret_driver_die;
        self.monsterinfo.stand = M_Infantry.infantry_stand;
        self.flags |= 0x800;
        ++GameBase.level.total_monsters;
        self.svflags |= 4;
        self.s.renderfx |= 0x40;
        self.takedamage = 2;
        self.use = GameUtil.monster_use;
        self.clipmask = 0x2020003;
        Math3D.VectorCopy(self.s.origin, self.s.old_origin);
        self.monsterinfo.aiflags |= 0x801;
        if (GameBase.st.item != null) {
            self.item = GameItems.FindItemByClassname(GameBase.st.item);
            if (self.item == null) {
                GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + " has bad item: " + GameBase.st.item + "\n");
            }
        }
        self.think = turret_driver_link;
        self.nextthink = GameBase.level.time + 0.1f;
        GameBase.gi.linkentity(self);
    }
}

