/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EntThinkAdapter;
import jake2.game.EntTouchAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameItems;
import jake2.game.GameUtil;
import jake2.game.cplane_t;
import jake2.game.csurface_t;
import jake2.game.edict_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameTrigger {
    public static EntThinkAdapter multi_wait = new EntThinkAdapter(){

        public String getID() {
            return "multi_wait";
        }

        public boolean think(edict_t ent) {
            ent.nextthink = 0.0f;
            return true;
        }
    };
    static EntUseAdapter Use_Multi = new EntUseAdapter(){

        public String getID() {
            return "Use_Multi";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            ent.activator = activator;
            GameTrigger.multi_trigger(ent);
        }
    };
    static EntTouchAdapter Touch_Multi = new EntTouchAdapter(){

        public String getID() {
            return "Touch_Multi";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (other.client != null) {
                if ((self.spawnflags & 2) != 0) {
                    return;
                }
            } else if ((other.svflags & 4) != 0) {
                if (0 == (self.spawnflags & 1)) {
                    return;
                }
            } else {
                return;
            }
            if (!Math3D.VectorEquals(self.movedir, Globals.vec3_origin)) {
                float[] forward = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.AngleVectors(other.s.angles, forward, null, null);
                if (Math3D.DotProduct(forward, self.movedir) < 0.0f) {
                    return;
                }
            }
            self.activator = other;
            GameTrigger.multi_trigger(self);
        }
    };
    static EntUseAdapter trigger_enable = new EntUseAdapter(){

        public String getID() {
            return "trigger_enable";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.solid = 1;
            self.use = Use_Multi;
            GameBase.gi.linkentity(self);
        }
    };
    public static EntUseAdapter trigger_relay_use = new EntUseAdapter(){

        public String getID() {
            return "trigger_relay_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            GameUtil.G_UseTargets(self, activator);
        }
    };
    static EntUseAdapter trigger_key_use = new EntUseAdapter(){

        public String getID() {
            return "trigger_key_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (self.item == null) {
                return;
            }
            if (activator.client == null) {
                return;
            }
            int index = GameItems.ITEM_INDEX(self.item);
            if (activator.client.pers.inventory[index] == 0) {
                if (GameBase.level.time < self.touch_debounce_time) {
                    return;
                }
                self.touch_debounce_time = GameBase.level.time + 5.0f;
                GameBase.gi.centerprintf(activator, "You need the " + self.item.pickup_name);
                GameBase.gi.sound(activator, 0, GameBase.gi.soundindex("misc/keytry.wav"), 1.0f, 1.0f, 0.0f);
                return;
            }
            GameBase.gi.sound(activator, 0, GameBase.gi.soundindex("misc/keyuse.wav"), 1.0f, 1.0f, 0.0f);
            if (GameBase.coop.value != 0.0f) {
                if (Lib.strcmp(self.item.classname, "key_power_cube") == 0) {
                    int cube;
                    for (cube = 0; cube < 8 && (activator.client.pers.power_cubes & 1 << cube) == 0; ++cube) {
                    }
                    for (int player = 1; player <= GameBase.game.maxclients; ++player) {
                        edict_t ent = GameBase.g_edicts[player];
                        if (!ent.inuse || null == ent.client || (ent.client.pers.power_cubes & 1 << cube) == 0) continue;
                        int n = index;
                        ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                        ent.client.pers.power_cubes &= ~(1 << cube);
                    }
                } else {
                    for (int player = 1; player <= GameBase.game.maxclients; ++player) {
                        edict_t ent = GameBase.g_edicts[player];
                        if (!ent.inuse || ent.client == null) continue;
                        ent.client.pers.inventory[index] = 0;
                    }
                }
            } else {
                int n = index;
                activator.client.pers.inventory[n] = activator.client.pers.inventory[n] - 1;
            }
            GameUtil.G_UseTargets(self, activator);
            self.use = null;
        }
    };
    static EntUseAdapter trigger_counter_use = new EntUseAdapter(){

        public String getID() {
            return "trigger_counter_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (self.count == 0) {
                return;
            }
            --self.count;
            if (self.count != 0) {
                if (0 == (self.spawnflags & 1)) {
                    GameBase.gi.centerprintf(activator, self.count + " more to go...");
                    GameBase.gi.sound(activator, 0, GameBase.gi.soundindex("misc/talk1.wav"), 1.0f, 1.0f, 0.0f);
                }
                return;
            }
            if (0 == (self.spawnflags & 1)) {
                GameBase.gi.centerprintf(activator, "Sequence completed!");
                GameBase.gi.sound(activator, 0, GameBase.gi.soundindex("misc/talk1.wav"), 1.0f, 1.0f, 0.0f);
            }
            self.activator = activator;
            GameTrigger.multi_trigger(self);
        }
    };
    public static final int PUSH_ONCE = 1;
    public static int windsound;
    static EntTouchAdapter trigger_push_touch;
    static EntUseAdapter hurt_use;
    static EntTouchAdapter hurt_touch;
    static EntTouchAdapter trigger_gravity_touch;
    static EntTouchAdapter trigger_monsterjump_touch;

    public static void InitTrigger(edict_t self) {
        if (!Math3D.VectorEquals(self.s.angles, Globals.vec3_origin)) {
            GameBase.G_SetMovedir(self.s.angles, self.movedir);
        }
        self.solid = 1;
        self.movetype = 0;
        GameBase.gi.setmodel(self, self.model);
        self.svflags = 1;
    }

    public static void multi_trigger(edict_t ent) {
        if (ent.nextthink != 0.0f) {
            return;
        }
        GameUtil.G_UseTargets(ent, ent.activator);
        if (ent.wait > 0.0f) {
            ent.think = multi_wait;
            ent.nextthink = GameBase.level.time + ent.wait;
        } else {
            ent.touch = null;
            ent.nextthink = GameBase.level.time + 0.1f;
            ent.think = GameUtil.G_FreeEdictA;
        }
    }

    public static void SP_trigger_multiple(edict_t ent) {
        if (ent.sounds == 1) {
            ent.noise_index = GameBase.gi.soundindex("misc/secret.wav");
        } else if (ent.sounds == 2) {
            ent.noise_index = GameBase.gi.soundindex("misc/talk.wav");
        } else if (ent.sounds == 3) {
            ent.noise_index = GameBase.gi.soundindex("misc/trigger1.wav");
        }
        if (ent.wait == 0.0f) {
            ent.wait = 0.2f;
        }
        ent.touch = Touch_Multi;
        ent.movetype = 0;
        ent.svflags |= 1;
        if ((ent.spawnflags & 4) != 0) {
            ent.solid = 0;
            ent.use = trigger_enable;
        } else {
            ent.solid = 1;
            ent.use = Use_Multi;
        }
        if (!Math3D.VectorEquals(ent.s.angles, Globals.vec3_origin)) {
            GameBase.G_SetMovedir(ent.s.angles, ent.movedir);
        }
        GameBase.gi.setmodel(ent, ent.model);
        GameBase.gi.linkentity(ent);
    }

    public static void SP_trigger_once(edict_t ent) {
        if ((ent.spawnflags & 1) != 0) {
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorMA(ent.mins, 0.5f, ent.size, v);
            ent.spawnflags &= 0xFFFFFFFE;
            ent.spawnflags |= 4;
            GameBase.gi.dprintf("fixed TRIGGERED flag on " + ent.classname + " at " + Lib.vtos(v) + "\n");
        }
        ent.wait = -1.0f;
        GameTrigger.SP_trigger_multiple(ent);
    }

    public static void SP_trigger_relay(edict_t self) {
        self.use = trigger_relay_use;
    }

    public static void SP_trigger_key(edict_t self) {
        if (GameBase.st.item == null) {
            GameBase.gi.dprintf("no key item for trigger_key at " + Lib.vtos(self.s.origin) + "\n");
            return;
        }
        self.item = GameItems.FindItemByClassname(GameBase.st.item);
        if (null == self.item) {
            GameBase.gi.dprintf("item " + GameBase.st.item + " not found for trigger_key at " + Lib.vtos(self.s.origin) + "\n");
            return;
        }
        if (self.target == null) {
            GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + " has no target\n");
            return;
        }
        GameBase.gi.soundindex("misc/keytry.wav");
        GameBase.gi.soundindex("misc/keyuse.wav");
        self.use = trigger_key_use;
    }

    public static void SP_trigger_counter(edict_t self) {
        self.wait = -1.0f;
        if (0 == self.count) {
            self.count = 2;
        }
        self.use = trigger_counter_use;
    }

    public static void SP_trigger_always(edict_t ent) {
        if (ent.delay < 0.2f) {
            ent.delay = 0.2f;
        }
        GameUtil.G_UseTargets(ent, ent);
    }

    public static void SP_trigger_push(edict_t self) {
        GameTrigger.InitTrigger(self);
        windsound = GameBase.gi.soundindex("misc/windfly.wav");
        self.touch = trigger_push_touch;
        if (0.0f == self.speed) {
            self.speed = 1000.0f;
        }
        GameBase.gi.linkentity(self);
    }

    public static void SP_trigger_hurt(edict_t self) {
        GameTrigger.InitTrigger(self);
        self.noise_index = GameBase.gi.soundindex("world/electro.wav");
        self.touch = hurt_touch;
        if (0 == self.dmg) {
            self.dmg = 5;
        }
        self.solid = (self.spawnflags & 1) != 0 ? 0 : 1;
        if ((self.spawnflags & 2) != 0) {
            self.use = hurt_use;
        }
        GameBase.gi.linkentity(self);
    }

    public static void SP_trigger_gravity(edict_t self) {
        if (GameBase.st.gravity == null) {
            GameBase.gi.dprintf("trigger_gravity without gravity set at " + Lib.vtos(self.s.origin) + "\n");
            GameUtil.G_FreeEdict(self);
            return;
        }
        GameTrigger.InitTrigger(self);
        self.gravity = Lib.atoi(GameBase.st.gravity);
        self.touch = trigger_gravity_touch;
    }

    public static void SP_trigger_monsterjump(edict_t self) {
        if (0.0f == self.speed) {
            self.speed = 200.0f;
        }
        if (0 == GameBase.st.height) {
            GameBase.st.height = 200;
        }
        if (self.s.angles[1] == 0.0f) {
            self.s.angles[1] = 360.0f;
        }
        GameTrigger.InitTrigger(self);
        self.touch = trigger_monsterjump_touch;
        self.movedir[2] = GameBase.st.height;
    }

    static {
        trigger_push_touch = new EntTouchAdapter(){

            public String getID() {
                return "trigger_push_touch";
            }

            public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
                if (Lib.strcmp(other.classname, "grenade") == 0) {
                    Math3D.VectorScale(self.movedir, self.speed * 10.0f, other.velocity);
                } else if (other.health > 0) {
                    Math3D.VectorScale(self.movedir, self.speed * 10.0f, other.velocity);
                    if (other.client != null) {
                        Math3D.VectorCopy(other.velocity, other.client.oldvelocity);
                        if (other.fly_sound_debounce_time < GameBase.level.time) {
                            other.fly_sound_debounce_time = GameBase.level.time + 1.5f;
                            GameBase.gi.sound(other, 0, windsound, 1.0f, 1.0f, 0.0f);
                        }
                    }
                }
                if ((self.spawnflags & 1) != 0) {
                    GameUtil.G_FreeEdict(self);
                }
            }
        };
        hurt_use = new EntUseAdapter(){

            public String getID() {
                return "hurt_use";
            }

            public void use(edict_t self, edict_t other, edict_t activator) {
                self.solid = self.solid == 0 ? 1 : 0;
                GameBase.gi.linkentity(self);
                if (0 == (self.spawnflags & 2)) {
                    self.use = null;
                }
            }
        };
        hurt_touch = new EntTouchAdapter(){

            public String getID() {
                return "hurt_touch";
            }

            public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
                if (other.takedamage == 0) {
                    return;
                }
                if (self.timestamp > GameBase.level.time) {
                    return;
                }
                self.timestamp = (self.spawnflags & 0x10) != 0 ? GameBase.level.time + 1.0f : GameBase.level.time + 0.1f;
                if (0 == (self.spawnflags & 4) && GameBase.level.framenum % 10 == 0) {
                    GameBase.gi.sound(other, 0, self.noise_index, 1.0f, 1.0f, 0.0f);
                }
                int dflags = (self.spawnflags & 8) != 0 ? 32 : 0;
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, self.dmg, dflags, 31);
            }
        };
        trigger_gravity_touch = new EntTouchAdapter(){

            public String getID() {
                return "trigger_gravity_touch";
            }

            public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
                other.gravity = self.gravity;
            }
        };
        trigger_monsterjump_touch = new EntTouchAdapter(){

            public String getID() {
                return "trigger_monsterjump_touch";
            }

            public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
                if ((other.flags & 3) != 0) {
                    return;
                }
                if ((other.svflags & 2) != 0) {
                    return;
                }
                if (0 == (other.svflags & 4)) {
                    return;
                }
                other.velocity[0] = self.movedir[0] * self.speed;
                other.velocity[1] = self.movedir[1] * self.speed;
                if (other.groundentity != null) {
                    return;
                }
                other.groundentity = null;
                other.velocity[2] = self.movedir[2];
            }
        };
    }
}

