/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EdictIterator;
import jake2.game.EntThinkAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameSpawn;
import jake2.game.GameUtil;
import jake2.game.GameWeapon;
import jake2.game.PlayerHud;
import jake2.game.edict_t;
import jake2.game.trace_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameTarget {
    public static EntUseAdapter Use_Target_Tent = new EntUseAdapter(){

        public String getID() {
            return "Use_Target_Tent";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            GameBase.gi.WriteByte(3);
            GameBase.gi.WriteByte(ent.style);
            GameBase.gi.WritePosition(ent.s.origin);
            GameBase.gi.multicast(ent.s.origin, 2);
        }
    };
    public static EntUseAdapter Use_Target_Speaker = new EntUseAdapter(){

        public String getID() {
            return "Use_Target_Speaker";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            if ((ent.spawnflags & 3) != 0) {
                ent.s.sound = ent.s.sound != 0 ? 0 : ent.noise_index;
            } else {
                int chan = (ent.spawnflags & 4) != 0 ? 18 : 2;
                GameBase.gi.positioned_sound(ent.s.origin, ent, chan, ent.noise_index, ent.volume, ent.attenuation, 0.0f);
            }
        }
    };
    public static EntUseAdapter Use_Target_Help = new EntUseAdapter(){

        public String getID() {
            return "Use_Target_Help";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            if ((ent.spawnflags & 1) != 0) {
                GameBase.game.helpmessage1 = ent.message;
            } else {
                GameBase.game.helpmessage2 = ent.message;
            }
            ++GameBase.game.helpchanged;
        }
    };
    static EntUseAdapter use_target_secret = new EntUseAdapter(){

        public String getID() {
            return "use_target_secret";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            GameBase.gi.sound(ent, 2, ent.noise_index, 1.0f, 1.0f, 0.0f);
            ++GameBase.level.found_secrets;
            GameUtil.G_UseTargets(ent, activator);
            GameUtil.G_FreeEdict(ent);
        }
    };
    static EntUseAdapter use_target_goal = new EntUseAdapter(){

        public String getID() {
            return "use_target_goal";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            GameBase.gi.sound(ent, 2, ent.noise_index, 1.0f, 1.0f, 0.0f);
            ++GameBase.level.found_goals;
            if (GameBase.level.found_goals == GameBase.level.total_goals) {
                GameBase.gi.configstring(1, "0");
            }
            GameUtil.G_UseTargets(ent, activator);
            GameUtil.G_FreeEdict(ent);
        }
    };
    static EntThinkAdapter target_explosion_explode = new EntThinkAdapter(){

        public String getID() {
            return "target_explosion_explode";
        }

        public boolean think(edict_t self) {
            GameBase.gi.WriteByte(3);
            GameBase.gi.WriteByte(5);
            GameBase.gi.WritePosition(self.s.origin);
            GameBase.gi.multicast(self.s.origin, 1);
            GameCombat.T_RadiusDamage(self, self.activator, self.dmg, null, self.dmg + 40, 25);
            float save = self.delay;
            self.delay = 0.0f;
            GameUtil.G_UseTargets(self, self.activator);
            self.delay = save;
            return true;
        }
    };
    static EntUseAdapter use_target_explosion = new EntUseAdapter(){

        public String getID() {
            return "use_target_explosion";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.activator = activator;
            if (0.0f == self.delay) {
                target_explosion_explode.think(self);
                return;
            }
            self.think = target_explosion_explode;
            self.nextthink = GameBase.level.time + self.delay;
        }
    };
    static EntUseAdapter use_target_changelevel = new EntUseAdapter(){

        public String getID() {
            return "use_target_changelevel";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (GameBase.level.intermissiontime != 0.0f) {
                return;
            }
            if (0.0f == GameBase.deathmatch.value && 0.0f == GameBase.coop.value && GameBase.g_edicts[1].health <= 0) {
                return;
            }
            if (GameBase.deathmatch.value != 0.0f && 0 == ((int)GameBase.dmflags.value & 0x1000) && other != GameBase.g_edicts[0]) {
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, 10 * other.max_health, 1000, 0, 28);
                return;
            }
            if (GameBase.deathmatch.value != 0.0f && activator != null && activator.client != null) {
                GameBase.gi.bprintf(2, activator.client.pers.netname + " exited the level.\n");
            }
            if (self.map.indexOf(42) > -1) {
                GameBase.game.serverflags &= 0xFFFFFF00;
            }
            PlayerHud.BeginIntermission(self);
        }
    };
    static EntUseAdapter use_target_splash = new EntUseAdapter(){

        public String getID() {
            return "use_target_splash";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            GameBase.gi.WriteByte(3);
            GameBase.gi.WriteByte(10);
            GameBase.gi.WriteByte(self.count);
            GameBase.gi.WritePosition(self.s.origin);
            GameBase.gi.WriteDir(self.movedir);
            GameBase.gi.WriteByte(self.sounds);
            GameBase.gi.multicast(self.s.origin, 2);
            if (self.dmg != 0) {
                GameCombat.T_RadiusDamage(self, activator, self.dmg, null, self.dmg + 40, 29);
            }
        }
    };
    static EntUseAdapter use_target_spawner = new EntUseAdapter(){

        public String getID() {
            return "use_target_spawner";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            edict_t ent = GameUtil.G_Spawn();
            ent.classname = self.target;
            Math3D.VectorCopy(self.s.origin, ent.s.origin);
            Math3D.VectorCopy(self.s.angles, ent.s.angles);
            GameSpawn.ED_CallSpawn(ent);
            GameBase.gi.unlinkentity(ent);
            GameUtil.KillBox(ent);
            GameBase.gi.linkentity(ent);
            if (self.speed != 0.0f) {
                Math3D.VectorCopy(self.movedir, ent.velocity);
            }
        }
    };
    public static EntUseAdapter use_target_blaster = new EntUseAdapter(){

        public String getID() {
            return "use_target_blaster";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if ((self.spawnflags & 2) != 0) {
                boolean effect = false;
            } else if ((self.spawnflags & 1) != 0) {
                int effect = 64;
            } else {
                int effect = 8;
            }
            GameWeapon.fire_blaster(self, self.s.origin, self.movedir, self.dmg, (int)self.speed, 8, true);
            GameBase.gi.sound(self, 2, self.noise_index, 1.0f, 1.0f, 0.0f);
        }
    };
    public static EntUseAdapter trigger_crosslevel_trigger_use = new EntUseAdapter(){

        public String getID() {
            return "trigger_crosslevel_trigger_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            GameBase.game.serverflags |= self.spawnflags;
            GameUtil.G_FreeEdict(self);
        }
    };
    static EntThinkAdapter target_crosslevel_target_think = new EntThinkAdapter(){

        public String getID() {
            return "target_crosslevel_target_think";
        }

        public boolean think(edict_t self) {
            if (self.spawnflags == (GameBase.game.serverflags & 0xFF & self.spawnflags)) {
                GameUtil.G_UseTargets(self, self);
                GameUtil.G_FreeEdict(self);
            }
            return true;
        }
    };
    public static EntThinkAdapter target_laser_think = new EntThinkAdapter(){

        public String getID() {
            return "target_laser_think";
        }

        public boolean think(edict_t self) {
            trace_t tr;
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] end = new float[]{0.0f, 0.0f, 0.0f};
            float[] point = new float[]{0.0f, 0.0f, 0.0f};
            float[] last_movedir = new float[]{0.0f, 0.0f, 0.0f};
            int count = (self.spawnflags & Integer.MIN_VALUE) != 0 ? 8 : 4;
            if (self.enemy != null) {
                Math3D.VectorCopy(self.movedir, last_movedir);
                Math3D.VectorMA(self.enemy.absmin, 0.5f, self.enemy.size, point);
                Math3D.VectorSubtract(point, self.s.origin, self.movedir);
                Math3D.VectorNormalize(self.movedir);
                if (!Math3D.VectorEquals(self.movedir, last_movedir)) {
                    self.spawnflags |= Integer.MIN_VALUE;
                }
            }
            edict_t ignore = self;
            Math3D.VectorCopy(self.s.origin, start);
            Math3D.VectorMA(start, 2048.0f, self.movedir, end);
            while (true) {
                tr = GameBase.gi.trace(start, null, null, end, ignore, 0x6000001);
                if (tr.ent == null) break;
                if (tr.ent.takedamage != 0 && 0 == (tr.ent.flags & 4)) {
                    GameCombat.T_Damage(tr.ent, self, self.activator, self.movedir, tr.endpos, Globals.vec3_origin, self.dmg, 1, 4, 30);
                }
                if (0 == (tr.ent.svflags & 4) && null == tr.ent.client) {
                    if ((self.spawnflags & Integer.MIN_VALUE) == 0) break;
                    self.spawnflags &= Integer.MAX_VALUE;
                    GameBase.gi.WriteByte(3);
                    GameBase.gi.WriteByte(15);
                    GameBase.gi.WriteByte(count);
                    GameBase.gi.WritePosition(tr.endpos);
                    GameBase.gi.WriteDir(tr.plane.normal);
                    GameBase.gi.WriteByte(self.s.skinnum);
                    GameBase.gi.multicast(tr.endpos, 2);
                    break;
                }
                ignore = tr.ent;
                Math3D.VectorCopy(tr.endpos, start);
            }
            Math3D.VectorCopy(tr.endpos, self.s.old_origin);
            self.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };
    public static EntUseAdapter target_laser_use = new EntUseAdapter(){

        public String getID() {
            return "target_laser_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.activator = activator;
            if ((self.spawnflags & 1) != 0) {
                GameTarget.target_laser_off(self);
            } else {
                GameTarget.target_laser_on(self);
            }
        }
    };
    static EntThinkAdapter target_laser_start = new EntThinkAdapter(){

        public String getID() {
            return "target_laser_start";
        }

        public boolean think(edict_t self) {
            self.movetype = 0;
            self.solid = 0;
            self.s.renderfx |= 0xA0;
            self.s.modelindex = 1;
            self.s.frame = (self.spawnflags & 0x40) != 0 ? 16 : 4;
            if ((self.spawnflags & 2) != 0) {
                self.s.skinnum = -218959632;
            } else if ((self.spawnflags & 4) != 0) {
                self.s.skinnum = -791555373;
            } else if ((self.spawnflags & 8) != 0) {
                self.s.skinnum = -202116623;
            } else if ((self.spawnflags & 0x10) != 0) {
                self.s.skinnum = -589439265;
            } else if ((self.spawnflags & 0x20) != 0) {
                self.s.skinnum = -522067229;
            }
            if (null == self.enemy) {
                if (self.target != null) {
                    EdictIterator edit = GameBase.G_Find(null, GameBase.findByTarget, self.target);
                    if (edit == null) {
                        GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + ": " + self.target + " is a bad target\n");
                    }
                    self.enemy = edit.o;
                } else {
                    GameBase.G_SetMovedir(self.s.angles, self.movedir);
                }
            }
            self.use = target_laser_use;
            self.think = target_laser_think;
            if (0 == self.dmg) {
                self.dmg = 1;
            }
            Math3D.VectorSet(self.mins, -8.0f, -8.0f, -8.0f);
            Math3D.VectorSet(self.maxs, 8.0f, 8.0f, 8.0f);
            GameBase.gi.linkentity(self);
            if ((self.spawnflags & 1) != 0) {
                GameTarget.target_laser_on(self);
            } else {
                GameTarget.target_laser_off(self);
            }
            return true;
        }
    };
    static EntThinkAdapter target_lightramp_think = new EntThinkAdapter(){

        public String getID() {
            return "target_lightramp_think";
        }

        public boolean think(edict_t self) {
            char[] tmp = new char[]{(char)(97 + (int)(self.movedir[0] + (GameBase.level.time - self.timestamp) / 0.1f * self.movedir[2]))};
            GameBase.gi.configstring(800 + self.enemy.style, new String(tmp));
            if (GameBase.level.time - self.timestamp < self.speed) {
                self.nextthink = GameBase.level.time + 0.1f;
            } else if ((self.spawnflags & 1) != 0) {
                char temp = (char)self.movedir[0];
                self.movedir[0] = self.movedir[1];
                self.movedir[1] = temp;
                self.movedir[2] = self.movedir[2] * -1.0f;
            }
            return true;
        }
    };
    static EntUseAdapter target_lightramp_use = new EntUseAdapter(){

        public String getID() {
            return "target_lightramp_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (self.enemy == null) {
                edict_t e = null;
                EdictIterator es = null;
                while ((es = GameBase.G_Find(es, GameBase.findByTarget, self.target)) != null) {
                    e = es.o;
                    if (Lib.strcmp(e.classname, "light") != 0) {
                        GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin));
                        GameBase.gi.dprintf("target " + self.target + " (" + e.classname + " at " + Lib.vtos(e.s.origin) + ") is not a light\n");
                        continue;
                    }
                    self.enemy = e;
                }
                if (null == self.enemy) {
                    GameBase.gi.dprintf(self.classname + " target " + self.target + " not found at " + Lib.vtos(self.s.origin) + "\n");
                    GameUtil.G_FreeEdict(self);
                    return;
                }
            }
            self.timestamp = GameBase.level.time;
            target_lightramp_think.think(self);
        }
    };
    static EntThinkAdapter target_earthquake_think = new EntThinkAdapter(){

        public String getID() {
            return "target_earthquake_think";
        }

        public boolean think(edict_t self) {
            if (self.last_move_time < GameBase.level.time) {
                GameBase.gi.positioned_sound(self.s.origin, self, 0, self.noise_index, 1.0f, 0.0f, 0.0f);
                self.last_move_time = GameBase.level.time + 0.5f;
            }
            for (int i = 1; i < GameBase.num_edicts; ++i) {
                edict_t e = GameBase.g_edicts[i];
                if (!e.inuse || null == e.client || null == e.groundentity) continue;
                e.groundentity = null;
                e.velocity[0] = e.velocity[0] + Lib.crandom() * 150.0f;
                e.velocity[1] = e.velocity[1] + Lib.crandom() * 150.0f;
                e.velocity[2] = self.speed * (100.0f / (float)e.mass);
            }
            if (GameBase.level.time < self.timestamp) {
                self.nextthink = GameBase.level.time + 0.1f;
            }
            return true;
        }
    };
    static EntUseAdapter target_earthquake_use = new EntUseAdapter(){

        public String getID() {
            return "target_earthquake_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.timestamp = GameBase.level.time + (float)self.count;
            self.nextthink = GameBase.level.time + 0.1f;
            self.activator = activator;
            self.last_move_time = 0.0f;
        }
    };

    public static void SP_target_temp_entity(edict_t ent) {
        ent.use = Use_Target_Tent;
    }

    public static void SP_target_speaker(edict_t ent) {
        if (GameBase.st.noise == null) {
            GameBase.gi.dprintf("target_speaker with no noise set at " + Lib.vtos(ent.s.origin) + "\n");
            return;
        }
        String buffer = GameBase.st.noise.indexOf(".wav") < 0 ? "" + GameBase.st.noise + ".wav" : GameBase.st.noise;
        ent.noise_index = GameBase.gi.soundindex(buffer);
        if (ent.volume == 0.0f) {
            ent.volume = 1.0f;
        }
        if (ent.attenuation == 0.0f) {
            ent.attenuation = 1.0f;
        } else if (ent.attenuation == -1.0f) {
            ent.attenuation = 0.0f;
        }
        if ((ent.spawnflags & 1) != 0) {
            ent.s.sound = ent.noise_index;
        }
        ent.use = Use_Target_Speaker;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_target_help(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(ent);
            return;
        }
        if (ent.message == null) {
            GameBase.gi.dprintf(ent.classname + " with no message at " + Lib.vtos(ent.s.origin) + "\n");
            GameUtil.G_FreeEdict(ent);
            return;
        }
        ent.use = Use_Target_Help;
    }

    public static void SP_target_secret(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(ent);
            return;
        }
        ent.use = use_target_secret;
        if (GameBase.st.noise == null) {
            GameBase.st.noise = "misc/secret.wav";
        }
        ent.noise_index = GameBase.gi.soundindex(GameBase.st.noise);
        ent.svflags = 1;
        ++GameBase.level.total_secrets;
        if (0 == Lib.Q_stricmp(GameBase.level.mapname, "mine3") && ent.s.origin[0] == 280.0f && ent.s.origin[1] == -2048.0f && ent.s.origin[2] == -624.0f) {
            ent.message = "You have found a secret area.";
        }
    }

    public static void SP_target_goal(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(ent);
            return;
        }
        ent.use = use_target_goal;
        if (GameBase.st.noise == null) {
            GameBase.st.noise = "misc/secret.wav";
        }
        ent.noise_index = GameBase.gi.soundindex(GameBase.st.noise);
        ent.svflags = 1;
        ++GameBase.level.total_goals;
    }

    public static void SP_target_explosion(edict_t ent) {
        ent.use = use_target_explosion;
        ent.svflags = 1;
    }

    public static void SP_target_changelevel(edict_t ent) {
        if (ent.map == null) {
            GameBase.gi.dprintf("target_changelevel with no map at " + Lib.vtos(ent.s.origin) + "\n");
            GameUtil.G_FreeEdict(ent);
            return;
        }
        if (Lib.Q_stricmp(GameBase.level.mapname, "fact1") == 0 && Lib.Q_stricmp(ent.map, "fact3") == 0) {
            ent.map = "fact3$secret1";
        }
        ent.use = use_target_changelevel;
        ent.svflags = 1;
    }

    public static void SP_target_splash(edict_t self) {
        self.use = use_target_splash;
        GameBase.G_SetMovedir(self.s.angles, self.movedir);
        if (0 == self.count) {
            self.count = 32;
        }
        self.svflags = 1;
    }

    public static void SP_target_spawner(edict_t self) {
        self.use = use_target_spawner;
        self.svflags = 1;
        if (self.speed != 0.0f) {
            GameBase.G_SetMovedir(self.s.angles, self.movedir);
            Math3D.VectorScale(self.movedir, self.speed, self.movedir);
        }
    }

    public static void SP_target_blaster(edict_t self) {
        self.use = use_target_blaster;
        GameBase.G_SetMovedir(self.s.angles, self.movedir);
        self.noise_index = GameBase.gi.soundindex("weapons/laser2.wav");
        if (0 == self.dmg) {
            self.dmg = 15;
        }
        if (0.0f == self.speed) {
            self.speed = 1000.0f;
        }
        self.svflags = 1;
    }

    public static void SP_target_crosslevel_trigger(edict_t self) {
        self.svflags = 1;
        self.use = trigger_crosslevel_trigger_use;
    }

    public static void SP_target_crosslevel_target(edict_t self) {
        if (0.0f == self.delay) {
            self.delay = 1.0f;
        }
        self.svflags = 1;
        self.think = target_crosslevel_target_think;
        self.nextthink = GameBase.level.time + self.delay;
    }

    public static void target_laser_on(edict_t self) {
        if (null == self.activator) {
            self.activator = self;
        }
        self.spawnflags |= 0x80000001;
        self.svflags &= 0xFFFFFFFE;
        target_laser_think.think(self);
    }

    public static void target_laser_off(edict_t self) {
        self.spawnflags &= 0xFFFFFFFE;
        self.svflags |= 1;
        self.nextthink = 0.0f;
    }

    public static void SP_target_laser(edict_t self) {
        self.think = target_laser_start;
        self.nextthink = GameBase.level.time + 1.0f;
    }

    public static void SP_target_lightramp(edict_t self) {
        if (self.message == null || self.message.length() != 2 || self.message.charAt(0) < 'a' || self.message.charAt(0) > 'z' || self.message.charAt(1) < 'a' || self.message.charAt(1) > 'z' || self.message.charAt(0) == self.message.charAt(1)) {
            GameBase.gi.dprintf("target_lightramp has bad ramp (" + self.message + ") at " + Lib.vtos(self.s.origin) + "\n");
            GameUtil.G_FreeEdict(self);
            return;
        }
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        if (self.target == null) {
            GameBase.gi.dprintf(self.classname + " with no target at " + Lib.vtos(self.s.origin) + "\n");
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.svflags |= 1;
        self.use = target_lightramp_use;
        self.think = target_lightramp_think;
        self.movedir[0] = self.message.charAt(0) - 97;
        self.movedir[1] = self.message.charAt(1) - 97;
        self.movedir[2] = (self.movedir[1] - self.movedir[0]) / (self.speed / 0.1f);
    }

    public static void SP_target_earthquake(edict_t self) {
        if (null == self.targetname) {
            GameBase.gi.dprintf("untargeted " + self.classname + " at " + Lib.vtos(self.s.origin) + "\n");
        }
        if (0 == self.count) {
            self.count = 5;
        }
        if (0.0f == self.speed) {
            self.speed = 200.0f;
        }
        self.svflags |= 1;
        self.think = target_earthquake_think;
        self.use = target_earthquake_use;
        self.noise_index = GameBase.gi.soundindex("world/quake.wav");
    }
}

