/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.EntThinkAdapter;
import jake2.game.GameBase;
import jake2.game.GameFunc;
import jake2.game.GameItemList;
import jake2.game.GameItems;
import jake2.game.GameMisc;
import jake2.game.GameTarget;
import jake2.game.GameTrigger;
import jake2.game.GameTurret;
import jake2.game.GameUtil;
import jake2.game.PlayerClient;
import jake2.game.PlayerTrail;
import jake2.game.edict_t;
import jake2.game.gitem_t;
import jake2.game.level_locals_t;
import jake2.game.monsters.M_Actor;
import jake2.game.monsters.M_Berserk;
import jake2.game.monsters.M_Boss2;
import jake2.game.monsters.M_Boss3;
import jake2.game.monsters.M_Boss31;
import jake2.game.monsters.M_Brain;
import jake2.game.monsters.M_Chick;
import jake2.game.monsters.M_Flipper;
import jake2.game.monsters.M_Float;
import jake2.game.monsters.M_Flyer;
import jake2.game.monsters.M_Gladiator;
import jake2.game.monsters.M_Gunner;
import jake2.game.monsters.M_Hover;
import jake2.game.monsters.M_Infantry;
import jake2.game.monsters.M_Insane;
import jake2.game.monsters.M_Medic;
import jake2.game.monsters.M_Mutant;
import jake2.game.monsters.M_Parasite;
import jake2.game.monsters.M_Soldier;
import jake2.game.monsters.M_Supertank;
import jake2.game.monsters.M_Tank;
import jake2.game.spawn_t;
import jake2.game.spawn_temp_t;
import jake2.qcommon.Com;
import jake2.util.Lib;

public class GameSpawn {
    static EntThinkAdapter SP_item_health = new EntThinkAdapter(){

        public String getID() {
            return "SP_item_health";
        }

        public boolean think(edict_t ent) {
            GameItems.SP_item_health(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_item_health_small = new EntThinkAdapter(){

        public String getID() {
            return "SP_item_health_small";
        }

        public boolean think(edict_t ent) {
            GameItems.SP_item_health_small(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_item_health_large = new EntThinkAdapter(){

        public String getID() {
            return "SP_item_health_large";
        }

        public boolean think(edict_t ent) {
            GameItems.SP_item_health_large(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_item_health_mega = new EntThinkAdapter(){

        public String getID() {
            return "SP_item_health_mega";
        }

        public boolean think(edict_t ent) {
            GameItems.SP_item_health_mega(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_info_player_start = new EntThinkAdapter(){

        public String getID() {
            return "SP_info_player_start";
        }

        public boolean think(edict_t ent) {
            PlayerClient.SP_info_player_start(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_info_player_deathmatch = new EntThinkAdapter(){

        public String getID() {
            return "SP_info_player_deathmatch";
        }

        public boolean think(edict_t ent) {
            PlayerClient.SP_info_player_deathmatch(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_info_player_coop = new EntThinkAdapter(){

        public String getID() {
            return "SP_info_player_coop";
        }

        public boolean think(edict_t ent) {
            PlayerClient.SP_info_player_coop(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_info_player_intermission = new EntThinkAdapter(){

        public String getID() {
            return "SP_info_player_intermission";
        }

        public boolean think(edict_t ent) {
            PlayerClient.SP_info_player_intermission();
            return true;
        }
    };
    static EntThinkAdapter SP_func_plat = new EntThinkAdapter(){

        public String getID() {
            return "SP_func_plat";
        }

        public boolean think(edict_t ent) {
            GameFunc.SP_func_plat(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_func_water = new EntThinkAdapter(){

        public String getID() {
            return "SP_func_water";
        }

        public boolean think(edict_t ent) {
            GameFunc.SP_func_water(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_func_train = new EntThinkAdapter(){

        public String getID() {
            return "SP_func_train";
        }

        public boolean think(edict_t ent) {
            GameFunc.SP_func_train(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_func_clock = new EntThinkAdapter(){

        public String getID() {
            return "SP_func_clock";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_func_clock(ent);
            return true;
        }
    };
    static EntThinkAdapter SP_worldspawn = new EntThinkAdapter(){

        public String getID() {
            return "SP_worldspawn";
        }

        public boolean think(edict_t ent) {
            ent.movetype = 2;
            ent.solid = 3;
            ent.inuse = true;
            ent.s.modelindex = 1;
            PlayerClient.InitBodyQue();
            GameItems.SetItemNames();
            if (GameBase.st.nextmap != null) {
                GameBase.level.nextmap = GameBase.st.nextmap;
            }
            if (ent.message != null && ent.message.length() > 0) {
                GameBase.gi.configstring(0, ent.message);
                GameBase.level.level_name = ent.message;
            } else {
                GameBase.level.level_name = GameBase.level.mapname;
            }
            if (GameBase.st.sky != null && GameBase.st.sky.length() > 0) {
                GameBase.gi.configstring(2, GameBase.st.sky);
            } else {
                GameBase.gi.configstring(2, "unit1_");
            }
            GameBase.gi.configstring(4, "" + GameBase.st.skyrotate);
            GameBase.gi.configstring(3, Lib.vtos(GameBase.st.skyaxis));
            GameBase.gi.configstring(1, "" + ent.sounds);
            GameBase.gi.configstring(30, "" + (int)GameBase.maxclients.value);
            if (GameBase.deathmatch.value != 0.0f) {
                GameBase.gi.configstring(5, "" + dm_statusbar);
            } else {
                GameBase.gi.configstring(5, "" + single_statusbar);
            }
            GameBase.gi.imageindex("i_help");
            GameBase.level.pic_health = GameBase.gi.imageindex("i_health");
            GameBase.gi.imageindex("help");
            GameBase.gi.imageindex("field_3");
            if ("".equals(GameBase.st.gravity)) {
                GameBase.gi.cvar_set("sv_gravity", "800");
            } else {
                GameBase.gi.cvar_set("sv_gravity", GameBase.st.gravity);
            }
            GameBase.snd_fry = GameBase.gi.soundindex("player/fry.wav");
            GameItems.PrecacheItem(GameItems.FindItem("Blaster"));
            GameBase.gi.soundindex("player/lava1.wav");
            GameBase.gi.soundindex("player/lava2.wav");
            GameBase.gi.soundindex("misc/pc_up.wav");
            GameBase.gi.soundindex("misc/talk1.wav");
            GameBase.gi.soundindex("misc/udeath.wav");
            GameBase.gi.soundindex("items/respawn1.wav");
            GameBase.gi.soundindex("*death1.wav");
            GameBase.gi.soundindex("*death2.wav");
            GameBase.gi.soundindex("*death3.wav");
            GameBase.gi.soundindex("*death4.wav");
            GameBase.gi.soundindex("*fall1.wav");
            GameBase.gi.soundindex("*fall2.wav");
            GameBase.gi.soundindex("*gurp1.wav");
            GameBase.gi.soundindex("*gurp2.wav");
            GameBase.gi.soundindex("*jump1.wav");
            GameBase.gi.soundindex("*pain25_1.wav");
            GameBase.gi.soundindex("*pain25_2.wav");
            GameBase.gi.soundindex("*pain50_1.wav");
            GameBase.gi.soundindex("*pain50_2.wav");
            GameBase.gi.soundindex("*pain75_1.wav");
            GameBase.gi.soundindex("*pain75_2.wav");
            GameBase.gi.soundindex("*pain100_1.wav");
            GameBase.gi.soundindex("*pain100_2.wav");
            GameBase.gi.modelindex("#w_blaster.md2");
            GameBase.gi.modelindex("#w_shotgun.md2");
            GameBase.gi.modelindex("#w_sshotgun.md2");
            GameBase.gi.modelindex("#w_machinegun.md2");
            GameBase.gi.modelindex("#w_chaingun.md2");
            GameBase.gi.modelindex("#a_grenades.md2");
            GameBase.gi.modelindex("#w_glauncher.md2");
            GameBase.gi.modelindex("#w_rlauncher.md2");
            GameBase.gi.modelindex("#w_hyperblaster.md2");
            GameBase.gi.modelindex("#w_railgun.md2");
            GameBase.gi.modelindex("#w_bfg.md2");
            GameBase.gi.soundindex("player/gasp1.wav");
            GameBase.gi.soundindex("player/gasp2.wav");
            GameBase.gi.soundindex("player/watr_in.wav");
            GameBase.gi.soundindex("player/watr_out.wav");
            GameBase.gi.soundindex("player/watr_un.wav");
            GameBase.gi.soundindex("player/u_breath1.wav");
            GameBase.gi.soundindex("player/u_breath2.wav");
            GameBase.gi.soundindex("items/pkup.wav");
            GameBase.gi.soundindex("world/land.wav");
            GameBase.gi.soundindex("misc/h2ohit1.wav");
            GameBase.gi.soundindex("items/damage.wav");
            GameBase.gi.soundindex("items/protect.wav");
            GameBase.gi.soundindex("items/protect4.wav");
            GameBase.gi.soundindex("weapons/noammo.wav");
            GameBase.gi.soundindex("infantry/inflies1.wav");
            GameBase.sm_meat_index = GameBase.gi.modelindex("models/objects/gibs/sm_meat/tris.md2");
            GameBase.gi.modelindex("models/objects/gibs/arm/tris.md2");
            GameBase.gi.modelindex("models/objects/gibs/bone/tris.md2");
            GameBase.gi.modelindex("models/objects/gibs/bone2/tris.md2");
            GameBase.gi.modelindex("models/objects/gibs/chest/tris.md2");
            GameBase.gi.modelindex("models/objects/gibs/skull/tris.md2");
            GameBase.gi.modelindex("models/objects/gibs/head2/tris.md2");
            GameBase.gi.configstring(800, "m");
            GameBase.gi.configstring(801, "mmnmmommommnonmmonqnmmo");
            GameBase.gi.configstring(802, "abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba");
            GameBase.gi.configstring(803, "mmmmmaaaaammmmmaaaaaabcdefgabcdefg");
            GameBase.gi.configstring(804, "mamamamamama");
            GameBase.gi.configstring(805, "jklmnopqrstuvwxyzyxwvutsrqponmlkj");
            GameBase.gi.configstring(806, "nmonqnmomnmomomno");
            GameBase.gi.configstring(807, "mmmaaaabcdefgmmmmaaaammmaamm");
            GameBase.gi.configstring(808, "mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa");
            GameBase.gi.configstring(809, "aaaaaaaazzzzzzzz");
            GameBase.gi.configstring(810, "mmamammmmammamamaaamammma");
            GameBase.gi.configstring(811, "abcdefghijklmnopqrrqponmlkjihgfedcba");
            GameBase.gi.configstring(863, "a");
            return true;
        }
    };
    static String single_statusbar = "yb\t-24 xv\t0 hnum xv\t50 pic 0 if 2 \txv\t100 \tanum \txv\t150 \tpic 2 endif if 4 \txv\t200 \trnum \txv\t250 \tpic 4 endif if 6 \txv\t296 \tpic 6 endif yb\t-50 if 7 \txv\t0 \tpic 7 \txv\t26 \tyb\t-42 \tstat_string 8 \tyb\t-50 endif if 9 \txv\t262 \tnum\t2\t10 \txv\t296 \tpic\t9 endif if 11 \txv\t148 \tpic\t11 endif ";
    static String dm_statusbar = "yb\t-24 xv\t0 hnum xv\t50 pic 0 if 2 \txv\t100 \tanum \txv\t150 \tpic 2 endif if 4 \txv\t200 \trnum \txv\t250 \tpic 4 endif if 6 \txv\t296 \tpic 6 endif yb\t-50 if 7 \txv\t0 \tpic 7 \txv\t26 \tyb\t-42 \tstat_string 8 \tyb\t-50 endif if 9 \txv\t246 \tnum\t2\t10 \txv\t296 \tpic\t9 endif if 11 \txv\t148 \tpic\t11 endif xr\t-50 yt 2 num 3 14 if 17 xv 0 yb -58 string2 \"SPECTATOR MODE\" endif if 16 xv 0 yb -68 string \"Chasing\" xv 64 stat_string 16 endif ";
    static spawn_t[] spawns = new spawn_t[]{new spawn_t("item_health", SP_item_health), new spawn_t("item_health_small", SP_item_health_small), new spawn_t("item_health_large", SP_item_health_large), new spawn_t("item_health_mega", SP_item_health_mega), new spawn_t("info_player_start", SP_info_player_start), new spawn_t("info_player_deathmatch", SP_info_player_deathmatch), new spawn_t("info_player_coop", SP_info_player_coop), new spawn_t("info_player_intermission", SP_info_player_intermission), new spawn_t("func_plat", SP_func_plat), new spawn_t("func_button", GameFunc.SP_func_button), new spawn_t("func_door", GameFunc.SP_func_door), new spawn_t("func_door_secret", GameFunc.SP_func_door_secret), new spawn_t("func_door_rotating", GameFunc.SP_func_door_rotating), new spawn_t("func_rotating", GameFunc.SP_func_rotating), new spawn_t("func_train", SP_func_train), new spawn_t("func_water", SP_func_water), new spawn_t("func_conveyor", GameFunc.SP_func_conveyor), new spawn_t("func_areaportal", GameMisc.SP_func_areaportal), new spawn_t("func_clock", SP_func_clock), new spawn_t("func_wall", new EntThinkAdapter(){

        public String getID() {
            return "func_wall";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_func_wall(ent);
            return true;
        }
    }), new spawn_t("func_object", new EntThinkAdapter(){

        public String getID() {
            return "SP_func_object";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_func_object(ent);
            return true;
        }
    }), new spawn_t("func_timer", new EntThinkAdapter(){

        public String getID() {
            return "SP_func_timer";
        }

        public boolean think(edict_t ent) {
            GameFunc.SP_func_timer(ent);
            return true;
        }
    }), new spawn_t("func_explosive", new EntThinkAdapter(){

        public String getID() {
            return "SP_func_explosive";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_func_explosive(ent);
            return true;
        }
    }), new spawn_t("func_killbox", GameFunc.SP_func_killbox), new spawn_t("trigger_always", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_always";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_always(ent);
            return true;
        }
    }), new spawn_t("trigger_once", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_once";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_once(ent);
            return true;
        }
    }), new spawn_t("trigger_multiple", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_multiple";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_multiple(ent);
            return true;
        }
    }), new spawn_t("trigger_relay", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_relay";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_relay(ent);
            return true;
        }
    }), new spawn_t("trigger_push", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_push";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_push(ent);
            return true;
        }
    }), new spawn_t("trigger_hurt", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_hurt";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_hurt(ent);
            return true;
        }
    }), new spawn_t("trigger_key", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_key";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_key(ent);
            return true;
        }
    }), new spawn_t("trigger_counter", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_counter";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_counter(ent);
            return true;
        }
    }), new spawn_t("trigger_elevator", GameFunc.SP_trigger_elevator), new spawn_t("trigger_gravity", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_gravity";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_gravity(ent);
            return true;
        }
    }), new spawn_t("trigger_monsterjump", new EntThinkAdapter(){

        public String getID() {
            return "SP_trigger_monsterjump";
        }

        public boolean think(edict_t ent) {
            GameTrigger.SP_trigger_monsterjump(ent);
            return true;
        }
    }), new spawn_t("target_temp_entity", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_temp_entity";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_temp_entity(ent);
            return true;
        }
    }), new spawn_t("target_speaker", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_speaker";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_speaker(ent);
            return true;
        }
    }), new spawn_t("target_explosion", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_explosion";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_explosion(ent);
            return true;
        }
    }), new spawn_t("target_changelevel", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_changelevel";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_changelevel(ent);
            return true;
        }
    }), new spawn_t("target_secret", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_secret";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_secret(ent);
            return true;
        }
    }), new spawn_t("target_goal", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_goal";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_goal(ent);
            return true;
        }
    }), new spawn_t("target_splash", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_splash";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_splash(ent);
            return true;
        }
    }), new spawn_t("target_spawner", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_spawner";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_spawner(ent);
            return true;
        }
    }), new spawn_t("target_blaster", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_blaster";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_blaster(ent);
            return true;
        }
    }), new spawn_t("target_crosslevel_trigger", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_crosslevel_trigger";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_crosslevel_trigger(ent);
            return true;
        }
    }), new spawn_t("target_crosslevel_target", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_crosslevel_target";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_crosslevel_target(ent);
            return true;
        }
    }), new spawn_t("target_laser", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_laser";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_laser(ent);
            return true;
        }
    }), new spawn_t("target_help", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_help";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_help(ent);
            return true;
        }
    }), new spawn_t("target_actor", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_actor";
        }

        public boolean think(edict_t ent) {
            M_Actor.SP_target_actor(ent);
            return true;
        }
    }), new spawn_t("target_lightramp", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_lightramp";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_lightramp(ent);
            return true;
        }
    }), new spawn_t("target_earthquake", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_earthquake";
        }

        public boolean think(edict_t ent) {
            GameTarget.SP_target_earthquake(ent);
            return true;
        }
    }), new spawn_t("target_character", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_character";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_target_character(ent);
            return true;
        }
    }), new spawn_t("target_string", new EntThinkAdapter(){

        public String getID() {
            return "SP_target_string";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_target_string(ent);
            return true;
        }
    }), new spawn_t("worldspawn", SP_worldspawn), new spawn_t("viewthing", new EntThinkAdapter(){

        public String getID() {
            return "SP_viewthing";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_viewthing(ent);
            return true;
        }
    }), new spawn_t("light", new EntThinkAdapter(){

        public String getID() {
            return "SP_light";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_light(ent);
            return true;
        }
    }), new spawn_t("light_mine1", new EntThinkAdapter(){

        public String getID() {
            return "SP_light_mine1";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_light_mine1(ent);
            return true;
        }
    }), new spawn_t("light_mine2", new EntThinkAdapter(){

        public String getID() {
            return "SP_light_mine2";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_light_mine2(ent);
            return true;
        }
    }), new spawn_t("info_null", new EntThinkAdapter(){

        public String getID() {
            return "SP_info_null";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_info_null(ent);
            return true;
        }
    }), new spawn_t("func_group", new EntThinkAdapter(){

        public String getID() {
            return "SP_info_null";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_info_null(ent);
            return true;
        }
    }), new spawn_t("info_notnull", new EntThinkAdapter(){

        public String getID() {
            return "info_notnull";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_info_notnull(ent);
            return true;
        }
    }), new spawn_t("path_corner", new EntThinkAdapter(){

        public String getID() {
            return "SP_path_corner";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_path_corner(ent);
            return true;
        }
    }), new spawn_t("point_combat", new EntThinkAdapter(){

        public String getID() {
            return "SP_point_combat";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_point_combat(ent);
            return true;
        }
    }), new spawn_t("misc_explobox", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_explobox";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_explobox(ent);
            return true;
        }
    }), new spawn_t("misc_banner", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_banner";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_banner(ent);
            return true;
        }
    }), new spawn_t("misc_satellite_dish", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_satellite_dish";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_satellite_dish(ent);
            return true;
        }
    }), new spawn_t("misc_actor", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_actor";
        }

        public boolean think(edict_t ent) {
            M_Actor.SP_misc_actor(ent);
            return false;
        }
    }), new spawn_t("misc_gib_arm", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_gib_arm";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_gib_arm(ent);
            return true;
        }
    }), new spawn_t("misc_gib_leg", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_gib_leg";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_gib_leg(ent);
            return true;
        }
    }), new spawn_t("misc_gib_head", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_gib_head";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_gib_head(ent);
            return true;
        }
    }), new spawn_t("misc_insane", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_insane";
        }

        public boolean think(edict_t ent) {
            M_Insane.SP_misc_insane(ent);
            return true;
        }
    }), new spawn_t("misc_deadsoldier", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_deadsoldier";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_deadsoldier(ent);
            return true;
        }
    }), new spawn_t("misc_viper", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_viper";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_viper(ent);
            return true;
        }
    }), new spawn_t("misc_viper_bomb", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_viper_bomb";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_viper_bomb(ent);
            return true;
        }
    }), new spawn_t("misc_bigviper", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_bigviper";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_bigviper(ent);
            return true;
        }
    }), new spawn_t("misc_strogg_ship", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_strogg_ship";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_strogg_ship(ent);
            return true;
        }
    }), new spawn_t("misc_teleporter", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_teleporter";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_teleporter(ent);
            return true;
        }
    }), new spawn_t("misc_teleporter_dest", GameMisc.SP_misc_teleporter_dest), new spawn_t("misc_blackhole", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_blackhole";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_blackhole(ent);
            return true;
        }
    }), new spawn_t("misc_eastertank", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_eastertank";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_eastertank(ent);
            return true;
        }
    }), new spawn_t("misc_easterchick", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_easterchick";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_easterchick(ent);
            return true;
        }
    }), new spawn_t("misc_easterchick2", new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_easterchick2";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_misc_easterchick2(ent);
            return true;
        }
    }), new spawn_t("monster_berserk", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_berserk";
        }

        public boolean think(edict_t ent) {
            M_Berserk.SP_monster_berserk(ent);
            return true;
        }
    }), new spawn_t("monster_gladiator", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_gladiator";
        }

        public boolean think(edict_t ent) {
            M_Gladiator.SP_monster_gladiator(ent);
            return true;
        }
    }), new spawn_t("monster_gunner", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_gunner";
        }

        public boolean think(edict_t ent) {
            M_Gunner.SP_monster_gunner(ent);
            return true;
        }
    }), new spawn_t("monster_infantry", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_infantry";
        }

        public boolean think(edict_t ent) {
            M_Infantry.SP_monster_infantry(ent);
            return true;
        }
    }), new spawn_t("monster_soldier_light", M_Soldier.SP_monster_soldier_light), new spawn_t("monster_soldier", M_Soldier.SP_monster_soldier), new spawn_t("monster_soldier_ss", M_Soldier.SP_monster_soldier_ss), new spawn_t("monster_tank", M_Tank.SP_monster_tank), new spawn_t("monster_tank_commander", M_Tank.SP_monster_tank), new spawn_t("monster_medic", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_medic";
        }

        public boolean think(edict_t ent) {
            M_Medic.SP_monster_medic(ent);
            return true;
        }
    }), new spawn_t("monster_flipper", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_flipper";
        }

        public boolean think(edict_t ent) {
            M_Flipper.SP_monster_flipper(ent);
            return true;
        }
    }), new spawn_t("monster_chick", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_chick";
        }

        public boolean think(edict_t ent) {
            M_Chick.SP_monster_chick(ent);
            return true;
        }
    }), new spawn_t("monster_parasite", M_Parasite.SP_monster_parasite), new spawn_t("monster_flyer", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_flyer";
        }

        public boolean think(edict_t ent) {
            M_Flyer.SP_monster_flyer(ent);
            return true;
        }
    }), new spawn_t("monster_brain", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_brain";
        }

        public boolean think(edict_t ent) {
            M_Brain.SP_monster_brain(ent);
            return true;
        }
    }), new spawn_t("monster_floater", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_floater";
        }

        public boolean think(edict_t ent) {
            M_Float.SP_monster_floater(ent);
            return true;
        }
    }), new spawn_t("monster_hover", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_hover";
        }

        public boolean think(edict_t ent) {
            M_Hover.SP_monster_hover(ent);
            return true;
        }
    }), new spawn_t("monster_mutant", M_Mutant.SP_monster_mutant), new spawn_t("monster_supertank", M_Supertank.SP_monster_supertank), new spawn_t("monster_boss2", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_boss2";
        }

        public boolean think(edict_t ent) {
            M_Boss2.SP_monster_boss2(ent);
            return true;
        }
    }), new spawn_t("monster_boss3_stand", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_boss3_stand";
        }

        public boolean think(edict_t ent) {
            M_Boss3.SP_monster_boss3_stand(ent);
            return true;
        }
    }), new spawn_t("monster_jorg", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_jorg";
        }

        public boolean think(edict_t ent) {
            M_Boss31.SP_monster_jorg(ent);
            return true;
        }
    }), new spawn_t("monster_commander_body", new EntThinkAdapter(){

        public String getID() {
            return "SP_monster_commander_body";
        }

        public boolean think(edict_t ent) {
            GameMisc.SP_monster_commander_body(ent);
            return true;
        }
    }), new spawn_t("turret_breach", new EntThinkAdapter(){

        public String getID() {
            return "SP_turret_breach";
        }

        public boolean think(edict_t ent) {
            GameTurret.SP_turret_breach(ent);
            return true;
        }
    }), new spawn_t("turret_base", new EntThinkAdapter(){

        public String getID() {
            return "SP_turret_base";
        }

        public boolean think(edict_t ent) {
            GameTurret.SP_turret_base(ent);
            return true;
        }
    }), new spawn_t("turret_driver", new EntThinkAdapter(){

        public String getID() {
            return "SP_turret_driver";
        }

        public boolean think(edict_t ent) {
            GameTurret.SP_turret_driver(ent);
            return true;
        }
    }), new spawn_t(null, null)};

    static String ED_NewString(String string) {
        int l = string.length();
        StringBuffer newb = new StringBuffer(l);
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < l - 1) {
                if ((c = string.charAt(++i)) == 'n') {
                    newb.append('\n');
                    continue;
                }
                newb.append('\\');
                continue;
            }
            newb.append(c);
        }
        return newb.toString();
    }

    static void ED_ParseField(String key, String value, edict_t ent) {
        if (key.equals("nextmap")) {
            Com.Println("nextmap: " + value);
        }
        if (!GameBase.st.set(key, value) && !ent.setField(key, value)) {
            GameBase.gi.dprintf("??? The key [" + key + "] is not a field\n");
        }
    }

    static void ED_ParseEdict(Com.ParseHelp ph, edict_t ent) {
        String com_token;
        boolean init = false;
        GameBase.st = new spawn_temp_t();
        while (!(com_token = Com.Parse(ph)).equals("}")) {
            if (ph.isEof()) {
                GameBase.gi.error("ED_ParseEntity: EOF without closing brace");
            }
            String keyname = com_token;
            com_token = Com.Parse(ph);
            if (ph.isEof()) {
                GameBase.gi.error("ED_ParseEntity: EOF without closing brace");
            }
            if (com_token.equals("}")) {
                GameBase.gi.error("ED_ParseEntity: closing brace without data");
            }
            init = true;
            if (keyname.charAt(0) == '_') continue;
            GameSpawn.ED_ParseField(keyname.toLowerCase(), com_token, ent);
        }
        if (!init) {
            GameUtil.G_ClearEdict(ent);
        }
    }

    static void G_FindTeams() {
        int c = 0;
        int c2 = 0;
        for (int i = 1; i < GameBase.num_edicts; ++i) {
            edict_t e = GameBase.g_edicts[i];
            if (!e.inuse || e.team == null || (e.flags & 0x400) != 0) continue;
            edict_t chain = e;
            e.teammaster = e;
            ++c;
            ++c2;
            for (int j = i + 1; j < GameBase.num_edicts; ++j) {
                edict_t e2 = GameBase.g_edicts[j];
                if (!e2.inuse || null == e2.team || (e2.flags & 0x400) != 0 || 0 != Lib.strcmp(e.team, e2.team)) continue;
                ++c2;
                chain.teamchain = e2;
                e2.teammaster = e;
                chain = e2;
                e2.flags |= 0x400;
            }
        }
    }

    public static void SpawnEntities(String mapname, String entities, String spawnpoint) {
        int i;
        Com.dprintln("SpawnEntities(), mapname=" + mapname);
        float skill_level = (float)Math.floor(GameBase.skill.value);
        if (skill_level < 0.0f) {
            skill_level = 0.0f;
        }
        if (skill_level > 3.0f) {
            skill_level = 3.0f;
        }
        if (GameBase.skill.value != skill_level) {
            GameBase.gi.cvar_forceset("skill", "" + skill_level);
        }
        PlayerClient.SaveClientData();
        GameBase.level = new level_locals_t();
        for (int n = 0; n < GameBase.game.maxentities; ++n) {
            GameBase.g_edicts[n] = new edict_t(n);
        }
        GameBase.level.mapname = mapname;
        GameBase.game.spawnpoint = spawnpoint;
        for (i = 0; i < GameBase.game.maxclients; ++i) {
            GameBase.g_edicts[i + 1].client = GameBase.game.clients[i];
        }
        edict_t ent = null;
        int inhibit = 0;
        Com.ParseHelp ph = new Com.ParseHelp(entities);
        while (true) {
            String com_token = Com.Parse(ph);
            if (ph.isEof()) break;
            if (!com_token.startsWith("{")) {
                GameBase.gi.error("ED_LoadFromFile: found " + com_token + " when expecting {");
            }
            ent = ent == null ? GameBase.g_edicts[0] : GameUtil.G_Spawn();
            GameSpawn.ED_ParseEdict(ph, ent);
            Com.DPrintf("spawning ent[" + ent.index + "], classname=" + ent.classname + ", flags= " + Integer.toHexString(ent.spawnflags));
            if (0 == Lib.Q_stricmp(GameBase.level.mapname, "command") && 0 == Lib.Q_stricmp(ent.classname, "trigger_once") && 0 == Lib.Q_stricmp(ent.model, "*27")) {
                ent.spawnflags &= 0xFFFFFBFF;
            }
            if (ent != GameBase.g_edicts[0]) {
                if (GameBase.deathmatch.value != 0.0f) {
                    if ((ent.spawnflags & 0x800) != 0) {
                        Com.DPrintf("->inhibited.\n");
                        GameUtil.G_FreeEdict(ent);
                        ++inhibit;
                        continue;
                    }
                } else if (GameBase.skill.value == 0.0f && (ent.spawnflags & 0x100) != 0 || GameBase.skill.value == 1.0f && (ent.spawnflags & 0x200) != 0 || (GameBase.skill.value == 2.0f || GameBase.skill.value == 3.0f) && (ent.spawnflags & 0x400) != 0) {
                    Com.DPrintf("->inhibited.\n");
                    GameUtil.G_FreeEdict(ent);
                    ++inhibit;
                    continue;
                }
                ent.spawnflags &= 0xFFFFE0FF;
            }
            GameSpawn.ED_CallSpawn(ent);
            Com.DPrintf("\n");
        }
        Com.DPrintf("player skill level:" + GameBase.skill.value + "\n");
        Com.DPrintf(inhibit + " entities inhibited.\n");
        i = 1;
        GameSpawn.G_FindTeams();
        PlayerTrail.Init();
    }

    public static void ED_CallSpawn(edict_t ent) {
        spawn_t s;
        int i;
        if (null == ent.classname) {
            GameBase.gi.dprintf("ED_CallSpawn: null classname\n");
            return;
        }
        for (i = 1; i < GameBase.game.num_items; ++i) {
            gitem_t item = GameItemList.itemlist[i];
            if (item == null) {
                GameBase.gi.error("ED_CallSpawn: null item in pos " + i);
            }
            if (item.classname == null || !item.classname.equalsIgnoreCase(ent.classname)) continue;
            GameItems.SpawnItem(ent, item);
            return;
        }
        i = 0;
        while ((s = spawns[i]) != null && s.name != null) {
            if (s.name.equalsIgnoreCase(ent.classname)) {
                if (s.spawn == null) {
                    GameBase.gi.error("ED_CallSpawn: null-spawn on index=" + i);
                }
                s.spawn.think(ent);
                return;
            }
            ++i;
        }
        GameBase.gi.dprintf(ent.classname + " doesn't have a spawn function\n");
    }
}

