/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.GameBase;
import jake2.game.GameItems;
import jake2.game.PlayerClient;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import jake2.util.QuakeFile;

public class GameSave {
    private static String[] preloadclasslist = new String[]{"jake2.game.PlayerWeapon", "jake2.game.AIAdapter", "jake2.game.Cmd", "jake2.game.EdictFindFilter", "jake2.game.EdictIterator", "jake2.game.EndianHandler", "jake2.game.EntBlockedAdapter", "jake2.game.EntDieAdapter", "jake2.game.EntDodgeAdapter", "jake2.game.EntInteractAdapter", "jake2.game.EntPainAdapter", "jake2.game.EntThinkAdapter", "jake2.game.EntTouchAdapter", "jake2.game.EntUseAdapter", "jake2.game.GameAI", "jake2.game.GameBase", "jake2.game.GameChase", "jake2.game.GameCombat", "jake2.game.GameFunc", "jake2.game.GameMisc", "jake2.game.GameSVCmds", "jake2.game.GameSave", "jake2.game.GameSpawn", "jake2.game.GameTarget", "jake2.game.GameTrigger", "jake2.game.GameTurret", "jake2.game.GameUtil", "jake2.game.GameWeapon", "jake2.game.Info", "jake2.game.ItemDropAdapter", "jake2.game.ItemUseAdapter", "jake2.game.Monster", "jake2.game.PlayerClient", "jake2.game.PlayerHud", "jake2.game.PlayerTrail", "jake2.game.PlayerView", "jake2.game.SuperAdapter", "jake2.game.monsters.M_Actor", "jake2.game.monsters.M_Berserk", "jake2.game.monsters.M_Boss2", "jake2.game.monsters.M_Boss3", "jake2.game.monsters.M_Boss31", "jake2.game.monsters.M_Boss32", "jake2.game.monsters.M_Brain", "jake2.game.monsters.M_Chick", "jake2.game.monsters.M_Flash", "jake2.game.monsters.M_Flipper", "jake2.game.monsters.M_Float", "jake2.game.monsters.M_Flyer", "jake2.game.monsters.M_Gladiator", "jake2.game.monsters.M_Gunner", "jake2.game.monsters.M_Hover", "jake2.game.monsters.M_Infantry", "jake2.game.monsters.M_Insane", "jake2.game.monsters.M_Medic", "jake2.game.monsters.M_Mutant", "jake2.game.monsters.M_Parasite", "jake2.game.monsters.M_Player", "jake2.game.monsters.M_Soldier", "jake2.game.monsters.M_Supertank", "jake2.game.monsters.M_Tank", "jake2.game.GameItems", "jake2.game.GameItemList"};

    public static void CreateEdicts() {
        GameBase.g_edicts = new edict_t[GameBase.game.maxentities];
        for (int i = 0; i < GameBase.game.maxentities; ++i) {
            GameBase.g_edicts[i] = new edict_t(i);
        }
    }

    public static void CreateClients() {
        GameBase.game.clients = new gclient_t[GameBase.game.maxclients];
        for (int i = 0; i < GameBase.game.maxclients; ++i) {
            GameBase.game.clients[i] = new gclient_t(i);
        }
    }

    public static void InitGame() {
        GameBase.gi.dprintf("==== InitGame ====\n");
        for (int n = 0; n < preloadclasslist.length; ++n) {
            try {
                Class.forName(preloadclasslist[n]);
                continue;
            }
            catch (Exception e) {
                Com.DPrintf("error loading class: " + e.getMessage());
            }
        }
        GameBase.gun_x = GameBase.gi.cvar("gun_x", "0", 0);
        GameBase.gun_y = GameBase.gi.cvar("gun_y", "0", 0);
        GameBase.gun_z = GameBase.gi.cvar("gun_z", "0", 0);
        GameBase.sv_rollspeed = GameBase.gi.cvar("sv_rollspeed", "200", 0);
        GameBase.sv_rollangle = GameBase.gi.cvar("sv_rollangle", "2", 0);
        GameBase.sv_maxvelocity = GameBase.gi.cvar("sv_maxvelocity", "2000", 0);
        GameBase.sv_gravity = GameBase.gi.cvar("sv_gravity", "800", 0);
        Globals.dedicated = GameBase.gi.cvar("dedicated", "0", 8);
        GameBase.sv_cheats = GameBase.gi.cvar("cheats", "0", 20);
        GameBase.gi.cvar("gamename", "baseq2", 20);
        GameBase.gi.cvar("gamedate", "2003", 20);
        GameBase.maxclients = GameBase.gi.cvar("maxclients", "4", 20);
        GameBase.maxspectators = GameBase.gi.cvar("maxspectators", "4", 4);
        GameBase.deathmatch = GameBase.gi.cvar("deathmatch", "0", 16);
        GameBase.coop = GameBase.gi.cvar("coop", "0", 16);
        GameBase.skill = GameBase.gi.cvar("skill", "0", 16);
        GameBase.maxentities = GameBase.gi.cvar("maxentities", "1024", 16);
        GameBase.dmflags = GameBase.gi.cvar("dmflags", "0", 4);
        GameBase.fraglimit = GameBase.gi.cvar("fraglimit", "0", 4);
        GameBase.timelimit = GameBase.gi.cvar("timelimit", "0", 4);
        GameBase.password = GameBase.gi.cvar("password", "", 2);
        GameBase.spectator_password = GameBase.gi.cvar("spectator_password", "", 2);
        GameBase.needpass = GameBase.gi.cvar("needpass", "0", 4);
        GameBase.filterban = GameBase.gi.cvar("filterban", "1", 0);
        GameBase.g_select_empty = GameBase.gi.cvar("g_select_empty", "0", 1);
        GameBase.run_pitch = GameBase.gi.cvar("run_pitch", "0.002", 0);
        GameBase.run_roll = GameBase.gi.cvar("run_roll", "0.005", 0);
        GameBase.bob_up = GameBase.gi.cvar("bob_up", "0.005", 0);
        GameBase.bob_pitch = GameBase.gi.cvar("bob_pitch", "0.002", 0);
        GameBase.bob_roll = GameBase.gi.cvar("bob_roll", "0.002", 0);
        GameBase.flood_msgs = GameBase.gi.cvar("flood_msgs", "4", 0);
        GameBase.flood_persecond = GameBase.gi.cvar("flood_persecond", "4", 0);
        GameBase.flood_waitdelay = GameBase.gi.cvar("flood_waitdelay", "10", 0);
        GameBase.sv_maplist = GameBase.gi.cvar("sv_maplist", "", 0);
        GameItems.InitItems();
        GameBase.game.helpmessage1 = "";
        GameBase.game.helpmessage2 = "";
        GameBase.game.maxentities = (int)GameBase.maxentities.value;
        GameSave.CreateEdicts();
        GameBase.game.maxclients = (int)GameBase.maxclients.value;
        GameSave.CreateClients();
        GameBase.num_edicts = GameBase.game.maxclients + 1;
    }

    public static void WriteGame(String filename, boolean autosave) {
        try {
            QuakeFile f;
            if (!autosave) {
                PlayerClient.SaveClientData();
            }
            if ((f = new QuakeFile(filename, "rw")) == null) {
                GameBase.gi.error("Couldn't write to " + filename);
            }
            GameBase.game.autosaved = autosave;
            GameBase.game.write(f);
            GameBase.game.autosaved = false;
            for (int i = 0; i < GameBase.game.maxclients; ++i) {
                GameBase.game.clients[i].write(f);
            }
            Lib.fclose(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ReadGame(String filename) {
        QuakeFile f = null;
        try {
            f = new QuakeFile(filename, "r");
            GameSave.CreateEdicts();
            GameBase.game.load(f);
            for (int i = 0; i < GameBase.game.maxclients; ++i) {
                GameBase.game.clients[i] = new gclient_t(i);
                GameBase.game.clients[i].read(f);
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void WriteLevel(String filename) {
        try {
            int i;
            QuakeFile f = new QuakeFile(filename, "rw");
            if (f == null) {
                GameBase.gi.error("Couldn't open for writing: " + filename);
            }
            GameBase.level.write(f);
            for (i = 0; i < GameBase.num_edicts; ++i) {
                edict_t ent = GameBase.g_edicts[i];
                if (!ent.inuse) continue;
                f.writeInt(i);
                ent.write(f);
            }
            i = -1;
            f.writeInt(-1);
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ReadLevel(String filename) {
        try {
            edict_t ent;
            int entnum;
            QuakeFile f = new QuakeFile(filename, "r");
            if (f == null) {
                GameBase.gi.error("Couldn't read level file " + filename);
            }
            GameSave.CreateEdicts();
            GameBase.num_edicts = (int)GameBase.maxclients.value + 1;
            GameBase.level.read(f);
            while ((entnum = f.readInt()) != -1) {
                if (entnum >= GameBase.num_edicts) {
                    GameBase.num_edicts = entnum + 1;
                }
                ent = GameBase.g_edicts[entnum];
                ent.read(f);
                ent.cleararealinks();
                GameBase.gi.linkentity(ent);
            }
            Lib.fclose(f);
            int i = 0;
            while ((float)i < GameBase.maxclients.value) {
                ent = GameBase.g_edicts[i + 1];
                ent.client = GameBase.game.clients[i];
                ent.client.pers.connected = false;
                ++i;
            }
            for (i = 0; i < GameBase.num_edicts; ++i) {
                ent = GameBase.g_edicts[i];
                if (!ent.inuse || ent.classname == null || Lib.strcmp(ent.classname, "target_crosslevel_target") != 0) continue;
                ent.nextthink = GameBase.level.time + ent.delay;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

