/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.GameBase;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class GameSVCmds {
    public static final int MAX_IPFILTERS = 1024;
    static ipfilter_t[] ipfilters = new ipfilter_t[1024];
    static int numipfilters;

    public static void Svcmd_Test_f() {
        GameBase.gi.cprintf(null, 2, "Svcmd_Test_f()\n");
    }

    static boolean StringToFilter(String s, ipfilter_t f) {
        byte[] b = new byte[]{0, 0, 0, 0};
        byte[] m = new byte[]{0, 0, 0, 0};
        try {
            StringTokenizer tk = new StringTokenizer(s, ". ");
            for (int n = 0; n < 4; ++n) {
                b[n] = (byte)Lib.atoi(tk.nextToken());
                if (b[n] == 0) continue;
                m[n] = -1;
            }
            f.mask = ByteBuffer.wrap(m).getInt();
            f.compare = ByteBuffer.wrap(b).getInt();
        }
        catch (Exception e) {
            GameBase.gi.cprintf(null, 2, "Bad filter address: " + s + "\n");
            return false;
        }
        return true;
    }

    static boolean SV_FilterPacket(String from) {
        int i;
        int[] m = new int[]{0, 0, 0, 0};
        int p = 0;
        for (i = 0; p < from.length() && i < 4; ++i, ++p) {
            m[i] = 0;
            char c = from.charAt(p);
            while (c >= '0' && c <= '9') {
                m[i] = m[i] * 10 + (c - 48);
                c = from.charAt(p++);
            }
            if (p == from.length() || c == ':') break;
        }
        int in = m[0] & 0xFF | (m[1] & 0xFF) << 8 | (m[2] & 0xFF) << 16 | (m[3] & 0xFF) << 24;
        for (i = 0; i < numipfilters; ++i) {
            if ((in & GameSVCmds.ipfilters[i].mask) != GameSVCmds.ipfilters[i].compare) continue;
            return (int)GameBase.filterban.value != 0;
        }
        return 1.0f - GameBase.filterban.value != 0.0f;
    }

    static void SVCmd_AddIP_f() {
        int i;
        if (GameBase.gi.argc() < 3) {
            GameBase.gi.cprintf(null, 2, "Usage:  addip <ip-mask>\n");
            return;
        }
        for (i = 0; i < numipfilters && GameSVCmds.ipfilters[i].compare != -1; ++i) {
        }
        if (i == numipfilters) {
            if (numipfilters == 1024) {
                GameBase.gi.cprintf(null, 2, "IP filter list is full\n");
                return;
            }
            ++numipfilters;
        }
        if (!GameSVCmds.StringToFilter(GameBase.gi.argv(2), ipfilters[i])) {
            GameSVCmds.ipfilters[i].compare = -1;
        }
    }

    static void SVCmd_RemoveIP_f() {
        ipfilter_t f = new ipfilter_t();
        if (GameBase.gi.argc() < 3) {
            GameBase.gi.cprintf(null, 2, "Usage:  sv removeip <ip-mask>\n");
            return;
        }
        if (!GameSVCmds.StringToFilter(GameBase.gi.argv(2), f)) {
            return;
        }
        for (int i = 0; i < numipfilters; ++i) {
            if (GameSVCmds.ipfilters[i].mask != f.mask || GameSVCmds.ipfilters[i].compare != f.compare) continue;
            for (int j = i + 1; j < numipfilters; ++j) {
                GameSVCmds.ipfilters[j - 1] = ipfilters[j];
            }
            --numipfilters;
            GameBase.gi.cprintf(null, 2, "Removed.\n");
            return;
        }
        GameBase.gi.cprintf(null, 2, "Didn't find " + GameBase.gi.argv(2) + ".\n");
    }

    static void SVCmd_ListIP_f() {
        GameBase.gi.cprintf(null, 2, "Filter list:\n");
        for (int i = 0; i < numipfilters; ++i) {
            byte[] b = Lib.getIntBytes(GameSVCmds.ipfilters[i].compare);
            GameBase.gi.cprintf(null, 2, (b[0] & 0xFF) + "." + (b[1] & 0xFF) + "." + (b[2] & 0xFF) + "." + (b[3] & 0xFF));
        }
    }

    static void SVCmd_WriteIP_f() {
        cvar_t game = GameBase.gi.cvar("game", "", 0);
        String name = game.string == null ? "baseq2/listip.cfg" : game.string + "/listip.cfg";
        GameBase.gi.cprintf(null, 2, "Writing " + name + ".\n");
        RandomAccessFile f = Lib.fopen(name, "rw");
        if (f == null) {
            GameBase.gi.cprintf(null, 2, "Couldn't open " + name + "\n");
            return;
        }
        try {
            f.writeChars("set filterban " + (int)GameBase.filterban.value + "\n");
            for (int i = 0; i < numipfilters; ++i) {
                byte[] b = Lib.getIntBytes(GameSVCmds.ipfilters[i].compare);
                f.writeChars("sv addip " + (b[0] & 0xFF) + "." + (b[1] & 0xFF) + "." + (b[2] & 0xFF) + "." + (b[3] & 0xFF) + "\n");
            }
        }
        catch (IOException e) {
            Com.Printf("IOError in SVCmd_WriteIP_f:" + e);
        }
        Lib.fclose(f);
    }

    public static void ServerCommand() {
        String cmd = GameBase.gi.argv(1);
        if (Lib.Q_stricmp(cmd, "test") == 0) {
            GameSVCmds.Svcmd_Test_f();
        } else if (Lib.Q_stricmp(cmd, "addip") == 0) {
            GameSVCmds.SVCmd_AddIP_f();
        } else if (Lib.Q_stricmp(cmd, "removeip") == 0) {
            GameSVCmds.SVCmd_RemoveIP_f();
        } else if (Lib.Q_stricmp(cmd, "listip") == 0) {
            GameSVCmds.SVCmd_ListIP_f();
        } else if (Lib.Q_stricmp(cmd, "writeip") == 0) {
            GameSVCmds.SVCmd_WriteIP_f();
        } else {
            GameBase.gi.cprintf(null, 2, "Unknown server command \"" + cmd + "\"\n");
        }
    }

    static {
        for (int n = 0; n < 1024; ++n) {
            GameSVCmds.ipfilters[n] = new ipfilter_t();
        }
    }

    public static class ipfilter_t {
        int mask;
        int compare;
    }
}

