/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.client.M;
import jake2.game.EdictFindFilter;
import jake2.game.EdictIterator;
import jake2.game.EntDieAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.EntTouchAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameFunc;
import jake2.game.GameUtil;
import jake2.game.cplane_t;
import jake2.game.csurface_t;
import jake2.game.edict_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.util.Calendar;

public class GameMisc {
    public static EntUseAdapter Use_Areaportal = new EntUseAdapter(){

        public String getID() {
            return "use_areaportal";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            ent.count ^= 1;
            GameBase.gi.SetAreaPortalState(ent.style, ent.count != 0);
        }
    };
    static EntThinkAdapter SP_func_areaportal = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_areaportal";
        }

        public boolean think(edict_t ent) {
            ent.use = Use_Areaportal;
            ent.count = 0;
            return true;
        }
    };
    public static EntTouchAdapter path_corner_touch = new EntTouchAdapter(){

        public String getID() {
            return "path_corner_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            edict_t next;
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            if (other.movetarget != self) {
                return;
            }
            if (other.enemy != null) {
                return;
            }
            if (self.pathtarget != null) {
                String savetarget = self.target;
                self.target = self.pathtarget;
                GameUtil.G_UseTargets(self, other);
                self.target = savetarget;
            }
            if ((next = self.target != null ? GameBase.G_PickTarget(self.target) : null) != null && (next.spawnflags & 1) != 0) {
                Math3D.VectorCopy(next.s.origin, v);
                v[2] = v[2] + next.mins[2];
                v[2] = v[2] - other.mins[2];
                Math3D.VectorCopy(v, other.s.origin);
                next = GameBase.G_PickTarget(next.target);
                other.s.event = 7;
            }
            other.goalentity = other.movetarget = next;
            if (self.wait != 0.0f) {
                other.monsterinfo.pausetime = GameBase.level.time + self.wait;
                other.monsterinfo.stand.think(other);
                return;
            }
            if (other.movetarget == null) {
                other.monsterinfo.pausetime = GameBase.level.time + 1.0E8f;
                other.monsterinfo.stand.think(other);
            } else {
                Math3D.VectorSubtract(other.goalentity.s.origin, other.s.origin, v);
                other.ideal_yaw = Math3D.vectoyaw(v);
            }
        }
    };
    public static EntTouchAdapter point_combat_touch = new EntTouchAdapter(){

        public String getID() {
            return "point_combat_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (other.movetarget != self) {
                return;
            }
            if (self.target != null) {
                other.target = self.target;
                other.goalentity = other.movetarget = GameBase.G_PickTarget(other.target);
                if (null == other.goalentity) {
                    GameBase.gi.dprintf(self.classname + " at " + Lib.vtos(self.s.origin) + " target " + self.target + " does not exist\n");
                    other.movetarget = self;
                }
                self.target = null;
            } else if ((self.spawnflags & 1) != 0 && 0 == (other.flags & 3)) {
                other.monsterinfo.pausetime = GameBase.level.time + 1.0E8f;
                other.monsterinfo.aiflags |= 1;
                other.monsterinfo.stand.think(other);
            }
            if (other.movetarget == self) {
                other.target = null;
                other.movetarget = null;
                other.goalentity = other.enemy;
                other.monsterinfo.aiflags &= 0xFFFFEFFF;
            }
            if (self.pathtarget != null) {
                String savetarget = self.target;
                self.target = self.pathtarget;
                edict_t activator = other.enemy != null && other.enemy.client != null ? other.enemy : (other.oldenemy != null && other.oldenemy.client != null ? other.oldenemy : (other.activator != null && other.activator.client != null ? other.activator : other));
                GameUtil.G_UseTargets(self, activator);
                self.target = savetarget;
            }
        }
    };
    public static EntThinkAdapter TH_viewthing = new EntThinkAdapter(){

        public String getID() {
            return "th_viewthing";
        }

        public boolean think(edict_t ent) {
            ent.s.frame = (ent.s.frame + 1) % 7;
            ent.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };
    public static final int START_OFF = 1;
    public static EntUseAdapter light_use = new EntUseAdapter(){

        public String getID() {
            return "light_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if ((self.spawnflags & 1) != 0) {
                GameBase.gi.configstring(800 + self.style, "m");
                self.spawnflags &= 0xFFFFFFFE;
            } else {
                GameBase.gi.configstring(800 + self.style, "a");
                self.spawnflags |= 1;
            }
        }
    };
    static EntUseAdapter func_wall_use = new EntUseAdapter(){

        public String getID() {
            return "func_wall_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (self.solid == 0) {
                self.solid = 3;
                self.svflags &= 0xFFFFFFFE;
                GameUtil.KillBox(self);
            } else {
                self.solid = 0;
                self.svflags |= 1;
            }
            GameBase.gi.linkentity(self);
            if (0 == (self.spawnflags & 2)) {
                self.use = null;
            }
        }
    };
    static EntTouchAdapter func_object_touch = new EntTouchAdapter(){

        public String getID() {
            return "func_object_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (plane == null) {
                return;
            }
            if ((double)plane.normal[2] < 1.0) {
                return;
            }
            if (other.takedamage == 0) {
                return;
            }
            GameCombat.T_Damage(other, self, self, Globals.vec3_origin, self.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
        }
    };
    static EntThinkAdapter func_object_release = new EntThinkAdapter(){

        public String getID() {
            return "func_object_release";
        }

        public boolean think(edict_t self) {
            self.movetype = 7;
            self.touch = func_object_touch;
            return true;
        }
    };
    static EntUseAdapter func_object_use = new EntUseAdapter(){

        public String getID() {
            return "func_object_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.solid = 3;
            self.svflags &= 0xFFFFFFFE;
            self.use = null;
            GameUtil.KillBox(self);
            func_object_release.think(self);
        }
    };
    public static EntDieAdapter func_explosive_explode = new EntDieAdapter(){

        public String getID() {
            return "func_explosive_explode";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            int count;
            float[] origin = new float[]{0.0f, 0.0f, 0.0f};
            float[] chunkorigin = new float[]{0.0f, 0.0f, 0.0f};
            float[] size = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorScale(self.size, 0.5f, size);
            Math3D.VectorAdd(self.absmin, size, origin);
            Math3D.VectorCopy(origin, self.s.origin);
            self.takedamage = 0;
            if (self.dmg != 0) {
                GameCombat.T_RadiusDamage(self, attacker, self.dmg, null, self.dmg + 40, 25);
            }
            Math3D.VectorSubtract(self.s.origin, inflictor.s.origin, self.velocity);
            Math3D.VectorNormalize(self.velocity);
            Math3D.VectorScale(self.velocity, 150.0f, self.velocity);
            Math3D.VectorScale(size, 0.5f, size);
            int mass = self.mass;
            if (0 == mass) {
                mass = 75;
            }
            if (mass >= 100) {
                count = mass / 100;
                if (count > 8) {
                    count = 8;
                }
                while (count-- != 0) {
                    chunkorigin[0] = origin[0] + Lib.crandom() * size[0];
                    chunkorigin[1] = origin[1] + Lib.crandom() * size[1];
                    chunkorigin[2] = origin[2] + Lib.crandom() * size[2];
                    GameMisc.ThrowDebris(self, "models/objects/debris1/tris.md2", 1.0f, chunkorigin);
                }
            }
            if ((count = mass / 25) > 16) {
                count = 16;
            }
            while (count-- != 0) {
                chunkorigin[0] = origin[0] + Lib.crandom() * size[0];
                chunkorigin[1] = origin[1] + Lib.crandom() * size[1];
                chunkorigin[2] = origin[2] + Lib.crandom() * size[2];
                GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", 2.0f, chunkorigin);
            }
            GameUtil.G_UseTargets(self, attacker);
            if (self.dmg != 0) {
                GameMisc.BecomeExplosion1(self);
            } else {
                GameUtil.G_FreeEdict(self);
            }
        }
    };
    public static EntUseAdapter func_explosive_use = new EntUseAdapter(){

        public String getID() {
            return "func_explosive_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            func_explosive_explode.die(self, self, other, self.health, Globals.vec3_origin);
        }
    };
    public static EntUseAdapter func_explosive_spawn = new EntUseAdapter(){

        public String getID() {
            return "func_explosive_spawn";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.solid = 3;
            self.svflags &= 0xFFFFFFFE;
            self.use = null;
            GameUtil.KillBox(self);
            GameBase.gi.linkentity(self);
        }
    };
    public static EntTouchAdapter barrel_touch = new EntTouchAdapter(){

        public String getID() {
            return "barrel_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            if (null == other.groundentity || other.groundentity == self) {
                return;
            }
            float ratio = (float)other.mass / (float)self.mass;
            Math3D.VectorSubtract(self.s.origin, other.s.origin, v);
            M.M_walkmove(self, Math3D.vectoyaw(v), 20.0f * ratio * 0.1f);
        }
    };
    public static EntThinkAdapter barrel_explode = new EntThinkAdapter(){

        public String getID() {
            return "barrel_explode";
        }

        public boolean think(edict_t self) {
            float[] org = new float[]{0.0f, 0.0f, 0.0f};
            float[] save = new float[]{0.0f, 0.0f, 0.0f};
            GameCombat.T_RadiusDamage(self, self.activator, self.dmg, null, self.dmg + 40, 26);
            Math3D.VectorCopy(self.s.origin, save);
            Math3D.VectorMA(self.absmin, 0.5f, self.size, self.s.origin);
            float spd = 1.5f * (float)self.dmg / 200.0f;
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris1/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris1/tris.md2", spd, org);
            spd = 1.75f * (float)self.dmg / 200.0f;
            Math3D.VectorCopy(self.absmin, org);
            GameMisc.ThrowDebris(self, "models/objects/debris3/tris.md2", spd, org);
            Math3D.VectorCopy(self.absmin, org);
            org[0] = org[0] + self.size[0];
            GameMisc.ThrowDebris(self, "models/objects/debris3/tris.md2", spd, org);
            Math3D.VectorCopy(self.absmin, org);
            org[1] = org[1] + self.size[1];
            GameMisc.ThrowDebris(self, "models/objects/debris3/tris.md2", spd, org);
            Math3D.VectorCopy(self.absmin, org);
            org[0] = org[0] + self.size[0];
            org[1] = org[1] + self.size[1];
            GameMisc.ThrowDebris(self, "models/objects/debris3/tris.md2", spd, org);
            spd = 2 * self.dmg / 200;
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            org[0] = self.s.origin[0] + Lib.crandom() * self.size[0];
            org[1] = self.s.origin[1] + Lib.crandom() * self.size[1];
            org[2] = self.s.origin[2] + Lib.crandom() * self.size[2];
            GameMisc.ThrowDebris(self, "models/objects/debris2/tris.md2", spd, org);
            Math3D.VectorCopy(save, self.s.origin);
            if (self.groundentity != null) {
                GameMisc.BecomeExplosion2(self);
            } else {
                GameMisc.BecomeExplosion1(self);
            }
            return true;
        }
    };
    public static EntDieAdapter barrel_delay = new EntDieAdapter(){

        public String getID() {
            return "barrel_delay";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            self.takedamage = 0;
            self.nextthink = GameBase.level.time + 0.2f;
            self.think = barrel_explode;
            self.activator = attacker;
        }
    };
    static EntUseAdapter misc_blackhole_use = new EntUseAdapter(){

        public String getID() {
            return "misc_blavkhole_use";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            GameUtil.G_FreeEdict(ent);
        }
    };
    static EntThinkAdapter misc_blackhole_think = new EntThinkAdapter(){

        public String getID() {
            return "misc_blackhole_think";
        }

        public boolean think(edict_t self) {
            if (++self.s.frame < 19) {
                self.nextthink = GameBase.level.time + 0.1f;
            } else {
                self.s.frame = 0;
                self.nextthink = GameBase.level.time + 0.1f;
            }
            return true;
        }
    };
    static EntThinkAdapter misc_eastertank_think = new EntThinkAdapter(){

        public String getID() {
            return "misc_eastertank_think";
        }

        public boolean think(edict_t self) {
            if (++self.s.frame < 293) {
                self.nextthink = GameBase.level.time + 0.1f;
            } else {
                self.s.frame = 254;
                self.nextthink = GameBase.level.time + 0.1f;
            }
            return true;
        }
    };
    static EntThinkAdapter misc_easterchick_think = new EntThinkAdapter(){

        public String getID() {
            return "misc_easterchick_think";
        }

        public boolean think(edict_t self) {
            if (++self.s.frame < 247) {
                self.nextthink = GameBase.level.time + 0.1f;
            } else {
                self.s.frame = 208;
                self.nextthink = GameBase.level.time + 0.1f;
            }
            return true;
        }
    };
    static EntThinkAdapter misc_easterchick2_think = new EntThinkAdapter(){

        public String getID() {
            return "misc_easterchick2_think";
        }

        public boolean think(edict_t self) {
            if (++self.s.frame < 287) {
                self.nextthink = GameBase.level.time + 0.1f;
            } else {
                self.s.frame = 248;
                self.nextthink = GameBase.level.time + 0.1f;
            }
            return true;
        }
    };
    public static EntThinkAdapter commander_body_think = new EntThinkAdapter(){

        public String getID() {
            return "commander_body_think";
        }

        public boolean think(edict_t self) {
            self.nextthink = ++self.s.frame < 24 ? GameBase.level.time + 0.1f : 0.0f;
            if (self.s.frame == 22) {
                GameBase.gi.sound(self, 4, GameBase.gi.soundindex("tank/thud.wav"), 1.0f, 1.0f, 0.0f);
            }
            return true;
        }
    };
    public static EntUseAdapter commander_body_use = new EntUseAdapter(){

        public String getID() {
            return "commander_body_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.think = commander_body_think;
            self.nextthink = GameBase.level.time + 0.1f;
            GameBase.gi.sound(self, 4, GameBase.gi.soundindex("tank/pain.wav"), 1.0f, 1.0f, 0.0f);
        }
    };
    public static EntThinkAdapter commander_body_drop = new EntThinkAdapter(){

        public String getID() {
            return "commander_body_group";
        }

        public boolean think(edict_t self) {
            self.movetype = 7;
            self.s.origin[2] = self.s.origin[2] + 2.0f;
            return true;
        }
    };
    static EntThinkAdapter misc_banner_think = new EntThinkAdapter(){

        public String getID() {
            return "misc_banner_think";
        }

        public boolean think(edict_t ent) {
            ent.s.frame = (ent.s.frame + 1) % 16;
            ent.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };
    static EntDieAdapter misc_deadsoldier_die = new EntDieAdapter(){

        public String getID() {
            return "misc_deadsoldier_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            if (self.health > -80) {
                return;
            }
            GameBase.gi.sound(self, 4, GameBase.gi.soundindex("misc/udeath.wav"), 1.0f, 1.0f, 0.0f);
            for (int n = 0; n < 4; ++n) {
                GameMisc.ThrowGib(self, "models/objects/gibs/sm_meat/tris.md2", damage, 0);
            }
            GameMisc.ThrowHead(self, "models/objects/gibs/head2/tris.md2", damage, 0);
        }
    };
    static EntUseAdapter misc_viper_use = new EntUseAdapter(){

        public String getID() {
            return "misc_viper_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.svflags &= 0xFFFFFFFE;
            self.use = GameFunc.train_use;
            GameFunc.train_use.use(self, other, activator);
        }
    };
    static EntTouchAdapter misc_viper_bomb_touch = new EntTouchAdapter(){

        public String getID() {
            return "misc_viper_bomb_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            GameUtil.G_UseTargets(self, self.activator);
            self.s.origin[2] = self.absmin[2] + 1.0f;
            GameCombat.T_RadiusDamage(self, self, self.dmg, null, self.dmg + 40, 27);
            GameMisc.BecomeExplosion2(self);
        }
    };
    static EntThinkAdapter misc_viper_bomb_prethink = new EntThinkAdapter(){

        public String getID() {
            return "misc_viper_bomb_prethink";
        }

        public boolean think(edict_t self) {
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            self.groundentity = null;
            float diff = self.timestamp - GameBase.level.time;
            if ((double)diff < -1.0) {
                diff = -1.0f;
            }
            Math3D.VectorScale(self.moveinfo.dir, 1.0f + diff, v);
            v[2] = diff;
            diff = self.s.angles[2];
            Math3D.vectoangles(v, self.s.angles);
            self.s.angles[2] = diff + 10.0f;
            return true;
        }
    };
    static EntUseAdapter misc_viper_bomb_use = new EntUseAdapter(){

        public String getID() {
            return "misc_viper_bomb_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            edict_t viper = null;
            self.solid = 2;
            self.svflags &= 0xFFFFFFFE;
            self.s.effects |= 0x10;
            self.use = null;
            self.movetype = 7;
            self.prethink = misc_viper_bomb_prethink;
            self.touch = misc_viper_bomb_touch;
            self.activator = activator;
            EdictIterator es = null;
            if ((es = GameBase.G_Find(es, GameBase.findByClass, "misc_viper")) != null) {
                viper = es.o;
            }
            Math3D.VectorScale(viper.moveinfo.dir, viper.moveinfo.speed, self.velocity);
            self.timestamp = GameBase.level.time;
            Math3D.VectorCopy(viper.moveinfo.dir, self.moveinfo.dir);
        }
    };
    static EntUseAdapter misc_strogg_ship_use = new EntUseAdapter(){

        public String getID() {
            return "misc_strogg_ship_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.svflags &= 0xFFFFFFFE;
            self.use = GameFunc.train_use;
            GameFunc.train_use.use(self, other, activator);
        }
    };
    static EntThinkAdapter misc_satellite_dish_think = new EntThinkAdapter(){

        public String getID() {
            return "misc_satellite_dish_think";
        }

        public boolean think(edict_t self) {
            ++self.s.frame;
            if (self.s.frame < 38) {
                self.nextthink = GameBase.level.time + 0.1f;
            }
            return true;
        }
    };
    static EntUseAdapter misc_satellite_dish_use = new EntUseAdapter(){

        public String getID() {
            return "misc_satellite_dish_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.s.frame = 0;
            self.think = misc_satellite_dish_think;
            self.nextthink = GameBase.level.time + 0.1f;
        }
    };
    static EntUseAdapter target_string_use = new EntUseAdapter(){

        public String getID() {
            return "target_string_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            int l = self.message.length();
            edict_t e = self.teammaster;
            while (e != null) {
                if (e.count != 0) {
                    char c;
                    int n = e.count - 1;
                    e.s.frame = n >= l ? 12 : ((c = self.message.charAt(n)) >= '0' && c <= '9' ? c - 48 : (c == '-' ? 10 : (c == ':' ? 11 : 12)));
                }
                e = e.teamchain;
            }
        }
    };
    public static final int CLOCK_MESSAGE_SIZE = 16;
    public static EntThinkAdapter func_clock_think = new EntThinkAdapter(){

        public String getID() {
            return "func_clock_think";
        }

        public boolean think(edict_t self) {
            if (null == self.enemy) {
                EdictIterator es = null;
                if ((es = GameBase.G_Find(es, GameBase.findByTarget, self.target)) != null) {
                    self.enemy = es.o;
                }
                if (self.enemy == null) {
                    return true;
                }
            }
            if ((self.spawnflags & 1) != 0) {
                GameMisc.func_clock_format_countdown(self);
                ++self.health;
            } else if ((self.spawnflags & 2) != 0) {
                GameMisc.func_clock_format_countdown(self);
                --self.health;
            } else {
                Calendar c = Calendar.getInstance();
                self.message = "" + c.get(11) + ":" + c.get(12) + ":" + c.get(13);
            }
            self.enemy.message = self.message;
            self.enemy.use.use(self.enemy, self, self);
            if ((self.spawnflags & 1) != 0 && (float)self.health > self.wait || (self.spawnflags & 2) != 0 && (float)self.health < self.wait) {
                if (self.pathtarget != null) {
                    String savetarget = self.target;
                    String savemessage = self.message;
                    self.target = self.pathtarget;
                    self.message = null;
                    GameUtil.G_UseTargets(self, self.activator);
                    self.target = savetarget;
                    self.message = savemessage;
                }
                if (0 == (self.spawnflags & 8)) {
                    return true;
                }
                GameMisc.func_clock_reset(self);
                if ((self.spawnflags & 4) != 0) {
                    return true;
                }
            }
            self.nextthink = GameBase.level.time + 1.0f;
            return true;
        }
    };
    public static EntUseAdapter func_clock_use = new EntUseAdapter(){

        public String getID() {
            return "func_clock_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (0 == (self.spawnflags & 8)) {
                self.use = null;
            }
            if (self.activator != null) {
                return;
            }
            self.activator = activator;
            self.think.think(self);
        }
    };
    static EntTouchAdapter teleporter_touch = new EntTouchAdapter(){

        public String getID() {
            return "teleporter_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (other.client == null) {
                return;
            }
            Object es = null;
            edict_t dest = GameBase.G_Find(null, (EdictFindFilter)GameBase.findByTarget, (String)self.target).o;
            if (dest == null) {
                GameBase.gi.dprintf("Couldn't find destination\n");
                return;
            }
            GameBase.gi.unlinkentity(other);
            Math3D.VectorCopy(dest.s.origin, other.s.origin);
            Math3D.VectorCopy(dest.s.origin, other.s.old_origin);
            other.s.origin[2] = other.s.origin[2] + 10.0f;
            Math3D.VectorClear(other.velocity);
            other.client.ps.pmove.pm_time = (byte)20;
            other.client.ps.pmove.pm_flags = (byte)(other.client.ps.pmove.pm_flags | 0x20);
            self.owner.s.event = 6;
            other.s.event = 6;
            for (int i = 0; i < 3; ++i) {
                other.client.ps.pmove.delta_angles[i] = (short)Math3D.ANGLE2SHORT(dest.s.angles[i] - other.client.resp.cmd_angles[i]);
            }
            Math3D.VectorClear(other.s.angles);
            Math3D.VectorClear(other.client.ps.viewangles);
            Math3D.VectorClear(other.client.v_angle);
            GameUtil.KillBox(other);
            GameBase.gi.linkentity(other);
        }
    };
    public static EntThinkAdapter SP_misc_teleporter_dest = new EntThinkAdapter(){

        public String getID() {
            return "SP_misc_teleporter_dest";
        }

        public boolean think(edict_t ent) {
            GameBase.gi.setmodel(ent, "models/objects/dmspot/tris.md2");
            ent.s.skinnum = 0;
            ent.solid = 2;
            Math3D.VectorSet(ent.mins, -32.0f, -32.0f, -24.0f);
            Math3D.VectorSet(ent.maxs, 32.0f, 32.0f, -16.0f);
            GameBase.gi.linkentity(ent);
            return true;
        }
    };
    public static EntThinkAdapter gib_think = new EntThinkAdapter(){

        public String getID() {
            return "gib_think";
        }

        public boolean think(edict_t self) {
            ++self.s.frame;
            self.nextthink = GameBase.level.time + 0.1f;
            if (self.s.frame == 10) {
                self.think = GameUtil.G_FreeEdictA;
                self.nextthink = GameBase.level.time + 8.0f + Globals.rnd.nextFloat() * 10.0f;
            }
            return true;
        }
    };
    public static EntTouchAdapter gib_touch = new EntTouchAdapter(){

        public String getID() {
            return "gib_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            float[] normal_angles = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            if (null == self.groundentity) {
                return;
            }
            self.touch = null;
            if (plane != null) {
                GameBase.gi.sound(self, 2, GameBase.gi.soundindex("misc/fhit3.wav"), 1.0f, 1.0f, 0.0f);
                Math3D.vectoangles(plane.normal, normal_angles);
                Math3D.AngleVectors(normal_angles, null, right, null);
                Math3D.vectoangles(right, self.s.angles);
                if (self.s.modelindex == GameBase.sm_meat_index) {
                    ++self.s.frame;
                    self.think = gib_think;
                    self.nextthink = GameBase.level.time + 0.1f;
                }
            }
        }
    };
    public static EntDieAdapter gib_die = new EntDieAdapter(){

        public String getID() {
            return "gib_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            GameUtil.G_FreeEdict(self);
        }
    };
    public static EntDieAdapter debris_die = new EntDieAdapter(){

        public String getID() {
            return "debris_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            GameUtil.G_FreeEdict(self);
        }
    };

    public static void SP_path_corner(edict_t self) {
        if (self.targetname == null) {
            GameBase.gi.dprintf("path_corner with no targetname at " + Lib.vtos(self.s.origin) + "\n");
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.solid = 1;
        self.touch = path_corner_touch;
        Math3D.VectorSet(self.mins, -8.0f, -8.0f, -8.0f);
        Math3D.VectorSet(self.maxs, 8.0f, 8.0f, 8.0f);
        self.svflags |= 1;
        GameBase.gi.linkentity(self);
    }

    public static void SP_point_combat(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.solid = 1;
        self.touch = point_combat_touch;
        Math3D.VectorSet(self.mins, -8.0f, -8.0f, -16.0f);
        Math3D.VectorSet(self.maxs, 8.0f, 8.0f, 16.0f);
        self.svflags = 1;
        GameBase.gi.linkentity(self);
    }

    public static void SP_viewthing(edict_t ent) {
        GameBase.gi.dprintf("viewthing spawned\n");
        ent.movetype = 0;
        ent.solid = 2;
        ent.s.renderfx = 64;
        Math3D.VectorSet(ent.mins, -16.0f, -16.0f, -24.0f);
        Math3D.VectorSet(ent.maxs, 16.0f, 16.0f, 32.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/objects/banner/tris.md2");
        GameBase.gi.linkentity(ent);
        ent.nextthink = GameBase.level.time + 0.5f;
        ent.think = TH_viewthing;
    }

    public static void SP_info_null(edict_t self) {
        GameUtil.G_FreeEdict(self);
    }

    public static void SP_info_notnull(edict_t self) {
        Math3D.VectorCopy(self.s.origin, self.absmin);
        Math3D.VectorCopy(self.s.origin, self.absmax);
    }

    public static void SP_light(edict_t self) {
        if (null == self.targetname || GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        if (self.style >= 32) {
            self.use = light_use;
            if ((self.spawnflags & 1) != 0) {
                GameBase.gi.configstring(800 + self.style, "a");
            } else {
                GameBase.gi.configstring(800 + self.style, "m");
            }
        }
    }

    public static void SP_func_wall(edict_t self) {
        self.movetype = 2;
        GameBase.gi.setmodel(self, self.model);
        if ((self.spawnflags & 8) != 0) {
            self.s.effects |= 0x1000;
        }
        if ((self.spawnflags & 0x10) != 0) {
            self.s.effects |= 0x2000;
        }
        if ((self.spawnflags & 7) == 0) {
            self.solid = 3;
            GameBase.gi.linkentity(self);
            return;
        }
        if (0 == (self.spawnflags & 1)) {
            GameBase.gi.dprintf("func_wall missing TRIGGER_SPAWN\n");
            self.spawnflags |= 1;
        }
        if ((self.spawnflags & 4) != 0 && 0 == (self.spawnflags & 2)) {
            GameBase.gi.dprintf("func_wall START_ON without TOGGLE\n");
            self.spawnflags |= 2;
        }
        self.use = func_wall_use;
        if ((self.spawnflags & 4) != 0) {
            self.solid = 3;
        } else {
            self.solid = 0;
            self.svflags |= 1;
        }
        GameBase.gi.linkentity(self);
    }

    public static void SP_func_object(edict_t self) {
        GameBase.gi.setmodel(self, self.model);
        self.mins[0] = self.mins[0] + 1.0f;
        self.mins[1] = self.mins[1] + 1.0f;
        self.mins[2] = self.mins[2] + 1.0f;
        self.maxs[0] = self.maxs[0] - 1.0f;
        self.maxs[1] = self.maxs[1] - 1.0f;
        self.maxs[2] = self.maxs[2] - 1.0f;
        if (self.dmg == 0) {
            self.dmg = 100;
        }
        if (self.spawnflags == 0) {
            self.solid = 3;
            self.movetype = 2;
            self.think = func_object_release;
            self.nextthink = GameBase.level.time + 0.2f;
        } else {
            self.solid = 0;
            self.movetype = 2;
            self.use = func_object_use;
            self.svflags |= 1;
        }
        if ((self.spawnflags & 2) != 0) {
            self.s.effects |= 0x1000;
        }
        if ((self.spawnflags & 4) != 0) {
            self.s.effects |= 0x2000;
        }
        self.clipmask = 0x2020003;
        GameBase.gi.linkentity(self);
    }

    public static void SP_func_explosive(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.movetype = 2;
        GameBase.gi.modelindex("models/objects/debris1/tris.md2");
        GameBase.gi.modelindex("models/objects/debris2/tris.md2");
        GameBase.gi.setmodel(self, self.model);
        if ((self.spawnflags & 1) != 0) {
            self.svflags |= 1;
            self.solid = 0;
            self.use = func_explosive_spawn;
        } else {
            self.solid = 3;
            if (self.targetname != null) {
                self.use = func_explosive_use;
            }
        }
        if ((self.spawnflags & 2) != 0) {
            self.s.effects |= 0x1000;
        }
        if ((self.spawnflags & 4) != 0) {
            self.s.effects |= 0x2000;
        }
        if (self.use != func_explosive_use) {
            if (self.health == 0) {
                self.health = 100;
            }
            self.die = func_explosive_explode;
            self.takedamage = 1;
        }
        GameBase.gi.linkentity(self);
    }

    public static void SP_misc_explobox(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        GameBase.gi.modelindex("models/objects/debris1/tris.md2");
        GameBase.gi.modelindex("models/objects/debris2/tris.md2");
        GameBase.gi.modelindex("models/objects/debris3/tris.md2");
        self.solid = 2;
        self.movetype = 5;
        self.model = "models/objects/barrels/tris.md2";
        self.s.modelindex = GameBase.gi.modelindex(self.model);
        Math3D.VectorSet(self.mins, -16.0f, -16.0f, 0.0f);
        Math3D.VectorSet(self.maxs, 16.0f, 16.0f, 40.0f);
        if (self.mass == 0) {
            self.mass = 400;
        }
        if (0 == self.health) {
            self.health = 10;
        }
        if (0 == self.dmg) {
            self.dmg = 150;
        }
        self.die = barrel_delay;
        self.takedamage = 1;
        self.monsterinfo.aiflags = 1024;
        self.touch = barrel_touch;
        self.think = M.M_droptofloor;
        self.nextthink = GameBase.level.time + 0.2f;
        GameBase.gi.linkentity(self);
    }

    public static void SP_misc_blackhole(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 0;
        Math3D.VectorSet(ent.mins, -64.0f, -64.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 64.0f, 64.0f, 8.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/objects/black/tris.md2");
        ent.s.renderfx = 32;
        ent.use = misc_blackhole_use;
        ent.think = misc_blackhole_think;
        ent.nextthink = GameBase.level.time + 0.2f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_eastertank(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        Math3D.VectorSet(ent.mins, -32.0f, -32.0f, -16.0f);
        Math3D.VectorSet(ent.maxs, 32.0f, 32.0f, 32.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/monsters/tank/tris.md2");
        ent.s.frame = 254;
        ent.think = misc_eastertank_think;
        ent.nextthink = GameBase.level.time + 0.2f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_easterchick(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        Math3D.VectorSet(ent.mins, -32.0f, -32.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 32.0f, 32.0f, 32.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/monsters/bitch/tris.md2");
        ent.s.frame = 208;
        ent.think = misc_easterchick_think;
        ent.nextthink = GameBase.level.time + 0.2f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_easterchick2(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        Math3D.VectorSet(ent.mins, -32.0f, -32.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 32.0f, 32.0f, 32.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/monsters/bitch/tris.md2");
        ent.s.frame = 248;
        ent.think = misc_easterchick2_think;
        ent.nextthink = GameBase.level.time + 0.2f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_monster_commander_body(edict_t self) {
        self.movetype = 0;
        self.solid = 2;
        self.model = "models/monsters/commandr/tris.md2";
        self.s.modelindex = GameBase.gi.modelindex(self.model);
        Math3D.VectorSet(self.mins, -32.0f, -32.0f, 0.0f);
        Math3D.VectorSet(self.maxs, 32.0f, 32.0f, 48.0f);
        self.use = commander_body_use;
        self.takedamage = 1;
        self.flags = 16;
        self.s.renderfx |= 0x40;
        GameBase.gi.linkentity(self);
        GameBase.gi.soundindex("tank/thud.wav");
        GameBase.gi.soundindex("tank/pain.wav");
        self.think = commander_body_drop;
        self.nextthink = GameBase.level.time + 0.5f;
    }

    public static void SP_misc_banner(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 0;
        ent.s.modelindex = GameBase.gi.modelindex("models/objects/banner/tris.md2");
        ent.s.frame = Lib.rand() % 16;
        GameBase.gi.linkentity(ent);
        ent.think = misc_banner_think;
        ent.nextthink = GameBase.level.time + 0.1f;
    }

    public static void SP_misc_deadsoldier(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f) {
            GameUtil.G_FreeEdict(ent);
            return;
        }
        ent.movetype = 0;
        ent.solid = 2;
        ent.s.modelindex = GameBase.gi.modelindex("models/deadbods/dude/tris.md2");
        ent.s.frame = (ent.spawnflags & 2) != 0 ? 1 : ((ent.spawnflags & 4) != 0 ? 2 : ((ent.spawnflags & 8) != 0 ? 3 : ((ent.spawnflags & 0x10) != 0 ? 4 : ((ent.spawnflags & 0x20) != 0 ? 5 : 0))));
        Math3D.VectorSet(ent.mins, -16.0f, -16.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 16.0f, 16.0f, 16.0f);
        ent.deadflag = 2;
        ent.takedamage = 1;
        ent.svflags |= 6;
        ent.die = misc_deadsoldier_die;
        ent.monsterinfo.aiflags |= 0x100;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_viper(edict_t ent) {
        if (null == ent.target) {
            GameBase.gi.dprintf("misc_viper without a target at " + Lib.vtos(ent.absmin) + "\n");
            GameUtil.G_FreeEdict(ent);
            return;
        }
        if (0.0f == ent.speed) {
            ent.speed = 300.0f;
        }
        ent.movetype = 2;
        ent.solid = 0;
        ent.s.modelindex = GameBase.gi.modelindex("models/ships/viper/tris.md2");
        Math3D.VectorSet(ent.mins, -16.0f, -16.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 16.0f, 16.0f, 32.0f);
        ent.think = GameFunc.func_train_find;
        ent.nextthink = GameBase.level.time + 0.1f;
        ent.use = misc_viper_use;
        ent.svflags |= 1;
        ent.moveinfo.decel = ent.moveinfo.speed = ent.speed;
        ent.moveinfo.accel = ent.moveinfo.speed;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_bigviper(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        Math3D.VectorSet(ent.mins, -176.0f, -120.0f, -24.0f);
        Math3D.VectorSet(ent.maxs, 176.0f, 120.0f, 72.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/ships/bigviper/tris.md2");
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_viper_bomb(edict_t self) {
        self.movetype = 0;
        self.solid = 0;
        Math3D.VectorSet(self.mins, -8.0f, -8.0f, -8.0f);
        Math3D.VectorSet(self.maxs, 8.0f, 8.0f, 8.0f);
        self.s.modelindex = GameBase.gi.modelindex("models/objects/bomb/tris.md2");
        if (self.dmg == 0) {
            self.dmg = 1000;
        }
        self.use = misc_viper_bomb_use;
        self.svflags |= 1;
        GameBase.gi.linkentity(self);
    }

    public static void SP_misc_strogg_ship(edict_t ent) {
        if (null == ent.target) {
            GameBase.gi.dprintf(ent.classname + " without a target at " + Lib.vtos(ent.absmin) + "\n");
            GameUtil.G_FreeEdict(ent);
            return;
        }
        if (0.0f == ent.speed) {
            ent.speed = 300.0f;
        }
        ent.movetype = 2;
        ent.solid = 0;
        ent.s.modelindex = GameBase.gi.modelindex("models/ships/strogg1/tris.md2");
        Math3D.VectorSet(ent.mins, -16.0f, -16.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 16.0f, 16.0f, 32.0f);
        ent.think = GameFunc.func_train_find;
        ent.nextthink = GameBase.level.time + 0.1f;
        ent.use = misc_strogg_ship_use;
        ent.svflags |= 1;
        ent.moveinfo.decel = ent.moveinfo.speed = ent.speed;
        ent.moveinfo.accel = ent.moveinfo.speed;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_satellite_dish(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        Math3D.VectorSet(ent.mins, -64.0f, -64.0f, 0.0f);
        Math3D.VectorSet(ent.maxs, 64.0f, 64.0f, 128.0f);
        ent.s.modelindex = GameBase.gi.modelindex("models/objects/satellite/tris.md2");
        ent.use = misc_satellite_dish_use;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_light_mine1(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        ent.s.modelindex = GameBase.gi.modelindex("models/objects/minelite/light1/tris.md2");
        GameBase.gi.linkentity(ent);
    }

    public static void SP_light_mine2(edict_t ent) {
        ent.movetype = 0;
        ent.solid = 2;
        ent.s.modelindex = GameBase.gi.modelindex("models/objects/minelite/light2/tris.md2");
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_gib_arm(edict_t ent) {
        GameBase.gi.setmodel(ent, "models/objects/gibs/arm/tris.md2");
        ent.solid = 0;
        ent.s.effects |= 2;
        ent.takedamage = 1;
        ent.die = gib_die;
        ent.movetype = 7;
        ent.svflags |= 4;
        ent.deadflag = 2;
        ent.avelocity[0] = Lib.random() * 200.0f;
        ent.avelocity[1] = Lib.random() * 200.0f;
        ent.avelocity[2] = Lib.random() * 200.0f;
        ent.think = GameUtil.G_FreeEdictA;
        ent.nextthink = GameBase.level.time + 30.0f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_gib_leg(edict_t ent) {
        GameBase.gi.setmodel(ent, "models/objects/gibs/leg/tris.md2");
        ent.solid = 0;
        ent.s.effects |= 2;
        ent.takedamage = 1;
        ent.die = gib_die;
        ent.movetype = 7;
        ent.svflags |= 4;
        ent.deadflag = 2;
        ent.avelocity[0] = Lib.random() * 200.0f;
        ent.avelocity[1] = Lib.random() * 200.0f;
        ent.avelocity[2] = Lib.random() * 200.0f;
        ent.think = GameUtil.G_FreeEdictA;
        ent.nextthink = GameBase.level.time + 30.0f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_misc_gib_head(edict_t ent) {
        GameBase.gi.setmodel(ent, "models/objects/gibs/head/tris.md2");
        ent.solid = 0;
        ent.s.effects |= 2;
        ent.takedamage = 1;
        ent.die = gib_die;
        ent.movetype = 7;
        ent.svflags |= 4;
        ent.deadflag = 2;
        ent.avelocity[0] = Lib.random() * 200.0f;
        ent.avelocity[1] = Lib.random() * 200.0f;
        ent.avelocity[2] = Lib.random() * 200.0f;
        ent.think = GameUtil.G_FreeEdictA;
        ent.nextthink = GameBase.level.time + 30.0f;
        GameBase.gi.linkentity(ent);
    }

    public static void SP_target_character(edict_t self) {
        self.movetype = 2;
        GameBase.gi.setmodel(self, self.model);
        self.solid = 3;
        self.s.frame = 12;
        GameBase.gi.linkentity(self);
    }

    public static void SP_target_string(edict_t self) {
        if (self.message == null) {
            self.message = "";
        }
        self.use = target_string_use;
    }

    public static void func_clock_reset(edict_t self) {
        self.activator = null;
        if ((self.spawnflags & 1) != 0) {
            self.health = 0;
            self.wait = self.count;
        } else if ((self.spawnflags & 2) != 0) {
            self.health = self.count;
            self.wait = 0.0f;
        }
    }

    public static void func_clock_format_countdown(edict_t self) {
        if (self.style == 0) {
            self.message = "" + self.health;
            return;
        }
        if (self.style == 1) {
            self.message = "" + self.health / 60 + ":" + self.health % 60;
            return;
        }
        if (self.style == 2) {
            self.message = "" + self.health / 3600 + ":" + (self.health - self.health / 3600 * 3600) / 60 + ":" + self.health % 60;
            return;
        }
    }

    public static void SP_func_clock(edict_t self) {
        if (self.target == null) {
            GameBase.gi.dprintf(self.classname + " with no target at " + Lib.vtos(self.s.origin) + "\n");
            GameUtil.G_FreeEdict(self);
            return;
        }
        if ((self.spawnflags & 2) != 0 && 0 == self.count) {
            GameBase.gi.dprintf(self.classname + " with no count at " + Lib.vtos(self.s.origin) + "\n");
            GameUtil.G_FreeEdict(self);
            return;
        }
        if ((self.spawnflags & 1) != 0 && 0 == self.count) {
            self.count = 3600;
        }
        GameMisc.func_clock_reset(self);
        self.message = new String();
        self.think = func_clock_think;
        if ((self.spawnflags & 4) != 0) {
            self.use = func_clock_use;
        } else {
            self.nextthink = GameBase.level.time + 1.0f;
        }
    }

    public static void SP_misc_teleporter(edict_t ent) {
        if (ent.target == null) {
            GameBase.gi.dprintf("teleporter without a target.\n");
            GameUtil.G_FreeEdict(ent);
            return;
        }
        GameBase.gi.setmodel(ent, "models/objects/dmspot/tris.md2");
        ent.s.skinnum = 1;
        ent.s.effects = 131072;
        ent.s.sound = GameBase.gi.soundindex("world/amb10.wav");
        ent.solid = 2;
        Math3D.VectorSet(ent.mins, -32.0f, -32.0f, -24.0f);
        Math3D.VectorSet(ent.maxs, 32.0f, 32.0f, -16.0f);
        GameBase.gi.linkentity(ent);
        edict_t trig = GameUtil.G_Spawn();
        trig.touch = teleporter_touch;
        trig.solid = 1;
        trig.target = ent.target;
        trig.owner = ent;
        Math3D.VectorCopy(ent.s.origin, trig.s.origin);
        Math3D.VectorSet(trig.mins, -8.0f, -8.0f, 8.0f);
        Math3D.VectorSet(trig.maxs, 8.0f, 8.0f, 24.0f);
        GameBase.gi.linkentity(trig);
    }

    public static void VelocityForDamage(int damage, float[] v) {
        v[0] = 100.0f * Lib.crandom();
        v[1] = 100.0f * Lib.crandom();
        v[2] = 200.0f + 100.0f * Lib.random();
        if (damage < 50) {
            Math3D.VectorScale(v, 0.7f, v);
        } else {
            Math3D.VectorScale(v, 1.2f, v);
        }
    }

    public static void BecomeExplosion1(edict_t self) {
        GameBase.gi.WriteByte(3);
        GameBase.gi.WriteByte(5);
        GameBase.gi.WritePosition(self.s.origin);
        GameBase.gi.multicast(self.s.origin, 2);
        GameUtil.G_FreeEdict(self);
    }

    public static void BecomeExplosion2(edict_t self) {
        GameBase.gi.WriteByte(3);
        GameBase.gi.WriteByte(6);
        GameBase.gi.WritePosition(self.s.origin);
        GameBase.gi.multicast(self.s.origin, 2);
        GameUtil.G_FreeEdict(self);
    }

    public static void ThrowGib(edict_t self, String gibname, int damage, int type) {
        float vscale;
        float[] vd = new float[]{0.0f, 0.0f, 0.0f};
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        float[] size = new float[]{0.0f, 0.0f, 0.0f};
        edict_t gib = GameUtil.G_Spawn();
        Math3D.VectorScale(self.size, 0.5f, size);
        Math3D.VectorAdd(self.absmin, size, origin);
        gib.s.origin[0] = origin[0] + Lib.crandom() * size[0];
        gib.s.origin[1] = origin[1] + Lib.crandom() * size[1];
        gib.s.origin[2] = origin[2] + Lib.crandom() * size[2];
        GameBase.gi.setmodel(gib, gibname);
        gib.solid = 0;
        gib.s.effects |= 2;
        gib.flags |= 0x800;
        gib.takedamage = 1;
        gib.die = gib_die;
        if (type == 0) {
            gib.movetype = 7;
            gib.touch = gib_touch;
            vscale = 0.5f;
        } else {
            gib.movetype = 9;
            vscale = 1.0f;
        }
        GameMisc.VelocityForDamage(damage, vd);
        Math3D.VectorMA(self.velocity, vscale, vd, gib.velocity);
        GameMisc.ClipGibVelocity(gib);
        gib.avelocity[0] = Lib.random() * 600.0f;
        gib.avelocity[1] = Lib.random() * 600.0f;
        gib.avelocity[2] = Lib.random() * 600.0f;
        gib.think = GameUtil.G_FreeEdictA;
        gib.nextthink = GameBase.level.time + 10.0f + Lib.random() * 10.0f;
        GameBase.gi.linkentity(gib);
    }

    public static void ThrowHead(edict_t self, String gibname, int damage, int type) {
        float vscale;
        float[] vd = new float[]{0.0f, 0.0f, 0.0f};
        self.s.skinnum = 0;
        self.s.frame = 0;
        Math3D.VectorClear(self.mins);
        Math3D.VectorClear(self.maxs);
        self.s.modelindex2 = 0;
        GameBase.gi.setmodel(self, gibname);
        self.solid = 0;
        self.s.effects |= 2;
        self.s.effects &= 0xFFFFBFFF;
        self.s.sound = 0;
        self.flags |= 0x800;
        self.svflags &= 0xFFFFFFFB;
        self.takedamage = 1;
        self.die = gib_die;
        if (type == 0) {
            self.movetype = 7;
            self.touch = gib_touch;
            vscale = 0.5f;
        } else {
            self.movetype = 9;
            vscale = 1.0f;
        }
        GameMisc.VelocityForDamage(damage, vd);
        Math3D.VectorMA(self.velocity, vscale, vd, self.velocity);
        GameMisc.ClipGibVelocity(self);
        self.avelocity[1] = Lib.crandom() * 600.0f;
        self.think = GameUtil.G_FreeEdictA;
        self.nextthink = GameBase.level.time + 10.0f + Lib.random() * 10.0f;
        GameBase.gi.linkentity(self);
    }

    public static void ThrowClientHead(edict_t self, int damage) {
        String gibname;
        float[] vd = new float[]{0.0f, 0.0f, 0.0f};
        if ((Lib.rand() & 1) != 0) {
            gibname = "models/objects/gibs/head2/tris.md2";
            self.s.skinnum = 1;
        } else {
            gibname = "models/objects/gibs/skull/tris.md2";
            self.s.skinnum = 0;
        }
        self.s.origin[2] = self.s.origin[2] + 32.0f;
        self.s.frame = 0;
        GameBase.gi.setmodel(self, gibname);
        Math3D.VectorSet(self.mins, -16.0f, -16.0f, 0.0f);
        Math3D.VectorSet(self.maxs, 16.0f, 16.0f, 16.0f);
        self.takedamage = 0;
        self.solid = 0;
        self.s.effects = 2;
        self.s.sound = 0;
        self.flags |= 0x800;
        self.movetype = 9;
        GameMisc.VelocityForDamage(damage, vd);
        Math3D.VectorAdd(self.velocity, vd, self.velocity);
        if (self.client != null) {
            self.client.anim_priority = 5;
            self.client.anim_end = self.s.frame;
        } else {
            self.think = null;
            self.nextthink = 0.0f;
        }
        GameBase.gi.linkentity(self);
    }

    public static void ThrowDebris(edict_t self, String modelname, float speed, float[] origin) {
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        edict_t chunk = GameUtil.G_Spawn();
        Math3D.VectorCopy(origin, chunk.s.origin);
        GameBase.gi.setmodel(chunk, modelname);
        v[0] = 100.0f * Lib.crandom();
        v[1] = 100.0f * Lib.crandom();
        v[2] = 100.0f + 100.0f * Lib.crandom();
        Math3D.VectorMA(self.velocity, speed, v, chunk.velocity);
        chunk.movetype = 9;
        chunk.solid = 0;
        chunk.avelocity[0] = Lib.random() * 600.0f;
        chunk.avelocity[1] = Lib.random() * 600.0f;
        chunk.avelocity[2] = Lib.random() * 600.0f;
        chunk.think = GameUtil.G_FreeEdictA;
        chunk.nextthink = GameBase.level.time + 5.0f + Lib.random() * 5.0f;
        chunk.s.frame = 0;
        chunk.flags = 0;
        chunk.classname = "debris";
        chunk.takedamage = 1;
        chunk.die = debris_die;
        GameBase.gi.linkentity(chunk);
    }

    public static void ClipGibVelocity(edict_t ent) {
        if (ent.velocity[0] < -300.0f) {
            ent.velocity[0] = -300.0f;
        } else if (ent.velocity[0] > 300.0f) {
            ent.velocity[0] = 300.0f;
        }
        if (ent.velocity[1] < -300.0f) {
            ent.velocity[1] = -300.0f;
        } else if (ent.velocity[1] > 300.0f) {
            ent.velocity[1] = 300.0f;
        }
        if (ent.velocity[2] < 200.0f) {
            ent.velocity[2] = 200.0f;
        } else if (ent.velocity[2] > 500.0f) {
            ent.velocity[2] = 500.0f;
        }
    }
}

