/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.game.Cmd;
import jake2.game.EntInteractAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.EntTouchAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameBase;
import jake2.game.GameChase;
import jake2.game.GameItemList;
import jake2.game.GameUtil;
import jake2.game.ItemDropAdapter;
import jake2.game.ItemUseAdapter;
import jake2.game.cplane_t;
import jake2.game.csurface_t;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.game.gitem_armor_t;
import jake2.game.gitem_t;
import jake2.game.trace_t;
import jake2.qcommon.Com;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.util.StringTokenizer;

public class GameItems {
    public static gitem_armor_t jacketarmor_info = new gitem_armor_t(25, 50, 0.3f, 0.0f, 1);
    public static gitem_armor_t combatarmor_info = new gitem_armor_t(50, 100, 0.6f, 0.3f, 2);
    public static gitem_armor_t bodyarmor_info = new gitem_armor_t(100, 200, 0.8f, 0.6f, 3);
    static int quad_drop_timeout_hack = 0;
    static int jacket_armor_index;
    static int combat_armor_index;
    static int body_armor_index;
    static int power_screen_index;
    static int power_shield_index;
    static EntThinkAdapter DoRespawn;
    static EntInteractAdapter Pickup_Pack;
    static final EntInteractAdapter Pickup_Health;
    static EntTouchAdapter Touch_Item;
    static EntTouchAdapter drop_temp_touch;
    static EntThinkAdapter drop_make_touchable;
    static ItemUseAdapter Use_Quad;
    static ItemUseAdapter Use_Invulnerability;
    static ItemUseAdapter Use_Breather;
    static ItemUseAdapter Use_Envirosuit;
    static ItemUseAdapter Use_Silencer;
    static EntInteractAdapter Pickup_Key;
    public static EntInteractAdapter Pickup_Ammo;
    public static EntInteractAdapter Pickup_Armor;
    public static EntInteractAdapter Pickup_PowerArmor;
    public static EntInteractAdapter Pickup_Powerup;
    public static EntInteractAdapter Pickup_Adrenaline;
    public static EntInteractAdapter Pickup_AncientHead;
    public static EntInteractAdapter Pickup_Bandolier;
    public static ItemDropAdapter Drop_Ammo;
    public static ItemDropAdapter Drop_General;
    public static ItemDropAdapter Drop_PowerArmor;
    public static EntThinkAdapter droptofloor;
    public static ItemUseAdapter Use_PowerArmor;
    public static EntUseAdapter Use_Item;

    public static gitem_t GetItemByIndex(int index) {
        if (index == 0 || index >= GameBase.game.num_items) {
            return null;
        }
        return GameItemList.itemlist[index];
    }

    static gitem_t FindItemByClassname(String classname) {
        for (int i = 1; i < GameBase.game.num_items; ++i) {
            gitem_t it = GameItemList.itemlist[i];
            if (it.classname == null || !it.classname.equalsIgnoreCase(classname)) continue;
            return it;
        }
        return null;
    }

    static gitem_t FindItem(String pickup_name) {
        for (int i = 1; i < GameBase.game.num_items; ++i) {
            gitem_t it = GameItemList.itemlist[i];
            if (it.pickup_name == null || !it.pickup_name.equalsIgnoreCase(pickup_name)) continue;
            return it;
        }
        Com.Println("Item not found:" + pickup_name);
        return null;
    }

    static void SetRespawn(edict_t ent, float delay) {
        ent.flags |= Integer.MIN_VALUE;
        ent.svflags |= 1;
        ent.solid = 0;
        ent.nextthink = GameBase.level.time + delay;
        ent.think = DoRespawn;
        GameBase.gi.linkentity(ent);
    }

    static int ITEM_INDEX(gitem_t item) {
        return item.index;
    }

    static edict_t Drop_Item(edict_t ent, gitem_t item) {
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] offset = new float[]{0.0f, 0.0f, 0.0f};
        edict_t dropped = GameUtil.G_Spawn();
        dropped.classname = item.classname;
        dropped.item = item;
        dropped.spawnflags = 65536;
        dropped.s.effects = item.world_model_flags;
        dropped.s.renderfx = 512;
        Math3D.VectorSet(dropped.mins, -15.0f, -15.0f, -15.0f);
        Math3D.VectorSet(dropped.maxs, 15.0f, 15.0f, 15.0f);
        GameBase.gi.setmodel(dropped, dropped.item.world_model);
        dropped.solid = 1;
        dropped.movetype = 7;
        dropped.touch = drop_temp_touch;
        dropped.owner = ent;
        if (ent.client != null) {
            Math3D.AngleVectors(ent.client.v_angle, forward, right, null);
            Math3D.VectorSet(offset, 24.0f, 0.0f, -16.0f);
            Math3D.G_ProjectSource(ent.s.origin, offset, forward, right, dropped.s.origin);
            trace_t trace = GameBase.gi.trace(ent.s.origin, dropped.mins, dropped.maxs, dropped.s.origin, ent, 1);
            Math3D.VectorCopy(trace.endpos, dropped.s.origin);
        } else {
            Math3D.AngleVectors(ent.s.angles, forward, right, null);
            Math3D.VectorCopy(ent.s.origin, dropped.s.origin);
        }
        Math3D.VectorScale(forward, 100.0f, dropped.velocity);
        dropped.velocity[2] = 300.0f;
        dropped.think = drop_make_touchable;
        dropped.nextthink = GameBase.level.time + 1.0f;
        GameBase.gi.linkentity(dropped);
        return dropped;
    }

    static void Use_Item(edict_t ent, edict_t other, edict_t activator) {
        ent.svflags &= 0xFFFFFFFE;
        ent.use = null;
        if ((ent.spawnflags & 2) != 0) {
            ent.solid = 2;
            ent.touch = null;
        } else {
            ent.solid = 1;
            ent.touch = Touch_Item;
        }
        GameBase.gi.linkentity(ent);
    }

    static int PowerArmorType(edict_t ent) {
        if (ent.client == null) {
            return 0;
        }
        if (0 == (ent.flags & 0x1000)) {
            return 0;
        }
        if (ent.client.pers.inventory[power_shield_index] > 0) {
            return 2;
        }
        if (ent.client.pers.inventory[power_screen_index] > 0) {
            return 1;
        }
        return 0;
    }

    static int ArmorIndex(edict_t ent) {
        if (ent.client == null) {
            return 0;
        }
        if (ent.client.pers.inventory[jacket_armor_index] > 0) {
            return jacket_armor_index;
        }
        if (ent.client.pers.inventory[combat_armor_index] > 0) {
            return combat_armor_index;
        }
        if (ent.client.pers.inventory[body_armor_index] > 0) {
            return body_armor_index;
        }
        return 0;
    }

    public static boolean Pickup_PowerArmor(edict_t ent, edict_t other) {
        int quantity = other.client.pers.inventory[GameItems.ITEM_INDEX(ent.item)];
        int n = GameItems.ITEM_INDEX(ent.item);
        other.client.pers.inventory[n] = other.client.pers.inventory[n] + 1;
        if (GameBase.deathmatch.value != 0.0f) {
            if (0 == (ent.spawnflags & 0x10000)) {
                GameItems.SetRespawn(ent, ent.item.quantity);
            }
            if (0 == quantity) {
                ent.item.use.use(other, ent.item);
            }
        }
        return true;
    }

    public static boolean Add_Ammo(edict_t ent, gitem_t item, int count) {
        int max;
        if (null == ent.client) {
            return false;
        }
        if (item.tag == 0) {
            max = ent.client.pers.max_bullets;
        } else if (item.tag == 1) {
            max = ent.client.pers.max_shells;
        } else if (item.tag == 2) {
            max = ent.client.pers.max_rockets;
        } else if (item.tag == 3) {
            max = ent.client.pers.max_grenades;
        } else if (item.tag == 4) {
            max = ent.client.pers.max_cells;
        } else if (item.tag == 5) {
            max = ent.client.pers.max_slugs;
        } else {
            return false;
        }
        int index = GameItems.ITEM_INDEX(item);
        if (ent.client.pers.inventory[index] == max) {
            return false;
        }
        int n = index;
        ent.client.pers.inventory[n] = ent.client.pers.inventory[n] + count;
        if (ent.client.pers.inventory[index] > max) {
            ent.client.pers.inventory[index] = max;
        }
        return true;
    }

    public static void InitItems() {
        GameBase.game.num_items = GameItemList.itemlist.length - 1;
    }

    public static void SetItemNames() {
        for (int i = 1; i < GameBase.game.num_items; ++i) {
            gitem_t it = GameItemList.itemlist[i];
            GameBase.gi.configstring(1056 + i, it.pickup_name);
        }
        jacket_armor_index = GameItems.ITEM_INDEX(GameItems.FindItem("Jacket Armor"));
        combat_armor_index = GameItems.ITEM_INDEX(GameItems.FindItem("Combat Armor"));
        body_armor_index = GameItems.ITEM_INDEX(GameItems.FindItem("Body Armor"));
        power_screen_index = GameItems.ITEM_INDEX(GameItems.FindItem("Power Screen"));
        power_shield_index = GameItems.ITEM_INDEX(GameItems.FindItem("Power Shield"));
    }

    public static void SelectNextItem(edict_t ent, int itflags) {
        gclient_t cl = ent.client;
        if (cl.chase_target != null) {
            GameChase.ChaseNext(ent);
            return;
        }
        for (int i = 1; i <= 256; ++i) {
            int index = (cl.pers.selected_item + i) % 256;
            if (0 == cl.pers.inventory[index]) continue;
            gitem_t it = GameItemList.itemlist[index];
            if (it.use == null || 0 == (it.flags & itflags)) continue;
            cl.pers.selected_item = index;
            return;
        }
        cl.pers.selected_item = -1;
    }

    public static void SelectPrevItem(edict_t ent, int itflags) {
        gclient_t cl = ent.client;
        if (cl.chase_target != null) {
            GameChase.ChasePrev(ent);
            return;
        }
        for (int i = 1; i <= 256; ++i) {
            int index = (cl.pers.selected_item + 256 - i) % 256;
            if (0 == cl.pers.inventory[index]) continue;
            gitem_t it = GameItemList.itemlist[index];
            if (null == it.use || 0 == (it.flags & itflags)) continue;
            cl.pers.selected_item = index;
            return;
        }
        cl.pers.selected_item = -1;
    }

    public static void PrecacheItem(gitem_t it) {
        String s;
        gitem_t ammo;
        if (it == null) {
            return;
        }
        if (it.pickup_sound != null) {
            GameBase.gi.soundindex(it.pickup_sound);
        }
        if (it.world_model != null) {
            GameBase.gi.modelindex(it.world_model);
        }
        if (it.view_model != null) {
            GameBase.gi.modelindex(it.view_model);
        }
        if (it.icon != null) {
            GameBase.gi.imageindex(it.icon);
        }
        if (it.ammo != null && it.ammo.length() != 0 && (ammo = GameItems.FindItem(it.ammo)) != it) {
            GameItems.PrecacheItem(ammo);
        }
        if ((s = it.precaches) == null || s.length() != 0) {
            return;
        }
        StringTokenizer tk = new StringTokenizer(s);
        while (tk.hasMoreTokens()) {
            String data = tk.nextToken();
            int len = data.length();
            if (len >= 64 || len < 5) {
                GameBase.gi.error("PrecacheItem: it.classname has bad precache string: " + s);
            }
            if (data.endsWith("md2")) {
                GameBase.gi.modelindex(data);
                continue;
            }
            if (data.endsWith("sp2")) {
                GameBase.gi.modelindex(data);
                continue;
            }
            if (data.endsWith("wav")) {
                GameBase.gi.soundindex(data);
                continue;
            }
            if (data.endsWith("pcx")) {
                GameBase.gi.imageindex(data);
                continue;
            }
            GameBase.gi.error("PrecacheItem: bad precache string: " + data);
        }
    }

    public static void SpawnItem(edict_t ent, gitem_t item) {
        GameItems.PrecacheItem(item);
        if (ent.spawnflags != 0 && Lib.strcmp(ent.classname, "key_power_cube") != 0) {
            ent.spawnflags = 0;
            GameBase.gi.dprintf("" + ent.classname + " at " + Lib.vtos(ent.s.origin) + " has invalid spawnflags set\n");
        }
        if (GameBase.deathmatch.value != 0.0f) {
            if (((int)GameBase.dmflags.value & 0x800) != 0 && (item.pickup == Pickup_Armor || item.pickup == Pickup_PowerArmor)) {
                GameUtil.G_FreeEdict(ent);
                return;
            }
            if (((int)GameBase.dmflags.value & 2) != 0 && item.pickup == Pickup_Powerup) {
                GameUtil.G_FreeEdict(ent);
                return;
            }
            if (((int)GameBase.dmflags.value & 1) != 0 && (item.pickup == Pickup_Health || item.pickup == Pickup_Adrenaline || item.pickup == Pickup_AncientHead)) {
                GameUtil.G_FreeEdict(ent);
                return;
            }
            if (((int)GameBase.dmflags.value & 0x2000) != 0 && (item.flags == 2 || Lib.strcmp(ent.classname, "weapon_bfg") == 0)) {
                GameUtil.G_FreeEdict(ent);
                return;
            }
        }
        if (GameBase.coop.value != 0.0f && Lib.strcmp(ent.classname, "key_power_cube") == 0) {
            ent.spawnflags |= 1 << 8 + GameBase.level.power_cubes;
            ++GameBase.level.power_cubes;
        }
        if (GameBase.coop.value != 0.0f && (item.flags & 8) != 0) {
            item.drop = null;
        }
        ent.item = item;
        ent.nextthink = GameBase.level.time + 0.2f;
        ent.think = droptofloor;
        ent.s.effects = item.world_model_flags;
        ent.s.renderfx = 512;
        if (ent.model != null) {
            GameBase.gi.modelindex(ent.model);
        }
    }

    public static void SP_item_health(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f && ((int)GameBase.dmflags.value & 1) != 0) {
            GameUtil.G_FreeEdict(self);
        }
        self.model = "models/items/healing/medium/tris.md2";
        self.count = 10;
        GameItems.SpawnItem(self, GameItems.FindItem("Health"));
        GameBase.gi.soundindex("items/n_health.wav");
    }

    static void SP_item_health_small(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f && ((int)GameBase.dmflags.value & 1) != 0) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.model = "models/items/healing/stimpack/tris.md2";
        self.count = 2;
        GameItems.SpawnItem(self, GameItems.FindItem("Health"));
        self.style = 1;
        GameBase.gi.soundindex("items/s_health.wav");
    }

    static void SP_item_health_large(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f && ((int)GameBase.dmflags.value & 1) != 0) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.model = "models/items/healing/large/tris.md2";
        self.count = 25;
        GameItems.SpawnItem(self, GameItems.FindItem("Health"));
        GameBase.gi.soundindex("items/l_health.wav");
    }

    static void SP_item_health_mega(edict_t self) {
        if (GameBase.deathmatch.value != 0.0f && ((int)GameBase.dmflags.value & 1) != 0) {
            GameUtil.G_FreeEdict(self);
            return;
        }
        self.model = "models/items/mega_h/tris.md2";
        self.count = 100;
        GameItems.SpawnItem(self, GameItems.FindItem("Health"));
        GameBase.gi.soundindex("items/m_health.wav");
        self.style = 3;
    }

    public static void Touch_Item(edict_t ent, edict_t other, cplane_t plane, csurface_t surf) {
        if (other.client == null || ent.item == null) {
            return;
        }
        if (other.health < 1) {
            return;
        }
        if (ent.item.pickup == null) {
            return;
        }
        boolean taken = ent.item.pickup.interact(ent, other);
        if (taken) {
            other.client.bonus_alpha = 0.25f;
            other.client.ps.stats[7] = (short)GameBase.gi.imageindex(ent.item.icon);
            other.client.ps.stats[8] = (short)(1056 + GameItems.ITEM_INDEX(ent.item));
            other.client.pickup_msg_time = GameBase.level.time + 3.0f;
            if (ent.item.use != null) {
                other.client.ps.stats[12] = (short)GameItems.ITEM_INDEX(ent.item);
                other.client.pers.selected_item = other.client.ps.stats[12];
            }
            if (ent.item.pickup == Pickup_Health) {
                if (ent.count == 2) {
                    GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/s_health.wav"), 1.0f, 1.0f, 0.0f);
                } else if (ent.count == 10) {
                    GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/n_health.wav"), 1.0f, 1.0f, 0.0f);
                } else if (ent.count == 25) {
                    GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/l_health.wav"), 1.0f, 1.0f, 0.0f);
                } else {
                    GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/m_health.wav"), 1.0f, 1.0f, 0.0f);
                }
            } else if (ent.item.pickup_sound != null) {
                GameBase.gi.sound(other, 3, GameBase.gi.soundindex(ent.item.pickup_sound), 1.0f, 1.0f, 0.0f);
            }
        }
        if (0 == (ent.spawnflags & 0x40000)) {
            GameUtil.G_UseTargets(ent, other);
            ent.spawnflags |= 0x40000;
        }
        if (!taken) {
            return;
        }
        if (GameBase.coop.value == 0.0f || (ent.item.flags & 8) == 0 || 0 != (ent.spawnflags & 0x30000)) {
            if ((ent.flags & Integer.MIN_VALUE) != 0) {
                ent.flags &= Integer.MAX_VALUE;
            } else {
                GameUtil.G_FreeEdict(ent);
            }
        }
    }

    static {
        DoRespawn = new EntThinkAdapter(){

            public String getID() {
                return "do_respawn";
            }

            public boolean think(edict_t ent) {
                if (ent.team != null) {
                    int choice = 0;
                    edict_t master = ent.teammaster;
                    int count = 0;
                    ent = master;
                    while (ent != null) {
                        ent = ent.chain;
                        ++count;
                    }
                    choice = Lib.rand() % count;
                    ent = master;
                    for (count = 0; count < choice; ++count) {
                        ent = ent.chain;
                    }
                }
                ent.svflags &= 0xFFFFFFFE;
                ent.solid = 1;
                GameBase.gi.linkentity(ent);
                ent.s.event = 1;
                return false;
            }
        };
        Pickup_Pack = new EntInteractAdapter(){

            public String getID() {
                return "pickup_pack";
            }

            public boolean interact(edict_t ent, edict_t other) {
                int index;
                gitem_t item;
                if (other.client.pers.max_bullets < 300) {
                    other.client.pers.max_bullets = 300;
                }
                if (other.client.pers.max_shells < 200) {
                    other.client.pers.max_shells = 200;
                }
                if (other.client.pers.max_rockets < 100) {
                    other.client.pers.max_rockets = 100;
                }
                if (other.client.pers.max_grenades < 100) {
                    other.client.pers.max_grenades = 100;
                }
                if (other.client.pers.max_cells < 300) {
                    other.client.pers.max_cells = 300;
                }
                if (other.client.pers.max_slugs < 100) {
                    other.client.pers.max_slugs = 100;
                }
                if ((item = GameItems.FindItem("Bullets")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_bullets) {
                        other.client.pers.inventory[index] = other.client.pers.max_bullets;
                    }
                }
                if ((item = GameItems.FindItem("Shells")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_shells) {
                        other.client.pers.inventory[index] = other.client.pers.max_shells;
                    }
                }
                if ((item = GameItems.FindItem("Cells")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_cells) {
                        other.client.pers.inventory[index] = other.client.pers.max_cells;
                    }
                }
                if ((item = GameItems.FindItem("Grenades")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_grenades) {
                        other.client.pers.inventory[index] = other.client.pers.max_grenades;
                    }
                }
                if ((item = GameItems.FindItem("Rockets")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_rockets) {
                        other.client.pers.inventory[index] = other.client.pers.max_rockets;
                    }
                }
                if ((item = GameItems.FindItem("Slugs")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_slugs) {
                        other.client.pers.inventory[index] = other.client.pers.max_slugs;
                    }
                }
                if (0 == (ent.spawnflags & 0x10000) && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, ent.item.quantity);
                }
                return true;
            }
        };
        Pickup_Health = new EntInteractAdapter(){

            public String getID() {
                return "pickup_health";
            }

            public boolean interact(edict_t ent, edict_t other) {
                if (0 == (ent.style & 1) && other.health >= other.max_health) {
                    return false;
                }
                other.health += ent.count;
                if (0 == (ent.style & 1) && other.health > other.max_health) {
                    other.health = other.max_health;
                }
                if (0 != (ent.style & 2)) {
                    ent.think = GameUtil.MegaHealth_think;
                    ent.nextthink = GameBase.level.time + 5.0f;
                    ent.owner = other;
                    ent.flags |= Integer.MIN_VALUE;
                    ent.svflags |= 1;
                    ent.solid = 0;
                } else if ((ent.spawnflags & 0x10000) == 0 && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, 30.0f);
                }
                return true;
            }
        };
        Touch_Item = new EntTouchAdapter(){

            public String getID() {
                return "touch_item";
            }

            public void touch(edict_t ent, edict_t other, cplane_t plane, csurface_t surf) {
                if (ent.classname.equals("item_breather")) {
                    boolean bl = false;
                }
                if (other.client == null) {
                    return;
                }
                if (other.health < 1) {
                    return;
                }
                if (ent.item.pickup == null) {
                    return;
                }
                boolean taken = ent.item.pickup.interact(ent, other);
                if (taken) {
                    other.client.bonus_alpha = 0.25f;
                    other.client.ps.stats[7] = (short)GameBase.gi.imageindex(ent.item.icon);
                    other.client.ps.stats[8] = (short)(1056 + GameItems.ITEM_INDEX(ent.item));
                    other.client.pickup_msg_time = GameBase.level.time + 3.0f;
                    if (ent.item.use != null) {
                        other.client.ps.stats[12] = (short)GameItems.ITEM_INDEX(ent.item);
                        other.client.pers.selected_item = other.client.ps.stats[12];
                    }
                    if (ent.item.pickup == Pickup_Health) {
                        if (ent.count == 2) {
                            GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/s_health.wav"), 1.0f, 1.0f, 0.0f);
                        } else if (ent.count == 10) {
                            GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/n_health.wav"), 1.0f, 1.0f, 0.0f);
                        } else if (ent.count == 25) {
                            GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/l_health.wav"), 1.0f, 1.0f, 0.0f);
                        } else {
                            GameBase.gi.sound(other, 3, GameBase.gi.soundindex("items/m_health.wav"), 1.0f, 1.0f, 0.0f);
                        }
                    } else if (ent.item.pickup_sound != null) {
                        GameBase.gi.sound(other, 3, GameBase.gi.soundindex(ent.item.pickup_sound), 1.0f, 1.0f, 0.0f);
                    }
                }
                if (0 == (ent.spawnflags & 0x40000)) {
                    GameUtil.G_UseTargets(ent, other);
                    ent.spawnflags |= 0x40000;
                }
                if (!taken) {
                    return;
                }
                Com.dprintln("Picked up:" + ent.classname);
                if (GameBase.coop.value == 0.0f || (ent.item.flags & 8) == 0 || 0 != (ent.spawnflags & 0x30000)) {
                    if ((ent.flags & Integer.MIN_VALUE) != 0) {
                        ent.flags &= Integer.MAX_VALUE;
                    } else {
                        GameUtil.G_FreeEdict(ent);
                    }
                }
            }
        };
        drop_temp_touch = new EntTouchAdapter(){

            public String getID() {
                return "drop_temp_touch";
            }

            public void touch(edict_t ent, edict_t other, cplane_t plane, csurface_t surf) {
                if (other == ent.owner) {
                    return;
                }
                Touch_Item.touch(ent, other, plane, surf);
            }
        };
        drop_make_touchable = new EntThinkAdapter(){

            public String getID() {
                return "drop_make_touchable";
            }

            public boolean think(edict_t ent) {
                ent.touch = Touch_Item;
                if (GameBase.deathmatch.value != 0.0f) {
                    ent.nextthink = GameBase.level.time + 29.0f;
                    ent.think = GameUtil.G_FreeEdictA;
                }
                return false;
            }
        };
        Use_Quad = new ItemUseAdapter(){

            public String getID() {
                return "use_quad";
            }

            public void use(edict_t ent, gitem_t item) {
                int timeout;
                int n = GameItems.ITEM_INDEX(item);
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                GameUtil.ValidateSelectedItem(ent);
                if (quad_drop_timeout_hack != 0) {
                    timeout = quad_drop_timeout_hack;
                    quad_drop_timeout_hack = 0;
                } else {
                    timeout = 300;
                }
                ent.client.quad_framenum = ent.client.quad_framenum > (float)GameBase.level.framenum ? (ent.client.quad_framenum += (float)timeout) : (float)(GameBase.level.framenum + timeout);
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/damage.wav"), 1.0f, 1.0f, 0.0f);
            }
        };
        Use_Invulnerability = new ItemUseAdapter(){

            public String getID() {
                return "use_invulnerability";
            }

            public void use(edict_t ent, gitem_t item) {
                int n = GameItems.ITEM_INDEX(item);
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                GameUtil.ValidateSelectedItem(ent);
                ent.client.invincible_framenum = ent.client.invincible_framenum > (float)GameBase.level.framenum ? (ent.client.invincible_framenum += 300.0f) : (float)(GameBase.level.framenum + 300);
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/protect.wav"), 1.0f, 1.0f, 0.0f);
            }
        };
        Use_Breather = new ItemUseAdapter(){

            public String getID() {
                return "use_breather";
            }

            public void use(edict_t ent, gitem_t item) {
                int n = GameItems.ITEM_INDEX(item);
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                GameUtil.ValidateSelectedItem(ent);
                ent.client.breather_framenum = ent.client.breather_framenum > (float)GameBase.level.framenum ? (ent.client.breather_framenum += 300.0f) : (float)(GameBase.level.framenum + 300);
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/damage.wav"), 1.0f, 1.0f, 0.0f);
            }
        };
        Use_Envirosuit = new ItemUseAdapter(){

            public String getID() {
                return "use_envirosuit";
            }

            public void use(edict_t ent, gitem_t item) {
                int n = GameItems.ITEM_INDEX(item);
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                GameUtil.ValidateSelectedItem(ent);
                ent.client.enviro_framenum = ent.client.enviro_framenum > (float)GameBase.level.framenum ? (ent.client.enviro_framenum += 300.0f) : (float)(GameBase.level.framenum + 300);
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/damage.wav"), 1.0f, 1.0f, 0.0f);
            }
        };
        Use_Silencer = new ItemUseAdapter(){

            public String getID() {
                return "use_silencer";
            }

            public void use(edict_t ent, gitem_t item) {
                int n = GameItems.ITEM_INDEX(item);
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                GameUtil.ValidateSelectedItem(ent);
                ent.client.silencer_shots += 30;
                GameBase.gi.sound(ent, 3, GameBase.gi.soundindex("items/damage.wav"), 1.0f, 1.0f, 0.0f);
            }
        };
        Pickup_Key = new EntInteractAdapter(){

            public String getID() {
                return "pickup_key";
            }

            public boolean interact(edict_t ent, edict_t other) {
                if (GameBase.coop.value != 0.0f) {
                    if (Lib.strcmp(ent.classname, "key_power_cube") == 0) {
                        if ((other.client.pers.power_cubes & (ent.spawnflags & 0xFF00) >> 8) != 0) {
                            return false;
                        }
                        int n = GameItems.ITEM_INDEX(ent.item);
                        other.client.pers.inventory[n] = other.client.pers.inventory[n] + 1;
                        other.client.pers.power_cubes |= (ent.spawnflags & 0xFF00) >> 8;
                    } else {
                        if (other.client.pers.inventory[GameItems.ITEM_INDEX(ent.item)] != 0) {
                            return false;
                        }
                        other.client.pers.inventory[GameItems.ITEM_INDEX((gitem_t)ent.item)] = 1;
                    }
                    return true;
                }
                int n = GameItems.ITEM_INDEX(ent.item);
                other.client.pers.inventory[n] = other.client.pers.inventory[n] + 1;
                return true;
            }
        };
        Pickup_Ammo = new EntInteractAdapter(){

            public String getID() {
                return "pickup_ammo";
            }

            public boolean interact(edict_t ent, edict_t other) {
                boolean weapon;
                boolean bl = weapon = (ent.item.flags & 1) != 0;
                int count = weapon && ((int)GameBase.dmflags.value & 0x2000) != 0 ? 1000 : (ent.count != 0 ? ent.count : ent.item.quantity);
                int oldcount = other.client.pers.inventory[GameItems.ITEM_INDEX(ent.item)];
                if (!GameItems.Add_Ammo(other, ent.item, count)) {
                    return false;
                }
                if (weapon && 0 == oldcount && other.client.pers.weapon != ent.item && (0.0f == GameBase.deathmatch.value || other.client.pers.weapon == GameItems.FindItem("blaster"))) {
                    other.client.newweapon = ent.item;
                }
                if (0 == (ent.spawnflags & 0x30000) && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, 30.0f);
                }
                return true;
            }
        };
        Pickup_Armor = new EntInteractAdapter(){

            public String getID() {
                return "pickup_armor";
            }

            public boolean interact(edict_t ent, edict_t other) {
                gitem_armor_t newinfo = ent.item.info;
                int old_armor_index = GameItems.ArmorIndex(other);
                if (ent.item.tag == 4) {
                    if (0 == old_armor_index) {
                        other.client.pers.inventory[GameItems.jacket_armor_index] = 2;
                    } else {
                        int n = old_armor_index;
                        other.client.pers.inventory[n] = other.client.pers.inventory[n] + 2;
                    }
                } else if (0 == old_armor_index) {
                    other.client.pers.inventory[GameItems.ITEM_INDEX((gitem_t)ent.item)] = newinfo.base_count;
                } else {
                    gitem_armor_t oldinfo = old_armor_index == jacket_armor_index ? jacketarmor_info : (old_armor_index == combat_armor_index ? combatarmor_info : bodyarmor_info);
                    if (newinfo.normal_protection > oldinfo.normal_protection) {
                        float salvage = oldinfo.normal_protection / newinfo.normal_protection;
                        int salvagecount = (int)salvage * other.client.pers.inventory[old_armor_index];
                        int newcount = newinfo.base_count + salvagecount;
                        if (newcount > newinfo.max_count) {
                            newcount = newinfo.max_count;
                        }
                        other.client.pers.inventory[old_armor_index] = 0;
                        other.client.pers.inventory[GameItems.ITEM_INDEX((gitem_t)ent.item)] = newcount;
                    } else {
                        float salvage = newinfo.normal_protection / oldinfo.normal_protection;
                        int salvagecount = (int)salvage * newinfo.base_count;
                        int newcount = other.client.pers.inventory[old_armor_index] + salvagecount;
                        if (newcount > oldinfo.max_count) {
                            newcount = oldinfo.max_count;
                        }
                        if (other.client.pers.inventory[old_armor_index] >= newcount) {
                            return false;
                        }
                        other.client.pers.inventory[old_armor_index] = newcount;
                    }
                }
                if (0 == (ent.spawnflags & 0x10000) && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, 20.0f);
                }
                return true;
            }
        };
        Pickup_PowerArmor = new EntInteractAdapter(){

            public String getID() {
                return "pickup_powerarmor";
            }

            public boolean interact(edict_t ent, edict_t other) {
                int quantity = other.client.pers.inventory[GameItems.ITEM_INDEX(ent.item)];
                int n = GameItems.ITEM_INDEX(ent.item);
                other.client.pers.inventory[n] = other.client.pers.inventory[n] + 1;
                if (GameBase.deathmatch.value != 0.0f) {
                    if (0 == (ent.spawnflags & 0x10000)) {
                        GameItems.SetRespawn(ent, ent.item.quantity);
                    }
                    if (0 == quantity) {
                        ent.item.use.use(other, ent.item);
                    }
                }
                return true;
            }
        };
        Pickup_Powerup = new EntInteractAdapter(){

            public String getID() {
                return "pickup_powerup";
            }

            public boolean interact(edict_t ent, edict_t other) {
                int quantity = other.client.pers.inventory[GameItems.ITEM_INDEX(ent.item)];
                if (GameBase.skill.value == 1.0f && quantity >= 2 || GameBase.skill.value >= 2.0f && quantity >= 1) {
                    return false;
                }
                if (GameBase.coop.value != 0.0f && (ent.item.flags & 8) != 0 && quantity > 0) {
                    return false;
                }
                int n = GameItems.ITEM_INDEX(ent.item);
                other.client.pers.inventory[n] = other.client.pers.inventory[n] + 1;
                if (GameBase.deathmatch.value != 0.0f) {
                    if (0 == (ent.spawnflags & 0x10000)) {
                        GameItems.SetRespawn(ent, ent.item.quantity);
                    }
                    if (((int)GameBase.dmflags.value & 0x10) != 0 || ent.item.use == Use_Quad && 0 != (ent.spawnflags & 0x20000)) {
                        if (ent.item.use == Use_Quad && 0 != (ent.spawnflags & 0x20000)) {
                            quad_drop_timeout_hack = (int)((ent.nextthink - GameBase.level.time) / 0.1f);
                        }
                        ent.item.use.use(other, ent.item);
                    }
                }
                return true;
            }
        };
        Pickup_Adrenaline = new EntInteractAdapter(){

            public String getID() {
                return "pickup_adrenaline";
            }

            public boolean interact(edict_t ent, edict_t other) {
                if (GameBase.deathmatch.value == 0.0f) {
                    ++other.max_health;
                }
                if (other.health < other.max_health) {
                    other.health = other.max_health;
                }
                if (0 == (ent.spawnflags & 0x10000) && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, ent.item.quantity);
                }
                return true;
            }
        };
        Pickup_AncientHead = new EntInteractAdapter(){

            public String getID() {
                return "pickup_ancienthead";
            }

            public boolean interact(edict_t ent, edict_t other) {
                other.max_health += 2;
                if (0 == (ent.spawnflags & 0x10000) && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, ent.item.quantity);
                }
                return true;
            }
        };
        Pickup_Bandolier = new EntInteractAdapter(){

            public String getID() {
                return "pickup_bandolier";
            }

            public boolean interact(edict_t ent, edict_t other) {
                int index;
                gitem_t item;
                if (other.client.pers.max_bullets < 250) {
                    other.client.pers.max_bullets = 250;
                }
                if (other.client.pers.max_shells < 150) {
                    other.client.pers.max_shells = 150;
                }
                if (other.client.pers.max_cells < 250) {
                    other.client.pers.max_cells = 250;
                }
                if (other.client.pers.max_slugs < 75) {
                    other.client.pers.max_slugs = 75;
                }
                if ((item = GameItems.FindItem("Bullets")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_bullets) {
                        other.client.pers.inventory[index] = other.client.pers.max_bullets;
                    }
                }
                if ((item = GameItems.FindItem("Shells")) != null) {
                    int n = index = GameItems.ITEM_INDEX(item);
                    other.client.pers.inventory[n] = other.client.pers.inventory[n] + item.quantity;
                    if (other.client.pers.inventory[index] > other.client.pers.max_shells) {
                        other.client.pers.inventory[index] = other.client.pers.max_shells;
                    }
                }
                if (0 == (ent.spawnflags & 0x10000) && GameBase.deathmatch.value != 0.0f) {
                    GameItems.SetRespawn(ent, ent.item.quantity);
                }
                return true;
            }
        };
        Drop_Ammo = new ItemDropAdapter(){

            public String getID() {
                return "drop_ammo";
            }

            public void drop(edict_t ent, gitem_t item) {
                int index = GameItems.ITEM_INDEX(item);
                edict_t dropped = GameItems.Drop_Item(ent, item);
                dropped.count = ent.client.pers.inventory[index] >= item.quantity ? item.quantity : ent.client.pers.inventory[index];
                if (ent.client.pers.weapon != null && ent.client.pers.weapon.tag == 3 && item.tag == 3 && ent.client.pers.inventory[index] - dropped.count <= 0) {
                    GameBase.gi.cprintf(ent, 2, "Can't drop current weapon\n");
                    GameUtil.G_FreeEdict(dropped);
                    return;
                }
                int n = index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - dropped.count;
                Cmd.ValidateSelectedItem(ent);
            }
        };
        Drop_General = new ItemDropAdapter(){

            public String getID() {
                return "drop_general";
            }

            public void drop(edict_t ent, gitem_t item) {
                GameItems.Drop_Item(ent, item);
                int n = GameItems.ITEM_INDEX(item);
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] - 1;
                Cmd.ValidateSelectedItem(ent);
            }
        };
        Drop_PowerArmor = new ItemDropAdapter(){

            public String getID() {
                return "drop_powerarmor";
            }

            public void drop(edict_t ent, gitem_t item) {
                if (0 != (ent.flags & 0x1000) && ent.client.pers.inventory[GameItems.ITEM_INDEX(item)] == 1) {
                    Use_PowerArmor.use(ent, item);
                }
                Drop_General.drop(ent, item);
            }
        };
        droptofloor = new EntThinkAdapter(){

            public String getID() {
                return "drop_to_floor";
            }

            public boolean think(edict_t ent) {
                float[] dest = new float[]{0.0f, 0.0f, 0.0f};
                ent.mins[2] = -15.0f;
                ent.mins[1] = -15.0f;
                ent.mins[0] = -15.0f;
                ent.maxs[2] = 15.0f;
                ent.maxs[1] = 15.0f;
                ent.maxs[0] = 15.0f;
                if (ent.model != null) {
                    GameBase.gi.setmodel(ent, ent.model);
                } else {
                    GameBase.gi.setmodel(ent, ent.item.world_model);
                }
                ent.solid = 1;
                ent.movetype = 7;
                ent.touch = Touch_Item;
                float[] v = new float[]{0.0f, 0.0f, -128.0f};
                Math3D.VectorAdd(ent.s.origin, v, dest);
                trace_t tr = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, dest, ent, 3);
                if (tr.startsolid) {
                    GameBase.gi.dprintf("droptofloor: " + ent.classname + " startsolid at " + Lib.vtos(ent.s.origin) + "\n");
                    GameUtil.G_FreeEdict(ent);
                    return true;
                }
                Math3D.VectorCopy(tr.endpos, ent.s.origin);
                if (ent.team != null) {
                    ent.flags &= 0xFFFFFBFF;
                    ent.chain = ent.teamchain;
                    ent.teamchain = null;
                    ent.svflags |= 1;
                    ent.solid = 0;
                    if (ent == ent.teammaster) {
                        ent.nextthink = GameBase.level.time + 0.1f;
                        ent.think = DoRespawn;
                    }
                }
                if ((ent.spawnflags & 2) != 0) {
                    ent.solid = 2;
                    ent.touch = null;
                    ent.s.effects &= 0xFFFFFFFE;
                    ent.s.renderfx &= 0xFFFFFDFF;
                }
                if ((ent.spawnflags & 1) != 0) {
                    ent.svflags |= 1;
                    ent.solid = 0;
                    ent.use = Use_Item;
                }
                GameBase.gi.linkentity(ent);
                return true;
            }
        };
        Use_PowerArmor = new ItemUseAdapter(){

            public String getID() {
                return "use_powerarmor";
            }

            public void use(edict_t ent, gitem_t item) {
                if ((ent.flags & 0x1000) != 0) {
                    ent.flags &= 0xFFFFEFFF;
                    GameBase.gi.sound(ent, 0, GameBase.gi.soundindex("misc/power2.wav"), 1.0f, 1.0f, 0.0f);
                } else {
                    int index = GameItems.ITEM_INDEX(GameItems.FindItem("cells"));
                    if (0 == ent.client.pers.inventory[index]) {
                        GameBase.gi.cprintf(ent, 2, "No cells for power armor.\n");
                        return;
                    }
                    ent.flags |= 0x1000;
                    GameBase.gi.sound(ent, 0, GameBase.gi.soundindex("misc/power1.wav"), 1.0f, 1.0f, 0.0f);
                }
            }
        };
        Use_Item = new EntUseAdapter(){

            public String getID() {
                return "use_item";
            }

            public void use(edict_t ent, edict_t other, edict_t activator) {
                ent.svflags &= 0xFFFFFFFE;
                ent.use = null;
                if ((ent.spawnflags & 2) != 0) {
                    ent.solid = 2;
                    ent.touch = null;
                } else {
                    ent.solid = 1;
                    ent.touch = Touch_Item;
                }
                GameBase.gi.linkentity(ent);
            }
        };
    }
}

