/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EdictIterator;
import jake2.game.EntBlockedAdapter;
import jake2.game.EntDieAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.EntTouchAdapter;
import jake2.game.EntUseAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.GameMisc;
import jake2.game.GameUtil;
import jake2.game.cplane_t;
import jake2.game.csurface_t;
import jake2.game.edict_t;
import jake2.game.moveinfo_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameFunc {
    public static final int PLAT_LOW_TRIGGER = 1;
    public static final int STATE_TOP = 0;
    public static final int STATE_BOTTOM = 1;
    public static final int STATE_UP = 2;
    public static final int STATE_DOWN = 3;
    public static final int DOOR_START_OPEN = 1;
    public static final int DOOR_REVERSE = 2;
    public static final int DOOR_CRUSHER = 4;
    public static final int DOOR_NOMONSTER = 8;
    public static final int DOOR_TOGGLE = 32;
    public static final int DOOR_X_AXIS = 64;
    public static final int DOOR_Y_AXIS = 128;
    static EntThinkAdapter Move_Done = new EntThinkAdapter(){

        public String getID() {
            return "move_done";
        }

        public boolean think(edict_t ent) {
            Math3D.VectorClear(ent.velocity);
            ent.moveinfo.endfunc.think(ent);
            return true;
        }
    };
    static EntThinkAdapter Move_Final = new EntThinkAdapter(){

        public String getID() {
            return "move_final";
        }

        public boolean think(edict_t ent) {
            if (ent.moveinfo.remaining_distance == 0.0f) {
                Move_Done.think(ent);
                return true;
            }
            Math3D.VectorScale(ent.moveinfo.dir, ent.moveinfo.remaining_distance / 0.1f, ent.velocity);
            ent.think = Move_Done;
            ent.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };
    static EntThinkAdapter Move_Begin = new EntThinkAdapter(){

        public String getID() {
            return "move_begin";
        }

        public boolean think(edict_t ent) {
            if (ent.moveinfo.speed * 0.1f >= ent.moveinfo.remaining_distance) {
                Move_Final.think(ent);
                return true;
            }
            Math3D.VectorScale(ent.moveinfo.dir, ent.moveinfo.speed, ent.velocity);
            float frames = (float)Math.floor(ent.moveinfo.remaining_distance / ent.moveinfo.speed / 0.1f);
            ent.moveinfo.remaining_distance -= frames * ent.moveinfo.speed * 0.1f;
            ent.nextthink = GameBase.level.time + frames * 0.1f;
            ent.think = Move_Final;
            return true;
        }
    };
    static EntThinkAdapter AngleMove_Done = new EntThinkAdapter(){

        public String getID() {
            return "agnle_move_done";
        }

        public boolean think(edict_t ent) {
            Math3D.VectorClear(ent.avelocity);
            ent.moveinfo.endfunc.think(ent);
            return true;
        }
    };
    static EntThinkAdapter AngleMove_Final = new EntThinkAdapter(){

        public String getID() {
            return "angle_move_final";
        }

        public boolean think(edict_t ent) {
            float[] move = new float[]{0.0f, 0.0f, 0.0f};
            if (ent.moveinfo.state == 2) {
                Math3D.VectorSubtract(ent.moveinfo.end_angles, ent.s.angles, move);
            } else {
                Math3D.VectorSubtract(ent.moveinfo.start_angles, ent.s.angles, move);
            }
            if (Math3D.VectorEquals(move, Globals.vec3_origin)) {
                AngleMove_Done.think(ent);
                return true;
            }
            Math3D.VectorScale(move, 10.0f, ent.avelocity);
            ent.think = AngleMove_Done;
            ent.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };
    static EntThinkAdapter AngleMove_Begin = new EntThinkAdapter(){

        public String getID() {
            return "angle_move_begin";
        }

        public boolean think(edict_t ent) {
            float[] destdelta = new float[]{0.0f, 0.0f, 0.0f};
            if (ent.moveinfo.state == 2) {
                Math3D.VectorSubtract(ent.moveinfo.end_angles, ent.s.angles, destdelta);
            } else {
                Math3D.VectorSubtract(ent.moveinfo.start_angles, ent.s.angles, destdelta);
            }
            float len = Math3D.VectorLength(destdelta);
            float traveltime = len / ent.moveinfo.speed;
            if (traveltime < 0.1f) {
                AngleMove_Final.think(ent);
                return true;
            }
            float frames = (float)Math.floor(traveltime / 0.1f);
            Math3D.VectorScale(destdelta, 1.0f / traveltime, ent.avelocity);
            ent.nextthink = GameBase.level.time + frames * 0.1f;
            ent.think = AngleMove_Final;
            return true;
        }
    };
    static EntThinkAdapter Think_AccelMove = new EntThinkAdapter(){

        public String getID() {
            return "thinc_accelmove";
        }

        public boolean think(edict_t ent) {
            ent.moveinfo.remaining_distance -= ent.moveinfo.current_speed;
            if (ent.moveinfo.current_speed == 0.0f) {
                GameFunc.plat_CalcAcceleratedMove(ent.moveinfo);
            }
            GameFunc.plat_Accelerate(ent.moveinfo);
            if (ent.moveinfo.remaining_distance <= ent.moveinfo.current_speed) {
                Move_Final.think(ent);
                return true;
            }
            Math3D.VectorScale(ent.moveinfo.dir, ent.moveinfo.current_speed * 10.0f, ent.velocity);
            ent.nextthink = GameBase.level.time + 0.1f;
            ent.think = Think_AccelMove;
            return true;
        }
    };
    static EntThinkAdapter plat_hit_top = new EntThinkAdapter(){

        public String getID() {
            return "plat_hit_top";
        }

        public boolean think(edict_t ent) {
            if (0 == (ent.flags & 0x400)) {
                if (ent.moveinfo.sound_end != 0) {
                    GameBase.gi.sound(ent, 10, ent.moveinfo.sound_end, 1.0f, 3.0f, 0.0f);
                }
                ent.s.sound = 0;
            }
            ent.moveinfo.state = 0;
            ent.think = plat_go_down;
            ent.nextthink = GameBase.level.time + 3.0f;
            return true;
        }
    };
    static EntThinkAdapter plat_hit_bottom = new EntThinkAdapter(){

        public String getID() {
            return "plat_hit_bottom";
        }

        public boolean think(edict_t ent) {
            if (0 == (ent.flags & 0x400)) {
                if (ent.moveinfo.sound_end != 0) {
                    GameBase.gi.sound(ent, 10, ent.moveinfo.sound_end, 1.0f, 3.0f, 0.0f);
                }
                ent.s.sound = 0;
            }
            ent.moveinfo.state = 1;
            return true;
        }
    };
    static EntThinkAdapter plat_go_down = new EntThinkAdapter(){

        public String getID() {
            return "plat_go_down";
        }

        public boolean think(edict_t ent) {
            if (0 == (ent.flags & 0x400)) {
                if (ent.moveinfo.sound_start != 0) {
                    GameBase.gi.sound(ent, 10, ent.moveinfo.sound_start, 1.0f, 3.0f, 0.0f);
                }
                ent.s.sound = ent.moveinfo.sound_middle;
            }
            ent.moveinfo.state = 3;
            GameFunc.Move_Calc(ent, ent.moveinfo.end_origin, plat_hit_bottom);
            return true;
        }
    };
    static EntBlockedAdapter plat_blocked = new EntBlockedAdapter(){

        public String getID() {
            return "plat_blocked";
        }

        public void blocked(edict_t self, edict_t other) {
            if (0 == (other.svflags & 4) && null == other.client) {
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, 100000, 1, 0, 20);
                if (other != null) {
                    GameMisc.BecomeExplosion1(other);
                }
                return;
            }
            GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
            if (self.moveinfo.state == 2) {
                plat_go_down.think(self);
            } else if (self.moveinfo.state == 3) {
                GameFunc.plat_go_up(self);
            }
        }
    };
    static EntUseAdapter Use_Plat = new EntUseAdapter(){

        public String getID() {
            return "use_plat";
        }

        public void use(edict_t ent, edict_t other, edict_t activator) {
            if (ent.think != null) {
                return;
            }
            plat_go_down.think(ent);
        }
    };
    static EntTouchAdapter Touch_Plat_Center = new EntTouchAdapter(){

        public String getID() {
            return "touch_plat_center";
        }

        public void touch(edict_t ent, edict_t other, cplane_t plane, csurface_t surf) {
            if (other.client == null) {
                return;
            }
            if (other.health <= 0) {
                return;
            }
            ent = ent.enemy;
            if (ent.moveinfo.state == 1) {
                GameFunc.plat_go_up(ent);
            } else if (ent.moveinfo.state == 0) {
                ent.nextthink = GameBase.level.time + 1.0f;
            }
        }
    };
    static EntBlockedAdapter rotating_blocked = new EntBlockedAdapter(){

        public String getID() {
            return "rotating_blocked";
        }

        public void blocked(edict_t self, edict_t other) {
            GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
        }
    };
    static EntTouchAdapter rotating_touch = new EntTouchAdapter(){

        public String getID() {
            return "rotating_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (self.avelocity[0] != 0.0f || self.avelocity[1] != 0.0f || self.avelocity[2] != 0.0f) {
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
            }
        }
    };
    static EntUseAdapter rotating_use = new EntUseAdapter(){

        public String getID() {
            return "rotating_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (!Math3D.VectorEquals(self.avelocity, Globals.vec3_origin)) {
                self.s.sound = 0;
                Math3D.VectorClear(self.avelocity);
                self.touch = null;
            } else {
                self.s.sound = self.moveinfo.sound_middle;
                Math3D.VectorScale(self.movedir, self.speed, self.avelocity);
                if ((self.spawnflags & 0x10) != 0) {
                    self.touch = rotating_touch;
                }
            }
        }
    };
    static EntThinkAdapter SP_func_rotating = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_rotating";
        }

        public boolean think(edict_t ent) {
            ent.solid = 3;
            ent.movetype = (ent.spawnflags & 0x20) != 0 ? 3 : 2;
            Math3D.VectorClear(ent.movedir);
            if ((ent.spawnflags & 4) != 0) {
                ent.movedir[2] = 1.0f;
            } else if ((ent.spawnflags & 8) != 0) {
                ent.movedir[0] = 1.0f;
            } else {
                ent.movedir[1] = 1.0f;
            }
            if ((ent.spawnflags & 2) != 0) {
                Math3D.VectorNegate(ent.movedir, ent.movedir);
            }
            if (0.0f == ent.speed) {
                ent.speed = 100.0f;
            }
            if (0 == ent.dmg) {
                ent.dmg = 2;
            }
            ent.use = rotating_use;
            if (ent.dmg != 0) {
                ent.blocked = rotating_blocked;
            }
            if ((ent.spawnflags & 1) != 0) {
                ent.use.use(ent, null, null);
            }
            if ((ent.spawnflags & 0x40) != 0) {
                ent.s.effects |= 0x1000;
            }
            if ((ent.spawnflags & 0x80) != 0) {
                ent.s.effects |= 0x2000;
            }
            GameBase.gi.setmodel(ent, ent.model);
            GameBase.gi.linkentity(ent);
            return true;
        }
    };
    static EntThinkAdapter button_done = new EntThinkAdapter(){

        public String getID() {
            return "button_done";
        }

        public boolean think(edict_t self) {
            self.moveinfo.state = 1;
            self.s.effects &= 0xFFFFF7FF;
            self.s.effects |= 0x400;
            return true;
        }
    };
    static EntThinkAdapter button_return = new EntThinkAdapter(){

        public String getID() {
            return "button_return";
        }

        public boolean think(edict_t self) {
            self.moveinfo.state = 3;
            GameFunc.Move_Calc(self, self.moveinfo.start_origin, button_done);
            self.s.frame = 0;
            if (self.health != 0) {
                self.takedamage = 1;
            }
            return true;
        }
    };
    static EntThinkAdapter button_wait = new EntThinkAdapter(){

        public String getID() {
            return "button_wait";
        }

        public boolean think(edict_t self) {
            self.moveinfo.state = 0;
            self.s.effects &= 0xFFFFFBFF;
            self.s.effects |= 0x800;
            GameUtil.G_UseTargets(self, self.activator);
            self.s.frame = 1;
            if (self.moveinfo.wait >= 0.0f) {
                self.nextthink = GameBase.level.time + self.moveinfo.wait;
                self.think = button_return;
            }
            return true;
        }
    };
    static EntThinkAdapter button_fire = new EntThinkAdapter(){

        public String getID() {
            return "button_fire";
        }

        public boolean think(edict_t self) {
            if (self.moveinfo.state == 2 || self.moveinfo.state == 0) {
                return true;
            }
            self.moveinfo.state = 2;
            if (self.moveinfo.sound_start != 0 && 0 == (self.flags & 0x400)) {
                GameBase.gi.sound(self, 10, self.moveinfo.sound_start, 1.0f, 3.0f, 0.0f);
            }
            GameFunc.Move_Calc(self, self.moveinfo.end_origin, button_wait);
            return true;
        }
    };
    static EntUseAdapter button_use = new EntUseAdapter(){

        public String getID() {
            return "button_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.activator = activator;
            button_fire.think(self);
        }
    };
    static EntTouchAdapter button_touch = new EntTouchAdapter(){

        public String getID() {
            return "button_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (null == other.client) {
                return;
            }
            if (other.health <= 0) {
                return;
            }
            self.activator = other;
            button_fire.think(self);
        }
    };
    static EntDieAdapter button_killed = new EntDieAdapter(){

        public String getID() {
            return "button_killed";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            self.activator = attacker;
            self.health = self.max_health;
            self.takedamage = 0;
            button_fire.think(self);
        }
    };
    static EntThinkAdapter SP_func_button = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_button";
        }

        public boolean think(edict_t ent) {
            float[] abs_movedir = new float[]{0.0f, 0.0f, 0.0f};
            GameBase.G_SetMovedir(ent.s.angles, ent.movedir);
            ent.movetype = 3;
            ent.solid = 3;
            GameBase.gi.setmodel(ent, ent.model);
            if (ent.sounds != 1) {
                ent.moveinfo.sound_start = GameBase.gi.soundindex("switches/butn2.wav");
            }
            if (0.0f == ent.speed) {
                ent.speed = 40.0f;
            }
            if (0.0f == ent.accel) {
                ent.accel = ent.speed;
            }
            if (0.0f == ent.decel) {
                ent.decel = ent.speed;
            }
            if (0.0f == ent.wait) {
                ent.wait = 3.0f;
            }
            if (0 == GameBase.st.lip) {
                GameBase.st.lip = 4;
            }
            Math3D.VectorCopy(ent.s.origin, ent.pos1);
            abs_movedir[0] = Math.abs(ent.movedir[0]);
            abs_movedir[1] = Math.abs(ent.movedir[1]);
            abs_movedir[2] = Math.abs(ent.movedir[2]);
            float dist = abs_movedir[0] * ent.size[0] + abs_movedir[1] * ent.size[1] + abs_movedir[2] * ent.size[2] - (float)GameBase.st.lip;
            Math3D.VectorMA(ent.pos1, dist, ent.movedir, ent.pos2);
            ent.use = button_use;
            ent.s.effects |= 0x400;
            if (ent.health != 0) {
                ent.max_health = ent.health;
                ent.die = button_killed;
                ent.takedamage = 1;
            } else if (null == ent.targetname) {
                ent.touch = button_touch;
            }
            ent.moveinfo.state = 1;
            ent.moveinfo.speed = ent.speed;
            ent.moveinfo.accel = ent.accel;
            ent.moveinfo.decel = ent.decel;
            ent.moveinfo.wait = ent.wait;
            Math3D.VectorCopy(ent.pos1, ent.moveinfo.start_origin);
            Math3D.VectorCopy(ent.s.angles, ent.moveinfo.start_angles);
            Math3D.VectorCopy(ent.pos2, ent.moveinfo.end_origin);
            Math3D.VectorCopy(ent.s.angles, ent.moveinfo.end_angles);
            GameBase.gi.linkentity(ent);
            return true;
        }
    };
    static EntThinkAdapter door_hit_top = new EntThinkAdapter(){

        public String getID() {
            return "door_hit_top";
        }

        public boolean think(edict_t self) {
            if (0 == (self.flags & 0x400)) {
                if (self.moveinfo.sound_end != 0) {
                    GameBase.gi.sound(self, 10, self.moveinfo.sound_end, 1.0f, 3.0f, 0.0f);
                }
                self.s.sound = 0;
            }
            self.moveinfo.state = 0;
            if ((self.spawnflags & 0x20) != 0) {
                return true;
            }
            if (self.moveinfo.wait >= 0.0f) {
                self.think = door_go_down;
                self.nextthink = GameBase.level.time + self.moveinfo.wait;
            }
            return true;
        }
    };
    static EntThinkAdapter door_hit_bottom = new EntThinkAdapter(){

        public String getID() {
            return "door_hit_bottom";
        }

        public boolean think(edict_t self) {
            if (0 == (self.flags & 0x400)) {
                if (self.moveinfo.sound_end != 0) {
                    GameBase.gi.sound(self, 10, self.moveinfo.sound_end, 1.0f, 3.0f, 0.0f);
                }
                self.s.sound = 0;
            }
            self.moveinfo.state = 1;
            GameFunc.door_use_areaportals(self, false);
            return true;
        }
    };
    static EntThinkAdapter door_go_down = new EntThinkAdapter(){

        public String getID() {
            return "door_go_down";
        }

        public boolean think(edict_t self) {
            if (0 == (self.flags & 0x400)) {
                if (self.moveinfo.sound_start != 0) {
                    GameBase.gi.sound(self, 10, self.moveinfo.sound_start, 1.0f, 3.0f, 0.0f);
                }
                self.s.sound = self.moveinfo.sound_middle;
            }
            if (self.max_health != 0) {
                self.takedamage = 1;
                self.health = self.max_health;
            }
            self.moveinfo.state = 3;
            if (Lib.strcmp(self.classname, "func_door") == 0) {
                GameFunc.Move_Calc(self, self.moveinfo.start_origin, door_hit_bottom);
            } else if (Lib.strcmp(self.classname, "func_door_rotating") == 0) {
                GameFunc.AngleMove_Calc(self, door_hit_bottom);
            }
            return true;
        }
    };
    static EntUseAdapter door_use = new EntUseAdapter(){

        public String getID() {
            return "door_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if ((self.flags & 0x400) != 0) {
                return;
            }
            if ((self.spawnflags & 0x20) != 0 && (self.moveinfo.state == 2 || self.moveinfo.state == 0)) {
                edict_t ent = self;
                while (ent != null) {
                    ent.message = null;
                    ent.touch = null;
                    door_go_down.think(ent);
                    ent = ent.teamchain;
                }
                return;
            }
            edict_t ent = self;
            while (ent != null) {
                ent.message = null;
                ent.touch = null;
                GameFunc.door_go_up(ent, activator);
                ent = ent.teamchain;
            }
        }
    };
    static EntTouchAdapter Touch_DoorTrigger = new EntTouchAdapter(){

        public String getID() {
            return "touch_door_trigger";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (other.health <= 0) {
                return;
            }
            if (0 == (other.svflags & 4) && null == other.client) {
                return;
            }
            if (0 != (self.owner.spawnflags & 8) && 0 != (other.svflags & 4)) {
                return;
            }
            if (GameBase.level.time < self.touch_debounce_time) {
                return;
            }
            self.touch_debounce_time = GameBase.level.time + 1.0f;
            door_use.use(self.owner, other, other);
        }
    };
    static EntThinkAdapter Think_CalcMoveSpeed = new EntThinkAdapter(){

        public String getID() {
            return "think_calc_movespeed";
        }

        public boolean think(edict_t self) {
            if ((self.flags & 0x400) != 0) {
                return true;
            }
            float min = Math.abs(self.moveinfo.distance);
            edict_t ent = self.teamchain;
            while (ent != null) {
                float dist = Math.abs(ent.moveinfo.distance);
                if (dist < min) {
                    min = dist;
                }
                ent = ent.teamchain;
            }
            float time = min / self.moveinfo.speed;
            ent = self;
            while (ent != null) {
                float newspeed = Math.abs(ent.moveinfo.distance) / time;
                float ratio = newspeed / ent.moveinfo.speed;
                ent.moveinfo.accel = ent.moveinfo.accel == ent.moveinfo.speed ? newspeed : (ent.moveinfo.accel *= ratio);
                ent.moveinfo.decel = ent.moveinfo.decel == ent.moveinfo.speed ? newspeed : (ent.moveinfo.decel *= ratio);
                ent.moveinfo.speed = newspeed;
                ent = ent.teamchain;
            }
            return true;
        }
    };
    static EntThinkAdapter Think_SpawnDoorTrigger = new EntThinkAdapter(){

        public String getID() {
            return "think_spawn_door_trigger";
        }

        public boolean think(edict_t ent) {
            float[] mins = new float[]{0.0f, 0.0f, 0.0f};
            float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
            if ((ent.flags & 0x400) != 0) {
                return true;
            }
            Math3D.VectorCopy(ent.absmin, mins);
            Math3D.VectorCopy(ent.absmax, maxs);
            edict_t other = ent.teamchain;
            while (other != null) {
                GameBase.AddPointToBounds(other.absmin, mins, maxs);
                GameBase.AddPointToBounds(other.absmax, mins, maxs);
                other = other.teamchain;
            }
            mins[0] = mins[0] - 60.0f;
            mins[1] = mins[1] - 60.0f;
            maxs[0] = maxs[0] + 60.0f;
            maxs[1] = maxs[1] + 60.0f;
            other = GameUtil.G_Spawn();
            Math3D.VectorCopy(mins, other.mins);
            Math3D.VectorCopy(maxs, other.maxs);
            other.owner = ent;
            other.solid = 1;
            other.movetype = 0;
            other.touch = Touch_DoorTrigger;
            GameBase.gi.linkentity(other);
            if ((ent.spawnflags & 1) != 0) {
                GameFunc.door_use_areaportals(ent, true);
            }
            Think_CalcMoveSpeed.think(ent);
            return true;
        }
    };
    static EntBlockedAdapter door_blocked = new EntBlockedAdapter(){

        public String getID() {
            return "door_blocked";
        }

        public void blocked(edict_t self, edict_t other) {
            block7: {
                if (0 == (other.svflags & 4) && null == other.client) {
                    GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, 100000, 1, 0, 20);
                    if (other != null) {
                        GameMisc.BecomeExplosion1(other);
                    }
                    return;
                }
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
                if ((self.spawnflags & 4) != 0) {
                    return;
                }
                if (!(self.moveinfo.wait >= 0.0f)) break block7;
                if (self.moveinfo.state == 3) {
                    edict_t ent = self.teammaster;
                    while (ent != null) {
                        GameFunc.door_go_up(ent, ent.activator);
                        ent = ent.teamchain;
                    }
                } else {
                    edict_t ent = self.teammaster;
                    while (ent != null) {
                        door_go_down.think(ent);
                        ent = ent.teamchain;
                    }
                }
            }
        }
    };
    static EntDieAdapter door_killed = new EntDieAdapter(){

        public String getID() {
            return "door_killed";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            edict_t ent = self.teammaster;
            while (ent != null) {
                ent.health = ent.max_health;
                ent.takedamage = 0;
                ent = ent.teamchain;
            }
            door_use.use(self.teammaster, attacker, attacker);
        }
    };
    static EntTouchAdapter door_touch = new EntTouchAdapter(){

        public String getID() {
            return "door_touch";
        }

        public void touch(edict_t self, edict_t other, cplane_t plane, csurface_t surf) {
            if (null == other.client) {
                return;
            }
            if (GameBase.level.time < self.touch_debounce_time) {
                return;
            }
            self.touch_debounce_time = GameBase.level.time + 5.0f;
            GameBase.gi.centerprintf(other, self.message);
            GameBase.gi.sound(other, 0, GameBase.gi.soundindex("misc/talk1.wav"), 1.0f, 1.0f, 0.0f);
        }
    };
    static EntThinkAdapter SP_func_door = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_door";
        }

        public boolean think(edict_t ent) {
            float[] abs_movedir = new float[]{0.0f, 0.0f, 0.0f};
            if (ent.sounds != 1) {
                ent.moveinfo.sound_start = GameBase.gi.soundindex("doors/dr1_strt.wav");
                ent.moveinfo.sound_middle = GameBase.gi.soundindex("doors/dr1_mid.wav");
                ent.moveinfo.sound_end = GameBase.gi.soundindex("doors/dr1_end.wav");
            }
            GameBase.G_SetMovedir(ent.s.angles, ent.movedir);
            ent.movetype = 2;
            ent.solid = 3;
            GameBase.gi.setmodel(ent, ent.model);
            ent.blocked = door_blocked;
            ent.use = door_use;
            if (0.0f == ent.speed) {
                ent.speed = 100.0f;
            }
            if (GameBase.deathmatch.value != 0.0f) {
                ent.speed *= 2.0f;
            }
            if (0.0f == ent.accel) {
                ent.accel = ent.speed;
            }
            if (0.0f == ent.decel) {
                ent.decel = ent.speed;
            }
            if (0.0f == ent.wait) {
                ent.wait = 3.0f;
            }
            if (0 == GameBase.st.lip) {
                GameBase.st.lip = 8;
            }
            if (0 == ent.dmg) {
                ent.dmg = 2;
            }
            Math3D.VectorCopy(ent.s.origin, ent.pos1);
            abs_movedir[0] = Math.abs(ent.movedir[0]);
            abs_movedir[1] = Math.abs(ent.movedir[1]);
            abs_movedir[2] = Math.abs(ent.movedir[2]);
            ent.moveinfo.distance = abs_movedir[0] * ent.size[0] + abs_movedir[1] * ent.size[1] + abs_movedir[2] * ent.size[2] - (float)GameBase.st.lip;
            Math3D.VectorMA(ent.pos1, ent.moveinfo.distance, ent.movedir, ent.pos2);
            if ((ent.spawnflags & 1) != 0) {
                Math3D.VectorCopy(ent.pos2, ent.s.origin);
                Math3D.VectorCopy(ent.pos1, ent.pos2);
                Math3D.VectorCopy(ent.s.origin, ent.pos1);
            }
            ent.moveinfo.state = 1;
            if (ent.health != 0) {
                ent.takedamage = 1;
                ent.die = door_killed;
                ent.max_health = ent.health;
            } else if (ent.targetname != null && ent.message != null) {
                GameBase.gi.soundindex("misc/talk.wav");
                ent.touch = door_touch;
            }
            ent.moveinfo.speed = ent.speed;
            ent.moveinfo.accel = ent.accel;
            ent.moveinfo.decel = ent.decel;
            ent.moveinfo.wait = ent.wait;
            Math3D.VectorCopy(ent.pos1, ent.moveinfo.start_origin);
            Math3D.VectorCopy(ent.s.angles, ent.moveinfo.start_angles);
            Math3D.VectorCopy(ent.pos2, ent.moveinfo.end_origin);
            Math3D.VectorCopy(ent.s.angles, ent.moveinfo.end_angles);
            if ((ent.spawnflags & 0x10) != 0) {
                ent.s.effects |= 0x1000;
            }
            if ((ent.spawnflags & 0x40) != 0) {
                ent.s.effects |= 0x2000;
            }
            if (null == ent.team) {
                ent.teammaster = ent;
            }
            GameBase.gi.linkentity(ent);
            ent.nextthink = GameBase.level.time + 0.1f;
            ent.think = ent.health != 0 || ent.targetname != null ? Think_CalcMoveSpeed : Think_SpawnDoorTrigger;
            return true;
        }
    };
    static EntThinkAdapter SP_func_door_rotating = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_door_rotating";
        }

        public boolean think(edict_t ent) {
            Math3D.VectorClear(ent.s.angles);
            Math3D.VectorClear(ent.movedir);
            if ((ent.spawnflags & 0x40) != 0) {
                ent.movedir[2] = 1.0f;
            } else if ((ent.spawnflags & 0x80) != 0) {
                ent.movedir[0] = 1.0f;
            } else {
                ent.movedir[1] = 1.0f;
            }
            if ((ent.spawnflags & 2) != 0) {
                Math3D.VectorNegate(ent.movedir, ent.movedir);
            }
            if (0 == GameBase.st.distance) {
                GameBase.gi.dprintf(ent.classname + " at " + Lib.vtos(ent.s.origin) + " with no distance set\n");
                GameBase.st.distance = 90;
            }
            Math3D.VectorCopy(ent.s.angles, ent.pos1);
            Math3D.VectorMA(ent.s.angles, GameBase.st.distance, ent.movedir, ent.pos2);
            ent.moveinfo.distance = GameBase.st.distance;
            ent.movetype = 2;
            ent.solid = 3;
            GameBase.gi.setmodel(ent, ent.model);
            ent.blocked = door_blocked;
            ent.use = door_use;
            if (0.0f == ent.speed) {
                ent.speed = 100.0f;
            }
            if (0.0f == ent.accel) {
                ent.accel = ent.speed;
            }
            if (0.0f == ent.decel) {
                ent.decel = ent.speed;
            }
            if (0.0f == ent.wait) {
                ent.wait = 3.0f;
            }
            if (0 == ent.dmg) {
                ent.dmg = 2;
            }
            if (ent.sounds != 1) {
                ent.moveinfo.sound_start = GameBase.gi.soundindex("doors/dr1_strt.wav");
                ent.moveinfo.sound_middle = GameBase.gi.soundindex("doors/dr1_mid.wav");
                ent.moveinfo.sound_end = GameBase.gi.soundindex("doors/dr1_end.wav");
            }
            if ((ent.spawnflags & 1) != 0) {
                Math3D.VectorCopy(ent.pos2, ent.s.angles);
                Math3D.VectorCopy(ent.pos1, ent.pos2);
                Math3D.VectorCopy(ent.s.angles, ent.pos1);
                Math3D.VectorNegate(ent.movedir, ent.movedir);
            }
            if (ent.health != 0) {
                ent.takedamage = 1;
                ent.die = door_killed;
                ent.max_health = ent.health;
            }
            if (ent.targetname != null && ent.message != null) {
                GameBase.gi.soundindex("misc/talk.wav");
                ent.touch = door_touch;
            }
            ent.moveinfo.state = 1;
            ent.moveinfo.speed = ent.speed;
            ent.moveinfo.accel = ent.accel;
            ent.moveinfo.decel = ent.decel;
            ent.moveinfo.wait = ent.wait;
            Math3D.VectorCopy(ent.s.origin, ent.moveinfo.start_origin);
            Math3D.VectorCopy(ent.pos1, ent.moveinfo.start_angles);
            Math3D.VectorCopy(ent.s.origin, ent.moveinfo.end_origin);
            Math3D.VectorCopy(ent.pos2, ent.moveinfo.end_angles);
            if ((ent.spawnflags & 0x10) != 0) {
                ent.s.effects |= 0x1000;
            }
            if (ent.team == null) {
                ent.teammaster = ent;
            }
            GameBase.gi.linkentity(ent);
            ent.nextthink = GameBase.level.time + 0.1f;
            ent.think = ent.health != 0 || ent.targetname != null ? Think_CalcMoveSpeed : Think_SpawnDoorTrigger;
            return true;
        }
    };
    public static final int TRAIN_START_ON = 1;
    public static final int TRAIN_TOGGLE = 2;
    public static final int TRAIN_BLOCK_STOPS = 4;
    static EntBlockedAdapter train_blocked = new EntBlockedAdapter(){

        public String getID() {
            return "train_blocked";
        }

        public void blocked(edict_t self, edict_t other) {
            if (0 == (other.svflags & 4) && null == other.client) {
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, 100000, 1, 0, 20);
                if (other != null) {
                    GameMisc.BecomeExplosion1(other);
                }
                return;
            }
            if (GameBase.level.time < self.touch_debounce_time) {
                return;
            }
            if (self.dmg == 0) {
                return;
            }
            self.touch_debounce_time = GameBase.level.time + 0.5f;
            GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
        }
    };
    static EntThinkAdapter train_wait = new EntThinkAdapter(){

        public String getID() {
            return "train_wait";
        }

        public boolean think(edict_t self) {
            if (self.target_ent.pathtarget != null) {
                edict_t ent = self.target_ent;
                String savetarget = ent.target;
                ent.target = ent.pathtarget;
                GameUtil.G_UseTargets(ent, self.activator);
                ent.target = savetarget;
                if (!self.inuse) {
                    return true;
                }
            }
            if (self.moveinfo.wait != 0.0f) {
                if (self.moveinfo.wait > 0.0f) {
                    self.nextthink = GameBase.level.time + self.moveinfo.wait;
                    self.think = train_next;
                } else if (0 != (self.spawnflags & 2)) {
                    train_next.think(self);
                    self.spawnflags &= 0xFFFFFFFE;
                    Math3D.VectorClear(self.velocity);
                    self.nextthink = 0.0f;
                }
                if (0 == (self.flags & 0x400)) {
                    if (self.moveinfo.sound_end != 0) {
                        GameBase.gi.sound(self, 10, self.moveinfo.sound_end, 1.0f, 3.0f, 0.0f);
                    }
                    self.s.sound = 0;
                }
            } else {
                train_next.think(self);
            }
            return true;
        }
    };
    static EntThinkAdapter train_next = new EntThinkAdapter(){

        public String getID() {
            return "train_next";
        }

        public boolean think(edict_t self) {
            edict_t ent = null;
            float[] dest = new float[]{0.0f, 0.0f, 0.0f};
            boolean first = true;
            boolean dogoto = true;
            while (dogoto) {
                if (null == self.target) {
                    return true;
                }
                ent = GameBase.G_PickTarget(self.target);
                if (null == ent) {
                    GameBase.gi.dprintf("train_next: bad target " + self.target + "\n");
                    return true;
                }
                self.target = ent.target;
                dogoto = false;
                if ((ent.spawnflags & 1) == 0) continue;
                if (!first) {
                    GameBase.gi.dprintf("connected teleport path_corners, see " + ent.classname + " at " + Lib.vtos(ent.s.origin) + "\n");
                    return true;
                }
                first = false;
                Math3D.VectorSubtract(ent.s.origin, self.mins, self.s.origin);
                Math3D.VectorCopy(self.s.origin, self.s.old_origin);
                self.s.event = 7;
                GameBase.gi.linkentity(self);
                dogoto = true;
            }
            self.moveinfo.wait = ent.wait;
            self.target_ent = ent;
            if (0 == (self.flags & 0x400)) {
                if (self.moveinfo.sound_start != 0) {
                    GameBase.gi.sound(self, 10, self.moveinfo.sound_start, 1.0f, 3.0f, 0.0f);
                }
                self.s.sound = self.moveinfo.sound_middle;
            }
            Math3D.VectorSubtract(ent.s.origin, self.mins, dest);
            self.moveinfo.state = 0;
            Math3D.VectorCopy(self.s.origin, self.moveinfo.start_origin);
            Math3D.VectorCopy(dest, self.moveinfo.end_origin);
            GameFunc.Move_Calc(self, dest, train_wait);
            self.spawnflags |= 1;
            return true;
        }
    };
    public static EntThinkAdapter func_train_find = new EntThinkAdapter(){

        public String getID() {
            return "func_train_find";
        }

        public boolean think(edict_t self) {
            if (null == self.target) {
                GameBase.gi.dprintf("train_find: no target\n");
                return true;
            }
            edict_t ent = GameBase.G_PickTarget(self.target);
            if (null == ent) {
                GameBase.gi.dprintf("train_find: target " + self.target + " not found\n");
                return true;
            }
            self.target = ent.target;
            Math3D.VectorSubtract(ent.s.origin, self.mins, self.s.origin);
            GameBase.gi.linkentity(self);
            if (null == self.targetname) {
                self.spawnflags |= 1;
            }
            if ((self.spawnflags & 1) != 0) {
                self.nextthink = GameBase.level.time + 0.1f;
                self.think = train_next;
                self.activator = self;
            }
            return true;
        }
    };
    public static EntUseAdapter train_use = new EntUseAdapter(){

        public String getID() {
            return "train_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.activator = activator;
            if ((self.spawnflags & 1) != 0) {
                if (0 == (self.spawnflags & 2)) {
                    return;
                }
                self.spawnflags &= 0xFFFFFFFE;
                Math3D.VectorClear(self.velocity);
                self.nextthink = 0.0f;
            } else if (self.target_ent != null) {
                GameFunc.train_resume(self);
            } else {
                train_next.think(self);
            }
        }
    };
    static EntUseAdapter trigger_elevator_use = new EntUseAdapter(){

        public String getID() {
            return "trigger_elevator_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (0.0f != self.movetarget.nextthink) {
                return;
            }
            if (null == other.pathtarget) {
                GameBase.gi.dprintf("elevator used with no pathtarget\n");
                return;
            }
            edict_t target = GameBase.G_PickTarget(other.pathtarget);
            if (null == target) {
                GameBase.gi.dprintf("elevator used with bad pathtarget: " + other.pathtarget + "\n");
                return;
            }
            self.movetarget.target_ent = target;
            GameFunc.train_resume(self.movetarget);
        }
    };
    static EntThinkAdapter trigger_elevator_init = new EntThinkAdapter(){

        public String getID() {
            return "trigger_elevator_init";
        }

        public boolean think(edict_t self) {
            if (null == self.target) {
                GameBase.gi.dprintf("trigger_elevator has no target\n");
                return true;
            }
            self.movetarget = GameBase.G_PickTarget(self.target);
            if (null == self.movetarget) {
                GameBase.gi.dprintf("trigger_elevator unable to find target " + self.target + "\n");
                return true;
            }
            if (Lib.strcmp(self.movetarget.classname, "func_train") != 0) {
                GameBase.gi.dprintf("trigger_elevator target " + self.target + " is not a train\n");
                return true;
            }
            self.use = trigger_elevator_use;
            self.svflags = 1;
            return true;
        }
    };
    static EntThinkAdapter SP_trigger_elevator = new EntThinkAdapter(){

        public String getID() {
            return "sp_trigger_elevator";
        }

        public boolean think(edict_t self) {
            self.think = trigger_elevator_init;
            self.nextthink = GameBase.level.time + 0.1f;
            return true;
        }
    };
    static EntThinkAdapter func_timer_think = new EntThinkAdapter(){

        public String getID() {
            return "func_timer_think";
        }

        public boolean think(edict_t self) {
            GameUtil.G_UseTargets(self, self.activator);
            self.nextthink = GameBase.level.time + self.wait + Lib.crandom() * self.random;
            return true;
        }
    };
    static EntUseAdapter func_timer_use = new EntUseAdapter(){

        public String getID() {
            return "func_timer_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            self.activator = activator;
            if (self.nextthink != 0.0f) {
                self.nextthink = 0.0f;
                return;
            }
            if (self.delay != 0.0f) {
                self.nextthink = GameBase.level.time + self.delay;
            } else {
                func_timer_think.think(self);
            }
        }
    };
    static EntUseAdapter func_conveyor_use = new EntUseAdapter(){

        public String getID() {
            return "func_conveyor_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if ((self.spawnflags & 1) != 0) {
                self.speed = 0.0f;
                self.spawnflags &= 0xFFFFFFFE;
            } else {
                self.speed = self.count;
                self.spawnflags |= 1;
            }
            if (0 == (self.spawnflags & 2)) {
                self.count = 0;
            }
        }
    };
    static EntThinkAdapter SP_func_conveyor = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_conveyor";
        }

        public boolean think(edict_t self) {
            if (0.0f == self.speed) {
                self.speed = 100.0f;
            }
            if (0 == (self.spawnflags & 1)) {
                self.count = (int)self.speed;
                self.speed = 0.0f;
            }
            self.use = func_conveyor_use;
            GameBase.gi.setmodel(self, self.model);
            self.solid = 3;
            GameBase.gi.linkentity(self);
            return true;
        }
    };
    public static final int SECRET_ALWAYS_SHOOT = 1;
    public static final int SECRET_1ST_LEFT = 2;
    public static final int SECRET_1ST_DOWN = 4;
    static EntUseAdapter door_secret_use = new EntUseAdapter(){

        public String getID() {
            return "door_secret_use";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            if (!Math3D.VectorEquals(self.s.origin, Globals.vec3_origin)) {
                return;
            }
            GameFunc.Move_Calc(self, self.pos1, door_secret_move1);
            GameFunc.door_use_areaportals(self, true);
        }
    };
    static EntThinkAdapter door_secret_move1 = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move1";
        }

        public boolean think(edict_t self) {
            self.nextthink = GameBase.level.time + 1.0f;
            self.think = door_secret_move2;
            return true;
        }
    };
    static EntThinkAdapter door_secret_move2 = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move2";
        }

        public boolean think(edict_t self) {
            GameFunc.Move_Calc(self, self.pos2, door_secret_move3);
            return true;
        }
    };
    static EntThinkAdapter door_secret_move3 = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move3";
        }

        public boolean think(edict_t self) {
            if (self.wait == -1.0f) {
                return true;
            }
            self.nextthink = GameBase.level.time + self.wait;
            self.think = door_secret_move4;
            return true;
        }
    };
    static EntThinkAdapter door_secret_move4 = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move4";
        }

        public boolean think(edict_t self) {
            GameFunc.Move_Calc(self, self.pos1, door_secret_move5);
            return true;
        }
    };
    static EntThinkAdapter door_secret_move5 = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move5";
        }

        public boolean think(edict_t self) {
            self.nextthink = GameBase.level.time + 1.0f;
            self.think = door_secret_move6;
            return true;
        }
    };
    static EntThinkAdapter door_secret_move6 = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move6";
        }

        public boolean think(edict_t self) {
            GameFunc.Move_Calc(self, Globals.vec3_origin, door_secret_done);
            return true;
        }
    };
    static EntThinkAdapter door_secret_done = new EntThinkAdapter(){

        public String getID() {
            return "door_secret_move7";
        }

        public boolean think(edict_t self) {
            if (null == self.targetname || 0 != (self.spawnflags & 1)) {
                self.health = 0;
                self.takedamage = 1;
            }
            GameFunc.door_use_areaportals(self, false);
            return true;
        }
    };
    static EntBlockedAdapter door_secret_blocked = new EntBlockedAdapter(){

        public String getID() {
            return "door_secret_blocked";
        }

        public void blocked(edict_t self, edict_t other) {
            if (0 == (other.svflags & 4) && null == other.client) {
                GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, 100000, 1, 0, 20);
                if (other != null) {
                    GameMisc.BecomeExplosion1(other);
                }
                return;
            }
            if (GameBase.level.time < self.touch_debounce_time) {
                return;
            }
            self.touch_debounce_time = GameBase.level.time + 0.5f;
            GameCombat.T_Damage(other, self, self, Globals.vec3_origin, other.s.origin, Globals.vec3_origin, self.dmg, 1, 0, 20);
        }
    };
    static EntDieAdapter door_secret_die = new EntDieAdapter(){

        public String getID() {
            return "door_secret_die";
        }

        public void die(edict_t self, edict_t inflictor, edict_t attacker, int damage, float[] point) {
            self.takedamage = 0;
            door_secret_use.use(self, attacker, attacker);
        }
    };
    static EntThinkAdapter SP_func_door_secret = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_door_secret";
        }

        public boolean think(edict_t ent) {
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] right = new float[]{0.0f, 0.0f, 0.0f};
            float[] up = new float[]{0.0f, 0.0f, 0.0f};
            ent.moveinfo.sound_start = GameBase.gi.soundindex("doors/dr1_strt.wav");
            ent.moveinfo.sound_middle = GameBase.gi.soundindex("doors/dr1_mid.wav");
            ent.moveinfo.sound_end = GameBase.gi.soundindex("doors/dr1_end.wav");
            ent.movetype = 2;
            ent.solid = 3;
            GameBase.gi.setmodel(ent, ent.model);
            ent.blocked = door_secret_blocked;
            ent.use = door_secret_use;
            if (null == ent.targetname || 0 != (ent.spawnflags & 1)) {
                ent.health = 0;
                ent.takedamage = 1;
                ent.die = door_secret_die;
            }
            if (0 == ent.dmg) {
                ent.dmg = 2;
            }
            if (0.0f == ent.wait) {
                ent.wait = 5.0f;
            }
            ent.moveinfo.speed = 50.0f;
            ent.moveinfo.decel = 50.0f;
            ent.moveinfo.accel = 50.0f;
            Math3D.AngleVectors(ent.s.angles, forward, right, up);
            Math3D.VectorClear(ent.s.angles);
            float side = 1.0f - (float)(ent.spawnflags & 2);
            float width = (ent.spawnflags & 4) != 0 ? Math.abs(Math3D.DotProduct(up, ent.size)) : Math.abs(Math3D.DotProduct(right, ent.size));
            float length = Math.abs(Math3D.DotProduct(forward, ent.size));
            if ((ent.spawnflags & 4) != 0) {
                Math3D.VectorMA(ent.s.origin, -1.0f * width, up, ent.pos1);
            } else {
                Math3D.VectorMA(ent.s.origin, side * width, right, ent.pos1);
            }
            Math3D.VectorMA(ent.pos1, length, forward, ent.pos2);
            if (ent.health != 0) {
                ent.takedamage = 1;
                ent.die = door_killed;
                ent.max_health = ent.health;
            } else if (ent.targetname != null && ent.message != null) {
                GameBase.gi.soundindex("misc/talk.wav");
                ent.touch = door_touch;
            }
            ent.classname = "func_door";
            GameBase.gi.linkentity(ent);
            return true;
        }
    };
    static EntUseAdapter use_killbox = new EntUseAdapter(){

        public String getID() {
            return "use_killbox";
        }

        public void use(edict_t self, edict_t other, edict_t activator) {
            GameUtil.KillBox(self);
        }
    };
    static EntThinkAdapter SP_func_killbox = new EntThinkAdapter(){

        public String getID() {
            return "sp_func_killbox";
        }

        public boolean think(edict_t ent) {
            GameBase.gi.setmodel(ent, ent.model);
            ent.use = use_killbox;
            ent.svflags = 1;
            return true;
        }
    };

    static void Move_Calc(edict_t ent, float[] dest, EntThinkAdapter func) {
        Math3D.VectorClear(ent.velocity);
        Math3D.VectorSubtract(dest, ent.s.origin, ent.moveinfo.dir);
        ent.moveinfo.remaining_distance = Math3D.VectorNormalize(ent.moveinfo.dir);
        ent.moveinfo.endfunc = func;
        if (ent.moveinfo.speed == ent.moveinfo.accel && ent.moveinfo.speed == ent.moveinfo.decel) {
            if (GameBase.level.current_entity == ((ent.flags & 0x400) != 0 ? ent.teammaster : ent)) {
                Move_Begin.think(ent);
            } else {
                ent.nextthink = GameBase.level.time + 0.1f;
                ent.think = Move_Begin;
            }
        } else {
            ent.moveinfo.current_speed = 0.0f;
            ent.think = Think_AccelMove;
            ent.nextthink = GameBase.level.time + 0.1f;
        }
    }

    static void AngleMove_Calc(edict_t ent, EntThinkAdapter func) {
        Math3D.VectorClear(ent.avelocity);
        ent.moveinfo.endfunc = func;
        if (GameBase.level.current_entity == ((ent.flags & 0x400) != 0 ? ent.teammaster : ent)) {
            AngleMove_Begin.think(ent);
        } else {
            ent.nextthink = GameBase.level.time + 0.1f;
            ent.think = AngleMove_Begin;
        }
    }

    static float AccelerationDistance(float target, float rate) {
        return target * (target / rate + 1.0f) / 2.0f;
    }

    static void plat_CalcAcceleratedMove(moveinfo_t moveinfo) {
        float decel_dist;
        moveinfo.move_speed = moveinfo.speed;
        if (moveinfo.remaining_distance < moveinfo.accel) {
            moveinfo.current_speed = moveinfo.remaining_distance;
            return;
        }
        float accel_dist = GameFunc.AccelerationDistance(moveinfo.speed, moveinfo.accel);
        if (moveinfo.remaining_distance - accel_dist - (decel_dist = GameFunc.AccelerationDistance(moveinfo.speed, moveinfo.decel)) < 0.0f) {
            float f = (moveinfo.accel + moveinfo.decel) / (moveinfo.accel * moveinfo.decel);
            moveinfo.move_speed = (float)((-2.0 + Math.sqrt(4.0f - 4.0f * f * (-2.0f * moveinfo.remaining_distance))) / (double)(2.0f * f));
            decel_dist = GameFunc.AccelerationDistance(moveinfo.move_speed, moveinfo.decel);
        }
        moveinfo.decel_distance = decel_dist;
    }

    static void plat_Accelerate(moveinfo_t moveinfo) {
        if (moveinfo.remaining_distance <= moveinfo.decel_distance) {
            if (moveinfo.remaining_distance < moveinfo.decel_distance) {
                if (moveinfo.next_speed != 0.0f) {
                    moveinfo.current_speed = moveinfo.next_speed;
                    moveinfo.next_speed = 0.0f;
                    return;
                }
                if (moveinfo.current_speed > moveinfo.decel) {
                    moveinfo.current_speed -= moveinfo.decel;
                }
            }
            return;
        }
        if (moveinfo.current_speed == moveinfo.move_speed && moveinfo.remaining_distance - moveinfo.current_speed < moveinfo.decel_distance) {
            float p1_distance = moveinfo.remaining_distance - moveinfo.decel_distance;
            float p2_distance = moveinfo.move_speed * (1.0f - p1_distance / moveinfo.move_speed);
            float distance = p1_distance + p2_distance;
            moveinfo.current_speed = moveinfo.move_speed;
            moveinfo.next_speed = moveinfo.move_speed - moveinfo.decel * (p2_distance / distance);
            return;
        }
        if (moveinfo.current_speed < moveinfo.speed) {
            float old_speed = moveinfo.current_speed;
            moveinfo.current_speed += moveinfo.accel;
            if (moveinfo.current_speed > moveinfo.speed) {
                moveinfo.current_speed = moveinfo.speed;
            }
            if (moveinfo.remaining_distance - moveinfo.current_speed >= moveinfo.decel_distance) {
                return;
            }
            float p1_distance = moveinfo.remaining_distance - moveinfo.decel_distance;
            float p1_speed = (old_speed + moveinfo.move_speed) / 2.0f;
            float p2_distance = moveinfo.move_speed * (1.0f - p1_distance / p1_speed);
            float distance = p1_distance + p2_distance;
            moveinfo.current_speed = p1_speed * (p1_distance / distance) + moveinfo.move_speed * (p2_distance / distance);
            moveinfo.next_speed = moveinfo.move_speed - moveinfo.decel * (p2_distance / distance);
            return;
        }
    }

    static void plat_go_up(edict_t ent) {
        if (0 == (ent.flags & 0x400)) {
            if (ent.moveinfo.sound_start != 0) {
                GameBase.gi.sound(ent, 10, ent.moveinfo.sound_start, 1.0f, 3.0f, 0.0f);
            }
            ent.s.sound = ent.moveinfo.sound_middle;
        }
        ent.moveinfo.state = 2;
        GameFunc.Move_Calc(ent, ent.moveinfo.start_origin, plat_hit_top);
    }

    static void plat_spawn_inside_trigger(edict_t ent) {
        float[] tmin = new float[]{0.0f, 0.0f, 0.0f};
        float[] tmax = new float[]{0.0f, 0.0f, 0.0f};
        edict_t trigger = GameUtil.G_Spawn();
        trigger.touch = Touch_Plat_Center;
        trigger.movetype = 0;
        trigger.solid = 1;
        trigger.enemy = ent;
        tmin[0] = ent.mins[0] + 25.0f;
        tmin[1] = ent.mins[1] + 25.0f;
        tmin[2] = ent.mins[2];
        tmax[0] = ent.maxs[0] - 25.0f;
        tmax[1] = ent.maxs[1] - 25.0f;
        tmax[2] = ent.maxs[2] + 8.0f;
        tmin[2] = tmax[2] - (ent.pos1[2] - ent.pos2[2] + (float)GameBase.st.lip);
        if ((ent.spawnflags & 1) != 0) {
            tmax[2] = tmin[2] + 8.0f;
        }
        if (tmax[0] - tmin[0] <= 0.0f) {
            tmin[0] = (ent.mins[0] + ent.maxs[0]) * 0.5f;
            tmax[0] = tmin[0] + 1.0f;
        }
        if (tmax[1] - tmin[1] <= 0.0f) {
            tmin[1] = (ent.mins[1] + ent.maxs[1]) * 0.5f;
            tmax[1] = tmin[1] + 1.0f;
        }
        Math3D.VectorCopy(tmin, trigger.mins);
        Math3D.VectorCopy(tmax, trigger.maxs);
        GameBase.gi.linkentity(trigger);
    }

    static void SP_func_plat(edict_t ent) {
        Math3D.VectorClear(ent.s.angles);
        ent.solid = 3;
        ent.movetype = 2;
        GameBase.gi.setmodel(ent, ent.model);
        ent.blocked = plat_blocked;
        ent.speed = 0.0f == ent.speed ? 20.0f : (float)((double)ent.speed * 0.1);
        ent.accel = ent.accel == 0.0f ? 5.0f : (float)((double)ent.accel * 0.1);
        ent.decel = ent.decel == 0.0f ? 5.0f : (float)((double)ent.decel * 0.1);
        if (ent.dmg == 0) {
            ent.dmg = 2;
        }
        if (GameBase.st.lip == 0) {
            GameBase.st.lip = 8;
        }
        Math3D.VectorCopy(ent.s.origin, ent.pos1);
        Math3D.VectorCopy(ent.s.origin, ent.pos2);
        ent.pos2[2] = GameBase.st.height != 0 ? ent.pos2[2] - (float)GameBase.st.height : ent.pos2[2] - (ent.maxs[2] - ent.mins[2] - (float)GameBase.st.lip);
        ent.use = Use_Plat;
        GameFunc.plat_spawn_inside_trigger(ent);
        if (ent.targetname != null) {
            ent.moveinfo.state = 2;
        } else {
            Math3D.VectorCopy(ent.pos2, ent.s.origin);
            GameBase.gi.linkentity(ent);
            ent.moveinfo.state = 1;
        }
        ent.moveinfo.speed = ent.speed;
        ent.moveinfo.accel = ent.accel;
        ent.moveinfo.decel = ent.decel;
        ent.moveinfo.wait = ent.wait;
        Math3D.VectorCopy(ent.pos1, ent.moveinfo.start_origin);
        Math3D.VectorCopy(ent.s.angles, ent.moveinfo.start_angles);
        Math3D.VectorCopy(ent.pos2, ent.moveinfo.end_origin);
        Math3D.VectorCopy(ent.s.angles, ent.moveinfo.end_angles);
        ent.moveinfo.sound_start = GameBase.gi.soundindex("plats/pt1_strt.wav");
        ent.moveinfo.sound_middle = GameBase.gi.soundindex("plats/pt1_mid.wav");
        ent.moveinfo.sound_end = GameBase.gi.soundindex("plats/pt1_end.wav");
    }

    static void door_use_areaportals(edict_t self, boolean open) {
        edict_t t = null;
        if (self.target == null) {
            return;
        }
        EdictIterator edit = null;
        while ((edit = GameBase.G_Find(edit, GameBase.findByTarget, self.target)) != null) {
            t = edit.o;
            if (Lib.Q_stricmp(t.classname, "func_areaportal") != 0) continue;
            GameBase.gi.SetAreaPortalState(t.style, open);
        }
    }

    static void door_go_up(edict_t self, edict_t activator) {
        if (self.moveinfo.state == 2) {
            return;
        }
        if (self.moveinfo.state == 0) {
            if (self.moveinfo.wait >= 0.0f) {
                self.nextthink = GameBase.level.time + self.moveinfo.wait;
            }
            return;
        }
        if (0 == (self.flags & 0x400)) {
            if (self.moveinfo.sound_start != 0) {
                GameBase.gi.sound(self, 10, self.moveinfo.sound_start, 1.0f, 3.0f, 0.0f);
            }
            self.s.sound = self.moveinfo.sound_middle;
        }
        self.moveinfo.state = 2;
        if (Lib.strcmp(self.classname, "func_door") == 0) {
            GameFunc.Move_Calc(self, self.moveinfo.end_origin, door_hit_top);
        } else if (Lib.strcmp(self.classname, "func_door_rotating") == 0) {
            GameFunc.AngleMove_Calc(self, door_hit_top);
        }
        GameUtil.G_UseTargets(self, activator);
        GameFunc.door_use_areaportals(self, true);
    }

    static void SP_func_water(edict_t self) {
        float[] abs_movedir = new float[]{0.0f, 0.0f, 0.0f};
        GameBase.G_SetMovedir(self.s.angles, self.movedir);
        self.movetype = 2;
        self.solid = 3;
        GameBase.gi.setmodel(self, self.model);
        switch (self.sounds) {
            default: {
                break;
            }
            case 1: {
                self.moveinfo.sound_start = GameBase.gi.soundindex("world/mov_watr.wav");
                self.moveinfo.sound_end = GameBase.gi.soundindex("world/stp_watr.wav");
                break;
            }
            case 2: {
                self.moveinfo.sound_start = GameBase.gi.soundindex("world/mov_watr.wav");
                self.moveinfo.sound_end = GameBase.gi.soundindex("world/stp_watr.wav");
            }
        }
        Math3D.VectorCopy(self.s.origin, self.pos1);
        abs_movedir[0] = Math.abs(self.movedir[0]);
        abs_movedir[1] = Math.abs(self.movedir[1]);
        abs_movedir[2] = Math.abs(self.movedir[2]);
        self.moveinfo.distance = abs_movedir[0] * self.size[0] + abs_movedir[1] * self.size[1] + abs_movedir[2] * self.size[2] - (float)GameBase.st.lip;
        Math3D.VectorMA(self.pos1, self.moveinfo.distance, self.movedir, self.pos2);
        if ((self.spawnflags & 1) != 0) {
            Math3D.VectorCopy(self.pos2, self.s.origin);
            Math3D.VectorCopy(self.pos1, self.pos2);
            Math3D.VectorCopy(self.s.origin, self.pos1);
        }
        Math3D.VectorCopy(self.pos1, self.moveinfo.start_origin);
        Math3D.VectorCopy(self.s.angles, self.moveinfo.start_angles);
        Math3D.VectorCopy(self.pos2, self.moveinfo.end_origin);
        Math3D.VectorCopy(self.s.angles, self.moveinfo.end_angles);
        self.moveinfo.state = 1;
        if (0.0f == self.speed) {
            self.speed = 25.0f;
        }
        self.moveinfo.decel = self.moveinfo.speed = self.speed;
        self.moveinfo.accel = self.moveinfo.speed;
        if (0.0f == self.wait) {
            self.wait = -1.0f;
        }
        self.moveinfo.wait = self.wait;
        self.use = door_use;
        if (self.wait == -1.0f) {
            self.spawnflags |= 0x20;
        }
        self.classname = "func_door";
        GameBase.gi.linkentity(self);
    }

    static void train_resume(edict_t self) {
        float[] dest = new float[]{0.0f, 0.0f, 0.0f};
        edict_t ent = self.target_ent;
        Math3D.VectorSubtract(ent.s.origin, self.mins, dest);
        self.moveinfo.state = 0;
        Math3D.VectorCopy(self.s.origin, self.moveinfo.start_origin);
        Math3D.VectorCopy(dest, self.moveinfo.end_origin);
        GameFunc.Move_Calc(self, dest, train_wait);
        self.spawnflags |= 1;
    }

    static void SP_func_train(edict_t self) {
        self.movetype = 2;
        Math3D.VectorClear(self.s.angles);
        self.blocked = train_blocked;
        if ((self.spawnflags & 4) != 0) {
            self.dmg = 0;
        } else if (0 == self.dmg) {
            self.dmg = 100;
        }
        self.solid = 3;
        GameBase.gi.setmodel(self, self.model);
        if (GameBase.st.noise != null) {
            self.moveinfo.sound_middle = GameBase.gi.soundindex(GameBase.st.noise);
        }
        if (0.0f == self.speed) {
            self.speed = 100.0f;
        }
        self.moveinfo.accel = self.moveinfo.decel = (self.moveinfo.speed = self.speed);
        self.use = train_use;
        GameBase.gi.linkentity(self);
        if (self.target != null) {
            self.nextthink = GameBase.level.time + 0.1f;
            self.think = func_train_find;
        } else {
            GameBase.gi.dprintf("func_train without a target at " + Lib.vtos(self.absmin) + "\n");
        }
    }

    static void SP_func_timer(edict_t self) {
        if (0.0f == self.wait) {
            self.wait = 1.0f;
        }
        self.use = func_timer_use;
        self.think = func_timer_think;
        if (self.random >= self.wait) {
            self.random = self.wait - 0.1f;
            GameBase.gi.dprintf("func_timer at " + Lib.vtos(self.s.origin) + " has random >= wait\n");
        }
        if ((self.spawnflags & 1) != 0) {
            self.nextthink = GameBase.level.time + 1.0f + GameBase.st.pausetime + self.delay + self.wait + Lib.crandom() * self.random;
            self.activator = self;
        }
        self.svflags = 1;
    }
}

