/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.EdictIterator;
import jake2.game.GameBase;
import jake2.game.GameItems;
import jake2.game.GameUtil;
import jake2.game.Monster;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.game.gitem_armor_t;
import jake2.game.gitem_t;
import jake2.game.trace_t;
import jake2.qcommon.Com;
import jake2.util.Math3D;

public class GameCombat {
    static boolean CanDamage(edict_t targ, edict_t inflictor) {
        float[] dest = new float[]{0.0f, 0.0f, 0.0f};
        if (targ.movetype == 2) {
            Math3D.VectorAdd(targ.absmin, targ.absmax, dest);
            Math3D.VectorScale(dest, 0.5f, dest);
            trace_t trace = GameBase.gi.trace(inflictor.s.origin, Globals.vec3_origin, Globals.vec3_origin, dest, inflictor, 3);
            if (trace.fraction == 1.0f) {
                return true;
            }
            return trace.ent == targ;
        }
        trace_t trace = GameBase.gi.trace(inflictor.s.origin, Globals.vec3_origin, Globals.vec3_origin, targ.s.origin, inflictor, 3);
        if ((double)trace.fraction == 1.0) {
            return true;
        }
        Math3D.VectorCopy(targ.s.origin, dest);
        dest[0] = (float)((double)dest[0] + 15.0);
        dest[1] = (float)((double)dest[1] + 15.0);
        trace = GameBase.gi.trace(inflictor.s.origin, Globals.vec3_origin, Globals.vec3_origin, dest, inflictor, 3);
        if ((double)trace.fraction == 1.0) {
            return true;
        }
        Math3D.VectorCopy(targ.s.origin, dest);
        dest[0] = (float)((double)dest[0] + 15.0);
        dest[1] = (float)((double)dest[1] - 15.0);
        trace = GameBase.gi.trace(inflictor.s.origin, Globals.vec3_origin, Globals.vec3_origin, dest, inflictor, 3);
        if ((double)trace.fraction == 1.0) {
            return true;
        }
        Math3D.VectorCopy(targ.s.origin, dest);
        dest[0] = (float)((double)dest[0] - 15.0);
        dest[1] = (float)((double)dest[1] + 15.0);
        trace = GameBase.gi.trace(inflictor.s.origin, Globals.vec3_origin, Globals.vec3_origin, dest, inflictor, 3);
        if ((double)trace.fraction == 1.0) {
            return true;
        }
        Math3D.VectorCopy(targ.s.origin, dest);
        dest[0] = (float)((double)dest[0] - 15.0);
        dest[1] = (float)((double)dest[1] - 15.0);
        trace = GameBase.gi.trace(inflictor.s.origin, Globals.vec3_origin, Globals.vec3_origin, dest, inflictor, 3);
        return (double)trace.fraction == 1.0;
    }

    public static void Killed(edict_t targ, edict_t inflictor, edict_t attacker, int damage, float[] point) {
        Com.DPrintf("Killing a " + targ.classname + "\n");
        if (targ.health < -999) {
            targ.health = -999;
        }
        targ.enemy = attacker;
        if ((targ.svflags & 4) != 0 && targ.deadflag != 2 && 0 == (targ.monsterinfo.aiflags & 0x100)) {
            ++GameBase.level.killed_monsters;
            if (GameBase.coop.value != 0.0f && attacker.client != null) {
                ++attacker.client.resp.score;
            }
            if (attacker.classname.equals("monster_medic")) {
                targ.owner = attacker;
            }
        }
        if (targ.movetype == 2 || targ.movetype == 3 || targ.movetype == 0) {
            targ.die.die(targ, inflictor, attacker, damage, point);
            return;
        }
        if ((targ.svflags & 4) != 0 && targ.deadflag != 2) {
            targ.touch = null;
            Monster.monster_death_use(targ);
        }
        targ.die.die(targ, inflictor, attacker, damage, point);
    }

    static void SpawnDamage(int type, float[] origin, float[] normal, int damage) {
        if (damage > 255) {
            damage = 255;
        }
        GameBase.gi.WriteByte(3);
        GameBase.gi.WriteByte(type);
        GameBase.gi.WritePosition(origin);
        GameBase.gi.WriteDir(normal);
        GameBase.gi.multicast(origin, 2);
    }

    static int CheckPowerArmor(edict_t ent, float[] point, float[] normal, int damage, int dflags) {
        int pa_te_type;
        int damagePerCell;
        int power_armor_type;
        int index = 0;
        int power = 0;
        if (damage == 0) {
            return 0;
        }
        gclient_t client = ent.client;
        if ((dflags & 2) != 0) {
            return 0;
        }
        if (client != null) {
            power_armor_type = GameItems.PowerArmorType(ent);
            if (power_armor_type != 0) {
                index = GameItems.ITEM_INDEX(GameItems.FindItem("Cells"));
                power = client.pers.inventory[index];
            }
        } else if ((ent.svflags & 4) != 0) {
            power_armor_type = ent.monsterinfo.power_armor_type;
            power = ent.monsterinfo.power_armor_power;
        } else {
            return 0;
        }
        if (power_armor_type == 0) {
            return 0;
        }
        if (power == 0) {
            return 0;
        }
        if (power_armor_type == 1) {
            float[] vec = new float[]{0.0f, 0.0f, 0.0f};
            float[] forward = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.AngleVectors(ent.s.angles, forward, null, null);
            Math3D.VectorSubtract(point, ent.s.origin, vec);
            Math3D.VectorNormalize(vec);
            float dot = Math3D.DotProduct(vec, forward);
            if ((double)dot <= 0.3) {
                return 0;
            }
            damagePerCell = 1;
            pa_te_type = 12;
            damage /= 3;
        } else {
            damagePerCell = 2;
            pa_te_type = 13;
            damage = 2 * damage / 3;
        }
        int save = power * damagePerCell;
        if (save == 0) {
            return 0;
        }
        if (save > damage) {
            save = damage;
        }
        GameCombat.SpawnDamage(pa_te_type, point, normal, save);
        ent.powerarmor_time = GameBase.level.time + 0.2f;
        int power_used = save / damagePerCell;
        if (client != null) {
            int n = index;
            client.pers.inventory[n] = client.pers.inventory[n] - power_used;
        } else {
            ent.monsterinfo.power_armor_power -= power_used;
        }
        return save;
    }

    static int CheckArmor(edict_t ent, float[] point, float[] normal, int damage, int te_sparks, int dflags) {
        if (damage == 0) {
            return 0;
        }
        gclient_t client = ent.client;
        if (client == null) {
            return 0;
        }
        if ((dflags & 2) != 0) {
            return 0;
        }
        int index = GameItems.ArmorIndex(ent);
        if (index == 0) {
            return 0;
        }
        gitem_t armor = GameItems.GetItemByIndex(index);
        gitem_armor_t garmor = armor.info;
        int save = 0 != (dflags & 4) ? (int)Math.ceil(garmor.energy_protection * (float)damage) : (int)Math.ceil(garmor.normal_protection * (float)damage);
        if (save >= client.pers.inventory[index]) {
            save = client.pers.inventory[index];
        }
        if (save == 0) {
            return 0;
        }
        int n = index;
        client.pers.inventory[n] = client.pers.inventory[n] - save;
        GameCombat.SpawnDamage(te_sparks, point, normal, save);
        return save;
    }

    public static void M_ReactToDamage(edict_t targ, edict_t attacker) {
        if (null != attacker.client && 0 != (attacker.svflags & 4)) {
            return;
        }
        if (attacker == targ || attacker == targ.enemy) {
            return;
        }
        if (0 != (targ.monsterinfo.aiflags & 0x100) && (attacker.client != null || (attacker.monsterinfo.aiflags & 0x100) != 0)) {
            return;
        }
        if (attacker.client != null) {
            targ.monsterinfo.aiflags &= 0xFFFFFFFB;
            if (targ.enemy != null && targ.enemy.client != null) {
                if (GameUtil.visible(targ, targ.enemy)) {
                    targ.oldenemy = attacker;
                    return;
                }
                targ.oldenemy = targ.enemy;
            }
            targ.enemy = attacker;
            if (0 == (targ.monsterinfo.aiflags & 0x800)) {
                GameUtil.FoundTarget(targ);
            }
            return;
        }
        if (!((targ.flags & 3) != (attacker.flags & 3) || targ.classname.equals(attacker.classname) || attacker.classname.equals("monster_tank") || attacker.classname.equals("monster_supertank") || attacker.classname.equals("monster_makron") || attacker.classname.equals("monster_jorg"))) {
            if (targ.enemy != null && targ.enemy.client != null) {
                targ.oldenemy = targ.enemy;
            }
            targ.enemy = attacker;
            if (0 == (targ.monsterinfo.aiflags & 0x800)) {
                GameUtil.FoundTarget(targ);
            }
        } else if (attacker.enemy == targ) {
            if (targ.enemy != null && targ.enemy.client != null) {
                targ.oldenemy = targ.enemy;
            }
            targ.enemy = attacker;
            if (0 == (targ.monsterinfo.aiflags & 0x800)) {
                GameUtil.FoundTarget(targ);
            }
        } else if (attacker.enemy != null && attacker.enemy != targ) {
            if (targ.enemy != null && targ.enemy.client != null) {
                targ.oldenemy = targ.enemy;
            }
            targ.enemy = attacker.enemy;
            if (0 == (targ.monsterinfo.aiflags & 0x800)) {
                GameUtil.FoundTarget(targ);
            }
        }
    }

    static boolean CheckTeamDamage(edict_t targ, edict_t attacker) {
        return false;
    }

    static void T_RadiusDamage(edict_t inflictor, edict_t attacker, float damage, edict_t ignore, float radius, int mod) {
        EdictIterator edictit = null;
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        while ((edictit = GameBase.findradius(edictit, inflictor.s.origin, radius)) != null) {
            edict_t ent = edictit.o;
            if (ent == ignore || ent.takedamage == 0) continue;
            Math3D.VectorAdd(ent.mins, ent.maxs, v);
            Math3D.VectorMA(ent.s.origin, 0.5f, v, v);
            Math3D.VectorSubtract(inflictor.s.origin, v, v);
            float points = damage - 0.5f * Math3D.VectorLength(v);
            if (ent == attacker) {
                points *= 0.5f;
            }
            if (!(points > 0.0f) || !GameCombat.CanDamage(ent, inflictor)) continue;
            Math3D.VectorSubtract(ent.s.origin, inflictor.s.origin, dir);
            GameCombat.T_Damage(ent, inflictor, attacker, dir, inflictor.s.origin, Globals.vec3_origin, (int)points, (int)points, 1, mod);
        }
    }

    public static void T_Damage(edict_t targ, edict_t inflictor, edict_t attacker, float[] dir, float[] point, float[] normal, int damage, int knockback, int dflags, int mod) {
        if (targ.takedamage == 0) {
            return;
        }
        if (targ != attacker && (GameBase.deathmatch.value != 0.0f && 0 != ((int)GameBase.dmflags.value & 0xC0) || GameBase.coop.value != 0.0f) && GameUtil.OnSameTeam(targ, attacker)) {
            if (((int)GameBase.dmflags.value & 0x100) != 0) {
                damage = 0;
            } else {
                mod |= 0x8000000;
            }
        }
        GameBase.meansOfDeath = mod;
        if (GameBase.skill.value == 0.0f && GameBase.deathmatch.value == 0.0f && targ.client != null && (damage = (int)((double)damage * 0.5)) == 0) {
            damage = 1;
        }
        gclient_t client = targ.client;
        int te_sparks = (dflags & 0x10) != 0 ? 14 : 9;
        Math3D.VectorNormalize(dir);
        if (0 == (dflags & 1) && (targ.svflags & 4) != 0 && attacker.client != null && targ.enemy == null && targ.health > 0) {
            damage *= 2;
        }
        if ((targ.flags & 0x800) != 0) {
            knockback = 0;
        }
        if (0 == (dflags & 8) && knockback != 0 && targ.movetype != 0 && targ.movetype != 9 && targ.movetype != 2 && targ.movetype != 3) {
            float[] kvel = new float[]{0.0f, 0.0f, 0.0f};
            float mass = targ.mass < 50 ? 50.0f : (float)targ.mass;
            if (targ.client != null && attacker == targ) {
                Math3D.VectorScale(dir, 1600.0f * (float)knockback / mass, kvel);
            } else {
                Math3D.VectorScale(dir, 500.0f * (float)knockback / mass, kvel);
            }
            Math3D.VectorAdd(targ.velocity, kvel, targ.velocity);
        }
        int take = damage;
        int save = 0;
        if ((targ.flags & 0x10) != 0 && 0 == (dflags & 0x20)) {
            take = 0;
            save = damage;
            GameCombat.SpawnDamage(te_sparks, point, normal, save);
        }
        if (client != null && client.invincible_framenum > (float)GameBase.level.framenum && 0 == (dflags & 0x20)) {
            if (targ.pain_debounce_time < GameBase.level.time) {
                GameBase.gi.sound(targ, 3, GameBase.gi.soundindex("items/protect4.wav"), 1.0f, 1.0f, 0.0f);
                targ.pain_debounce_time = GameBase.level.time + 2.0f;
            }
            take = 0;
            save = damage;
        }
        int psave = GameCombat.CheckPowerArmor(targ, point, normal, take, dflags);
        int asave = GameCombat.CheckArmor(targ, point, normal, take -= psave, te_sparks, dflags);
        take -= asave;
        asave += save;
        if (0 == (dflags & 0x20) && GameCombat.CheckTeamDamage(targ, attacker)) {
            return;
        }
        if (take != 0) {
            if (0 != (targ.svflags & 4) || client != null) {
                GameCombat.SpawnDamage(1, point, normal, take);
            } else {
                GameCombat.SpawnDamage(te_sparks, point, normal, take);
            }
            targ.health -= take;
            if (targ.health <= 0) {
                if ((targ.svflags & 4) != 0 || client != null) {
                    targ.flags |= 0x800;
                }
                GameCombat.Killed(targ, inflictor, attacker, take, point);
                return;
            }
        }
        if ((targ.svflags & 4) != 0) {
            GameCombat.M_ReactToDamage(targ, attacker);
            if (0 == (targ.monsterinfo.aiflags & 0x800) && take != 0) {
                targ.pain.pain(targ, attacker, knockback, take);
                if (GameBase.skill.value == 3.0f) {
                    targ.pain_debounce_time = GameBase.level.time + 5.0f;
                }
            }
        } else if (client != null) {
            if ((targ.flags & 0x10) == 0 && take != 0) {
                targ.pain.pain(targ, attacker, knockback, take);
            }
        } else if (take != 0 && targ.pain != null) {
            targ.pain.pain(targ, attacker, knockback, take);
        }
        if (client != null) {
            client.damage_parmor += psave;
            client.damage_armor += asave;
            client.damage_blood += take;
            client.damage_knockback += knockback;
            Math3D.VectorCopy(point, client.damage_from);
        }
    }
}

