/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.GameBase;
import jake2.game.edict_t;
import jake2.game.trace_t;
import jake2.server.SV_WORLD;
import jake2.util.Math3D;

public class GameChase {
    public static void UpdateChaseCam(edict_t ent) {
        float[] o = new float[]{0.0f, 0.0f, 0.0f};
        float[] ownerv = new float[]{0.0f, 0.0f, 0.0f};
        float[] goal = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] oldgoal = new float[]{0.0f, 0.0f, 0.0f};
        float[] angles = new float[]{0.0f, 0.0f, 0.0f};
        if (!ent.client.chase_target.inuse || ent.client.chase_target.client.resp.spectator) {
            edict_t old = ent.client.chase_target;
            GameChase.ChaseNext(ent);
            if (ent.client.chase_target == old) {
                ent.client.chase_target = null;
                ent.client.ps.pmove.pm_flags = (byte)(ent.client.ps.pmove.pm_flags & 0xFFFFFFBF);
                return;
            }
        }
        edict_t targ = ent.client.chase_target;
        Math3D.VectorCopy(targ.s.origin, ownerv);
        Math3D.VectorCopy(ent.s.origin, oldgoal);
        ownerv[2] = ownerv[2] + (float)targ.viewheight;
        Math3D.VectorCopy(targ.client.v_angle, angles);
        if (angles[0] > 56.0f) {
            angles[0] = 56.0f;
        }
        Math3D.AngleVectors(angles, forward, right, null);
        Math3D.VectorNormalize(forward);
        Math3D.VectorMA(ownerv, -30.0f, forward, o);
        if (o[2] < targ.s.origin[2] + 20.0f) {
            o[2] = targ.s.origin[2] + 20.0f;
        }
        if (targ.groundentity == null) {
            o[2] = o[2] + 16.0f;
        }
        trace_t trace = GameBase.gi.trace(ownerv, Globals.vec3_origin, Globals.vec3_origin, o, targ, 3);
        Math3D.VectorCopy(trace.endpos, goal);
        Math3D.VectorMA(goal, 2.0f, forward, goal);
        Math3D.VectorCopy(goal, o);
        o[2] = o[2] + 6.0f;
        trace = GameBase.gi.trace(goal, Globals.vec3_origin, Globals.vec3_origin, o, targ, 3);
        if (trace.fraction < 1.0f) {
            Math3D.VectorCopy(trace.endpos, goal);
            goal[2] = goal[2] - 6.0f;
        }
        Math3D.VectorCopy(goal, o);
        o[2] = o[2] - 6.0f;
        trace = GameBase.gi.trace(goal, Globals.vec3_origin, Globals.vec3_origin, o, targ, 3);
        if (trace.fraction < 1.0f) {
            Math3D.VectorCopy(trace.endpos, goal);
            goal[2] = goal[2] + 6.0f;
        }
        ent.client.ps.pmove.pm_type = targ.deadflag != 0 ? 2 : 4;
        Math3D.VectorCopy(goal, ent.s.origin);
        for (int i = 0; i < 3; ++i) {
            ent.client.ps.pmove.delta_angles[i] = (short)Math3D.ANGLE2SHORT(targ.client.v_angle[i] - ent.client.resp.cmd_angles[i]);
        }
        if (targ.deadflag != 0) {
            ent.client.ps.viewangles[2] = 40.0f;
            ent.client.ps.viewangles[0] = -15.0f;
            ent.client.ps.viewangles[1] = targ.client.killer_yaw;
        } else {
            Math3D.VectorCopy(targ.client.v_angle, ent.client.ps.viewangles);
            Math3D.VectorCopy(targ.client.v_angle, ent.client.v_angle);
        }
        ent.viewheight = 0;
        ent.client.ps.pmove.pm_flags = (byte)(ent.client.ps.pmove.pm_flags | 0x40);
        SV_WORLD.SV_LinkEdict(ent);
    }

    public static void ChaseNext(edict_t ent) {
        edict_t e;
        if (null == ent.client.chase_target) {
            return;
        }
        int i = ent.client.chase_target.index;
        do {
            if ((float)(++i) > GameBase.maxclients.value) {
                i = 1;
            }
            e = GameBase.g_edicts[i];
        } while ((!e.inuse || e.client.resp.spectator) && e != ent.client.chase_target);
        ent.client.chase_target = e;
        ent.client.update_chase = true;
    }

    public static void ChasePrev(edict_t ent) {
        edict_t e;
        if (ent.client.chase_target == null) {
            return;
        }
        int i = ent.client.chase_target.index;
        do {
            if (--i < 1) {
                i = (int)GameBase.maxclients.value;
            }
            e = GameBase.g_edicts[i];
        } while ((!e.inuse || e.client.resp.spectator) && e != ent.client.chase_target);
        ent.client.chase_target = e;
        ent.client.update_chase = true;
    }

    public static void GetChaseTarget(edict_t ent) {
        int i = 1;
        while ((float)i <= GameBase.maxclients.value) {
            edict_t other = GameBase.g_edicts[i];
            if (other.inuse && !other.client.resp.spectator) {
                ent.client.chase_target = other;
                ent.client.update_chase = true;
                GameChase.UpdateChaseCam(ent);
                return;
            }
            ++i;
        }
        GameBase.gi.centerprintf(ent, "No other players to chase.");
    }
}

