/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.client.M;
import jake2.game.EdictFindFilter;
import jake2.game.EdictIterator;
import jake2.game.GameAI;
import jake2.game.GameUtil;
import jake2.game.PlayerClient;
import jake2.game.PlayerHud;
import jake2.game.PlayerView;
import jake2.game.cplane_t;
import jake2.game.cvar_t;
import jake2.game.edict_t;
import jake2.game.game_import_t;
import jake2.game.game_locals_t;
import jake2.game.gclient_t;
import jake2.game.level_locals_t;
import jake2.game.pmove_t;
import jake2.game.pushed_t;
import jake2.game.spawn_temp_t;
import jake2.qcommon.Com;
import jake2.server.SV;
import jake2.server.SV_WORLD;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.util.StringTokenizer;

public class GameBase {
    public static cplane_t dummyplane;
    public static game_locals_t game;
    public static level_locals_t level;
    public static game_import_t gi;
    public static spawn_temp_t st;
    public static int sm_meat_index;
    public static int snd_fry;
    public static int meansOfDeath;
    public static int num_edicts;
    public static edict_t[] g_edicts;
    public static cvar_t deathmatch;
    public static cvar_t coop;
    public static cvar_t dmflags;
    public static cvar_t skill;
    public static cvar_t fraglimit;
    public static cvar_t timelimit;
    public static cvar_t password;
    public static cvar_t spectator_password;
    public static cvar_t needpass;
    public static cvar_t maxclients;
    public static cvar_t maxspectators;
    public static cvar_t maxentities;
    public static cvar_t g_select_empty;
    public static cvar_t filterban;
    public static cvar_t sv_maxvelocity;
    public static cvar_t sv_gravity;
    public static cvar_t sv_rollspeed;
    public static cvar_t sv_rollangle;
    public static cvar_t gun_x;
    public static cvar_t gun_y;
    public static cvar_t gun_z;
    public static cvar_t run_pitch;
    public static cvar_t run_roll;
    public static cvar_t bob_up;
    public static cvar_t bob_pitch;
    public static cvar_t bob_roll;
    public static cvar_t sv_cheats;
    public static cvar_t flood_msgs;
    public static cvar_t flood_persecond;
    public static cvar_t flood_waitdelay;
    public static cvar_t sv_maplist;
    public static final float STOP_EPSILON = 0.1f;
    public static int MAXCHOICES;
    public static float[] VEC_UP;
    public static float[] MOVEDIR_UP;
    public static float[] VEC_DOWN;
    public static float[] MOVEDIR_DOWN;
    static edict_t[] touch;
    public static pushed_t[] pushed;
    public static int pushed_p;
    public static edict_t obstacle;
    public static int c_yes;
    public static int c_no;
    public static int STEPSIZE;
    public static EdictFindFilter findByTarget;
    public static EdictFindFilter findByClass;

    public static int ClipVelocity(float[] in, float[] normal, float[] out, float overbounce) {
        int blocked = 0;
        if (normal[2] > 0.0f) {
            blocked |= 1;
        }
        if (normal[2] == 0.0f) {
            blocked |= 2;
        }
        float backoff = Math3D.DotProduct(in, normal) * overbounce;
        for (int i = 0; i < 3; ++i) {
            float change = normal[i] * backoff;
            out[i] = in[i] - change;
            if (!(out[i] > -0.1f) || !(out[i] < 0.1f)) continue;
            out[i] = 0.0f;
        }
        return blocked;
    }

    public static EdictIterator G_Find(EdictIterator from, EdictFindFilter eff, String s) {
        if (from == null) {
            from = new EdictIterator(0);
        } else {
            ++from.i;
        }
        while (from.i < num_edicts) {
            from.o = g_edicts[from.i];
            if (from.o.classname == null) {
                Com.Printf("edict with classname = null" + from.o.index);
            }
            if (from.o.inuse && eff.matches(from.o, s)) {
                return from;
            }
            ++from.i;
        }
        return null;
    }

    public static edict_t G_FindEdict(EdictIterator from, EdictFindFilter eff, String s) {
        EdictIterator ei = GameBase.G_Find(from, eff, s);
        if (ei == null) {
            return null;
        }
        return ei.o;
    }

    public static EdictIterator findradius(EdictIterator from, float[] org, float rad) {
        float[] eorg = new float[]{0.0f, 0.0f, 0.0f};
        if (from == null) {
            from = new EdictIterator(0);
        } else {
            ++from.i;
        }
        while (from.i < num_edicts) {
            from.o = g_edicts[from.i];
            if (from.o.inuse && from.o.solid != 0) {
                for (int j = 0; j < 3; ++j) {
                    eorg[j] = org[j] - (from.o.s.origin[j] + (from.o.mins[j] + from.o.maxs[j]) * 0.5f);
                }
                if (!(Math3D.VectorLength(eorg) > rad)) {
                    return from;
                }
            }
            ++from.i;
        }
        return null;
    }

    public static edict_t G_PickTarget(String targetname) {
        int num_choices = 0;
        edict_t[] choice = new edict_t[MAXCHOICES];
        if (targetname == null) {
            gi.dprintf("G_PickTarget called with null targetname\n");
            return null;
        }
        EdictIterator es = null;
        while ((es = GameBase.G_Find(es, findByTarget, targetname)) != null) {
            choice[num_choices++] = es.o;
            if (num_choices != MAXCHOICES) continue;
        }
        if (num_choices == 0) {
            gi.dprintf("G_PickTarget: target " + targetname + " not found\n");
            return null;
        }
        return choice[Lib.rand() % num_choices];
    }

    public static void G_SetMovedir(float[] angles, float[] movedir) {
        if (Math3D.VectorEquals(angles, VEC_UP)) {
            Math3D.VectorCopy(MOVEDIR_UP, movedir);
        } else if (Math3D.VectorEquals(angles, VEC_DOWN)) {
            Math3D.VectorCopy(MOVEDIR_DOWN, movedir);
        } else {
            Math3D.AngleVectors(angles, movedir, null, null);
        }
        Math3D.VectorClear(angles);
    }

    public static String G_CopyString(String in) {
        return new String(in);
    }

    public static void G_TouchTriggers(edict_t ent) {
        if ((ent.client != null || (ent.svflags & 4) != 0) && ent.health <= 0) {
            return;
        }
        int num = gi.BoxEdicts(ent.absmin, ent.absmax, touch, 1024, 2);
        for (int i = 0; i < num; ++i) {
            edict_t hit = touch[i];
            if (!hit.inuse || hit.touch == null) continue;
            hit.touch.touch(hit, ent, dummyplane, null);
        }
    }

    public static void G_RunEntity(edict_t ent) {
        if (ent.prethink != null) {
            ent.prethink.think(ent);
        }
        switch (ent.movetype) {
            case 2: 
            case 3: {
                SV.SV_Physics_Pusher(ent);
                break;
            }
            case 0: {
                SV.SV_Physics_None(ent);
                break;
            }
            case 1: {
                SV.SV_Physics_Noclip(ent);
                break;
            }
            case 5: {
                SV.SV_Physics_Step(ent);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                SV.SV_Physics_Toss(ent);
                break;
            }
            default: {
                gi.error("SV_Physics: bad movetype " + ent.movetype);
            }
        }
    }

    public static void ClearBounds(float[] mins, float[] maxs) {
        mins[2] = 99999.0f;
        mins[1] = 99999.0f;
        mins[0] = 99999.0f;
        maxs[2] = -99999.0f;
        maxs[1] = -99999.0f;
        maxs[0] = -99999.0f;
    }

    public static void AddPointToBounds(float[] v, float[] mins, float[] maxs) {
        for (int i = 0; i < 3; ++i) {
            float val = v[i];
            if (val < mins[i]) {
                mins[i] = val;
            }
            if (!(val > maxs[i])) continue;
            maxs[i] = val;
        }
    }

    public static void ShutdownGame() {
        gi.dprintf("==== ShutdownGame ====\n");
    }

    public static void ClientEndServerFrames() {
        int i = 0;
        while ((float)i < GameBase.maxclients.value) {
            edict_t ent = g_edicts[1 + i];
            if (ent.inuse && null != ent.client) {
                PlayerView.ClientEndServerFrame(ent);
            }
            ++i;
        }
    }

    public static edict_t CreateTargetChangeLevel(String map) {
        edict_t ent = GameUtil.G_Spawn();
        ent.classname = "target_changelevel";
        ent.map = GameBase.level.nextmap = map;
        return ent;
    }

    public static void EndDMLevel() {
        String seps = " ,\n\r";
        if (((int)GameBase.dmflags.value & 0x20) != 0) {
            PlayerHud.BeginIntermission(GameBase.CreateTargetChangeLevel(GameBase.level.mapname));
            return;
        }
        if (GameBase.sv_maplist.string.length() > 0) {
            String s = GameBase.sv_maplist.string;
            String f = null;
            StringTokenizer tk = new StringTokenizer(s, seps);
            while (tk.hasMoreTokens()) {
                String t = tk.nextToken();
                if (f == null) {
                    f = t;
                }
                if (!t.equalsIgnoreCase(GameBase.level.mapname)) continue;
                if (!tk.hasMoreTokens()) {
                    if (f == null) {
                        PlayerHud.BeginIntermission(GameBase.CreateTargetChangeLevel(GameBase.level.mapname));
                    } else {
                        PlayerHud.BeginIntermission(GameBase.CreateTargetChangeLevel(f));
                    }
                } else {
                    PlayerHud.BeginIntermission(GameBase.CreateTargetChangeLevel(tk.nextToken()));
                }
                return;
            }
        }
        if (GameBase.level.nextmap.length() > 0) {
            PlayerHud.BeginIntermission(GameBase.CreateTargetChangeLevel(GameBase.level.nextmap));
        } else {
            EdictIterator edit = null;
            if ((edit = GameBase.G_Find(edit, findByClass, "target_changelevel")) == null) {
                PlayerHud.BeginIntermission(GameBase.CreateTargetChangeLevel(GameBase.level.mapname));
                return;
            }
            edict_t ent = edit.o;
            PlayerHud.BeginIntermission(ent);
        }
    }

    public static void CheckNeedPass() {
        if (GameBase.password.modified || GameBase.spectator_password.modified) {
            GameBase.spectator_password.modified = false;
            GameBase.password.modified = false;
            int need = 0;
            if (GameBase.password.string.length() > 0 && 0 != Lib.Q_stricmp(GameBase.password.string, "none")) {
                need |= 1;
            }
            if (GameBase.spectator_password.string.length() > 0 && 0 != Lib.Q_stricmp(GameBase.spectator_password.string, "none")) {
                need |= 2;
            }
            gi.cvar_set("needpass", "" + need);
        }
    }

    public static void CheckDMRules() {
        if (GameBase.level.intermissiontime != 0.0f) {
            return;
        }
        if (0.0f == GameBase.deathmatch.value) {
            return;
        }
        if (GameBase.timelimit.value != 0.0f && GameBase.level.time >= GameBase.timelimit.value * 60.0f) {
            gi.bprintf(2, "Timelimit hit.\n");
            GameBase.EndDMLevel();
            return;
        }
        if (GameBase.fraglimit.value != 0.0f) {
            int i = 0;
            while ((float)i < GameBase.maxclients.value) {
                gclient_t cl = GameBase.game.clients[i];
                if (GameBase.g_edicts[i + 1].inuse && (float)cl.resp.score >= GameBase.fraglimit.value) {
                    gi.bprintf(2, "Fraglimit hit.\n");
                    GameBase.EndDMLevel();
                    return;
                }
                ++i;
            }
        }
    }

    public static void ExitLevel() {
        String command = "gamemap \"" + GameBase.level.changemap + "\"\n";
        gi.AddCommandString(command);
        GameBase.level.changemap = null;
        GameBase.level.exitintermission = false;
        GameBase.level.intermissiontime = 0.0f;
        GameBase.ClientEndServerFrames();
        int i = 0;
        while ((float)i < GameBase.maxclients.value) {
            edict_t ent = g_edicts[1 + i];
            if (ent.inuse && ent.health > ent.client.pers.max_health) {
                ent.health = ent.client.pers.max_health;
            }
            ++i;
        }
    }

    public static void G_RunFrame() {
        ++GameBase.level.framenum;
        GameBase.level.time = (float)GameBase.level.framenum * 0.1f;
        GameAI.AI_SetSightClient();
        if (GameBase.level.exitintermission) {
            GameBase.ExitLevel();
            return;
        }
        for (int i = 0; i < num_edicts; ++i) {
            edict_t ent = g_edicts[i];
            if (!ent.inuse) continue;
            GameBase.level.current_entity = ent;
            Math3D.VectorCopy(ent.s.origin, ent.s.old_origin);
            if (ent.groundentity != null && ent.groundentity.linkcount != ent.groundentity_linkcount) {
                ent.groundentity = null;
                if (0 == (ent.flags & 3) && (ent.svflags & 4) != 0) {
                    M.M_CheckGround(ent);
                }
            }
            if (i > 0 && (float)i <= GameBase.maxclients.value) {
                PlayerClient.ClientBeginServerFrame(ent);
                continue;
            }
            GameBase.G_RunEntity(ent);
        }
        GameBase.CheckDMRules();
        GameBase.CheckNeedPass();
        GameBase.ClientEndServerFrames();
    }

    public static void GetGameApi(game_import_t imp) {
        gi = imp;
        GameBase.gi.pointcontents = new pmove_t.PointContentsAdapter(){

            public int pointcontents(float[] o) {
                return SV_WORLD.SV_PointContents(o);
            }
        };
    }

    static {
        int n;
        dummyplane = new cplane_t();
        game = new game_locals_t();
        level = new level_locals_t();
        gi = new game_import_t();
        st = new spawn_temp_t();
        g_edicts = new edict_t[1024];
        for (n = 0; n < 1024; ++n) {
            GameBase.g_edicts[n] = new edict_t(n);
        }
        deathmatch = new cvar_t();
        coop = new cvar_t();
        dmflags = new cvar_t();
        fraglimit = new cvar_t();
        timelimit = new cvar_t();
        password = new cvar_t();
        spectator_password = new cvar_t();
        needpass = new cvar_t();
        maxclients = new cvar_t();
        maxspectators = new cvar_t();
        maxentities = new cvar_t();
        g_select_empty = new cvar_t();
        filterban = new cvar_t();
        sv_maxvelocity = new cvar_t();
        sv_gravity = new cvar_t();
        sv_rollspeed = new cvar_t();
        sv_rollangle = new cvar_t();
        gun_x = new cvar_t();
        gun_y = new cvar_t();
        gun_z = new cvar_t();
        run_pitch = new cvar_t();
        run_roll = new cvar_t();
        bob_up = new cvar_t();
        bob_pitch = new cvar_t();
        bob_roll = new cvar_t();
        sv_cheats = new cvar_t();
        flood_msgs = new cvar_t();
        flood_persecond = new cvar_t();
        flood_waitdelay = new cvar_t();
        sv_maplist = new cvar_t();
        MAXCHOICES = 8;
        VEC_UP = new float[]{0.0f, -1.0f, 0.0f};
        MOVEDIR_UP = new float[]{0.0f, 0.0f, 1.0f};
        VEC_DOWN = new float[]{0.0f, -2.0f, 0.0f};
        MOVEDIR_DOWN = new float[]{0.0f, 0.0f, -1.0f};
        touch = new edict_t[1024];
        pushed = new pushed_t[1024];
        for (n = 0; n < 1024; ++n) {
            GameBase.pushed[n] = new pushed_t();
        }
        STEPSIZE = 18;
        findByTarget = new EdictFindFilter(){

            public boolean matches(edict_t e, String s) {
                if (e.targetname == null) {
                    return false;
                }
                return e.targetname.equalsIgnoreCase(s);
            }
        };
        findByClass = new EdictFindFilter(){

            public boolean matches(edict_t e, String s) {
                return e.classname.equalsIgnoreCase(s);
            }
        };
    }
}

