/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.client.M;
import jake2.game.AIAdapter;
import jake2.game.EntThinkAdapter;
import jake2.game.GameBase;
import jake2.game.GameUtil;
import jake2.game.Monster;
import jake2.game.PlayerTrail;
import jake2.game.edict_t;
import jake2.game.trace_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class GameAI {
    public static EntThinkAdapter walkmonster_start_go = new EntThinkAdapter(){

        public String getID() {
            return "walkmonster_start_go";
        }

        public boolean think(edict_t self) {
            if (0 == (self.spawnflags & 2) && GameBase.level.time < 1.0f) {
                M.M_droptofloor.think(self);
                if (self.groundentity != null && !M.M_walkmove(self, 0.0f, 0.0f)) {
                    GameBase.gi.dprintf(self.classname + " in solid at " + Lib.vtos(self.s.origin) + "\n");
                }
            }
            if (0.0f == self.yaw_speed) {
                self.yaw_speed = 40.0f;
            }
            self.viewheight = 25;
            Monster.monster_start_go(self);
            if ((self.spawnflags & 2) != 0) {
                Monster.monster_triggered_start.think(self);
            }
            return true;
        }
    };
    public static EntThinkAdapter walkmonster_start = new EntThinkAdapter(){

        public String getID() {
            return "walkmonster_start";
        }

        public boolean think(edict_t self) {
            self.think = walkmonster_start_go;
            Monster.monster_start(self);
            return true;
        }
    };
    public static EntThinkAdapter flymonster_start_go = new EntThinkAdapter(){

        public String getID() {
            return "flymonster_start_go";
        }

        public boolean think(edict_t self) {
            if (!M.M_walkmove(self, 0.0f, 0.0f)) {
                GameBase.gi.dprintf(self.classname + " in solid at " + Lib.vtos(self.s.origin) + "\n");
            }
            if (0.0f == self.yaw_speed) {
                self.yaw_speed = 20.0f;
            }
            self.viewheight = 25;
            Monster.monster_start_go(self);
            if ((self.spawnflags & 2) != 0) {
                Monster.monster_triggered_start.think(self);
            }
            return true;
        }
    };
    public static EntThinkAdapter flymonster_start = new EntThinkAdapter(){

        public String getID() {
            return "flymonster_start";
        }

        public boolean think(edict_t self) {
            self.flags |= 1;
            self.think = flymonster_start_go;
            Monster.monster_start(self);
            return true;
        }
    };
    public static EntThinkAdapter swimmonster_start_go = new EntThinkAdapter(){

        public String getID() {
            return "swimmonster_start_go";
        }

        public boolean think(edict_t self) {
            if (0.0f == self.yaw_speed) {
                self.yaw_speed = 20.0f;
            }
            self.viewheight = 10;
            Monster.monster_start_go(self);
            if ((self.spawnflags & 2) != 0) {
                Monster.monster_triggered_start.think(self);
            }
            return true;
        }
    };
    public static EntThinkAdapter swimmonster_start = new EntThinkAdapter(){

        public String getID() {
            return "swimmonster_start";
        }

        public boolean think(edict_t self) {
            self.flags |= 2;
            self.think = swimmonster_start_go;
            Monster.monster_start(self);
            return true;
        }
    };
    public static AIAdapter ai_turn = new AIAdapter(){

        public String getID() {
            return "ai_turn";
        }

        public void ai(edict_t self, float dist) {
            if (dist != 0.0f) {
                M.M_walkmove(self, self.s.angles[1], dist);
            }
            if (GameUtil.FindTarget(self)) {
                return;
            }
            M.M_ChangeYaw(self);
        }
    };
    public static AIAdapter ai_move = new AIAdapter(){

        public String getID() {
            return "ai_move";
        }

        public void ai(edict_t self, float dist) {
            M.M_walkmove(self, self.s.angles[1], dist);
        }
    };
    public static AIAdapter ai_walk = new AIAdapter(){

        public String getID() {
            return "ai_walk";
        }

        public void ai(edict_t self, float dist) {
            M.M_MoveToGoal(self, dist);
            if (GameUtil.FindTarget(self)) {
                return;
            }
            if (self.monsterinfo.search != null && GameBase.level.time > self.monsterinfo.idle_time) {
                if (self.monsterinfo.idle_time != 0.0f) {
                    self.monsterinfo.search.think(self);
                    self.monsterinfo.idle_time = GameBase.level.time + 15.0f + Globals.rnd.nextFloat() * 15.0f;
                } else {
                    self.monsterinfo.idle_time = GameBase.level.time + Globals.rnd.nextFloat() * 15.0f;
                }
            }
        }
    };
    public static AIAdapter ai_stand = new AIAdapter(){

        public String getID() {
            return "ai_stand";
        }

        public void ai(edict_t self, float dist) {
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            if (dist != 0.0f) {
                M.M_walkmove(self, self.s.angles[1], dist);
            }
            if ((self.monsterinfo.aiflags & 1) != 0) {
                if (self.enemy != null) {
                    Math3D.VectorSubtract(self.enemy.s.origin, self.s.origin, v);
                    self.ideal_yaw = Math3D.vectoyaw(v);
                    if (self.s.angles[1] != self.ideal_yaw && 0 != (self.monsterinfo.aiflags & 2)) {
                        self.monsterinfo.aiflags &= 0xFFFFFFFC;
                        self.monsterinfo.run.think(self);
                    }
                    M.M_ChangeYaw(self);
                    GameAI.ai_checkattack(self, 0.0f);
                } else {
                    GameUtil.FindTarget(self);
                }
                return;
            }
            if (GameUtil.FindTarget(self)) {
                return;
            }
            if (GameBase.level.time > self.monsterinfo.pausetime) {
                self.monsterinfo.walk.think(self);
                return;
            }
            if (0 == (self.spawnflags & 1) && self.monsterinfo.idle != null && GameBase.level.time > self.monsterinfo.idle_time) {
                if (self.monsterinfo.idle_time != 0.0f) {
                    self.monsterinfo.idle.think(self);
                    self.monsterinfo.idle_time = GameBase.level.time + 15.0f + Globals.rnd.nextFloat() * 15.0f;
                } else {
                    self.monsterinfo.idle_time = GameBase.level.time + Globals.rnd.nextFloat() * 15.0f;
                }
            }
        }
    };
    public static AIAdapter ai_charge = new AIAdapter(){

        public String getID() {
            return "ai_charge";
        }

        public void ai(edict_t self, float dist) {
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorSubtract(self.enemy.s.origin, self.s.origin, v);
            self.ideal_yaw = Math3D.vectoyaw(v);
            M.M_ChangeYaw(self);
            if (dist != 0.0f) {
                M.M_walkmove(self, self.s.angles[1], dist);
            }
        }
    };
    public static AIAdapter ai_run = new AIAdapter(){

        public String getID() {
            return "ai_run";
        }

        public void ai(edict_t self, float dist) {
            edict_t tempgoal;
            float[] v = new float[]{0.0f, 0.0f, 0.0f};
            float[] v_forward = new float[]{0.0f, 0.0f, 0.0f};
            float[] v_right = new float[]{0.0f, 0.0f, 0.0f};
            float[] left_target = new float[]{0.0f, 0.0f, 0.0f};
            float[] right_target = new float[]{0.0f, 0.0f, 0.0f};
            if ((self.monsterinfo.aiflags & 0x1000) != 0) {
                M.M_MoveToGoal(self, dist);
                return;
            }
            if ((self.monsterinfo.aiflags & 4) != 0) {
                Math3D.VectorSubtract(self.s.origin, self.enemy.s.origin, v);
                if (Math3D.VectorLength(v) < 64.0f) {
                    self.monsterinfo.stand.think(self);
                    self.spawnflags &= 0xFFFFFFFE;
                    self.enemy = null;
                } else {
                    M.M_MoveToGoal(self, dist);
                }
                if (!GameUtil.FindTarget(self)) {
                    return;
                }
            }
            if (GameAI.ai_checkattack(self, dist)) {
                return;
            }
            if (self.monsterinfo.attack_state == 2) {
                GameAI.ai_run_slide(self, dist);
                return;
            }
            if (enemy_vis) {
                M.M_MoveToGoal(self, dist);
                self.monsterinfo.aiflags &= 0xFFFFFFF7;
                Math3D.VectorCopy(self.enemy.s.origin, self.monsterinfo.last_sighting);
                self.monsterinfo.trail_time = GameBase.level.time;
                return;
            }
            if (GameBase.coop.value != 0.0f && GameUtil.FindTarget(self)) {
                return;
            }
            if (self.monsterinfo.search_time != 0.0f && GameBase.level.time > self.monsterinfo.search_time + 20.0f) {
                M.M_MoveToGoal(self, dist);
                self.monsterinfo.search_time = 0.0f;
                return;
            }
            edict_t save = self.goalentity;
            self.goalentity = tempgoal = GameUtil.G_Spawn();
            boolean new1 = false;
            if (0 == (self.monsterinfo.aiflags & 8)) {
                self.monsterinfo.aiflags |= 0x18;
                self.monsterinfo.aiflags &= 0xFFFFFF9F;
                new1 = true;
            }
            if ((self.monsterinfo.aiflags & 0x20) != 0) {
                edict_t marker;
                self.monsterinfo.aiflags &= 0xFFFFFFDF;
                self.monsterinfo.search_time = GameBase.level.time + 5.0f;
                if ((self.monsterinfo.aiflags & 0x40) != 0) {
                    self.monsterinfo.aiflags &= 0xFFFFFFBF;
                    marker = null;
                    Math3D.VectorCopy(self.monsterinfo.saved_goal, self.monsterinfo.last_sighting);
                    new1 = true;
                } else if ((self.monsterinfo.aiflags & 0x10) != 0) {
                    self.monsterinfo.aiflags &= 0xFFFFFFEF;
                    marker = PlayerTrail.PickFirst(self);
                } else {
                    marker = PlayerTrail.PickNext(self);
                }
                if (marker != null) {
                    Math3D.VectorCopy(marker.s.origin, self.monsterinfo.last_sighting);
                    self.monsterinfo.trail_time = marker.timestamp;
                    self.s.angles[1] = self.ideal_yaw = marker.s.angles[1];
                    new1 = true;
                }
            }
            Math3D.VectorSubtract(self.s.origin, self.monsterinfo.last_sighting, v);
            float d1 = Math3D.VectorLength(v);
            if (d1 <= dist) {
                self.monsterinfo.aiflags |= 0x20;
                dist = d1;
            }
            Math3D.VectorCopy(self.monsterinfo.last_sighting, self.goalentity.s.origin);
            if (new1) {
                trace_t tr = GameBase.gi.trace(self.s.origin, self.mins, self.maxs, self.monsterinfo.last_sighting, self, 33619971);
                if (tr.fraction < 1.0f) {
                    Math3D.VectorSubtract(self.goalentity.s.origin, self.s.origin, v);
                    d1 = Math3D.VectorLength(v);
                    float center = tr.fraction;
                    float d2 = d1 * ((center + 1.0f) / 2.0f);
                    self.s.angles[1] = self.ideal_yaw = Math3D.vectoyaw(v);
                    Math3D.AngleVectors(self.s.angles, v_forward, v_right, null);
                    Math3D.VectorSet(v, d2, -16.0f, 0.0f);
                    Math3D.G_ProjectSource(self.s.origin, v, v_forward, v_right, left_target);
                    tr = GameBase.gi.trace(self.s.origin, self.mins, self.maxs, left_target, self, 33619971);
                    float left = tr.fraction;
                    Math3D.VectorSet(v, d2, 16.0f, 0.0f);
                    Math3D.G_ProjectSource(self.s.origin, v, v_forward, v_right, right_target);
                    tr = GameBase.gi.trace(self.s.origin, self.mins, self.maxs, right_target, self, 33619971);
                    float right = tr.fraction;
                    center = d1 * center / d2;
                    if (left >= center && left > right) {
                        if (left < 1.0f) {
                            Math3D.VectorSet(v, d2 * left * 0.5f, -16.0f, 0.0f);
                            Math3D.G_ProjectSource(self.s.origin, v, v_forward, v_right, left_target);
                        }
                        Math3D.VectorCopy(self.monsterinfo.last_sighting, self.monsterinfo.saved_goal);
                        self.monsterinfo.aiflags |= 0x40;
                        Math3D.VectorCopy(left_target, self.goalentity.s.origin);
                        Math3D.VectorCopy(left_target, self.monsterinfo.last_sighting);
                        Math3D.VectorSubtract(self.goalentity.s.origin, self.s.origin, v);
                        self.s.angles[1] = self.ideal_yaw = Math3D.vectoyaw(v);
                    } else if (right >= center && right > left) {
                        if (right < 1.0f) {
                            Math3D.VectorSet(v, d2 * right * 0.5f, 16.0f, 0.0f);
                            Math3D.G_ProjectSource(self.s.origin, v, v_forward, v_right, right_target);
                        }
                        Math3D.VectorCopy(self.monsterinfo.last_sighting, self.monsterinfo.saved_goal);
                        self.monsterinfo.aiflags |= 0x40;
                        Math3D.VectorCopy(right_target, self.goalentity.s.origin);
                        Math3D.VectorCopy(right_target, self.monsterinfo.last_sighting);
                        Math3D.VectorSubtract(self.goalentity.s.origin, self.s.origin, v);
                        self.s.angles[1] = self.ideal_yaw = Math3D.vectoyaw(v);
                    }
                }
            }
            M.M_MoveToGoal(self, dist);
            GameUtil.G_FreeEdict(tempgoal);
            if (self != null) {
                self.goalentity = save;
            }
        }
    };
    static boolean enemy_vis;
    static boolean enemy_infront;
    static int enemy_range;
    static float enemy_yaw;

    public static void AttackFinished(edict_t self, float time) {
        self.monsterinfo.attack_finished = GameBase.level.time + time;
    }

    public static void ai_turn(edict_t self, float dist) {
        if (dist != 0.0f) {
            M.M_walkmove(self, self.s.angles[1], dist);
        }
        if (GameUtil.FindTarget(self)) {
            return;
        }
        M.M_ChangeYaw(self);
    }

    public static boolean FacingIdeal(edict_t self) {
        float delta = Math3D.anglemod(self.s.angles[1] - self.ideal_yaw);
        return !(delta > 45.0f) || !(delta < 315.0f);
    }

    public static void ai_run_melee(edict_t self) {
        self.ideal_yaw = enemy_yaw;
        M.M_ChangeYaw(self);
        if (GameAI.FacingIdeal(self)) {
            self.monsterinfo.melee.think(self);
            self.monsterinfo.attack_state = 1;
        }
    }

    public static void ai_run_missile(edict_t self) {
        self.ideal_yaw = enemy_yaw;
        M.M_ChangeYaw(self);
        if (GameAI.FacingIdeal(self)) {
            self.monsterinfo.attack.think(self);
            self.monsterinfo.attack_state = 1;
        }
    }

    public static void ai_run_slide(edict_t self, float distance) {
        self.ideal_yaw = enemy_yaw;
        M.M_ChangeYaw(self);
        float ofs = self.monsterinfo.lefty != 0 ? 90.0f : -90.0f;
        if (M.M_walkmove(self, self.ideal_yaw + ofs, distance)) {
            return;
        }
        self.monsterinfo.lefty = 1 - self.monsterinfo.lefty;
        M.M_walkmove(self, self.ideal_yaw - ofs, distance);
    }

    public static boolean ai_checkattack(edict_t self, float dist) {
        float[] temp = new float[]{0.0f, 0.0f, 0.0f};
        if (self.goalentity != null) {
            if ((self.monsterinfo.aiflags & 0x1000) != 0) {
                return false;
            }
            if ((self.monsterinfo.aiflags & 4) != 0) {
                if ((double)(GameBase.level.time - self.enemy.teleport_time) > 5.0) {
                    if (self.goalentity == self.enemy) {
                        self.goalentity = self.movetarget != null ? self.movetarget : null;
                    }
                    self.monsterinfo.aiflags &= 0xFFFFFFFB;
                    if ((self.monsterinfo.aiflags & 2) != 0) {
                        self.monsterinfo.aiflags &= 0xFFFFFFFC;
                    }
                } else {
                    self.show_hostile = (int)GameBase.level.time + 1;
                    return false;
                }
            }
        }
        enemy_vis = false;
        boolean hesDeadJim = false;
        if (null == self.enemy || !self.enemy.inuse) {
            hesDeadJim = true;
        } else if ((self.monsterinfo.aiflags & 0x2000) != 0) {
            if (self.enemy.health > 0) {
                hesDeadJim = true;
                self.monsterinfo.aiflags &= 0xFFFFDFFF;
            }
        } else if ((self.monsterinfo.aiflags & 0x200) != 0) {
            if (self.enemy.health <= -80) {
                hesDeadJim = true;
            }
        } else if (self.enemy.health <= 0) {
            hesDeadJim = true;
        }
        if (hesDeadJim) {
            self.enemy = null;
            if (self.oldenemy != null && self.oldenemy.health > 0) {
                self.enemy = self.oldenemy;
                self.oldenemy = null;
                GameAI.HuntTarget(self);
            } else {
                if (self.movetarget != null) {
                    self.goalentity = self.movetarget;
                    self.monsterinfo.walk.think(self);
                } else {
                    self.monsterinfo.pausetime = GameBase.level.time + 1.0E8f;
                    self.monsterinfo.stand.think(self);
                }
                return true;
            }
        }
        self.show_hostile = (int)GameBase.level.time + 1;
        enemy_vis = GameUtil.visible(self, self.enemy);
        if (enemy_vis) {
            self.monsterinfo.search_time = GameBase.level.time + 5.0f;
            Math3D.VectorCopy(self.enemy.s.origin, self.monsterinfo.last_sighting);
        }
        enemy_infront = GameUtil.infront(self, self.enemy);
        enemy_range = GameUtil.range(self, self.enemy);
        Math3D.VectorSubtract(self.enemy.s.origin, self.s.origin, temp);
        enemy_yaw = Math3D.vectoyaw(temp);
        if (self.monsterinfo.attack_state == 4) {
            GameAI.ai_run_missile(self);
            return true;
        }
        if (self.monsterinfo.attack_state == 3) {
            GameAI.ai_run_melee(self);
            return true;
        }
        if (!enemy_vis) {
            return false;
        }
        return self.monsterinfo.checkattack.think(self);
    }

    static void ai_walk(edict_t self, float dist) {
        M.M_MoveToGoal(self, dist);
        if (GameUtil.FindTarget(self)) {
            return;
        }
        if (self.monsterinfo.search != null && GameBase.level.time > self.monsterinfo.idle_time) {
            if (self.monsterinfo.idle_time != 0.0f) {
                self.monsterinfo.search.think(self);
                self.monsterinfo.idle_time = GameBase.level.time + 15.0f + Lib.random() * 15.0f;
            } else {
                self.monsterinfo.idle_time = GameBase.level.time + Lib.random() * 15.0f;
            }
        }
    }

    static void AI_SetSightClient() {
        int start = GameBase.level.sight_client == null ? 1 : GameBase.level.sight_client.index;
        int check = start;
        do {
            if (++check > GameBase.game.maxclients) {
                check = 1;
            }
            edict_t ent = GameBase.g_edicts[check];
            if (!ent.inuse || ent.health <= 0 || (ent.flags & 0x20) != 0) continue;
            GameBase.level.sight_client = ent;
            return;
        } while (check != start);
        GameBase.level.sight_client = null;
    }

    static void ai_move(edict_t self, float dist) {
        M.M_walkmove(self, self.s.angles[1], dist);
    }

    static void HuntTarget(edict_t self) {
        float[] vec = new float[]{0.0f, 0.0f, 0.0f};
        self.goalentity = self.enemy;
        if ((self.monsterinfo.aiflags & 1) != 0) {
            self.monsterinfo.stand.think(self);
        } else {
            self.monsterinfo.run.think(self);
        }
        Math3D.VectorSubtract(self.enemy.s.origin, self.s.origin, vec);
        self.ideal_yaw = Math3D.vectoyaw(vec);
        if (0 == (self.monsterinfo.aiflags & 1)) {
            GameUtil.AttackFinished(self, 1.0f);
        }
    }
}

