/*
 * Decompiled with CFR 0.152.
 */
package jake2.game;

import jake2.Globals;
import jake2.game.GameBase;
import jake2.game.GameItemList;
import jake2.game.GameItems;
import jake2.game.GameUtil;
import jake2.game.PlayerClient;
import jake2.game.PlayerHud;
import jake2.game.cmdalias_t;
import jake2.game.edict_t;
import jake2.game.gclient_t;
import jake2.game.gitem_armor_t;
import jake2.game.gitem_t;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.qcommon.cmd_function_t;
import jake2.qcommon.xcommand_t;
import jake2.server.SV_GAME;
import jake2.util.Lib;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public final class Cmd {
    static xcommand_t List_f = new xcommand_t(){

        public void execute() {
            cmd_function_t cmd = cmd_functions;
            int i = 0;
            while (cmd != null) {
                Com.Printf(cmd.name + '\n');
                ++i;
                cmd = cmd.next;
            }
            Com.Printf(i + " commands\n");
        }
    };
    static xcommand_t Exec_f = new xcommand_t(){

        public void execute() {
            if (Cmd.Argc() != 2) {
                Com.Printf("exec <filename> : execute a script file\n");
                return;
            }
            byte[] f = null;
            f = FS.LoadFile(Cmd.Argv(1));
            if (f == null) {
                Com.Printf("couldn't exec " + Cmd.Argv(1) + "\n");
                return;
            }
            Com.Printf("execing " + Cmd.Argv(1) + "\n");
            Cbuf.InsertText(new String(f));
            FS.FreeFile(f);
        }
    };
    static xcommand_t Echo_f = new xcommand_t(){

        public void execute() {
            for (int i = 1; i < Cmd.Argc(); ++i) {
                Com.Printf(Cmd.Argv(i) + " ");
            }
            Com.Printf("'\n");
        }
    };
    static xcommand_t Alias_f = new xcommand_t(){

        public void execute() {
            cmdalias_t a = null;
            if (Cmd.Argc() == 1) {
                Com.Printf("Current alias commands:\n");
                a = Globals.cmd_alias;
                while (a != null) {
                    Com.Printf(a.name + " : " + a.value);
                    a = a.next;
                }
                return;
            }
            String s = Cmd.Argv(1);
            if (s.length() > 32) {
                Com.Printf("Alias name is too long\n");
                return;
            }
            a = Globals.cmd_alias;
            while (a != null) {
                if (s.equalsIgnoreCase(a.name)) {
                    a.value = null;
                    break;
                }
                a = a.next;
            }
            if (a == null) {
                a = new cmdalias_t();
                a.next = Globals.cmd_alias;
                Globals.cmd_alias = a;
            }
            a.name = s;
            String cmd = "";
            int c = Cmd.Argc();
            for (int i = 2; i < c; ++i) {
                cmd = cmd + Cmd.Argv(i);
                if (i == c - 1) continue;
                cmd = cmd + " ";
            }
            a.value = cmd = cmd + "\n";
        }
    };
    public static xcommand_t Wait_f = new xcommand_t(){

        public void execute() {
            Globals.cmd_wait = true;
        }
    };
    public static cmd_function_t cmd_functions = null;
    public static int cmd_argc;
    public static String[] cmd_argv;
    public static String cmd_args;
    public static final int ALIAS_LOOP_COUNT = 16;
    private static char[] expanded;
    private static char[] temporary;
    public static Comparator PlayerSort;

    public static void Init() {
        Cmd.AddCommand("exec", Exec_f);
        Cmd.AddCommand("echo", Echo_f);
        Cmd.AddCommand("cmdlist", List_f);
        Cmd.AddCommand("alias", Alias_f);
        Cmd.AddCommand("wait", Wait_f);
    }

    public static char[] MacroExpandString(char[] text, int len) {
        boolean inquote = false;
        char[] scan = text;
        if (len >= 1024) {
            Com.Printf("Line exceeded 1024 chars, discarded.\n");
            return null;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (scan[i] == '\"') {
                boolean bl = inquote = !inquote;
            }
            if (inquote || scan[i] != '$') continue;
            Com.ParseHelp ph = new Com.ParseHelp(text, i + 1);
            String token = Com.Parse(ph);
            if (ph.data == null) continue;
            int j = (token = Cvar.VariableString(token)).length();
            if ((len += j) >= 1024) {
                Com.Printf("Expanded line exceeded 1024 chars, discarded.\n");
                return null;
            }
            System.arraycopy(scan, 0, temporary, 0, i);
            System.arraycopy(token.toCharArray(), 0, temporary, i, token.length());
            System.arraycopy(ph.data, ph.index, temporary, i + j, len - ph.index - j);
            System.arraycopy(temporary, 0, expanded, 0, 0);
            scan = expanded;
            --i;
            if (++count != 100) continue;
            Com.Printf("Macro expansion loop, discarded.\n");
            return null;
        }
        if (inquote) {
            Com.Printf("Line has unmatched quote, discarded.\n");
            return null;
        }
        return scan;
    }

    public static void TokenizeString(char[] text, boolean macroExpand) {
        char c;
        cmd_argc = 0;
        cmd_args = "";
        int len = Lib.strlen(text);
        if (macroExpand) {
            text = Cmd.MacroExpandString(text, len);
        }
        if (text == null) {
            return;
        }
        len = Lib.strlen(text);
        Com.ParseHelp ph = new Com.ParseHelp(text);
        while (true) {
            if ((c = ph.skipwhitestoeol()) == '\n') break;
            if (c == '\u0000') {
                return;
            }
            if (cmd_argc == 1) {
                cmd_args = new String(text, ph.index, len - ph.index);
                cmd_args.trim();
            }
            String com_token = Com.Parse(ph);
            if (ph.data == null) {
                return;
            }
            if (cmd_argc >= 80) continue;
            Cmd.cmd_argv[Cmd.cmd_argc] = com_token;
            ++cmd_argc;
        }
        c = ph.nextchar();
    }

    public static void AddCommand(String cmd_name, xcommand_t function) {
        if (Cvar.VariableString(cmd_name).length() > 0) {
            Com.Printf("Cmd_AddCommand: " + cmd_name + " already defined as a var\n");
            return;
        }
        cmd_function_t cmd = cmd_functions;
        while (cmd != null) {
            if (cmd_name.equals(cmd.name)) {
                Com.Printf("Cmd_AddCommand: " + cmd_name + " already defined\n");
                return;
            }
            cmd = cmd.next;
        }
        cmd = new cmd_function_t();
        cmd.name = cmd_name;
        cmd.function = function;
        cmd.next = cmd_functions;
        cmd_functions = cmd;
    }

    public static void RemoveCommand(String cmd_name) {
        cmd_function_t cmd;
        cmd_function_t back = null;
        back = cmd = cmd_functions;
        while (true) {
            if (cmd == null) {
                Com.Printf("Cmd_RemoveCommand: " + cmd_name + " not added\n");
                return;
            }
            if (0 == Lib.strcmp(cmd_name, cmd.name)) {
                if (cmd == cmd_functions) {
                    cmd_functions = cmd.next;
                } else {
                    back.next = cmd.next;
                }
                return;
            }
            back = cmd;
            cmd = cmd.next;
        }
    }

    public static boolean Exists(String cmd_name) {
        cmd_function_t cmd = cmd_functions;
        while (cmd != null) {
            if (cmd.name.equals(cmd_name)) {
                return true;
            }
            cmd = cmd.next;
        }
        return false;
    }

    public static int Argc() {
        return cmd_argc;
    }

    public static String Argv(int i) {
        if (i < 0 || i >= cmd_argc) {
            return "";
        }
        return cmd_argv[i];
    }

    public static String Args() {
        return new String(cmd_args);
    }

    public static void ExecuteString(String text) {
        Cmd.TokenizeString(text.toCharArray(), true);
        if (Cmd.Argc() == 0) {
            return;
        }
        cmd_function_t cmd = cmd_functions;
        while (cmd != null) {
            if (cmd_argv[0].equalsIgnoreCase(cmd.name)) {
                if (null == cmd.function) {
                    Cmd.ExecuteString("cmd " + text);
                } else {
                    cmd.function.execute();
                }
                return;
            }
            cmd = cmd.next;
        }
        cmdalias_t a = Globals.cmd_alias;
        while (a != null) {
            if (cmd_argv[0].equalsIgnoreCase(a.name)) {
                if (++Globals.alias_count == 16) {
                    Com.Printf("ALIAS_LOOP_COUNT\n");
                    return;
                }
                Cbuf.InsertText(a.value);
                return;
            }
            a = a.next;
        }
        if (Cvar.Command()) {
            return;
        }
        Cmd.ForwardToServer();
    }

    public static void Give_f(edict_t ent) {
        edict_t it_ent;
        gitem_t it;
        int i;
        if (GameBase.deathmatch.value != 0.0f && GameBase.sv_cheats.value == 0.0f) {
            SV_GAME.PF_cprintfhigh(ent, "You must run the server with '+set cheats 1' to enable this command.\n");
            return;
        }
        String name = Cmd.Args();
        boolean give_all = 0 == Lib.Q_stricmp(name, "all");
        if (give_all || 0 == Lib.Q_stricmp(Cmd.Argv(1), "health")) {
            ent.health = Cmd.Argc() == 3 ? Lib.atoi(Cmd.Argv(2)) : ent.max_health;
            if (!give_all) {
                return;
            }
        }
        if (give_all || 0 == Lib.Q_stricmp(name, "weapons")) {
            for (i = 1; i < GameBase.game.num_items; ++i) {
                it = GameItemList.itemlist[i];
                if (null == it.pickup || 0 == (it.flags & 1)) continue;
                int n = i;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] + 1;
            }
            if (!give_all) {
                return;
            }
        }
        if (give_all || 0 == Lib.Q_stricmp(name, "ammo")) {
            for (i = 1; i < GameBase.game.num_items; ++i) {
                it = GameItemList.itemlist[i];
                if (null == it.pickup || 0 == (it.flags & 2)) continue;
                GameItems.Add_Ammo(ent, it, 1000);
            }
            if (!give_all) {
                return;
            }
        }
        if (give_all || Lib.Q_stricmp(name, "armor") == 0) {
            it = GameItems.FindItem("Jacket Armor");
            ent.client.pers.inventory[GameItems.ITEM_INDEX((gitem_t)it)] = 0;
            it = GameItems.FindItem("Combat Armor");
            ent.client.pers.inventory[GameItems.ITEM_INDEX((gitem_t)it)] = 0;
            it = GameItems.FindItem("Body Armor");
            gitem_armor_t info = it.info;
            ent.client.pers.inventory[GameItems.ITEM_INDEX((gitem_t)it)] = info.max_count;
            if (!give_all) {
                return;
            }
        }
        if (give_all || Lib.Q_stricmp(name, "Power Shield") == 0) {
            it = GameItems.FindItem("Power Shield");
            it_ent = GameUtil.G_Spawn();
            it_ent.classname = it.classname;
            GameItems.SpawnItem(it_ent, it);
            GameItems.Touch_Item(it_ent, ent, GameBase.dummyplane, null);
            if (it_ent.inuse) {
                GameUtil.G_FreeEdict(it_ent);
            }
            if (!give_all) {
                return;
            }
        }
        if (give_all) {
            for (i = 1; i < GameBase.game.num_items; ++i) {
                it = GameItemList.itemlist[i];
                if (it.pickup != null || (it.flags & 7) != 0) continue;
                ent.client.pers.inventory[i] = 1;
            }
            return;
        }
        it = GameItems.FindItem(name);
        if (it == null && (it = GameItems.FindItem(name = Cmd.Argv(1))) == null) {
            SV_GAME.PF_cprintf(ent, 2, "unknown item\n");
            return;
        }
        if (it.pickup == null) {
            SV_GAME.PF_cprintf(ent, 2, "non-pickup item\n");
            return;
        }
        int index = GameItems.ITEM_INDEX(it);
        if ((it.flags & 2) != 0) {
            if (Cmd.Argc() == 3) {
                ent.client.pers.inventory[index] = Lib.atoi(Cmd.Argv(2));
            } else {
                int n = index;
                ent.client.pers.inventory[n] = ent.client.pers.inventory[n] + it.quantity;
            }
        } else {
            it_ent = GameUtil.G_Spawn();
            it_ent.classname = it.classname;
            GameItems.SpawnItem(it_ent, it);
            GameItems.Touch_Item(it_ent, ent, GameBase.dummyplane, null);
            if (it_ent.inuse) {
                GameUtil.G_FreeEdict(it_ent);
            }
        }
    }

    public static void God_f(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f && GameBase.sv_cheats.value == 0.0f) {
            SV_GAME.PF_cprintfhigh(ent, "You must run the server with '+set cheats 1' to enable this command.\n");
            return;
        }
        ent.flags ^= 0x10;
        String msg = 0 == (ent.flags & 0x10) ? "godmode OFF\n" : "godmode ON\n";
        SV_GAME.PF_cprintf(ent, 2, msg);
    }

    public static void Notarget_f(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f && GameBase.sv_cheats.value == 0.0f) {
            SV_GAME.PF_cprintfhigh(ent, "You must run the server with '+set cheats 1' to enable this command.\n");
            return;
        }
        ent.flags ^= 0x20;
        String msg = 0 == (ent.flags & 0x20) ? "notarget OFF\n" : "notarget ON\n";
        SV_GAME.PF_cprintfhigh(ent, msg);
    }

    public static void Noclip_f(edict_t ent) {
        String msg;
        if (GameBase.deathmatch.value != 0.0f && GameBase.sv_cheats.value == 0.0f) {
            SV_GAME.PF_cprintfhigh(ent, "You must run the server with '+set cheats 1' to enable this command.\n");
            return;
        }
        if (ent.movetype == 1) {
            ent.movetype = 4;
            msg = "noclip OFF\n";
        } else {
            ent.movetype = 1;
            msg = "noclip ON\n";
        }
        SV_GAME.PF_cprintfhigh(ent, msg);
    }

    public static void Use_f(edict_t ent) {
        String s = Cmd.Args();
        gitem_t it = GameItems.FindItem(s);
        Com.dprintln("using:" + s);
        if (it == null) {
            SV_GAME.PF_cprintfhigh(ent, "unknown item: " + s + "\n");
            return;
        }
        if (it.use == null) {
            SV_GAME.PF_cprintfhigh(ent, "Item is not usable.\n");
            return;
        }
        int index = GameItems.ITEM_INDEX(it);
        if (0 == ent.client.pers.inventory[index]) {
            SV_GAME.PF_cprintfhigh(ent, "Out of item: " + s + "\n");
            return;
        }
        it.use.use(ent, it);
    }

    public static void Drop_f(edict_t ent) {
        String s = Cmd.Args();
        gitem_t it = GameItems.FindItem(s);
        if (it == null) {
            SV_GAME.PF_cprintfhigh(ent, "unknown item: " + s + "\n");
            return;
        }
        if (it.drop == null) {
            SV_GAME.PF_cprintf(ent, 2, "Item is not dropable.\n");
            return;
        }
        int index = GameItems.ITEM_INDEX(it);
        if (0 == ent.client.pers.inventory[index]) {
            SV_GAME.PF_cprintfhigh(ent, "Out of item: " + s + "\n");
            return;
        }
        it.drop.drop(ent, it);
    }

    public static void Inven_f(edict_t ent) {
        gclient_t cl = ent.client;
        cl.showscores = false;
        cl.showhelp = false;
        if (cl.showinventory) {
            cl.showinventory = false;
            return;
        }
        cl.showinventory = true;
        GameBase.gi.WriteByte(5);
        for (int i = 0; i < 256; ++i) {
            GameBase.gi.WriteShort(cl.pers.inventory[i]);
        }
        GameBase.gi.unicast(ent, true);
    }

    public static void InvUse_f(edict_t ent) {
        Cmd.ValidateSelectedItem(ent);
        if (ent.client.pers.selected_item == -1) {
            SV_GAME.PF_cprintfhigh(ent, "No item to use.\n");
            return;
        }
        gitem_t it = GameItemList.itemlist[ent.client.pers.selected_item];
        if (it.use == null) {
            SV_GAME.PF_cprintfhigh(ent, "Item is not usable.\n");
            return;
        }
        it.use.use(ent, it);
    }

    public static void WeapPrev_f(edict_t ent) {
        gclient_t cl = ent.client;
        if (cl.pers.weapon == null) {
            return;
        }
        int selected_weapon = GameItems.ITEM_INDEX(cl.pers.weapon);
        for (int i = 1; i <= 256; ++i) {
            int index = (selected_weapon + i) % 256;
            if (0 == cl.pers.inventory[index]) continue;
            gitem_t it = GameItemList.itemlist[index];
            if (it.use == null || 0 == (it.flags & 1)) continue;
            it.use.use(ent, it);
            if (cl.pers.weapon != it) continue;
            return;
        }
    }

    public static void WeapNext_f(edict_t ent) {
        gclient_t cl = ent.client;
        if (null == cl.pers.weapon) {
            return;
        }
        int selected_weapon = GameItems.ITEM_INDEX(cl.pers.weapon);
        for (int i = 1; i <= 256; ++i) {
            int index = (selected_weapon + 256 - i) % 256;
            if (index == 0) {
                ++index;
            }
            if (0 == cl.pers.inventory[index]) continue;
            gitem_t it = GameItemList.itemlist[index];
            if (null == it.use || 0 == (it.flags & 1)) continue;
            it.use.use(ent, it);
            if (cl.pers.weapon != it) continue;
            return;
        }
    }

    public static void WeapLast_f(edict_t ent) {
        gclient_t cl = ent.client;
        if (null == cl.pers.weapon || null == cl.pers.lastweapon) {
            return;
        }
        int index = GameItems.ITEM_INDEX(cl.pers.lastweapon);
        if (0 == cl.pers.inventory[index]) {
            return;
        }
        gitem_t it = GameItemList.itemlist[index];
        if (null == it.use) {
            return;
        }
        if (0 == (it.flags & 1)) {
            return;
        }
        it.use.use(ent, it);
    }

    public static void InvDrop_f(edict_t ent) {
        Cmd.ValidateSelectedItem(ent);
        if (ent.client.pers.selected_item == -1) {
            SV_GAME.PF_cprintfhigh(ent, "No item to drop.\n");
            return;
        }
        gitem_t it = GameItemList.itemlist[ent.client.pers.selected_item];
        if (it.drop == null) {
            SV_GAME.PF_cprintfhigh(ent, "Item is not dropable.\n");
            return;
        }
        it.drop.drop(ent, it);
    }

    public static void Score_f(edict_t ent) {
        ent.client.showinventory = false;
        ent.client.showhelp = false;
        if (0.0f == GameBase.deathmatch.value && 0.0f == GameBase.coop.value) {
            return;
        }
        if (ent.client.showscores) {
            ent.client.showscores = false;
            return;
        }
        ent.client.showscores = true;
        PlayerHud.DeathmatchScoreboard(ent);
    }

    public static void Help_f(edict_t ent) {
        if (GameBase.deathmatch.value != 0.0f) {
            Cmd.Score_f(ent);
            return;
        }
        ent.client.showinventory = false;
        ent.client.showscores = false;
        if (ent.client.showhelp && ent.client.pers.game_helpchanged == GameBase.game.helpchanged) {
            ent.client.showhelp = false;
            return;
        }
        ent.client.showhelp = true;
        ent.client.pers.helpchanged = 0;
        PlayerHud.HelpComputer(ent);
    }

    public static void Kill_f(edict_t ent) {
        if (GameBase.level.time - ent.client.respawn_time < 5.0f) {
            return;
        }
        ent.flags &= 0xFFFFFFEF;
        ent.health = 0;
        GameBase.meansOfDeath = 23;
        PlayerClient.player_die.die(ent, ent, ent, 100000, Globals.vec3_origin);
    }

    public static void PutAway_f(edict_t ent) {
        ent.client.showscores = false;
        ent.client.showhelp = false;
        ent.client.showinventory = false;
    }

    public static void Players_f(edict_t ent) {
        Integer[] index = new Integer[256];
        int count = 0;
        int i = 0;
        while ((float)i < GameBase.maxclients.value) {
            if (GameBase.game.clients[i].pers.connected) {
                index[count] = new Integer(i);
                ++count;
            }
            ++i;
        }
        Arrays.sort(index, 0, count - 1, PlayerSort);
        String large = "";
        for (i = 0; i < count; ++i) {
            String small = GameBase.game.clients[index[i].intValue()].ps.stats[14] + " " + GameBase.game.clients[index[i].intValue()].pers.netname + "\n";
            if (small.length() + large.length() > 924) {
                large = large + "...\n";
                break;
            }
            large = large + small;
        }
        SV_GAME.PF_cprintfhigh(ent, large + "\n" + count + " players\n");
    }

    public static void Wave_f(edict_t ent) {
        int i = Lib.atoi(Cmd.Argv(1));
        if ((ent.client.ps.pmove.pm_flags & 1) != 0) {
            return;
        }
        if (ent.client.anim_priority > 1) {
            return;
        }
        ent.client.anim_priority = 1;
        switch (i) {
            case 0: {
                SV_GAME.PF_cprintfhigh(ent, "flipoff\n");
                ent.s.frame = 71;
                ent.client.anim_end = 83;
                break;
            }
            case 1: {
                SV_GAME.PF_cprintfhigh(ent, "salute\n");
                ent.s.frame = 83;
                ent.client.anim_end = 94;
                break;
            }
            case 2: {
                SV_GAME.PF_cprintfhigh(ent, "taunt\n");
                ent.s.frame = 94;
                ent.client.anim_end = 111;
                break;
            }
            case 3: {
                SV_GAME.PF_cprintfhigh(ent, "wave\n");
                ent.s.frame = 111;
                ent.client.anim_end = 122;
                break;
            }
            default: {
                SV_GAME.PF_cprintfhigh(ent, "point\n");
                ent.s.frame = 122;
                ent.client.anim_end = 134;
            }
        }
    }

    public static void ShowPosition_f(edict_t ent) {
        SV_GAME.PF_cprintfhigh(ent, "pos=" + Lib.vtofsbeaty(ent.s.origin) + "\n");
    }

    public static void Say_f(edict_t ent, boolean team, boolean arg0) {
        if (Cmd.Argc() < 2 && !arg0) {
            return;
        }
        if (0 == ((int)GameBase.dmflags.value & 0xC0)) {
            team = false;
        }
        String text = team ? "(" + ent.client.pers.netname + "): " : "" + ent.client.pers.netname + ": ";
        if (arg0) {
            text = text + Cmd.Argv(0);
            text = text + " ";
            text = text + Cmd.Args();
        } else {
            text = Cmd.Args().startsWith("\"") ? text + Cmd.Args().substring(1, Cmd.Args().length() - 1) : text + Cmd.Args();
        }
        if (text.length() > 150) {
            text = text.substring(0, 150);
        }
        text = text + "\n";
        if (GameBase.flood_msgs.value != 0.0f) {
            gclient_t cl = ent.client;
            if (GameBase.level.time < cl.flood_locktill) {
                SV_GAME.PF_cprintfhigh(ent, "You can't talk for " + (int)(cl.flood_locktill - GameBase.level.time) + " more seconds\n");
                return;
            }
            int i = (int)((float)cl.flood_whenhead - GameBase.flood_msgs.value + 1.0f);
            if (i < 0) {
                i = 10 + i;
            }
            if (cl.flood_when[i] != 0.0f && GameBase.level.time - cl.flood_when[i] < GameBase.flood_persecond.value) {
                cl.flood_locktill = GameBase.level.time + GameBase.flood_waitdelay.value;
                SV_GAME.PF_cprintf(ent, 3, "Flood protection:  You can't talk for " + (int)GameBase.flood_waitdelay.value + " seconds.\n");
                return;
            }
            cl.flood_whenhead = (cl.flood_whenhead + 1) % 10;
            cl.flood_when[cl.flood_whenhead] = GameBase.level.time;
        }
        if (Globals.dedicated.value != 0.0f) {
            SV_GAME.PF_cprintf(null, 3, "" + text + "");
        }
        for (int j = 1; j <= GameBase.game.maxclients; ++j) {
            edict_t other = GameBase.g_edicts[j];
            if (!other.inuse || other.client == null || team && !GameUtil.OnSameTeam(ent, other)) continue;
            SV_GAME.PF_cprintf(other, 3, "" + text + "");
        }
    }

    public static void PlayerList_f(edict_t ent) {
        String text = "";
        int i = 0;
        while ((float)i < GameBase.maxclients.value) {
            edict_t e2 = GameBase.g_edicts[1 + i];
            if (e2.inuse) {
                String st = "" + (GameBase.level.framenum - e2.client.resp.enterframe) / 600 + ":" + (GameBase.level.framenum - e2.client.resp.enterframe) % 600 / 10 + " " + e2.client.ping + " " + e2.client.resp.score + " " + e2.client.pers.netname + " " + (e2.client.resp.spectator ? " (spectator)" : "") + "\n";
                if (text.length() + st.length() > 974) {
                    text = text + "And more...\n";
                    SV_GAME.PF_cprintfhigh(ent, "" + text + "");
                    return;
                }
                text = text + st;
            }
            ++i;
        }
        SV_GAME.PF_cprintfhigh(ent, text);
    }

    public static void ForwardToServer() {
        String cmd = Cmd.Argv(0);
        if (Globals.cls.state <= 3 || cmd.charAt(0) == '-' || cmd.charAt(0) == '+') {
            Com.Printf("Unknown command \"" + cmd + "\"\n");
            return;
        }
        MSG.WriteByte(Globals.cls.netchan.message, 4);
        SZ.Print(Globals.cls.netchan.message, cmd);
        if (Cmd.Argc() > 1) {
            SZ.Print(Globals.cls.netchan.message, " ");
            SZ.Print(Globals.cls.netchan.message, Cmd.Args());
        }
    }

    public static Vector CompleteCommand(String partial) {
        Vector<String> cmds = new Vector<String>();
        cmd_function_t cmd = cmd_functions;
        while (cmd != null) {
            if (cmd.name.startsWith(partial)) {
                cmds.add(cmd.name);
            }
            cmd = cmd.next;
        }
        cmdalias_t a = Globals.cmd_alias;
        while (a != null) {
            if (a.name.startsWith(partial)) {
                cmds.add(a.name);
            }
            a = a.next;
        }
        return cmds;
    }

    public static void ClientCommand(edict_t ent) {
        if (ent.client == null) {
            return;
        }
        String cmd = GameBase.gi.argv(0).toLowerCase();
        if (cmd.equals("players")) {
            Cmd.Players_f(ent);
            return;
        }
        if (cmd.equals("say")) {
            Cmd.Say_f(ent, false, false);
            return;
        }
        if (cmd.equals("say_team")) {
            Cmd.Say_f(ent, true, false);
            return;
        }
        if (cmd.equals("score")) {
            Cmd.Score_f(ent);
            return;
        }
        if (cmd.equals("help")) {
            Cmd.Help_f(ent);
            return;
        }
        if (GameBase.level.intermissiontime != 0.0f) {
            return;
        }
        if (cmd.equals("use")) {
            Cmd.Use_f(ent);
        } else if (cmd.equals("drop")) {
            Cmd.Drop_f(ent);
        } else if (cmd.equals("give")) {
            Cmd.Give_f(ent);
        } else if (cmd.equals("god")) {
            Cmd.God_f(ent);
        } else if (cmd.equals("notarget")) {
            Cmd.Notarget_f(ent);
        } else if (cmd.equals("noclip")) {
            Cmd.Noclip_f(ent);
        } else if (cmd.equals("inven")) {
            Cmd.Inven_f(ent);
        } else if (cmd.equals("invnext")) {
            GameItems.SelectNextItem(ent, -1);
        } else if (cmd.equals("invprev")) {
            GameItems.SelectPrevItem(ent, -1);
        } else if (cmd.equals("invnextw")) {
            GameItems.SelectNextItem(ent, 1);
        } else if (cmd.equals("invprevw")) {
            GameItems.SelectPrevItem(ent, 1);
        } else if (cmd.equals("invnextp")) {
            GameItems.SelectNextItem(ent, 32);
        } else if (cmd.equals("invprevp")) {
            GameItems.SelectPrevItem(ent, 32);
        } else if (cmd.equals("invuse")) {
            Cmd.InvUse_f(ent);
        } else if (cmd.equals("invdrop")) {
            Cmd.InvDrop_f(ent);
        } else if (cmd.equals("weapprev")) {
            Cmd.WeapPrev_f(ent);
        } else if (cmd.equals("weapnext")) {
            Cmd.WeapNext_f(ent);
        } else if (cmd.equals("weaplast")) {
            Cmd.WeapLast_f(ent);
        } else if (cmd.equals("kill")) {
            Cmd.Kill_f(ent);
        } else if (cmd.equals("putaway")) {
            Cmd.PutAway_f(ent);
        } else if (cmd.equals("wave")) {
            Cmd.Wave_f(ent);
        } else if (cmd.equals("playerlist")) {
            Cmd.PlayerList_f(ent);
        } else if (cmd.equals("showposition")) {
            Cmd.ShowPosition_f(ent);
        } else {
            Cmd.Say_f(ent, false, true);
        }
    }

    public static void ValidateSelectedItem(edict_t ent) {
        gclient_t cl = ent.client;
        if (cl.pers.inventory[cl.pers.selected_item] != 0) {
            return;
        }
        GameItems.SelectNextItem(ent, -1);
    }

    static {
        cmd_argv = new String[80];
        expanded = new char[1024];
        temporary = new char[1024];
        PlayerSort = new Comparator(){

            public int compare(Object o1, Object o2) {
                int anum = (Integer)o1;
                int bnum = (Integer)o2;
                short anum1 = GameBase.game.clients[anum].ps.stats[14];
                short bnum1 = GameBase.game.clients[bnum].ps.stats[14];
                if (anum1 < bnum1) {
                    return -1;
                }
                if (anum1 > bnum1) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

