/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.Console;
import jake2.client.Menu;
import jake2.client.SCR;
import jake2.client.vidmode_t;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.xcommand_t;
import jake2.render.Renderer;
import jake2.sound.S;
import jake2.sys.IN;
import jake2.util.Vargs;
import java.awt.Dimension;
import java.awt.DisplayMode;

public class VID
extends Globals {
    static cvar_t vid_gamma;
    static cvar_t vid_ref;
    static cvar_t vid_xpos;
    static cvar_t vid_ypos;
    static cvar_t vid_width;
    static cvar_t vid_height;
    static cvar_t vid_fullscreen;
    static boolean reflib_active;
    static vidmode_t[] vid_modes;
    static vidmode_t[] fs_modes;
    static final int REF_OPENGL_JOGL = 0;
    static final int REF_OPENGL_FASTJOGL = 1;
    static final int REF_OPENGL_LWJGL = 2;
    static cvar_t gl_mode;
    static cvar_t gl_driver;
    static cvar_t gl_picmip;
    static cvar_t gl_ext_palettedtexture;
    static cvar_t gl_swapinterval;
    static Menu.menuframework_s s_opengl_menu;
    static Menu.menuframework_s s_current_menu;
    static Menu.menulist_s s_mode_list;
    static Menu.menulist_s s_ref_list;
    static Menu.menuslider_s s_tq_slider;
    static Menu.menuslider_s s_screensize_slider;
    static Menu.menuslider_s s_brightness_slider;
    static Menu.menulist_s s_fs_box;
    static Menu.menulist_s s_stipple_box;
    static Menu.menulist_s s_paletted_texture_box;
    static Menu.menulist_s s_vsync_box;
    static Menu.menulist_s s_windowed_mouse;
    static Menu.menuaction_s s_apply_action;
    static Menu.menuaction_s s_defaults_action;
    static final String[] resolutions;
    static String[] fs_resolutions;
    static int mode_x;
    static String[] refs;
    static String[] drivers;
    static final String[] yesno_names;

    public static void Printf(int print_level, String fmt) {
        VID.Printf(print_level, fmt, null);
    }

    public static void Printf(int print_level, String fmt, Vargs vargs) {
        if (print_level == 0) {
            Com.Printf(fmt, vargs);
        } else {
            Com.DPrintf(fmt, vargs);
        }
    }

    static void Restart_f() {
        VID.vid_modes[11].width = (int)VID.vid_width.value;
        VID.vid_modes[11].height = (int)VID.vid_height.value;
        VID.vid_ref.modified = true;
    }

    public static boolean GetModeInfo(Dimension dim, int mode) {
        if (fs_modes == null) {
            VID.initModeList();
        }
        vidmode_t[] modes = vid_modes;
        if (VID.vid_fullscreen.value != 0.0f) {
            modes = fs_modes;
        }
        if (mode < 0 || mode >= modes.length) {
            return false;
        }
        dim.width = modes[mode].width;
        dim.height = modes[mode].height;
        return true;
    }

    public static void NewWindow(int width, int height) {
        Globals.viddef.setSize(width, height);
    }

    static void FreeReflib() {
        if (Globals.re != null) {
            Globals.re.getKeyboardHandler().Close();
            IN.Shutdown();
        }
        Globals.re = null;
        reflib_active = false;
    }

    static boolean LoadRefresh(String name, boolean fast) {
        if (reflib_active) {
            Globals.re.getKeyboardHandler().Close();
            IN.Shutdown();
            Globals.re.Shutdown();
            VID.FreeReflib();
        }
        Com.Printf("------- Loading " + name + " -------\n");
        boolean found = false;
        String[] driverNames = Renderer.getDriverNames();
        for (int i = 0; i < driverNames.length; ++i) {
            if (!driverNames[i].equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            Com.Printf("LoadLibrary(\"" + name + "\") failed\n");
            return false;
        }
        Com.Printf("LoadLibrary(\"" + name + "\")\n");
        Globals.re = Renderer.getDriver(name, fast);
        if (Globals.re == null) {
            Com.Error(0, name + " can't load but registered");
        }
        if (Globals.re.apiVersion() != 3) {
            VID.FreeReflib();
            Com.Error(0, name + " has incompatible api_version");
        }
        IN.Real_IN_Init();
        if (!Globals.re.Init((int)VID.vid_xpos.value, (int)VID.vid_ypos.value)) {
            Globals.re.Shutdown();
            VID.FreeReflib();
            return false;
        }
        Globals.re.getKeyboardHandler().Init();
        Com.Printf("------------------------------------\n");
        reflib_active = true;
        return true;
    }

    public static void CheckChanges() {
        Globals.viddef.update();
        if (VID.vid_ref.modified) {
            S.StopAllSounds();
        }
        while (VID.vid_ref.modified) {
            VID.vid_ref.modified = false;
            VID.vid_fullscreen.modified = true;
            Globals.cl.refresh_prepped = false;
            Globals.cls.disable_screen = 1.0f;
            if (!VID.LoadRefresh(VID.vid_ref.string, true)) {
                String renderer = VID.vid_ref.string.equals(Renderer.getPreferedName()) ? Renderer.getDefaultName() : Renderer.getPreferedName();
                if (VID.vid_ref.string.equals(Renderer.getDefaultName())) {
                    renderer = VID.vid_ref.string;
                    Com.Printf("Refresh failed\n");
                    gl_mode = Cvar.Get("gl_mode", "0", 0);
                    if (VID.gl_mode.value != 0.0f) {
                        Com.Printf("Trying mode 0\n");
                        Cvar.SetValue("gl_mode", 0);
                        if (!VID.LoadRefresh(VID.vid_ref.string, false)) {
                            Com.Error(0, "Couldn't fall back to " + renderer + " refresh!");
                        }
                    } else {
                        Com.Error(0, "Couldn't fall back to " + renderer + " refresh!");
                    }
                }
                Cvar.Set("vid_ref", renderer);
                if (Globals.cls.key_dest != 1) {
                    try {
                        Console.ToggleConsole_f.execute();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Globals.cls.disable_screen = 0.0f;
        }
    }

    public static void Init() {
        vid_ref = Cvar.Get("vid_ref", Renderer.getPreferedName(), 1);
        vid_xpos = Cvar.Get("vid_xpos", "3", 1);
        vid_ypos = Cvar.Get("vid_ypos", "22", 1);
        vid_width = Cvar.Get("vid_width", "640", 1);
        vid_height = Cvar.Get("vid_height", "480", 1);
        vid_fullscreen = Cvar.Get("vid_fullscreen", "0", 1);
        vid_gamma = Cvar.Get("vid_gamma", "1", 1);
        VID.vid_modes[11].width = (int)VID.vid_width.value;
        VID.vid_modes[11].height = (int)VID.vid_height.value;
        Cmd.AddCommand("vid_restart", new xcommand_t(){

            public void execute() {
                VID.Restart_f();
            }
        });
        VID.CheckChanges();
    }

    public static void Shutdown() {
        if (reflib_active) {
            Globals.re.getKeyboardHandler().Close();
            IN.Shutdown();
            Globals.re.Shutdown();
            VID.FreeReflib();
        }
    }

    static void DriverCallback(Object unused) {
        s_current_menu = s_opengl_menu;
    }

    static void ScreenSizeCallback(Object s) {
        Menu.menuslider_s slider = (Menu.menuslider_s)s;
        Cvar.SetValue("viewsize", slider.curvalue * 10.0f);
    }

    static void BrightnessCallback(Object s) {
        Menu.menuslider_s slider = (Menu.menuslider_s)s;
        if (VID.vid_ref.string.equalsIgnoreCase("soft") || VID.vid_ref.string.equalsIgnoreCase("softx")) {
            float gamma = 0.8f - (slider.curvalue / 10.0f - 0.5f) + 0.5f;
            Cvar.SetValue("vid_gamma", gamma);
        }
    }

    static void ResetDefaults(Object unused) {
        VID.MenuInit();
    }

    static void ApplyChanges(Object unused) {
        float gamma = 0.4f - (VID.s_brightness_slider.curvalue / 20.0f - 0.25f) + 0.7f;
        float modulate = VID.s_brightness_slider.curvalue * 0.2f;
        Cvar.SetValue("vid_gamma", gamma);
        Cvar.SetValue("gl_modulate", modulate);
        Cvar.SetValue("gl_picmip", 3.0f - VID.s_tq_slider.curvalue);
        Cvar.SetValue("vid_fullscreen", VID.s_fs_box.curvalue);
        Cvar.SetValue("gl_swapinterval", VID.s_vsync_box.curvalue);
        VID.gl_swapinterval.modified = true;
        Cvar.SetValue("gl_ext_palettedtexture", VID.s_paletted_texture_box.curvalue);
        Cvar.SetValue("gl_mode", VID.s_mode_list.curvalue);
        Cvar.Set("vid_ref", drivers[VID.s_ref_list.curvalue]);
        Cvar.Set("gl_driver", drivers[VID.s_ref_list.curvalue]);
        if (VID.gl_driver.modified) {
            VID.vid_ref.modified = true;
        }
        Menu.ForceMenuOff();
    }

    static void initModeList() {
        DisplayMode[] modes = re.getModeList();
        fs_resolutions = new String[modes.length];
        fs_modes = new vidmode_t[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode m = modes[i];
            StringBuffer sb = new StringBuffer(18);
            sb.append('[');
            sb.append(m.getWidth());
            sb.append(' ');
            sb.append(m.getHeight());
            while (sb.length() < 10) {
                sb.append(' ');
            }
            sb.append(']');
            VID.fs_resolutions[i] = sb.toString();
            sb.setLength(0);
            sb.append("Mode ");
            sb.append(i);
            sb.append(':');
            sb.append(m.getWidth());
            sb.append('x');
            sb.append(m.getHeight());
            VID.fs_modes[i] = new vidmode_t(sb.toString(), m.getWidth(), m.getHeight(), i);
        }
    }

    private static void initRefs() {
        drivers = Renderer.getDriverNames();
        refs = new String[drivers.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < drivers.length; ++i) {
            sb.setLength(0);
            sb.append("[OpenGL ").append(drivers[i]);
            while (sb.length() < 16) {
                sb.append(" ");
            }
            sb.append("]");
            VID.refs[i] = sb.toString();
        }
    }

    public static void MenuInit() {
        VID.initRefs();
        if (gl_driver == null) {
            gl_driver = Cvar.Get("gl_driver", Renderer.getPreferedName(), 0);
        }
        if (gl_picmip == null) {
            gl_picmip = Cvar.Get("gl_picmip", "0", 0);
        }
        if (gl_mode == null) {
            gl_mode = Cvar.Get("gl_mode", "3", 0);
        }
        if (gl_ext_palettedtexture == null) {
            gl_ext_palettedtexture = Cvar.Get("gl_ext_palettedtexture", "1", 1);
        }
        if (gl_swapinterval == null) {
            gl_swapinterval = Cvar.Get("gl_swapinterval", "0", 1);
        }
        VID.s_mode_list.curvalue = (int)VID.gl_mode.value;
        if (VID.vid_fullscreen.value != 0.0f) {
            VID.s_mode_list.itemnames = fs_resolutions;
            if (VID.s_mode_list.curvalue >= fs_resolutions.length - 1) {
                VID.s_mode_list.curvalue = 0;
            }
            mode_x = VID.fs_modes[VID.s_mode_list.curvalue].width;
        } else {
            VID.s_mode_list.itemnames = resolutions;
            if (VID.s_mode_list.curvalue >= resolutions.length - 1) {
                VID.s_mode_list.curvalue = 0;
            }
            mode_x = VID.vid_modes[VID.s_mode_list.curvalue].width;
        }
        if (SCR.scr_viewsize == null) {
            SCR.scr_viewsize = Cvar.Get("viewsize", "100", 1);
        }
        VID.s_screensize_slider.curvalue = (int)(SCR.scr_viewsize.value / 10.0f);
        for (int i = 0; i < drivers.length; ++i) {
            if (!VID.vid_ref.string.equals(drivers[i])) continue;
            VID.s_ref_list.curvalue = i;
        }
        VID.s_opengl_menu.x = (int)((float)viddef.getWidth() * 0.5f);
        VID.s_opengl_menu.nitems = 0;
        VID.s_ref_list.type = 3;
        VID.s_ref_list.name = "driver";
        VID.s_ref_list.x = 0;
        VID.s_ref_list.y = 0;
        VID.s_ref_list.callback = new Menu.mcallback(){

            public void execute(Object self) {
                VID.DriverCallback(self);
            }
        };
        VID.s_ref_list.itemnames = refs;
        VID.s_mode_list.type = 3;
        VID.s_mode_list.name = "video mode";
        VID.s_mode_list.x = 0;
        VID.s_mode_list.y = 10;
        VID.s_screensize_slider.type = 0;
        VID.s_screensize_slider.x = 0;
        VID.s_screensize_slider.y = 20;
        VID.s_screensize_slider.name = "screen size";
        VID.s_screensize_slider.minvalue = 3.0f;
        VID.s_screensize_slider.maxvalue = 12.0f;
        VID.s_screensize_slider.callback = new Menu.mcallback(){

            public void execute(Object self) {
                VID.ScreenSizeCallback(self);
            }
        };
        VID.s_brightness_slider.type = 0;
        VID.s_brightness_slider.x = 0;
        VID.s_brightness_slider.y = 30;
        VID.s_brightness_slider.name = "brightness";
        VID.s_brightness_slider.callback = new Menu.mcallback(){

            public void execute(Object self) {
                VID.BrightnessCallback(self);
            }
        };
        VID.s_brightness_slider.minvalue = 5.0f;
        VID.s_brightness_slider.maxvalue = 13.0f;
        VID.s_brightness_slider.curvalue = (1.3f - VID.vid_gamma.value + 0.5f) * 10.0f;
        VID.s_fs_box.type = 3;
        VID.s_fs_box.x = 0;
        VID.s_fs_box.y = 40;
        VID.s_fs_box.name = "fullscreen";
        VID.s_fs_box.itemnames = yesno_names;
        VID.s_fs_box.curvalue = (int)VID.vid_fullscreen.value;
        VID.s_fs_box.callback = new Menu.mcallback(){

            public void execute(Object o) {
                int fs = ((Menu.menulist_s)o).curvalue;
                if (fs == 0) {
                    int i;
                    VID.s_mode_list.itemnames = resolutions;
                    for (i = vid_modes.length - 2; i > 0 && VID.vid_modes[i].width > mode_x; --i) {
                    }
                    VID.s_mode_list.curvalue = i;
                } else {
                    int i;
                    VID.s_mode_list.itemnames = fs_resolutions;
                    for (i = fs_modes.length - 1; i > 0 && VID.fs_modes[i].width > mode_x; --i) {
                    }
                    VID.s_mode_list.curvalue = i;
                }
            }
        };
        VID.s_tq_slider.type = 0;
        VID.s_tq_slider.x = 0;
        VID.s_tq_slider.y = 60;
        VID.s_tq_slider.name = "texture quality";
        VID.s_tq_slider.minvalue = 0.0f;
        VID.s_tq_slider.maxvalue = 3.0f;
        VID.s_tq_slider.curvalue = 3.0f - VID.gl_picmip.value;
        VID.s_paletted_texture_box.type = 3;
        VID.s_paletted_texture_box.x = 0;
        VID.s_paletted_texture_box.y = 70;
        VID.s_paletted_texture_box.name = "8-bit textures";
        VID.s_paletted_texture_box.itemnames = yesno_names;
        VID.s_paletted_texture_box.curvalue = (int)VID.gl_ext_palettedtexture.value;
        VID.s_vsync_box.type = 3;
        VID.s_vsync_box.x = 0;
        VID.s_vsync_box.y = 80;
        VID.s_vsync_box.name = "sync every frame";
        VID.s_vsync_box.itemnames = yesno_names;
        VID.s_vsync_box.curvalue = (int)VID.gl_swapinterval.value;
        VID.s_defaults_action.type = 2;
        VID.s_defaults_action.name = "reset to default";
        VID.s_defaults_action.x = 0;
        VID.s_defaults_action.y = 100;
        VID.s_defaults_action.callback = new Menu.mcallback(){

            public void execute(Object self) {
                VID.ResetDefaults(self);
            }
        };
        VID.s_apply_action.type = 2;
        VID.s_apply_action.name = "apply";
        VID.s_apply_action.x = 0;
        VID.s_apply_action.y = 110;
        VID.s_apply_action.callback = new Menu.mcallback(){

            public void execute(Object self) {
                VID.ApplyChanges(self);
            }
        };
        Menu.Menu_AddItem(s_opengl_menu, s_ref_list);
        Menu.Menu_AddItem(s_opengl_menu, s_mode_list);
        Menu.Menu_AddItem(s_opengl_menu, s_screensize_slider);
        Menu.Menu_AddItem(s_opengl_menu, s_brightness_slider);
        Menu.Menu_AddItem(s_opengl_menu, s_fs_box);
        Menu.Menu_AddItem(s_opengl_menu, s_tq_slider);
        Menu.Menu_AddItem(s_opengl_menu, s_paletted_texture_box);
        Menu.Menu_AddItem(s_opengl_menu, s_vsync_box);
        Menu.Menu_AddItem(s_opengl_menu, s_defaults_action);
        Menu.Menu_AddItem(s_opengl_menu, s_apply_action);
        Menu.Menu_Center(s_opengl_menu);
        VID.s_opengl_menu.x -= 8;
    }

    static void MenuDraw() {
        s_current_menu = s_opengl_menu;
        Dimension dim = new Dimension();
        re.DrawGetPicSize(dim, "m_banner_video");
        re.DrawPic(viddef.getWidth() / 2 - dim.width / 2, viddef.getHeight() / 2 - 110, "m_banner_video");
        Menu.Menu_AdjustCursor(s_current_menu, 1);
        Menu.Menu_Draw(s_current_menu);
    }

    static String MenuKey(int key) {
        Menu.menuframework_s m = s_current_menu;
        String sound = "misc/menu1.wav";
        switch (key) {
            case 27: {
                Menu.PopMenu();
                return null;
            }
            case 128: {
                --m.cursor;
                Menu.Menu_AdjustCursor(m, -1);
                break;
            }
            case 129: {
                ++m.cursor;
                Menu.Menu_AdjustCursor(m, 1);
                break;
            }
            case 130: {
                Menu.Menu_SlideItem(m, -1);
                break;
            }
            case 131: {
                Menu.Menu_SlideItem(m, 1);
                break;
            }
            case 13: {
                Menu.Menu_SelectItem(m);
            }
        }
        return "misc/menu1.wav";
    }

    static {
        reflib_active = false;
        vid_modes = new vidmode_t[]{new vidmode_t("Mode 0: 320x240", 320, 240, 0), new vidmode_t("Mode 1: 400x300", 400, 300, 1), new vidmode_t("Mode 2: 512x384", 512, 384, 2), new vidmode_t("Mode 3: 640x480", 640, 480, 3), new vidmode_t("Mode 4: 800x600", 800, 600, 4), new vidmode_t("Mode 5: 960x720", 960, 720, 5), new vidmode_t("Mode 6: 1024x768", 1024, 768, 6), new vidmode_t("Mode 7: 1152x864", 1152, 864, 7), new vidmode_t("Mode 8: 1280x1024", 1280, 1024, 8), new vidmode_t("Mode 9: 1600x1200", 1600, 1200, 9), new vidmode_t("Mode 10: 2048x1536", 2048, 1536, 10), new vidmode_t("Mode 11: user", 640, 480, 11)};
        s_opengl_menu = new Menu.menuframework_s();
        s_mode_list = new Menu.menulist_s();
        s_ref_list = new Menu.menulist_s();
        s_tq_slider = new Menu.menuslider_s();
        s_screensize_slider = new Menu.menuslider_s();
        s_brightness_slider = new Menu.menuslider_s();
        s_fs_box = new Menu.menulist_s();
        s_stipple_box = new Menu.menulist_s();
        s_paletted_texture_box = new Menu.menulist_s();
        s_vsync_box = new Menu.menulist_s();
        s_windowed_mouse = new Menu.menulist_s();
        s_apply_action = new Menu.menuaction_s();
        s_defaults_action = new Menu.menuaction_s();
        resolutions = new String[]{"[320 240  ]", "[400 300  ]", "[512 384  ]", "[640 480  ]", "[800 600  ]", "[960 720  ]", "[1024 768 ]", "[1152 864 ]", "[1280 1024]", "[1600 1200]", "[2048 1536]", "user mode"};
        yesno_names = new String[]{"no", "yes"};
    }
}

