/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL_ents;
import jake2.client.SCR;
import jake2.client.dlight_t;
import jake2.client.entity_t;
import jake2.client.lightstyle_t;
import jake2.client.particle_t;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.xcommand_t;
import jake2.sys.Timer;
import jake2.util.Math3D;
import jake2.util.Vargs;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class V
extends Globals {
    static cvar_t cl_testblend;
    static cvar_t cl_testparticles;
    static cvar_t cl_testentities;
    static cvar_t cl_testlights;
    static cvar_t cl_stats;
    static int r_numdlights;
    static dlight_t[] r_dlights;
    static int r_numentities;
    static entity_t[] r_entities;
    static int r_numparticles;
    static lightstyle_t[] r_lightstyles;
    private static final float[] origin;
    static xcommand_t Gun_Next_f;
    static xcommand_t Gun_Prev_f;
    static xcommand_t Gun_Model_f;
    static xcommand_t Viewpos_f;

    static void ClearScene() {
        r_numdlights = 0;
        r_numentities = 0;
        r_numparticles = 0;
    }

    static void AddEntity(entity_t ent) {
        if ((ent.flags & 2) != 0) {
            for (int i = 0; i < 3; ++i) {
                ent.oldorigin[i] = ent.origin[i] = V.cl.predicted_origin[i];
            }
            if (V.cl_3rd.value == 1.0f) {
                ent.flags &= 0xFFFFFFFD;
            }
        }
        if (r_numentities >= 128) {
            return;
        }
        r_entities[r_numentities++].set(ent);
    }

    static void AddParticle(float[] org, int color, float alpha) {
        if (r_numparticles >= 4096) {
            return;
        }
        int i = r_numparticles++;
        int c = particle_t.colorTable[color];
        particle_t.colorArray.put(i, c |= (int)(alpha * 255.0f) << 24);
        i *= 3;
        FloatBuffer vertexBuf = particle_t.vertexArray;
        vertexBuf.put(i++, org[0]);
        vertexBuf.put(i++, org[1]);
        vertexBuf.put(i++, org[2]);
    }

    static void AddLight(float[] org, float intensity, float r, float g, float b) {
        if (r_numdlights >= 32) {
            return;
        }
        dlight_t dl = r_dlights[r_numdlights++];
        Math3D.VectorCopy(org, dl.origin);
        dl.intensity = intensity;
        dl.color[0] = r;
        dl.color[1] = g;
        dl.color[2] = b;
    }

    static void AddLightStyle(int style, float r, float g, float b) {
        if (style < 0 || style > 256) {
            Com.Error(1, "Bad light style " + style);
        }
        lightstyle_t ls = r_lightstyles[style];
        ls.white = r + g + b;
        ls.rgb[0] = r;
        ls.rgb[1] = g;
        ls.rgb[2] = b;
    }

    static void TestParticles() {
        r_numparticles = 0;
        for (int i = 0; i < 4096; ++i) {
            float d = (float)i * 0.25f;
            float r = 4.0f * ((float)(i & 7) - 3.5f);
            float u = 4.0f * ((float)(i >> 3 & 7) - 3.5f);
            for (int j = 0; j < 3; ++j) {
                V.origin[j] = V.cl.refdef.vieworg[j] + V.cl.v_forward[j] * d + V.cl.v_right[j] * r + V.cl.v_up[j] * u;
            }
            V.AddParticle(origin, 8, V.cl_testparticles.value);
        }
    }

    static void TestEntities() {
        int i;
        r_numentities = 32;
        for (i = 0; i < r_entities.length; ++i) {
            r_entities[i].clear();
        }
        for (i = 0; i < r_numentities; ++i) {
            entity_t ent = r_entities[i];
            float r = 64.0f * ((float)(i % 4) - 1.5f);
            float f = 64 * (i / 4) + 128;
            for (int j = 0; j < 3; ++j) {
                ent.origin[j] = V.cl.refdef.vieworg[j] + V.cl.v_forward[j] * f + V.cl.v_right[j] * r;
            }
            ent.model = V.cl.baseclientinfo.model;
            ent.skin = V.cl.baseclientinfo.skin;
        }
    }

    static void TestLights() {
        int i;
        r_numdlights = 32;
        for (i = 0; i < r_dlights.length; ++i) {
            V.r_dlights[i] = new dlight_t();
        }
        for (i = 0; i < r_numdlights; ++i) {
            dlight_t dl = r_dlights[i];
            float r = 64.0f * ((float)(i % 4) - 1.5f);
            float f = 64 * (i / 4) + 128;
            for (int j = 0; j < 3; ++j) {
                dl.origin[j] = V.cl.refdef.vieworg[j] + V.cl.v_forward[j] * f + V.cl.v_right[j] * r;
            }
            dl.color[0] = i % 6 + 1 & 1;
            dl.color[1] = (i % 6 + 1 & 2) >> 1;
            dl.color[2] = (i % 6 + 1 & 4) >> 2;
            dl.intensity = 200.0f;
        }
    }

    static void RenderView(float stereo_separation) {
        if (V.cls.state != 4) {
            return;
        }
        if (!V.cl.refresh_prepped) {
            return;
        }
        if (V.cl_timedemo.value != 0.0f) {
            if (V.cl.timedemo_start == 0) {
                V.cl.timedemo_start = Timer.Milliseconds();
            }
            ++V.cl.timedemo_frames;
        }
        if (V.cl.frame.valid && (V.cl.force_refdef || V.cl_paused.value == 0.0f)) {
            V.cl.force_refdef = false;
            V.ClearScene();
            CL_ents.AddEntities();
            if (V.cl_testparticles.value != 0.0f) {
                V.TestParticles();
            }
            if (V.cl_testentities.value != 0.0f) {
                V.TestEntities();
            }
            if (V.cl_testlights.value != 0.0f) {
                V.TestLights();
            }
            if (V.cl_testblend.value != 0.0f) {
                V.cl.refdef.blend[0] = 1.0f;
                V.cl.refdef.blend[1] = 0.5f;
                V.cl.refdef.blend[2] = 0.25f;
                V.cl.refdef.blend[3] = 0.5f;
            }
            if (stereo_separation != 0.0f) {
                float[] tmp = new float[3];
                Math3D.VectorScale(V.cl.v_right, stereo_separation, tmp);
                Math3D.VectorAdd(V.cl.refdef.vieworg, tmp, V.cl.refdef.vieworg);
            }
            V.cl.refdef.vieworg[0] = (float)((double)V.cl.refdef.vieworg[0] + 0.0625);
            V.cl.refdef.vieworg[1] = (float)((double)V.cl.refdef.vieworg[1] + 0.0625);
            V.cl.refdef.vieworg[2] = (float)((double)V.cl.refdef.vieworg[2] + 0.0625);
            V.cl.refdef.x = V.scr_vrect.x;
            V.cl.refdef.y = V.scr_vrect.y;
            V.cl.refdef.width = V.scr_vrect.width;
            V.cl.refdef.height = V.scr_vrect.height;
            V.cl.refdef.fov_y = Math3D.CalcFov(V.cl.refdef.fov_x, V.cl.refdef.width, V.cl.refdef.height);
            V.cl.refdef.time = (float)V.cl.time * 0.001f;
            V.cl.refdef.areabits = V.cl.frame.areabits;
            Math3D.VectorCopy(V.cl.refdef.viewangles, V.cl.mapdef.viewangles);
            Math3D.VectorCopy(V.cl.refdef.vieworg, V.cl.mapdef.vieworg);
            V.cl.mapdef.vieworg[0] = (float)((double)V.cl.mapdef.vieworg[0] + 0.0625);
            V.cl.mapdef.vieworg[1] = (float)((double)V.cl.mapdef.vieworg[1] + 0.0625);
            V.cl.mapdef.vieworg[2] = (float)((double)V.cl.mapdef.vieworg[2] + 0.0625);
            V.cl.mapdef.x = (int)((double)(V.scr_vrect.x + viddef.getWidth()) - (((double)viddef.getWidth() - (double)viddef.getWidth() * 0.8) / 2.0 + (double)viddef.getWidth() * 0.8));
            V.cl.mapdef.y = (int)((double)V.scr_vrect.y + ((double)viddef.getHeight() - (double)viddef.getHeight() * 0.8) / 2.0);
            V.cl.mapdef.width = (int)((double)viddef.getWidth() * 0.8);
            V.cl.mapdef.height = (int)((double)viddef.getHeight() * 0.8);
            V.cl.mapdef.map_zoom = (int)Globals.cl_map_zoom.value;
            V.cl.mapdef.vieworg[2] = V.cl.mapdef.vieworg[2] + (float)V.cl.mapdef.map_zoom;
            V.cl.mapdef.blend[3] = 0.5f;
            V.cl.mapdef.fov_y = Math3D.CalcFov(V.cl.refdef.fov_x, V.cl.refdef.width, V.cl.refdef.height);
            V.cl.mapdef.time = (float)((double)V.cl.time * 0.001);
            V.cl.mapdef.viewangles[0] = 90.0f;
            V.cl.mapdef.areabits = V.cl.frame.areabits;
            V.cl.mapdef.lightstyles = r_lightstyles;
            if (V.cl_add_entities.value == 0.0f) {
                r_numentities = 0;
            }
            if (V.cl_add_particles.value == 0.0f) {
                r_numparticles = 0;
            }
            if (V.cl_add_lights.value == 0.0f) {
                r_numdlights = 0;
            }
            if (V.cl_add_blend.value == 0.0f) {
                Math3D.VectorClear(V.cl.refdef.blend);
            }
            V.cl.refdef.num_entities = r_numentities;
            V.cl.refdef.entities = r_entities;
            V.cl.refdef.num_particles = r_numparticles;
            V.cl.refdef.num_dlights = r_numdlights;
            V.cl.refdef.dlights = r_dlights;
            V.cl.refdef.lightstyles = r_lightstyles;
            V.cl.refdef.rdflags = V.cl.frame.playerstate.rdflags;
        }
        re.RenderFrame(V.cl.refdef);
        V.cl.mapdef.map_view = (int)Globals.cl_map.value;
        if (Globals.cl.mapdef.map_view != 0) {
            re.RenderFrame(V.cl.mapdef);
        }
        if (V.cl_stats.value != 0.0f) {
            Com.Printf("ent:%i  lt:%i  part:%i\n", new Vargs(3).add(r_numentities).add(r_numdlights).add(r_numparticles));
        }
        if (V.log_stats.value != 0.0f && log_stats_file != null) {
            try {
                log_stats_file.write(r_numentities + "," + r_numdlights + "," + r_numparticles);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SCR.AddDirtyPoint(V.scr_vrect.x, V.scr_vrect.y);
        SCR.AddDirtyPoint(V.scr_vrect.x + V.scr_vrect.width - 1, V.scr_vrect.y + V.scr_vrect.height - 1);
        SCR.DrawCrosshair();
    }

    public static void Init() {
        Cmd.AddCommand("gun_next", Gun_Next_f);
        Cmd.AddCommand("gun_prev", Gun_Prev_f);
        Cmd.AddCommand("gun_model", Gun_Model_f);
        Cmd.AddCommand("viewpos", Viewpos_f);
        crosshair = Cvar.Get("crosshair", "0", 1);
        cl_testblend = Cvar.Get("cl_testblend", "0", 0);
        cl_testparticles = Cvar.Get("cl_testparticles", "0", 0);
        cl_testentities = Cvar.Get("cl_testentities", "0", 0);
        cl_testlights = Cvar.Get("cl_testlights", "0", 0);
        cl_stats = Cvar.Get("cl_stats", "0", 0);
    }

    static {
        int i;
        r_dlights = new dlight_t[32];
        r_entities = new entity_t[128];
        r_lightstyles = new lightstyle_t[256];
        for (i = 0; i < r_dlights.length; ++i) {
            V.r_dlights[i] = new dlight_t();
        }
        for (i = 0; i < r_entities.length; ++i) {
            V.r_entities[i] = new entity_t();
        }
        for (i = 0; i < r_lightstyles.length; ++i) {
            V.r_lightstyles[i] = new lightstyle_t();
        }
        origin = new float[]{0.0f, 0.0f, 0.0f};
        Gun_Next_f = new xcommand_t(){

            public void execute() {
                Com.Printf("frame " + ++Globals.gun_frame + "\n");
            }
        };
        Gun_Prev_f = new xcommand_t(){

            public void execute() {
                if (--Globals.gun_frame < 0) {
                    Globals.gun_frame = 0;
                }
                Com.Printf("frame " + Globals.gun_frame + "\n");
            }
        };
        Gun_Model_f = new xcommand_t(){

            public void execute() {
                if (Cmd.Argc() != 2) {
                    Globals.gun_model = null;
                    return;
                }
                String name = "models/" + Cmd.Argv(1) + "/tris.md2";
                Globals.gun_model = Globals.re.RegisterModel(name);
            }
        };
        Viewpos_f = new xcommand_t(){

            public void execute() {
                Com.Printf("(%i %i %i) : %i\n", new Vargs(4).add((int)Globals.cl.refdef.vieworg[0]).add((int)Globals.cl.refdef.vieworg[1]).add((int)Globals.cl.refdef.vieworg[2]).add((int)Globals.cl.refdef.viewangles[1]));
            }
        };
    }
}

