/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL_inv;
import jake2.client.Console;
import jake2.client.LayoutParser;
import jake2.client.Menu;
import jake2.client.V;
import jake2.client.VID;
import jake2.client.clientinfo_t;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.qcommon.CDAudio;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.qcommon.qfiles;
import jake2.qcommon.xcommand_t;
import jake2.sound.S;
import jake2.sys.Timer;
import jake2.util.Vargs;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class SCR
extends Globals {
    static String[][] sb_nums = new String[][]{{"num_0", "num_1", "num_2", "num_3", "num_4", "num_5", "num_6", "num_7", "num_8", "num_9", "num_minus"}, {"anum_0", "anum_1", "anum_2", "anum_3", "anum_4", "anum_5", "anum_6", "anum_7", "anum_8", "anum_9", "anum_minus"}};
    static float scr_con_current;
    static float scr_conlines;
    static boolean scr_initialized;
    static int scr_draw_loading;
    static cvar_t scr_viewsize;
    static cvar_t scr_conspeed;
    static cvar_t scr_centertime;
    static cvar_t scr_showturtle;
    static cvar_t scr_showpause;
    static cvar_t scr_printspeed;
    static cvar_t scr_netgraph;
    static cvar_t scr_timegraph;
    static cvar_t scr_debuggraph;
    static cvar_t scr_graphheight;
    static cvar_t scr_graphscale;
    static cvar_t scr_graphshift;
    static cvar_t scr_drawall;
    public static cvar_t fps;
    static dirty_t scr_dirty;
    static dirty_t[] scr_old_dirty;
    static String crosshair_pic;
    static int crosshair_width;
    static int crosshair_height;
    static int current;
    static graphsamp_t[] values;
    static String scr_centerstring;
    static float scr_centertime_start;
    static float scr_centertime_off;
    static int scr_center_lines;
    static int scr_erase_center;
    static dirty_t clear;
    static final int STAT_MINUS = 10;
    static final int ICON_WIDTH = 24;
    static final int ICON_HEIGHT = 24;
    static final int CHAR_WIDTH = 16;
    static final int ICON_SPACE = 8;
    private static LayoutParser layoutParser;
    static final int STAT_LAYOUTS = 13;
    private static final float[] separation;
    private static xcommand_t updateScreenCallback;
    private static int lastframes;
    private static int lasttime;
    private static String fpsvalue;
    private static cinematics_t cin;
    private static byte[] compressed;

    public static void DebugGraph(float value, int color) {
        SCR.values[SCR.current & 0x3FF].value = value;
        SCR.values[SCR.current & 0x3FF].color = color;
        ++current;
    }

    static void DrawDebugGraph() {
        int w = SCR.scr_vrect.width;
        int x = SCR.scr_vrect.x;
        int y = SCR.scr_vrect.y + SCR.scr_vrect.height;
        re.DrawFill(x, (int)((float)y - SCR.scr_graphheight.value), w, (int)SCR.scr_graphheight.value, 8);
        for (int a = 0; a < w; ++a) {
            int i = current - 1 - a + 1024 & 0x3FF;
            float v = SCR.values[i].value;
            int color = SCR.values[i].color;
            if ((v = v * SCR.scr_graphscale.value + SCR.scr_graphshift.value) < 0.0f) {
                v += SCR.scr_graphheight.value * (float)(1 + (int)(-v / SCR.scr_graphheight.value));
            }
            int h = (int)v % (int)SCR.scr_graphheight.value;
            re.DrawFill(x + w - 1 - a, y - h, 1, h, color);
        }
    }

    static void CenterPrint(String str) {
        int s;
        StringBuffer line = new StringBuffer(64);
        scr_centerstring = str;
        scr_centertime_off = SCR.scr_centertime.value;
        scr_centertime_start = SCR.cl.time;
        scr_center_lines = 1;
        for (s = 0; s < str.length(); ++s) {
            if (str.charAt(s) != '\n') continue;
            ++scr_center_lines;
        }
        Com.Printf("\n\n\u001d\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001f\n\n");
        s = 0;
        if (str.length() != 0) {
            while (true) {
                int l;
                for (l = 0; l < 40 && l + s < str.length() && str.charAt(s + l) != '\n' && str.charAt(s + l) != '\u0000'; ++l) {
                }
                for (int i = 0; i < (40 - l) / 2; ++i) {
                    line.append(' ');
                }
                for (int j = 0; j < l; ++j) {
                    line.append(str.charAt(s + j));
                }
                line.append('\n');
                Com.Printf(line.toString());
                while (s < str.length() && str.charAt(s) != '\n') {
                    ++s;
                }
                if (s == str.length()) break;
                ++s;
            }
        }
        Com.Printf("\n\n\u001d\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001f\n\n");
        Console.ClearNotify();
    }

    static void DrawCenterString() {
        String cs = scr_centerstring + "\u0000";
        if (cs == null) {
            return;
        }
        if (cs.length() == 0) {
            return;
        }
        int remaining = 9999;
        scr_erase_center = 0;
        int start = 0;
        int y = scr_center_lines <= 4 ? (int)((double)viddef.getHeight() * 0.35) : 48;
        while (true) {
            int l;
            for (l = 0; l < 40 && start + l != cs.length() - 1 && cs.charAt(start + l) != '\n'; ++l) {
            }
            int x = (viddef.getWidth() - l * 8) / 2;
            SCR.AddDirtyPoint(x, y);
            int j = 0;
            while (j < l) {
                re.DrawChar(x, y, cs.charAt(start + j));
                if (remaining == 0) {
                    return;
                }
                --remaining;
                ++j;
                x += 8;
            }
            SCR.AddDirtyPoint(x, y + 8);
            y += 8;
            while (start < cs.length() && cs.charAt(start) != '\n') {
                ++start;
            }
            if (start == cs.length()) break;
            ++start;
        }
    }

    static void CheckDrawCenterString() {
        if ((scr_centertime_off -= SCR.cls.frametime) <= 0.0f) {
            return;
        }
        SCR.DrawCenterString();
    }

    static void CalcVrect() {
        if (SCR.scr_viewsize.value < 40.0f) {
            Cvar.Set("viewsize", "40");
        }
        if (SCR.scr_viewsize.value > 100.0f) {
            Cvar.Set("viewsize", "100");
        }
        int size = (int)SCR.scr_viewsize.value;
        SCR.scr_vrect.width = viddef.getWidth() * size / 100;
        SCR.scr_vrect.width &= 0xFFFFFFF8;
        SCR.scr_vrect.height = viddef.getHeight() * size / 100;
        SCR.scr_vrect.height &= 0xFFFFFFFE;
        SCR.scr_vrect.x = (viddef.getWidth() - SCR.scr_vrect.width) / 2;
        SCR.scr_vrect.y = (viddef.getHeight() - SCR.scr_vrect.height) / 2;
    }

    static void SizeUp_f() {
        Cvar.SetValue("viewsize", SCR.scr_viewsize.value + 10.0f);
    }

    static void SizeDown_f() {
        Cvar.SetValue("viewsize", SCR.scr_viewsize.value - 10.0f);
    }

    static void Sky_f() {
        float[] axis = new float[]{0.0f, 0.0f, 0.0f};
        if (Cmd.Argc() < 2) {
            Com.Printf("Usage: sky <basename> <rotate> <axis x y z>\n");
            return;
        }
        float rotate = Cmd.Argc() > 2 ? Float.parseFloat(Cmd.Argv(2)) : 0.0f;
        if (Cmd.Argc() == 6) {
            axis[0] = Float.parseFloat(Cmd.Argv(3));
            axis[1] = Float.parseFloat(Cmd.Argv(4));
            axis[2] = Float.parseFloat(Cmd.Argv(5));
        } else {
            axis[0] = 0.0f;
            axis[1] = 0.0f;
            axis[2] = 1.0f;
        }
        re.SetSky(Cmd.Argv(1), rotate, axis);
    }

    static void Init() {
        scr_viewsize = Cvar.Get("viewsize", "100", 1);
        scr_conspeed = Cvar.Get("scr_conspeed", "3", 0);
        scr_showturtle = Cvar.Get("scr_showturtle", "0", 0);
        scr_showpause = Cvar.Get("scr_showpause", "1", 0);
        scr_centertime = Cvar.Get("scr_centertime", "2.5", 0);
        scr_printspeed = Cvar.Get("scr_printspeed", "8", 0);
        scr_netgraph = Cvar.Get("netgraph", "1", 0);
        scr_timegraph = Cvar.Get("timegraph", "1", 0);
        scr_debuggraph = Cvar.Get("debuggraph", "1", 0);
        scr_graphheight = Cvar.Get("graphheight", "32", 0);
        scr_graphscale = Cvar.Get("graphscale", "1", 0);
        scr_graphshift = Cvar.Get("graphshift", "0", 0);
        scr_drawall = Cvar.Get("scr_drawall", "1", 0);
        fps = Cvar.Get("fps", "0", 0);
        Cmd.AddCommand("timerefresh", new xcommand_t(){

            public void execute() {
                SCR.TimeRefresh_f();
            }
        });
        Cmd.AddCommand("loading", new xcommand_t(){

            public void execute() {
                SCR.Loading_f();
            }
        });
        Cmd.AddCommand("sizeup", new xcommand_t(){

            public void execute() {
                SCR.SizeUp_f();
            }
        });
        Cmd.AddCommand("sizedown", new xcommand_t(){

            public void execute() {
                SCR.SizeDown_f();
            }
        });
        Cmd.AddCommand("sky", new xcommand_t(){

            public void execute() {
                SCR.Sky_f();
            }
        });
        scr_initialized = true;
    }

    static void DrawNet() {
        if (SCR.cls.netchan.outgoing_sequence - SCR.cls.netchan.incoming_acknowledged < CMD_BACKUP - 1) {
            return;
        }
        re.DrawPic(SCR.scr_vrect.x + 64, SCR.scr_vrect.y, "net");
    }

    static void DrawPause() {
        Dimension dim = new Dimension();
        if (SCR.scr_showpause.value == 0.0f) {
            return;
        }
        if (SCR.cl_paused.value == 0.0f) {
            return;
        }
        re.DrawGetPicSize(dim, "pause");
        re.DrawPic((viddef.getWidth() - dim.width) / 2, viddef.getHeight() / 2 + 8, "pause");
    }

    static void DrawLoading() {
        Dimension dim = new Dimension();
        if (scr_draw_loading == 0) {
            return;
        }
        scr_draw_loading = 0;
        re.DrawGetPicSize(dim, "loading");
        re.DrawPic((viddef.getWidth() - dim.width) / 2, (viddef.getHeight() - dim.height) / 2, "loading");
    }

    static void RunConsole() {
        scr_conlines = SCR.cls.key_dest == 1 ? 0.5f : 0.0f;
        if (scr_conlines < scr_con_current) {
            if (scr_conlines > (scr_con_current -= SCR.scr_conspeed.value * SCR.cls.frametime)) {
                scr_con_current = scr_conlines;
            }
        } else if (scr_conlines > scr_con_current && scr_conlines < (scr_con_current += SCR.scr_conspeed.value * SCR.cls.frametime)) {
            scr_con_current = scr_conlines;
        }
    }

    static void DrawConsole() {
        Console.CheckResize();
        if (SCR.cls.state == 1 || SCR.cls.state == 2) {
            Console.DrawConsole(1.0f);
            return;
        }
        if (SCR.cls.state != 4 || !SCR.cl.refresh_prepped) {
            Console.DrawConsole(0.5f);
            re.DrawFill(0, viddef.getHeight() / 2, viddef.getWidth(), viddef.getHeight() / 2, 0);
            return;
        }
        if (scr_con_current != 0.0f) {
            Console.DrawConsole(scr_con_current);
        } else if (SCR.cls.key_dest == 0 || SCR.cls.key_dest == 2) {
            Console.DrawNotify();
        }
    }

    public static void BeginLoadingPlaque() {
        S.StopAllSounds();
        SCR.cl.sound_prepped = false;
        CDAudio.Stop();
        if (SCR.cls.disable_screen != 0.0f) {
            return;
        }
        if (SCR.developer.value != 0.0f) {
            return;
        }
        if (SCR.cls.state == 1) {
            return;
        }
        if (SCR.cls.key_dest == 1) {
            return;
        }
        scr_draw_loading = SCR.cl.cinematictime > 0 ? 2 : 1;
        SCR.UpdateScreen();
        SCR.cls.disable_screen = Timer.Milliseconds();
        SCR.cls.disable_servercount = SCR.cl.servercount;
    }

    public static void EndLoadingPlaque() {
        SCR.cls.disable_screen = 0.0f;
        Console.ClearNotify();
    }

    static void Loading_f() {
        SCR.BeginLoadingPlaque();
    }

    static void TimeRefresh_f() {
        if (SCR.cls.state != 4) {
            return;
        }
        int start = Timer.Milliseconds();
        if (Cmd.Argc() == 2) {
            re.BeginFrame(0.0f);
            for (int i = 0; i < 128; ++i) {
                SCR.cl.refdef.viewangles[1] = (float)i / 128.0f * 360.0f;
                re.RenderFrame(SCR.cl.refdef);
            }
            re.EndFrame();
        } else {
            for (int i = 0; i < 128; ++i) {
                SCR.cl.refdef.viewangles[1] = (float)i / 128.0f * 360.0f;
                re.BeginFrame(0.0f);
                re.RenderFrame(SCR.cl.refdef);
                re.EndFrame();
            }
        }
        int stop = Timer.Milliseconds();
        float time = (float)(stop - start) / 1000.0f;
        Com.Printf("%f seconds (%f fps)\n", new Vargs(2).add(time).add(128.0f / time));
    }

    static void DirtyScreen() {
        SCR.AddDirtyPoint(0, 0);
        SCR.AddDirtyPoint(viddef.getWidth() - 1, viddef.getHeight() - 1);
    }

    static void TileClear() {
        int i;
        clear.clear();
        if (SCR.scr_drawall.value != 0.0f) {
            SCR.DirtyScreen();
        }
        if (scr_con_current == 1.0f) {
            return;
        }
        if (SCR.scr_viewsize.value == 100.0f) {
            return;
        }
        if (SCR.cl.cinematictime > 0) {
            return;
        }
        clear.set(scr_dirty);
        for (i = 0; i < 2; ++i) {
            if (SCR.scr_old_dirty[i].x1 < SCR.clear.x1) {
                SCR.clear.x1 = SCR.scr_old_dirty[i].x1;
            }
            if (SCR.scr_old_dirty[i].x2 > SCR.clear.x2) {
                SCR.clear.x2 = SCR.scr_old_dirty[i].x2;
            }
            if (SCR.scr_old_dirty[i].y1 < SCR.clear.y1) {
                SCR.clear.y1 = SCR.scr_old_dirty[i].y1;
            }
            if (SCR.scr_old_dirty[i].y2 <= SCR.clear.y2) continue;
            SCR.clear.y2 = SCR.scr_old_dirty[i].y2;
        }
        scr_old_dirty[1].set(scr_old_dirty[0]);
        scr_old_dirty[0].set(scr_dirty);
        SCR.scr_dirty.x1 = 9999;
        SCR.scr_dirty.x2 = -9999;
        SCR.scr_dirty.y1 = 9999;
        SCR.scr_dirty.y2 = -9999;
        int top = (int)(scr_con_current * (float)viddef.getHeight());
        if (top >= SCR.clear.y1) {
            SCR.clear.y1 = top;
        }
        if (SCR.clear.y2 <= SCR.clear.y1) {
            return;
        }
        top = SCR.scr_vrect.y;
        int bottom = top + SCR.scr_vrect.height - 1;
        int left = SCR.scr_vrect.x;
        int right = left + SCR.scr_vrect.width - 1;
        if (SCR.clear.y1 < top) {
            i = SCR.clear.y2 < top - 1 ? SCR.clear.y2 : top - 1;
            re.DrawTileClear(SCR.clear.x1, SCR.clear.y1, SCR.clear.x2 - SCR.clear.x1 + 1, i - SCR.clear.y1 + 1, "backtile");
            SCR.clear.y1 = top;
        }
        if (SCR.clear.y2 > bottom) {
            i = SCR.clear.y1 > bottom + 1 ? SCR.clear.y1 : bottom + 1;
            re.DrawTileClear(SCR.clear.x1, i, SCR.clear.x2 - SCR.clear.x1 + 1, SCR.clear.y2 - i + 1, "backtile");
            SCR.clear.y2 = bottom;
        }
        if (SCR.clear.x1 < left) {
            i = SCR.clear.x2 < left - 1 ? SCR.clear.x2 : left - 1;
            re.DrawTileClear(SCR.clear.x1, SCR.clear.y1, i - SCR.clear.x1 + 1, SCR.clear.y2 - SCR.clear.y1 + 1, "backtile");
            SCR.clear.x1 = left;
        }
        if (SCR.clear.x2 > right) {
            i = SCR.clear.x1 > right + 1 ? SCR.clear.x1 : right + 1;
            re.DrawTileClear(i, SCR.clear.y1, SCR.clear.x2 - i + 1, SCR.clear.y2 - SCR.clear.y1 + 1, "backtile");
            SCR.clear.x2 = right;
        }
    }

    static void SizeHUDString(String string, Dimension dim) {
        int lines = 1;
        int width = 0;
        int current = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++lines;
                current = 0;
                continue;
            }
            if (++current <= width) continue;
            width = current;
        }
        dim.width = width * 8;
        dim.height = lines * 8;
    }

    static void DrawHUDString(String string, int x, int y, int centerwidth, int xor) {
        StringBuffer line = new StringBuffer(1024);
        int margin = x;
        int l = 0;
        while (l < string.length()) {
            line = new StringBuffer(1024);
            while (l < string.length() && string.charAt(l) != '\n') {
                line.append(string.charAt(l));
                ++l;
            }
            x = centerwidth != 0 ? margin + (centerwidth - line.length() * 8) / 2 : margin;
            for (int i = 0; i < line.length(); ++i) {
                re.DrawChar(x, y, line.charAt(i) ^ xor);
                x += 8;
            }
            if (l >= string.length()) continue;
            ++l;
            x = margin;
            y += 8;
        }
    }

    static void DrawField(int x, int y, int color, int width, int value) {
        if (width < 1) {
            return;
        }
        if (width > 5) {
            width = 5;
        }
        SCR.AddDirtyPoint(x, y);
        SCR.AddDirtyPoint(x + width * 16 + 2, y + 23);
        String num = String.valueOf(value);
        int l = num.length();
        if (l > width) {
            l = width;
        }
        x += 2 + 16 * (width - l);
        char ptr = num.charAt(0);
        for (int i = 0; i < l; ++i) {
            ptr = num.charAt(i);
            int frame = ptr == '-' ? 10 : ptr - 48;
            re.DrawPic(x, y, sb_nums[color][frame]);
            x += 16;
        }
    }

    static void TouchPics() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 11; ++j) {
                re.RegisterPic(sb_nums[i][j]);
            }
        }
        if (SCR.crosshair.value != 0.0f) {
            if (SCR.crosshair.value > 3.0f || SCR.crosshair.value < 0.0f) {
                SCR.crosshair.value = 3.0f;
            }
            crosshair_pic = "ch" + (int)SCR.crosshair.value;
            Dimension dim = new Dimension();
            re.DrawGetPicSize(dim, crosshair_pic);
            crosshair_width = dim.width;
            crosshair_height = dim.height;
            if (crosshair_width == 0) {
                crosshair_pic = "";
            }
        }
    }

    static void ExecuteLayoutString(String s) {
        if (SCR.cls.state != 4 || !SCR.cl.refresh_prepped) {
            return;
        }
        if (s == null || s.length() == 0) {
            return;
        }
        int x = 0;
        int y = 0;
        int width = 3;
        LayoutParser parser = layoutParser;
        parser.init(s);
        while (parser.hasNext()) {
            int color;
            int ping;
            int score;
            int value;
            parser.next();
            if (parser.tokenEquals("xl")) {
                parser.next();
                x = parser.tokenAsInt();
                continue;
            }
            if (parser.tokenEquals("xr")) {
                parser.next();
                x = viddef.getWidth() + parser.tokenAsInt();
                continue;
            }
            if (parser.tokenEquals("xv")) {
                parser.next();
                x = viddef.getWidth() / 2 - 160 + parser.tokenAsInt();
                continue;
            }
            if (parser.tokenEquals("yt")) {
                parser.next();
                y = parser.tokenAsInt();
                continue;
            }
            if (parser.tokenEquals("yb")) {
                parser.next();
                y = viddef.getHeight() + parser.tokenAsInt();
                continue;
            }
            if (parser.tokenEquals("yv")) {
                parser.next();
                y = viddef.getHeight() / 2 - 120 + parser.tokenAsInt();
                continue;
            }
            if (parser.tokenEquals("pic")) {
                parser.next();
                value = SCR.cl.frame.playerstate.stats[parser.tokenAsInt()];
                if (value >= 256) {
                    Com.Error(1, "Pic >= MAX_IMAGES");
                }
                if (SCR.cl.configstrings[544 + value] == null) continue;
                SCR.AddDirtyPoint(x, y);
                SCR.AddDirtyPoint(x + 23, y + 23);
                re.DrawPic(x, y, SCR.cl.configstrings[544 + value]);
                continue;
            }
            if (parser.tokenEquals("client")) {
                parser.next();
                x = viddef.getWidth() / 2 - 160 + parser.tokenAsInt();
                parser.next();
                y = viddef.getHeight() / 2 - 120 + parser.tokenAsInt();
                SCR.AddDirtyPoint(x, y);
                SCR.AddDirtyPoint(x + 159, y + 31);
                parser.next();
                value = parser.tokenAsInt();
                if (value >= 256 || value < 0) {
                    Com.Error(1, "client >= MAX_CLIENTS");
                }
                clientinfo_t ci = SCR.cl.clientinfo[value];
                parser.next();
                score = parser.tokenAsInt();
                parser.next();
                ping = parser.tokenAsInt();
                parser.next();
                int time = parser.tokenAsInt();
                Console.DrawAltString(x + 32, y, ci.name);
                Console.DrawString(x + 32, y + 8, "Score: ");
                Console.DrawAltString(x + 32 + 56, y + 8, "" + score);
                Console.DrawString(x + 32, y + 16, "Ping:  " + ping);
                Console.DrawString(x + 32, y + 24, "Time:  " + time);
                if (ci.icon == null) {
                    ci = SCR.cl.baseclientinfo;
                }
                re.DrawPic(x, y, ci.iconname);
                continue;
            }
            if (parser.tokenEquals("ctf")) {
                parser.next();
                x = viddef.getWidth() / 2 - 160 + parser.tokenAsInt();
                parser.next();
                y = viddef.getHeight() / 2 - 120 + parser.tokenAsInt();
                SCR.AddDirtyPoint(x, y);
                SCR.AddDirtyPoint(x + 159, y + 31);
                parser.next();
                value = parser.tokenAsInt();
                if (value >= 256 || value < 0) {
                    Com.Error(1, "client >= MAX_CLIENTS");
                }
                clientinfo_t ci = SCR.cl.clientinfo[value];
                parser.next();
                score = parser.tokenAsInt();
                parser.next();
                ping = parser.tokenAsInt();
                if (ping > 999) {
                    ping = 999;
                }
                String block = Com.sprintf("%3d %3d %-12.12s", new Vargs(3).add(score).add(ping).add(ci.name));
                if (value == SCR.cl.playernum) {
                    Console.DrawAltString(x, y, block);
                    continue;
                }
                Console.DrawString(x, y, block);
                continue;
            }
            if (parser.tokenEquals("picn")) {
                parser.next();
                SCR.AddDirtyPoint(x, y);
                SCR.AddDirtyPoint(x + 23, y + 23);
                re.DrawPic(x, y, parser.token());
                continue;
            }
            if (parser.tokenEquals("num")) {
                parser.next();
                width = parser.tokenAsInt();
                parser.next();
                value = SCR.cl.frame.playerstate.stats[parser.tokenAsInt()];
                SCR.DrawField(x, y, 0, width, value);
                continue;
            }
            if (parser.tokenEquals("hnum")) {
                width = 3;
                value = SCR.cl.frame.playerstate.stats[1];
                color = value > 25 ? 0 : (value > 0 ? SCR.cl.frame.serverframe >> 2 & 1 : 1);
                if ((SCR.cl.frame.playerstate.stats[15] & 1) != 0) {
                    re.DrawPic(x, y, "field_3");
                }
                SCR.DrawField(x, y, color, width, value);
                continue;
            }
            if (parser.tokenEquals("anum")) {
                width = 3;
                value = SCR.cl.frame.playerstate.stats[3];
                if (value > 5) {
                    color = 0;
                } else {
                    if (value < 0) continue;
                    color = SCR.cl.frame.serverframe >> 2 & 1;
                }
                if ((SCR.cl.frame.playerstate.stats[15] & 4) != 0) {
                    re.DrawPic(x, y, "field_3");
                }
                SCR.DrawField(x, y, color, width, value);
                continue;
            }
            if (parser.tokenEquals("rnum")) {
                width = 3;
                value = SCR.cl.frame.playerstate.stats[5];
                if (value < 1) continue;
                color = 0;
                if ((SCR.cl.frame.playerstate.stats[15] & 2) != 0) {
                    re.DrawPic(x, y, "field_3");
                }
                SCR.DrawField(x, y, color, width, value);
                continue;
            }
            if (parser.tokenEquals("stat_string")) {
                parser.next();
                int index = parser.tokenAsInt();
                if (index < 0 || index >= 2080) {
                    Com.Error(1, "Bad stat_string index");
                }
                if ((index = SCR.cl.frame.playerstate.stats[index]) < 0 || index >= 2080) {
                    Com.Error(1, "Bad stat_string index");
                }
                Console.DrawString(x, y, SCR.cl.configstrings[index]);
                continue;
            }
            if (parser.tokenEquals("cstring")) {
                parser.next();
                SCR.DrawHUDString(parser.token(), x, y, 320, 0);
                continue;
            }
            if (parser.tokenEquals("string")) {
                parser.next();
                Console.DrawString(x, y, parser.token());
                continue;
            }
            if (parser.tokenEquals("cstring2")) {
                parser.next();
                SCR.DrawHUDString(parser.token(), x, y, 320, 128);
                continue;
            }
            if (parser.tokenEquals("string2")) {
                parser.next();
                Console.DrawAltString(x, y, parser.token());
                continue;
            }
            if (!parser.tokenEquals("if")) continue;
            parser.next();
            value = SCR.cl.frame.playerstate.stats[parser.tokenAsInt()];
            if (value != 0) continue;
            parser.next();
            while (parser.hasNext() && !parser.tokenEquals("endif")) {
                parser.next();
            }
        }
    }

    static void DrawStats() {
        SCR.ExecuteLayoutString(SCR.cl.configstrings[5]);
    }

    static void DrawLayout() {
        if (SCR.cl.frame.playerstate.stats[13] != 0) {
            SCR.ExecuteLayoutString(SCR.cl.layout);
        }
    }

    static void UpdateScreen2() {
        int numframes;
        if (SCR.cls.disable_screen != 0.0f) {
            if ((float)Timer.Milliseconds() - SCR.cls.disable_screen > 120000.0f) {
                SCR.cls.disable_screen = 0.0f;
                Com.Printf("Loading plaque timed out.\n");
            }
            return;
        }
        if (!scr_initialized || !SCR.con.initialized) {
            return;
        }
        if ((double)SCR.cl_stereo_separation.value > 1.0) {
            Cvar.SetValue("cl_stereo_separation", 1.0f);
        } else if (SCR.cl_stereo_separation.value < 0.0f) {
            Cvar.SetValue("cl_stereo_separation", 0.0f);
        }
        if (SCR.cl_stereo.value != 0.0f) {
            numframes = 2;
            SCR.separation[0] = -SCR.cl_stereo_separation.value / 2.0f;
            SCR.separation[1] = SCR.cl_stereo_separation.value / 2.0f;
        } else {
            SCR.separation[0] = 0.0f;
            SCR.separation[1] = 0.0f;
            numframes = 1;
        }
        for (int i = 0; i < numframes; ++i) {
            re.BeginFrame(separation[i]);
            if (scr_draw_loading == 2) {
                Dimension dim = new Dimension();
                re.CinematicSetPalette(null);
                scr_draw_loading = 0;
                re.DrawGetPicSize(dim, "loading");
                re.DrawPic((viddef.getWidth() - dim.width) / 2, (viddef.getHeight() - dim.height) / 2, "loading");
                continue;
            }
            if (SCR.cl.cinematictime > 0) {
                if (SCR.cls.key_dest == 3) {
                    if (SCR.cl.cinematicpalette_active) {
                        re.CinematicSetPalette(null);
                        SCR.cl.cinematicpalette_active = false;
                    }
                    Menu.Draw();
                    continue;
                }
                if (SCR.cls.key_dest == 1) {
                    if (SCR.cl.cinematicpalette_active) {
                        re.CinematicSetPalette(null);
                        SCR.cl.cinematicpalette_active = false;
                    }
                    SCR.DrawConsole();
                    continue;
                }
                SCR.DrawCinematic();
                continue;
            }
            if (SCR.cl.cinematicpalette_active) {
                re.CinematicSetPalette(null);
                SCR.cl.cinematicpalette_active = false;
            }
            SCR.CalcVrect();
            SCR.TileClear();
            V.RenderView(separation[i]);
            SCR.DrawStats();
            if ((SCR.cl.frame.playerstate.stats[13] & 1) != 0) {
                SCR.DrawLayout();
            }
            if ((SCR.cl.frame.playerstate.stats[13] & 2) != 0) {
                CL_inv.DrawInventory();
            }
            SCR.DrawNet();
            SCR.CheckDrawCenterString();
            SCR.DrawFPS();
            SCR.DrawPause();
            SCR.DrawConsole();
            Menu.Draw();
            SCR.DrawLoading();
        }
        Globals.re.EndFrame();
    }

    static void DrawCrosshair() {
        if (SCR.crosshair.value == 0.0f) {
            return;
        }
        if (SCR.crosshair.modified) {
            SCR.crosshair.modified = false;
            SCR.TouchPics();
        }
        if (crosshair_pic.length() == 0) {
            return;
        }
        re.DrawPic(SCR.scr_vrect.x + (SCR.scr_vrect.width - crosshair_width >> 1), SCR.scr_vrect.y + (SCR.scr_vrect.height - crosshair_height >> 1), crosshair_pic);
    }

    public static void UpdateScreen() {
        Globals.re.updateScreen(updateScreenCallback);
    }

    static void AddDirtyPoint(int x, int y) {
        if (x < SCR.scr_dirty.x1) {
            SCR.scr_dirty.x1 = x;
        }
        if (x > SCR.scr_dirty.x2) {
            SCR.scr_dirty.x2 = x;
        }
        if (y < SCR.scr_dirty.y1) {
            SCR.scr_dirty.y1 = y;
        }
        if (y > SCR.scr_dirty.y2) {
            SCR.scr_dirty.y2 = y;
        }
    }

    static void DrawFPS() {
        if (SCR.fps.value > 0.0f) {
            int diff;
            if (SCR.fps.modified) {
                SCR.fps.modified = false;
                Cvar.SetValue("cl_maxfps", 1000);
            }
            if ((diff = SCR.cls.realtime - lasttime) > (int)(SCR.fps.value * 1000.0f)) {
                fpsvalue = (float)((SCR.cls.framecount - lastframes) * 100000 / diff) / 100.0f + " fps";
                lastframes = SCR.cls.framecount;
                lasttime = SCR.cls.realtime;
            }
            int x = viddef.getWidth() - 8 * fpsvalue.length() - 2;
            for (int i = 0; i < fpsvalue.length(); ++i) {
                re.DrawChar(x, 2, fpsvalue.charAt(i));
                x += 8;
            }
        } else if (SCR.fps.modified) {
            SCR.fps.modified = false;
            Cvar.SetValue("cl_maxfps", 90);
        }
    }

    static int LoadPCX(String filename, byte[] palette, cinematics_t cin) {
        ByteBuffer raw = FS.LoadMappedFile(filename);
        if (raw == null) {
            VID.Printf(1, "Bad pcx file " + filename + '\n');
            return 0;
        }
        qfiles.pcx_t pcx = new qfiles.pcx_t(raw);
        if (pcx.manufacturer != 10 || pcx.version != 5 || pcx.encoding != 1 || pcx.bits_per_pixel != 8 || pcx.xmax >= 640 || pcx.ymax >= 480) {
            VID.Printf(0, "Bad pcx file " + filename + '\n');
            return 0;
        }
        int width = pcx.xmax - pcx.xmin + 1;
        int height = pcx.ymax - pcx.ymin + 1;
        byte[] pix = new byte[width * height];
        if (palette != null) {
            raw.position(raw.limit() - 768);
            raw.get(palette);
        }
        if (cin != null) {
            cin.pic = pix;
            cin.width = width;
            cin.height = height;
        }
        int count = 0;
        byte dataByte = 0;
        int runLength = 0;
        int p = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (((dataByte = pcx.data.get(p++)) & 0xC0) == 192) {
                    runLength = dataByte & 0x3F;
                    dataByte = pcx.data.get(p++);
                    while (runLength-- > 0) {
                        pix[count++] = dataByte;
                        ++x;
                    }
                    continue;
                }
                pix[count++] = dataByte;
                ++x;
            }
        }
        return width * height;
    }

    static void StopCinematic() {
        if (SCR.cin.restart_sound) {
            SCR.cl.cinematictime = 0;
            SCR.cin.pic = null;
            SCR.cin.pic_pending = null;
            if (SCR.cl.cinematicpalette_active) {
                re.CinematicSetPalette(null);
                SCR.cl.cinematicpalette_active = false;
            }
            if (SCR.cl.cinematic_file != null) {
                SCR.cl.cinematic_file = null;
            }
            if (SCR.cin.hnodes1 != null) {
                SCR.cin.hnodes1 = null;
            }
            S.disableStreaming();
            SCR.cin.restart_sound = false;
        }
    }

    static void FinishCinematic() {
        MSG.WriteByte(SCR.cls.netchan.message, 4);
        SZ.Print(SCR.cls.netchan.message, "nextserver " + SCR.cl.servercount + '\n');
    }

    private static int SmallestNode1(int numhnodes) {
        int best = 99999999;
        int bestnode = -1;
        for (int i = 0; i < numhnodes; ++i) {
            if (SCR.cin.h_used[i] != 0 || SCR.cin.h_count[i] == 0 || SCR.cin.h_count[i] >= best) continue;
            best = SCR.cin.h_count[i];
            bestnode = i;
        }
        if (bestnode == -1) {
            return -1;
        }
        SCR.cin.h_used[bestnode] = 1;
        return bestnode;
    }

    private static void Huff1TableInit() {
        byte[] counts = new byte[256];
        SCR.cin.hnodes1 = new int[131072];
        Arrays.fill(SCR.cin.hnodes1, 0);
        for (int prev = 0; prev < 256; ++prev) {
            int numhnodes;
            Arrays.fill(SCR.cin.h_count, 0);
            Arrays.fill(SCR.cin.h_used, 0);
            SCR.cl.cinematic_file.get(counts);
            for (int j = 0; j < 256; ++j) {
                SCR.cin.h_count[j] = counts[j] & 0xFF;
            }
            int nodebase = 0 + prev * 256 * 2;
            int index = 0;
            int[] node = SCR.cin.hnodes1;
            for (numhnodes = 256; numhnodes != 511; ++numhnodes) {
                index = nodebase + (numhnodes - 256) * 2;
                node[index] = SCR.SmallestNode1(numhnodes);
                if (node[index] == -1) break;
                node[index + 1] = SCR.SmallestNode1(numhnodes);
                if (node[index + 1] == -1) break;
                SCR.cin.h_count[numhnodes] = SCR.cin.h_count[node[index]] + SCR.cin.h_count[node[index + 1]];
            }
            SCR.cin.numhnodes1[prev] = numhnodes - 1;
        }
    }

    private static byte[] Huff1Decompress(byte[] in, int size) {
        int hnodesbase;
        int count = in[0] & 0xFF | (in[1] & 0xFF) << 8 | (in[2] & 0xFF) << 16 | (in[3] & 0xFF) << 24;
        int input = 4;
        byte[] out = new byte[count];
        int out_p = 0;
        int index = hnodesbase = -512;
        int[] hnodes = SCR.cin.hnodes1;
        int nodenum = SCR.cin.numhnodes1[0];
        while (count != 0) {
            int inbyte = in[input++] & 0xFF;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
            if (nodenum < 256) {
                index = hnodesbase + (nodenum << 9);
                out[out_p++] = (byte)nodenum;
                if (--count == 0) break;
                nodenum = SCR.cin.numhnodes1[nodenum];
            }
            nodenum = hnodes[index + nodenum * 2 + (inbyte & 1)];
            inbyte >>= 1;
        }
        if (input != size && input != size + 1) {
            Com.Printf("Decompression overread by " + (input - size));
        }
        return out;
    }

    static byte[] ReadNextFrame() {
        int size;
        ByteBuffer file = SCR.cl.cinematic_file;
        int command = file.getInt();
        if (command == 2) {
            return null;
        }
        if (command == 1) {
            file.get(SCR.cl.cinematicpalette);
            SCR.cl.cinematicpalette_active = false;
        }
        if ((size = file.getInt()) > compressed.length || size < 1) {
            Com.Error(1, "Bad compressed frame size:" + size);
        }
        file.get(compressed, 0, size);
        int start = SCR.cl.cinematicframe * SCR.cin.s_rate / 14;
        int end = (SCR.cl.cinematicframe + 1) * SCR.cin.s_rate / 14;
        int count = end - start;
        S.RawSamples(count, SCR.cin.s_rate, SCR.cin.s_width, SCR.cin.s_channels, file.slice());
        file.position(file.position() + count * SCR.cin.s_width * SCR.cin.s_channels);
        byte[] pic = SCR.Huff1Decompress(compressed, size);
        ++SCR.cl.cinematicframe;
        return pic;
    }

    static void RunCinematic() {
        if (SCR.cl.cinematictime <= 0) {
            SCR.StopCinematic();
            return;
        }
        if (SCR.cl.cinematicframe == -1) {
            return;
        }
        if (SCR.cls.key_dest != 0) {
            SCR.cl.cinematictime = SCR.cls.realtime - SCR.cl.cinematicframe * 1000 / 14;
            return;
        }
        int frame = (int)((float)(SCR.cls.realtime - SCR.cl.cinematictime) * 14.0f / 1000.0f);
        if (frame <= SCR.cl.cinematicframe) {
            return;
        }
        if (frame > SCR.cl.cinematicframe + 1) {
            Com.Println("Dropped frame: " + frame + " > " + (SCR.cl.cinematicframe + 1));
            SCR.cl.cinematictime = SCR.cls.realtime - SCR.cl.cinematicframe * 1000 / 14;
        }
        SCR.cin.pic = SCR.cin.pic_pending;
        SCR.cin.pic_pending = SCR.ReadNextFrame();
        if (SCR.cin.pic_pending == null) {
            SCR.StopCinematic();
            SCR.FinishCinematic();
            SCR.cl.cinematictime = 1;
            SCR.BeginLoadingPlaque();
            SCR.cl.cinematictime = 0;
            return;
        }
    }

    static boolean DrawCinematic() {
        if (SCR.cl.cinematictime <= 0) {
            return false;
        }
        if (SCR.cls.key_dest == 3) {
            Globals.re.CinematicSetPalette(null);
            SCR.cl.cinematicpalette_active = false;
            return true;
        }
        if (!SCR.cl.cinematicpalette_active) {
            re.CinematicSetPalette(SCR.cl.cinematicpalette);
            SCR.cl.cinematicpalette_active = true;
        }
        if (SCR.cin.pic == null) {
            return true;
        }
        Globals.re.DrawStretchRaw(0, 0, viddef.getWidth(), viddef.getHeight(), SCR.cin.width, SCR.cin.height, SCR.cin.pic);
        return true;
    }

    static void PlayCinematic(String arg) {
        CDAudio.Stop();
        SCR.cl.cinematicframe = 0;
        if (arg.endsWith(".pcx")) {
            String name = "pics/" + arg;
            int size = SCR.LoadPCX(name, SCR.cl.cinematicpalette, cin);
            SCR.cl.cinematicframe = -1;
            SCR.cl.cinematictime = 1;
            SCR.EndLoadingPlaque();
            SCR.cls.state = 4;
            if (size == 0 || SCR.cin.pic == null) {
                Com.Println(name + " not found.");
                SCR.cl.cinematictime = 0;
            }
            return;
        }
        String name = "video/" + arg;
        SCR.cl.cinematic_file = FS.LoadMappedFile(name);
        if (SCR.cl.cinematic_file == null) {
            SCR.FinishCinematic();
            SCR.cl.cinematictime = 0;
            return;
        }
        SCR.EndLoadingPlaque();
        SCR.cls.state = 4;
        SCR.cl.cinematic_file.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer file = SCR.cl.cinematic_file;
        SCR.cin.width = file.getInt();
        SCR.cin.height = file.getInt();
        SCR.cin.s_rate = file.getInt();
        SCR.cin.s_width = file.getInt();
        SCR.cin.s_channels = file.getInt();
        SCR.Huff1TableInit();
        SCR.cin.restart_sound = true;
        SCR.cl.cinematicframe = 0;
        SCR.cin.pic = SCR.ReadNextFrame();
        SCR.cl.cinematictime = Timer.Milliseconds();
    }

    static {
        fps = new cvar_t();
        scr_dirty = new dirty_t();
        scr_old_dirty = new dirty_t[]{new dirty_t(), new dirty_t()};
        values = new graphsamp_t[1024];
        for (int n = 0; n < 1024; ++n) {
            SCR.values[n] = new graphsamp_t();
        }
        clear = new dirty_t();
        layoutParser = new LayoutParser();
        separation = new float[]{0.0f, 0.0f};
        updateScreenCallback = new xcommand_t(){

            public void execute() {
                SCR.UpdateScreen2();
            }
        };
        lastframes = 0;
        lasttime = 0;
        fpsvalue = "";
        cin = new cinematics_t();
        compressed = new byte[131072];
    }

    private static class cinematics_t {
        boolean restart_sound;
        int s_rate;
        int s_width;
        int s_channels;
        int width;
        int height;
        byte[] pic;
        byte[] pic_pending;
        int[] hnodes1;
        int[] numhnodes1 = new int[256];
        int[] h_used = new int[512];
        int[] h_count = new int[512];

        private cinematics_t() {
        }
    }

    static class graphsamp_t {
        float value;
        int color;

        graphsamp_t() {
        }
    }

    static class dirty_t {
        int x1;
        int x2;
        int y1;
        int y2;

        dirty_t() {
        }

        void set(dirty_t src) {
            this.x1 = src.x1;
            this.x2 = src.x2;
            this.y1 = src.y1;
            this.y2 = src.y2;
        }

        void clear() {
            this.y2 = 0;
            this.y1 = 0;
            this.x2 = 0;
            this.x1 = 0;
        }
    }
}

