/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL;
import jake2.client.Console;
import jake2.client.Key;
import jake2.client.SCR;
import jake2.client.VID;
import jake2.client.entity_t;
import jake2.client.keyfunc_t;
import jake2.client.refdef_t;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.netadr_t;
import jake2.qcommon.xcommand_t;
import jake2.sound.S;
import jake2.sys.NET;
import jake2.sys.Sys;
import jake2.sys.Timer;
import jake2.util.Lib;
import jake2.util.Math3D;
import jake2.util.QuakeFile;
import java.awt.Dimension;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;

public final class Menu
extends Key {
    static int m_main_cursor;
    static final int NUM_CURSOR_FRAMES = 15;
    static final String menu_in_sound = "misc/menu1.wav";
    static final String menu_move_sound = "misc/menu2.wav";
    static final String menu_out_sound = "misc/menu3.wav";
    static boolean m_entersound;
    static xcommand_t m_drawfunc;
    static keyfunc_t m_keyfunc;
    public static final int MAX_MENU_DEPTH = 8;
    public static menulayer_t[] m_layers;
    public static int m_menudepth;
    static boolean cached;
    static final int MAIN_ITEMS = 5;
    static xcommand_t Main_Draw;
    static keyfunc_t Main_Key;
    static xcommand_t Menu_Main;
    static menuframework_s s_multiplayer_menu;
    static menuaction_s s_join_network_server_action;
    static menuaction_s s_start_network_server_action;
    static menuaction_s s_player_setup_action;
    static xcommand_t Menu_Multiplayer;
    static String[][] bindnames;
    int keys_cursor;
    static boolean bind_grab;
    static menuframework_s s_keys_menu;
    static menuaction_s s_keys_attack_action;
    static menuaction_s s_keys_change_weapon_action;
    static menuaction_s s_keys_walk_forward_action;
    static menuaction_s s_keys_backpedal_action;
    static menuaction_s s_keys_turn_left_action;
    static menuaction_s s_keys_turn_right_action;
    static menuaction_s s_keys_run_action;
    static menuaction_s s_keys_step_left_action;
    static menuaction_s s_keys_step_right_action;
    static menuaction_s s_keys_sidestep_action;
    static menuaction_s s_keys_look_up_action;
    static menuaction_s s_keys_look_down_action;
    static menuaction_s s_keys_center_view_action;
    static menuaction_s s_keys_mouse_look_action;
    static menuaction_s s_keys_keyboard_look_action;
    static menuaction_s s_keys_move_up_action;
    static menuaction_s s_keys_move_down_action;
    static menuaction_s s_keys_inventory_action;
    static menuaction_s s_keys_inv_use_action;
    static menuaction_s s_keys_inv_drop_action;
    static menuaction_s s_keys_inv_prev_action;
    static menuaction_s s_keys_inv_next_action;
    static menuaction_s s_keys_help_computer_action;
    static xcommand_t Keys_MenuDraw;
    static keyfunc_t Keys_MenuKey;
    static xcommand_t Menu_Keys;
    static cvar_t win_noalttab;
    static menuframework_s s_options_menu;
    static menuaction_s s_options_defaults_action;
    static menuaction_s s_options_customize_options_action;
    static menuslider_s s_options_sensitivity_slider;
    static menulist_s s_options_freelook_box;
    static menulist_s s_options_noalttab_box;
    static menulist_s s_options_alwaysrun_box;
    static menulist_s s_options_invertmouse_box;
    static menulist_s s_options_lookspring_box;
    static menulist_s s_options_lookstrafe_box;
    static menulist_s s_options_crosshair_box;
    static menuslider_s s_options_sfxvolume_slider;
    static menulist_s s_options_joystick_box;
    static menulist_s s_options_cdvolume_box;
    static menulist_s s_options_quality_list;
    static menuaction_s s_options_console_action;
    static String[] cd_music_items;
    static String[] compatibility_items;
    static String[] yesno_names;
    static String[] crosshair_names;
    static String[] s_labels;
    static String[] s_drivers;
    static xcommand_t Menu_Options;
    static xcommand_t Menu_Video;
    static int credits_start_time;
    static String[] creditsIndex;
    static String creditsBuffer;
    static String[] idcredits;
    static String[] credits;
    static String[] xatcredits;
    static String[] roguecredits;
    static xcommand_t Menu_Credits;
    static int m_game_cursor;
    static menuframework_s s_game_menu;
    static menuaction_s s_easy_game_action;
    static menuaction_s s_medium_game_action;
    static menuaction_s s_hard_game_action;
    static menuaction_s s_load_game_action;
    static menuaction_s s_save_game_action;
    static menuaction_s s_credits_action;
    static menuseparator_s s_blankline;
    static String[] difficulty_names;
    static xcommand_t Menu_Game;
    public static final int MAX_SAVEGAMES = 15;
    static menuframework_s s_savegame_menu;
    static menuframework_s s_loadgame_menu;
    static menuaction_s[] s_loadgame_actions;
    static String[] m_savestrings;
    static boolean[] m_savevalid;
    static xcommand_t Menu_LoadGame;
    static menuaction_s[] s_savegame_actions;
    static xcommand_t Menu_SaveGame;
    static menuframework_s s_joinserver_menu;
    static menuseparator_s s_joinserver_server_title;
    static menuaction_s s_joinserver_search_action;
    static menuaction_s s_joinserver_address_book_action;
    static netadr_t[] local_server_netadr;
    static String[] local_server_names;
    static menuaction_s[] s_joinserver_server_actions;
    static int m_num_servers;
    static xcommand_t Menu_JoinServer;
    static menuframework_s s_startserver_menu;
    static String[] mapnames;
    static int nummaps;
    static menuaction_s s_startserver_start_action;
    static menuaction_s s_startserver_dmoptions_action;
    static menufield_s s_timelimit_field;
    static menufield_s s_fraglimit_field;
    static menufield_s s_maxclients_field;
    static menufield_s s_hostname_field;
    static menulist_s s_startmap_list;
    static menulist_s s_rules_box;
    static String[] dm_coop_names;
    static String[] dm_coop_names_rogue;
    static xcommand_t Menu_StartServer;
    static xcommand_t startServer_MenuDraw;
    static keyfunc_t startServer_MenuKey;
    static String dmoptions_statusbar;
    static menuframework_s s_dmoptions_menu;
    static menulist_s s_friendlyfire_box;
    static menulist_s s_falls_box;
    static menulist_s s_weapons_stay_box;
    static menulist_s s_instant_powerups_box;
    static menulist_s s_powerups_box;
    static menulist_s s_health_box;
    static menulist_s s_spawn_farthest_box;
    static menulist_s s_teamplay_box;
    static menulist_s s_samelevel_box;
    static menulist_s s_force_respawn_box;
    static menulist_s s_armor_box;
    static menulist_s s_allow_exit_box;
    static menulist_s s_infinite_ammo_box;
    static menulist_s s_fixed_fov_box;
    static menulist_s s_quad_drop_box;
    static menulist_s s_no_mines_box;
    static menulist_s s_no_nukes_box;
    static menulist_s s_stack_double_box;
    static menulist_s s_no_spheres_box;
    static String[] teamplay_names;
    static xcommand_t Menu_DMOptions;
    static menuframework_s s_downloadoptions_menu;
    static menuseparator_s s_download_title;
    static menulist_s s_allow_download_box;
    static menulist_s s_allow_download_maps_box;
    static menulist_s s_allow_download_models_box;
    static menulist_s s_allow_download_players_box;
    static menulist_s s_allow_download_sounds_box;
    static String[] yes_no_names;
    static xcommand_t Menu_DownloadOptions;
    static menuframework_s s_addressbook_menu;
    static menufield_s[] s_addressbook_fields;
    static keyfunc_t AddressBook_MenuKey;
    static xcommand_t AddressBook_MenuDraw;
    static xcommand_t Menu_AddressBook;
    static menuframework_s s_player_config_menu;
    static menufield_s s_player_name_field;
    static menulist_s s_player_model_box;
    static menulist_s s_player_skin_box;
    static menulist_s s_player_handedness_box;
    static menulist_s s_player_rate_box;
    static menuseparator_s s_player_skin_title;
    static menuseparator_s s_player_model_title;
    static menuseparator_s s_player_hand_title;
    static menuseparator_s s_player_rate_title;
    static menuaction_s s_player_download_action;
    static playermodelinfo_s[] s_pmi;
    static String[] s_pmnames;
    static int s_numplayermodels;
    static int[] rate_tbl;
    static String[] rate_names;
    static String[] handedness;
    static int yaw;
    private static final entity_t entity;
    static xcommand_t Menu_PlayerConfig;
    static xcommand_t Menu_Quit;
    public static final int SLIDER_RANGE = 10;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void Banner(String name) {
        Dimension dim = new Dimension();
        Globals.re.DrawGetPicSize(dim, name);
        Globals.re.DrawPic(viddef.getWidth() / 2 - dim.width / 2, viddef.getHeight() / 2 - 110, name);
    }

    static void PushMenu(xcommand_t draw, keyfunc_t key) {
        int i;
        if (Cvar.VariableValue("maxclients") == 1.0f && Globals.server_state != 0) {
            Cvar.Set("paused", "1");
        }
        for (i = 0; i < m_menudepth; ++i) {
            if (Menu.m_layers[i].draw != draw || Menu.m_layers[i].key != key) continue;
            m_menudepth = i;
        }
        if (i == m_menudepth) {
            if (m_menudepth >= 8) {
                Com.Error(0, "PushMenu: MAX_MENU_DEPTH");
            }
            Menu.m_layers[Menu.m_menudepth].draw = draw;
            Menu.m_layers[Menu.m_menudepth].key = key;
        }
        ++m_menudepth;
        m_drawfunc = draw;
        m_keyfunc = key;
        m_entersound = true;
        Menu.cls.key_dest = 3;
    }

    static void ForceMenuOff() {
        m_drawfunc = null;
        m_keyfunc = null;
        Menu.cls.key_dest = 0;
        m_menudepth = 0;
        Key.ClearStates();
        Cvar.Set("paused", "0");
    }

    static void PopMenu() {
        S.StartLocalSound(menu_out_sound);
        if (--m_menudepth < 0) {
            Com.Error(0, "PopMenu: depth < 1");
        }
        if (0 < m_menudepth) {
            m_drawfunc = Menu.m_layers[Menu.m_menudepth - 1].draw;
            m_keyfunc = Menu.m_layers[Menu.m_menudepth - 1].key;
        }
        if (0 == m_menudepth) {
            Menu.ForceMenuOff();
        }
    }

    static String Default_MenuKey(menuframework_s m, int key) {
        menucommon_s item;
        String sound = null;
        if (m != null && (item = Menu.Menu_ItemAtCursor(m)) != null && item.type == 5 && Menu.Field_Key((menufield_s)item, key)) {
            return null;
        }
        switch (key) {
            case 27: {
                Menu.PopMenu();
                return menu_out_sound;
            }
            case 128: 
            case 161: {
                if (m == null) break;
                --m.cursor;
                Menu.Menu_AdjustCursor(m, -1);
                sound = menu_move_sound;
                break;
            }
            case 9: {
                if (m == null) break;
                ++m.cursor;
                Menu.Menu_AdjustCursor(m, 1);
                sound = menu_move_sound;
                break;
            }
            case 129: 
            case 167: {
                if (m == null) break;
                ++m.cursor;
                Menu.Menu_AdjustCursor(m, 1);
                sound = menu_move_sound;
                break;
            }
            case 130: 
            case 163: {
                if (m == null) break;
                Menu.Menu_SlideItem(m, -1);
                sound = menu_move_sound;
                break;
            }
            case 131: 
            case 165: {
                if (m == null) break;
                Menu.Menu_SlideItem(m, 1);
                sound = menu_move_sound;
                break;
            }
            case 13: 
            case 169: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                if (m != null) {
                    Menu.Menu_SelectItem(m);
                }
                sound = menu_move_sound;
            }
        }
        return sound;
    }

    public static void DrawCharacter(int cx, int cy, int num) {
        re.DrawChar(cx + (viddef.getWidth() - 320 >> 1), cy + (viddef.getHeight() - 240 >> 1), num);
    }

    public static void Print(int cx, int cy, String str) {
        for (int n = 0; n < str.length(); ++n) {
            Menu.DrawCharacter(cx, cy, str.charAt(n) + 128);
            cx += 8;
        }
    }

    public static void PrintWhite(int cx, int cy, String str) {
        for (int n = 0; n < str.length(); ++n) {
            Menu.DrawCharacter(cx, cy, str.charAt(n));
            cx += 8;
        }
    }

    public static void DrawPic(int x, int y, String pic) {
        re.DrawPic(x + (viddef.getWidth() - 320 >> 1), y + (viddef.getHeight() - 240 >> 1), pic);
    }

    static void DrawCursor(int x, int y, int f) {
        if (!$assertionsDisabled && f < 0) {
            throw new AssertionError((Object)"negative time and cursor bug");
        }
        f = Math.abs(f);
        if (!cached) {
            for (int i = 0; i < 15; ++i) {
                re.RegisterPic("m_cursor" + i);
            }
            cached = true;
        }
        re.DrawPic(x, y, "m_cursor" + f);
    }

    public static void DrawTextBox(int x, int y, int width, int lines) {
        int n;
        int cx = x;
        int cy = y;
        Menu.DrawCharacter(cx, cy, 1);
        for (n = 0; n < lines; ++n) {
            Menu.DrawCharacter(cx, cy += 8, 4);
        }
        Menu.DrawCharacter(cx, cy + 8, 7);
        cx += 8;
        while (width > 0) {
            cy = y;
            Menu.DrawCharacter(cx, cy, 2);
            for (n = 0; n < lines; ++n) {
                Menu.DrawCharacter(cx, cy += 8, 5);
            }
            Menu.DrawCharacter(cx, cy + 8, 8);
            --width;
            cx += 8;
        }
        cy = y;
        Menu.DrawCharacter(cx, cy, 3);
        for (n = 0; n < lines; ++n) {
            Menu.DrawCharacter(cx, cy += 8, 6);
        }
        Menu.DrawCharacter(cx, cy + 8, 9);
    }

    static void Main_Draw() {
        int h;
        int w;
        int i;
        int widest = -1;
        int totalheight = 0;
        String[] names = new String[]{"m_main_game", "m_main_multiplayer", "m_main_options", "m_main_video", "m_main_quit"};
        Dimension dim = new Dimension();
        for (i = 0; i < names.length; ++i) {
            Globals.re.DrawGetPicSize(dim, names[i]);
            w = dim.width;
            h = dim.height;
            if (w > widest) {
                widest = w;
            }
            totalheight += h + 12;
        }
        int ystart = Globals.viddef.getHeight() / 2 - 110;
        int xoffset = (Globals.viddef.getWidth() - widest + 70) / 2;
        for (i = 0; i < names.length; ++i) {
            if (i == m_main_cursor) continue;
            Globals.re.DrawPic(xoffset, ystart + i * 40 + 13, names[i]);
        }
        String litname = names[m_main_cursor] + "_sel";
        Globals.re.DrawPic(xoffset, ystart + m_main_cursor * 40 + 13, litname);
        Menu.DrawCursor(xoffset - 25, ystart + m_main_cursor * 40 + 11, Globals.cls.realtime / 100 % 15);
        Globals.re.DrawGetPicSize(dim, "m_main_plaque");
        w = dim.width;
        h = dim.height;
        Globals.re.DrawPic(xoffset - 30 - w, ystart, "m_main_plaque");
        Globals.re.DrawPic(xoffset - 30 - w, ystart + h + 5, "m_main_logo");
    }

    static String Main_Key(int key) {
        String sound = menu_move_sound;
        block0 : switch (key) {
            case 27: {
                Menu.PopMenu();
                break;
            }
            case 129: 
            case 167: {
                if (++m_main_cursor >= 5) {
                    m_main_cursor = 0;
                }
                return sound;
            }
            case 128: 
            case 161: {
                if (--m_main_cursor < 0) {
                    m_main_cursor = 4;
                }
                return sound;
            }
            case 13: 
            case 169: {
                m_entersound = true;
                switch (m_main_cursor) {
                    case 0: {
                        Menu.Menu_Game_f();
                        break block0;
                    }
                    case 1: {
                        Menu.Menu_Multiplayer_f();
                        break block0;
                    }
                    case 2: {
                        Menu.Menu_Options_f();
                        break block0;
                    }
                    case 3: {
                        Menu.Menu_Video_f();
                        break block0;
                    }
                    case 4: {
                        Menu.Menu_Quit_f();
                    }
                }
            }
        }
        return null;
    }

    static void Menu_Main_f() {
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Main_Draw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Main_Key(key);
            }
        });
    }

    static void Multiplayer_MenuDraw() {
        Menu.Banner("m_banner_multiplayer");
        Menu.Menu_AdjustCursor(s_multiplayer_menu, 1);
        Menu.Menu_Draw(s_multiplayer_menu);
    }

    static void PlayerSetupFunc(Object unused) {
        Menu.Menu_PlayerConfig_f();
    }

    static void JoinNetworkServerFunc(Object unused) {
        Menu.Menu_JoinServer_f();
    }

    static void StartNetworkServerFunc(Object unused) {
        Menu.Menu_StartServer_f();
    }

    static void Multiplayer_MenuInit() {
        Menu.s_multiplayer_menu.x = (int)((float)viddef.getWidth() * 0.5f - 64.0f);
        Menu.s_multiplayer_menu.nitems = 0;
        Menu.s_join_network_server_action.type = 2;
        Menu.s_join_network_server_action.flags = 1;
        Menu.s_join_network_server_action.x = 0;
        Menu.s_join_network_server_action.y = 0;
        Menu.s_join_network_server_action.name = " join network server";
        Menu.s_join_network_server_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.JoinNetworkServerFunc(o);
            }
        };
        Menu.s_start_network_server_action.type = 2;
        Menu.s_start_network_server_action.flags = 1;
        Menu.s_start_network_server_action.x = 0;
        Menu.s_start_network_server_action.y = 10;
        Menu.s_start_network_server_action.name = " start network server";
        Menu.s_start_network_server_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.StartNetworkServerFunc(o);
            }
        };
        Menu.s_player_setup_action.type = 2;
        Menu.s_player_setup_action.flags = 1;
        Menu.s_player_setup_action.x = 0;
        Menu.s_player_setup_action.y = 20;
        Menu.s_player_setup_action.name = " player setup";
        Menu.s_player_setup_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.PlayerSetupFunc(o);
            }
        };
        Menu.Menu_AddItem(s_multiplayer_menu, s_join_network_server_action);
        Menu.Menu_AddItem(s_multiplayer_menu, s_start_network_server_action);
        Menu.Menu_AddItem(s_multiplayer_menu, s_player_setup_action);
        Menu.Menu_SetStatusBar(s_multiplayer_menu, null);
        Menu.Menu_Center(s_multiplayer_menu);
    }

    static String Multiplayer_MenuKey(int key) {
        return Menu.Default_MenuKey(s_multiplayer_menu, key);
    }

    static void Menu_Multiplayer_f() {
        Menu.Multiplayer_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Multiplayer_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Multiplayer_MenuKey(key);
            }
        });
    }

    static void UnbindCommand(String command) {
        for (int j = 0; j < 256; ++j) {
            String b = keybindings[j];
            if (b == null || !b.equals(command)) continue;
            Key.SetBinding(j, "");
        }
    }

    static void FindKeysForCommand(String command, int[] twokeys) {
        twokeys[1] = -1;
        twokeys[0] = -1;
        int count = 0;
        for (int j = 0; j < 256; ++j) {
            String b = keybindings[j];
            if (b == null || !b.equals(command)) continue;
            twokeys[count] = j;
            if (++count == 2) break;
        }
    }

    static void KeyCursorDrawFunc(menuframework_s menu) {
        if (bind_grab) {
            re.DrawChar(menu.x, menu.y + menu.cursor * 9, 61);
        } else {
            re.DrawChar(menu.x, menu.y + menu.cursor * 9, 12 + (Timer.Milliseconds() / 250 & 1));
        }
    }

    static void DrawKeyBindingFunc(Object self) {
        int[] keys = new int[]{0, 0};
        menuaction_s a = (menuaction_s)self;
        Menu.FindKeysForCommand(bindnames[a.localdata[0]][0], keys);
        if (keys[0] == -1) {
            Menu.Menu_DrawString(a.x + a.parent.x + 16, a.y + a.parent.y, "???");
        } else {
            String name = Key.KeynumToString(keys[0]);
            Menu.Menu_DrawString(a.x + a.parent.x + 16, a.y + a.parent.y, name);
            int x = name.length() * 8;
            if (keys[1] != -1) {
                Menu.Menu_DrawString(a.x + a.parent.x + 24 + x, a.y + a.parent.y, "or");
                Menu.Menu_DrawString(a.x + a.parent.x + 48 + x, a.y + a.parent.y, Key.KeynumToString(keys[1]));
            }
        }
    }

    static void KeyBindingFunc(Object self) {
        menuaction_s a = (menuaction_s)self;
        int[] keys = new int[]{0, 0};
        Menu.FindKeysForCommand(bindnames[a.localdata[0]][0], keys);
        if (keys[1] != -1) {
            Menu.UnbindCommand(bindnames[a.localdata[0]][0]);
        }
        bind_grab = true;
        Menu.Menu_SetStatusBar(s_keys_menu, "press a key or button for this action");
    }

    static void Keys_MenuInit() {
        int y = 0;
        int i = 0;
        Menu.s_keys_menu.x = (int)((double)viddef.getWidth() * 0.5);
        Menu.s_keys_menu.nitems = 0;
        Menu.s_keys_menu.cursordraw = new mcallback(){

            public void execute(Object o) {
                Menu.KeyCursorDrawFunc((menuframework_s)o);
            }
        };
        Menu.s_keys_attack_action.type = 2;
        Menu.s_keys_attack_action.flags = 2;
        Menu.s_keys_attack_action.x = 0;
        Menu.s_keys_attack_action.y = y;
        Menu.s_keys_attack_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_attack_action.localdata[0] = i++;
        Menu.s_keys_attack_action.name = bindnames[Menu.s_keys_attack_action.localdata[0]][1];
        Menu.s_keys_change_weapon_action.type = 2;
        Menu.s_keys_change_weapon_action.flags = 2;
        Menu.s_keys_change_weapon_action.x = 0;
        Menu.s_keys_change_weapon_action.y = y += 9;
        Menu.s_keys_change_weapon_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_change_weapon_action.localdata[0] = i++;
        Menu.s_keys_change_weapon_action.name = bindnames[Menu.s_keys_change_weapon_action.localdata[0]][1];
        Menu.s_keys_walk_forward_action.type = 2;
        Menu.s_keys_walk_forward_action.flags = 2;
        Menu.s_keys_walk_forward_action.x = 0;
        Menu.s_keys_walk_forward_action.y = y += 9;
        Menu.s_keys_walk_forward_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_walk_forward_action.localdata[0] = i++;
        Menu.s_keys_walk_forward_action.name = bindnames[Menu.s_keys_walk_forward_action.localdata[0]][1];
        Menu.s_keys_backpedal_action.type = 2;
        Menu.s_keys_backpedal_action.flags = 2;
        Menu.s_keys_backpedal_action.x = 0;
        Menu.s_keys_backpedal_action.y = y += 9;
        Menu.s_keys_backpedal_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_backpedal_action.localdata[0] = i++;
        Menu.s_keys_backpedal_action.name = bindnames[Menu.s_keys_backpedal_action.localdata[0]][1];
        Menu.s_keys_turn_left_action.type = 2;
        Menu.s_keys_turn_left_action.flags = 2;
        Menu.s_keys_turn_left_action.x = 0;
        Menu.s_keys_turn_left_action.y = y += 9;
        Menu.s_keys_turn_left_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_turn_left_action.localdata[0] = i++;
        Menu.s_keys_turn_left_action.name = bindnames[Menu.s_keys_turn_left_action.localdata[0]][1];
        Menu.s_keys_turn_right_action.type = 2;
        Menu.s_keys_turn_right_action.flags = 2;
        Menu.s_keys_turn_right_action.x = 0;
        Menu.s_keys_turn_right_action.y = y += 9;
        Menu.s_keys_turn_right_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_turn_right_action.localdata[0] = i++;
        Menu.s_keys_turn_right_action.name = bindnames[Menu.s_keys_turn_right_action.localdata[0]][1];
        Menu.s_keys_run_action.type = 2;
        Menu.s_keys_run_action.flags = 2;
        Menu.s_keys_run_action.x = 0;
        Menu.s_keys_run_action.y = y += 9;
        Menu.s_keys_run_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_run_action.localdata[0] = i++;
        Menu.s_keys_run_action.name = bindnames[Menu.s_keys_run_action.localdata[0]][1];
        Menu.s_keys_step_left_action.type = 2;
        Menu.s_keys_step_left_action.flags = 2;
        Menu.s_keys_step_left_action.x = 0;
        Menu.s_keys_step_left_action.y = y += 9;
        Menu.s_keys_step_left_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_step_left_action.localdata[0] = i++;
        Menu.s_keys_step_left_action.name = bindnames[Menu.s_keys_step_left_action.localdata[0]][1];
        Menu.s_keys_step_right_action.type = 2;
        Menu.s_keys_step_right_action.flags = 2;
        Menu.s_keys_step_right_action.x = 0;
        Menu.s_keys_step_right_action.y = y += 9;
        Menu.s_keys_step_right_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_step_right_action.localdata[0] = i++;
        Menu.s_keys_step_right_action.name = bindnames[Menu.s_keys_step_right_action.localdata[0]][1];
        Menu.s_keys_sidestep_action.type = 2;
        Menu.s_keys_sidestep_action.flags = 2;
        Menu.s_keys_sidestep_action.x = 0;
        Menu.s_keys_sidestep_action.y = y += 9;
        Menu.s_keys_sidestep_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_sidestep_action.localdata[0] = i++;
        Menu.s_keys_sidestep_action.name = bindnames[Menu.s_keys_sidestep_action.localdata[0]][1];
        Menu.s_keys_look_up_action.type = 2;
        Menu.s_keys_look_up_action.flags = 2;
        Menu.s_keys_look_up_action.x = 0;
        Menu.s_keys_look_up_action.y = y += 9;
        Menu.s_keys_look_up_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_look_up_action.localdata[0] = i++;
        Menu.s_keys_look_up_action.name = bindnames[Menu.s_keys_look_up_action.localdata[0]][1];
        Menu.s_keys_look_down_action.type = 2;
        Menu.s_keys_look_down_action.flags = 2;
        Menu.s_keys_look_down_action.x = 0;
        Menu.s_keys_look_down_action.y = y += 9;
        Menu.s_keys_look_down_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_look_down_action.localdata[0] = i++;
        Menu.s_keys_look_down_action.name = bindnames[Menu.s_keys_look_down_action.localdata[0]][1];
        Menu.s_keys_center_view_action.type = 2;
        Menu.s_keys_center_view_action.flags = 2;
        Menu.s_keys_center_view_action.x = 0;
        Menu.s_keys_center_view_action.y = y += 9;
        Menu.s_keys_center_view_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_center_view_action.localdata[0] = i++;
        Menu.s_keys_center_view_action.name = bindnames[Menu.s_keys_center_view_action.localdata[0]][1];
        Menu.s_keys_mouse_look_action.type = 2;
        Menu.s_keys_mouse_look_action.flags = 2;
        Menu.s_keys_mouse_look_action.x = 0;
        Menu.s_keys_mouse_look_action.y = y += 9;
        Menu.s_keys_mouse_look_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_mouse_look_action.localdata[0] = i++;
        Menu.s_keys_mouse_look_action.name = bindnames[Menu.s_keys_mouse_look_action.localdata[0]][1];
        Menu.s_keys_keyboard_look_action.type = 2;
        Menu.s_keys_keyboard_look_action.flags = 2;
        Menu.s_keys_keyboard_look_action.x = 0;
        Menu.s_keys_keyboard_look_action.y = y += 9;
        Menu.s_keys_keyboard_look_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_keyboard_look_action.localdata[0] = i++;
        Menu.s_keys_keyboard_look_action.name = bindnames[Menu.s_keys_keyboard_look_action.localdata[0]][1];
        Menu.s_keys_move_up_action.type = 2;
        Menu.s_keys_move_up_action.flags = 2;
        Menu.s_keys_move_up_action.x = 0;
        Menu.s_keys_move_up_action.y = y += 9;
        Menu.s_keys_move_up_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_move_up_action.localdata[0] = i++;
        Menu.s_keys_move_up_action.name = bindnames[Menu.s_keys_move_up_action.localdata[0]][1];
        Menu.s_keys_move_down_action.type = 2;
        Menu.s_keys_move_down_action.flags = 2;
        Menu.s_keys_move_down_action.x = 0;
        Menu.s_keys_move_down_action.y = y += 9;
        Menu.s_keys_move_down_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_move_down_action.localdata[0] = i++;
        Menu.s_keys_move_down_action.name = bindnames[Menu.s_keys_move_down_action.localdata[0]][1];
        Menu.s_keys_inventory_action.type = 2;
        Menu.s_keys_inventory_action.flags = 2;
        Menu.s_keys_inventory_action.x = 0;
        Menu.s_keys_inventory_action.y = y += 9;
        Menu.s_keys_inventory_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_inventory_action.localdata[0] = i++;
        Menu.s_keys_inventory_action.name = bindnames[Menu.s_keys_inventory_action.localdata[0]][1];
        Menu.s_keys_inv_use_action.type = 2;
        Menu.s_keys_inv_use_action.flags = 2;
        Menu.s_keys_inv_use_action.x = 0;
        Menu.s_keys_inv_use_action.y = y += 9;
        Menu.s_keys_inv_use_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_inv_use_action.localdata[0] = i++;
        Menu.s_keys_inv_use_action.name = bindnames[Menu.s_keys_inv_use_action.localdata[0]][1];
        Menu.s_keys_inv_drop_action.type = 2;
        Menu.s_keys_inv_drop_action.flags = 2;
        Menu.s_keys_inv_drop_action.x = 0;
        Menu.s_keys_inv_drop_action.y = y += 9;
        Menu.s_keys_inv_drop_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_inv_drop_action.localdata[0] = i++;
        Menu.s_keys_inv_drop_action.name = bindnames[Menu.s_keys_inv_drop_action.localdata[0]][1];
        Menu.s_keys_inv_prev_action.type = 2;
        Menu.s_keys_inv_prev_action.flags = 2;
        Menu.s_keys_inv_prev_action.x = 0;
        Menu.s_keys_inv_prev_action.y = y += 9;
        Menu.s_keys_inv_prev_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_inv_prev_action.localdata[0] = i++;
        Menu.s_keys_inv_prev_action.name = bindnames[Menu.s_keys_inv_prev_action.localdata[0]][1];
        Menu.s_keys_inv_next_action.type = 2;
        Menu.s_keys_inv_next_action.flags = 2;
        Menu.s_keys_inv_next_action.x = 0;
        Menu.s_keys_inv_next_action.y = y += 9;
        Menu.s_keys_inv_next_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_inv_next_action.localdata[0] = i++;
        Menu.s_keys_inv_next_action.name = bindnames[Menu.s_keys_inv_next_action.localdata[0]][1];
        Menu.s_keys_help_computer_action.type = 2;
        Menu.s_keys_help_computer_action.flags = 2;
        Menu.s_keys_help_computer_action.x = 0;
        Menu.s_keys_help_computer_action.y = y += 9;
        Menu.s_keys_help_computer_action.ownerdraw = new mcallback(){

            public void execute(Object o) {
                Menu.DrawKeyBindingFunc(o);
            }
        };
        Menu.s_keys_help_computer_action.localdata[0] = i;
        Menu.s_keys_help_computer_action.name = bindnames[Menu.s_keys_help_computer_action.localdata[0]][1];
        Menu.Menu_AddItem(s_keys_menu, s_keys_attack_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_change_weapon_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_walk_forward_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_backpedal_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_turn_left_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_turn_right_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_run_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_step_left_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_step_right_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_sidestep_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_look_up_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_look_down_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_center_view_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_mouse_look_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_keyboard_look_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_move_up_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_move_down_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_inventory_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_inv_use_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_inv_drop_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_inv_prev_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_inv_next_action);
        Menu.Menu_AddItem(s_keys_menu, s_keys_help_computer_action);
        Menu.Menu_SetStatusBar(s_keys_menu, "enter to change, backspace to clear");
        Menu.Menu_Center(s_keys_menu);
    }

    static void Keys_MenuDraw_f() {
        Menu.Menu_AdjustCursor(s_keys_menu, 1);
        Menu.Menu_Draw(s_keys_menu);
    }

    static String Keys_MenuKey_f(int key) {
        menuaction_s item = (menuaction_s)Menu.Menu_ItemAtCursor(s_keys_menu);
        if (bind_grab) {
            if (key != 27 && key != 96) {
                String cmd = "bind \"" + Key.KeynumToString(key) + "\" \"" + bindnames[item.localdata[0]][0] + "\"";
                Cbuf.InsertText(cmd);
            }
            Menu.Menu_SetStatusBar(s_keys_menu, "enter to change, backspace to clear");
            bind_grab = false;
            return menu_out_sound;
        }
        switch (key) {
            case 13: 
            case 169: {
                Menu.KeyBindingFunc(item);
                return menu_in_sound;
            }
            case 127: 
            case 148: 
            case 171: {
                Menu.UnbindCommand(bindnames[item.localdata[0]][0]);
                return menu_out_sound;
            }
        }
        return Menu.Default_MenuKey(s_keys_menu, key);
    }

    static void Menu_Keys_f() {
        Menu.Keys_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Keys_MenuDraw_f();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Keys_MenuKey_f(key);
            }
        });
    }

    static void CrosshairFunc(Object unused) {
        Cvar.SetValue("crosshair", Menu.s_options_crosshair_box.curvalue);
    }

    static void JoystickFunc(Object unused) {
        Cvar.SetValue("in_joystick", Menu.s_options_joystick_box.curvalue);
    }

    static void CustomizeControlsFunc(Object unused) {
        Menu.Menu_Keys_f();
    }

    static void AlwaysRunFunc(Object unused) {
        Cvar.SetValue("cl_run", Menu.s_options_alwaysrun_box.curvalue);
    }

    static void FreeLookFunc(Object unused) {
        Cvar.SetValue("freelook", Menu.s_options_freelook_box.curvalue);
    }

    static void MouseSpeedFunc(Object unused) {
        Cvar.SetValue("sensitivity", Menu.s_options_sensitivity_slider.curvalue / 2.0f);
    }

    static void NoAltTabFunc(Object unused) {
        Cvar.SetValue("win_noalttab", Menu.s_options_noalttab_box.curvalue);
    }

    static float ClampCvar(float min, float max, float value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static void ControlsSetMenuItemValues() {
        Menu.s_options_sfxvolume_slider.curvalue = Cvar.VariableValue("s_volume") * 10.0f;
        Menu.s_options_cdvolume_box.curvalue = 1 - (int)Cvar.VariableValue("cd_nocd");
        String s = Cvar.VariableString("s_impl");
        for (int i = 0; i < s_drivers.length; ++i) {
            if (!s.equals(s_drivers[i])) continue;
            Menu.s_options_quality_list.curvalue = i;
        }
        Menu.s_options_sensitivity_slider.curvalue = Menu.sensitivity.value * 2.0f;
        Cvar.SetValue("cl_run", Menu.ClampCvar(0.0f, 1.0f, Menu.cl_run.value));
        Menu.s_options_alwaysrun_box.curvalue = (int)Menu.cl_run.value;
        Menu.s_options_invertmouse_box.curvalue = Menu.m_pitch.value < 0.0f ? 1 : 0;
        Cvar.SetValue("lookspring", Menu.ClampCvar(0.0f, 1.0f, Menu.lookspring.value));
        Menu.s_options_lookspring_box.curvalue = (int)Menu.lookspring.value;
        Cvar.SetValue("lookstrafe", Menu.ClampCvar(0.0f, 1.0f, Menu.lookstrafe.value));
        Menu.s_options_lookstrafe_box.curvalue = (int)Menu.lookstrafe.value;
        Cvar.SetValue("freelook", Menu.ClampCvar(0.0f, 1.0f, Menu.freelook.value));
        Menu.s_options_freelook_box.curvalue = (int)Menu.freelook.value;
        Cvar.SetValue("crosshair", Menu.ClampCvar(0.0f, 3.0f, Globals.crosshair.value));
        Menu.s_options_crosshair_box.curvalue = (int)Globals.crosshair.value;
        Cvar.SetValue("in_joystick", Menu.ClampCvar(0.0f, 1.0f, Menu.in_joystick.value));
        Menu.s_options_joystick_box.curvalue = (int)Menu.in_joystick.value;
        Menu.s_options_noalttab_box.curvalue = (int)Menu.win_noalttab.value;
    }

    static void ControlsResetDefaultsFunc(Object unused) {
        Cbuf.AddText("exec default.cfg\n");
        Cbuf.Execute();
        Menu.ControlsSetMenuItemValues();
    }

    static void InvertMouseFunc(Object unused) {
        Cvar.SetValue("m_pitch", -Menu.m_pitch.value);
    }

    static void LookspringFunc(Object unused) {
        Cvar.SetValue("lookspring", 1.0f - Menu.lookspring.value);
    }

    static void LookstrafeFunc(Object unused) {
        Cvar.SetValue("lookstrafe", 1.0f - Menu.lookstrafe.value);
    }

    static void UpdateVolumeFunc(Object unused) {
        Cvar.SetValue("s_volume", Menu.s_options_sfxvolume_slider.curvalue / 10.0f);
    }

    static void UpdateCDVolumeFunc(Object unused) {
        Cvar.SetValue("cd_nocd", 1 - Menu.s_options_cdvolume_box.curvalue);
    }

    static void ConsoleFunc(Object unused) {
        if (Menu.cl.attractloop) {
            Cbuf.AddText("killserver\n");
            return;
        }
        Key.ClearTyping();
        Console.ClearNotify();
        Menu.ForceMenuOff();
        Menu.cls.key_dest = 1;
    }

    static void UpdateSoundQualityFunc(Object unused) {
        boolean driverNotChanged = false;
        String current = s_drivers[Menu.s_options_quality_list.curvalue];
        driverNotChanged = S.getDriverName().equals(current);
        if (driverNotChanged) {
            re.EndFrame();
            return;
        }
        Cvar.Set("s_impl", current);
        Menu.DrawTextBox(8, 72, 36, 3);
        Menu.Print(32, 80, "Restarting the sound system. This");
        Menu.Print(32, 88, "could take up to a minute, so");
        Menu.Print(32, 96, "please be patient.");
        re.EndFrame();
        CL.Snd_Restart_f.execute();
    }

    static void Options_MenuInit() {
        s_drivers = S.getDriverNames();
        s_labels = new String[s_drivers.length];
        for (int i = 0; i < s_drivers.length; ++i) {
            Menu.s_labels[i] = "dummy".equals(s_drivers[i]) ? "off" : s_drivers[i];
        }
        win_noalttab = Cvar.Get("win_noalttab", "0", 1);
        Menu.s_options_menu.x = viddef.getWidth() / 2;
        Menu.s_options_menu.y = viddef.getHeight() / 2 - 58;
        Menu.s_options_menu.nitems = 0;
        Menu.s_options_sfxvolume_slider.type = 0;
        Menu.s_options_sfxvolume_slider.x = 0;
        Menu.s_options_sfxvolume_slider.y = 0;
        Menu.s_options_sfxvolume_slider.name = "effects volume";
        Menu.s_options_sfxvolume_slider.callback = new mcallback(){

            public void execute(Object o) {
                Menu.UpdateVolumeFunc(o);
            }
        };
        Menu.s_options_sfxvolume_slider.minvalue = 0.0f;
        Menu.s_options_sfxvolume_slider.maxvalue = 10.0f;
        Menu.s_options_sfxvolume_slider.curvalue = Cvar.VariableValue("s_volume") * 10.0f;
        Menu.s_options_cdvolume_box.type = 3;
        Menu.s_options_cdvolume_box.x = 0;
        Menu.s_options_cdvolume_box.y = 10;
        Menu.s_options_cdvolume_box.name = "CD music";
        Menu.s_options_cdvolume_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.UpdateCDVolumeFunc(o);
            }
        };
        Menu.s_options_cdvolume_box.itemnames = cd_music_items;
        Menu.s_options_cdvolume_box.curvalue = 1 - (int)Cvar.VariableValue("cd_nocd");
        Menu.s_options_quality_list.type = 3;
        Menu.s_options_quality_list.x = 0;
        Menu.s_options_quality_list.y = 20;
        Menu.s_options_quality_list.name = "sound";
        Menu.s_options_quality_list.callback = new mcallback(){

            public void execute(Object o) {
                Menu.UpdateSoundQualityFunc(o);
            }
        };
        Menu.s_options_quality_list.itemnames = s_labels;
        Menu.s_options_sensitivity_slider.type = 0;
        Menu.s_options_sensitivity_slider.x = 0;
        Menu.s_options_sensitivity_slider.y = 50;
        Menu.s_options_sensitivity_slider.name = "mouse speed";
        Menu.s_options_sensitivity_slider.callback = new mcallback(){

            public void execute(Object o) {
                Menu.MouseSpeedFunc(o);
            }
        };
        Menu.s_options_sensitivity_slider.minvalue = 2.0f;
        Menu.s_options_sensitivity_slider.maxvalue = 22.0f;
        Menu.s_options_alwaysrun_box.type = 3;
        Menu.s_options_alwaysrun_box.x = 0;
        Menu.s_options_alwaysrun_box.y = 60;
        Menu.s_options_alwaysrun_box.name = "always run";
        Menu.s_options_alwaysrun_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.AlwaysRunFunc(o);
            }
        };
        Menu.s_options_alwaysrun_box.itemnames = yesno_names;
        Menu.s_options_invertmouse_box.type = 3;
        Menu.s_options_invertmouse_box.x = 0;
        Menu.s_options_invertmouse_box.y = 70;
        Menu.s_options_invertmouse_box.name = "invert mouse";
        Menu.s_options_invertmouse_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.InvertMouseFunc(o);
            }
        };
        Menu.s_options_invertmouse_box.itemnames = yesno_names;
        Menu.s_options_lookspring_box.type = 3;
        Menu.s_options_lookspring_box.x = 0;
        Menu.s_options_lookspring_box.y = 80;
        Menu.s_options_lookspring_box.name = "lookspring";
        Menu.s_options_lookspring_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.LookspringFunc(o);
            }
        };
        Menu.s_options_lookspring_box.itemnames = yesno_names;
        Menu.s_options_lookstrafe_box.type = 3;
        Menu.s_options_lookstrafe_box.x = 0;
        Menu.s_options_lookstrafe_box.y = 90;
        Menu.s_options_lookstrafe_box.name = "lookstrafe";
        Menu.s_options_lookstrafe_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.LookstrafeFunc(o);
            }
        };
        Menu.s_options_lookstrafe_box.itemnames = yesno_names;
        Menu.s_options_freelook_box.type = 3;
        Menu.s_options_freelook_box.x = 0;
        Menu.s_options_freelook_box.y = 100;
        Menu.s_options_freelook_box.name = "free look";
        Menu.s_options_freelook_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.FreeLookFunc(o);
            }
        };
        Menu.s_options_freelook_box.itemnames = yesno_names;
        Menu.s_options_crosshair_box.type = 3;
        Menu.s_options_crosshair_box.x = 0;
        Menu.s_options_crosshair_box.y = 110;
        Menu.s_options_crosshair_box.name = "crosshair";
        Menu.s_options_crosshair_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.CrosshairFunc(o);
            }
        };
        Menu.s_options_crosshair_box.itemnames = crosshair_names;
        Menu.s_options_joystick_box.type = 3;
        Menu.s_options_joystick_box.x = 0;
        Menu.s_options_joystick_box.y = 120;
        Menu.s_options_joystick_box.name = "use joystick";
        Menu.s_options_joystick_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.JoystickFunc(o);
            }
        };
        Menu.s_options_joystick_box.itemnames = yesno_names;
        Menu.s_options_customize_options_action.type = 2;
        Menu.s_options_customize_options_action.x = 0;
        Menu.s_options_customize_options_action.y = 140;
        Menu.s_options_customize_options_action.name = "customize controls";
        Menu.s_options_customize_options_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.CustomizeControlsFunc(o);
            }
        };
        Menu.s_options_defaults_action.type = 2;
        Menu.s_options_defaults_action.x = 0;
        Menu.s_options_defaults_action.y = 150;
        Menu.s_options_defaults_action.name = "reset defaults";
        Menu.s_options_defaults_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.ControlsResetDefaultsFunc(o);
            }
        };
        Menu.s_options_console_action.type = 2;
        Menu.s_options_console_action.x = 0;
        Menu.s_options_console_action.y = 160;
        Menu.s_options_console_action.name = "go to console";
        Menu.s_options_console_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.ConsoleFunc(o);
            }
        };
        Menu.ControlsSetMenuItemValues();
        Menu.Menu_AddItem(s_options_menu, s_options_sfxvolume_slider);
        Menu.Menu_AddItem(s_options_menu, s_options_cdvolume_box);
        Menu.Menu_AddItem(s_options_menu, s_options_quality_list);
        Menu.Menu_AddItem(s_options_menu, s_options_sensitivity_slider);
        Menu.Menu_AddItem(s_options_menu, s_options_alwaysrun_box);
        Menu.Menu_AddItem(s_options_menu, s_options_invertmouse_box);
        Menu.Menu_AddItem(s_options_menu, s_options_lookspring_box);
        Menu.Menu_AddItem(s_options_menu, s_options_lookstrafe_box);
        Menu.Menu_AddItem(s_options_menu, s_options_freelook_box);
        Menu.Menu_AddItem(s_options_menu, s_options_crosshair_box);
        Menu.Menu_AddItem(s_options_menu, s_options_customize_options_action);
        Menu.Menu_AddItem(s_options_menu, s_options_defaults_action);
        Menu.Menu_AddItem(s_options_menu, s_options_console_action);
    }

    static void Options_MenuDraw() {
        Menu.Banner("m_banner_options");
        Menu.Menu_AdjustCursor(s_options_menu, 1);
        Menu.Menu_Draw(s_options_menu);
    }

    static String Options_MenuKey(int key) {
        return Menu.Default_MenuKey(s_options_menu, key);
    }

    static void Menu_Options_f() {
        Menu.Options_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Options_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Options_MenuKey(key);
            }
        });
    }

    static void Menu_Video_f() {
        VID.MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                VID.MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return VID.MenuKey(key);
            }
        });
    }

    public static void Credits_MenuDraw() {
        int i = 0;
        int y = (int)((float)viddef.getHeight() - (float)(Menu.cls.realtime - credits_start_time) / 40.0f);
        while (credits[i] != null && y < viddef.getHeight()) {
            int stringoffset = 0;
            boolean bold = false;
            if (y > -8) {
                if (credits[i].length() > 0 && credits[i].charAt(0) == '+') {
                    bold = true;
                    stringoffset = 1;
                } else {
                    bold = false;
                    stringoffset = 0;
                }
                int j = 0;
                while (j + stringoffset < credits[i].length()) {
                    int x = (viddef.getWidth() - credits[i].length() * 8 - stringoffset * 8) / 2 + (j + stringoffset) * 8;
                    if (bold) {
                        re.DrawChar(x, y, credits[i].charAt(j + stringoffset) + 128);
                    } else {
                        re.DrawChar(x, y, credits[i].charAt(j + stringoffset));
                    }
                    ++j;
                }
            }
            y += 10;
            ++i;
        }
        if (y < 0) {
            credits_start_time = Menu.cls.realtime;
        }
    }

    public static String Credits_Key(int key) {
        switch (key) {
            case 27: {
                if (creditsBuffer != null) {
                    // empty if block
                }
                Menu.PopMenu();
            }
        }
        return menu_out_sound;
    }

    static void Menu_Credits_f() {
        int isdeveloper = 0;
        byte[] b = FS.LoadFile("credits");
        if (b != null) {
            creditsBuffer = new String(b);
            String[] line = creditsBuffer.split("\r\n");
            for (int n = 0; n < line.length; ++n) {
                Menu.creditsIndex[n] = line[n];
            }
            Menu.creditsIndex[n] = null;
            credits = creditsIndex;
        } else {
            isdeveloper = FS.Developer_searchpath(1);
            credits = isdeveloper == 1 ? xatcredits : (isdeveloper == 2 ? roguecredits : idcredits);
        }
        credits_start_time = Menu.cls.realtime;
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Credits_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Credits_Key(key);
            }
        });
    }

    static void StartGame() {
        Menu.cl.servercount = -1;
        Menu.ForceMenuOff();
        Cvar.SetValue("deathmatch", 0);
        Cvar.SetValue("coop", 0);
        Cvar.SetValue("gamerules", 0);
        Cbuf.AddText("loading ; killserver ; wait ; newgame\n");
        Menu.cls.key_dest = 0;
    }

    static void EasyGameFunc(Object data) {
        Cvar.ForceSet("skill", "0");
        Menu.StartGame();
    }

    static void MediumGameFunc(Object data) {
        Cvar.ForceSet("skill", "1");
        Menu.StartGame();
    }

    static void HardGameFunc(Object data) {
        Cvar.ForceSet("skill", "2");
        Menu.StartGame();
    }

    static void LoadGameFunc(Object unused) {
        Menu.Menu_LoadGame_f();
    }

    static void SaveGameFunc(Object unused) {
        Menu.Menu_SaveGame_f();
    }

    static void CreditsFunc(Object unused) {
        Menu.Menu_Credits_f();
    }

    static void Game_MenuInit() {
        Menu.s_game_menu.x = (int)((double)viddef.getWidth() * 0.5);
        Menu.s_game_menu.nitems = 0;
        Menu.s_easy_game_action.type = 2;
        Menu.s_easy_game_action.flags = 1;
        Menu.s_easy_game_action.x = 0;
        Menu.s_easy_game_action.y = 0;
        Menu.s_easy_game_action.name = "easy";
        Menu.s_easy_game_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.EasyGameFunc(o);
            }
        };
        Menu.s_medium_game_action.type = 2;
        Menu.s_medium_game_action.flags = 1;
        Menu.s_medium_game_action.x = 0;
        Menu.s_medium_game_action.y = 10;
        Menu.s_medium_game_action.name = "medium";
        Menu.s_medium_game_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.MediumGameFunc(o);
            }
        };
        Menu.s_hard_game_action.type = 2;
        Menu.s_hard_game_action.flags = 1;
        Menu.s_hard_game_action.x = 0;
        Menu.s_hard_game_action.y = 20;
        Menu.s_hard_game_action.name = "hard";
        Menu.s_hard_game_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.HardGameFunc(o);
            }
        };
        Menu.s_blankline.type = 4;
        Menu.s_load_game_action.type = 2;
        Menu.s_load_game_action.flags = 1;
        Menu.s_load_game_action.x = 0;
        Menu.s_load_game_action.y = 40;
        Menu.s_load_game_action.name = "load game";
        Menu.s_load_game_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.LoadGameFunc(o);
            }
        };
        Menu.s_save_game_action.type = 2;
        Menu.s_save_game_action.flags = 1;
        Menu.s_save_game_action.x = 0;
        Menu.s_save_game_action.y = 50;
        Menu.s_save_game_action.name = "save game";
        Menu.s_save_game_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.SaveGameFunc(o);
            }
        };
        Menu.s_credits_action.type = 2;
        Menu.s_credits_action.flags = 1;
        Menu.s_credits_action.x = 0;
        Menu.s_credits_action.y = 60;
        Menu.s_credits_action.name = "credits";
        Menu.s_credits_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.CreditsFunc(o);
            }
        };
        Menu.Menu_AddItem(s_game_menu, s_easy_game_action);
        Menu.Menu_AddItem(s_game_menu, s_medium_game_action);
        Menu.Menu_AddItem(s_game_menu, s_hard_game_action);
        Menu.Menu_AddItem(s_game_menu, s_blankline);
        Menu.Menu_AddItem(s_game_menu, s_load_game_action);
        Menu.Menu_AddItem(s_game_menu, s_save_game_action);
        Menu.Menu_AddItem(s_game_menu, s_blankline);
        Menu.Menu_AddItem(s_game_menu, s_credits_action);
        Menu.Menu_Center(s_game_menu);
    }

    static void Game_MenuDraw() {
        Menu.Banner("m_banner_game");
        Menu.Menu_AdjustCursor(s_game_menu, 1);
        Menu.Menu_Draw(s_game_menu);
    }

    static String Game_MenuKey(int key) {
        return Menu.Default_MenuKey(s_game_menu, key);
    }

    static void Menu_Game_f() {
        Menu.Game_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Game_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Game_MenuKey(key);
            }
        });
        m_game_cursor = 1;
    }

    static void Create_Savestrings() {
        for (int i = 0; i < 15; ++i) {
            Menu.m_savestrings[i] = "<EMPTY>";
            String name = FS.Gamedir() + "/save/save" + i + "/server.ssv";
            try {
                QuakeFile f = new QuakeFile(name, "r");
                if (f == null) {
                    Menu.m_savestrings[i] = "<EMPTY>";
                    Menu.m_savevalid[i] = false;
                    continue;
                }
                String str = f.readString();
                if (str != null) {
                    Menu.m_savestrings[i] = str;
                }
                f.close();
                Menu.m_savevalid[i] = true;
                continue;
            }
            catch (Exception e) {
                Menu.m_savestrings[i] = "<EMPTY>";
                Menu.m_savevalid[i] = false;
            }
        }
    }

    static void LoadGameCallback(Object self) {
        menuaction_s a = (menuaction_s)self;
        if (m_savevalid[a.localdata[0]]) {
            Cbuf.AddText("load save" + a.localdata[0] + "\n");
        }
        Menu.ForceMenuOff();
    }

    static void LoadGame_MenuInit() {
        Menu.s_loadgame_menu.x = viddef.getWidth() / 2 - 120;
        Menu.s_loadgame_menu.y = viddef.getHeight() / 2 - 58;
        Menu.s_loadgame_menu.nitems = 0;
        Menu.Create_Savestrings();
        for (int i = 0; i < 15; ++i) {
            Menu.s_loadgame_actions[i].name = m_savestrings[i];
            Menu.s_loadgame_actions[i].flags = 1;
            Menu.s_loadgame_actions[i].localdata[0] = i;
            Menu.s_loadgame_actions[i].callback = new mcallback(){

                public void execute(Object o) {
                    Menu.LoadGameCallback(o);
                }
            };
            Menu.s_loadgame_actions[i].x = 0;
            Menu.s_loadgame_actions[i].y = i * 10;
            if (i > 0) {
                Menu.s_loadgame_actions[i].y += 10;
            }
            Menu.s_loadgame_actions[i].type = 2;
            Menu.Menu_AddItem(s_loadgame_menu, s_loadgame_actions[i]);
        }
    }

    static void LoadGame_MenuDraw() {
        Menu.Banner("m_banner_load_game");
        Menu.Menu_Draw(s_loadgame_menu);
    }

    static String LoadGame_MenuKey(int key) {
        if (key == 27 || key == 13) {
            Menu.s_savegame_menu.cursor = Menu.s_loadgame_menu.cursor - 1;
            if (Menu.s_savegame_menu.cursor < 0) {
                Menu.s_savegame_menu.cursor = 0;
            }
        }
        return Menu.Default_MenuKey(s_loadgame_menu, key);
    }

    static void Menu_LoadGame_f() {
        Menu.LoadGame_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.LoadGame_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.LoadGame_MenuKey(key);
            }
        });
    }

    static void SaveGameCallback(Object self) {
        menuaction_s a = (menuaction_s)self;
        Cbuf.AddText("save save" + a.localdata[0] + "\n");
        Menu.ForceMenuOff();
    }

    static void SaveGame_MenuDraw() {
        Menu.Banner("m_banner_save_game");
        Menu.Menu_AdjustCursor(s_savegame_menu, 1);
        Menu.Menu_Draw(s_savegame_menu);
    }

    static void SaveGame_MenuInit() {
        Menu.s_savegame_menu.x = viddef.getWidth() / 2 - 120;
        Menu.s_savegame_menu.y = viddef.getHeight() / 2 - 58;
        Menu.s_savegame_menu.nitems = 0;
        Menu.Create_Savestrings();
        for (int i = 0; i < 14; ++i) {
            Menu.s_savegame_actions[i].name = m_savestrings[i + 1];
            Menu.s_savegame_actions[i].localdata[0] = i + 1;
            Menu.s_savegame_actions[i].flags = 1;
            Menu.s_savegame_actions[i].callback = new mcallback(){

                public void execute(Object o) {
                    Menu.SaveGameCallback(o);
                }
            };
            Menu.s_savegame_actions[i].x = 0;
            Menu.s_savegame_actions[i].y = i * 10;
            Menu.s_savegame_actions[i].type = 2;
            Menu.Menu_AddItem(s_savegame_menu, s_savegame_actions[i]);
        }
    }

    static String SaveGame_MenuKey(int key) {
        if (key == 13 || key == 27) {
            Menu.s_loadgame_menu.cursor = Menu.s_savegame_menu.cursor - 1;
            if (Menu.s_loadgame_menu.cursor < 0) {
                Menu.s_loadgame_menu.cursor = 0;
            }
        }
        return Menu.Default_MenuKey(s_savegame_menu, key);
    }

    static void Menu_SaveGame_f() {
        if (0 == Globals.server_state) {
            return;
        }
        Menu.SaveGame_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.SaveGame_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.SaveGame_MenuKey(key);
            }
        });
        Menu.Create_Savestrings();
    }

    static void AddToServerList(netadr_t adr, String info) {
        if (m_num_servers == 8) {
            return;
        }
        String x = info.trim();
        for (int i = 0; i < m_num_servers; ++i) {
            if (!x.equals(local_server_names[i])) continue;
            return;
        }
        local_server_netadr[m_num_servers].set(adr);
        Menu.local_server_names[Menu.m_num_servers] = x;
        Menu.s_joinserver_server_actions[Menu.m_num_servers].name = x;
        ++m_num_servers;
    }

    static void JoinServerFunc(Object self) {
        int index = ((menucommon_s)self).n;
        if (Lib.Q_stricmp(local_server_names[index], "<no server>") == 0) {
            return;
        }
        if (index >= m_num_servers) {
            return;
        }
        String buffer = "connect " + NET.AdrToString(local_server_netadr[index]) + "\n";
        Cbuf.AddText(buffer);
        Menu.ForceMenuOff();
    }

    static void AddressBookFunc(Object self) {
        Menu.Menu_AddressBook_f();
    }

    static void NullCursorDraw(Object self) {
    }

    static void SearchLocalGames() {
        m_num_servers = 0;
        for (int i = 0; i < 8; ++i) {
            Menu.local_server_names[i] = "<no server>";
        }
        Menu.DrawTextBox(8, 72, 36, 3);
        Menu.Print(32, 80, "Searching for local servers, this");
        Menu.Print(32, 88, "could take up to a minute, so");
        Menu.Print(32, 96, "please be patient.");
        re.EndFrame();
        CL.PingServers_f.execute();
    }

    static void SearchLocalGamesFunc(Object self) {
        Menu.SearchLocalGames();
    }

    static void JoinServer_MenuInit() {
        int i;
        Menu.s_joinserver_menu.x = (int)((double)viddef.getWidth() * 0.5 - 120.0);
        Menu.s_joinserver_menu.nitems = 0;
        Menu.s_joinserver_address_book_action.type = 2;
        Menu.s_joinserver_address_book_action.name = "address book";
        Menu.s_joinserver_address_book_action.flags = 1;
        Menu.s_joinserver_address_book_action.x = 0;
        Menu.s_joinserver_address_book_action.y = 0;
        Menu.s_joinserver_address_book_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.AddressBookFunc(o);
            }
        };
        Menu.s_joinserver_search_action.type = 2;
        Menu.s_joinserver_search_action.name = "refresh server list";
        Menu.s_joinserver_search_action.flags = 1;
        Menu.s_joinserver_search_action.x = 0;
        Menu.s_joinserver_search_action.y = 10;
        Menu.s_joinserver_search_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.SearchLocalGamesFunc(o);
            }
        };
        Menu.s_joinserver_search_action.statusbar = "search for servers";
        Menu.s_joinserver_server_title.type = 4;
        Menu.s_joinserver_server_title.name = "connect to...";
        Menu.s_joinserver_server_title.x = 80;
        Menu.s_joinserver_server_title.y = 30;
        for (i = 0; i < 8; ++i) {
            Menu.s_joinserver_server_actions[i].type = 2;
            Menu.local_server_names[i] = "<no server>";
            Menu.s_joinserver_server_actions[i].name = local_server_names[i];
            Menu.s_joinserver_server_actions[i].flags = 1;
            Menu.s_joinserver_server_actions[i].x = 0;
            Menu.s_joinserver_server_actions[i].y = 40 + i * 10;
            Menu.s_joinserver_server_actions[i].callback = new mcallback(){

                public void execute(Object o) {
                    Menu.JoinServerFunc(o);
                }
            };
            Menu.s_joinserver_server_actions[i].statusbar = "press ENTER to connect";
        }
        Menu.Menu_AddItem(s_joinserver_menu, s_joinserver_address_book_action);
        Menu.Menu_AddItem(s_joinserver_menu, s_joinserver_server_title);
        Menu.Menu_AddItem(s_joinserver_menu, s_joinserver_search_action);
        for (i = 0; i < 8; ++i) {
            Menu.Menu_AddItem(s_joinserver_menu, s_joinserver_server_actions[i]);
        }
        Menu.Menu_Center(s_joinserver_menu);
        Menu.SearchLocalGames();
    }

    static void JoinServer_MenuDraw() {
        Menu.Banner("m_banner_join_server");
        Menu.Menu_Draw(s_joinserver_menu);
    }

    static String JoinServer_MenuKey(int key) {
        return Menu.Default_MenuKey(s_joinserver_menu, key);
    }

    static void Menu_JoinServer_f() {
        Menu.JoinServer_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.JoinServer_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.JoinServer_MenuKey(key);
            }
        });
    }

    static void DMOptionsFunc(Object self) {
        if (Menu.s_rules_box.curvalue == 1) {
            return;
        }
        Menu.Menu_DMOptions_f();
    }

    static void RulesChangeFunc(Object self) {
        if (Menu.s_rules_box.curvalue == 0) {
            Menu.s_maxclients_field.statusbar = null;
            Menu.s_startserver_dmoptions_action.statusbar = null;
        } else if (Menu.s_rules_box.curvalue == 1) {
            Menu.s_maxclients_field.statusbar = "4 maximum for cooperative";
            if (Lib.atoi(Menu.s_maxclients_field.buffer.toString()) > 4) {
                Menu.s_maxclients_field.buffer = new StringBuffer("4");
            }
            Menu.s_startserver_dmoptions_action.statusbar = "N/A for cooperative";
        } else if (FS.Developer_searchpath(2) == 2 && Menu.s_rules_box.curvalue == 2) {
            Menu.s_maxclients_field.statusbar = null;
            Menu.s_startserver_dmoptions_action.statusbar = null;
        }
    }

    static void StartServerActionFunc(Object self) {
        String x = mapnames[Menu.s_startmap_list.curvalue];
        int pos = x.indexOf(10);
        String startmap = pos == -1 ? x : x.substring(pos + 1, x.length());
        int maxclients = Lib.atoi(Menu.s_maxclients_field.buffer.toString());
        int timelimit = Lib.atoi(Menu.s_timelimit_field.buffer.toString());
        int fraglimit = Lib.atoi(Menu.s_fraglimit_field.buffer.toString());
        Cvar.SetValue("maxclients", Menu.ClampCvar(0.0f, maxclients, maxclients));
        Cvar.SetValue("timelimit", Menu.ClampCvar(0.0f, timelimit, timelimit));
        Cvar.SetValue("fraglimit", Menu.ClampCvar(0.0f, fraglimit, fraglimit));
        Cvar.Set("hostname", Menu.s_hostname_field.buffer.toString());
        if (Menu.s_rules_box.curvalue < 2 || FS.Developer_searchpath(2) != 2) {
            Cvar.SetValue("deathmatch", 1 - Menu.s_rules_box.curvalue);
            Cvar.SetValue("coop", Menu.s_rules_box.curvalue);
            Cvar.SetValue("gamerules", 0);
        } else {
            Cvar.SetValue("deathmatch", 1);
            Cvar.SetValue("coop", 0);
            Cvar.SetValue("gamerules", Menu.s_rules_box.curvalue);
        }
        String spot = null;
        if (Menu.s_rules_box.curvalue == 1) {
            if (Lib.Q_stricmp(startmap, "bunk1") == 0) {
                spot = "start";
            } else if (Lib.Q_stricmp(startmap, "mintro") == 0) {
                spot = "start";
            } else if (Lib.Q_stricmp(startmap, "fact1") == 0) {
                spot = "start";
            } else if (Lib.Q_stricmp(startmap, "power1") == 0) {
                spot = "pstart";
            } else if (Lib.Q_stricmp(startmap, "biggun") == 0) {
                spot = "bstart";
            } else if (Lib.Q_stricmp(startmap, "hangar1") == 0) {
                spot = "unitstart";
            } else if (Lib.Q_stricmp(startmap, "city1") == 0) {
                spot = "unitstart";
            } else if (Lib.Q_stricmp(startmap, "boss1") == 0) {
                spot = "bosstart";
            }
        }
        if (spot != null) {
            if (Globals.server_state != 0) {
                Cbuf.AddText("disconnect\n");
            }
            Cbuf.AddText("gamemap \"*" + startmap + "$" + spot + "\"\n");
        } else {
            Cbuf.AddText("map " + startmap + "\n");
        }
        Menu.ForceMenuOff();
    }

    static void StartServer_MenuInit() {
        String s;
        String[] lines;
        byte[] buffer = null;
        String mapsname = FS.Gamedir() + "/maps.lst";
        RandomAccessFile fp = Lib.fopen(mapsname, "r");
        if (fp == null) {
            buffer = FS.LoadFile("maps.lst");
            if (buffer == null) {
                Com.Error(1, "couldn't find maps.lst\n");
            }
        } else {
            try {
                int len = (int)fp.length();
                buffer = new byte[len];
                fp.readFully(buffer);
            }
            catch (Exception e) {
                Com.Error(1, "couldn't load maps.lst\n");
            }
        }
        if ((nummaps = (lines = (s = new String(buffer)).split("\r\n")).length) == 0) {
            Com.Error(1, "no maps in maps.lst\n");
        }
        mapnames = new String[nummaps];
        for (int i = 0; i < nummaps; ++i) {
            String scratch;
            Com.ParseHelp ph = new Com.ParseHelp(lines[i]);
            String shortname = Com.Parse(ph).toUpperCase();
            String longname = Com.Parse(ph);
            Menu.mapnames[i] = scratch = longname + "\n" + shortname;
        }
        if (fp != null) {
            Lib.fclose(fp);
            fp = null;
        } else {
            FS.FreeFile(buffer);
        }
        Menu.s_startserver_menu.x = (int)((double)viddef.getWidth() * 0.5);
        Menu.s_startserver_menu.nitems = 0;
        Menu.s_startmap_list.type = 3;
        Menu.s_startmap_list.x = 0;
        Menu.s_startmap_list.y = 0;
        Menu.s_startmap_list.name = "initial map";
        Menu.s_startmap_list.itemnames = mapnames;
        Menu.s_rules_box.type = 3;
        Menu.s_rules_box.x = 0;
        Menu.s_rules_box.y = 20;
        Menu.s_rules_box.name = "rules";
        Menu.s_rules_box.itemnames = FS.Developer_searchpath(2) == 2 ? dm_coop_names_rogue : dm_coop_names;
        Menu.s_rules_box.curvalue = Cvar.VariableValue("coop") != 0.0f ? 1 : 0;
        Menu.s_rules_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.RulesChangeFunc(o);
            }
        };
        Menu.s_timelimit_field.type = 5;
        Menu.s_timelimit_field.name = "time limit";
        Menu.s_timelimit_field.flags = 4;
        Menu.s_timelimit_field.x = 0;
        Menu.s_timelimit_field.y = 36;
        Menu.s_timelimit_field.statusbar = "0 = no limit";
        Menu.s_timelimit_field.length = 3;
        Menu.s_timelimit_field.visible_length = 3;
        Menu.s_timelimit_field.buffer = new StringBuffer(Cvar.VariableString("timelimit"));
        Menu.s_fraglimit_field.type = 5;
        Menu.s_fraglimit_field.name = "frag limit";
        Menu.s_fraglimit_field.flags = 4;
        Menu.s_fraglimit_field.x = 0;
        Menu.s_fraglimit_field.y = 54;
        Menu.s_fraglimit_field.statusbar = "0 = no limit";
        Menu.s_fraglimit_field.length = 3;
        Menu.s_fraglimit_field.visible_length = 3;
        Menu.s_fraglimit_field.buffer = new StringBuffer(Cvar.VariableString("fraglimit"));
        Menu.s_maxclients_field.type = 5;
        Menu.s_maxclients_field.name = "max players";
        Menu.s_maxclients_field.flags = 4;
        Menu.s_maxclients_field.x = 0;
        Menu.s_maxclients_field.y = 72;
        Menu.s_maxclients_field.statusbar = null;
        Menu.s_maxclients_field.length = 3;
        Menu.s_maxclients_field.visible_length = 3;
        Menu.s_maxclients_field.buffer = Cvar.VariableValue("maxclients") == 1.0f ? new StringBuffer("8") : new StringBuffer(Cvar.VariableString("maxclients"));
        Menu.s_hostname_field.type = 5;
        Menu.s_hostname_field.name = "hostname";
        Menu.s_hostname_field.flags = 0;
        Menu.s_hostname_field.x = 0;
        Menu.s_hostname_field.y = 90;
        Menu.s_hostname_field.statusbar = null;
        Menu.s_hostname_field.length = 12;
        Menu.s_hostname_field.visible_length = 12;
        Menu.s_hostname_field.buffer = new StringBuffer(Cvar.VariableString("hostname"));
        Menu.s_hostname_field.cursor = Menu.s_hostname_field.buffer.length();
        Menu.s_startserver_dmoptions_action.type = 2;
        Menu.s_startserver_dmoptions_action.name = " deathmatch flags";
        Menu.s_startserver_dmoptions_action.flags = 1;
        Menu.s_startserver_dmoptions_action.x = 24;
        Menu.s_startserver_dmoptions_action.y = 108;
        Menu.s_startserver_dmoptions_action.statusbar = null;
        Menu.s_startserver_dmoptions_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMOptionsFunc(o);
            }
        };
        Menu.s_startserver_start_action.type = 2;
        Menu.s_startserver_start_action.name = " begin";
        Menu.s_startserver_start_action.flags = 1;
        Menu.s_startserver_start_action.x = 24;
        Menu.s_startserver_start_action.y = 128;
        Menu.s_startserver_start_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.StartServerActionFunc(o);
            }
        };
        Menu.Menu_AddItem(s_startserver_menu, s_startmap_list);
        Menu.Menu_AddItem(s_startserver_menu, s_rules_box);
        Menu.Menu_AddItem(s_startserver_menu, s_timelimit_field);
        Menu.Menu_AddItem(s_startserver_menu, s_fraglimit_field);
        Menu.Menu_AddItem(s_startserver_menu, s_maxclients_field);
        Menu.Menu_AddItem(s_startserver_menu, s_hostname_field);
        Menu.Menu_AddItem(s_startserver_menu, s_startserver_dmoptions_action);
        Menu.Menu_AddItem(s_startserver_menu, s_startserver_start_action);
        Menu.Menu_Center(s_startserver_menu);
        Menu.RulesChangeFunc(null);
    }

    static void StartServer_MenuDraw() {
        Menu.Menu_Draw(s_startserver_menu);
    }

    static String StartServer_MenuKey(int key) {
        if (key == 27) {
            if (mapnames != null) {
                for (int i = 0; i < nummaps; ++i) {
                    Menu.mapnames[i] = null;
                }
            }
            mapnames = null;
            nummaps = 0;
        }
        return Menu.Default_MenuKey(s_startserver_menu, key);
    }

    static void Menu_StartServer_f() {
        Menu.StartServer_MenuInit();
        Menu.PushMenu(startServer_MenuDraw, startServer_MenuKey);
    }

    static void setvalue(int flags) {
        Cvar.SetValue("dmflags", flags);
        dmoptions_statusbar = "dmflags = " + flags;
    }

    static void DMFlagCallback(Object self) {
        menulist_s f = (menulist_s)self;
        int bit = 0;
        int flags = (int)Cvar.VariableValue("dmflags");
        if (f == s_friendlyfire_box) {
            flags = f.curvalue != 0 ? (flags &= 0xFFFFFEFF) : (flags |= 0x100);
            Menu.setvalue(flags);
            return;
        }
        if (f == s_falls_box) {
            flags = f.curvalue != 0 ? (flags &= 0xFFFFFFF7) : (flags |= 8);
            Menu.setvalue(flags);
            return;
        }
        if (f == s_weapons_stay_box) {
            bit = 4;
        } else if (f == s_instant_powerups_box) {
            bit = 16;
        } else if (f == s_allow_exit_box) {
            bit = 4096;
        } else {
            if (f == s_powerups_box) {
                flags = f.curvalue != 0 ? (flags &= 0xFFFFFFFD) : (flags |= 2);
                Menu.setvalue(flags);
                return;
            }
            if (f == s_health_box) {
                flags = f.curvalue != 0 ? (flags &= 0xFFFFFFFE) : (flags |= 1);
                Menu.setvalue(flags);
                return;
            }
            if (f == s_spawn_farthest_box) {
                bit = 512;
            } else {
                if (f == s_teamplay_box) {
                    if (f.curvalue == 1) {
                        flags |= 0x40;
                        flags &= 0xFFFFFF7F;
                    } else if (f.curvalue == 2) {
                        flags |= 0x80;
                        flags &= 0xFFFFFFBF;
                    } else {
                        flags &= 0xFFFFFF3F;
                    }
                    Menu.setvalue(flags);
                    return;
                }
                if (f == s_samelevel_box) {
                    bit = 32;
                } else if (f == s_force_respawn_box) {
                    bit = 1024;
                } else {
                    if (f == s_armor_box) {
                        flags = f.curvalue != 0 ? (flags &= 0xFFFFF7FF) : (flags |= 0x800);
                        Menu.setvalue(flags);
                        return;
                    }
                    if (f == s_infinite_ammo_box) {
                        bit = 8192;
                    } else if (f == s_fixed_fov_box) {
                        bit = 32768;
                    } else if (f == s_quad_drop_box) {
                        bit = 16384;
                    } else if (FS.Developer_searchpath(2) == 2) {
                        if (f == s_no_mines_box) {
                            bit = 131072;
                        } else if (f == s_no_nukes_box) {
                            bit = 524288;
                        } else if (f == s_stack_double_box) {
                            bit = 262144;
                        } else if (f == s_no_spheres_box) {
                            bit = 0x100000;
                        }
                    }
                }
            }
        }
        if (f != null) {
            flags = f.curvalue == 0 ? (flags &= ~bit) : (flags |= bit);
        }
        Cvar.SetValue("dmflags", flags);
        dmoptions_statusbar = "dmflags = " + flags;
    }

    static void DMOptions_MenuInit() {
        int dmflags = (int)Cvar.VariableValue("dmflags");
        int y = 0;
        Menu.s_dmoptions_menu.x = (int)((double)viddef.getWidth() * 0.5);
        Menu.s_dmoptions_menu.nitems = 0;
        Menu.s_falls_box.type = 3;
        Menu.s_falls_box.x = 0;
        Menu.s_falls_box.y = y;
        Menu.s_falls_box.name = "falling damage";
        Menu.s_falls_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_falls_box.itemnames = yes_no_names;
        Menu.s_falls_box.curvalue = (dmflags & 8) == 0 ? 1 : 0;
        Menu.s_weapons_stay_box.type = 3;
        Menu.s_weapons_stay_box.x = 0;
        Menu.s_weapons_stay_box.y = y += 10;
        Menu.s_weapons_stay_box.name = "weapons stay";
        Menu.s_weapons_stay_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_weapons_stay_box.itemnames = yes_no_names;
        Menu.s_weapons_stay_box.curvalue = (dmflags & 4) != 0 ? 1 : 0;
        Menu.s_instant_powerups_box.type = 3;
        Menu.s_instant_powerups_box.x = 0;
        Menu.s_instant_powerups_box.y = y += 10;
        Menu.s_instant_powerups_box.name = "instant powerups";
        Menu.s_instant_powerups_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_instant_powerups_box.itemnames = yes_no_names;
        Menu.s_instant_powerups_box.curvalue = (dmflags & 0x10) != 0 ? 1 : 0;
        Menu.s_powerups_box.type = 3;
        Menu.s_powerups_box.x = 0;
        Menu.s_powerups_box.y = y += 10;
        Menu.s_powerups_box.name = "allow powerups";
        Menu.s_powerups_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_powerups_box.itemnames = yes_no_names;
        Menu.s_powerups_box.curvalue = (dmflags & 2) == 0 ? 1 : 0;
        Menu.s_health_box.type = 3;
        Menu.s_health_box.x = 0;
        Menu.s_health_box.y = y += 10;
        Menu.s_health_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_health_box.name = "allow health";
        Menu.s_health_box.itemnames = yes_no_names;
        Menu.s_health_box.curvalue = (dmflags & 1) == 0 ? 1 : 0;
        Menu.s_armor_box.type = 3;
        Menu.s_armor_box.x = 0;
        Menu.s_armor_box.y = y += 10;
        Menu.s_armor_box.name = "allow armor";
        Menu.s_armor_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_armor_box.itemnames = yes_no_names;
        Menu.s_armor_box.curvalue = (dmflags & 0x800) == 0 ? 1 : 0;
        Menu.s_spawn_farthest_box.type = 3;
        Menu.s_spawn_farthest_box.x = 0;
        Menu.s_spawn_farthest_box.y = y += 10;
        Menu.s_spawn_farthest_box.name = "spawn farthest";
        Menu.s_spawn_farthest_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_spawn_farthest_box.itemnames = yes_no_names;
        Menu.s_spawn_farthest_box.curvalue = (dmflags & 0x200) != 0 ? 1 : 0;
        Menu.s_samelevel_box.type = 3;
        Menu.s_samelevel_box.x = 0;
        Menu.s_samelevel_box.y = y += 10;
        Menu.s_samelevel_box.name = "same map";
        Menu.s_samelevel_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_samelevel_box.itemnames = yes_no_names;
        Menu.s_samelevel_box.curvalue = (dmflags & 0x20) != 0 ? 1 : 0;
        Menu.s_force_respawn_box.type = 3;
        Menu.s_force_respawn_box.x = 0;
        Menu.s_force_respawn_box.y = y += 10;
        Menu.s_force_respawn_box.name = "force respawn";
        Menu.s_force_respawn_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_force_respawn_box.itemnames = yes_no_names;
        Menu.s_force_respawn_box.curvalue = (dmflags & 0x400) != 0 ? 1 : 0;
        Menu.s_teamplay_box.type = 3;
        Menu.s_teamplay_box.x = 0;
        Menu.s_teamplay_box.y = y += 10;
        Menu.s_teamplay_box.name = "teamplay";
        Menu.s_teamplay_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_teamplay_box.itemnames = teamplay_names;
        Menu.s_allow_exit_box.type = 3;
        Menu.s_allow_exit_box.x = 0;
        Menu.s_allow_exit_box.y = y += 10;
        Menu.s_allow_exit_box.name = "allow exit";
        Menu.s_allow_exit_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_allow_exit_box.itemnames = yes_no_names;
        Menu.s_allow_exit_box.curvalue = (dmflags & 0x1000) != 0 ? 1 : 0;
        Menu.s_infinite_ammo_box.type = 3;
        Menu.s_infinite_ammo_box.x = 0;
        Menu.s_infinite_ammo_box.y = y += 10;
        Menu.s_infinite_ammo_box.name = "infinite ammo";
        Menu.s_infinite_ammo_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_infinite_ammo_box.itemnames = yes_no_names;
        Menu.s_infinite_ammo_box.curvalue = (dmflags & 0x2000) != 0 ? 1 : 0;
        Menu.s_fixed_fov_box.type = 3;
        Menu.s_fixed_fov_box.x = 0;
        Menu.s_fixed_fov_box.y = y += 10;
        Menu.s_fixed_fov_box.name = "fixed FOV";
        Menu.s_fixed_fov_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_fixed_fov_box.itemnames = yes_no_names;
        Menu.s_fixed_fov_box.curvalue = (dmflags & 0x8000) != 0 ? 1 : 0;
        Menu.s_quad_drop_box.type = 3;
        Menu.s_quad_drop_box.x = 0;
        Menu.s_quad_drop_box.y = y += 10;
        Menu.s_quad_drop_box.name = "quad drop";
        Menu.s_quad_drop_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_quad_drop_box.itemnames = yes_no_names;
        Menu.s_quad_drop_box.curvalue = (dmflags & 0x4000) != 0 ? 1 : 0;
        Menu.s_friendlyfire_box.type = 3;
        Menu.s_friendlyfire_box.x = 0;
        Menu.s_friendlyfire_box.y = y += 10;
        Menu.s_friendlyfire_box.name = "friendly fire";
        Menu.s_friendlyfire_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DMFlagCallback(o);
            }
        };
        Menu.s_friendlyfire_box.itemnames = yes_no_names;
        int n = Menu.s_friendlyfire_box.curvalue = (dmflags & 0x100) == 0 ? 1 : 0;
        if (FS.Developer_searchpath(2) == 2) {
            Menu.s_no_mines_box.type = 3;
            Menu.s_no_mines_box.x = 0;
            Menu.s_no_mines_box.y = y += 10;
            Menu.s_no_mines_box.name = "remove mines";
            Menu.s_no_mines_box.callback = new mcallback(){

                public void execute(Object o) {
                    Menu.DMFlagCallback(o);
                }
            };
            Menu.s_no_mines_box.itemnames = yes_no_names;
            Menu.s_no_mines_box.curvalue = (dmflags & 0x20000) != 0 ? 1 : 0;
            Menu.s_no_nukes_box.type = 3;
            Menu.s_no_nukes_box.x = 0;
            Menu.s_no_nukes_box.y = y += 10;
            Menu.s_no_nukes_box.name = "remove nukes";
            Menu.s_no_nukes_box.callback = new mcallback(){

                public void execute(Object o) {
                    Menu.DMFlagCallback(o);
                }
            };
            Menu.s_no_nukes_box.itemnames = yes_no_names;
            Menu.s_no_nukes_box.curvalue = (dmflags & 0x80000) != 0 ? 1 : 0;
            Menu.s_stack_double_box.type = 3;
            Menu.s_stack_double_box.x = 0;
            Menu.s_stack_double_box.y = y += 10;
            Menu.s_stack_double_box.name = "2x/4x stacking off";
            Menu.s_stack_double_box.callback = new mcallback(){

                public void execute(Object o) {
                    Menu.DMFlagCallback(o);
                }
            };
            Menu.s_stack_double_box.itemnames = yes_no_names;
            Menu.s_stack_double_box.curvalue = dmflags & 0x40000;
            Menu.s_no_spheres_box.type = 3;
            Menu.s_no_spheres_box.x = 0;
            Menu.s_no_spheres_box.y = y += 10;
            Menu.s_no_spheres_box.name = "remove spheres";
            Menu.s_no_spheres_box.callback = new mcallback(){

                public void execute(Object o) {
                    Menu.DMFlagCallback(o);
                }
            };
            Menu.s_no_spheres_box.itemnames = yes_no_names;
            Menu.s_no_spheres_box.curvalue = (dmflags & 0x100000) != 0 ? 1 : 0;
        }
        Menu.Menu_AddItem(s_dmoptions_menu, s_falls_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_weapons_stay_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_instant_powerups_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_powerups_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_health_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_armor_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_spawn_farthest_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_samelevel_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_force_respawn_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_teamplay_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_allow_exit_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_infinite_ammo_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_fixed_fov_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_quad_drop_box);
        Menu.Menu_AddItem(s_dmoptions_menu, s_friendlyfire_box);
        if (FS.Developer_searchpath(2) == 2) {
            Menu.Menu_AddItem(s_dmoptions_menu, s_no_mines_box);
            Menu.Menu_AddItem(s_dmoptions_menu, s_no_nukes_box);
            Menu.Menu_AddItem(s_dmoptions_menu, s_stack_double_box);
            Menu.Menu_AddItem(s_dmoptions_menu, s_no_spheres_box);
        }
        Menu.Menu_Center(s_dmoptions_menu);
        Menu.DMFlagCallback(null);
        Menu.Menu_SetStatusBar(s_dmoptions_menu, dmoptions_statusbar);
    }

    static void DMOptions_MenuDraw() {
        Menu.Menu_Draw(s_dmoptions_menu);
    }

    static String DMOptions_MenuKey(int key) {
        return Menu.Default_MenuKey(s_dmoptions_menu, key);
    }

    static void Menu_DMOptions_f() {
        Menu.DMOptions_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.DMOptions_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.DMOptions_MenuKey(key);
            }
        });
    }

    static void DownloadCallback(Object self) {
        menulist_s f = (menulist_s)self;
        if (f == s_allow_download_box) {
            Cvar.SetValue("allow_download", f.curvalue);
        } else if (f == s_allow_download_maps_box) {
            Cvar.SetValue("allow_download_maps", f.curvalue);
        } else if (f == s_allow_download_models_box) {
            Cvar.SetValue("allow_download_models", f.curvalue);
        } else if (f == s_allow_download_players_box) {
            Cvar.SetValue("allow_download_players", f.curvalue);
        } else if (f == s_allow_download_sounds_box) {
            Cvar.SetValue("allow_download_sounds", f.curvalue);
        }
    }

    static void DownloadOptions_MenuInit() {
        int y = 0;
        Menu.s_downloadoptions_menu.x = (int)((double)viddef.getWidth() * 0.5);
        Menu.s_downloadoptions_menu.nitems = 0;
        Menu.s_download_title.type = 4;
        Menu.s_download_title.name = "Download Options";
        Menu.s_download_title.x = 48;
        Menu.s_download_title.y = y;
        Menu.s_allow_download_box.type = 3;
        Menu.s_allow_download_box.x = 0;
        Menu.s_allow_download_box.y = y += 20;
        Menu.s_allow_download_box.name = "allow downloading";
        Menu.s_allow_download_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DownloadCallback(o);
            }
        };
        Menu.s_allow_download_box.itemnames = yes_no_names;
        Menu.s_allow_download_box.curvalue = Cvar.VariableValue("allow_download") != 0.0f ? 1 : 0;
        Menu.s_allow_download_maps_box.type = 3;
        Menu.s_allow_download_maps_box.x = 0;
        Menu.s_allow_download_maps_box.y = y += 20;
        Menu.s_allow_download_maps_box.name = "maps";
        Menu.s_allow_download_maps_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DownloadCallback(o);
            }
        };
        Menu.s_allow_download_maps_box.itemnames = yes_no_names;
        Menu.s_allow_download_maps_box.curvalue = Cvar.VariableValue("allow_download_maps") != 0.0f ? 1 : 0;
        Menu.s_allow_download_players_box.type = 3;
        Menu.s_allow_download_players_box.x = 0;
        Menu.s_allow_download_players_box.y = y += 10;
        Menu.s_allow_download_players_box.name = "player models/skins";
        Menu.s_allow_download_players_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DownloadCallback(o);
            }
        };
        Menu.s_allow_download_players_box.itemnames = yes_no_names;
        Menu.s_allow_download_players_box.curvalue = Cvar.VariableValue("allow_download_players") != 0.0f ? 1 : 0;
        Menu.s_allow_download_models_box.type = 3;
        Menu.s_allow_download_models_box.x = 0;
        Menu.s_allow_download_models_box.y = y += 10;
        Menu.s_allow_download_models_box.name = "models";
        Menu.s_allow_download_models_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DownloadCallback(o);
            }
        };
        Menu.s_allow_download_models_box.itemnames = yes_no_names;
        Menu.s_allow_download_models_box.curvalue = Cvar.VariableValue("allow_download_models") != 0.0f ? 1 : 0;
        Menu.s_allow_download_sounds_box.type = 3;
        Menu.s_allow_download_sounds_box.x = 0;
        Menu.s_allow_download_sounds_box.y = y += 10;
        Menu.s_allow_download_sounds_box.name = "sounds";
        Menu.s_allow_download_sounds_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DownloadCallback(o);
            }
        };
        Menu.s_allow_download_sounds_box.itemnames = yes_no_names;
        Menu.s_allow_download_sounds_box.curvalue = Cvar.VariableValue("allow_download_sounds") != 0.0f ? 1 : 0;
        Menu.Menu_AddItem(s_downloadoptions_menu, s_download_title);
        Menu.Menu_AddItem(s_downloadoptions_menu, s_allow_download_box);
        Menu.Menu_AddItem(s_downloadoptions_menu, s_allow_download_maps_box);
        Menu.Menu_AddItem(s_downloadoptions_menu, s_allow_download_players_box);
        Menu.Menu_AddItem(s_downloadoptions_menu, s_allow_download_models_box);
        Menu.Menu_AddItem(s_downloadoptions_menu, s_allow_download_sounds_box);
        Menu.Menu_Center(s_downloadoptions_menu);
        if (Menu.s_downloadoptions_menu.cursor == 0) {
            Menu.s_downloadoptions_menu.cursor = 1;
        }
    }

    static void DownloadOptions_MenuDraw() {
        Menu.Menu_Draw(s_downloadoptions_menu);
    }

    static String DownloadOptions_MenuKey(int key) {
        return Menu.Default_MenuKey(s_downloadoptions_menu, key);
    }

    static void Menu_DownloadOptions_f() {
        Menu.DownloadOptions_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.DownloadOptions_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.DownloadOptions_MenuKey(key);
            }
        });
    }

    static void AddressBook_MenuInit() {
        Menu.s_addressbook_menu.x = viddef.getWidth() / 2 - 142;
        Menu.s_addressbook_menu.y = viddef.getHeight() / 2 - 58;
        Menu.s_addressbook_menu.nitems = 0;
        for (int i = 0; i < 9; ++i) {
            cvar_t adr = Cvar.Get("adr" + i, "", 1);
            Menu.s_addressbook_fields[i].type = 5;
            Menu.s_addressbook_fields[i].name = null;
            Menu.s_addressbook_fields[i].callback = null;
            Menu.s_addressbook_fields[i].x = 0;
            Menu.s_addressbook_fields[i].y = i * 18 + 0;
            Menu.s_addressbook_fields[i].localdata[0] = i;
            Menu.s_addressbook_fields[i].cursor = adr.string.length();
            Menu.s_addressbook_fields[i].length = 60;
            Menu.s_addressbook_fields[i].visible_length = 30;
            Menu.s_addressbook_fields[i].buffer = new StringBuffer(adr.string);
            Menu.Menu_AddItem(s_addressbook_menu, s_addressbook_fields[i]);
        }
    }

    static String AddressBook_MenuKey_f(int key) {
        if (key == 27) {
            for (int index = 0; index < 9; ++index) {
                Cvar.Set("adr" + index, Menu.s_addressbook_fields[index].buffer.toString());
            }
        }
        return Menu.Default_MenuKey(s_addressbook_menu, key);
    }

    static void AddressBook_MenuDraw_f() {
        Menu.Banner("m_banner_addressbook");
        Menu.Menu_Draw(s_addressbook_menu);
    }

    static void Menu_AddressBook_f() {
        Menu.AddressBook_MenuInit();
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.AddressBook_MenuDraw_f();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.AddressBook_MenuKey_f(key);
            }
        });
    }

    static void DownloadOptionsFunc(Object self) {
        Menu.Menu_DownloadOptions_f();
    }

    static void HandednessCallback(Object unused) {
        Cvar.SetValue("hand", Menu.s_player_handedness_box.curvalue);
    }

    static void RateCallback(Object unused) {
        if (Menu.s_player_rate_box.curvalue != rate_tbl.length - 1) {
            Cvar.SetValue("rate", rate_tbl[Menu.s_player_rate_box.curvalue]);
        }
    }

    static void ModelCallback(Object unused) {
        Menu.s_player_skin_box.itemnames = Menu.s_pmi[Menu.s_player_model_box.curvalue].skindisplaynames;
        Menu.s_player_skin_box.curvalue = 0;
    }

    static boolean IconOfSkinExists(String skin, String[] pcxfiles, int npcxfiles) {
        String scratch = skin;
        int pos = scratch.lastIndexOf(46);
        scratch = pos != -1 ? scratch.substring(0, pos) + "_i.pcx" : scratch + "_i.pcx";
        for (int i = 0; i < npcxfiles; ++i) {
            if (!pcxfiles[i].equals(scratch)) continue;
            return true;
        }
        return false;
    }

    static boolean PlayerConfig_ScanDirectories() {
        String[] dirnames;
        int ndirs = 0;
        int npms = 0;
        String path = null;
        s_numplayermodels = 0;
        do {
            String findname;
            if ((dirnames = FS.ListFiles(findname = (path = FS.NextPath(path)) + "/players/*.*", 0, 8)) == null) continue;
            ndirs = dirnames.length;
            break;
        } while (path != null);
        if (dirnames == null) {
            return false;
        }
        npms = ndirs;
        if (npms > 1024) {
            npms = 1024;
        }
        for (int i = 0; i < npms; ++i) {
            int c;
            int b;
            int a;
            int k;
            int nskins = 0;
            if (dirnames[i] == null) continue;
            String scratch = dirnames[i];
            if (Sys.FindFirst(scratch = scratch + "/tris.md2", 0, 26) == null) {
                dirnames[i] = null;
                Sys.FindClose();
                continue;
            }
            Sys.FindClose();
            scratch = dirnames[i] + "/*.pcx";
            String[] pcxnames = FS.ListFiles(scratch, 0, 0);
            int npcxfiles = pcxnames.length;
            if (pcxnames == null) {
                dirnames[i] = null;
                continue;
            }
            for (k = 0; k < npcxfiles - 1; ++k) {
                if (pcxnames[k].endsWith("_i.pcx") || !Menu.IconOfSkinExists(pcxnames[k], pcxnames, npcxfiles - 1)) continue;
                ++nskins;
            }
            if (nskins == 0) continue;
            String[] skinnames = new String[nskins + 1];
            int s = 0;
            for (k = 0; k < npcxfiles - 1; ++k) {
                if (pcxnames[k].indexOf("_i.pcx") >= 0 || !Menu.IconOfSkinExists(pcxnames[k], pcxnames, npcxfiles - 1)) continue;
                a = pcxnames[k].lastIndexOf(47);
                c = a > (b = pcxnames[k].lastIndexOf(92)) ? a : b;
                scratch = pcxnames[k].substring(c + 1, pcxnames[k].length());
                int pos = scratch.lastIndexOf(46);
                if (pos != -1) {
                    scratch = scratch.substring(0, pos);
                }
                skinnames[s] = scratch;
                ++s;
            }
            if (s_pmi[s_numplayermodels] == null) {
                Menu.s_pmi[Menu.s_numplayermodels] = new playermodelinfo_s();
            }
            Menu.s_pmi[Menu.s_numplayermodels].nskins = nskins;
            Menu.s_pmi[Menu.s_numplayermodels].skindisplaynames = skinnames;
            a = dirnames[i].lastIndexOf(47);
            c = a > (b = dirnames[i].lastIndexOf(92)) ? a : b;
            Menu.s_pmi[Menu.s_numplayermodels].displayname = dirnames[i].substring(c + 1);
            Menu.s_pmi[Menu.s_numplayermodels].directory = dirnames[i].substring(c + 1);
            ++s_numplayermodels;
        }
        return true;
    }

    static int pmicmpfnc(Object _a, Object _b) {
        playermodelinfo_s a = (playermodelinfo_s)_a;
        playermodelinfo_s b = (playermodelinfo_s)_b;
        if (a.directory.equals("male")) {
            return -1;
        }
        if (b.directory.equals("male")) {
            return 1;
        }
        if (a.directory.equals("female")) {
            return -1;
        }
        if (b.directory.equals("female")) {
            return 1;
        }
        return a.directory.compareTo(b.directory);
    }

    static boolean PlayerConfig_MenuInit() {
        String currentskin;
        String currentdirectory;
        int i = 0;
        int currentdirectoryindex = 0;
        int currentskinindex = 0;
        cvar_t hand = Cvar.Get("hand", "0", 3);
        Menu.PlayerConfig_ScanDirectories();
        if (s_numplayermodels == 0) {
            return false;
        }
        if (hand.value < 0.0f || hand.value > 2.0f) {
            Cvar.SetValue("hand", 0);
        }
        if ((currentdirectory = Menu.skin.string).lastIndexOf(47) != -1) {
            currentskin = Lib.rightFrom(currentdirectory, '/');
            currentdirectory = Lib.leftFrom(currentdirectory, '/');
        } else if (currentdirectory.lastIndexOf(92) != -1) {
            currentskin = Lib.rightFrom(currentdirectory, '\\');
            currentdirectory = Lib.leftFrom(currentdirectory, '\\');
        } else {
            currentdirectory = "male";
            currentskin = "grunt";
        }
        Arrays.sort(s_pmi, 0, s_numplayermodels, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Menu.pmicmpfnc(o1, o2);
            }
        });
        s_pmnames = new String[1024];
        block0: for (i = 0; i < s_numplayermodels; ++i) {
            Menu.s_pmnames[i] = Menu.s_pmi[i].displayname;
            if (Lib.Q_stricmp(Menu.s_pmi[i].directory, currentdirectory) != 0) continue;
            currentdirectoryindex = i;
            for (int j = 0; j < Menu.s_pmi[i].nskins; ++j) {
                if (Lib.Q_stricmp(Menu.s_pmi[i].skindisplaynames[j], currentskin) != 0) continue;
                currentskinindex = j;
                continue block0;
            }
        }
        Menu.s_player_config_menu.x = viddef.getWidth() / 2 - 95;
        Menu.s_player_config_menu.y = viddef.getHeight() / 2 - 97;
        Menu.s_player_config_menu.nitems = 0;
        Menu.s_player_name_field.type = 5;
        Menu.s_player_name_field.name = "name";
        Menu.s_player_name_field.callback = null;
        Menu.s_player_name_field.x = 0;
        Menu.s_player_name_field.y = 0;
        Menu.s_player_name_field.length = 20;
        Menu.s_player_name_field.visible_length = 20;
        Menu.s_player_name_field.buffer = new StringBuffer(Menu.name.string);
        Menu.s_player_name_field.cursor = Menu.name.string.length();
        Menu.s_player_model_title.type = 4;
        Menu.s_player_model_title.name = "model";
        Menu.s_player_model_title.x = -8;
        Menu.s_player_model_title.y = 60;
        Menu.s_player_model_box.type = 3;
        Menu.s_player_model_box.x = -56;
        Menu.s_player_model_box.y = 70;
        Menu.s_player_model_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.ModelCallback(o);
            }
        };
        Menu.s_player_model_box.cursor_offset = -48;
        Menu.s_player_model_box.curvalue = currentdirectoryindex;
        Menu.s_player_model_box.itemnames = s_pmnames;
        Menu.s_player_skin_title.type = 4;
        Menu.s_player_skin_title.name = "skin";
        Menu.s_player_skin_title.x = -16;
        Menu.s_player_skin_title.y = 84;
        Menu.s_player_skin_box.type = 3;
        Menu.s_player_skin_box.x = -56;
        Menu.s_player_skin_box.y = 94;
        Menu.s_player_skin_box.name = null;
        Menu.s_player_skin_box.callback = null;
        Menu.s_player_skin_box.cursor_offset = -48;
        Menu.s_player_skin_box.curvalue = currentskinindex;
        Menu.s_player_skin_box.itemnames = Menu.s_pmi[currentdirectoryindex].skindisplaynames;
        Menu.s_player_hand_title.type = 4;
        Menu.s_player_hand_title.name = "handedness";
        Menu.s_player_hand_title.x = 32;
        Menu.s_player_hand_title.y = 108;
        Menu.s_player_handedness_box.type = 3;
        Menu.s_player_handedness_box.x = -56;
        Menu.s_player_handedness_box.y = 118;
        Menu.s_player_handedness_box.name = null;
        Menu.s_player_handedness_box.cursor_offset = -48;
        Menu.s_player_handedness_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.HandednessCallback(o);
            }
        };
        Menu.s_player_handedness_box.curvalue = (int)Cvar.VariableValue("hand");
        Menu.s_player_handedness_box.itemnames = handedness;
        for (i = 0; i < rate_tbl.length - 1 && Cvar.VariableValue("rate") != (float)rate_tbl[i]; ++i) {
        }
        Menu.s_player_rate_title.type = 4;
        Menu.s_player_rate_title.name = "connect speed";
        Menu.s_player_rate_title.x = 56;
        Menu.s_player_rate_title.y = 156;
        Menu.s_player_rate_box.type = 3;
        Menu.s_player_rate_box.x = -56;
        Menu.s_player_rate_box.y = 166;
        Menu.s_player_rate_box.name = null;
        Menu.s_player_rate_box.cursor_offset = -48;
        Menu.s_player_rate_box.callback = new mcallback(){

            public void execute(Object o) {
                Menu.RateCallback(o);
            }
        };
        Menu.s_player_rate_box.curvalue = i;
        Menu.s_player_rate_box.itemnames = rate_names;
        Menu.s_player_download_action.type = 2;
        Menu.s_player_download_action.name = "download options";
        Menu.s_player_download_action.flags = 1;
        Menu.s_player_download_action.x = -24;
        Menu.s_player_download_action.y = 186;
        Menu.s_player_download_action.statusbar = null;
        Menu.s_player_download_action.callback = new mcallback(){

            public void execute(Object o) {
                Menu.DownloadOptionsFunc(o);
            }
        };
        Menu.Menu_AddItem(s_player_config_menu, s_player_name_field);
        Menu.Menu_AddItem(s_player_config_menu, s_player_model_title);
        Menu.Menu_AddItem(s_player_config_menu, s_player_model_box);
        if (Menu.s_player_skin_box.itemnames != null) {
            Menu.Menu_AddItem(s_player_config_menu, s_player_skin_title);
            Menu.Menu_AddItem(s_player_config_menu, s_player_skin_box);
        }
        Menu.Menu_AddItem(s_player_config_menu, s_player_hand_title);
        Menu.Menu_AddItem(s_player_config_menu, s_player_handedness_box);
        Menu.Menu_AddItem(s_player_config_menu, s_player_rate_title);
        Menu.Menu_AddItem(s_player_config_menu, s_player_rate_box);
        Menu.Menu_AddItem(s_player_config_menu, s_player_download_action);
        return true;
    }

    static void PlayerConfig_MenuDraw() {
        refdef_t refdef = new refdef_t();
        refdef.x = viddef.getWidth() / 2;
        refdef.y = viddef.getHeight() / 2 - 72;
        refdef.width = 144;
        refdef.height = 168;
        refdef.fov_x = 40.0f;
        refdef.fov_y = Math3D.CalcFov(refdef.fov_x, refdef.width, refdef.height);
        refdef.time = (float)Menu.cls.realtime * 0.001f;
        if (Menu.s_pmi[Menu.s_player_model_box.curvalue].skindisplaynames != null) {
            entity.clear();
            String scratch = "players/" + Menu.s_pmi[Menu.s_player_model_box.curvalue].directory + "/tris.md2";
            Menu.entity.model = re.RegisterModel(scratch);
            scratch = "players/" + Menu.s_pmi[Menu.s_player_model_box.curvalue].directory + "/" + Menu.s_pmi[Menu.s_player_model_box.curvalue].skindisplaynames[Menu.s_player_skin_box.curvalue] + ".pcx";
            Menu.entity.skin = re.RegisterSkin(scratch);
            Menu.entity.flags = 8;
            Menu.entity.origin[0] = 80.0f;
            Menu.entity.origin[1] = 0.0f;
            Menu.entity.origin[2] = 0.0f;
            Math3D.VectorCopy(Menu.entity.origin, Menu.entity.oldorigin);
            Menu.entity.frame = 0;
            Menu.entity.oldframe = 0;
            Menu.entity.backlerp = 0.0f;
            Menu.entity.angles[1] = yaw++;
            if (++yaw > 360) {
                yaw -= 360;
            }
            refdef.areabits = null;
            refdef.num_entities = 1;
            refdef.entities = new entity_t[]{entity};
            refdef.lightstyles = null;
            refdef.rdflags = 2;
            Menu.Menu_Draw(s_player_config_menu);
            Menu.DrawTextBox((int)((float)refdef.x * (320.0f / (float)viddef.getWidth()) - 8.0f), (int)((float)(viddef.getHeight() / 2) * (240.0f / (float)viddef.getHeight()) - 77.0f), refdef.width / 8, refdef.height / 8);
            refdef.height += 4;
            re.RenderFrame(refdef);
            scratch = "/players/" + Menu.s_pmi[Menu.s_player_model_box.curvalue].directory + "/" + Menu.s_pmi[Menu.s_player_model_box.curvalue].skindisplaynames[Menu.s_player_skin_box.curvalue] + "_i.pcx";
            re.DrawPic(Menu.s_player_config_menu.x - 40, refdef.y, scratch);
        }
    }

    static String PlayerConfig_MenuKey(int key) {
        if (key == 27) {
            Cvar.Set("name", Menu.s_player_name_field.buffer.toString());
            String scratch = Menu.s_pmi[Menu.s_player_model_box.curvalue].directory + "/" + Menu.s_pmi[Menu.s_player_model_box.curvalue].skindisplaynames[Menu.s_player_skin_box.curvalue];
            Cvar.Set("skin", scratch);
            for (int i = 0; i < s_numplayermodels; ++i) {
                for (int j = 0; j < Menu.s_pmi[i].nskins; ++j) {
                    if (Menu.s_pmi[i].skindisplaynames[j] == null) continue;
                    Menu.s_pmi[i].skindisplaynames[j] = null;
                }
                Menu.s_pmi[i].skindisplaynames = null;
                Menu.s_pmi[i].nskins = 0;
            }
        }
        return Menu.Default_MenuKey(s_player_config_menu, key);
    }

    static void Menu_PlayerConfig_f() {
        if (!Menu.PlayerConfig_MenuInit()) {
            Menu.Menu_SetStatusBar(s_multiplayer_menu, "No valid player models found");
            return;
        }
        Menu.Menu_SetStatusBar(s_multiplayer_menu, null);
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.PlayerConfig_MenuDraw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.PlayerConfig_MenuKey(key);
            }
        });
    }

    static String Quit_Key(int key) {
        switch (key) {
            case 27: 
            case 78: 
            case 110: {
                Menu.PopMenu();
                break;
            }
            case 89: 
            case 121: {
                Menu.cls.key_dest = 1;
                CL.Quit_f.execute();
                break;
            }
        }
        return null;
    }

    static void Quit_Draw() {
        Dimension d = new Dimension();
        re.DrawGetPicSize(d, "quit");
        int w = d.width;
        int h = d.height;
        re.DrawPic((viddef.getWidth() - w) / 2, (viddef.getHeight() - h) / 2, "quit");
    }

    static void Menu_Quit_f() {
        Menu.PushMenu(new xcommand_t(){

            public void execute() {
                Menu.Quit_Draw();
            }
        }, new keyfunc_t(){

            public String execute(int key) {
                return Menu.Quit_Key(key);
            }
        });
    }

    public static void Init() {
        Cmd.AddCommand("menu_main", Menu_Main);
        Cmd.AddCommand("menu_game", Menu_Game);
        Cmd.AddCommand("menu_loadgame", Menu_LoadGame);
        Cmd.AddCommand("menu_savegame", Menu_SaveGame);
        Cmd.AddCommand("menu_joinserver", Menu_JoinServer);
        Cmd.AddCommand("menu_addressbook", Menu_AddressBook);
        Cmd.AddCommand("menu_startserver", Menu_StartServer);
        Cmd.AddCommand("menu_dmoptions", Menu_DMOptions);
        Cmd.AddCommand("menu_playerconfig", Menu_PlayerConfig);
        Cmd.AddCommand("menu_downloadoptions", Menu_DownloadOptions);
        Cmd.AddCommand("menu_credits", Menu_Credits);
        Cmd.AddCommand("menu_multiplayer", Menu_Multiplayer);
        Cmd.AddCommand("menu_video", Menu_Video);
        Cmd.AddCommand("menu_options", Menu_Options);
        Cmd.AddCommand("menu_keys", Menu_Keys);
        Cmd.AddCommand("menu_quit", Menu_Quit);
        for (int i = 0; i < m_layers.length; ++i) {
            Menu.m_layers[i] = new menulayer_t();
        }
    }

    static void Draw() {
        if (Menu.cls.key_dest != 3) {
            return;
        }
        SCR.DirtyScreen();
        if (Menu.cl.cinematictime > 0) {
            re.DrawFill(0, 0, viddef.getWidth(), viddef.getHeight(), 0);
        } else {
            re.DrawFadeScreen();
        }
        m_drawfunc.execute();
        if (m_entersound) {
            S.StartLocalSound(menu_in_sound);
            m_entersound = false;
        }
    }

    static void Keydown(int key) {
        String s;
        if (m_keyfunc != null && (s = m_keyfunc.execute(key)) != null) {
            S.StartLocalSound(s);
        }
    }

    public static void Action_DoEnter(menuaction_s a) {
        if (a.callback != null) {
            a.callback.execute(a);
        }
    }

    public static void Action_Draw(menuaction_s a) {
        if ((a.flags & 1) != 0) {
            if ((a.flags & 2) != 0) {
                Menu.Menu_DrawStringDark(a.x + a.parent.x + -16, a.y + a.parent.y, a.name);
            } else {
                Menu.Menu_DrawString(a.x + a.parent.x + -16, a.y + a.parent.y, a.name);
            }
        } else if ((a.flags & 2) != 0) {
            Menu.Menu_DrawStringR2LDark(a.x + a.parent.x + -16, a.y + a.parent.y, a.name);
        } else {
            Menu.Menu_DrawStringR2L(a.x + a.parent.x + -16, a.y + a.parent.y, a.name);
        }
        if (a.ownerdraw != null) {
            a.ownerdraw.execute(a);
        }
    }

    public static boolean Field_DoEnter(menufield_s f) {
        if (f.callback != null) {
            f.callback.execute(f);
            return true;
        }
        return false;
    }

    public static void Field_Draw(menufield_s f) {
        if (f.name != null) {
            Menu.Menu_DrawStringR2LDark(f.x + f.parent.x + -16, f.y + f.parent.y, f.name);
        }
        String s = f.buffer.toString();
        String tempbuffer = s.substring(f.visible_offset, s.length());
        re.DrawChar(f.x + f.parent.x + 16, f.y + f.parent.y - 4, 18);
        re.DrawChar(f.x + f.parent.x + 16, f.y + f.parent.y + 4, 24);
        re.DrawChar(f.x + f.parent.x + 24 + f.visible_length * 8, f.y + f.parent.y - 4, 20);
        re.DrawChar(f.x + f.parent.x + 24 + f.visible_length * 8, f.y + f.parent.y + 4, 26);
        for (int i = 0; i < f.visible_length; ++i) {
            re.DrawChar(f.x + f.parent.x + 24 + i * 8, f.y + f.parent.y - 4, 19);
            re.DrawChar(f.x + f.parent.x + 24 + i * 8, f.y + f.parent.y + 4, 25);
        }
        Menu.Menu_DrawString(f.x + f.parent.x + 24, f.y + f.parent.y, tempbuffer);
        if (Menu.Menu_ItemAtCursor(f.parent) == f) {
            int offset = f.visible_offset != 0 ? f.visible_length : f.cursor;
            if ((Timer.Milliseconds() / 250 & 1) != 0) {
                re.DrawChar(f.x + f.parent.x + (offset + 2) * 8 + 8, f.y + f.parent.y, 11);
            } else {
                re.DrawChar(f.x + f.parent.x + (offset + 2) * 8 + 8, f.y + f.parent.y, 32);
            }
        }
    }

    public static boolean Field_Key(menufield_s f, int k) {
        char key = (char)k;
        switch (key) {
            case '\u00ac': {
                key = '/';
                break;
            }
            case '\u00ad': {
                key = '-';
                break;
            }
            case '\u00ae': {
                key = '+';
                break;
            }
            case '\u00a0': {
                key = '7';
                break;
            }
            case '\u00a1': {
                key = '8';
                break;
            }
            case '\u00a2': {
                key = '9';
                break;
            }
            case '\u00a3': {
                key = '4';
                break;
            }
            case '\u00a4': {
                key = '5';
                break;
            }
            case '\u00a5': {
                key = '6';
                break;
            }
            case '\u00a6': {
                key = '1';
                break;
            }
            case '\u00a7': {
                key = '2';
                break;
            }
            case '\u00a8': {
                key = '3';
                break;
            }
            case '\u00aa': {
                key = '0';
                break;
            }
            case '\u00ab': {
                key = '.';
            }
        }
        if (key > '\u007f') {
            switch (key) {
                default: 
            }
            return false;
        }
        if (key == '\u0016' && keydown[133] || (key == '\u0093' || key == '\u00aa') && keydown[134]) {
            String[] lines;
            String cbd = Sys.GetClipboardData();
            if (cbd != null && (lines = cbd.split("\r\n")).length > 0 && lines[0].length() != 0) {
                f.buffer = new StringBuffer(lines[0]);
                f.cursor = f.buffer.length();
                f.visible_offset = f.cursor - f.visible_length;
                if (f.visible_offset < 0) {
                    f.visible_offset = 0;
                }
            }
            return true;
        }
        switch (key) {
            case '\u007f': 
            case '\u0082': 
            case '\u00a3': {
                if (f.cursor <= 0) break;
                f.buffer.deleteCharAt(f.cursor - 1);
                --f.cursor;
                if (f.visible_offset == 0) break;
                --f.visible_offset;
                break;
            }
            case '\u0094': 
            case '\u00ab': {
                f.buffer.deleteCharAt(f.cursor);
                break;
            }
            case '\t': 
            case '\r': 
            case '\u001b': 
            case '\u00a9': {
                return false;
            }
            default: {
                if (!Character.isDigit(key) && (f.flags & 4) != 0) {
                    return false;
                }
                if (f.cursor >= f.length) break;
                f.buffer.append(key);
                ++f.cursor;
                if (f.cursor <= f.visible_length) break;
                ++f.visible_offset;
            }
        }
        return true;
    }

    public static void Menu_AddItem(menuframework_s menu, menucommon_s item) {
        if (menu.nitems == 0) {
            menu.nslots = 0;
        }
        if (menu.nitems < 64) {
            menu.items[menu.nitems] = item;
            menu.items[menu.nitems].parent = menu;
            ++menu.nitems;
        }
        menu.nslots = Menu.Menu_TallySlots(menu);
    }

    public static void Menu_AdjustCursor(menuframework_s m, int dir) {
        menucommon_s citem;
        if (m.cursor >= 0 && m.cursor < m.nitems && (citem = Menu.Menu_ItemAtCursor(m)) != null && citem.type != 4) {
            return;
        }
        if (dir == 1) {
            while ((citem = Menu.Menu_ItemAtCursor(m)) == null || citem.type == 4) {
                m.cursor += dir;
                if (m.cursor < m.nitems) continue;
                m.cursor = 0;
            }
        } else {
            while ((citem = Menu.Menu_ItemAtCursor(m)) == null || citem.type == 4) {
                m.cursor += dir;
                if (m.cursor >= 0) continue;
                m.cursor = m.nitems - 1;
            }
        }
    }

    public static void Menu_Center(menuframework_s menu) {
        int height = menu.items[menu.nitems - 1].y;
        menu.y = (viddef.getHeight() - (height += 10)) / 2;
    }

    public static void Menu_Draw(menuframework_s menu) {
        block8: for (int i = 0; i < menu.nitems; ++i) {
            switch (menu.items[i].type) {
                case 5: {
                    Menu.Field_Draw((menufield_s)menu.items[i]);
                    continue block8;
                }
                case 0: {
                    Menu.Slider_Draw((menuslider_s)menu.items[i]);
                    continue block8;
                }
                case 1: {
                    Menu.MenuList_Draw((menulist_s)menu.items[i]);
                    continue block8;
                }
                case 3: {
                    Menu.SpinControl_Draw((menulist_s)menu.items[i]);
                    continue block8;
                }
                case 2: {
                    Menu.Action_Draw((menuaction_s)menu.items[i]);
                    continue block8;
                }
                case 4: {
                    Menu.Separator_Draw((menuseparator_s)menu.items[i]);
                }
            }
        }
        menucommon_s item = Menu.Menu_ItemAtCursor(menu);
        if (item != null && item.cursordraw != null) {
            item.cursordraw.execute(item);
        } else if (menu.cursordraw != null) {
            menu.cursordraw.execute(menu);
        } else if (item != null && item.type != 5) {
            if ((item.flags & 1) != 0) {
                re.DrawChar(menu.x + item.x - 24 + item.cursor_offset, menu.y + item.y, 12 + (Timer.Milliseconds() / 250 & 1));
            } else {
                re.DrawChar(menu.x + item.cursor_offset, menu.y + item.y, 12 + (Timer.Milliseconds() / 250 & 1));
            }
        }
        if (item != null) {
            if (item.statusbarfunc != null) {
                item.statusbarfunc.execute(item);
            } else if (item.statusbar != null) {
                Menu.Menu_DrawStatusBar(item.statusbar);
            } else {
                Menu.Menu_DrawStatusBar(menu.statusbar);
            }
        } else {
            Menu.Menu_DrawStatusBar(menu.statusbar);
        }
    }

    public static void Menu_DrawStatusBar(String string) {
        if (string != null) {
            int l = string.length();
            int maxrow = viddef.getHeight() / 8;
            int maxcol = viddef.getWidth() / 8;
            int col = maxcol / 2 - l / 2;
            re.DrawFill(0, viddef.getHeight() - 8, viddef.getWidth(), 8, 4);
            Menu.Menu_DrawString(col * 8, viddef.getHeight() - 8, string);
        } else {
            re.DrawFill(0, viddef.getHeight() - 8, viddef.getWidth(), 8, 0);
        }
    }

    public static void Menu_DrawString(int x, int y, String string) {
        for (int i = 0; i < string.length(); ++i) {
            re.DrawChar(x + i * 8, y, string.charAt(i));
        }
    }

    public static void Menu_DrawStringDark(int x, int y, String string) {
        for (int i = 0; i < string.length(); ++i) {
            re.DrawChar(x + i * 8, y, string.charAt(i) + 128);
        }
    }

    public static void Menu_DrawStringR2L(int x, int y, String string) {
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            re.DrawChar(x - i * 8, y, string.charAt(l - i - 1));
        }
    }

    public static void Menu_DrawStringR2LDark(int x, int y, String string) {
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            re.DrawChar(x - i * 8, y, string.charAt(l - i - 1) + 128);
        }
    }

    public static menucommon_s Menu_ItemAtCursor(menuframework_s m) {
        if (m.cursor < 0 || m.cursor >= m.nitems) {
            return null;
        }
        return m.items[m.cursor];
    }

    static boolean Menu_SelectItem(menuframework_s s) {
        menucommon_s item = Menu.Menu_ItemAtCursor(s);
        if (item != null) {
            switch (item.type) {
                case 5: {
                    return Menu.Field_DoEnter((menufield_s)item);
                }
                case 2: {
                    Menu.Action_DoEnter((menuaction_s)item);
                    return true;
                }
                case 1: {
                    return false;
                }
                case 3: {
                    return false;
                }
            }
        }
        return false;
    }

    public static void Menu_SetStatusBar(menuframework_s m, String string) {
        m.statusbar = string;
    }

    public static void Menu_SlideItem(menuframework_s s, int dir) {
        menucommon_s item = Menu.Menu_ItemAtCursor(s);
        if (item != null) {
            switch (item.type) {
                case 0: {
                    Menu.Slider_DoSlide((menuslider_s)item, dir);
                    break;
                }
                case 3: {
                    Menu.SpinControl_DoSlide((menulist_s)item, dir);
                }
            }
        }
    }

    public static int Menu_TallySlots(menuframework_s menu) {
        int total = 0;
        for (int i = 0; i < menu.nitems; ++i) {
            if (menu.items[i].type == 1) {
                int nitems = 0;
                String[] n = ((menulist_s)menu.items[i]).itemnames;
                while (n[nitems] != null) {
                    ++nitems;
                }
                total += nitems;
                continue;
            }
            ++total;
        }
        return total;
    }

    public static void Menulist_DoEnter(menulist_s l) {
        int start = l.y / 10 + 1;
        l.curvalue = l.parent.cursor - start;
        if (l.callback != null) {
            l.callback.execute(l);
        }
    }

    public static void MenuList_Draw(menulist_s l) {
        int y = 0;
        Menu.Menu_DrawStringR2LDark(l.x + l.parent.x + -16, l.y + l.parent.y, l.name);
        String[] n = l.itemnames;
        re.DrawFill(l.x - 112 + l.parent.x, l.parent.y + l.y + l.curvalue * 10 + 10, 128, 10, 16);
        int i = 0;
        while (n[i] != null) {
            Menu.Menu_DrawStringR2LDark(l.x + l.parent.x + -16, l.y + l.parent.y + y + 10, n[i]);
            ++i;
            y += 10;
        }
    }

    public static void Separator_Draw(menuseparator_s s) {
        if (s.name != null) {
            Menu.Menu_DrawStringR2LDark(s.x + s.parent.x, s.y + s.parent.y, s.name);
        }
    }

    public static void Slider_DoSlide(menuslider_s s, int dir) {
        s.curvalue += (float)dir;
        if (s.curvalue > s.maxvalue) {
            s.curvalue = s.maxvalue;
        } else if (s.curvalue < s.minvalue) {
            s.curvalue = s.minvalue;
        }
        if (s.callback != null) {
            s.callback.execute(s);
        }
    }

    public static void Slider_Draw(menuslider_s s) {
        int i;
        Menu.Menu_DrawStringR2LDark(s.x + s.parent.x + -16, s.y + s.parent.y, s.name);
        s.range = (s.curvalue - s.minvalue) / (s.maxvalue - s.minvalue);
        if (s.range < 0.0f) {
            s.range = 0.0f;
        }
        if (s.range > 1.0f) {
            s.range = 1.0f;
        }
        re.DrawChar(s.x + s.parent.x + 16, s.y + s.parent.y, 128);
        for (i = 0; i < 10; ++i) {
            re.DrawChar(16 + s.x + i * 8 + s.parent.x + 8, s.y + s.parent.y, 129);
        }
        re.DrawChar(16 + s.x + i * 8 + s.parent.x + 8, s.y + s.parent.y, 130);
        re.DrawChar((int)((float)(24 + s.parent.x + s.x) + 72.0f * s.range), s.y + s.parent.y, 131);
    }

    public static void SpinControl_DoEnter(menulist_s s) {
        ++s.curvalue;
        if (s.itemnames[s.curvalue] == null) {
            s.curvalue = 0;
        }
        if (s.callback != null) {
            s.callback.execute(s);
        }
    }

    public static void SpinControl_DoSlide(menulist_s s, int dir) {
        s.curvalue += dir;
        if (s.curvalue < 0) {
            s.curvalue = 0;
        } else if (s.curvalue >= s.itemnames.length || s.itemnames[s.curvalue] == null) {
            --s.curvalue;
        }
        if (s.callback != null) {
            s.callback.execute(s);
        }
    }

    public static void SpinControl_Draw(menulist_s s) {
        if (s.name != null) {
            Menu.Menu_DrawStringR2LDark(s.x + s.parent.x + -16, s.y + s.parent.y, s.name);
        }
        if (s.itemnames[s.curvalue].indexOf(10) == -1) {
            Menu.Menu_DrawString(16 + s.x + s.parent.x, s.y + s.parent.y, s.itemnames[s.curvalue]);
        } else {
            String line1 = Lib.leftFrom(s.itemnames[s.curvalue], '\n');
            Menu.Menu_DrawString(16 + s.x + s.parent.x, s.y + s.parent.y, line1);
            String line2 = Lib.rightFrom(s.itemnames[s.curvalue], '\n');
            int pos = line2.indexOf(10);
            if (pos != -1) {
                line2 = line2.substring(0, pos);
            }
            Menu.Menu_DrawString(16 + s.x + s.parent.x, s.y + s.parent.y + 10, line2);
        }
    }

    static {
        int n;
        $assertionsDisabled = !Menu.class.desiredAssertionStatus();
        m_layers = new menulayer_t[8];
        Main_Draw = new xcommand_t(){

            public void execute() {
                Menu.Main_Draw();
            }
        };
        Main_Key = new keyfunc_t(){

            public String execute(int key) {
                return Menu.Main_Key(key);
            }
        };
        Menu_Main = new xcommand_t(){

            public void execute() {
                Menu.Menu_Main_f();
            }
        };
        s_multiplayer_menu = new menuframework_s();
        s_join_network_server_action = new menuaction_s();
        s_start_network_server_action = new menuaction_s();
        s_player_setup_action = new menuaction_s();
        Menu_Multiplayer = new xcommand_t(){

            public void execute() {
                Menu.Menu_Multiplayer_f();
            }
        };
        bindnames = new String[][]{{"+attack", "attack"}, {"weapnext", "next weapon"}, {"+forward", "walk forward"}, {"+back", "backpedal"}, {"+left", "turn left"}, {"+right", "turn right"}, {"+speed", "run"}, {"+moveleft", "step left"}, {"+moveright", "step right"}, {"+strafe", "sidestep"}, {"+lookup", "look up"}, {"+lookdown", "look down"}, {"centerview", "center view"}, {"+mlook", "mouse look"}, {"+klook", "keyboard look"}, {"+moveup", "up / jump"}, {"+movedown", "down / crouch"}, {"inven", "inventory"}, {"invuse", "use item"}, {"invdrop", "drop item"}, {"invprev", "prev item"}, {"invnext", "next item"}, {"cmd help", "help computer"}, {null, null}};
        s_keys_menu = new menuframework_s();
        s_keys_attack_action = new menuaction_s();
        s_keys_change_weapon_action = new menuaction_s();
        s_keys_walk_forward_action = new menuaction_s();
        s_keys_backpedal_action = new menuaction_s();
        s_keys_turn_left_action = new menuaction_s();
        s_keys_turn_right_action = new menuaction_s();
        s_keys_run_action = new menuaction_s();
        s_keys_step_left_action = new menuaction_s();
        s_keys_step_right_action = new menuaction_s();
        s_keys_sidestep_action = new menuaction_s();
        s_keys_look_up_action = new menuaction_s();
        s_keys_look_down_action = new menuaction_s();
        s_keys_center_view_action = new menuaction_s();
        s_keys_mouse_look_action = new menuaction_s();
        s_keys_keyboard_look_action = new menuaction_s();
        s_keys_move_up_action = new menuaction_s();
        s_keys_move_down_action = new menuaction_s();
        s_keys_inventory_action = new menuaction_s();
        s_keys_inv_use_action = new menuaction_s();
        s_keys_inv_drop_action = new menuaction_s();
        s_keys_inv_prev_action = new menuaction_s();
        s_keys_inv_next_action = new menuaction_s();
        s_keys_help_computer_action = new menuaction_s();
        Keys_MenuDraw = new xcommand_t(){

            public void execute() {
                Menu.Keys_MenuDraw_f();
            }
        };
        Keys_MenuKey = new keyfunc_t(){

            public String execute(int key) {
                return Menu.Keys_MenuKey_f(key);
            }
        };
        Menu_Keys = new xcommand_t(){

            public void execute() {
                Menu.Menu_Keys_f();
            }
        };
        s_options_menu = new menuframework_s();
        s_options_defaults_action = new menuaction_s();
        s_options_customize_options_action = new menuaction_s();
        s_options_sensitivity_slider = new menuslider_s();
        s_options_freelook_box = new menulist_s();
        s_options_noalttab_box = new menulist_s();
        s_options_alwaysrun_box = new menulist_s();
        s_options_invertmouse_box = new menulist_s();
        s_options_lookspring_box = new menulist_s();
        s_options_lookstrafe_box = new menulist_s();
        s_options_crosshair_box = new menulist_s();
        s_options_sfxvolume_slider = new menuslider_s();
        s_options_joystick_box = new menulist_s();
        s_options_cdvolume_box = new menulist_s();
        s_options_quality_list = new menulist_s();
        s_options_console_action = new menuaction_s();
        cd_music_items = new String[]{"disabled", "enabled"};
        compatibility_items = new String[]{"max compatibility", "max performance"};
        yesno_names = new String[]{"no", "yes"};
        crosshair_names = new String[]{"none", "cross", "dot", "angle"};
        Menu_Options = new xcommand_t(){

            public void execute() {
                Menu.Menu_Options_f();
            }
        };
        Menu_Video = new xcommand_t(){

            public void execute() {
                Menu.Menu_Video_f();
            }
        };
        creditsIndex = new String[256];
        idcredits = new String[]{"+QUAKE II BY ID SOFTWARE", "", "+PROGRAMMING", "John Carmack", "John Cash", "Brian Hook", "", "+JAVA PORT BY BYTONIC", "Carsten Weisse", "Holger Zickner", "Rene Stoeckel", "", "+ART", "Adrian Carmack", "Kevin Cloud", "Paul Steed", "", "+LEVEL DESIGN", "Tim Willits", "American McGee", "Christian Antkow", "Paul Jaquays", "Brandon James", "", "+BIZ", "Todd Hollenshead", "Barrett (Bear) Alexander", "Donna Jackson", "", "", "+SPECIAL THANKS", "Ben Donges for beta testing", "", "", "", "", "", "", "+ADDITIONAL SUPPORT", "", "+LINUX PORT AND CTF", "Dave \"Zoid\" Kirsch", "", "+CINEMATIC SEQUENCES", "Ending Cinematic by Blur Studio - ", "Venice, CA", "", "Environment models for Introduction", "Cinematic by Karl Dolgener", "", "Assistance with environment design", "by Cliff Iwai", "", "+SOUND EFFECTS AND MUSIC", "Sound Design by Soundelux Media Labs.", "Music Composed and Produced by", "Soundelux Media Labs.  Special thanks", "to Bill Brown, Tom Ozanich, Brian", "Celano, Jeff Eisner, and The Soundelux", "Players.", "", "\"Level Music\" by Sonic Mayhem", "www.sonicmayhem.com", "", "\"Quake II Theme Song\"", "(C) 1997 Rob Zombie. All Rights", "Reserved.", "", "Track 10 (\"Climb\") by Jer Sypult", "", "Voice of computers by", "Carly Staehlin-Taylor", "", "+THANKS TO ACTIVISION", "+IN PARTICULAR:", "", "John Tam", "Steve Rosenthal", "Marty Stratton", "Henk Hartong", "", "Quake II(tm) (C)1997 Id Software, Inc.", "All Rights Reserved.  Distributed by", "Activision, Inc. under license.", "Quake II(tm), the Id Software name,", "the \"Q II\"(tm) logo and id(tm)", "logo are trademarks of Id Software,", "Inc. Activision(R) is a registered", "trademark of Activision, Inc. All", "other trademarks and trade names are", "properties of their respective owners.", null};
        credits = idcredits;
        xatcredits = new String[]{"+QUAKE II MISSION PACK: THE RECKONING", "+BY", "+XATRIX ENTERTAINMENT, INC.", "", "+DESIGN AND DIRECTION", "Drew Markham", "", "+PRODUCED BY", "Greg Goodrich", "", "+PROGRAMMING", "Rafael Paiz", "", "+LEVEL DESIGN / ADDITIONAL GAME DESIGN", "Alex Mayberry", "", "+LEVEL DESIGN", "Mal Blackwell", "Dan Koppel", "", "+ART DIRECTION", "Michael \"Maxx\" Kaufman", "", "+COMPUTER GRAPHICS SUPERVISOR AND", "+CHARACTER ANIMATION DIRECTION", "Barry Dempsey", "", "+SENIOR ANIMATOR AND MODELER", "Jason Hoover", "", "+CHARACTER ANIMATION AND", "+MOTION CAPTURE SPECIALIST", "Amit Doron", "", "+ART", "Claire Praderie-Markham", "Viktor Antonov", "Corky Lehmkuhl", "", "+INTRODUCTION ANIMATION", "Dominique Drozdz", "", "+ADDITIONAL LEVEL DESIGN", "Aaron Barber", "Rhett Baldwin", "", "+3D CHARACTER ANIMATION TOOLS", "Gerry Tyra, SA Technology", "", "+ADDITIONAL EDITOR TOOL PROGRAMMING", "Robert Duffy", "", "+ADDITIONAL PROGRAMMING", "Ryan Feltrin", "", "+PRODUCTION COORDINATOR", "Victoria Sylvester", "", "+SOUND DESIGN", "Gary Bradfield", "", "+MUSIC BY", "Sonic Mayhem", "", "", "", "+SPECIAL THANKS", "+TO", "+OUR FRIENDS AT ID SOFTWARE", "", "John Carmack", "John Cash", "Brian Hook", "Adrian Carmack", "Kevin Cloud", "Paul Steed", "Tim Willits", "Christian Antkow", "Paul Jaquays", "Brandon James", "Todd Hollenshead", "Barrett (Bear) Alexander", "Dave \"Zoid\" Kirsch", "Donna Jackson", "", "", "", "+THANKS TO ACTIVISION", "+IN PARTICULAR:", "", "Marty Stratton", "Henk \"The Original Ripper\" Hartong", "Kevin Kraff", "Jamey Gottlieb", "Chris Hepburn", "", "+AND THE GAME TESTERS", "", "Tim Vanlaw", "Doug Jacobs", "Steven Rosenthal", "David Baker", "Chris Campbell", "Aaron Casillas", "Steve Elwell", "Derek Johnstone", "Igor Krinitskiy", "Samantha Lee", "Michael Spann", "Chris Toft", "Juan Valdes", "", "+THANKS TO INTERGRAPH COMPUTER SYTEMS", "+IN PARTICULAR:", "", "Michael T. Nicolaou", "", "", "Quake II Mission Pack: The Reckoning", "(tm) (C)1998 Id Software, Inc. All", "Rights Reserved. Developed by Xatrix", "Entertainment, Inc. for Id Software,", "Inc. Distributed by Activision Inc.", "under license. Quake(R) is a", "registered trademark of Id Software,", "Inc. Quake II Mission Pack: The", "Reckoning(tm), Quake II(tm), the Id", "Software name, the \"Q II\"(tm) logo", "and id(tm) logo are trademarks of Id", "Software, Inc. Activision(R) is a", "registered trademark of Activision,", "Inc. Xatrix(R) is a registered", "trademark of Xatrix Entertainment,", "Inc. All other trademarks and trade", "names are properties of their", "respective owners.", null};
        roguecredits = new String[]{"+QUAKE II MISSION PACK 2: GROUND ZERO", "+BY", "+ROGUE ENTERTAINMENT, INC.", "", "+PRODUCED BY", "Jim Molinets", "", "+PROGRAMMING", "Peter Mack", "Patrick Magruder", "", "+LEVEL DESIGN", "Jim Molinets", "Cameron Lamprecht", "Berenger Fish", "Robert Selitto", "Steve Tietze", "Steve Thoms", "", "+ART DIRECTION", "Rich Fleider", "", "+ART", "Rich Fleider", "Steve Maines", "Won Choi", "", "+ANIMATION SEQUENCES", "Creat Studios", "Steve Maines", "", "+ADDITIONAL LEVEL DESIGN", "Rich Fleider", "Steve Maines", "Peter Mack", "", "+SOUND", "James Grunke", "", "+GROUND ZERO THEME", "+AND", "+MUSIC BY", "Sonic Mayhem", "", "+VWEP MODELS", "Brent \"Hentai\" Dill", "", "", "", "+SPECIAL THANKS", "+TO", "+OUR FRIENDS AT ID SOFTWARE", "", "John Carmack", "John Cash", "Brian Hook", "Adrian Carmack", "Kevin Cloud", "Paul Steed", "Tim Willits", "Christian Antkow", "Paul Jaquays", "Brandon James", "Todd Hollenshead", "Barrett (Bear) Alexander", "Katherine Anna Kang", "Donna Jackson", "Dave \"Zoid\" Kirsch", "", "", "", "+THANKS TO ACTIVISION", "+IN PARTICULAR:", "", "Marty Stratton", "Henk Hartong", "Mitch Lasky", "Steve Rosenthal", "Steve Elwell", "", "+AND THE GAME TESTERS", "", "The Ranger Clan", "Dave \"Zoid\" Kirsch", "Nihilistic Software", "Robert Duffy", "", "And Countless Others", "", "", "", "Quake II Mission Pack 2: Ground Zero", "(tm) (C)1998 Id Software, Inc. All", "Rights Reserved. Developed by Rogue", "Entertainment, Inc. for Id Software,", "Inc. Distributed by Activision Inc.", "under license. Quake(R) is a", "registered trademark of Id Software,", "Inc. Quake II Mission Pack 2: Ground", "Zero(tm), Quake II(tm), the Id", "Software name, the \"Q II\"(tm) logo", "and id(tm) logo are trademarks of Id", "Software, Inc. Activision(R) is a", "registered trademark of Activision,", "Inc. Rogue(R) is a registered", "trademark of Rogue Entertainment,", "Inc. All other trademarks and trade", "names are properties of their", "respective owners.", null};
        Menu_Credits = new xcommand_t(){

            public void execute() {
                Menu.Menu_Credits_f();
            }
        };
        s_game_menu = new menuframework_s();
        s_easy_game_action = new menuaction_s();
        s_medium_game_action = new menuaction_s();
        s_hard_game_action = new menuaction_s();
        s_load_game_action = new menuaction_s();
        s_save_game_action = new menuaction_s();
        s_credits_action = new menuaction_s();
        s_blankline = new menuseparator_s();
        difficulty_names = new String[]{"easy", "medium", "fuckin shitty hard"};
        Menu_Game = new xcommand_t(){

            public void execute() {
                Menu.Menu_Game_f();
            }
        };
        s_savegame_menu = new menuframework_s();
        s_loadgame_menu = new menuframework_s();
        s_loadgame_actions = new menuaction_s[15];
        for (n = 0; n < 15; ++n) {
            Menu.s_loadgame_actions[n] = new menuaction_s();
        }
        m_savestrings = new String[15];
        for (n = 0; n < 15; ++n) {
            Menu.m_savestrings[n] = "";
        }
        m_savevalid = new boolean[15];
        Menu_LoadGame = new xcommand_t(){

            public void execute() {
                Menu.Menu_LoadGame_f();
            }
        };
        s_savegame_actions = new menuaction_s[15];
        for (n = 0; n < 15; ++n) {
            Menu.s_savegame_actions[n] = new menuaction_s();
        }
        Menu_SaveGame = new xcommand_t(){

            public void execute() {
                Menu.Menu_SaveGame_f();
            }
        };
        s_joinserver_menu = new menuframework_s();
        s_joinserver_server_title = new menuseparator_s();
        s_joinserver_search_action = new menuaction_s();
        s_joinserver_address_book_action = new menuaction_s();
        local_server_netadr = new netadr_t[8];
        local_server_names = new String[8];
        s_joinserver_server_actions = new menuaction_s[8];
        for (n = 0; n < 8; ++n) {
            Menu.local_server_netadr[n] = new netadr_t();
            Menu.local_server_names[n] = "";
            Menu.s_joinserver_server_actions[n] = new menuaction_s();
            Menu.s_joinserver_server_actions[n].n = n;
        }
        Menu_JoinServer = new xcommand_t(){

            public void execute() {
                Menu.Menu_JoinServer_f();
            }
        };
        s_startserver_menu = new menuframework_s();
        s_startserver_start_action = new menuaction_s();
        s_startserver_dmoptions_action = new menuaction_s();
        s_timelimit_field = new menufield_s();
        s_fraglimit_field = new menufield_s();
        s_maxclients_field = new menufield_s();
        s_hostname_field = new menufield_s();
        s_startmap_list = new menulist_s();
        s_rules_box = new menulist_s();
        dm_coop_names = new String[]{"deathmatch", "cooperative"};
        dm_coop_names_rogue = new String[]{"deathmatch", "cooperative", "tag"};
        Menu_StartServer = new xcommand_t(){

            public void execute() {
                Menu.Menu_StartServer_f();
            }
        };
        startServer_MenuDraw = new xcommand_t(){

            public void execute() {
                Menu.StartServer_MenuDraw();
            }
        };
        startServer_MenuKey = new keyfunc_t(){

            public String execute(int key) {
                return Menu.StartServer_MenuKey(key);
            }
        };
        s_dmoptions_menu = new menuframework_s();
        s_friendlyfire_box = new menulist_s();
        s_falls_box = new menulist_s();
        s_weapons_stay_box = new menulist_s();
        s_instant_powerups_box = new menulist_s();
        s_powerups_box = new menulist_s();
        s_health_box = new menulist_s();
        s_spawn_farthest_box = new menulist_s();
        s_teamplay_box = new menulist_s();
        s_samelevel_box = new menulist_s();
        s_force_respawn_box = new menulist_s();
        s_armor_box = new menulist_s();
        s_allow_exit_box = new menulist_s();
        s_infinite_ammo_box = new menulist_s();
        s_fixed_fov_box = new menulist_s();
        s_quad_drop_box = new menulist_s();
        s_no_mines_box = new menulist_s();
        s_no_nukes_box = new menulist_s();
        s_stack_double_box = new menulist_s();
        s_no_spheres_box = new menulist_s();
        teamplay_names = new String[]{"disabled", "by skin", "by model"};
        Menu_DMOptions = new xcommand_t(){

            public void execute() {
                Menu.Menu_DMOptions_f();
            }
        };
        s_downloadoptions_menu = new menuframework_s();
        s_download_title = new menuseparator_s();
        s_allow_download_box = new menulist_s();
        s_allow_download_maps_box = new menulist_s();
        s_allow_download_models_box = new menulist_s();
        s_allow_download_players_box = new menulist_s();
        s_allow_download_sounds_box = new menulist_s();
        yes_no_names = new String[]{"no", "yes"};
        Menu_DownloadOptions = new xcommand_t(){

            public void execute() {
                Menu.Menu_DownloadOptions_f();
            }
        };
        s_addressbook_menu = new menuframework_s();
        s_addressbook_fields = new menufield_s[9];
        for (n = 0; n < 9; ++n) {
            Menu.s_addressbook_fields[n] = new menufield_s();
        }
        AddressBook_MenuKey = new keyfunc_t(){

            public String execute(int key) {
                return Menu.AddressBook_MenuKey_f(key);
            }
        };
        AddressBook_MenuDraw = new xcommand_t(){

            public void execute() {
                Menu.AddressBook_MenuDraw_f();
            }
        };
        Menu_AddressBook = new xcommand_t(){

            public void execute() {
                Menu.Menu_AddressBook_f();
            }
        };
        s_player_config_menu = new menuframework_s();
        s_player_name_field = new menufield_s();
        s_player_model_box = new menulist_s();
        s_player_skin_box = new menulist_s();
        s_player_handedness_box = new menulist_s();
        s_player_rate_box = new menulist_s();
        s_player_skin_title = new menuseparator_s();
        s_player_model_title = new menuseparator_s();
        s_player_hand_title = new menuseparator_s();
        s_player_rate_title = new menuseparator_s();
        s_player_download_action = new menuaction_s();
        s_pmi = new playermodelinfo_s[1024];
        s_pmnames = new String[1024];
        rate_tbl = new int[]{2500, 3200, 5000, 10000, 25000, 0};
        rate_names = new String[]{"28.8 Modem", "33.6 Modem", "Single ISDN", "Dual ISDN/Cable", "T1/LAN", "User defined"};
        handedness = new String[]{"right", "left", "center"};
        entity = new entity_t();
        Menu_PlayerConfig = new xcommand_t(){

            public void execute() {
                Menu.Menu_PlayerConfig_f();
            }
        };
        Menu_Quit = new xcommand_t(){

            public void execute() {
                Menu.Menu_Quit_f();
            }
        };
    }

    static class playermodelinfo_s {
        int nskins;
        String[] skindisplaynames;
        String displayname;
        String directory;

        playermodelinfo_s() {
        }
    }

    static class menuseparator_s
    extends menucommon_s {
        menuseparator_s() {
        }
    }

    static class menuaction_s
    extends menucommon_s {
        menuaction_s() {
        }
    }

    static class menulist_s
    extends menucommon_s {
        int curvalue;
        String[] itemnames;

        menulist_s() {
        }
    }

    static class menuslider_s
    extends menucommon_s {
        float minvalue;
        float maxvalue;
        float curvalue;
        float range;

        menuslider_s() {
        }
    }

    static class menufield_s
    extends menucommon_s {
        StringBuffer buffer;
        int cursor;
        int length;
        int visible_length;
        int visible_offset;

        menufield_s() {
        }
    }

    static class menucommon_s {
        int type;
        String name = "";
        int x;
        int y;
        menuframework_s parent;
        int cursor_offset;
        int[] localdata = new int[]{0, 0, 0, 0};
        int flags;
        int n = -1;
        String statusbar;
        mcallback callback;
        mcallback statusbarfunc;
        mcallback ownerdraw;
        mcallback cursordraw;

        menucommon_s() {
        }
    }

    static abstract class mcallback {
        mcallback() {
        }

        public abstract void execute(Object var1);
    }

    static class menuframework_s {
        int x;
        int y;
        int cursor;
        int nitems;
        int nslots;
        menucommon_s[] items = new menucommon_s[64];
        String statusbar;
        mcallback cursordraw;

        menuframework_s() {
        }
    }

    public static class menulayer_t {
        xcommand_t draw;
        keyfunc_t key;
    }
}

