/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.game.EntThinkAdapter;
import jake2.game.GameBase;
import jake2.game.GameCombat;
import jake2.game.edict_t;
import jake2.game.mmove_t;
import jake2.game.trace_t;
import jake2.server.SV;
import jake2.util.Lib;
import jake2.util.Math3D;

public final class M {
    public static EntThinkAdapter M_droptofloor = new EntThinkAdapter(){

        public String getID() {
            return "m_drop_to_floor";
        }

        public boolean think(edict_t ent) {
            float[] end = new float[]{0.0f, 0.0f, 0.0f};
            ent.s.origin[2] = ent.s.origin[2] + 1.0f;
            Math3D.VectorCopy(ent.s.origin, end);
            end[2] = end[2] - 256.0f;
            trace_t trace = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, end, ent, 0x2020003);
            if (trace.fraction == 1.0f || trace.allsolid) {
                return true;
            }
            Math3D.VectorCopy(trace.endpos, ent.s.origin);
            GameBase.gi.linkentity(ent);
            M.M_CheckGround(ent);
            M.M_CatagorizePosition(ent);
            return true;
        }
    };
    public static EntThinkAdapter M_FliesOff = new EntThinkAdapter(){

        public String getID() {
            return "m_fliesoff";
        }

        public boolean think(edict_t self) {
            self.s.effects &= 0xFFFFBFFF;
            self.s.sound = 0;
            return true;
        }
    };
    public static EntThinkAdapter M_FliesOn = new EntThinkAdapter(){

        public String getID() {
            return "m_flies_on";
        }

        public boolean think(edict_t self) {
            if (self.waterlevel != 0) {
                return true;
            }
            self.s.effects |= 0x4000;
            self.s.sound = GameBase.gi.soundindex("infantry/inflies1.wav");
            self.think = M_FliesOff;
            self.nextthink = GameBase.level.time + 60.0f;
            return true;
        }
    };
    public static EntThinkAdapter M_FlyCheck = new EntThinkAdapter(){

        public String getID() {
            return "m_fly_check";
        }

        public boolean think(edict_t self) {
            if (self.waterlevel != 0) {
                return true;
            }
            if ((double)Globals.rnd.nextFloat() > 0.5) {
                return true;
            }
            self.think = M_FliesOn;
            self.nextthink = GameBase.level.time + 5.0f + 10.0f * Globals.rnd.nextFloat();
            return true;
        }
    };

    public static void M_CheckGround(edict_t ent) {
        float[] point = new float[]{0.0f, 0.0f, 0.0f};
        if ((ent.flags & 3) != 0) {
            return;
        }
        if (ent.velocity[2] > 100.0f) {
            ent.groundentity = null;
            return;
        }
        point[0] = ent.s.origin[0];
        point[1] = ent.s.origin[1];
        point[2] = ent.s.origin[2] - 0.25f;
        trace_t trace = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, point, ent, 0x2020003);
        if ((double)trace.plane.normal[2] < 0.7 && !trace.startsolid) {
            ent.groundentity = null;
            return;
        }
        if (!trace.startsolid && !trace.allsolid) {
            Math3D.VectorCopy(trace.endpos, ent.s.origin);
            ent.groundentity = trace.ent;
            ent.groundentity_linkcount = trace.ent.linkcount;
            ent.velocity[2] = 0.0f;
        }
    }

    public static boolean M_CheckBottom(edict_t ent) {
        float[] mins = new float[]{0.0f, 0.0f, 0.0f};
        float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
        float[] start = new float[]{0.0f, 0.0f, 0.0f};
        float[] stop = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorAdd(ent.s.origin, ent.mins, mins);
        Math3D.VectorAdd(ent.s.origin, ent.maxs, maxs);
        start[2] = mins[2] - 1.0f;
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                float bottom;
                start[0] = x != 0 ? maxs[0] : mins[0];
                float f = start[1] = y != 0 ? maxs[1] : mins[1];
                if (GameBase.gi.pointcontents.pointcontents(start) == 1) continue;
                ++GameBase.c_no;
                start[2] = mins[2];
                start[0] = stop[0] = (mins[0] + maxs[0]) * 0.5f;
                start[1] = stop[1] = (mins[1] + maxs[1]) * 0.5f;
                stop[2] = start[2] - (float)(2 * GameBase.STEPSIZE);
                trace_t trace = GameBase.gi.trace(start, Globals.vec3_origin, Globals.vec3_origin, stop, ent, 0x2020003);
                if ((double)trace.fraction == 1.0) {
                    return false;
                }
                float mid = bottom = trace.endpos[2];
                for (x = 0; x <= 1; ++x) {
                    for (y = 0; y <= 1; ++y) {
                        stop[0] = x != 0 ? maxs[0] : mins[0];
                        start[0] = stop[0];
                        stop[1] = y != 0 ? maxs[1] : mins[1];
                        start[1] = stop[1];
                        trace = GameBase.gi.trace(start, Globals.vec3_origin, Globals.vec3_origin, stop, ent, 0x2020003);
                        if ((double)trace.fraction != 1.0 && trace.endpos[2] > bottom) {
                            bottom = trace.endpos[2];
                        }
                        if ((double)trace.fraction != 1.0 && !(mid - trace.endpos[2] > (float)GameBase.STEPSIZE)) continue;
                        return false;
                    }
                }
                ++GameBase.c_yes;
                return true;
            }
        }
        ++GameBase.c_yes;
        return true;
    }

    public static void M_ChangeYaw(edict_t ent) {
        float ideal;
        float current = Math3D.anglemod(ent.s.angles[1]);
        if (current == (ideal = ent.ideal_yaw)) {
            return;
        }
        float move = ideal - current;
        float speed = ent.yaw_speed;
        if (ideal > current) {
            if (move >= 180.0f) {
                move -= 360.0f;
            }
        } else if (move <= -180.0f) {
            move += 360.0f;
        }
        if (move > 0.0f) {
            if (move > speed) {
                move = speed;
            }
        } else if (move < -speed) {
            move = -speed;
        }
        ent.s.angles[1] = Math3D.anglemod(current + move);
    }

    public static void M_MoveToGoal(edict_t ent, float dist) {
        edict_t goal = ent.goalentity;
        if (ent.groundentity == null && (ent.flags & 3) == 0) {
            return;
        }
        if (ent.enemy != null && SV.SV_CloseEnough(ent, ent.enemy, dist)) {
            return;
        }
        if (((Lib.rand() & 3) == 1 || !SV.SV_StepDirection(ent, ent.ideal_yaw, dist)) && ent.inuse) {
            SV.SV_NewChaseDir(ent, goal, dist);
        }
    }

    public static boolean M_walkmove(edict_t ent, float yaw, float dist) {
        float[] move = new float[]{0.0f, 0.0f, 0.0f};
        if (ent.groundentity == null && (ent.flags & 3) == 0) {
            return false;
        }
        yaw = (float)((double)yaw * Math.PI * 2.0 / 360.0);
        move[0] = (float)Math.cos(yaw) * dist;
        move[1] = (float)Math.sin(yaw) * dist;
        move[2] = 0.0f;
        return SV.SV_movestep(ent, move, true);
    }

    public static void M_CatagorizePosition(edict_t ent) {
        float[] point = new float[]{0.0f, 0.0f, 0.0f};
        point[0] = ent.s.origin[0];
        point[1] = ent.s.origin[1];
        point[2] = ent.s.origin[2] + ent.mins[2] + 1.0f;
        int cont = GameBase.gi.pointcontents.pointcontents(point);
        if (0 == (cont & 0x38)) {
            ent.waterlevel = 0;
            ent.watertype = 0;
            return;
        }
        ent.watertype = cont;
        ent.waterlevel = 1;
        point[2] = point[2] + 26.0f;
        cont = GameBase.gi.pointcontents.pointcontents(point);
        if (0 == (cont & 0x38)) {
            return;
        }
        ent.waterlevel = 2;
        point[2] = point[2] + 22.0f;
        cont = GameBase.gi.pointcontents.pointcontents(point);
        if (0 != (cont & 0x38)) {
            ent.waterlevel = 3;
        }
    }

    public static void M_WorldEffects(edict_t ent) {
        if (ent.health > 0) {
            if (0 == (ent.flags & 2)) {
                if (ent.waterlevel < 3) {
                    ent.air_finished = GameBase.level.time + 12.0f;
                } else if (ent.air_finished < GameBase.level.time && ent.pain_debounce_time < GameBase.level.time) {
                    int dmg = (int)(2.0 + 2.0 * Math.floor(GameBase.level.time - ent.air_finished));
                    if (dmg > 15) {
                        dmg = 15;
                    }
                    GameCombat.T_Damage(ent, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, ent.s.origin, Globals.vec3_origin, dmg, 0, 2, 17);
                    ent.pain_debounce_time = GameBase.level.time + 1.0f;
                }
            } else if (ent.waterlevel > 0) {
                ent.air_finished = GameBase.level.time + 9.0f;
            } else if (ent.air_finished < GameBase.level.time && ent.pain_debounce_time < GameBase.level.time) {
                int dmg = (int)(2.0 + 2.0 * Math.floor(GameBase.level.time - ent.air_finished));
                if (dmg > 15) {
                    dmg = 15;
                }
                GameCombat.T_Damage(ent, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, ent.s.origin, Globals.vec3_origin, dmg, 0, 2, 17);
                ent.pain_debounce_time = GameBase.level.time + 1.0f;
            }
        }
        if (ent.waterlevel == 0) {
            if ((ent.flags & 8) != 0) {
                GameBase.gi.sound(ent, 4, GameBase.gi.soundindex("player/watr_out.wav"), 1.0f, 1.0f, 0.0f);
                ent.flags &= 0xFFFFFFF7;
            }
            return;
        }
        if ((ent.watertype & 8) != 0 && 0 == (ent.flags & 0x80) && ent.damage_debounce_time < GameBase.level.time) {
            ent.damage_debounce_time = GameBase.level.time + 0.2f;
            GameCombat.T_Damage(ent, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, ent.s.origin, Globals.vec3_origin, 10 * ent.waterlevel, 0, 0, 19);
        }
        if ((ent.watertype & 0x10) != 0 && 0 == (ent.flags & 0x40) && ent.damage_debounce_time < GameBase.level.time) {
            ent.damage_debounce_time = GameBase.level.time + 1.0f;
            GameCombat.T_Damage(ent, GameBase.g_edicts[0], GameBase.g_edicts[0], Globals.vec3_origin, ent.s.origin, Globals.vec3_origin, 4 * ent.waterlevel, 0, 0, 18);
        }
        if (0 == (ent.flags & 8)) {
            if (0 == (ent.svflags & 2)) {
                if ((ent.watertype & 8) != 0) {
                    if ((double)Globals.rnd.nextFloat() <= 0.5) {
                        GameBase.gi.sound(ent, 4, GameBase.gi.soundindex("player/lava1.wav"), 1.0f, 1.0f, 0.0f);
                    } else {
                        GameBase.gi.sound(ent, 4, GameBase.gi.soundindex("player/lava2.wav"), 1.0f, 1.0f, 0.0f);
                    }
                } else if ((ent.watertype & 0x10) != 0) {
                    GameBase.gi.sound(ent, 4, GameBase.gi.soundindex("player/watr_in.wav"), 1.0f, 1.0f, 0.0f);
                } else if ((ent.watertype & 0x20) != 0) {
                    GameBase.gi.sound(ent, 4, GameBase.gi.soundindex("player/watr_in.wav"), 1.0f, 1.0f, 0.0f);
                }
            }
            ent.flags |= 8;
            ent.damage_debounce_time = 0.0f;
        }
    }

    public static void M_SetEffects(edict_t ent) {
        ent.s.effects &= 0xFFFFFCFF;
        ent.s.renderfx &= 0xFFFFE3FF;
        if ((ent.monsterinfo.aiflags & 0x4000) != 0) {
            ent.s.effects |= 0x100;
            ent.s.renderfx |= 0x400;
        }
        if (ent.health <= 0) {
            return;
        }
        if (ent.powerarmor_time > GameBase.level.time) {
            if (ent.monsterinfo.power_armor_type == 1) {
                ent.s.effects |= 0x200;
            } else if (ent.monsterinfo.power_armor_type == 2) {
                ent.s.effects |= 0x100;
                ent.s.renderfx |= 0x800;
            }
        }
    }

    public static void M_MoveFrame(edict_t self) {
        mmove_t move = self.monsterinfo.currentmove;
        self.nextthink = GameBase.level.time + 0.1f;
        if (self.monsterinfo.nextframe != 0 && self.monsterinfo.nextframe >= move.firstframe && self.monsterinfo.nextframe <= move.lastframe) {
            self.s.frame = self.monsterinfo.nextframe;
            self.monsterinfo.nextframe = 0;
        } else {
            if (self.s.frame == move.lastframe && move.endfunc != null) {
                move.endfunc.think(self);
                move = self.monsterinfo.currentmove;
                if ((self.svflags & 2) != 0) {
                    return;
                }
            }
            if (self.s.frame < move.firstframe || self.s.frame > move.lastframe) {
                self.monsterinfo.aiflags &= 0xFFFFFF7F;
                self.s.frame = move.firstframe;
            } else if (0 == (self.monsterinfo.aiflags & 0x80)) {
                ++self.s.frame;
                if (self.s.frame > move.lastframe) {
                    self.s.frame = move.firstframe;
                }
            }
        }
        int index = self.s.frame - move.firstframe;
        if (move.frame[index].ai != null) {
            if (0 == (self.monsterinfo.aiflags & 0x80)) {
                move.frame[index].ai.ai(self, move.frame[index].dist * self.monsterinfo.scale);
            } else {
                move.frame[index].ai.ai(self, 0.0f);
            }
        }
        if (move.frame[index].think != null) {
            move.frame[index].think.think(self);
        }
    }
}

