/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.qcommon.Com;

final class LayoutParser {
    int tokenPos;
    int tokenLength;
    int index;
    int length;
    String data;

    LayoutParser() {
        this.init(null);
    }

    public void init(String layout) {
        this.tokenPos = 0;
        this.tokenLength = 0;
        this.index = 0;
        this.data = layout != null ? layout : "";
        this.length = layout != null ? layout.length() : 0;
    }

    public boolean hasNext() {
        return !this.isEof();
    }

    public void next() {
        block8: {
            if (this.data == null) {
                this.tokenLength = 0;
                return;
            }
            while (true) {
                this.skipwhites();
                if (this.isEof()) {
                    this.tokenLength = 0;
                    return;
                }
                if (this.getchar() != '/') break block8;
                if (this.nextchar() != '/') break;
                this.skiptoeol();
            }
            this.prevchar();
        }
        int len = 0;
        if (this.getchar() == '\"') {
            this.nextchar();
            this.tokenPos = this.index;
            while (true) {
                char c = this.getchar();
                this.nextchar();
                if (c == '\"' || c == '\u0000') {
                    this.tokenLength = len;
                    return;
                }
                if (len >= 1024) continue;
                ++len;
            }
        }
        char c = this.getchar();
        this.tokenPos = this.index;
        do {
            if (len >= 1024) continue;
            ++len;
        } while ((c = this.nextchar()) > ' ');
        if (len == 1024) {
            Com.Printf("Token exceeded 1024 chars, discarded.\n");
            len = 0;
        }
        this.tokenLength = len;
    }

    public boolean tokenEquals(String other) {
        if (this.tokenLength != other.length()) {
            return false;
        }
        return this.data.regionMatches(this.tokenPos, other, 0, this.tokenLength);
    }

    public int tokenAsInt() {
        if (this.tokenLength == 0) {
            return 0;
        }
        return this.atoi();
    }

    public String token() {
        if (this.tokenLength == 0) {
            return "";
        }
        return this.data.substring(this.tokenPos, this.tokenPos + this.tokenLength);
    }

    private int atoi() {
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = this.tokenLength;
        String s = this.data;
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(this.tokenPos) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(this.tokenPos + i++), 10)) < 0) {
                    return 0;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(this.tokenPos + i++), 10)) < 0) {
                    return 0;
                }
                if (result < multmin) {
                    return 0;
                }
                if ((result *= 10) < limit + digit) {
                    return 0;
                }
                result -= digit;
            }
        } else {
            return 0;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            return 0;
        }
        return -result;
    }

    private char getchar() {
        if (this.index < this.length) {
            return this.data.charAt(this.index);
        }
        return '\u0000';
    }

    private char nextchar() {
        ++this.index;
        if (this.index < this.length) {
            return this.data.charAt(this.index);
        }
        return '\u0000';
    }

    private char prevchar() {
        if (this.index > 0) {
            --this.index;
            return this.data.charAt(this.index);
        }
        return '\u0000';
    }

    private boolean isEof() {
        return this.index >= this.length;
    }

    private char skipwhites() {
        char c = '\u0000';
        while (this.index < this.length && (c = this.data.charAt(this.index)) <= ' ' && c != '\u0000') {
            ++this.index;
        }
        return c;
    }

    private char skiptoeol() {
        char c = '\u0000';
        while (this.index < this.length && (c = this.data.charAt(this.index)) != '\n' && c != '\u0000') {
            ++this.index;
        }
        return c;
    }
}

