/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.Key;
import jake2.client.Menu;
import jake2.client.SCR;
import jake2.game.Cmd;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.xcommand_t;
import jake2.util.Lib;
import jake2.util.Vargs;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public final class Console
extends Globals {
    public static xcommand_t ToggleConsole_f = new xcommand_t(){

        public void execute() {
            SCR.EndLoadingPlaque();
            if (Globals.cl.attractloop) {
                Cbuf.AddText("killserver\n");
                return;
            }
            if (Globals.cls.state == 1) {
                Cbuf.AddText("d1\n");
                return;
            }
            Key.ClearTyping();
            Console.ClearNotify();
            if (Globals.cls.key_dest == 1) {
                Menu.ForceMenuOff();
                Cvar.Set("paused", "0");
            } else {
                Menu.ForceMenuOff();
                Globals.cls.key_dest = 1;
                if (Cvar.VariableValue("maxclients") == 1.0f && Globals.server_state != 0) {
                    Cvar.Set("paused", "1");
                }
            }
        }
    };
    public static xcommand_t Clear_f = new xcommand_t(){

        public void execute() {
            Arrays.fill(Globals.con.text, (byte)32);
        }
    };
    public static xcommand_t Dump_f = new xcommand_t(){

        public void execute() {
            int x;
            int line;
            int l;
            byte[] buffer = new byte[1024];
            if (Cmd.Argc() != 2) {
                Com.Printf("usage: condump <filename>\n");
                return;
            }
            String name = FS.Gamedir() + "/" + Cmd.Argv(1) + ".txt";
            Com.Printf("Dumped console text to " + name + ".\n");
            FS.CreatePath(name);
            RandomAccessFile f = Lib.fopen(name, "rw");
            if (f == null) {
                Com.Printf("ERROR: couldn't open.\n");
                return;
            }
            for (l = Globals.con.current - Globals.con.totallines + 1; l <= Globals.con.current; ++l) {
                line = l % Globals.con.totallines * Globals.con.linewidth;
                for (x = 0; x < Globals.con.linewidth && Globals.con.text[line + x] == 32; ++x) {
                }
                if (x != Globals.con.linewidth) break;
            }
            buffer[Globals.con.linewidth] = 0;
            while (l <= Globals.con.current) {
                line = l % Globals.con.totallines * Globals.con.linewidth;
                System.arraycopy(Globals.con.text, line, buffer, 0, Globals.con.linewidth);
                for (x = Globals.con.linewidth - 1; x >= 0 && buffer[x] == 32; --x) {
                    buffer[x] = 0;
                }
                x = 0;
                while (buffer[x] != 0) {
                    int n = x++;
                    buffer[n] = (byte)(buffer[n] & 0x7F);
                }
                buffer[x] = 10;
                try {
                    f.write(buffer, 0, x + 1);
                }
                catch (IOException e) {
                    // empty catch block
                }
                ++l;
            }
            Lib.fclose(f);
        }
    };
    static xcommand_t ToggleChat_f = new xcommand_t(){

        public void execute() {
            Key.ClearTyping();
            if (Globals.cls.key_dest == 1) {
                if (Globals.cls.state == 4) {
                    Menu.ForceMenuOff();
                    Globals.cls.key_dest = 0;
                }
            } else {
                Globals.cls.key_dest = 1;
            }
            Console.ClearNotify();
        }
    };
    static xcommand_t MessageMode_f = new xcommand_t(){

        public void execute() {
            Globals.chat_team = false;
            Globals.cls.key_dest = 2;
        }
    };
    static xcommand_t MessageMode2_f = new xcommand_t(){

        public void execute() {
            Globals.chat_team = true;
            Globals.cls.key_dest = 2;
        }
    };
    private static int cr;

    public static void Init() {
        Globals.con.linewidth = -1;
        Globals.con.backedit = 0;
        Console.CheckResize();
        Com.Printf("Console initialized.\n");
        Globals.con_notifytime = Cvar.Get("con_notifytime", "3", 0);
        Cmd.AddCommand("toggleconsole", ToggleConsole_f);
        Cmd.AddCommand("togglechat", ToggleChat_f);
        Cmd.AddCommand("messagemode", MessageMode_f);
        Cmd.AddCommand("messagemode2", MessageMode2_f);
        Cmd.AddCommand("clear", Clear_f);
        Cmd.AddCommand("condump", Dump_f);
        Globals.con.initialized = true;
    }

    public static void CheckResize() {
        int width = (Globals.viddef.getWidth() >> 3) - 2;
        if (width > 256) {
            width = 256;
        }
        if (width == Globals.con.linewidth) {
            return;
        }
        if (width < 1) {
            Globals.con.linewidth = width = 38;
            Globals.con.backedit = 0;
            Globals.con.totallines = 32768 / Globals.con.linewidth;
            Arrays.fill(Globals.con.text, (byte)32);
        } else {
            int numchars;
            int oldwidth = Globals.con.linewidth;
            Globals.con.linewidth = width;
            Globals.con.backedit = 0;
            int oldtotallines = Globals.con.totallines;
            Globals.con.totallines = 32768 / Globals.con.linewidth;
            int numlines = oldtotallines;
            if (Globals.con.totallines < numlines) {
                numlines = Globals.con.totallines;
            }
            if (Globals.con.linewidth < (numchars = oldwidth)) {
                numchars = Globals.con.linewidth;
            }
            byte[] tbuf = new byte[32768];
            System.arraycopy(Globals.con.text, 0, tbuf, 0, 32768);
            Arrays.fill(Globals.con.text, (byte)32);
            for (int i = 0; i < numlines; ++i) {
                for (int j = 0; j < numchars; ++j) {
                    Globals.con.text[(Globals.con.totallines - 1 - i) * Globals.con.linewidth + j] = tbuf[(Globals.con.current - i + oldtotallines) % oldtotallines * oldwidth + j];
                }
            }
            Console.ClearNotify();
        }
        Globals.con.display = Globals.con.current = Globals.con.totallines - 1;
    }

    public static void ClearNotify() {
        for (int i = 0; i < 4; ++i) {
            Globals.con.times[i] = 0.0f;
        }
    }

    static void DrawString(int x, int y, String s) {
        for (int i = 0; i < s.length(); ++i) {
            Globals.re.DrawChar(x, y, s.charAt(i));
            x += 8;
        }
    }

    static void DrawAltString(int x, int y, String s) {
        for (int i = 0; i < s.length(); ++i) {
            Globals.re.DrawChar(x, y, s.charAt(i) ^ 0x80);
            x += 8;
        }
    }

    static void Linefeed() {
        Globals.con.x = 0;
        if (Globals.con.display == Globals.con.current) {
            ++Globals.con.display;
        }
        ++Globals.con.current;
        int i = Globals.con.current % Globals.con.totallines * Globals.con.linewidth;
        int e = i + Globals.con.linewidth;
        while (i++ < e) {
            Globals.con.text[i] = 32;
        }
    }

    public static void Print(String txt) {
        int mask;
        int txtpos = 0;
        if (!Console.con.initialized) {
            return;
        }
        if (txt.charAt(0) == '\u0001' || txt.charAt(0) == '\u0002') {
            mask = 128;
            ++txtpos;
        } else {
            mask = 0;
        }
        block4: while (txtpos < txt.length()) {
            int l;
            char c = txt.charAt(txtpos);
            for (l = 0; l < Console.con.linewidth && l < txt.length() - txtpos && txt.charAt(l + txtpos) > ' '; ++l) {
            }
            if (l != Console.con.linewidth && Console.con.x + l > Console.con.linewidth) {
                Console.con.x = 0;
            }
            ++txtpos;
            if (cr != 0) {
                --Console.con.current;
                cr = 0;
            }
            if (Console.con.x == 0) {
                Console.Linefeed();
                if (Console.con.current >= 0) {
                    Console.con.times[Console.con.current % 4] = Console.cls.realtime;
                }
            }
            switch (c) {
                case '\n': {
                    Console.con.x = 0;
                    continue block4;
                }
                case '\r': {
                    Console.con.x = 0;
                    cr = 1;
                    continue block4;
                }
            }
            int y = Console.con.current % Console.con.totallines;
            Console.con.text[y * Console.con.linewidth + Console.con.x] = (byte)(c | mask | Console.con.ormask);
            ++Console.con.x;
            if (Console.con.x < Console.con.linewidth) continue;
            Console.con.x = 0;
        }
    }

    static void CenteredPrint(String text) {
        int l = text.length();
        if ((l = (Console.con.linewidth - l) / 2) < 0) {
            l = 0;
        }
        StringBuffer sb = new StringBuffer(1024);
        for (int i = 0; i < l; ++i) {
            sb.append(' ');
        }
        sb.append(text);
        sb.append('\n');
        sb.setLength(1024);
        Console.Print(sb.toString());
    }

    static void DrawInput() {
        int i;
        int start = 0;
        if (Console.cls.key_dest == 3) {
            return;
        }
        if (Console.cls.key_dest != 1 && Console.cls.state == 4) {
            return;
        }
        byte[] text = key_lines[edit_line];
        for (i = key_linepos; i < Console.con.linewidth; ++i) {
            text[i] = 32;
        }
        if (key_linepos >= Console.con.linewidth) {
            start += 1 + key_linepos - Console.con.linewidth;
        }
        for (i = 0; i < Console.con.linewidth; ++i) {
            if (Console.con.backedit == key_linepos - i && (Globals.cls.realtime >> 8 & 1) != 0) {
                re.DrawChar(i + 1 << 3, Console.con.vislines - 22, 11);
                continue;
            }
            re.DrawChar(i + 1 << 3, Console.con.vislines - 22, text[i]);
        }
        Console.key_lines[Console.edit_line][Console.key_linepos] = 0;
    }

    static void DrawNotify() {
        int x;
        int v = 0;
        for (int i = Console.con.current - 4 + 1; i <= Console.con.current; ++i) {
            int time;
            if (i < 0 || (time = (int)Console.con.times[i % 4]) == 0 || (float)(time = Console.cls.realtime - time) > Console.con_notifytime.value * 1000.0f) continue;
            int text = i % Console.con.totallines * Console.con.linewidth;
            for (x = 0; x < Console.con.linewidth; ++x) {
                re.DrawChar(x + 1 << 3, v, Console.con.text[text + x]);
            }
            v += 8;
        }
        if (Console.cls.key_dest == 2) {
            int skip;
            if (chat_team) {
                Console.DrawString(8, v, "say_team:");
                skip = 11;
            } else {
                Console.DrawString(8, v, "say:");
                skip = 5;
            }
            String s = chat_buffer;
            if (chat_bufferlen > (viddef.getWidth() >> 3) - (skip + 1)) {
                s = s.substring(chat_bufferlen - ((viddef.getWidth() >> 3) - (skip + 1)));
            }
            for (x = 0; x < s.length(); ++x) {
                if (chat_backedit > 0 && chat_backedit == chat_buffer.length() - x && (Console.cls.realtime >> 8 & 1) != 0) {
                    re.DrawChar(x + skip << 3, v, 11);
                    continue;
                }
                re.DrawChar(x + skip << 3, v, s.charAt(x));
            }
            if (chat_backedit == 0) {
                re.DrawChar(x + skip << 3, v, 10 + (Console.cls.realtime >> 8 & 1));
            }
            v += 8;
        }
        if (v != 0) {
            SCR.AddDirtyPoint(0, 0);
            SCR.AddDirtyPoint(viddef.getWidth() - 1, v);
        }
    }

    static void DrawConsole(float frac) {
        int x;
        int width = viddef.getWidth();
        int height = viddef.getHeight();
        int lines = (int)((float)height * frac);
        if (lines <= 0) {
            return;
        }
        if (lines > height) {
            lines = height;
        }
        re.DrawStretchPic(0, -height + lines, width, height, "conback");
        SCR.AddDirtyPoint(0, 0);
        SCR.AddDirtyPoint(width - 1, lines - 1);
        String version = Com.sprintf("v%4.2f", new Vargs(1).add(3.21f));
        for (int x2 = 0; x2 < 5; ++x2) {
            re.DrawChar(width - 44 + x2 * 8, lines - 12, 128 + version.charAt(x2));
        }
        Console.con.vislines = lines;
        int rows = lines - 22 >> 3;
        int y = lines - 30;
        if (Console.con.display != Console.con.current) {
            for (int x3 = 0; x3 < Console.con.linewidth; x3 += 4) {
                re.DrawChar(x3 + 1 << 3, y, 94);
            }
            y -= 8;
            --rows;
        }
        int row = Console.con.display;
        int i = 0;
        while (i < rows && row >= 0 && Console.con.current - row < Console.con.totallines) {
            int first = row % Console.con.totallines * Console.con.linewidth;
            for (x = 0; x < Console.con.linewidth; ++x) {
                re.DrawChar(x + 1 << 3, y, Console.con.text[x + first]);
            }
            ++i;
            y -= 8;
            --row;
        }
        if (Console.cls.download != null) {
            int text = Console.cls.downloadname.lastIndexOf(47);
            text = text != 0 ? ++text : 0;
            x = Console.con.linewidth - Console.con.linewidth * 7 / 40;
            y = x - (Console.cls.downloadname.length() - text) - 8;
            i = Console.con.linewidth / 3;
            StringBuffer dlbar = new StringBuffer(512);
            if (Console.cls.downloadname.length() - text > i) {
                y = x - i - 11;
                int end = text + i - 1;
                dlbar.append(Console.cls.downloadname.substring(text, end));
                dlbar.append("...");
            } else {
                dlbar.append(Console.cls.downloadname.substring(text));
            }
            dlbar.append(": ");
            dlbar.append('\u0080');
            int n = Console.cls.downloadpercent == 0 ? 0 : y * Console.cls.downloadpercent / 100;
            for (int j = 0; j < y; ++j) {
                if (j == n) {
                    dlbar.append('\u0083');
                    continue;
                }
                dlbar.append('\u0081');
            }
            dlbar.append('\u0082');
            dlbar.append(Console.cls.downloadpercent < 10 ? " 0" : " ");
            dlbar.append(Console.cls.downloadpercent).append('%');
            y = Console.con.vislines - 12;
            for (i = 0; i < dlbar.length(); ++i) {
                re.DrawChar(i + 1 << 3, y, dlbar.charAt(i));
            }
        }
        Console.DrawInput();
    }
}

