/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL_fx;
import jake2.client.CL_newfx;
import jake2.client.V;
import jake2.client.cl_sustain_t;
import jake2.client.entity_t;
import jake2.client.frame_t;
import jake2.game.player_state_t;
import jake2.qcommon.Com;
import jake2.qcommon.MSG;
import jake2.render.model_t;
import jake2.sound.S;
import jake2.sound.sfx_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class CL_tent {
    static final int MAX_EXPLOSIONS = 32;
    static explosion_t[] cl_explosions;
    static final int MAX_BEAMS = 32;
    static beam_t[] cl_beams;
    static beam_t[] cl_playerbeams;
    static final int MAX_LASERS = 32;
    static laser_t[] cl_lasers;
    static final int MAX_SUSTAINS = 32;
    static cl_sustain_t[] cl_sustains;
    static final int ex_free = 0;
    static final int ex_explosion = 1;
    static final int ex_misc = 2;
    static final int ex_flash = 3;
    static final int ex_mflash = 4;
    static final int ex_poly = 5;
    static final int ex_poly2 = 6;
    static sfx_t cl_sfx_ric1;
    static sfx_t cl_sfx_ric2;
    static sfx_t cl_sfx_ric3;
    static sfx_t cl_sfx_lashit;
    static sfx_t cl_sfx_spark5;
    static sfx_t cl_sfx_spark6;
    static sfx_t cl_sfx_spark7;
    static sfx_t cl_sfx_railg;
    static sfx_t cl_sfx_rockexp;
    static sfx_t cl_sfx_grenexp;
    static sfx_t cl_sfx_watrexp;
    static sfx_t cl_sfx_plasexp;
    static sfx_t[] cl_sfx_footsteps;
    static model_t cl_mod_explode;
    static model_t cl_mod_smoke;
    static model_t cl_mod_flash;
    static model_t cl_mod_parasite_segment;
    static model_t cl_mod_grapple_cable;
    static model_t cl_mod_parasite_tip;
    static model_t cl_mod_explo4;
    static model_t cl_mod_bfg_explo;
    static model_t cl_mod_powerscreen;
    static model_t cl_mod_plasmaexplo;
    static sfx_t cl_sfx_lightning;
    static sfx_t cl_sfx_disrexp;
    static model_t cl_mod_lightning;
    static model_t cl_mod_heatbeam;
    static model_t cl_mod_monster_heatbeam;
    static model_t cl_mod_explo4_big;
    private static final float[] start;
    private static final float[] end;
    private static final float[] pos;
    private static final float[] dir;
    static int[] splash_color;
    private static final float[] pos2;
    private static final entity_t ent;
    private static final float[] dist;
    private static final float[] org;
    private static final float[] f;
    private static final float[] u;
    private static final float[] r;

    static void RegisterTEntSounds() {
        cl_sfx_ric1 = S.RegisterSound("world/ric1.wav");
        cl_sfx_ric2 = S.RegisterSound("world/ric2.wav");
        cl_sfx_ric3 = S.RegisterSound("world/ric3.wav");
        cl_sfx_lashit = S.RegisterSound("weapons/lashit.wav");
        cl_sfx_spark5 = S.RegisterSound("world/spark5.wav");
        cl_sfx_spark6 = S.RegisterSound("world/spark6.wav");
        cl_sfx_spark7 = S.RegisterSound("world/spark7.wav");
        cl_sfx_railg = S.RegisterSound("weapons/railgf1a.wav");
        cl_sfx_rockexp = S.RegisterSound("weapons/rocklx1a.wav");
        cl_sfx_grenexp = S.RegisterSound("weapons/grenlx1a.wav");
        cl_sfx_watrexp = S.RegisterSound("weapons/xpld_wat.wav");
        S.RegisterSound("player/land1.wav");
        S.RegisterSound("player/fall2.wav");
        S.RegisterSound("player/fall1.wav");
        for (int i = 0; i < 4; ++i) {
            String name = "player/step" + (i + 1) + ".wav";
            CL_tent.cl_sfx_footsteps[i] = S.RegisterSound(name);
        }
        cl_sfx_lightning = S.RegisterSound("weapons/tesla.wav");
        cl_sfx_disrexp = S.RegisterSound("weapons/disrupthit.wav");
    }

    static void RegisterTEntModels() {
        cl_mod_explode = Globals.re.RegisterModel("models/objects/explode/tris.md2");
        cl_mod_smoke = Globals.re.RegisterModel("models/objects/smoke/tris.md2");
        cl_mod_flash = Globals.re.RegisterModel("models/objects/flash/tris.md2");
        cl_mod_parasite_segment = Globals.re.RegisterModel("models/monsters/parasite/segment/tris.md2");
        cl_mod_grapple_cable = Globals.re.RegisterModel("models/ctf/segment/tris.md2");
        cl_mod_parasite_tip = Globals.re.RegisterModel("models/monsters/parasite/tip/tris.md2");
        cl_mod_explo4 = Globals.re.RegisterModel("models/objects/r_explode/tris.md2");
        cl_mod_bfg_explo = Globals.re.RegisterModel("sprites/s_bfg2.sp2");
        cl_mod_powerscreen = Globals.re.RegisterModel("models/items/armor/effect/tris.md2");
        Globals.re.RegisterModel("models/objects/laser/tris.md2");
        Globals.re.RegisterModel("models/objects/grenade2/tris.md2");
        Globals.re.RegisterModel("models/weapons/v_machn/tris.md2");
        Globals.re.RegisterModel("models/weapons/v_handgr/tris.md2");
        Globals.re.RegisterModel("models/weapons/v_shotg2/tris.md2");
        Globals.re.RegisterModel("models/objects/gibs/bone/tris.md2");
        Globals.re.RegisterModel("models/objects/gibs/sm_meat/tris.md2");
        Globals.re.RegisterModel("models/objects/gibs/bone2/tris.md2");
        Globals.re.RegisterPic("w_machinegun");
        Globals.re.RegisterPic("a_bullets");
        Globals.re.RegisterPic("i_health");
        Globals.re.RegisterPic("a_grenades");
        cl_mod_explo4_big = Globals.re.RegisterModel("models/objects/r_explode2/tris.md2");
        cl_mod_lightning = Globals.re.RegisterModel("models/proj/lightning/tris.md2");
        cl_mod_heatbeam = Globals.re.RegisterModel("models/proj/beam/tris.md2");
        cl_mod_monster_heatbeam = Globals.re.RegisterModel("models/proj/widowbeam/tris.md2");
    }

    static void ClearTEnts() {
        int i;
        for (i = 0; i < cl_beams.length; ++i) {
            cl_beams[i].clear();
        }
        for (i = 0; i < cl_explosions.length; ++i) {
            cl_explosions[i].clear();
        }
        for (i = 0; i < cl_lasers.length; ++i) {
            cl_lasers[i].clear();
        }
        for (i = 0; i < cl_playerbeams.length; ++i) {
            cl_playerbeams[i].clear();
        }
        for (i = 0; i < cl_sustains.length; ++i) {
            cl_sustains[i].clear();
        }
    }

    static explosion_t AllocExplosion() {
        int i;
        for (i = 0; i < 32; ++i) {
            if (CL_tent.cl_explosions[i].type != 0) continue;
            cl_explosions[i].clear();
            return cl_explosions[i];
        }
        int time = Globals.cl.time;
        int index = 0;
        for (i = 0; i < 32; ++i) {
            if (!(CL_tent.cl_explosions[i].start < (float)time)) continue;
            time = (int)CL_tent.cl_explosions[i].start;
            index = i;
        }
        cl_explosions[index].clear();
        return cl_explosions[index];
    }

    static void SmokeAndFlash(float[] origin) {
        explosion_t ex = CL_tent.AllocExplosion();
        Math3D.VectorCopy(origin, ex.ent.origin);
        ex.type = 2;
        ex.frames = 4;
        ex.ent.flags = 32;
        ex.start = Globals.cl.frame.servertime - 100;
        ex.ent.model = cl_mod_smoke;
        ex = CL_tent.AllocExplosion();
        Math3D.VectorCopy(origin, ex.ent.origin);
        ex.type = 3;
        ex.ent.flags = 8;
        ex.frames = 2;
        ex.start = Globals.cl.frame.servertime - 100;
        ex.ent.model = cl_mod_flash;
    }

    static int ParseBeam(model_t model) {
        int i;
        float[] start = new float[3];
        float[] end = new float[3];
        short ent = MSG.ReadShort(Globals.net_message);
        MSG.ReadPos(Globals.net_message, start);
        MSG.ReadPos(Globals.net_message, end);
        beam_t[] b = cl_beams;
        for (i = 0; i < 32; ++i) {
            if (b[i].entity != ent) continue;
            b[i].entity = ent;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorClear(b[i].offset);
            return ent;
        }
        b = cl_beams;
        for (i = 0; i < 32; ++i) {
            if (b[i].model != null && b[i].endtime >= Globals.cl.time) continue;
            b[i].entity = ent;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorClear(b[i].offset);
            return ent;
        }
        Com.Printf("beam list overflow!\n");
        return ent;
    }

    static int ParseBeam2(model_t model) {
        int i;
        float[] start = new float[3];
        float[] end = new float[3];
        float[] offset = new float[3];
        short ent = MSG.ReadShort(Globals.net_message);
        MSG.ReadPos(Globals.net_message, start);
        MSG.ReadPos(Globals.net_message, end);
        MSG.ReadPos(Globals.net_message, offset);
        beam_t[] b = cl_beams;
        for (i = 0; i < 32; ++i) {
            if (b[i].entity != ent) continue;
            b[i].entity = ent;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorCopy(offset, b[i].offset);
            return ent;
        }
        b = cl_beams;
        for (i = 0; i < 32; ++i) {
            if (b[i].model != null && b[i].endtime >= Globals.cl.time) continue;
            b[i].entity = ent;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorCopy(offset, b[i].offset);
            return ent;
        }
        Com.Printf("beam list overflow!\n");
        return ent;
    }

    static int ParsePlayerBeam(model_t model) {
        int i;
        float[] start = new float[3];
        float[] end = new float[3];
        float[] offset = new float[3];
        short ent = MSG.ReadShort(Globals.net_message);
        MSG.ReadPos(Globals.net_message, start);
        MSG.ReadPos(Globals.net_message, end);
        if (model == cl_mod_heatbeam) {
            Math3D.VectorSet(offset, 2.0f, 7.0f, -3.0f);
        } else if (model == cl_mod_monster_heatbeam) {
            model = cl_mod_heatbeam;
            Math3D.VectorSet(offset, 0.0f, 0.0f, 0.0f);
        } else {
            MSG.ReadPos(Globals.net_message, offset);
        }
        beam_t[] b = cl_playerbeams;
        for (i = 0; i < 32; ++i) {
            if (b[i].entity != ent) continue;
            b[i].entity = ent;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorCopy(offset, b[i].offset);
            return ent;
        }
        b = cl_playerbeams;
        for (i = 0; i < 32; ++i) {
            if (b[i].model != null && b[i].endtime >= Globals.cl.time) continue;
            b[i].entity = ent;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 100;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorCopy(offset, b[i].offset);
            return ent;
        }
        Com.Printf("beam list overflow!\n");
        return ent;
    }

    static int ParseLightning(model_t model) {
        int i;
        short srcEnt = MSG.ReadShort(Globals.net_message);
        short destEnt = MSG.ReadShort(Globals.net_message);
        MSG.ReadPos(Globals.net_message, start);
        MSG.ReadPos(Globals.net_message, end);
        beam_t[] b = cl_beams;
        for (i = 0; i < 32; ++i) {
            if (b[i].entity != srcEnt || b[i].dest_entity != destEnt) continue;
            b[i].entity = srcEnt;
            b[i].dest_entity = destEnt;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorClear(b[i].offset);
            return srcEnt;
        }
        b = cl_beams;
        for (i = 0; i < 32; ++i) {
            if (b[i].model != null && b[i].endtime >= Globals.cl.time) continue;
            b[i].entity = srcEnt;
            b[i].dest_entity = destEnt;
            b[i].model = model;
            b[i].endtime = Globals.cl.time + 200;
            Math3D.VectorCopy(start, b[i].start);
            Math3D.VectorCopy(end, b[i].end);
            Math3D.VectorClear(b[i].offset);
            return srcEnt;
        }
        Com.Printf("beam list overflow!\n");
        return srcEnt;
    }

    static void ParseLaser(int colors) {
        MSG.ReadPos(Globals.net_message, start);
        MSG.ReadPos(Globals.net_message, end);
        laser_t[] l = cl_lasers;
        for (int i = 0; i < 32; ++i) {
            if (l[i].endtime >= Globals.cl.time) continue;
            l[i].ent.flags = 160;
            Math3D.VectorCopy(start, l[i].ent.origin);
            Math3D.VectorCopy(end, l[i].ent.oldorigin);
            l[i].ent.alpha = 0.3f;
            l[i].ent.skinnum = colors >> Lib.rand() % 4 * 8 & 0xFF;
            l[i].ent.model = null;
            l[i].ent.frame = 4;
            l[i].endtime = Globals.cl.time + 100;
            return;
        }
    }

    static void ParseSteam() {
        short id = MSG.ReadShort(Globals.net_message);
        if (id != -1) {
            int i;
            cl_sustain_t free_sustain = null;
            cl_sustain_t[] s = cl_sustains;
            for (i = 0; i < 32; ++i) {
                if (s[i].id != 0) continue;
                free_sustain = s[i];
                break;
            }
            if (free_sustain != null) {
                s[i].id = id;
                s[i].count = MSG.ReadByte(Globals.net_message);
                MSG.ReadPos(Globals.net_message, s[i].org);
                MSG.ReadDir(Globals.net_message, s[i].dir);
                int r = MSG.ReadByte(Globals.net_message);
                s[i].color = r & 0xFF;
                s[i].magnitude = MSG.ReadShort(Globals.net_message);
                s[i].endtime = Globals.cl.time + MSG.ReadLong(Globals.net_message);
                s[i].think = new cl_sustain_t.ThinkAdapter(){

                    void think(cl_sustain_t self) {
                        CL_newfx.ParticleSteamEffect2(self);
                    }
                };
                s[i].thinkinterval = 100;
                s[i].nextthink = Globals.cl.time;
            } else {
                int cnt = MSG.ReadByte(Globals.net_message);
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int r = MSG.ReadByte(Globals.net_message);
                int magnitude = MSG.ReadShort(Globals.net_message);
                magnitude = MSG.ReadLong(Globals.net_message);
            }
        } else {
            int cnt = MSG.ReadByte(Globals.net_message);
            MSG.ReadPos(Globals.net_message, pos);
            MSG.ReadDir(Globals.net_message, dir);
            int r = MSG.ReadByte(Globals.net_message);
            short magnitude = MSG.ReadShort(Globals.net_message);
            int color = r & 0xFF;
            CL_newfx.ParticleSteamEffect(pos, dir, color, cnt, magnitude);
        }
    }

    static void ParseWidow() {
        int i;
        short id = MSG.ReadShort(Globals.net_message);
        cl_sustain_t free_sustain = null;
        cl_sustain_t[] s = cl_sustains;
        for (i = 0; i < 32; ++i) {
            if (s[i].id != 0) continue;
            free_sustain = s[i];
            break;
        }
        if (free_sustain != null) {
            s[i].id = id;
            MSG.ReadPos(Globals.net_message, s[i].org);
            s[i].endtime = Globals.cl.time + 2100;
            s[i].think = new cl_sustain_t.ThinkAdapter(){

                void think(cl_sustain_t self) {
                    CL_newfx.Widowbeamout(self);
                }
            };
            s[i].thinkinterval = 1;
            s[i].nextthink = Globals.cl.time;
        } else {
            MSG.ReadPos(Globals.net_message, pos);
        }
    }

    static void ParseNuke() {
        int i;
        cl_sustain_t free_sustain = null;
        cl_sustain_t[] s = cl_sustains;
        for (i = 0; i < 32; ++i) {
            if (s[i].id != 0) continue;
            free_sustain = s[i];
            break;
        }
        if (free_sustain != null) {
            s[i].id = 21000;
            MSG.ReadPos(Globals.net_message, s[i].org);
            s[i].endtime = Globals.cl.time + 1000;
            s[i].think = new cl_sustain_t.ThinkAdapter(){

                void think(cl_sustain_t self) {
                    CL_newfx.Nukeblast(self);
                }
            };
            s[i].thinkinterval = 1;
            s[i].nextthink = Globals.cl.time;
        } else {
            MSG.ReadPos(Globals.net_message, pos);
        }
    }

    static void ParseTEnt() {
        int type = MSG.ReadByte(Globals.net_message);
        switch (type) {
            case 1: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                CL_fx.ParticleEffect(pos, dir, 232, 60);
                break;
            }
            case 0: 
            case 9: 
            case 14: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                if (type == 0) {
                    CL_fx.ParticleEffect(pos, dir, 0, 40);
                } else {
                    CL_fx.ParticleEffect(pos, dir, 224, 6);
                }
                if (type == 9) break;
                CL_tent.SmokeAndFlash(pos);
                int cnt = Lib.rand() & 0xF;
                if (cnt == 1) {
                    S.StartSound(pos, 0, 0, cl_sfx_ric1, 1.0f, 1.0f, 0.0f);
                    break;
                }
                if (cnt == 2) {
                    S.StartSound(pos, 0, 0, cl_sfx_ric2, 1.0f, 1.0f, 0.0f);
                    break;
                }
                if (cnt != 3) break;
                S.StartSound(pos, 0, 0, cl_sfx_ric3, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 12: 
            case 13: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                if (type == 12) {
                    CL_fx.ParticleEffect(pos, dir, 208, 40);
                } else {
                    CL_fx.ParticleEffect(pos, dir, 176, 40);
                }
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 4: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                CL_fx.ParticleEffect(pos, dir, 0, 20);
                CL_tent.SmokeAndFlash(pos);
                break;
            }
            case 10: {
                int cnt = MSG.ReadByte(Globals.net_message);
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int r = MSG.ReadByte(Globals.net_message);
                int color = r > 6 ? 0 : splash_color[r];
                CL_fx.ParticleEffect(pos, dir, color, cnt);
                if (r != 1) break;
                r = Lib.rand() & 3;
                if (r == 0) {
                    S.StartSound(pos, 0, 0, cl_sfx_spark5, 1.0f, 3.0f, 0.0f);
                    break;
                }
                if (r == 1) {
                    S.StartSound(pos, 0, 0, cl_sfx_spark6, 1.0f, 3.0f, 0.0f);
                    break;
                }
                S.StartSound(pos, 0, 0, cl_sfx_spark7, 1.0f, 3.0f, 0.0f);
                break;
            }
            case 15: {
                int cnt = MSG.ReadByte(Globals.net_message);
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int color = MSG.ReadByte(Globals.net_message);
                CL_fx.ParticleEffect2(pos, dir, color, cnt);
                break;
            }
            case 27: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadPos(Globals.net_message, dir);
                CL_fx.BlasterParticles(pos, dir);
                break;
            }
            case 2: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                CL_fx.BlasterParticles(pos, dir);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.ent.angles[0] = (float)(Math.acos(dir[2]) / Math.PI * 180.0);
                ex.ent.angles[1] = dir[0] != 0.0f ? (float)(Math.atan2(dir[1], dir[0]) / Math.PI * 180.0) : (dir[1] > 0.0f ? 90.0f : (dir[1] < 0.0f ? 270.0f : 0.0f));
                ex.type = 2;
                ex.ent.flags = 40;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 150.0f;
                ex.lightcolor[0] = 1.0f;
                ex.lightcolor[1] = 1.0f;
                ex.ent.model = cl_mod_explode;
                ex.frames = 4;
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadPos(Globals.net_message, pos2);
                CL_fx.RailTrail(pos, pos2);
                S.StartSound(pos2, 0, 0, cl_sfx_railg, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 6: 
            case 8: 
            case 18: {
                MSG.ReadPos(Globals.net_message, pos);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.type = 5;
                ex.ent.flags = 8;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 350.0f;
                ex.lightcolor[0] = 1.0f;
                ex.lightcolor[1] = 0.5f;
                ex.lightcolor[2] = 0.5f;
                ex.ent.model = cl_mod_explo4;
                ex.frames = 19;
                ex.baseframe = 30;
                ex.ent.angles[1] = Lib.rand() % 360;
                CL_fx.ExplosionParticles(pos);
                if (type == 18) {
                    S.StartSound(pos, 0, 0, cl_sfx_watrexp, 1.0f, 1.0f, 0.0f);
                    break;
                }
                S.StartSound(pos, 0, 0, cl_sfx_grenexp, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 28: {
                MSG.ReadPos(Globals.net_message, pos);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.type = 5;
                ex.ent.flags = 8;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 350.0f;
                ex.lightcolor[0] = 1.0f;
                ex.lightcolor[1] = 0.5f;
                ex.lightcolor[2] = 0.5f;
                ex.ent.angles[1] = Lib.rand() % 360;
                ex.ent.model = cl_mod_explo4;
                if ((double)Globals.rnd.nextFloat() < 0.5) {
                    ex.baseframe = 15;
                }
                ex.frames = 15;
                CL_fx.ExplosionParticles(pos);
                S.StartSound(pos, 0, 0, cl_sfx_rockexp, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 5: 
            case 7: 
            case 17: 
            case 53: 
            case 54: {
                MSG.ReadPos(Globals.net_message, pos);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.type = 5;
                ex.ent.flags = 8;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 350.0f;
                ex.lightcolor[0] = 1.0f;
                ex.lightcolor[1] = 0.5f;
                ex.lightcolor[2] = 0.5f;
                ex.ent.angles[1] = Lib.rand() % 360;
                ex.ent.model = type != 53 ? cl_mod_explo4 : cl_mod_explo4_big;
                if ((double)Globals.rnd.nextFloat() < 0.5) {
                    ex.baseframe = 15;
                }
                ex.frames = 15;
                if (type != 53 && type != 54) {
                    CL_fx.ExplosionParticles(pos);
                }
                if (type == 17) {
                    S.StartSound(pos, 0, 0, cl_sfx_watrexp, 1.0f, 1.0f, 0.0f);
                    break;
                }
                S.StartSound(pos, 0, 0, cl_sfx_rockexp, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 20: {
                MSG.ReadPos(Globals.net_message, pos);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.type = 5;
                ex.ent.flags = 8;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 350.0f;
                ex.lightcolor[0] = 0.0f;
                ex.lightcolor[1] = 1.0f;
                ex.lightcolor[2] = 0.0f;
                ex.ent.model = cl_mod_bfg_explo;
                ex.ent.flags |= 0x20;
                ex.ent.alpha = 0.3f;
                ex.frames = 4;
                break;
            }
            case 21: {
                MSG.ReadPos(Globals.net_message, pos);
                CL_fx.BFGExplosionParticles(pos);
                break;
            }
            case 23: {
                CL_tent.ParseLaser(-791555373);
                break;
            }
            case 11: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadPos(Globals.net_message, pos2);
                CL_fx.BubbleTrail(pos, pos2);
                break;
            }
            case 16: 
            case 19: {
                int ent = CL_tent.ParseBeam(cl_mod_parasite_segment);
                break;
            }
            case 22: {
                MSG.ReadPos(Globals.net_message, pos);
                CL_fx.BigTeleportParticles(pos);
                S.StartSound(pos, 0, 0, S.RegisterSound("misc/bigtele.wav"), 1.0f, 0.0f, 0.0f);
                break;
            }
            case 24: {
                int ent = CL_tent.ParseBeam2(cl_mod_grapple_cable);
                break;
            }
            case 25: {
                int cnt = MSG.ReadByte(Globals.net_message);
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int color = MSG.ReadByte(Globals.net_message);
                CL_fx.ParticleEffect2(pos, dir, color, cnt);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.type = 3;
                ex.ent.flags = 128;
                ex.start = (float)Globals.cl.frame.servertime - 0.1f;
                ex.light = 100 + Lib.rand() % 75;
                ex.lightcolor[0] = 1.0f;
                ex.lightcolor[1] = 1.0f;
                ex.lightcolor[2] = 0.3f;
                ex.ent.model = cl_mod_flash;
                ex.frames = 2;
                break;
            }
            case 26: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                CL_fx.ParticleEffect2(pos, dir, 223, 30);
                break;
            }
            case 29: {
                int cnt = MSG.ReadByte(Globals.net_message);
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int color = MSG.ReadByte(Globals.net_message);
                CL_fx.ParticleEffect3(pos, dir, color, cnt);
                break;
            }
            case 30: 
            case 55: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                if (type == 30) {
                    CL_newfx.BlasterParticles2(pos, dir, 208L);
                } else {
                    CL_newfx.BlasterParticles2(pos, dir, 111L);
                }
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.ent.angles[0] = (float)(Math.acos(dir[2]) / Math.PI * 180.0);
                ex.ent.angles[1] = dir[0] != 0.0f ? (float)(Math.atan2(dir[1], dir[0]) / Math.PI * 180.0) : (dir[1] > 0.0f ? 90.0f : (dir[1] < 0.0f ? 270.0f : 0.0f));
                ex.type = 2;
                ex.ent.flags = 40;
                ex.ent.skinnum = type == 30 ? 1 : 2;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 150.0f;
                if (type == 30) {
                    ex.lightcolor[1] = 1.0f;
                } else {
                    ex.lightcolor[0] = 0.19f;
                    ex.lightcolor[1] = 0.41f;
                    ex.lightcolor[2] = 0.75f;
                }
                ex.ent.model = cl_mod_explode;
                ex.frames = 4;
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 33: {
                int ent = CL_tent.ParseLightning(cl_mod_lightning);
                S.StartSound(null, ent, 1, cl_sfx_lightning, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 34: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadPos(Globals.net_message, pos2);
                CL_newfx.DebugTrail(pos, pos2);
                break;
            }
            case 35: {
                MSG.ReadPos(Globals.net_message, pos);
                explosion_t ex = CL_tent.AllocExplosion();
                Math3D.VectorCopy(pos, ex.ent.origin);
                ex.type = 5;
                ex.ent.flags = 8;
                ex.start = Globals.cl.frame.servertime - 100;
                ex.light = 350.0f;
                ex.lightcolor[0] = 1.0f;
                ex.lightcolor[1] = 0.5f;
                ex.lightcolor[2] = 0.5f;
                ex.ent.angles[1] = Lib.rand() % 360;
                ex.ent.model = cl_mod_explo4;
                if ((double)Globals.rnd.nextFloat() < 0.5) {
                    ex.baseframe = 15;
                }
                ex.frames = 15;
                if (type == 17) {
                    S.StartSound(pos, 0, 0, cl_sfx_watrexp, 1.0f, 1.0f, 0.0f);
                    break;
                }
                S.StartSound(pos, 0, 0, cl_sfx_rockexp, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 36: {
                MSG.ReadPos(Globals.net_message, pos);
                short ent = MSG.ReadShort(Globals.net_message);
                CL_newfx.Flashlight(ent, pos);
                break;
            }
            case 37: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadPos(Globals.net_message, pos2);
                int color = MSG.ReadByte(Globals.net_message);
                CL_newfx.ForceWall(pos, pos2, color);
                break;
            }
            case 38: {
                int ent = CL_tent.ParsePlayerBeam(cl_mod_heatbeam);
                break;
            }
            case 39: {
                int ent = CL_tent.ParsePlayerBeam(cl_mod_monster_heatbeam);
                break;
            }
            case 43: {
                int cnt = 50;
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int r = 8;
                int magnitude = 60;
                int color = r & 0xFF;
                CL_newfx.ParticleSteamEffect(pos, dir, color, cnt, magnitude);
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 44: {
                int cnt = 20;
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                int color = 224;
                int magnitude = 60;
                CL_newfx.ParticleSteamEffect(pos, dir, color, cnt, magnitude);
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 40: {
                CL_tent.ParseSteam();
                break;
            }
            case 41: {
                int cnt = 8;
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadPos(Globals.net_message, pos2);
                CL_newfx.BubbleTrail2(pos, pos2, cnt);
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 42: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                CL_fx.ParticleEffect(pos, dir, 232, 250);
                break;
            }
            case 45: {
                CL_tent.dir[0] = 0.0f;
                CL_tent.dir[1] = 0.0f;
                CL_tent.dir[2] = 1.0f;
                MSG.ReadPos(Globals.net_message, pos);
                CL_newfx.ParticleSmokeEffect(pos, dir, 0, 20, 20);
                break;
            }
            case 46: {
                MSG.ReadPos(Globals.net_message, pos);
                MSG.ReadDir(Globals.net_message, dir);
                CL_fx.ParticleEffect(pos, dir, 117, 40);
                S.StartSound(pos, 0, 0, cl_sfx_lashit, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 47: {
                MSG.ReadPos(Globals.net_message, pos);
                CL_newfx.ColorFlash(pos, 0, 150, -1.0f, -1.0f, -1.0f);
                CL_newfx.ColorExplosionParticles(pos, 0, 1);
                S.StartSound(pos, 0, 0, cl_sfx_disrexp, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 48: 
            case 49: {
                MSG.ReadPos(Globals.net_message, pos);
                CL_fx.TeleportParticles(pos);
                break;
            }
            case 50: {
                CL_tent.ParseWidow();
                break;
            }
            case 51: {
                CL_tent.ParseNuke();
                break;
            }
            case 52: {
                MSG.ReadPos(Globals.net_message, pos);
                CL_newfx.WidowSplash(pos);
                break;
            }
            default: {
                Com.Error(1, "CL_ParseTEnt: bad type");
            }
        }
    }

    static void AddBeams() {
        beam_t[] b = cl_beams;
        for (int i = 0; i < 32; ++i) {
            float model_length;
            float pitch;
            float yaw;
            if (b[i].model == null || b[i].endtime < Globals.cl.time) continue;
            if (b[i].entity == Globals.cl.playernum + 1) {
                Math3D.VectorCopy(Globals.cl.refdef.vieworg, b[i].start);
                b[i].start[2] = b[i].start[2] - 22.0f;
            }
            Math3D.VectorAdd(b[i].start, b[i].offset, org);
            Math3D.VectorSubtract(b[i].end, org, dist);
            if (dist[1] == 0.0f && dist[0] == 0.0f) {
                yaw = 0.0f;
                pitch = dist[2] > 0.0f ? 90.0f : 270.0f;
            } else {
                float forward;
                yaw = dist[0] != 0.0f ? (float)(Math.atan2(dist[1], dist[0]) * 180.0 / Math.PI) : (dist[1] > 0.0f ? 90.0f : 270.0f);
                if (yaw < 0.0f) {
                    yaw += 360.0f;
                }
                if ((pitch = (float)(Math.atan2(dist[2], forward = (float)Math.sqrt(dist[0] * dist[0] + dist[1] * dist[1])) * -180.0 / Math.PI)) < 0.0f) {
                    pitch = (float)((double)pitch + 360.0);
                }
            }
            float d = Math3D.VectorNormalize(dist);
            ent.clear();
            if (b[i].model == cl_mod_lightning) {
                model_length = 35.0f;
                d = (float)((double)d - 20.0);
            } else {
                model_length = 30.0f;
            }
            float steps = (float)Math.ceil(d / model_length);
            float len = (d - model_length) / (steps - 1.0f);
            if (b[i].model == cl_mod_lightning && d <= model_length) {
                Math3D.VectorCopy(b[i].end, CL_tent.ent.origin);
                CL_tent.ent.model = b[i].model;
                CL_tent.ent.flags = 8;
                CL_tent.ent.angles[0] = pitch;
                CL_tent.ent.angles[1] = yaw;
                CL_tent.ent.angles[2] = Lib.rand() % 360;
                V.AddEntity(ent);
                return;
            }
            while (d > 0.0f) {
                Math3D.VectorCopy(org, CL_tent.ent.origin);
                CL_tent.ent.model = b[i].model;
                if (b[i].model == cl_mod_lightning) {
                    CL_tent.ent.flags = 8;
                    CL_tent.ent.angles[0] = -pitch;
                    CL_tent.ent.angles[1] = yaw + 180.0f;
                    CL_tent.ent.angles[2] = Lib.rand() % 360;
                } else {
                    CL_tent.ent.angles[0] = pitch;
                    CL_tent.ent.angles[1] = yaw;
                    CL_tent.ent.angles[2] = Lib.rand() % 360;
                }
                V.AddEntity(ent);
                for (int j = 0; j < 3; ++j) {
                    int n = j;
                    org[n] = org[n] + dist[j] * len;
                }
                d -= model_length;
            }
        }
    }

    static void AddPlayerBeams() {
        int framenum = 0;
        float hand_multiplier = Globals.hand != null ? (Globals.hand.value == 2.0f ? 0.0f : (Globals.hand.value == 1.0f ? -1.0f : 1.0f)) : 1.0f;
        beam_t[] b = cl_playerbeams;
        for (int i = 0; i < 32; ++i) {
            float model_length;
            float pitch;
            float yaw;
            float len;
            int j;
            if (b[i].model == null || b[i].endtime < Globals.cl.time) continue;
            if (cl_mod_heatbeam != null && b[i].model == cl_mod_heatbeam) {
                if (b[i].entity == Globals.cl.playernum + 1) {
                    player_state_t ps = Globals.cl.frame.playerstate;
                    j = Globals.cl.frame.serverframe - 1 & 0xF;
                    frame_t oldframe = Globals.cl.frames[j];
                    if (oldframe.serverframe != Globals.cl.frame.serverframe - 1 || !oldframe.valid) {
                        oldframe = Globals.cl.frame;
                    }
                    player_state_t ops = oldframe.playerstate;
                    for (j = 0; j < 3; ++j) {
                        b[i].start[j] = Globals.cl.refdef.vieworg[j] + ops.gunoffset[j] + Globals.cl.lerpfrac * (ps.gunoffset[j] - ops.gunoffset[j]);
                    }
                    Math3D.VectorMA(b[i].start, hand_multiplier * b[i].offset[0], Globals.cl.v_right, org);
                    Math3D.VectorMA(org, b[i].offset[1], Globals.cl.v_forward, org);
                    Math3D.VectorMA(org, b[i].offset[2], Globals.cl.v_up, org);
                    if (Globals.hand != null && Globals.hand.value == 2.0f) {
                        Math3D.VectorMA(org, -1.0f, Globals.cl.v_up, org);
                    }
                    Math3D.VectorCopy(Globals.cl.v_right, r);
                    Math3D.VectorCopy(Globals.cl.v_forward, f);
                    Math3D.VectorCopy(Globals.cl.v_up, u);
                } else {
                    Math3D.VectorCopy(b[i].start, org);
                }
            } else {
                if (b[i].entity == Globals.cl.playernum + 1) {
                    Math3D.VectorCopy(Globals.cl.refdef.vieworg, b[i].start);
                    b[i].start[2] = b[i].start[2] - 22.0f;
                }
                Math3D.VectorAdd(b[i].start, b[i].offset, org);
            }
            Math3D.VectorSubtract(b[i].end, org, dist);
            if (cl_mod_heatbeam != null && b[i].model == cl_mod_heatbeam && b[i].entity == Globals.cl.playernum + 1) {
                len = Math3D.VectorLength(dist);
                Math3D.VectorScale(f, len, dist);
                Math3D.VectorMA(dist, hand_multiplier * b[i].offset[0], r, dist);
                Math3D.VectorMA(dist, b[i].offset[1], f, dist);
                Math3D.VectorMA(dist, b[i].offset[2], u, dist);
                if (Globals.hand != null && Globals.hand.value == 2.0f) {
                    Math3D.VectorMA(org, -1.0f, Globals.cl.v_up, org);
                }
            }
            if (dist[1] == 0.0f && dist[0] == 0.0f) {
                yaw = 0.0f;
                pitch = dist[2] > 0.0f ? 90.0f : 270.0f;
            } else {
                float forward;
                yaw = dist[0] != 0.0f ? (float)(Math.atan2(dist[1], dist[0]) * 180.0 / Math.PI) : (dist[1] > 0.0f ? 90.0f : 270.0f);
                if (yaw < 0.0f) {
                    yaw += 360.0f;
                }
                if ((pitch = (float)(Math.atan2(dist[2], forward = (float)Math.sqrt(dist[0] * dist[0] + dist[1] * dist[1])) * -180.0 / Math.PI)) < 0.0f) {
                    pitch = (float)((double)pitch + 360.0);
                }
            }
            if (cl_mod_heatbeam != null && b[i].model == cl_mod_heatbeam) {
                if (b[i].entity != Globals.cl.playernum + 1) {
                    framenum = 2;
                    CL_tent.ent.angles[0] = -pitch;
                    CL_tent.ent.angles[1] = yaw + 180.0f;
                    CL_tent.ent.angles[2] = 0.0f;
                    Math3D.AngleVectors(CL_tent.ent.angles, f, r, u);
                    if (!Math3D.VectorEquals(b[i].offset, Globals.vec3_origin)) {
                        Math3D.VectorMA(org, -b[i].offset[0] + 1.0f, r, org);
                        Math3D.VectorMA(org, -b[i].offset[1], f, org);
                        Math3D.VectorMA(org, -b[i].offset[2] - 10.0f, u, org);
                    } else {
                        CL_newfx.MonsterPlasma_Shell(b[i].start);
                    }
                } else {
                    framenum = 1;
                }
            }
            if (cl_mod_heatbeam != null && b[i].model == cl_mod_heatbeam && b[i].entity == Globals.cl.playernum + 1) {
                CL_newfx.Heatbeam(org, dist);
            }
            float d = Math3D.VectorNormalize(dist);
            ent.clear();
            if (b[i].model == cl_mod_heatbeam) {
                model_length = 32.0f;
            } else if (b[i].model == cl_mod_lightning) {
                model_length = 35.0f;
                d = (float)((double)d - 20.0);
            } else {
                model_length = 30.0f;
            }
            float steps = (float)Math.ceil(d / model_length);
            len = (d - model_length) / (steps - 1.0f);
            if (b[i].model == cl_mod_lightning && d <= model_length) {
                Math3D.VectorCopy(b[i].end, CL_tent.ent.origin);
                CL_tent.ent.model = b[i].model;
                CL_tent.ent.flags = 8;
                CL_tent.ent.angles[0] = pitch;
                CL_tent.ent.angles[1] = yaw;
                CL_tent.ent.angles[2] = Lib.rand() % 360;
                V.AddEntity(ent);
                return;
            }
            while (d > 0.0f) {
                Math3D.VectorCopy(org, CL_tent.ent.origin);
                CL_tent.ent.model = b[i].model;
                if (cl_mod_heatbeam != null && b[i].model == cl_mod_heatbeam) {
                    CL_tent.ent.flags = 8;
                    CL_tent.ent.angles[0] = -pitch;
                    CL_tent.ent.angles[1] = yaw + 180.0f;
                    CL_tent.ent.angles[2] = Globals.cl.time % 360;
                    CL_tent.ent.frame = framenum;
                } else if (b[i].model == cl_mod_lightning) {
                    CL_tent.ent.flags = 8;
                    CL_tent.ent.angles[0] = -pitch;
                    CL_tent.ent.angles[1] = yaw + 180.0f;
                    CL_tent.ent.angles[2] = Lib.rand() % 360;
                } else {
                    CL_tent.ent.angles[0] = pitch;
                    CL_tent.ent.angles[1] = yaw;
                    CL_tent.ent.angles[2] = Lib.rand() % 360;
                }
                V.AddEntity(ent);
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    org[n] = org[n] + dist[j] * len;
                }
                d -= model_length;
            }
        }
    }

    static void AddExplosions() {
        entity_t ent = null;
        explosion_t[] ex = cl_explosions;
        for (int i = 0; i < 32; ++i) {
            if (ex[i].type == 0) continue;
            float frac = ((float)Globals.cl.time - ex[i].start) / 100.0f;
            int f = (int)Math.floor(frac);
            ent = ex[i].ent;
            switch (ex[i].type) {
                case 4: {
                    if (f < ex[i].frames - 1) break;
                    ex[i].type = 0;
                    break;
                }
                case 2: {
                    if (f >= ex[i].frames - 1) {
                        ex[i].type = 0;
                        break;
                    }
                    ent.alpha = 1.0f - frac / (float)(ex[i].frames - 1);
                    break;
                }
                case 3: {
                    if (f >= 1) {
                        ex[i].type = 0;
                        break;
                    }
                    ent.alpha = 1.0f;
                    break;
                }
                case 5: {
                    if (f >= ex[i].frames - 1) {
                        ex[i].type = 0;
                        break;
                    }
                    ent.alpha = (16.0f - (float)f) / 16.0f;
                    if (f < 10) {
                        ent.skinnum = f >> 1;
                        if (ent.skinnum >= 0) break;
                        ent.skinnum = 0;
                        break;
                    }
                    ent.flags |= 0x20;
                    if (f < 13) {
                        ent.skinnum = 5;
                        break;
                    }
                    ent.skinnum = 6;
                    break;
                }
                case 6: {
                    if (f >= ex[i].frames - 1) {
                        ex[i].type = 0;
                        break;
                    }
                    ent.alpha = (5.0f - (float)f) / 5.0f;
                    ent.skinnum = 0;
                    ent.flags |= 0x20;
                }
            }
            if (ex[i].type == 0) continue;
            if (ex[i].light != 0.0f) {
                V.AddLight(ent.origin, ex[i].light * ent.alpha, ex[i].lightcolor[0], ex[i].lightcolor[1], ex[i].lightcolor[2]);
            }
            Math3D.VectorCopy(ent.origin, ent.oldorigin);
            if (f < 0) {
                f = 0;
            }
            ent.frame = ex[i].baseframe + f + 1;
            ent.oldframe = ex[i].baseframe + f;
            ent.backlerp = 1.0f - Globals.cl.lerpfrac;
            V.AddEntity(ent);
        }
    }

    static void AddLasers() {
        laser_t[] l = cl_lasers;
        for (int i = 0; i < 32; ++i) {
            if (l[i].endtime < Globals.cl.time) continue;
            V.AddEntity(l[i].ent);
        }
    }

    static void ProcessSustain() {
        cl_sustain_t[] s = cl_sustains;
        for (int i = 0; i < 32; ++i) {
            if (s[i].id == 0) continue;
            if (s[i].endtime >= Globals.cl.time && Globals.cl.time >= s[i].nextthink) {
                s[i].think.think(s[i]);
                continue;
            }
            if (s[i].endtime >= Globals.cl.time) continue;
            s[i].id = 0;
        }
    }

    static void AddTEnts() {
        CL_tent.AddBeams();
        CL_tent.AddPlayerBeams();
        CL_tent.AddExplosions();
        CL_tent.AddLasers();
        CL_tent.ProcessSustain();
    }

    static {
        int i;
        cl_explosions = new explosion_t[32];
        cl_beams = new beam_t[32];
        cl_playerbeams = new beam_t[32];
        cl_lasers = new laser_t[32];
        cl_sustains = new cl_sustain_t[32];
        for (i = 0; i < cl_explosions.length; ++i) {
            CL_tent.cl_explosions[i] = new explosion_t();
        }
        for (i = 0; i < cl_beams.length; ++i) {
            CL_tent.cl_beams[i] = new beam_t();
        }
        for (i = 0; i < cl_playerbeams.length; ++i) {
            CL_tent.cl_playerbeams[i] = new beam_t();
        }
        for (i = 0; i < cl_lasers.length; ++i) {
            CL_tent.cl_lasers[i] = new laser_t();
        }
        for (i = 0; i < cl_sustains.length; ++i) {
            CL_tent.cl_sustains[i] = new cl_sustain_t();
        }
        cl_sfx_footsteps = new sfx_t[4];
        start = new float[3];
        end = new float[3];
        pos = new float[3];
        dir = new float[3];
        splash_color = new int[]{0, 224, 176, 80, 208, 224, 232};
        pos2 = new float[]{0.0f, 0.0f, 0.0f};
        ent = new entity_t();
        dist = new float[3];
        org = new float[3];
        f = new float[3];
        u = new float[3];
        r = new float[3];
    }

    static class laser_t {
        entity_t ent = new entity_t();
        int endtime;

        laser_t() {
        }

        void clear() {
            this.endtime = 0;
            this.ent.clear();
        }
    }

    static class beam_t {
        int entity;
        int dest_entity;
        model_t model;
        int endtime;
        float[] offset = new float[3];
        float[] start = new float[3];
        float[] end = new float[3];

        beam_t() {
        }

        void clear() {
            this.endtime = 0;
            this.dest_entity = 0;
            this.entity = 0;
            this.end[1] = this.end[2] = (float)0;
            this.end[0] = this.end[2];
            this.start[2] = this.end[2];
            this.start[1] = this.end[2];
            this.start[0] = this.end[2];
            this.offset[2] = this.end[2];
            this.offset[1] = this.end[2];
            this.offset[0] = this.end[2];
            this.model = null;
        }
    }

    static class explosion_t {
        int type;
        entity_t ent = new entity_t();
        int frames;
        float light;
        float[] lightcolor = new float[3];
        float start;
        int baseframe;

        explosion_t() {
        }

        void clear() {
            this.baseframe = 0;
            this.frames = 0;
            this.type = 0;
            this.light = this.start = (float)0;
            this.lightcolor[2] = this.start;
            this.lightcolor[1] = this.start;
            this.lightcolor[0] = this.start;
            this.ent.clear();
        }
    }
}

