/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Defines;
import jake2.Globals;
import jake2.game.cmodel_t;
import jake2.game.edict_t;
import jake2.game.entity_state_t;
import jake2.game.pmove_t;
import jake2.game.trace_t;
import jake2.game.usercmd_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.qcommon.PMove;
import jake2.util.Lib;
import jake2.util.Math3D;

public class CL_pred {
    public static edict_t DUMMY_ENT = new edict_t(-1);

    static void CheckPredictionError() {
        int[] delta = new int[3];
        if (Globals.cl_predict.value == 0.0f || (Globals.cl.frame.playerstate.pmove.pm_flags & 0x40) != 0) {
            return;
        }
        int frame = Globals.cls.netchan.incoming_acknowledged;
        Math3D.VectorSubtract(Globals.cl.frame.playerstate.pmove.origin, Globals.cl.predicted_origins[frame &= Defines.CMD_BACKUP - 1], delta);
        int len = Math.abs(delta[0]) + Math.abs(delta[1]) + Math.abs(delta[2]);
        if (len > 640) {
            Math3D.VectorClear(Globals.cl.prediction_error);
        } else {
            if (Globals.cl_showmiss.value != 0.0f && (delta[0] != 0 || delta[1] != 0 || delta[2] != 0)) {
                Com.Printf("prediction miss on " + Globals.cl.frame.serverframe + ": " + (delta[0] + delta[1] + delta[2]) + "\n");
            }
            Math3D.VectorCopy(Globals.cl.frame.playerstate.pmove.origin, Globals.cl.predicted_origins[frame]);
            for (int i = 0; i < 3; ++i) {
                Globals.cl.prediction_error[i] = (float)delta[i] * 0.125f;
            }
        }
    }

    static void ClipMoveToEntities(float[] start, float[] mins, float[] maxs, float[] end, trace_t tr) {
        float[] bmins = new float[3];
        float[] bmaxs = new float[3];
        for (int i = 0; i < Globals.cl.frame.num_entities; ++i) {
            float[] angles;
            int headnode;
            int num = Globals.cl.frame.parse_entities + i & 0x3FF;
            entity_state_t ent = Globals.cl_parse_entities[num];
            if (ent.solid == 0 || ent.number == Globals.cl.playernum + 1) continue;
            if (ent.solid == 31) {
                cmodel_t cmodel = Globals.cl.model_clip[ent.modelindex];
                if (cmodel == null) continue;
                headnode = cmodel.headnode;
                angles = ent.angles;
            } else {
                int x = 8 * (ent.solid & 0x1F);
                int zd = 8 * (ent.solid >>> 5 & 0x1F);
                int zu = 8 * (ent.solid >>> 10 & 0x3F) - 32;
                bmins[0] = bmins[1] = (float)(-x);
                bmaxs[0] = bmaxs[1] = (float)x;
                bmins[2] = -zd;
                bmaxs[2] = zu;
                headnode = CM.HeadnodeForBox(bmins, bmaxs);
                angles = Globals.vec3_origin;
            }
            if (tr.allsolid) {
                return;
            }
            trace_t trace = CM.TransformedBoxTrace(start, end, mins, maxs, headnode, 33619971, ent.origin, angles);
            if (trace.allsolid || trace.startsolid || trace.fraction < tr.fraction) {
                trace.ent = ent.surrounding_ent;
                if (tr.startsolid) {
                    tr.set(trace);
                    tr.startsolid = true;
                    continue;
                }
                tr.set(trace);
                continue;
            }
            if (!trace.startsolid) continue;
            tr.startsolid = true;
        }
    }

    static trace_t PMTrace(float[] start, float[] mins, float[] maxs, float[] end) {
        trace_t t = CM.BoxTrace(start, end, mins, maxs, 0, 33619971);
        if (t.fraction < 1.0f) {
            t.ent = DUMMY_ENT;
        }
        CL_pred.ClipMoveToEntities(start, mins, maxs, end, t);
        return t;
    }

    static int PMpointcontents(float[] point) {
        int contents = CM.PointContents(point, 0);
        for (int i = 0; i < Globals.cl.frame.num_entities; ++i) {
            cmodel_t cmodel;
            int num = Globals.cl.frame.parse_entities + i & 0x3FF;
            entity_state_t ent = Globals.cl_parse_entities[num];
            if (ent.solid != 31 || (cmodel = Globals.cl.model_clip[ent.modelindex]) == null) continue;
            contents |= CM.TransformedPointContents(point, cmodel.headnode, ent.origin, ent.angles);
        }
        return contents;
    }

    static void PredictMovement() {
        if (Globals.cls.state != 4) {
            return;
        }
        if (Globals.cl_paused.value != 0.0f) {
            return;
        }
        if (Globals.cl_predict.value == 0.0f || (Globals.cl.frame.playerstate.pmove.pm_flags & 0x40) != 0) {
            for (int i = 0; i < 3; ++i) {
                Globals.cl.predicted_angles[i] = Globals.cl.viewangles[i] + Math3D.SHORT2ANGLE(Globals.cl.frame.playerstate.pmove.delta_angles[i]);
            }
            return;
        }
        int current = Globals.cls.netchan.outgoing_sequence;
        int ack = Globals.cls.netchan.incoming_acknowledged;
        if (current - ack >= Defines.CMD_BACKUP) {
            if (Globals.cl_showmiss.value != 0.0f) {
                Com.Printf("exceeded CMD_BACKUP\n");
            }
            return;
        }
        pmove_t pm = new pmove_t();
        pm.trace = new pmove_t.TraceAdapter(){

            public trace_t trace(float[] start, float[] mins, float[] maxs, float[] end) {
                return CL_pred.PMTrace(start, mins, maxs, end);
            }
        };
        pm.pointcontents = new pmove_t.PointContentsAdapter(){

            public int pointcontents(float[] point) {
                return CL_pred.PMpointcontents(point);
            }
        };
        PMove.pm_airaccelerate = Lib.atof(Globals.cl.configstrings[29]);
        pm.s.set(Globals.cl.frame.playerstate.pmove);
        int frame = 0;
        while (++ack < current) {
            frame = ack & Defines.CMD_BACKUP - 1;
            usercmd_t cmd = Globals.cl.cmds[frame];
            pm.cmd.set(cmd);
            PMove.Pmove(pm);
            Math3D.VectorCopy(pm.s.origin, Globals.cl.predicted_origins[frame]);
        }
        int oldframe = ack - 2 & Defines.CMD_BACKUP - 1;
        short oldz = Globals.cl.predicted_origins[oldframe][2];
        int step = pm.s.origin[2] - oldz;
        if (step > 63 && step < 160 && (pm.s.pm_flags & 4) != 0) {
            Globals.cl.predicted_step = (float)step * 0.125f;
            Globals.cl.predicted_step_time = (int)((float)Globals.cls.realtime - Globals.cls.frametime * 500.0f);
        }
        Globals.cl.predicted_origin[0] = (float)pm.s.origin[0] * 0.125f;
        Globals.cl.predicted_origin[1] = (float)pm.s.origin[1] * 0.125f;
        Globals.cl.predicted_origin[2] = (float)pm.s.origin[2] * 0.125f;
        Math3D.VectorCopy(pm.viewangles, Globals.cl.predicted_angles);
    }
}

