/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL;
import jake2.client.CL_ents;
import jake2.client.CL_fx;
import jake2.client.CL_inv;
import jake2.client.CL_tent;
import jake2.client.CL_view;
import jake2.client.SCR;
import jake2.client.clientinfo_t;
import jake2.game.Cmd;
import jake2.game.entity_state_t;
import jake2.qcommon.CDAudio;
import jake2.qcommon.CM;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.qcommon.xcommand_t;
import jake2.render.model_t;
import jake2.sound.S;
import jake2.sys.Sys;
import jake2.util.Lib;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CL_parse {
    public static String[] svc_strings = new String[]{"svc_bad", "svc_muzzleflash", "svc_muzzlflash2", "svc_temp_entity", "svc_layout", "svc_inventory", "svc_nop", "svc_disconnect", "svc_reconnect", "svc_sound", "svc_print", "svc_stufftext", "svc_serverdata", "svc_configstring", "svc_spawnbaseline", "svc_centerprint", "svc_download", "svc_playerinfo", "svc_packetentities", "svc_deltapacketentities", "svc_frame"};
    public static xcommand_t Download_f = new xcommand_t(){

        public void execute() {
            if (Cmd.Argc() != 2) {
                Com.Printf("Usage: download <filename>\n");
                return;
            }
            String filename = Cmd.Argv(1);
            if (filename.indexOf("..") != -1) {
                Com.Printf("Refusing to download a path with ..\n");
                return;
            }
            if (FS.LoadFile(filename) != null) {
                Com.Printf("File already exists.\n");
                return;
            }
            Globals.cls.downloadname = filename;
            Com.Printf("Downloading " + Globals.cls.downloadname + "\n");
            Globals.cls.downloadtempname = Com.StripExtension(Globals.cls.downloadname);
            Globals.cls.downloadtempname = Globals.cls.downloadtempname + ".tmp";
            MSG.WriteByte(Globals.cls.netchan.message, 4);
            MSG.WriteString(Globals.cls.netchan.message, "download " + Globals.cls.downloadname);
            ++Globals.cls.downloadnumber;
        }
    };
    private static final float[] pos_v = new float[]{0.0f, 0.0f, 0.0f};

    public static String DownloadFileName(String fn) {
        return FS.Gamedir() + "/" + fn;
    }

    public static boolean CheckOrDownloadFile(String filename) {
        if (filename.indexOf("..") != -1) {
            Com.Printf("Refusing to download a path with ..\n");
            return true;
        }
        if (FS.FileLength(filename) > 0) {
            return true;
        }
        Globals.cls.downloadname = filename;
        Globals.cls.downloadtempname = Com.StripExtension(Globals.cls.downloadname);
        Globals.cls.downloadtempname = Globals.cls.downloadtempname + ".tmp";
        String name = CL_parse.DownloadFileName(Globals.cls.downloadtempname);
        RandomAccessFile fp = Lib.fopen(name, "r+b");
        if (fp != null) {
            long len = 0L;
            try {
                len = fp.length();
            }
            catch (IOException e) {
                // empty catch block
            }
            Globals.cls.download = fp;
            Com.Printf("Resuming " + Globals.cls.downloadname + "\n");
            MSG.WriteByte(Globals.cls.netchan.message, 4);
            MSG.WriteString(Globals.cls.netchan.message, "download " + Globals.cls.downloadname + " " + len);
        } else {
            Com.Printf("Downloading " + Globals.cls.downloadname + "\n");
            MSG.WriteByte(Globals.cls.netchan.message, 4);
            MSG.WriteString(Globals.cls.netchan.message, "download " + Globals.cls.downloadname);
        }
        ++Globals.cls.downloadnumber;
        return false;
    }

    public static void RegisterSounds() {
        S.BeginRegistration();
        CL_tent.RegisterTEntSounds();
        for (int i = 1; i < 256 && Globals.cl.configstrings[288 + i] != null && !Globals.cl.configstrings[288 + i].equals("") && !Globals.cl.configstrings[288 + i].equals("\u0000"); ++i) {
            Globals.cl.sound_precache[i] = S.RegisterSound(Globals.cl.configstrings[288 + i]);
            Sys.SendKeyEvents();
        }
        S.EndRegistration();
    }

    public static void ParseDownload() {
        short size = MSG.ReadShort(Globals.net_message);
        int percent = MSG.ReadByte(Globals.net_message);
        if (size == -1) {
            Com.Printf("Server does not have this file.\n");
            if (Globals.cls.download != null) {
                try {
                    Globals.cls.download.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Globals.cls.download = null;
            }
            CL.RequestNextDownload();
            return;
        }
        if (Globals.cls.download == null) {
            String name = CL_parse.DownloadFileName(Globals.cls.downloadtempname).toLowerCase();
            FS.CreatePath(name);
            Globals.cls.download = Lib.fopen(name, "rw");
            if (Globals.cls.download == null) {
                Globals.net_message.readcount += size;
                Com.Printf("Failed to open " + Globals.cls.downloadtempname + "\n");
                CL.RequestNextDownload();
                return;
            }
        }
        try {
            Globals.cls.download.write(Globals.net_message.data, Globals.net_message.readcount, size);
        }
        catch (Exception e) {
            // empty catch block
        }
        Globals.net_message.readcount += size;
        if (percent != 100) {
            Globals.cls.downloadpercent = percent;
            MSG.WriteByte(Globals.cls.netchan.message, 4);
            SZ.Print(Globals.cls.netchan.message, "nextdl");
        } else {
            try {
                Globals.cls.download.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            String oldn = CL_parse.DownloadFileName(Globals.cls.downloadtempname);
            String newn = CL_parse.DownloadFileName(Globals.cls.downloadname);
            int r = Lib.rename(oldn, newn);
            if (r != 0) {
                Com.Printf("failed to rename.\n");
            }
            Globals.cls.download = null;
            Globals.cls.downloadpercent = 0;
            CL.RequestNextDownload();
        }
    }

    public static void ParseServerData() {
        String str;
        int i;
        Com.DPrintf("ParseServerData():Serverdata packet received.\n");
        CL.ClearState();
        Globals.cls.state = 3;
        Globals.cls.serverProtocol = i = MSG.ReadLong(Globals.net_message);
        if (Globals.server_state == 0 && i != 34) {
            Com.Error(1, "Server returned version " + i + ", not " + 34);
        }
        Globals.cl.servercount = MSG.ReadLong(Globals.net_message);
        Globals.cl.attractloop = MSG.ReadByte(Globals.net_message) != 0;
        Globals.cl.gamedir = str = MSG.ReadString(Globals.net_message);
        Com.dprintln("gamedir=" + str);
        if (str.length() > 0 && (FS.fs_gamedirvar.string == null || FS.fs_gamedirvar.string.length() == 0 || FS.fs_gamedirvar.string.equals(str)) || str.length() == 0 && (FS.fs_gamedirvar.string != null || FS.fs_gamedirvar.string.length() == 0)) {
            Cvar.Set("game", str);
        }
        Globals.cl.playernum = MSG.ReadShort(Globals.net_message);
        Com.dprintln("numplayers=" + Globals.cl.playernum);
        str = MSG.ReadString(Globals.net_message);
        Com.dprintln("levelname=" + str);
        if (Globals.cl.playernum == -1) {
            SCR.PlayCinematic(str);
        } else {
            Com.Printf("Levelname:" + str + "\n");
            Globals.cl.refresh_prepped = false;
        }
    }

    public static void ParseBaseline() {
        entity_state_t nullstate = new entity_state_t(null);
        int[] bits = new int[]{0};
        int newnum = CL_ents.ParseEntityBits(bits);
        entity_state_t es = Globals.cl_entities[newnum].baseline;
        CL_ents.ParseDelta(nullstate, es, newnum, bits[0]);
    }

    public static void LoadClientinfo(clientinfo_t ci, String s) {
        ci.cinfo = s;
        ci.name = s;
        int t = s.indexOf(92);
        if (t != -1) {
            ci.name = s.substring(0, t);
            s = s.substring(t + 1, s.length());
        }
        if (Globals.cl_noskins.value != 0.0f || s.length() == 0) {
            String model_filename = "players/male/tris.md2";
            String weapon_filename = "players/male/weapon.md2";
            String skin_filename = "players/male/grunt.pcx";
            ci.iconname = "/players/male/grunt_i.pcx";
            ci.model = Globals.re.RegisterModel(model_filename);
            ci.weaponmodel = new model_t[20];
            ci.weaponmodel[0] = Globals.re.RegisterModel(weapon_filename);
            ci.skin = Globals.re.RegisterSkin(skin_filename);
            ci.icon = Globals.re.RegisterPic(ci.iconname);
        } else {
            int pos = s.indexOf(47);
            if (pos == -1) {
                pos = s.indexOf(47);
            }
            if (pos == -1) {
                pos = 0;
                Com.Error(0, "Invalid model name:" + s);
            }
            String model_name = s.substring(0, pos);
            String skin_name = s.substring(pos + 1, s.length());
            String model_filename = "players/" + model_name + "/tris.md2";
            ci.model = Globals.re.RegisterModel(model_filename);
            if (ci.model == null) {
                model_name = "male";
                model_filename = "players/male/tris.md2";
                ci.model = Globals.re.RegisterModel(model_filename);
            }
            String skin_filename = "players/" + model_name + "/" + skin_name + ".pcx";
            ci.skin = Globals.re.RegisterSkin(skin_filename);
            if (ci.skin == null && !model_name.equalsIgnoreCase("male")) {
                model_name = "male";
                model_filename = "players/male/tris.md2";
                ci.model = Globals.re.RegisterModel(model_filename);
                skin_filename = "players/" + model_name + "/" + skin_name + ".pcx";
                ci.skin = Globals.re.RegisterSkin(skin_filename);
            }
            if (ci.skin == null) {
                skin_filename = "players/" + model_name + "/grunt.pcx";
                ci.skin = Globals.re.RegisterSkin(skin_filename);
            }
            for (int i = 0; i < CL_view.num_cl_weaponmodels; ++i) {
                String weapon_filename = "players/" + model_name + "/" + CL_view.cl_weaponmodels[i];
                ci.weaponmodel[i] = Globals.re.RegisterModel(weapon_filename);
                if (null == ci.weaponmodel[i] && model_name.equals("cyborg")) {
                    weapon_filename = "players/male/" + CL_view.cl_weaponmodels[i];
                    ci.weaponmodel[i] = Globals.re.RegisterModel(weapon_filename);
                }
                if (0.0f == Globals.cl_vwep.value) break;
            }
            ci.iconname = "/players/" + model_name + "/" + skin_name + "_i.pcx";
            ci.icon = Globals.re.RegisterPic(ci.iconname);
        }
        if (ci.skin == null || ci.icon == null || ci.model == null || ci.weaponmodel[0] == null) {
            ci.skin = null;
            ci.icon = null;
            ci.model = null;
            ci.weaponmodel[0] = null;
            return;
        }
    }

    public static void ParseClientinfo(int player) {
        String s = Globals.cl.configstrings[player + 1312];
        clientinfo_t ci = Globals.cl.clientinfo[player];
        CL_parse.LoadClientinfo(ci, s);
    }

    public static void ParseConfigString() {
        short i = MSG.ReadShort(Globals.net_message);
        if (i < 0 || i >= 2080) {
            Com.Error(1, "configstring > MAX_CONFIGSTRINGS");
        }
        String s = MSG.ReadString(Globals.net_message);
        String olds = Globals.cl.configstrings[i];
        Globals.cl.configstrings[i] = s;
        if (i >= 800 && i < 1056) {
            CL_fx.SetLightstyle(i - 800);
        } else if (i == 1) {
            if (Globals.cl.refresh_prepped) {
                CDAudio.Play(Lib.atoi(Globals.cl.configstrings[1]), true);
            }
        } else if (i >= 32 && i < 288) {
            if (Globals.cl.refresh_prepped) {
                Globals.cl.model_draw[i - 32] = Globals.re.RegisterModel(Globals.cl.configstrings[i]);
                Globals.cl.model_clip[i - 32] = Globals.cl.configstrings[i].startsWith("*") ? CM.InlineModel(Globals.cl.configstrings[i]) : null;
            }
        } else if (i >= 288 && i < 544) {
            if (Globals.cl.refresh_prepped) {
                Globals.cl.sound_precache[i - 288] = S.RegisterSound(Globals.cl.configstrings[i]);
            }
        } else if (i >= 544 && i < 800) {
            if (Globals.cl.refresh_prepped) {
                Globals.cl.image_precache[i - 544] = Globals.re.RegisterPic(Globals.cl.configstrings[i]);
            }
        } else if (i >= 1312 && i < 1568 && Globals.cl.refresh_prepped && !olds.equals(s)) {
            CL_parse.ParseClientinfo(i - 1312);
        }
    }

    public static void ParseStartSoundPacket() {
        float[] pos;
        int ent;
        int channel;
        int flags = MSG.ReadByte(Globals.net_message);
        int sound_num = MSG.ReadByte(Globals.net_message);
        float volume = (flags & 1) != 0 ? (float)MSG.ReadByte(Globals.net_message) / 255.0f : 1.0f;
        float attenuation = (flags & 2) != 0 ? (float)MSG.ReadByte(Globals.net_message) / 64.0f : 1.0f;
        float ofs = (flags & 0x10) != 0 ? (float)MSG.ReadByte(Globals.net_message) / 1000.0f : 0.0f;
        if ((flags & 8) != 0) {
            channel = MSG.ReadShort(Globals.net_message);
            ent = channel >> 3;
            if (ent > 1024) {
                Com.Error(1, "CL_ParseStartSoundPacket: ent = " + ent);
            }
            channel &= 7;
        } else {
            ent = 0;
            channel = 0;
        }
        if ((flags & 4) != 0) {
            MSG.ReadPos(Globals.net_message, pos_v);
            pos = pos_v;
        } else {
            pos = null;
        }
        if (null == Globals.cl.sound_precache[sound_num]) {
            return;
        }
        S.StartSound(pos, ent, channel, Globals.cl.sound_precache[sound_num], volume, attenuation, ofs);
    }

    public static void SHOWNET(String s) {
        if (Globals.cl_shownet.value >= 2.0f) {
            Com.Printf(Globals.net_message.readcount - 1 + ":" + s + "\n");
        }
    }

    public static void ParseServerMessage() {
        block22: while (true) {
            if (Globals.net_message.readcount > Globals.net_message.cursize) {
                Com.Error(0, "CL_ParseServerMessage: Bad server message:");
                break;
            }
            int cmd = MSG.ReadByte(Globals.net_message);
            if (cmd == -1) {
                CL_parse.SHOWNET("END OF MESSAGE");
                break;
            }
            if (Globals.cl_shownet.value >= 2.0f) {
                if (null == svc_strings[cmd]) {
                    Com.Printf(Globals.net_message.readcount - 1 + ":BAD CMD " + cmd + "\n");
                } else {
                    CL_parse.SHOWNET(svc_strings[cmd]);
                }
            }
            switch (cmd) {
                default: {
                    Com.Error(1, "CL_ParseServerMessage: Illegible server message\n");
                    continue block22;
                }
                case 6: {
                    continue block22;
                }
                case 7: {
                    Com.Error(2, "Server disconnected\n");
                    continue block22;
                }
                case 8: {
                    Com.Printf("Server disconnected, reconnecting\n");
                    if (Globals.cls.download != null) {
                        try {
                            Globals.cls.download.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        Globals.cls.download = null;
                    }
                    Globals.cls.state = 2;
                    Globals.cls.connect_time = -99999.0f;
                    continue block22;
                }
                case 10: {
                    int i = MSG.ReadByte(Globals.net_message);
                    if (i == 3) {
                        S.StartLocalSound("misc/talk.wav");
                        Globals.con.ormask = 128;
                    }
                    Com.Printf(MSG.ReadString(Globals.net_message));
                    Globals.con.ormask = 0;
                    continue block22;
                }
                case 15: {
                    SCR.CenterPrint(MSG.ReadString(Globals.net_message));
                    continue block22;
                }
                case 11: {
                    String s = MSG.ReadString(Globals.net_message);
                    Com.DPrintf("stufftext: " + s + "\n");
                    Cbuf.AddText(s);
                    continue block22;
                }
                case 12: {
                    Cbuf.Execute();
                    CL_parse.ParseServerData();
                    continue block22;
                }
                case 13: {
                    CL_parse.ParseConfigString();
                    continue block22;
                }
                case 9: {
                    CL_parse.ParseStartSoundPacket();
                    continue block22;
                }
                case 14: {
                    CL_parse.ParseBaseline();
                    continue block22;
                }
                case 3: {
                    CL_tent.ParseTEnt();
                    continue block22;
                }
                case 1: {
                    CL_fx.ParseMuzzleFlash();
                    continue block22;
                }
                case 2: {
                    CL_fx.ParseMuzzleFlash2();
                    continue block22;
                }
                case 16: {
                    CL_parse.ParseDownload();
                    continue block22;
                }
                case 20: {
                    CL_ents.ParseFrame();
                    continue block22;
                }
                case 5: {
                    CL_inv.ParseInventory();
                    continue block22;
                }
                case 4: {
                    Globals.cl.layout = MSG.ReadString(Globals.net_message);
                    continue block22;
                }
                case 17: 
                case 18: 
                case 19: 
            }
            Com.Error(1, "Out of place frame data");
        }
        CL_view.AddNetgraph();
        if (Globals.cls.demorecording && !Globals.cls.demowaiting) {
            CL.WriteDemoMessage();
        }
    }
}

