/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL_fx;
import jake2.client.cl_sustain_t;
import jake2.client.cparticle_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class CL_newfx {
    private static final float[] move = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] vec = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] right = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] up = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] dir = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] end = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] r = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] u = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] forward = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] angle_dir = new float[]{0.0f, 0.0f, 0.0f};
    private static int[] wb_colortable = new int[]{16, 104, 168, 144};
    private static int[] nb_colortable = new int[]{110, 112, 114, 116};
    private static int[] ws_colortable = new int[]{16, 104, 168, 144};

    static void Flashlight(int ent, float[] pos) {
        CL_fx.cdlight_t dl = CL_fx.AllocDlight(ent);
        Math3D.VectorCopy(pos, dl.origin);
        dl.radius = 400.0f;
        dl.minlight = 250.0f;
        dl.die = Globals.cl.time + 100;
        dl.color[0] = 1.0f;
        dl.color[1] = 1.0f;
        dl.color[2] = 1.0f;
    }

    static void ColorFlash(float[] pos, int ent, int intensity, float r, float g, float b) {
        if (Globals.vidref_val == 2 && (r < 0.0f || g < 0.0f || b < 0.0f)) {
            intensity = -intensity;
            r = -r;
            g = -g;
            b = -b;
        }
        CL_fx.cdlight_t dl = CL_fx.AllocDlight(ent);
        Math3D.VectorCopy(pos, dl.origin);
        dl.radius = intensity;
        dl.minlight = 250.0f;
        dl.die = Globals.cl.time + 100;
        dl.color[0] = r;
        dl.color[1] = g;
        dl.color[2] = b;
    }

    static void DebugTrail(float[] start, float[] end) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        Math3D.MakeNormalVectors(vec, right, up);
        float dec = 3.0f;
        Math3D.VectorScale(vec, dec, vec);
        Math3D.VectorCopy(start, move);
        for (float len = Math3D.VectorNormalize(vec); len > 0.0f; len -= dec) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            Math3D.VectorClear(p.accel);
            Math3D.VectorClear(p.vel);
            p.alpha = 1.0f;
            p.alphavel = -0.1f;
            p.color = 116 + (Lib.rand() & 7);
            Math3D.VectorCopy(move, p.org);
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void ForceWall(float[] start, float[] end, int color) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        Math3D.VectorScale(vec, 4.0f, vec);
        while (len > 0.0f) {
            len -= 4.0f;
            if (CL_fx.free_particles == null) {
                return;
            }
            if ((double)Globals.rnd.nextFloat() > 0.3) {
                cparticle_t p = CL_fx.free_particles;
                CL_fx.free_particles = p.next;
                p.next = CL_fx.active_particles;
                CL_fx.active_particles = p;
                Math3D.VectorClear(p.accel);
                p.time = Globals.cl.time;
                p.alpha = 1.0f;
                p.alphavel = -1.0f / (3.0f + Globals.rnd.nextFloat() * 0.5f);
                p.color = color;
                for (int j = 0; j < 3; ++j) {
                    p.org[j] = move[j] + Lib.crand() * 3.0f;
                    p.accel[j] = 0.0f;
                }
                p.vel[0] = 0.0f;
                p.vel[1] = 0.0f;
                p.vel[2] = -40.0f - Lib.crand() * 10.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void BubbleTrail2(float[] start, float[] end, int dist) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        float dec = dist;
        Math3D.VectorScale(vec, dec, vec);
        int i = 0;
        while ((float)i < len) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.1f);
            p.color = 4 + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand() * 2.0f;
                p.vel[j] = Lib.crand() * 10.0f;
            }
            p.org[2] = p.org[2] - 4.0f;
            p.vel[2] = p.vel[2] + 20.0f;
            Math3D.VectorAdd(move, vec, move);
            i = (int)((float)i + dec);
        }
    }

    static void Heatbeam(float[] start, float[] forward) {
        float step = 32.0f;
        Math3D.VectorMA(start, 4096.0f, forward, end);
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        Math3D.VectorCopy(Globals.cl.v_right, right);
        Math3D.VectorCopy(Globals.cl.v_up, up);
        if (Globals.vidref_val == 1) {
            Math3D.VectorMA(move, -0.5f, right, move);
            Math3D.VectorMA(move, -0.5f, up, move);
        }
        float ltime = (float)Globals.cl.time / 1000.0f;
        float start_pt = ltime * 96.0f % step;
        Math3D.VectorMA(move, start_pt, vec, move);
        Math3D.VectorScale(vec, step, vec);
        float rstep = 0.31415927f;
        float M_PI2 = (float)Math.PI * 2;
        int i = (int)start_pt;
        while ((float)i < len && !((float)i > step * 5.0f)) {
            for (float rot = 0.0f; rot < M_PI2; rot += rstep) {
                if (CL_fx.free_particles == null) {
                    return;
                }
                cparticle_t p = CL_fx.free_particles;
                CL_fx.free_particles = p.next;
                p.next = CL_fx.active_particles;
                CL_fx.active_particles = p;
                p.time = Globals.cl.time;
                Math3D.VectorClear(p.accel);
                float variance = 0.5f;
                float c = (float)(Math.cos(rot) * (double)variance);
                float s = (float)(Math.sin(rot) * (double)variance);
                if (i < 10) {
                    Math3D.VectorScale(right, c * ((float)i / 10.0f), dir);
                    Math3D.VectorMA(dir, s * ((float)i / 10.0f), up, dir);
                } else {
                    Math3D.VectorScale(right, c, dir);
                    Math3D.VectorMA(dir, s, up, dir);
                }
                p.alpha = 0.5f;
                p.alphavel = -1000.0f;
                p.color = 223 - (Lib.rand() & 7);
                for (int j = 0; j < 3; ++j) {
                    p.org[j] = move[j] + dir[j] * 3.0f;
                    p.vel[j] = 0.0f;
                }
            }
            Math3D.VectorAdd(move, vec, move);
            i = (int)((float)i + step);
        }
    }

    static void ParticleSteamEffect(float[] org, float[] dir, int color, int count, int magnitude) {
        Math3D.MakeNormalVectors(dir, r, u);
        for (int i = 0; i < count; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            p.color = color + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)magnitude * 0.1f * Lib.crand();
            }
            Math3D.VectorScale(dir, magnitude, p.vel);
            float d = Lib.crand() * (float)magnitude / 3.0f;
            Math3D.VectorMA(p.vel, d, r, p.vel);
            d = Lib.crand() * (float)magnitude / 3.0f;
            Math3D.VectorMA(p.vel, d, u, p.vel);
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -20.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void ParticleSteamEffect2(cl_sustain_t self) {
        Math3D.VectorCopy(self.dir, dir);
        Math3D.MakeNormalVectors(dir, r, u);
        for (int i = 0; i < self.count; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            p.color = self.color + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = self.org[j] + (float)self.magnitude * 0.1f * Lib.crand();
            }
            Math3D.VectorScale(dir, self.magnitude, p.vel);
            float d = Lib.crand() * (float)self.magnitude / 3.0f;
            Math3D.VectorMA(p.vel, d, r, p.vel);
            d = Lib.crand() * (float)self.magnitude / 3.0f;
            Math3D.VectorMA(p.vel, d, u, p.vel);
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -20.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
        self.nextthink += self.thinkinterval;
    }

    static void TrackerTrail(float[] start, float[] end, int particleColor) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        Math3D.VectorCopy(vec, forward);
        Math3D.vectoangles(forward, angle_dir);
        Math3D.AngleVectors(angle_dir, forward, right, up);
        int dec = 3;
        Math3D.VectorScale(vec, 3.0f, vec);
        while (len > 0.0f) {
            len -= (float)dec;
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -2.0f;
            p.color = particleColor;
            float dist = Math3D.DotProduct(move, forward);
            Math3D.VectorMA(move, (float)(8.0 * Math.cos(dist)), up, p.org);
            for (int j = 0; j < 3; ++j) {
                p.vel[j] = 0.0f;
                p.accel[j] = 0.0f;
            }
            p.vel[2] = 5.0f;
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void Tracker_Shell(float[] origin) {
        for (int i = 0; i < 300; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -10000.0f;
            p.color = 0.0f;
            CL_newfx.dir[0] = Lib.crand();
            CL_newfx.dir[1] = Lib.crand();
            CL_newfx.dir[2] = Lib.crand();
            Math3D.VectorNormalize(dir);
            Math3D.VectorMA(origin, 40.0f, dir, p.org);
        }
    }

    static void MonsterPlasma_Shell(float[] origin) {
        for (int i = 0; i < 40; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -10000.0f;
            p.color = 224.0f;
            CL_newfx.dir[0] = Lib.crand();
            CL_newfx.dir[1] = Lib.crand();
            CL_newfx.dir[2] = Lib.crand();
            Math3D.VectorNormalize(dir);
            Math3D.VectorMA(origin, 10.0f, dir, p.org);
        }
    }

    static void Widowbeamout(cl_sustain_t self) {
        float ratio = 1.0f - ((float)self.endtime - (float)Globals.cl.time) / 2100.0f;
        for (int i = 0; i < 300; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -10000.0f;
            p.color = wb_colortable[Lib.rand() & 3];
            CL_newfx.dir[0] = Lib.crand();
            CL_newfx.dir[1] = Lib.crand();
            CL_newfx.dir[2] = Lib.crand();
            Math3D.VectorNormalize(dir);
            Math3D.VectorMA(self.org, 45.0f * ratio, dir, p.org);
        }
    }

    static void Nukeblast(cl_sustain_t self) {
        float ratio = 1.0f - ((float)self.endtime - (float)Globals.cl.time) / 1000.0f;
        for (int i = 0; i < 700; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -10000.0f;
            p.color = nb_colortable[Lib.rand() & 3];
            CL_newfx.dir[0] = Lib.crand();
            CL_newfx.dir[1] = Lib.crand();
            CL_newfx.dir[2] = Lib.crand();
            Math3D.VectorNormalize(dir);
            Math3D.VectorMA(self.org, 200.0f * ratio, dir, p.org);
        }
    }

    static void WidowSplash(float[] org) {
        for (int i = 0; i < 256; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            p.color = ws_colortable[Lib.rand() & 3];
            CL_newfx.dir[0] = Lib.crand();
            CL_newfx.dir[1] = Lib.crand();
            CL_newfx.dir[2] = Lib.crand();
            Math3D.VectorNormalize(dir);
            Math3D.VectorMA(org, 45.0f, dir, p.org);
            Math3D.VectorMA(Globals.vec3_origin, 40.0f, dir, p.vel);
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.alpha = 1.0f;
            p.alphavel = -0.8f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void TagTrail(float[] start, float[] end, float color) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        int dec = 5;
        Math3D.VectorScale(vec, 5.0f, vec);
        while (len >= 0.0f) {
            len -= (float)dec;
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.8f + Globals.rnd.nextFloat() * 0.2f);
            p.color = color;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand() * 16.0f;
                p.vel[j] = Lib.crand() * 5.0f;
                p.accel[j] = 0.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void ColorExplosionParticles(float[] org, int color, int run) {
        for (int i = 0; i < 128; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            p.color = color + Lib.rand() % run;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)(Lib.rand() % 32 - 16);
                p.vel[j] = Lib.rand() % 256 - 128;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -0.4f / (0.6f + Globals.rnd.nextFloat() * 0.2f);
        }
    }

    static void ParticleSmokeEffect(float[] org, float[] dir, int color, int count, int magnitude) {
        Math3D.MakeNormalVectors(dir, r, u);
        for (int i = 0; i < count; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            p.color = color + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)magnitude * 0.1f * Lib.crand();
            }
            Math3D.VectorScale(dir, magnitude, p.vel);
            float d = Lib.crand() * (float)magnitude / 3.0f;
            Math3D.VectorMA(p.vel, d, r, p.vel);
            d = Lib.crand() * (float)magnitude / 3.0f;
            Math3D.VectorMA(p.vel, d, u, p.vel);
            p.accel[2] = 0.0f;
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void BlasterParticles2(float[] org, float[] dir, long color) {
        int count = 40;
        for (int i = 0; i < count; ++i) {
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            p.time = Globals.cl.time;
            p.color = color + (long)(Lib.rand() & 7);
            float d = Lib.rand() & 0xF;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)((Lib.rand() & 7) - 4) + d * dir[j];
                p.vel[j] = dir[j] * 30.0f + Lib.crand() * 40.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void BlasterTrail2(float[] start, float[] end) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        int dec = 5;
        Math3D.VectorScale(vec, 5.0f, vec);
        while (len > 0.0f) {
            len -= (float)dec;
            if (CL_fx.free_particles == null) {
                return;
            }
            cparticle_t p = CL_fx.free_particles;
            CL_fx.free_particles = p.next;
            p.next = CL_fx.active_particles;
            CL_fx.active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.3f + Globals.rnd.nextFloat() * 0.2f);
            p.color = 208.0f;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand();
                p.vel[j] = Lib.crand() * 5.0f;
                p.accel[j] = 0.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }
}

