/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Defines;
import jake2.Globals;
import jake2.client.CL;
import jake2.client.Key;
import jake2.client.SCR;
import jake2.client.kbutton_t;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.game.usercmd_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.MSG;
import jake2.qcommon.Netchan;
import jake2.qcommon.SZ;
import jake2.qcommon.sizebuf_t;
import jake2.qcommon.xcommand_t;
import jake2.sys.IN;
import jake2.util.Lib;
import jake2.util.Math3D;

public class CL_input {
    static long frame_msec;
    static long old_sys_frame_time;
    static cvar_t cl_nodelta;
    static kbutton_t in_klook;
    static kbutton_t in_left;
    static kbutton_t in_right;
    static kbutton_t in_forward;
    static kbutton_t in_back;
    static kbutton_t in_lookup;
    static kbutton_t in_lookdown;
    static kbutton_t in_moveleft;
    static kbutton_t in_moveright;
    public static kbutton_t in_strafe;
    static kbutton_t in_speed;
    static kbutton_t in_use;
    static kbutton_t in_attack;
    static kbutton_t in_up;
    static kbutton_t in_down;
    static int in_impulse;
    private static final sizebuf_t buf;
    private static final byte[] data;
    private static final usercmd_t nullcmd;

    static void KeyDown(kbutton_t b) {
        String c = Cmd.Argv(1);
        int k = c.length() > 0 ? Lib.atoi(c) : -1;
        if (k == b.down[0] || k == b.down[1]) {
            return;
        }
        if (b.down[0] == 0) {
            b.down[0] = k;
        } else if (b.down[1] == 0) {
            b.down[1] = k;
        } else {
            Com.Printf("Three keys down for a button!\n");
            return;
        }
        if ((b.state & 1) != 0) {
            return;
        }
        c = Cmd.Argv(2);
        b.downtime = Lib.atoi(c);
        if (b.downtime == 0L) {
            b.downtime = Globals.sys_frame_time - 100;
        }
        b.state |= 3;
    }

    static void KeyUp(kbutton_t b) {
        String c = Cmd.Argv(1);
        if (c.length() <= 0) {
            b.down[1] = 0;
            b.down[0] = 0;
            b.state = 4;
            return;
        }
        int k = Lib.atoi(c);
        if (b.down[0] == k) {
            b.down[0] = 0;
        } else if (b.down[1] == k) {
            b.down[1] = 0;
        } else {
            return;
        }
        if (b.down[0] != 0 || b.down[1] != 0) {
            return;
        }
        if ((b.state & 1) == 0) {
            return;
        }
        c = Cmd.Argv(2);
        int uptime = Lib.atoi(c);
        b.msec = uptime != 0 ? (b.msec += (long)uptime - b.downtime) : (b.msec += 10L);
        b.state &= 0xFFFFFFFE;
        b.state |= 4;
    }

    static void IN_KLookDown() {
        CL_input.KeyDown(in_klook);
    }

    static void IN_KLookUp() {
        CL_input.KeyUp(in_klook);
    }

    static void IN_UpDown() {
        CL_input.KeyDown(in_up);
    }

    static void IN_UpUp() {
        CL_input.KeyUp(in_up);
    }

    static void IN_DownDown() {
        CL_input.KeyDown(in_down);
    }

    static void IN_DownUp() {
        CL_input.KeyUp(in_down);
    }

    static void IN_LeftDown() {
        CL_input.KeyDown(in_left);
    }

    static void IN_LeftUp() {
        CL_input.KeyUp(in_left);
    }

    static void IN_RightDown() {
        CL_input.KeyDown(in_right);
    }

    static void IN_RightUp() {
        CL_input.KeyUp(in_right);
    }

    static void IN_ForwardDown() {
        CL_input.KeyDown(in_forward);
    }

    static void IN_ForwardUp() {
        CL_input.KeyUp(in_forward);
    }

    static void IN_BackDown() {
        CL_input.KeyDown(in_back);
    }

    static void IN_BackUp() {
        CL_input.KeyUp(in_back);
    }

    static void IN_LookupDown() {
        CL_input.KeyDown(in_lookup);
    }

    static void IN_LookupUp() {
        CL_input.KeyUp(in_lookup);
    }

    static void IN_LookdownDown() {
        CL_input.KeyDown(in_lookdown);
    }

    static void IN_LookdownUp() {
        CL_input.KeyUp(in_lookdown);
    }

    static void IN_MoveleftDown() {
        CL_input.KeyDown(in_moveleft);
    }

    static void IN_MoveleftUp() {
        CL_input.KeyUp(in_moveleft);
    }

    static void IN_MoverightDown() {
        CL_input.KeyDown(in_moveright);
    }

    static void IN_MoverightUp() {
        CL_input.KeyUp(in_moveright);
    }

    static void IN_SpeedDown() {
        CL_input.KeyDown(in_speed);
    }

    static void IN_SpeedUp() {
        CL_input.KeyUp(in_speed);
    }

    static void IN_StrafeDown() {
        CL_input.KeyDown(in_strafe);
    }

    static void IN_StrafeUp() {
        CL_input.KeyUp(in_strafe);
    }

    static void IN_AttackDown() {
        CL_input.KeyDown(in_attack);
    }

    static void IN_AttackUp() {
        CL_input.KeyUp(in_attack);
    }

    static void IN_UseDown() {
        CL_input.KeyDown(in_use);
    }

    static void IN_UseUp() {
        CL_input.KeyUp(in_use);
    }

    static void IN_Impulse() {
        in_impulse = Lib.atoi(Cmd.Argv(1));
    }

    static float KeyState(kbutton_t key) {
        float val;
        key.state &= 1;
        long msec = key.msec;
        key.msec = 0L;
        if (key.state != 0) {
            msec += (long)Globals.sys_frame_time - key.downtime;
            key.downtime = Globals.sys_frame_time;
        }
        if ((val = (float)msec / (float)frame_msec) < 0.0f) {
            val = 0.0f;
        }
        if (val > 1.0f) {
            val = 1.0f;
        }
        return val;
    }

    static void AdjustAngles() {
        float speed = (CL_input.in_speed.state & 1) != 0 ? Globals.cls.frametime * Globals.cl_anglespeedkey.value : Globals.cls.frametime;
        if ((CL_input.in_strafe.state & 1) == 0) {
            Globals.cl.viewangles[1] = Globals.cl.viewangles[1] - speed * Globals.cl_yawspeed.value * CL_input.KeyState(in_right);
            Globals.cl.viewangles[1] = Globals.cl.viewangles[1] + speed * Globals.cl_yawspeed.value * CL_input.KeyState(in_left);
        }
        if ((CL_input.in_klook.state & 1) != 0) {
            Globals.cl.viewangles[0] = Globals.cl.viewangles[0] - speed * Globals.cl_pitchspeed.value * CL_input.KeyState(in_forward);
            Globals.cl.viewangles[0] = Globals.cl.viewangles[0] + speed * Globals.cl_pitchspeed.value * CL_input.KeyState(in_back);
        }
        float up = CL_input.KeyState(in_lookup);
        float down = CL_input.KeyState(in_lookdown);
        Globals.cl.viewangles[0] = Globals.cl.viewangles[0] - speed * Globals.cl_pitchspeed.value * up;
        Globals.cl.viewangles[0] = Globals.cl.viewangles[0] + speed * Globals.cl_pitchspeed.value * down;
    }

    static void BaseMove(usercmd_t cmd) {
        CL_input.AdjustAngles();
        cmd.clear();
        Math3D.VectorCopy(Globals.cl.viewangles, cmd.angles);
        if ((CL_input.in_strafe.state & 1) != 0) {
            cmd.sidemove = (short)((float)cmd.sidemove + Globals.cl_sidespeed.value * CL_input.KeyState(in_right));
            cmd.sidemove = (short)((float)cmd.sidemove - Globals.cl_sidespeed.value * CL_input.KeyState(in_left));
        }
        cmd.sidemove = (short)((float)cmd.sidemove + Globals.cl_sidespeed.value * CL_input.KeyState(in_moveright));
        cmd.sidemove = (short)((float)cmd.sidemove - Globals.cl_sidespeed.value * CL_input.KeyState(in_moveleft));
        cmd.upmove = (short)((float)cmd.upmove + Globals.cl_upspeed.value * CL_input.KeyState(in_up));
        cmd.upmove = (short)((float)cmd.upmove - Globals.cl_upspeed.value * CL_input.KeyState(in_down));
        if ((CL_input.in_klook.state & 1) == 0) {
            cmd.forwardmove = (short)((float)cmd.forwardmove + Globals.cl_forwardspeed.value * CL_input.KeyState(in_forward));
            cmd.forwardmove = (short)((float)cmd.forwardmove - Globals.cl_forwardspeed.value * CL_input.KeyState(in_back));
        }
        if ((CL_input.in_speed.state & 1 ^ (int)Globals.cl_run.value) != 0) {
            cmd.forwardmove = (short)(cmd.forwardmove * 2);
            cmd.sidemove = (short)(cmd.sidemove * 2);
            cmd.upmove = (short)(cmd.upmove * 2);
        }
    }

    static void ClampPitch() {
        float pitch = Math3D.SHORT2ANGLE(Globals.cl.frame.playerstate.pmove.delta_angles[0]);
        if (pitch > 180.0f) {
            pitch -= 360.0f;
        }
        if (Globals.cl.viewangles[0] + pitch < -360.0f) {
            Globals.cl.viewangles[0] = Globals.cl.viewangles[0] + 360.0f;
        }
        if (Globals.cl.viewangles[0] + pitch > 360.0f) {
            Globals.cl.viewangles[0] = Globals.cl.viewangles[0] - 360.0f;
        }
        if (Globals.cl.viewangles[0] + pitch > 89.0f) {
            Globals.cl.viewangles[0] = 89.0f - pitch;
        }
        if (Globals.cl.viewangles[0] + pitch < -89.0f) {
            Globals.cl.viewangles[0] = -89.0f - pitch;
        }
    }

    static void FinishMove(usercmd_t cmd) {
        int ms;
        if ((CL_input.in_attack.state & 3) != 0) {
            cmd.buttons = (byte)(cmd.buttons | 1);
        }
        CL_input.in_attack.state &= 0xFFFFFFFD;
        if ((CL_input.in_use.state & 3) != 0) {
            cmd.buttons = (byte)(cmd.buttons | 2);
        }
        CL_input.in_use.state &= 0xFFFFFFFD;
        if (Key.anykeydown != 0 && Globals.cls.key_dest == 0) {
            cmd.buttons = (byte)(cmd.buttons | 0x80);
        }
        if ((ms = (int)(Globals.cls.frametime * 1000.0f)) > 250) {
            ms = 100;
        }
        cmd.msec = (byte)ms;
        CL_input.ClampPitch();
        for (int i = 0; i < 3; ++i) {
            cmd.angles[i] = (short)Math3D.ANGLE2SHORT(Globals.cl.viewangles[i]);
        }
        cmd.impulse = (byte)in_impulse;
        in_impulse = 0;
        cmd.lightlevel = (byte)Globals.cl_lightlevel.value;
    }

    static void CreateCmd(usercmd_t cmd) {
        frame_msec = (long)Globals.sys_frame_time - old_sys_frame_time;
        if (frame_msec < 1L) {
            frame_msec = 1L;
        }
        if (frame_msec > 200L) {
            frame_msec = 200L;
        }
        CL_input.BaseMove(cmd);
        IN.Move(cmd);
        CL_input.FinishMove(cmd);
        old_sys_frame_time = Globals.sys_frame_time;
    }

    static void InitInput() {
        Cmd.AddCommand("centerview", new xcommand_t(){

            public void execute() {
                IN.CenterView();
            }
        });
        Cmd.AddCommand("+moveup", new xcommand_t(){

            public void execute() {
                CL_input.IN_UpDown();
            }
        });
        Cmd.AddCommand("-moveup", new xcommand_t(){

            public void execute() {
                CL_input.IN_UpUp();
            }
        });
        Cmd.AddCommand("+movedown", new xcommand_t(){

            public void execute() {
                CL_input.IN_DownDown();
            }
        });
        Cmd.AddCommand("-movedown", new xcommand_t(){

            public void execute() {
                CL_input.IN_DownUp();
            }
        });
        Cmd.AddCommand("+left", new xcommand_t(){

            public void execute() {
                CL_input.IN_LeftDown();
            }
        });
        Cmd.AddCommand("-left", new xcommand_t(){

            public void execute() {
                CL_input.IN_LeftUp();
            }
        });
        Cmd.AddCommand("+right", new xcommand_t(){

            public void execute() {
                CL_input.IN_RightDown();
            }
        });
        Cmd.AddCommand("-right", new xcommand_t(){

            public void execute() {
                CL_input.IN_RightUp();
            }
        });
        Cmd.AddCommand("+forward", new xcommand_t(){

            public void execute() {
                CL_input.IN_ForwardDown();
            }
        });
        Cmd.AddCommand("-forward", new xcommand_t(){

            public void execute() {
                CL_input.IN_ForwardUp();
            }
        });
        Cmd.AddCommand("+back", new xcommand_t(){

            public void execute() {
                CL_input.IN_BackDown();
            }
        });
        Cmd.AddCommand("-back", new xcommand_t(){

            public void execute() {
                CL_input.IN_BackUp();
            }
        });
        Cmd.AddCommand("+lookup", new xcommand_t(){

            public void execute() {
                CL_input.IN_LookupDown();
            }
        });
        Cmd.AddCommand("-lookup", new xcommand_t(){

            public void execute() {
                CL_input.IN_LookupUp();
            }
        });
        Cmd.AddCommand("+lookdown", new xcommand_t(){

            public void execute() {
                CL_input.IN_LookdownDown();
            }
        });
        Cmd.AddCommand("-lookdown", new xcommand_t(){

            public void execute() {
                CL_input.IN_LookdownUp();
            }
        });
        Cmd.AddCommand("+strafe", new xcommand_t(){

            public void execute() {
                CL_input.IN_StrafeDown();
            }
        });
        Cmd.AddCommand("-strafe", new xcommand_t(){

            public void execute() {
                CL_input.IN_StrafeUp();
            }
        });
        Cmd.AddCommand("+moveleft", new xcommand_t(){

            public void execute() {
                CL_input.IN_MoveleftDown();
            }
        });
        Cmd.AddCommand("-moveleft", new xcommand_t(){

            public void execute() {
                CL_input.IN_MoveleftUp();
            }
        });
        Cmd.AddCommand("+moveright", new xcommand_t(){

            public void execute() {
                CL_input.IN_MoverightDown();
            }
        });
        Cmd.AddCommand("-moveright", new xcommand_t(){

            public void execute() {
                CL_input.IN_MoverightUp();
            }
        });
        Cmd.AddCommand("+speed", new xcommand_t(){

            public void execute() {
                CL_input.IN_SpeedDown();
            }
        });
        Cmd.AddCommand("-speed", new xcommand_t(){

            public void execute() {
                CL_input.IN_SpeedUp();
            }
        });
        Cmd.AddCommand("+attack", new xcommand_t(){

            public void execute() {
                CL_input.IN_AttackDown();
            }
        });
        Cmd.AddCommand("-attack", new xcommand_t(){

            public void execute() {
                CL_input.IN_AttackUp();
            }
        });
        Cmd.AddCommand("+use", new xcommand_t(){

            public void execute() {
                CL_input.IN_UseDown();
            }
        });
        Cmd.AddCommand("-use", new xcommand_t(){

            public void execute() {
                CL_input.IN_UseUp();
            }
        });
        Cmd.AddCommand("impulse", new xcommand_t(){

            public void execute() {
                CL_input.IN_Impulse();
            }
        });
        Cmd.AddCommand("+klook", new xcommand_t(){

            public void execute() {
                CL_input.IN_KLookDown();
            }
        });
        Cmd.AddCommand("-klook", new xcommand_t(){

            public void execute() {
                CL_input.IN_KLookUp();
            }
        });
        cl_nodelta = Cvar.Get("cl_nodelta", "0", 0);
    }

    static void SendCmd() {
        int i = Globals.cls.netchan.outgoing_sequence & Defines.CMD_BACKUP - 1;
        usercmd_t cmd = Globals.cl.cmds[i];
        Globals.cl.cmd_time[i] = Globals.cls.realtime;
        CL_input.CreateCmd(cmd);
        Globals.cl.cmd.set(cmd);
        if (Globals.cls.state == 1 || Globals.cls.state == 2) {
            return;
        }
        if (Globals.cls.state == 3) {
            if (Globals.cls.netchan.message.cursize != 0 || Globals.curtime - Globals.cls.netchan.last_sent > 1000) {
                Netchan.Transmit(Globals.cls.netchan, 0, new byte[0]);
            }
            return;
        }
        if (Globals.userinfo_modified) {
            CL.FixUpGender();
            Globals.userinfo_modified = false;
            MSG.WriteByte(Globals.cls.netchan.message, 3);
            MSG.WriteString(Globals.cls.netchan.message, Cvar.Userinfo());
        }
        SZ.Init(buf, data, data.length);
        if (cmd.buttons != 0 && Globals.cl.cinematictime > 0 && !Globals.cl.attractloop && Globals.cls.realtime - Globals.cl.cinematictime > 1000) {
            SCR.FinishCinematic();
        }
        MSG.WriteByte(buf, 2);
        int checksumIndex = CL_input.buf.cursize;
        MSG.WriteByte(buf, 0);
        if (CL_input.cl_nodelta.value != 0.0f || !Globals.cl.frame.valid || Globals.cls.demowaiting) {
            MSG.WriteLong(buf, -1);
        } else {
            MSG.WriteLong(buf, Globals.cl.frame.serverframe);
        }
        i = Globals.cls.netchan.outgoing_sequence - 2 & Defines.CMD_BACKUP - 1;
        cmd = Globals.cl.cmds[i];
        nullcmd.clear();
        MSG.WriteDeltaUsercmd(buf, nullcmd, cmd);
        usercmd_t oldcmd = cmd;
        i = Globals.cls.netchan.outgoing_sequence - 1 & Defines.CMD_BACKUP - 1;
        cmd = Globals.cl.cmds[i];
        MSG.WriteDeltaUsercmd(buf, oldcmd, cmd);
        oldcmd = cmd;
        i = Globals.cls.netchan.outgoing_sequence & Defines.CMD_BACKUP - 1;
        cmd = Globals.cl.cmds[i];
        MSG.WriteDeltaUsercmd(buf, oldcmd, cmd);
        CL_input.buf.data[checksumIndex] = Com.BlockSequenceCRCByte(CL_input.buf.data, checksumIndex + 1, CL_input.buf.cursize - checksumIndex - 1, Globals.cls.netchan.outgoing_sequence);
        Netchan.Transmit(Globals.cls.netchan, CL_input.buf.cursize, CL_input.buf.data);
    }

    static {
        in_klook = new kbutton_t();
        in_left = new kbutton_t();
        in_right = new kbutton_t();
        in_forward = new kbutton_t();
        in_back = new kbutton_t();
        in_lookup = new kbutton_t();
        in_lookdown = new kbutton_t();
        in_moveleft = new kbutton_t();
        in_moveright = new kbutton_t();
        in_strafe = new kbutton_t();
        in_speed = new kbutton_t();
        in_use = new kbutton_t();
        in_attack = new kbutton_t();
        in_up = new kbutton_t();
        in_down = new kbutton_t();
        buf = new sizebuf_t();
        data = new byte[128];
        nullcmd = new usercmd_t();
    }
}

