/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL_tent;
import jake2.client.V;
import jake2.client.centity_t;
import jake2.client.cparticle_t;
import jake2.client.entity_t;
import jake2.game.entity_state_t;
import jake2.game.monsters.M_Flash;
import jake2.qcommon.Com;
import jake2.qcommon.MSG;
import jake2.sound.S;
import jake2.util.Lib;
import jake2.util.Math3D;

public class CL_fx {
    static cparticle_t[] particles;
    static int cl_numparticles;
    static final float INSTANT_PARTICLE = -10000.0f;
    static float[][] avelocities;
    static clightstyle_t[] cl_lightstyle;
    static int lastofs;
    static cdlight_t[] cl_dlights;
    private static final float[] fv;
    private static final float[] rv;
    private static final float[] origin;
    private static final float[] forward;
    private static final float[] right;
    private static final float[] move;
    private static final float[] vec;
    private static final float[] v;
    private static final float[] start;
    private static final float[] end;
    private static final float[] dir;
    private static final float[] org;
    static final int PARTICLE_GRAVITY = 40;
    static cparticle_t active_particles;
    static cparticle_t free_particles;
    private static int[] colortable;
    private static final int BEAMLENGTH = 16;

    static void ClearDlights() {
        for (int i = 0; i < cl_dlights.length; ++i) {
            cl_dlights[i].clear();
        }
    }

    static void ClearLightStyles() {
        for (int i = 0; i < cl_lightstyle.length; ++i) {
            cl_lightstyle[i].clear();
        }
        lastofs = -1;
    }

    static void RunLightStyles() {
        int ofs = Globals.cl.time / 100;
        if (ofs == lastofs) {
            return;
        }
        lastofs = ofs;
        for (int i = 0; i < cl_lightstyle.length; ++i) {
            clightstyle_t ls = cl_lightstyle[i];
            if (ls.length == 0) {
                ls.value[2] = 1.0f;
                ls.value[1] = 1.0f;
                ls.value[0] = 1.0f;
                continue;
            }
            if (ls.length == 1) {
                ls.value[1] = ls.value[2] = ls.map[0];
                ls.value[0] = ls.value[2];
                continue;
            }
            ls.value[1] = ls.value[2] = ls.map[ofs % ls.length];
            ls.value[0] = ls.value[2];
        }
    }

    static void SetLightstyle(int i) {
        String s = Globals.cl.configstrings[i + 800];
        int j = s.length();
        if (j >= 64) {
            Com.Error(1, "svc_lightstyle length=" + j);
        }
        CL_fx.cl_lightstyle[i].length = j;
        for (int k = 0; k < j; ++k) {
            CL_fx.cl_lightstyle[i].map[k] = (float)(s.charAt(k) - 97) / 12.0f;
        }
    }

    static void AddLightStyles() {
        for (int i = 0; i < cl_lightstyle.length; ++i) {
            clightstyle_t ls = cl_lightstyle[i];
            V.AddLightStyle(i, ls.value[0], ls.value[1], ls.value[2]);
        }
    }

    static cdlight_t AllocDlight(int key) {
        cdlight_t dl;
        int i;
        if (key != 0) {
            for (i = 0; i < 32; ++i) {
                dl = cl_dlights[i];
                if (dl.key != key) continue;
                dl.clear();
                dl.key = key;
                return dl;
            }
        }
        for (i = 0; i < 32; ++i) {
            dl = cl_dlights[i];
            if (!(dl.die < (float)Globals.cl.time)) continue;
            dl.clear();
            dl.key = key;
            return dl;
        }
        dl = cl_dlights[0];
        dl.clear();
        dl.key = key;
        return dl;
    }

    static void RunDLights() {
        for (int i = 0; i < 32; ++i) {
            cdlight_t dl = cl_dlights[i];
            if (dl.radius == 0.0f || !(dl.die < (float)Globals.cl.time)) continue;
            dl.radius = 0.0f;
            return;
        }
    }

    static void ParseMuzzleFlash() {
        short i = MSG.ReadShort(Globals.net_message);
        if (i < 1 || i >= 1024) {
            Com.Error(1, "CL_ParseMuzzleFlash: bad entity");
        }
        int weapon = MSG.ReadByte(Globals.net_message);
        int silenced = weapon & 0x80;
        weapon &= 0xFFFFFF7F;
        centity_t pl = Globals.cl_entities[i];
        cdlight_t dl = CL_fx.AllocDlight(i);
        Math3D.VectorCopy(pl.current.origin, dl.origin);
        Math3D.AngleVectors(pl.current.angles, fv, rv, null);
        Math3D.VectorMA(dl.origin, 18.0f, fv, dl.origin);
        Math3D.VectorMA(dl.origin, 16.0f, rv, dl.origin);
        dl.radius = silenced != 0 ? (float)(100 + (Globals.rnd.nextInt() & 0x1F)) : (float)(200 + (Globals.rnd.nextInt() & 0x1F));
        dl.minlight = 32.0f;
        dl.die = Globals.cl.time;
        float volume = silenced != 0 ? 0.2f : 1.0f;
        switch (weapon) {
            case 0: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/blastf1a.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 17: {
                dl.color[0] = 0.0f;
                dl.color[1] = 0.0f;
                dl.color[2] = 1.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/hyprbf1a.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 14: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/hyprbf1a.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 1: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                String soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.0f);
                break;
            }
            case 2: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/shotgf1b.wav"), volume, 1.0f, 0.0f);
                S.StartSound(null, i, 0, S.RegisterSound("weapons/shotgr1b.wav"), volume, 1.0f, 0.1f);
                break;
            }
            case 13: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/sshotf1b.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 3: {
                dl.radius = 200 + (Globals.rnd.nextInt() & 0x1F);
                dl.color[0] = 1.0f;
                dl.color[1] = 0.25f;
                dl.color[2] = 0.0f;
                String soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.0f);
                break;
            }
            case 4: {
                dl.radius = 225 + (Globals.rnd.nextInt() & 0x1F);
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.0f;
                dl.die = (float)Globals.cl.time + 0.1f;
                String soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.0f);
                soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.05f);
                break;
            }
            case 5: {
                dl.radius = 250 + (Globals.rnd.nextInt() & 0x1F);
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                dl.die = (float)Globals.cl.time + 0.1f;
                String soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.0f);
                soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.033f);
                soundname = "weapons/machgf" + (Globals.rnd.nextInt(5) + 1) + "b.wav";
                S.StartSound(null, i, 1, S.RegisterSound(soundname), volume, 1.0f, 0.066f);
                break;
            }
            case 6: {
                dl.color[0] = 0.5f;
                dl.color[1] = 0.5f;
                dl.color[2] = 1.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/railgf1a.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 7: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.2f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/rocklf1a.wav"), volume, 1.0f, 0.0f);
                S.StartSound(null, i, 0, S.RegisterSound("weapons/rocklr1b.wav"), volume, 1.0f, 0.1f);
                break;
            }
            case 8: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/grenlf1a.wav"), volume, 1.0f, 0.0f);
                S.StartSound(null, i, 0, S.RegisterSound("weapons/grenlr1b.wav"), volume, 1.0f, 0.1f);
                break;
            }
            case 12: {
                dl.color[0] = 0.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/bfg__f1y.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 9: {
                dl.color[0] = 0.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                dl.die = (float)Globals.cl.time + 1.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/grenlf1a.wav"), 1.0f, 1.0f, 0.0f);
                CL_fx.LogoutEffect(pl.current.origin, weapon);
                break;
            }
            case 10: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.0f;
                dl.color[2] = 0.0f;
                dl.die = (float)Globals.cl.time + 1.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/grenlf1a.wav"), 1.0f, 1.0f, 0.0f);
                CL_fx.LogoutEffect(pl.current.origin, weapon);
                break;
            }
            case 11: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                dl.die = (float)Globals.cl.time + 1.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/grenlf1a.wav"), 1.0f, 1.0f, 0.0f);
                CL_fx.LogoutEffect(pl.current.origin, weapon);
                break;
            }
            case 18: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.5f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/plasshot.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 16: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.5f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/rippfire.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 30: {
                dl.color[0] = 0.9f;
                dl.color[1] = 0.7f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/nail1.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 32: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/shotg2.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 33: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                dl.die = Globals.cl.time + 100;
                break;
            }
            case 34: {
                dl.color[0] = 0.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/blastf1a.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 35: {
                dl.color[0] = -1.0f;
                dl.color[1] = -1.0f;
                dl.color[2] = -1.0f;
                S.StartSound(null, i, 1, S.RegisterSound("weapons/disint2.wav"), volume, 1.0f, 0.0f);
                break;
            }
            case 36: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.0f;
                dl.color[2] = 0.0f;
                dl.die = Globals.cl.time + 100;
                break;
            }
            case 37: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                dl.die = Globals.cl.time + 100;
                break;
            }
            case 38: {
                dl.color[0] = 0.0f;
                dl.color[1] = 0.0f;
                dl.color[2] = 1.0f;
                dl.die = Globals.cl.time + 100;
                break;
            }
            case 39: {
                dl.color[0] = 0.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 1.0f;
                dl.die = Globals.cl.time + 100;
            }
        }
    }

    static void ParseMuzzleFlash2() {
        short ent = MSG.ReadShort(Globals.net_message);
        if (ent < 1 || ent >= 1024) {
            Com.Error(1, "CL_ParseMuzzleFlash2: bad entity");
        }
        int flash_number = MSG.ReadByte(Globals.net_message);
        Math3D.AngleVectors(Globals.cl_entities[ent].current.angles, forward, right, null);
        CL_fx.origin[0] = Globals.cl_entities[ent].current.origin[0] + forward[0] * M_Flash.monster_flash_offset[flash_number][0] + right[0] * M_Flash.monster_flash_offset[flash_number][1];
        CL_fx.origin[1] = Globals.cl_entities[ent].current.origin[1] + forward[1] * M_Flash.monster_flash_offset[flash_number][0] + right[1] * M_Flash.monster_flash_offset[flash_number][1];
        CL_fx.origin[2] = Globals.cl_entities[ent].current.origin[2] + forward[2] * M_Flash.monster_flash_offset[flash_number][0] + right[2] * M_Flash.monster_flash_offset[flash_number][1] + M_Flash.monster_flash_offset[flash_number][2];
        cdlight_t dl = CL_fx.AllocDlight(ent);
        Math3D.VectorCopy(origin, dl.origin);
        dl.radius = 200 + (Globals.rnd.nextInt() & 0x1F);
        dl.minlight = 32.0f;
        dl.die = Globals.cl.time;
        switch (flash_number) {
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("infantry/infatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 43: 
            case 44: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("soldier/solatck3.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("gunner/gunatck2.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 141: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("infantry/infatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 138: 
            case 152: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("infantry/infatck1.wav"), 1.0f, 0.0f, 0.0f);
                break;
            }
            case 39: 
            case 40: 
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 143: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("soldier/solatck2.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 58: 
            case 59: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("flyer/flyatck3.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 60: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("medic/medatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 62: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("hover/hovatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 82: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("floater/fltatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 41: 
            case 42: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("soldier/solatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("tank/tnkatck3.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                String soundname = "tank/tnkatk2" + (char)(97 + Globals.rnd.nextInt(5)) + ".wav";
                S.StartSound(null, ent, 1, S.RegisterSound(soundname), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 57: 
            case 142: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.2f;
                S.StartSound(null, ent, 1, S.RegisterSound("chick/chkatck2.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.2f;
                S.StartSound(null, ent, 1, S.RegisterSound("tank/tnkatck1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 191: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.2f;
                S.StartSound(null, ent, 1, S.RegisterSound("tank/rocket.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                dl.color[0] = 1.0f;
                dl.color[1] = 0.5f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("gunner/gunatck3.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 61: 
            case 147: 
            case 150: {
                dl.color[0] = 0.5f;
                dl.color[1] = 0.5f;
                dl.color[2] = 1.0f;
                break;
            }
            case 101: {
                dl.color[0] = 0.5f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.5f;
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("makron/blaster.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                S.StartSound(null, ent, 1, S.RegisterSound("boss3/xfire.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                break;
            }
            case 132: {
                dl.color[0] = 0.5f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.5f;
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 153: {
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                CL_fx.ParticleEffect(origin, Globals.vec3_origin, 0, 40);
                CL_tent.SmokeAndFlash(origin);
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 149: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: {
                dl.color[0] = 0.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("tank/tnkatck3.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 148: {
                dl.color[0] = -1.0f;
                dl.color[1] = -1.0f;
                dl.color[2] = -1.0f;
                S.StartSound(null, ent, 1, S.RegisterSound("weapons/disint2.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 151: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: {
                dl.radius = 300 + (Globals.rnd.nextInt() & 0x64);
                dl.color[0] = 1.0f;
                dl.color[1] = 1.0f;
                dl.color[2] = 0.0f;
                dl.die = Globals.cl.time + 200;
            }
        }
    }

    static void AddDLights() {
        if (Globals.vidref_val == 1) {
            for (int i = 0; i < 32; ++i) {
                cdlight_t dl = cl_dlights[i];
                if (dl.radius == 0.0f) continue;
                V.AddLight(dl.origin, dl.radius, dl.color[0], dl.color[1], dl.color[2]);
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                cdlight_t dl = cl_dlights[i];
                if (dl.radius == 0.0f) continue;
                if (dl.color[0] < 0.0f || dl.color[1] < 0.0f || dl.color[2] < 0.0f) {
                    dl.radius = -dl.radius;
                    dl.color[0] = 1.0f;
                    dl.color[1] = 1.0f;
                    dl.color[2] = 1.0f;
                }
                V.AddLight(dl.origin, dl.radius, dl.color[0], dl.color[1], dl.color[2]);
            }
        }
    }

    static void ClearParticles() {
        free_particles = particles[0];
        active_particles = null;
        for (int i = 0; i < particles.length - 1; ++i) {
            CL_fx.particles[i].next = particles[i + 1];
        }
        CL_fx.particles[CL_fx.particles.length - 1].next = null;
    }

    static void ParticleEffect(float[] org, float[] dir, int color, int count) {
        for (int i = 0; i < count; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = color + (Lib.rand() & 7);
            float d = Lib.rand() & 0x1F;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)((Lib.rand() & 7) - 4) + d * dir[j];
                p.vel[j] = Lib.crand() * 20.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void ParticleEffect2(float[] org, float[] dir, int color, int count) {
        for (int i = 0; i < count; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = color;
            float d = Lib.rand() & 7;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)((Lib.rand() & 7) - 4) + d * dir[j];
                p.vel[j] = Lib.crand() * 20.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void ParticleEffect3(float[] org, float[] dir, int color, int count) {
        for (int i = 0; i < count; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = color;
            float d = Lib.rand() & 7;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)((Lib.rand() & 7) - 4) + d * dir[j];
                p.vel[j] = Lib.crand() * 20.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = 40.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void TeleporterParticles(entity_state_t ent) {
        for (int i = 0; i < 8; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = 219.0f;
            for (int j = 0; j < 2; ++j) {
                p.org[j] = ent.origin[j] - 16.0f + (float)(Lib.rand() & 0x1F);
                p.vel[j] = Lib.crand() * 14.0f;
            }
            p.org[2] = ent.origin[2] - 8.0f + (float)(Lib.rand() & 7);
            p.vel[2] = 80 + (Lib.rand() & 7);
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -0.5f;
        }
    }

    static void LogoutEffect(float[] org, int type) {
        for (int i = 0; i < 500; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = type == 9 ? (float)(208 + (Lib.rand() & 7)) : (type == 10 ? (float)(64 + (Lib.rand() & 7)) : (float)(224 + (Lib.rand() & 7)));
            p.org[0] = org[0] - 16.0f + Globals.rnd.nextFloat() * 32.0f;
            p.org[1] = org[1] - 16.0f + Globals.rnd.nextFloat() * 32.0f;
            p.org[2] = org[2] - 24.0f + Globals.rnd.nextFloat() * 56.0f;
            for (int j = 0; j < 3; ++j) {
                p.vel[j] = Lib.crand() * 20.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void ItemRespawnParticles(float[] org) {
        for (int i = 0; i < 64; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = 212 + (Lib.rand() & 3);
            p.org[0] = org[0] + Lib.crand() * 8.0f;
            p.org[1] = org[1] + Lib.crand() * 8.0f;
            p.org[2] = org[2] + Lib.crand() * 8.0f;
            for (int j = 0; j < 3; ++j) {
                p.vel[j] = Lib.crand() * 8.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -8.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void ExplosionParticles(float[] org) {
        for (int i = 0; i < 256; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = 224 + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)(Lib.rand() % 32 - 16);
                p.vel[j] = Lib.rand() % 384 - 192;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -0.8f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void BigTeleportParticles(float[] org) {
        for (int i = 0; i < 4096; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = colortable[Lib.rand() & 3];
            float angle = (float)(Math.PI * 2 * (double)(Lib.rand() & 0x3FF) / 1023.0);
            float dist = Lib.rand() & 0x1F;
            p.org[0] = (float)((double)org[0] + Math.cos(angle) * (double)dist);
            p.vel[0] = (float)(Math.cos(angle) * (double)(70 + (Lib.rand() & 0x3F)));
            p.accel[0] = (float)(-Math.cos(angle) * 100.0);
            p.org[1] = (float)((double)org[1] + Math.sin(angle) * (double)dist);
            p.vel[1] = (float)(Math.sin(angle) * (double)(70 + (Lib.rand() & 0x3F)));
            p.accel[1] = (float)(-Math.sin(angle) * 100.0);
            p.org[2] = org[2] + 8.0f + (float)(Lib.rand() % 90);
            p.vel[2] = -100 + (Lib.rand() & 0x1F);
            p.accel[2] = 160.0f;
            p.alpha = 1.0f;
            p.alphavel = -0.3f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void BlasterParticles(float[] org, float[] dir) {
        int count = 40;
        for (int i = 0; i < count; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = 224 + (Lib.rand() & 7);
            float d = Lib.rand() & 0xF;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)((Lib.rand() & 7) - 4) + d * dir[j];
                p.vel[j] = dir[j] * 30.0f + Lib.crand() * 40.0f;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void BlasterTrail(float[] start, float[] end) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        int dec = 5;
        Math3D.VectorScale(vec, 5.0f, vec);
        while (len > 0.0f) {
            len -= (float)dec;
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.3f + Globals.rnd.nextFloat() * 0.2f);
            p.color = 224.0f;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand();
                p.vel[j] = Lib.crand() * 5.0f;
                p.accel[j] = 0.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void FlagTrail(float[] start, float[] end, float color) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        int dec = 5;
        Math3D.VectorScale(vec, 5.0f, vec);
        while (len > 0.0f) {
            len -= (float)dec;
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.8f + Globals.rnd.nextFloat() * 0.2f);
            p.color = color;
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand() * 16.0f;
                p.vel[j] = Lib.crand() * 5.0f;
                p.accel[j] = 0.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void DiminishingTrail(float[] start, float[] end, centity_t old, int flags) {
        float velscale;
        float orgscale;
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        float dec = 0.5f;
        Math3D.VectorScale(vec, dec, vec);
        if (old.trailcount > 900) {
            orgscale = 4.0f;
            velscale = 15.0f;
        } else if (old.trailcount > 800) {
            orgscale = 2.0f;
            velscale = 10.0f;
        } else {
            orgscale = 1.0f;
            velscale = 5.0f;
        }
        while (len > 0.0f) {
            len -= dec;
            if (free_particles == null) {
                return;
            }
            if ((Lib.rand() & 0x3FF) < old.trailcount) {
                int j;
                cparticle_t p = free_particles;
                free_particles = p.next;
                p.next = active_particles;
                active_particles = p;
                Math3D.VectorClear(p.accel);
                p.time = Globals.cl.time;
                if ((flags & 2) != 0) {
                    p.alpha = 1.0f;
                    p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.4f);
                    p.color = 232 + (Lib.rand() & 7);
                    for (j = 0; j < 3; ++j) {
                        p.org[j] = move[j] + Lib.crand() * orgscale;
                        p.vel[j] = Lib.crand() * velscale;
                        p.accel[j] = 0.0f;
                    }
                    p.vel[2] = p.vel[2] - 40.0f;
                } else if ((flags & 0x200000) != 0) {
                    p.alpha = 1.0f;
                    p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.4f);
                    p.color = 219 + (Lib.rand() & 7);
                    for (j = 0; j < 3; ++j) {
                        p.org[j] = move[j] + Lib.crand() * orgscale;
                        p.vel[j] = Lib.crand() * velscale;
                        p.accel[j] = 0.0f;
                    }
                    p.vel[2] = p.vel[2] - 40.0f;
                } else {
                    p.alpha = 1.0f;
                    p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.2f);
                    p.color = 4 + (Lib.rand() & 7);
                    for (j = 0; j < 3; ++j) {
                        p.org[j] = move[j] + Lib.crand() * orgscale;
                        p.vel[j] = Lib.crand() * velscale;
                    }
                    p.accel[2] = 20.0f;
                }
            }
            old.trailcount -= 5;
            if (old.trailcount < 100) {
                old.trailcount = 100;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void RocketTrail(float[] start, float[] end, centity_t old) {
        CL_fx.DiminishingTrail(start, end, old, 16);
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        float dec = 1.0f;
        Math3D.VectorScale(vec, dec, vec);
        while (len > 0.0f) {
            len -= dec;
            if (free_particles == null) {
                return;
            }
            if ((Lib.rand() & 7) == 0) {
                cparticle_t p = free_particles;
                free_particles = p.next;
                p.next = active_particles;
                active_particles = p;
                Math3D.VectorClear(p.accel);
                p.time = Globals.cl.time;
                p.alpha = 1.0f;
                p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.2f);
                p.color = 220 + (Lib.rand() & 3);
                for (int j = 0; j < 3; ++j) {
                    p.org[j] = move[j] + Lib.crand() * 5.0f;
                    p.vel[j] = Lib.crand() * 20.0f;
                }
                p.accel[2] = -40.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void RailTrail(float[] start, float[] end) {
        int j;
        cparticle_t p;
        float[] right = new float[3];
        float[] up = new float[3];
        float[] dir = new float[3];
        int clr = 116;
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        Math3D.MakeNormalVectors(vec, right, up);
        int i = 0;
        while ((float)i < len) {
            if (free_particles == null) {
                return;
            }
            p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            Math3D.VectorClear(p.accel);
            float d = (float)i * 0.1f;
            float c = (float)Math.cos(d);
            float s = (float)Math.sin(d);
            Math3D.VectorScale(right, c, dir);
            Math3D.VectorMA(dir, s, up, dir);
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.2f);
            p.color = clr + (Lib.rand() & 7);
            for (j = 0; j < 3; ++j) {
                p.org[j] = move[j] + dir[j] * 3.0f;
                p.vel[j] = dir[j] * 6.0f;
            }
            Math3D.VectorAdd(move, vec, move);
            ++i;
        }
        float dec = 0.75f;
        Math3D.VectorScale(vec, dec, vec);
        Math3D.VectorCopy(start, move);
        while (len > 0.0f) {
            len -= dec;
            if (free_particles == null) {
                return;
            }
            p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            Math3D.VectorClear(p.accel);
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.6f + Globals.rnd.nextFloat() * 0.2f);
            p.color = 0 + Lib.rand() & 0xF;
            for (j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand() * 3.0f;
                p.vel[j] = Lib.crand() * 3.0f;
                p.accel[j] = 0.0f;
            }
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void IonripperTrail(float[] start, float[] ent) {
        boolean left = false;
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(ent, start, vec);
        float len = Math3D.VectorNormalize(vec);
        int dec = 5;
        Math3D.VectorScale(vec, 5.0f, vec);
        while (len > 0.0f) {
            len -= (float)dec;
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 0.5f;
            p.alphavel = -1.0f / (0.3f + Globals.rnd.nextFloat() * 0.2f);
            p.color = 228 + (Lib.rand() & 3);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j];
                p.accel[j] = 0.0f;
            }
            if (left) {
                left = false;
                p.vel[0] = 10.0f;
            } else {
                left = true;
                p.vel[0] = -10.0f;
            }
            p.vel[1] = 0.0f;
            p.vel[2] = 0.0f;
            Math3D.VectorAdd(move, vec, move);
        }
    }

    static void BubbleTrail(float[] start, float[] end) {
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        float dec = 32.0f;
        Math3D.VectorScale(vec, dec, vec);
        int i = 0;
        while ((float)i < len) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (1.0f + Globals.rnd.nextFloat() * 0.2f);
            p.color = 4 + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand() * 2.0f;
                p.vel[j] = Lib.crand() * 5.0f;
            }
            p.vel[2] = p.vel[2] + 6.0f;
            Math3D.VectorAdd(move, vec, move);
            i = (int)((float)i + dec);
        }
    }

    static void FlyParticles(float[] origin, int count) {
        int i;
        float dist = 64.0f;
        if (count > 162) {
            count = 162;
        }
        if (avelocities[0][0] == 0.0f) {
            for (i = 0; i < 162; ++i) {
                CL_fx.avelocities[i][0] = (float)(Lib.rand() & 0xFF) * 0.01f;
                CL_fx.avelocities[i][1] = (float)(Lib.rand() & 0xFF) * 0.01f;
                CL_fx.avelocities[i][2] = (float)(Lib.rand() & 0xFF) * 0.01f;
            }
        }
        float ltime = (float)Globals.cl.time / 1000.0f;
        for (i = 0; i < count; i += 2) {
            float angle = ltime * avelocities[i][0];
            float sy = (float)Math.sin(angle);
            float cy = (float)Math.cos(angle);
            angle = ltime * avelocities[i][1];
            float sp = (float)Math.sin(angle);
            float cp = (float)Math.cos(angle);
            angle = ltime * avelocities[i][2];
            CL_fx.forward[0] = cp * cy;
            CL_fx.forward[1] = cp * sy;
            CL_fx.forward[2] = -sp;
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            dist = (float)Math.sin(ltime + (float)i) * 64.0f;
            p.org[0] = origin[0] + Globals.bytedirs[i][0] * dist + forward[0] * 16.0f;
            p.org[1] = origin[1] + Globals.bytedirs[i][1] * dist + forward[1] * 16.0f;
            p.org[2] = origin[2] + Globals.bytedirs[i][2] * dist + forward[2] * 16.0f;
            Math3D.VectorClear(p.vel);
            Math3D.VectorClear(p.accel);
            p.color = 0.0f;
            p.alpha = 1.0f;
            p.alphavel = -100.0f;
        }
    }

    static void FlyEffect(centity_t ent, float[] origin) {
        int starttime;
        if (ent.fly_stoptime < Globals.cl.time) {
            starttime = Globals.cl.time;
            ent.fly_stoptime = Globals.cl.time + 60000;
        } else {
            starttime = ent.fly_stoptime - 60000;
        }
        int n = Globals.cl.time - starttime;
        int count = n < 20000 ? (int)((double)(n * 162) / 20000.0) : ((n = ent.fly_stoptime - Globals.cl.time) < 20000 ? (int)((double)(n * 162) / 20000.0) : 162);
        CL_fx.FlyParticles(origin, count);
    }

    static void BfgParticles(entity_t ent) {
        int i;
        float dist = 64.0f;
        if (avelocities[0][0] == 0.0f) {
            for (i = 0; i < 162; ++i) {
                CL_fx.avelocities[i][0] = (float)(Lib.rand() & 0xFF) * 0.01f;
                CL_fx.avelocities[i][1] = (float)(Lib.rand() & 0xFF) * 0.01f;
                CL_fx.avelocities[i][2] = (float)(Lib.rand() & 0xFF) * 0.01f;
            }
        }
        float ltime = (float)Globals.cl.time / 1000.0f;
        for (i = 0; i < 162; ++i) {
            float angle = ltime * avelocities[i][0];
            float sy = (float)Math.sin(angle);
            float cy = (float)Math.cos(angle);
            angle = ltime * avelocities[i][1];
            float sp = (float)Math.sin(angle);
            float cp = (float)Math.cos(angle);
            angle = ltime * avelocities[i][2];
            CL_fx.forward[0] = cp * cy;
            CL_fx.forward[1] = cp * sy;
            CL_fx.forward[2] = -sp;
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            dist = (float)(Math.sin(ltime + (float)i) * 64.0);
            p.org[0] = ent.origin[0] + Globals.bytedirs[i][0] * dist + forward[0] * 16.0f;
            p.org[1] = ent.origin[1] + Globals.bytedirs[i][1] * dist + forward[1] * 16.0f;
            p.org[2] = ent.origin[2] + Globals.bytedirs[i][2] * dist + forward[2] * 16.0f;
            Math3D.VectorClear(p.vel);
            Math3D.VectorClear(p.accel);
            Math3D.VectorSubtract(p.org, ent.origin, v);
            dist = Math3D.VectorLength(v) / 90.0f;
            p.color = (float)Math.floor(208.0f + dist * 7.0f);
            p.alpha = 1.0f - dist;
            p.alphavel = -100.0f;
        }
    }

    static void TrapParticles(entity_t ent) {
        int j;
        cparticle_t p;
        ent.origin[2] = ent.origin[2] - 14.0f;
        Math3D.VectorCopy(ent.origin, start);
        Math3D.VectorCopy(ent.origin, end);
        end[2] = end[2] + 64.0f;
        Math3D.VectorCopy(start, move);
        Math3D.VectorSubtract(end, start, vec);
        float len = Math3D.VectorNormalize(vec);
        int dec = 5;
        Math3D.VectorScale(vec, 5.0f, vec);
        while (len > 0.0f) {
            len -= (float)dec;
            if (free_particles == null) {
                return;
            }
            p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            Math3D.VectorClear(p.accel);
            p.time = Globals.cl.time;
            p.alpha = 1.0f;
            p.alphavel = -1.0f / (0.3f + Globals.rnd.nextFloat() * 0.2f);
            p.color = 224.0f;
            for (j = 0; j < 3; ++j) {
                p.org[j] = move[j] + Lib.crand();
                p.vel[j] = Lib.crand() * 15.0f;
                p.accel[j] = 0.0f;
            }
            p.accel[2] = 40.0f;
            Math3D.VectorAdd(move, vec, move);
        }
        float[] dir = new float[3];
        float[] org = new float[3];
        ent.origin[2] = ent.origin[2] + 14.0f;
        Math3D.VectorCopy(ent.origin, org);
        for (int i = -2; i <= 2; i += 4) {
            for (j = -2; j <= 2; j += 4) {
                for (int k = -2; k <= 4; k += 4) {
                    if (free_particles == null) {
                        return;
                    }
                    p = free_particles;
                    free_particles = p.next;
                    p.next = active_particles;
                    active_particles = p;
                    p.time = Globals.cl.time;
                    p.color = 224 + (Lib.rand() & 3);
                    p.alpha = 1.0f;
                    p.alphavel = -1.0f / (0.3f + (float)(Lib.rand() & 7) * 0.02f);
                    p.org[0] = org[0] + (float)i + (float)(Lib.rand() & 0x17) * Lib.crand();
                    p.org[1] = org[1] + (float)j + (float)(Lib.rand() & 0x17) * Lib.crand();
                    p.org[2] = org[2] + (float)k + (float)(Lib.rand() & 0x17) * Lib.crand();
                    dir[0] = j * 8;
                    dir[1] = i * 8;
                    dir[2] = k * 8;
                    Math3D.VectorNormalize(dir);
                    float vel = 50 + Lib.rand() & 0x3F;
                    Math3D.VectorScale(dir, vel, p.vel);
                    p.accel[1] = 0.0f;
                    p.accel[0] = 0.0f;
                    p.accel[2] = -40.0f;
                }
            }
        }
    }

    static void BFGExplosionParticles(float[] org) {
        for (int i = 0; i < 256; ++i) {
            if (free_particles == null) {
                return;
            }
            cparticle_t p = free_particles;
            free_particles = p.next;
            p.next = active_particles;
            active_particles = p;
            p.time = Globals.cl.time;
            p.color = 208 + (Lib.rand() & 7);
            for (int j = 0; j < 3; ++j) {
                p.org[j] = org[j] + (float)(Lib.rand() % 32 - 16);
                p.vel[j] = Lib.rand() % 384 - 192;
            }
            p.accel[1] = 0.0f;
            p.accel[0] = 0.0f;
            p.accel[2] = -40.0f;
            p.alpha = 1.0f;
            p.alphavel = -0.8f / (0.5f + Globals.rnd.nextFloat() * 0.3f);
        }
    }

    static void TeleportParticles(float[] org) {
        for (int i = -16; i <= 16; i += 4) {
            for (int j = -16; j <= 16; j += 4) {
                for (int k = -16; k <= 32; k += 4) {
                    if (free_particles == null) {
                        return;
                    }
                    cparticle_t p = free_particles;
                    free_particles = p.next;
                    p.next = active_particles;
                    active_particles = p;
                    p.time = Globals.cl.time;
                    p.color = 7 + (Lib.rand() & 7);
                    p.alpha = 1.0f;
                    p.alphavel = -1.0f / (0.3f + (float)(Lib.rand() & 7) * 0.02f);
                    p.org[0] = org[0] + (float)i + (float)(Lib.rand() & 3);
                    p.org[1] = org[1] + (float)j + (float)(Lib.rand() & 3);
                    p.org[2] = org[2] + (float)k + (float)(Lib.rand() & 3);
                    CL_fx.dir[0] = j * 8;
                    CL_fx.dir[1] = i * 8;
                    CL_fx.dir[2] = k * 8;
                    Math3D.VectorNormalize(dir);
                    float vel = 50 + (Lib.rand() & 0x3F);
                    Math3D.VectorScale(dir, vel, p.vel);
                    p.accel[1] = 0.0f;
                    p.accel[0] = 0.0f;
                    p.accel[2] = -40.0f;
                }
            }
        }
    }

    static void AddParticles() {
        float time = 0.0f;
        cparticle_t active = null;
        cparticle_t tail = null;
        cparticle_t p = active_particles;
        while (p != null) {
            cparticle_t next;
            block7: {
                float alpha;
                block6: {
                    block5: {
                        next = p.next;
                        if (p.alphavel == -10000.0f) break block5;
                        time = ((float)Globals.cl.time - p.time) * 0.001f;
                        alpha = p.alpha + time * p.alphavel;
                        if (!(alpha <= 0.0f)) break block6;
                        p.next = free_particles;
                        free_particles = p;
                        break block7;
                    }
                    alpha = p.alpha;
                }
                p.next = null;
                if (tail == null) {
                    active = tail = p;
                } else {
                    tail.next = p;
                    tail = p;
                }
                if ((double)alpha > 1.0) {
                    alpha = 1.0f;
                }
                int color = (int)p.color;
                float time2 = time * time;
                CL_fx.org[0] = p.org[0] + p.vel[0] * time + p.accel[0] * time2;
                CL_fx.org[1] = p.org[1] + p.vel[1] * time + p.accel[1] * time2;
                CL_fx.org[2] = p.org[2] + p.vel[2] * time + p.accel[2] * time2;
                V.AddParticle(org, color, alpha);
                if (p.alphavel == -10000.0f) {
                    p.alphavel = 0.0f;
                    p.alpha = 0.0f;
                }
            }
            p = next;
        }
        active_particles = active;
    }

    static void EntityEvent(entity_state_t ent) {
        switch (ent.event) {
            case 1: {
                S.StartSound(null, ent.number, 1, S.RegisterSound("items/respawn1.wav"), 1.0f, 2.0f, 0.0f);
                CL_fx.ItemRespawnParticles(ent.origin);
                break;
            }
            case 6: {
                S.StartSound(null, ent.number, 1, S.RegisterSound("misc/tele1.wav"), 1.0f, 2.0f, 0.0f);
                CL_fx.TeleportParticles(ent.origin);
                break;
            }
            case 2: {
                if (Globals.cl_footsteps.value == 0.0f) break;
                S.StartSound(null, ent.number, 4, CL_tent.cl_sfx_footsteps[Lib.rand() & 3], 1.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                S.StartSound(null, ent.number, 0, S.RegisterSound("player/land1.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 4: {
                S.StartSound(null, ent.number, 0, S.RegisterSound("*fall2.wav"), 1.0f, 1.0f, 0.0f);
                break;
            }
            case 5: {
                S.StartSound(null, ent.number, 0, S.RegisterSound("*fall1.wav"), 1.0f, 1.0f, 0.0f);
            }
        }
    }

    static void ClearEffects() {
        CL_fx.ClearParticles();
        CL_fx.ClearDlights();
        CL_fx.ClearLightStyles();
    }

    static {
        int i;
        particles = new cparticle_t[4096];
        for (i = 0; i < particles.length; ++i) {
            CL_fx.particles[i] = new cparticle_t();
        }
        cl_numparticles = 4096;
        avelocities = new float[162][3];
        cl_lightstyle = new clightstyle_t[256];
        for (i = 0; i < cl_lightstyle.length; ++i) {
            CL_fx.cl_lightstyle[i] = new clightstyle_t();
        }
        cl_dlights = new cdlight_t[32];
        for (i = 0; i < cl_dlights.length; ++i) {
            CL_fx.cl_dlights[i] = new cdlight_t();
        }
        fv = new float[]{0.0f, 0.0f, 0.0f};
        rv = new float[]{0.0f, 0.0f, 0.0f};
        origin = new float[]{0.0f, 0.0f, 0.0f};
        forward = new float[]{0.0f, 0.0f, 0.0f};
        right = new float[]{0.0f, 0.0f, 0.0f};
        move = new float[]{0.0f, 0.0f, 0.0f};
        vec = new float[]{0.0f, 0.0f, 0.0f};
        v = new float[]{0.0f, 0.0f, 0.0f};
        start = new float[]{0.0f, 0.0f, 0.0f};
        end = new float[]{0.0f, 0.0f, 0.0f};
        dir = new float[]{0.0f, 0.0f, 0.0f};
        org = new float[]{0.0f, 0.0f, 0.0f};
        colortable = new int[]{16, 104, 168, 144};
    }

    static class clightstyle_t {
        int length;
        float[] value = new float[3];
        float[] map = new float[64];

        clightstyle_t() {
        }

        void clear() {
            this.length = 0;
            this.value[1] = this.value[2] = (float)0;
            this.value[0] = this.value[2];
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = 0.0f;
            }
        }
    }

    static class cdlight_t {
        int key;
        float[] color = new float[]{0.0f, 0.0f, 0.0f};
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        float radius;
        float die;
        float minlight;

        cdlight_t() {
        }

        void clear() {
            this.color[2] = 0.0f;
            this.color[1] = 0.0f;
            this.color[0] = 0.0f;
            this.minlight = 0.0f;
            this.radius = 0.0f;
        }
    }
}

