/*
 * Decompiled with CFR 0.152.
 */
package jake2.client;

import jake2.Globals;
import jake2.client.CL_fx;
import jake2.client.CL_newfx;
import jake2.client.CL_parse;
import jake2.client.CL_pred;
import jake2.client.CL_tent;
import jake2.client.SCR;
import jake2.client.V;
import jake2.client.centity_t;
import jake2.client.clientinfo_t;
import jake2.client.entity_t;
import jake2.client.frame_t;
import jake2.game.entity_state_t;
import jake2.game.player_state_t;
import jake2.game.trace_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.util.Math3D;

public class CL_ents {
    static int[] bitcounts = new int[32];
    static int[] bfg_lightramp = new int[]{300, 400, 600, 300, 150, 75};
    private static final int[] iw = new int[]{0};
    private static final entity_t ent = new entity_t();
    private static final entity_t gun = new entity_t();

    public static int ParseEntityBits(int[] bits) {
        int b;
        int total = MSG.ReadByte(Globals.net_message);
        if ((total & 0x80) != 0) {
            b = MSG.ReadByte(Globals.net_message);
            total |= b << 8;
        }
        if ((total & 0x8000) != 0) {
            b = MSG.ReadByte(Globals.net_message);
            total |= b << 16;
        }
        if ((total & 0x800000) != 0) {
            b = MSG.ReadByte(Globals.net_message);
            total |= b << 24;
        }
        for (int i = 0; i < 32; ++i) {
            if ((total & 1 << i) == 0) continue;
            int n = i;
            bitcounts[n] = bitcounts[n] + 1;
        }
        int number = (total & 0x100) != 0 ? MSG.ReadShort(Globals.net_message) : MSG.ReadByte(Globals.net_message);
        bits[0] = total;
        return number;
    }

    public static void ParseDelta(entity_state_t from, entity_state_t to, int number, int bits) {
        to.set(from);
        Math3D.VectorCopy(from.origin, to.old_origin);
        to.number = number;
        if ((bits & 0x800) != 0) {
            to.modelindex = MSG.ReadByte(Globals.net_message);
        }
        if ((bits & 0x100000) != 0) {
            to.modelindex2 = MSG.ReadByte(Globals.net_message);
        }
        if ((bits & 0x200000) != 0) {
            to.modelindex3 = MSG.ReadByte(Globals.net_message);
        }
        if ((bits & 0x400000) != 0) {
            to.modelindex4 = MSG.ReadByte(Globals.net_message);
        }
        if ((bits & 0x10) != 0) {
            to.frame = MSG.ReadByte(Globals.net_message);
        }
        if ((bits & 0x20000) != 0) {
            to.frame = MSG.ReadShort(Globals.net_message);
        }
        if ((bits & 0x10000) != 0 && (bits & 0x2000000) != 0) {
            to.skinnum = MSG.ReadLong(Globals.net_message);
        } else if ((bits & 0x10000) != 0) {
            to.skinnum = MSG.ReadByte(Globals.net_message);
        } else if ((bits & 0x2000000) != 0) {
            to.skinnum = MSG.ReadShort(Globals.net_message);
        }
        if ((bits & 0x84000) == 540672) {
            to.effects = MSG.ReadLong(Globals.net_message);
        } else if ((bits & 0x4000) != 0) {
            to.effects = MSG.ReadByte(Globals.net_message);
        } else if ((bits & 0x80000) != 0) {
            to.effects = MSG.ReadShort(Globals.net_message);
        }
        if ((bits & 0x41000) == 266240) {
            to.renderfx = MSG.ReadLong(Globals.net_message);
        } else if ((bits & 0x1000) != 0) {
            to.renderfx = MSG.ReadByte(Globals.net_message);
        } else if ((bits & 0x40000) != 0) {
            to.renderfx = MSG.ReadShort(Globals.net_message);
        }
        if ((bits & 1) != 0) {
            to.origin[0] = MSG.ReadCoord(Globals.net_message);
        }
        if ((bits & 2) != 0) {
            to.origin[1] = MSG.ReadCoord(Globals.net_message);
        }
        if ((bits & 0x200) != 0) {
            to.origin[2] = MSG.ReadCoord(Globals.net_message);
        }
        if ((bits & 0x400) != 0) {
            to.angles[0] = MSG.ReadAngle(Globals.net_message);
        }
        if ((bits & 4) != 0) {
            to.angles[1] = MSG.ReadAngle(Globals.net_message);
        }
        if ((bits & 8) != 0) {
            to.angles[2] = MSG.ReadAngle(Globals.net_message);
        }
        if ((bits & 0x1000000) != 0) {
            MSG.ReadPos(Globals.net_message, to.old_origin);
        }
        if ((bits & 0x4000000) != 0) {
            to.sound = MSG.ReadByte(Globals.net_message);
        }
        to.event = (bits & 0x20) != 0 ? MSG.ReadByte(Globals.net_message) : 0;
        if ((bits & 0x8000000) != 0) {
            to.solid = MSG.ReadShort(Globals.net_message);
        }
    }

    public static void DeltaEntity(frame_t frame, int newnum, entity_state_t old, int bits) {
        centity_t ent = Globals.cl_entities[newnum];
        entity_state_t state = Globals.cl_parse_entities[Globals.cl.parse_entities & 0x3FF];
        ++Globals.cl.parse_entities;
        ++frame.num_entities;
        CL_ents.ParseDelta(old, state, newnum, bits);
        if (state.modelindex != ent.current.modelindex || state.modelindex2 != ent.current.modelindex2 || state.modelindex3 != ent.current.modelindex3 || state.modelindex4 != ent.current.modelindex4 || Math.abs(state.origin[0] - ent.current.origin[0]) > 512.0f || Math.abs(state.origin[1] - ent.current.origin[1]) > 512.0f || Math.abs(state.origin[2] - ent.current.origin[2]) > 512.0f || state.event == 6 || state.event == 7) {
            ent.serverframe = -99;
        }
        if (ent.serverframe != Globals.cl.frame.serverframe - 1) {
            ent.trailcount = 1024;
            ent.prev.set(state);
            if (state.event == 7) {
                Math3D.VectorCopy(state.origin, ent.prev.origin);
                Math3D.VectorCopy(state.origin, ent.lerp_origin);
            } else {
                Math3D.VectorCopy(state.old_origin, ent.prev.origin);
                Math3D.VectorCopy(state.old_origin, ent.lerp_origin);
            }
        } else {
            ent.prev.set(ent.current);
        }
        ent.serverframe = Globals.cl.frame.serverframe;
        ent.current.set(state);
    }

    public static void ParsePacketEntities(frame_t oldframe, frame_t newframe) {
        int oldnum;
        int bits = 0;
        entity_state_t oldstate = null;
        newframe.parse_entities = Globals.cl.parse_entities;
        newframe.num_entities = 0;
        int oldindex = 0;
        if (oldframe == null) {
            oldnum = 99999;
        } else {
            oldstate = Globals.cl_parse_entities[oldframe.parse_entities + oldindex & 0x3FF];
            oldnum = oldstate.number;
        }
        while (true) {
            CL_ents.iw[0] = bits;
            int newnum = CL_ents.ParseEntityBits(iw);
            bits = iw[0];
            if (newnum >= 1024) {
                Com.Error(1, "CL_ParsePacketEntities: bad number:" + newnum);
            }
            if (Globals.net_message.readcount > Globals.net_message.cursize) {
                Com.Error(1, "CL_ParsePacketEntities: end of message");
            }
            if (0 == newnum) break;
            while (oldnum < newnum) {
                if (Globals.cl_shownet.value == 3.0f) {
                    Com.Printf("   unchanged: " + oldnum + "\n");
                }
                CL_ents.DeltaEntity(newframe, oldnum, oldstate, 0);
                if (++oldindex >= oldframe.num_entities) {
                    oldnum = 99999;
                    continue;
                }
                oldstate = Globals.cl_parse_entities[oldframe.parse_entities + oldindex & 0x3FF];
                oldnum = oldstate.number;
            }
            if ((bits & 0x40) != 0) {
                if (Globals.cl_shownet.value == 3.0f) {
                    Com.Printf("   remove: " + newnum + "\n");
                }
                if (oldnum != newnum) {
                    Com.Printf("U_REMOVE: oldnum != newnum\n");
                }
                if (++oldindex >= oldframe.num_entities) {
                    oldnum = 99999;
                    continue;
                }
                oldstate = Globals.cl_parse_entities[oldframe.parse_entities + oldindex & 0x3FF];
                oldnum = oldstate.number;
                continue;
            }
            if (oldnum == newnum) {
                if (Globals.cl_shownet.value == 3.0f) {
                    Com.Printf("   delta: " + newnum + "\n");
                }
                CL_ents.DeltaEntity(newframe, newnum, oldstate, bits);
                if (++oldindex >= oldframe.num_entities) {
                    oldnum = 99999;
                    continue;
                }
                oldstate = Globals.cl_parse_entities[oldframe.parse_entities + oldindex & 0x3FF];
                oldnum = oldstate.number;
                continue;
            }
            if (oldnum <= newnum) continue;
            if (Globals.cl_shownet.value == 3.0f) {
                Com.Printf("   baseline: " + newnum + "\n");
            }
            CL_ents.DeltaEntity(newframe, newnum, Globals.cl_entities[newnum].baseline, bits);
        }
        while (oldnum != 99999) {
            if (Globals.cl_shownet.value == 3.0f) {
                Com.Printf("   unchanged: " + oldnum + "\n");
            }
            CL_ents.DeltaEntity(newframe, oldnum, oldstate, 0);
            if (++oldindex >= oldframe.num_entities) {
                oldnum = 99999;
                continue;
            }
            oldstate = Globals.cl_parse_entities[oldframe.parse_entities + oldindex & 0x3FF];
            oldnum = oldstate.number;
        }
    }

    public static void ParsePlayerstate(frame_t oldframe, frame_t newframe) {
        player_state_t state = newframe.playerstate;
        if (oldframe != null) {
            state.set(oldframe.playerstate);
        } else {
            state.clear();
        }
        short flags = MSG.ReadShort(Globals.net_message);
        if ((flags & 1) != 0) {
            state.pmove.pm_type = MSG.ReadByte(Globals.net_message);
        }
        if ((flags & 2) != 0) {
            state.pmove.origin[0] = MSG.ReadShort(Globals.net_message);
            state.pmove.origin[1] = MSG.ReadShort(Globals.net_message);
            state.pmove.origin[2] = MSG.ReadShort(Globals.net_message);
        }
        if ((flags & 4) != 0) {
            state.pmove.velocity[0] = MSG.ReadShort(Globals.net_message);
            state.pmove.velocity[1] = MSG.ReadShort(Globals.net_message);
            state.pmove.velocity[2] = MSG.ReadShort(Globals.net_message);
        }
        if ((flags & 8) != 0) {
            state.pmove.pm_time = (byte)MSG.ReadByte(Globals.net_message);
        }
        if ((flags & 0x10) != 0) {
            state.pmove.pm_flags = (byte)MSG.ReadByte(Globals.net_message);
        }
        if ((flags & 0x20) != 0) {
            state.pmove.gravity = MSG.ReadShort(Globals.net_message);
        }
        if ((flags & 0x40) != 0) {
            state.pmove.delta_angles[0] = MSG.ReadShort(Globals.net_message);
            state.pmove.delta_angles[1] = MSG.ReadShort(Globals.net_message);
            state.pmove.delta_angles[2] = MSG.ReadShort(Globals.net_message);
        }
        if (Globals.cl.attractloop) {
            state.pmove.pm_type = 4;
        }
        if ((flags & 0x80) != 0) {
            state.viewoffset[0] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.viewoffset[1] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.viewoffset[2] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
        }
        if ((flags & 0x100) != 0) {
            state.viewangles[0] = MSG.ReadAngle16(Globals.net_message);
            state.viewangles[1] = MSG.ReadAngle16(Globals.net_message);
            state.viewangles[2] = MSG.ReadAngle16(Globals.net_message);
        }
        if ((flags & 0x200) != 0) {
            state.kick_angles[0] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.kick_angles[1] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.kick_angles[2] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
        }
        if ((flags & 0x1000) != 0) {
            state.gunindex = MSG.ReadByte(Globals.net_message);
        }
        if ((flags & 0x2000) != 0) {
            state.gunframe = MSG.ReadByte(Globals.net_message);
            state.gunoffset[0] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.gunoffset[1] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.gunoffset[2] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.gunangles[0] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.gunangles[1] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
            state.gunangles[2] = (float)MSG.ReadChar(Globals.net_message) * 0.25f;
        }
        if ((flags & 0x400) != 0) {
            state.blend[0] = (float)MSG.ReadByte(Globals.net_message) / 255.0f;
            state.blend[1] = (float)MSG.ReadByte(Globals.net_message) / 255.0f;
            state.blend[2] = (float)MSG.ReadByte(Globals.net_message) / 255.0f;
            state.blend[3] = (float)MSG.ReadByte(Globals.net_message) / 255.0f;
        }
        if ((flags & 0x800) != 0) {
            state.fov = MSG.ReadByte(Globals.net_message);
        }
        if ((flags & 0x4000) != 0) {
            state.rdflags = MSG.ReadByte(Globals.net_message);
        }
        int statbits = MSG.ReadLong(Globals.net_message);
        for (int i = 0; i < 32; ++i) {
            if ((statbits & 1 << i) == 0) continue;
            state.stats[i] = MSG.ReadShort(Globals.net_message);
        }
    }

    public static void FireEntityEvents(frame_t frame) {
        for (int pnum = 0; pnum < frame.num_entities; ++pnum) {
            int num = frame.parse_entities + pnum & 0x3FF;
            entity_state_t s1 = Globals.cl_parse_entities[num];
            if (s1.event != 0) {
                CL_fx.EntityEvent(s1);
            }
            if ((s1.effects & 0x20000) == 0) continue;
            CL_fx.TeleporterParticles(s1);
        }
    }

    public static void ParseFrame() {
        frame_t old;
        Globals.cl.frame.reset();
        Globals.cl.frame.serverframe = MSG.ReadLong(Globals.net_message);
        Globals.cl.frame.deltaframe = MSG.ReadLong(Globals.net_message);
        Globals.cl.frame.servertime = Globals.cl.frame.serverframe * 100;
        if (Globals.cls.serverProtocol != 26) {
            Globals.cl.surpressCount = MSG.ReadByte(Globals.net_message);
        }
        if (Globals.cl_shownet.value == 3.0f) {
            Com.Printf("   frame:" + Globals.cl.frame.serverframe + "  delta:" + Globals.cl.frame.deltaframe + "\n");
        }
        if (Globals.cl.frame.deltaframe <= 0) {
            Globals.cl.frame.valid = true;
            old = null;
            Globals.cls.demowaiting = false;
        } else {
            old = Globals.cl.frames[Globals.cl.frame.deltaframe & 0xF];
            if (!old.valid) {
                Com.Printf("Delta from invalid frame (not supposed to happen!).\n");
            }
            if (old.serverframe != Globals.cl.frame.deltaframe) {
                Com.Printf("Delta frame too old.\n");
            } else if (Globals.cl.parse_entities - old.parse_entities > 896) {
                Com.Printf("Delta parse_entities too old.\n");
            } else {
                Globals.cl.frame.valid = true;
            }
        }
        if (Globals.cl.time > Globals.cl.frame.servertime) {
            Globals.cl.time = Globals.cl.frame.servertime;
        } else if (Globals.cl.time < Globals.cl.frame.servertime - 100) {
            Globals.cl.time = Globals.cl.frame.servertime - 100;
        }
        int len = MSG.ReadByte(Globals.net_message);
        MSG.ReadData(Globals.net_message, Globals.cl.frame.areabits, len);
        int cmd = MSG.ReadByte(Globals.net_message);
        CL_parse.SHOWNET(CL_parse.svc_strings[cmd]);
        if (cmd != 17) {
            Com.Error(1, "CL_ParseFrame: not playerinfo");
        }
        CL_ents.ParsePlayerstate(old, Globals.cl.frame);
        cmd = MSG.ReadByte(Globals.net_message);
        CL_parse.SHOWNET(CL_parse.svc_strings[cmd]);
        if (cmd != 18) {
            Com.Error(1, "CL_ParseFrame: not packetentities");
        }
        CL_ents.ParsePacketEntities(old, Globals.cl.frame);
        Globals.cl.frames[Globals.cl.frame.serverframe & 0xF].set(Globals.cl.frame);
        if (Globals.cl.frame.valid) {
            if (Globals.cls.state != 4) {
                Globals.cls.state = 4;
                Globals.cl.force_refdef = true;
                Globals.cl.predicted_origin[0] = (float)Globals.cl.frame.playerstate.pmove.origin[0] * 0.125f;
                Globals.cl.predicted_origin[1] = (float)Globals.cl.frame.playerstate.pmove.origin[1] * 0.125f;
                Globals.cl.predicted_origin[2] = (float)Globals.cl.frame.playerstate.pmove.origin[2] * 0.125f;
                Math3D.VectorCopy(Globals.cl.frame.playerstate.viewangles, Globals.cl.predicted_angles);
                if (Globals.cls.disable_servercount != Globals.cl.servercount && Globals.cl.refresh_prepped) {
                    SCR.EndLoadingPlaque();
                }
            }
            Globals.cl.sound_prepped = true;
            CL_ents.FireEntityEvents(Globals.cl.frame);
            CL_pred.CheckPredictionError();
        }
    }

    static void AddPacketEntities(frame_t frame) {
        float autorotate = Math3D.anglemod(Globals.cl.time / 10);
        int autoanim = 2 * Globals.cl.time / 1000;
        ent.clear();
        for (int pnum = 0; pnum < frame.num_entities; ++pnum) {
            clientinfo_t ci;
            int i;
            entity_state_t s1 = Globals.cl_parse_entities[frame.parse_entities + pnum & 0x3FF];
            boolean isclientviewer = false;
            centity_t cent = Globals.cl_entities[s1.number];
            int effects = s1.effects;
            int renderfx = s1.renderfx;
            CL_ents.ent.frame = (effects & 0x400) != 0 ? autoanim & 1 : ((effects & 0x800) != 0 ? 2 + (autoanim & 1) : ((effects & 0x1000) != 0 ? autoanim : ((effects & 0x2000) != 0 ? Globals.cl.time / 100 : s1.frame)));
            if ((effects & 0x10000) != 0) {
                effects &= 0xFFFEFFFF;
                effects |= 0x100;
                renderfx |= 0x400;
            }
            if ((effects & 0x8000) != 0) {
                effects &= 0xFFFF7FFF;
                effects |= 0x100;
                renderfx |= 0x1000;
            }
            if ((effects & 0x8000000) != 0) {
                effects &= 0xF7FFFFFF;
                effects |= 0x100;
                renderfx |= 0x10000;
            }
            if ((effects & 0x40000000) != 0) {
                effects &= 0xBFFFFFFF;
                effects |= 0x100;
                renderfx |= 0x20000;
            }
            CL_ents.ent.oldframe = cent.prev.frame;
            CL_ents.ent.backlerp = 1.0f - Globals.cl.lerpfrac;
            if ((renderfx & 0xC0) != 0) {
                Math3D.VectorCopy(cent.current.origin, CL_ents.ent.origin);
                Math3D.VectorCopy(cent.current.old_origin, CL_ents.ent.oldorigin);
            } else {
                for (i = 0; i < 3; ++i) {
                    CL_ents.ent.origin[i] = CL_ents.ent.oldorigin[i] = cent.prev.origin[i] + Globals.cl.lerpfrac * (cent.current.origin[i] - cent.prev.origin[i]);
                }
            }
            if ((renderfx & 0x80) != 0) {
                CL_ents.ent.alpha = 0.3f;
                CL_ents.ent.skinnum = s1.skinnum >> Globals.rnd.nextInt(4) * 8 & 0xFF;
                Math.random();
                CL_ents.ent.model = null;
            } else if (s1.modelindex == 255) {
                CL_ents.ent.skinnum = 0;
                ci = Globals.cl.clientinfo[s1.skinnum & 0xFF];
                CL_ents.ent.skin = ci.skin;
                CL_ents.ent.model = ci.model;
                if (null == CL_ents.ent.skin || null == CL_ents.ent.model) {
                    CL_ents.ent.skin = Globals.cl.baseclientinfo.skin;
                    CL_ents.ent.model = Globals.cl.baseclientinfo.model;
                }
                if ((renderfx & 0x40000) != 0) {
                    if (CL_ents.ent.skin.name.startsWith("players/male")) {
                        CL_ents.ent.skin = Globals.re.RegisterSkin("players/male/disguise.pcx");
                        CL_ents.ent.model = Globals.re.RegisterModel("players/male/tris.md2");
                    } else if (CL_ents.ent.skin.name.startsWith("players/female")) {
                        CL_ents.ent.skin = Globals.re.RegisterSkin("players/female/disguise.pcx");
                        CL_ents.ent.model = Globals.re.RegisterModel("players/female/tris.md2");
                    } else if (CL_ents.ent.skin.name.startsWith("players/cyborg")) {
                        CL_ents.ent.skin = Globals.re.RegisterSkin("players/cyborg/disguise.pcx");
                        CL_ents.ent.model = Globals.re.RegisterModel("players/cyborg/tris.md2");
                    }
                }
            } else {
                CL_ents.ent.skinnum = s1.skinnum;
                CL_ents.ent.skin = null;
                CL_ents.ent.model = Globals.cl.model_draw[s1.modelindex];
            }
            if (renderfx == 32) {
                CL_ents.ent.alpha = 0.7f;
            }
            CL_ents.ent.flags = (effects & 0x100) != 0 ? 0 : renderfx;
            if ((effects & 1) != 0) {
                CL_ents.ent.angles[0] = 0.0f;
                CL_ents.ent.angles[1] = autorotate;
                CL_ents.ent.angles[2] = 0.0f;
            } else if ((effects & 0x800000) != 0) {
                CL_ents.ent.angles[0] = 0.0f;
                CL_ents.ent.angles[1] = Math3D.anglemod(Globals.cl.time / 2) + s1.angles[1];
                CL_ents.ent.angles[2] = 180.0f;
                float[] forward = new float[]{0.0f, 0.0f, 0.0f};
                float[] start = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.AngleVectors(CL_ents.ent.angles, forward, null, null);
                Math3D.VectorMA(CL_ents.ent.origin, 64.0f, forward, start);
                V.AddLight(start, 100.0f, 1.0f, 0.0f, 0.0f);
            } else {
                for (i = 0; i < 3; ++i) {
                    float a1 = cent.current.angles[i];
                    float a2 = cent.prev.angles[i];
                    CL_ents.ent.angles[i] = Math3D.LerpAngle(a2, a1, Globals.cl.lerpfrac);
                }
            }
            if (s1.number == Globals.cl.playernum + 1) {
                CL_ents.ent.flags |= 2;
                isclientviewer = true;
                if ((effects & 0x40000) != 0) {
                    V.AddLight(CL_ents.ent.origin, 225.0f, 1.0f, 0.1f, 0.1f);
                } else if ((effects & 0x80000) != 0) {
                    V.AddLight(CL_ents.ent.origin, 225.0f, 0.1f, 0.1f, 1.0f);
                } else if ((effects & 0x20000000) != 0) {
                    V.AddLight(CL_ents.ent.origin, 225.0f, 1.0f, 1.0f, 0.0f);
                } else if ((effects & Integer.MIN_VALUE) != 0) {
                    V.AddLight(CL_ents.ent.origin, 225.0f, -1.0f, -1.0f, -1.0f);
                }
                if (Globals.cl_3rd.value != 1.0f) continue;
            }
            if (s1.modelindex == 0) continue;
            if ((effects & 0x80) != 0) {
                CL_ents.ent.flags |= 0x20;
                CL_ents.ent.alpha = 0.3f;
            }
            if ((effects & 0x1000000) != 0) {
                CL_ents.ent.flags |= 0x20;
                CL_ents.ent.alpha = 0.6f;
            }
            if ((effects & 0x10000000) != 0) {
                CL_ents.ent.flags |= 0x20;
                CL_ents.ent.alpha = (effects & Integer.MIN_VALUE) != 0 ? 0.6f : 0.3f;
            }
            V.AddEntity(ent);
            if ((effects & 0x100) != 0) {
                if ((renderfx & 0x20000) != 0 && FS.Developer_searchpath(2) == 2 && (renderfx & 0x11400) != 0) {
                    renderfx &= 0xFFFDFFFF;
                }
                if ((renderfx & 0x10000) != 0 && FS.Developer_searchpath(2) == 2) {
                    if ((renderfx & 0x1C00) != 0) {
                        renderfx &= 0xFFFEFFFF;
                    }
                    if ((renderfx & 0x400) != 0) {
                        renderfx |= 0x1000;
                    } else if ((renderfx & 0x1000) != 0) {
                        renderfx = (renderfx & 0x800) != 0 ? (renderfx &= 0xFFFFEFFF) : (renderfx |= 0x800);
                    }
                }
                CL_ents.ent.flags = renderfx | 0x20;
                CL_ents.ent.alpha = 0.3f;
                V.AddEntity(ent);
            }
            CL_ents.ent.skin = null;
            CL_ents.ent.skinnum = 0;
            CL_ents.ent.flags = 0;
            CL_ents.ent.alpha = 0.0f;
            if (s1.modelindex2 != 0) {
                if (s1.modelindex2 == 255) {
                    ci = Globals.cl.clientinfo[s1.skinnum & 0xFF];
                    i = s1.skinnum >> 8;
                    if (0.0f == Globals.cl_vwep.value || i > 19) {
                        i = 0;
                    }
                    CL_ents.ent.model = ci.weaponmodel[i];
                    if (null == CL_ents.ent.model) {
                        if (i != 0) {
                            CL_ents.ent.model = ci.weaponmodel[0];
                        }
                        if (null == CL_ents.ent.model) {
                            CL_ents.ent.model = Globals.cl.baseclientinfo.weaponmodel[0];
                        }
                    }
                } else {
                    CL_ents.ent.model = Globals.cl.model_draw[s1.modelindex2];
                }
                if (Globals.cl.configstrings[32 + s1.modelindex2].equalsIgnoreCase("models/items/shell/tris.md2")) {
                    CL_ents.ent.alpha = 0.32f;
                    CL_ents.ent.flags = 32;
                }
                V.AddEntity(ent);
                CL_ents.ent.flags = 0;
                CL_ents.ent.alpha = 0.0f;
            }
            if (s1.modelindex3 != 0) {
                if (isclientviewer) {
                    CL_ents.ent.flags |= 2;
                }
                CL_ents.ent.model = Globals.cl.model_draw[s1.modelindex3];
                V.AddEntity(ent);
            }
            if (s1.modelindex4 != 0) {
                if (isclientviewer) {
                    CL_ents.ent.flags |= 2;
                }
                CL_ents.ent.model = Globals.cl.model_draw[s1.modelindex4];
                V.AddEntity(ent);
            }
            if ((effects & 0x200) != 0) {
                CL_ents.ent.model = CL_tent.cl_mod_powerscreen;
                CL_ents.ent.oldframe = 0;
                CL_ents.ent.frame = 0;
                CL_ents.ent.flags |= 0x820;
                CL_ents.ent.alpha = 0.3f;
                V.AddEntity(ent);
            }
            if ((effects & 0xFFFFFFFE) != 0) {
                if ((effects & 0x10) != 0) {
                    CL_fx.RocketTrail(cent.lerp_origin, CL_ents.ent.origin, cent);
                    V.AddLight(CL_ents.ent.origin, 200.0f, 1.0f, 1.0f, 0.0f);
                } else if ((effects & 8) != 0) {
                    if ((effects & 0x4000000) != 0) {
                        CL_newfx.BlasterTrail2(cent.lerp_origin, CL_ents.ent.origin);
                        V.AddLight(CL_ents.ent.origin, 200.0f, 0.0f, 1.0f, 0.0f);
                    } else {
                        CL_fx.BlasterTrail(cent.lerp_origin, CL_ents.ent.origin);
                        V.AddLight(CL_ents.ent.origin, 200.0f, 1.0f, 1.0f, 0.0f);
                    }
                } else if ((effects & 0x40) != 0) {
                    if ((effects & 0x4000000) != 0) {
                        V.AddLight(CL_ents.ent.origin, 200.0f, 0.0f, 1.0f, 0.0f);
                    } else {
                        V.AddLight(CL_ents.ent.origin, 200.0f, 1.0f, 1.0f, 0.0f);
                    }
                } else if ((effects & 2) != 0) {
                    CL_fx.DiminishingTrail(cent.lerp_origin, CL_ents.ent.origin, cent, effects);
                } else if ((effects & 0x20) != 0) {
                    CL_fx.DiminishingTrail(cent.lerp_origin, CL_ents.ent.origin, cent, effects);
                } else if ((effects & 0x4000) != 0) {
                    CL_fx.FlyEffect(cent, CL_ents.ent.origin);
                } else if ((effects & 0x80) != 0) {
                    if ((effects & 0x2000) != 0) {
                        CL_fx.BfgParticles(ent);
                        i = 200;
                    } else {
                        i = bfg_lightramp[s1.frame];
                    }
                    V.AddLight(CL_ents.ent.origin, i, 0.0f, 1.0f, 0.0f);
                } else if ((effects & 0x2000000) != 0) {
                    CL_ents.ent.origin[2] = CL_ents.ent.origin[2] + 32.0f;
                    CL_fx.TrapParticles(ent);
                    i = Globals.rnd.nextInt(100) + 100;
                    V.AddLight(CL_ents.ent.origin, i, 1.0f, 0.8f, 0.1f);
                } else if ((effects & 0x40000) != 0) {
                    CL_fx.FlagTrail(cent.lerp_origin, CL_ents.ent.origin, 242.0f);
                    V.AddLight(CL_ents.ent.origin, 225.0f, 1.0f, 0.1f, 0.1f);
                } else if ((effects & 0x80000) != 0) {
                    CL_fx.FlagTrail(cent.lerp_origin, CL_ents.ent.origin, 115.0f);
                    V.AddLight(CL_ents.ent.origin, 225.0f, 0.1f, 0.1f, 1.0f);
                } else if ((effects & 0x20000000) != 0) {
                    CL_newfx.TagTrail(cent.lerp_origin, CL_ents.ent.origin, 220.0f);
                    V.AddLight(CL_ents.ent.origin, 225.0f, 1.0f, 1.0f, 0.0f);
                } else if ((effects & Integer.MIN_VALUE) != 0) {
                    if ((effects & 0x4000000) != 0) {
                        float intensity = (float)(50.0 + 500.0 * (Math.sin((double)Globals.cl.time / 500.0) + 1.0));
                        if (Globals.vidref_val == 1) {
                            V.AddLight(CL_ents.ent.origin, intensity, -1.0f, -1.0f, -1.0f);
                        } else {
                            V.AddLight(CL_ents.ent.origin, -1.0f * intensity, 1.0f, 1.0f, 1.0f);
                        }
                    } else {
                        CL_newfx.Tracker_Shell(cent.lerp_origin);
                        V.AddLight(CL_ents.ent.origin, 155.0f, -1.0f, -1.0f, -1.0f);
                    }
                } else if ((effects & 0x4000000) != 0) {
                    CL_newfx.TrackerTrail(cent.lerp_origin, CL_ents.ent.origin, 0);
                    if (Globals.vidref_val == 1) {
                        V.AddLight(CL_ents.ent.origin, 200.0f, -1.0f, -1.0f, -1.0f);
                    } else {
                        V.AddLight(CL_ents.ent.origin, -200.0f, 1.0f, 1.0f, 1.0f);
                    }
                } else if ((effects & 0x200000) != 0) {
                    CL_fx.DiminishingTrail(cent.lerp_origin, CL_ents.ent.origin, cent, effects);
                } else if ((effects & 0x100000) != 0) {
                    CL_fx.IonripperTrail(cent.lerp_origin, CL_ents.ent.origin);
                    V.AddLight(CL_ents.ent.origin, 100.0f, 1.0f, 0.5f, 0.5f);
                } else if ((effects & 0x400000) != 0) {
                    V.AddLight(CL_ents.ent.origin, 200.0f, 0.0f, 0.0f, 1.0f);
                } else if ((effects & 0x1000000) != 0) {
                    if ((effects & 0x2000) != 0) {
                        CL_fx.BlasterTrail(cent.lerp_origin, CL_ents.ent.origin);
                    }
                    V.AddLight(CL_ents.ent.origin, 130.0f, 1.0f, 0.5f, 0.5f);
                }
            }
            Math3D.VectorCopy(CL_ents.ent.origin, cent.lerp_origin);
        }
    }

    static void AddViewWeapon(player_state_t ps, player_state_t ops) {
        if (Globals.cl_3rd.value == 1.0f) {
            return;
        }
        if (0.0f == Globals.cl_gun.value) {
            return;
        }
        if (ps.fov > 90.0f) {
            return;
        }
        gun.clear();
        CL_ents.gun.model = Globals.gun_model != null ? Globals.gun_model : Globals.cl.model_draw[ps.gunindex];
        if (CL_ents.gun.model == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            CL_ents.gun.origin[i] = Globals.cl.refdef.vieworg[i] + ops.gunoffset[i] + Globals.cl.lerpfrac * (ps.gunoffset[i] - ops.gunoffset[i]);
            CL_ents.gun.angles[i] = Globals.cl.refdef.viewangles[i] + Math3D.LerpAngle(ops.gunangles[i], ps.gunangles[i], Globals.cl.lerpfrac);
        }
        if (Globals.gun_frame != 0) {
            CL_ents.gun.frame = Globals.gun_frame;
            CL_ents.gun.oldframe = Globals.gun_frame;
        } else {
            CL_ents.gun.frame = ps.gunframe;
            CL_ents.gun.oldframe = CL_ents.gun.frame == 0 ? 0 : ops.gunframe;
        }
        CL_ents.gun.flags = 21;
        CL_ents.gun.backlerp = 1.0f - Globals.cl.lerpfrac;
        Math3D.VectorCopy(CL_ents.gun.origin, CL_ents.gun.oldorigin);
        V.AddEntity(gun);
    }

    static void CalcViewValues() {
        player_state_t ps = Globals.cl.frame.playerstate;
        int i = Globals.cl.frame.serverframe - 1 & 0xF;
        frame_t oldframe = Globals.cl.frames[i];
        if (oldframe.serverframe != Globals.cl.frame.serverframe - 1 || !oldframe.valid) {
            oldframe = Globals.cl.frame;
        }
        player_state_t ops = oldframe.playerstate;
        if (Math.abs(ops.pmove.origin[0] - ps.pmove.origin[0]) > 2048 || Math.abs(ops.pmove.origin[1] - ps.pmove.origin[1]) > 2048 || Math.abs(ops.pmove.origin[2] - ps.pmove.origin[2]) > 2048) {
            ops = ps;
        }
        float lerp = Globals.cl.lerpfrac;
        if (Globals.cl_predict.value != 0.0f && 0 == (Globals.cl.frame.playerstate.pmove.pm_flags & 0x40)) {
            float backlerp = 1.0f - lerp;
            for (i = 0; i < 3; ++i) {
                Globals.cl.refdef.vieworg[i] = Globals.cl.predicted_origin[i] + ops.viewoffset[i] + Globals.cl.lerpfrac * (ps.viewoffset[i] - ops.viewoffset[i]) - backlerp * Globals.cl.prediction_error[i];
                int n = i;
                Globals.cl.predicted_origin[n] = Globals.cl.predicted_origin[n] - backlerp * Globals.cl.prediction_error[i];
            }
            int delta = Globals.cls.realtime - Globals.cl.predicted_step_time;
            if (delta < 100) {
                Globals.cl.refdef.vieworg[2] = (float)((double)Globals.cl.refdef.vieworg[2] - (double)(Globals.cl.predicted_step * (float)(100 - delta)) * 0.01);
                Globals.cl.predicted_origin[2] = (float)((double)Globals.cl.predicted_origin[2] - (double)(Globals.cl.predicted_step * (float)(100 - delta)) * 0.01);
            }
        } else {
            for (i = 0; i < 3; ++i) {
                Globals.cl.refdef.vieworg[i] = (float)ops.pmove.origin[i] * 0.125f + ops.viewoffset[i] + lerp * ((float)ps.pmove.origin[i] * 0.125f + ps.viewoffset[i] - ((float)ops.pmove.origin[i] * 0.125f + ops.viewoffset[i]));
            }
        }
        if (Globals.cl.frame.playerstate.pmove.pm_type < 2) {
            for (i = 0; i < 3; ++i) {
                Globals.cl.refdef.viewangles[i] = Globals.cl.predicted_angles[i];
            }
        } else {
            for (i = 0; i < 3; ++i) {
                Globals.cl.refdef.viewangles[i] = Math3D.LerpAngle(ops.viewangles[i], ps.viewangles[i], lerp);
            }
        }
        for (i = 0; i < 3; ++i) {
            int n = i;
            Globals.cl.refdef.viewangles[n] = Globals.cl.refdef.viewangles[n] + Math3D.LerpAngle(ops.kick_angles[i], ps.kick_angles[i], lerp);
        }
        Math3D.AngleVectors(Globals.cl.refdef.viewangles, Globals.cl.v_forward, Globals.cl.v_right, Globals.cl.v_up);
        Globals.cl.refdef.fov_x = ops.fov + lerp * (ps.fov - ops.fov);
        for (i = 0; i < 4; ++i) {
            Globals.cl.refdef.blend[i] = ps.blend[i];
        }
        CL_ents.AddViewWeapon(ps, ops);
        if (Globals.cl_3rd.value != 0.0f) {
            float[] end = new float[]{0.0f, 0.0f, 0.0f};
            float[] oldorg = new float[]{0.0f, 0.0f, 0.0f};
            float[] camPos = new float[]{0.0f, 0.0f, 0.0f};
            if (Globals.cl_3rd_angle.value < 0.0f) {
                Cvar.SetValue("cl_3rd_angle", 0);
            }
            if (Globals.cl_3rd_angle.value > 60.0f) {
                Cvar.SetValue("cl_3rd_angle", 60);
            }
            if (Globals.cl_3rd_dist.value < 0.0f) {
                Cvar.SetValue("cl_3rd_dist", 0);
            }
            float angle = (float)(Math.PI * (double)Globals.cl_3rd_angle.value / 180.0);
            float dist_up = (float)((double)Globals.cl_3rd_dist.value * Math.sin(angle));
            float dist_back = (float)((double)Globals.cl_3rd_dist.value * Math.cos(angle));
            Math3D.VectorCopy(Globals.cl.refdef.vieworg, oldorg);
            Math3D.VectorMA(Globals.cl.refdef.vieworg, -dist_back, Globals.cl.v_forward, end);
            Math3D.VectorMA(end, dist_up, Globals.cl.v_up, end);
            CL_ents.ClipCam(Globals.cl.refdef.vieworg, end, camPos);
            float[] newDir = new float[]{0.0f, 0.0f, 0.0f};
            float[] dir = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorMA(Globals.cl.refdef.vieworg, 8000.0f, Globals.cl.v_forward, dir);
            CL_ents.ClipCam(Globals.cl.refdef.vieworg, dir, newDir);
            Math3D.VectorSubtract(newDir, camPos, dir);
            Math3D.VectorNormalize(dir);
            CL_ents.vectoangles2(dir, newDir);
            Math3D.AngleVectors(newDir, Globals.cl.v_forward, Globals.cl.v_right, Globals.cl.v_up);
            Math3D.VectorCopy(newDir, Globals.cl.refdef.viewangles);
            Math3D.VectorCopy(camPos, Globals.cl.refdef.vieworg);
        }
        for (i = 0; i < 3; ++i) {
            Globals.cl.mapdef.vieworg[i] = (float)((double)((float)ops.pmove.origin[i] * 0.125f + ops.viewoffset[i]) + (double)lerp * ((double)ps.pmove.origin[i] * 0.125 + (double)ps.viewoffset[i] - ((double)ops.pmove.origin[i] * 0.125 + (double)ops.viewoffset[i])));
        }
        for (i = 0; i < 3; ++i) {
            Globals.cl.mapdef.viewangles[i] = Math3D.LerpAngle(ops.viewangles[i], ps.viewangles[i], lerp);
        }
        for (i = 0; i < 3; ++i) {
            Globals.cl.mapdef.viewangles[i] = Globals.cl.predicted_angles[i];
        }
        Globals.cl.mapdef.fov_x = ops.fov + lerp * (ps.fov - ops.fov);
        for (i = 0; i < 3; ++i) {
            int n = i;
            Globals.cl.mapdef.viewangles[n] = Globals.cl.mapdef.viewangles[n] + Math3D.LerpAngle(ops.kick_angles[i], ps.kick_angles[i], lerp);
        }
        Math3D.AngleVectors(Globals.cl.mapdef.viewangles, Globals.cl.v_forward, Globals.cl.v_right, Globals.cl.v_up);
        Globals.cl.mapdef.blend[3] = 0.5f;
    }

    static void vectoangles2(float[] value1, float[] angles) {
        float pitch;
        float yaw;
        if (value1[1] == 0.0f && value1[0] == 0.0f) {
            yaw = 0.0f;
            pitch = value1[2] > 0.0f ? 90.0f : 270.0f;
        } else {
            float forward;
            yaw = value1[0] != 0.0f ? (float)(Math.atan2(value1[1], value1[0]) * 180.0 / Math.PI) : (value1[1] > 0.0f ? 90.0f : 270.0f);
            if (yaw < 0.0f) {
                yaw += 360.0f;
            }
            if ((pitch = (float)(Math.atan2(value1[2], forward = (float)Math.sqrt(value1[0] * value1[0] + value1[1] * value1[1])) * 180.0 / Math.PI)) < 0.0f) {
                pitch += 360.0f;
            }
        }
        angles[0] = -pitch;
        angles[1] = yaw;
        angles[2] = 0.0f;
    }

    static trace_t CL_Trace(float[] start, float[] end, float size, int contentmask) {
        float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
        float[] mins = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorSet(maxs, size, size, size);
        Math3D.VectorSet(mins, -size, -size, -size);
        return CM.BoxTrace(start, end, mins, maxs, 0, contentmask);
    }

    static void ClipCam(float[] start, float[] end, float[] newpos) {
        trace_t tr = CL_ents.CL_Trace(start, end, 5.0f, -1);
        Math3D.VectorCopy(tr.endpos, newpos);
    }

    static void AddEntities() {
        if (Globals.cls.state != 4) {
            return;
        }
        if (Globals.cl.time > Globals.cl.frame.servertime) {
            if (Globals.cl_showclamp.value != 0.0f) {
                Com.Printf("high clamp " + (Globals.cl.time - Globals.cl.frame.servertime) + "\n");
            }
            Globals.cl.time = Globals.cl.frame.servertime;
            Globals.cl.lerpfrac = 1.0f;
        } else if (Globals.cl.time < Globals.cl.frame.servertime - 100) {
            if (Globals.cl_showclamp.value != 0.0f) {
                Com.Printf("low clamp " + (Globals.cl.frame.servertime - 100 - Globals.cl.time) + "\n");
            }
            Globals.cl.time = Globals.cl.frame.servertime - 100;
            Globals.cl.lerpfrac = 0.0f;
        } else {
            Globals.cl.lerpfrac = 1.0f - (float)(Globals.cl.frame.servertime - Globals.cl.time) * 0.01f;
        }
        if (Globals.cl_timedemo.value != 0.0f) {
            Globals.cl.lerpfrac = 1.0f;
        }
        CL_ents.CalcViewValues();
        CL_ents.AddPacketEntities(Globals.cl.frame);
        CL_tent.AddTEnts();
        CL_fx.AddParticles();
        CL_fx.AddDLights();
        CL_fx.AddLightStyles();
    }

    public static void GetEntitySoundOrigin(int ent, float[] org) {
        if (ent < 0 || ent >= 1024) {
            Com.Error(1, "CL_GetEntitySoundOrigin: bad ent");
        }
        centity_t old = Globals.cl_entities[ent];
        Math3D.VectorCopy(old.lerp_origin, org);
    }
}

