/*
 * Decompiled with CFR 0.152.
 */
package jake2;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CompatibilityApplet
extends Applet {
    private Font font;
    private static final String inputText = "Click here to get the new Java Plug-In";
    private static final String url = "https://jdk6.dev.java.net/6uNea.html";

    public void init() {
        int fontSize = 36;
        try {
            fontSize = Integer.parseInt(this.getParameter("compat_fontsize"));
        }
        catch (Exception e) {
            // empty catch block
        }
        Color fgColor = Color.black;
        Color bgColor = Color.white;
        try {
            fgColor = Color.decode(this.getParameter("compat_fgcolor"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            bgColor = Color.decode(this.getParameter("compat_bgcolor"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.font = new Font("SansSerif", 0, fontSize);
        this.setForeground(fgColor);
        this.setBackground(bgColor);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    CompatibilityApplet.this.getAppletContext().showDocument(new URL(CompatibilityApplet.url), "_blank");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        ArrayList<LineInfo> lines = new ArrayList<LineInfo>();
        FontMetrics fm = g.getFontMetrics();
        FontRenderContext frc = g.getFontRenderContext();
        HashMap<TextAttribute, Font> attrs = new HashMap<TextAttribute, Font>();
        attrs.put(TextAttribute.FONT, this.font);
        float totalHeight = 0.0f;
        int curPos = 0;
        AttributedString str = new AttributedString(inputText, attrs);
        LineBreakMeasurer measurer = new LineBreakMeasurer(str.getIterator(), frc);
        while (measurer.getPosition() < inputText.length()) {
            int nextPos = measurer.nextOffset(this.getWidth() - 10);
            String line = inputText.substring(curPos, nextPos);
            GlyphVector gv = this.font.createGlyphVector(frc, line);
            Rectangle2D bounds = gv.getVisualBounds();
            float height = (float)bounds.getHeight() + 5.0f;
            lines.add(new LineInfo(line, (float)bounds.getWidth(), height));
            totalHeight += height;
            curPos = nextPos;
            measurer.setPosition(curPos);
        }
        g.setFont(this.font);
        float curY = ((float)this.getHeight() - totalHeight) / 2.0f;
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            LineInfo line = (LineInfo)iter.next();
            float x = ((float)this.getWidth() - line.width) / 2.0f;
            g.drawString(line.text, (int)x, (int)(curY += line.height));
        }
    }

    static class LineInfo {
        String text;
        float width;
        float height;

        LineInfo(String text, float width, float height) {
            this.text = text;
            this.width = width;
            this.height = height;
        }
    }
}

